
// TestSdkQSDlg.h : header file
//

#pragma once

#include "COCX.h"
#include "CPIPEOCX.h"

class CTestSdkQSDlgAutoProxy;


// CTestSdkQSDlg dialog
class CTestSdkQSDlg : public CDialogEx
{
	DECLARE_DYNAMIC(CTestSdkQSDlg);
	friend class CTestSdkQSDlgAutoProxy;

// Construction
public:
	CTestSdkQSDlg(CWnd* pParent = nullptr);	// standard constructor
	virtual ~CTestSdkQSDlg();

// Dialog Data
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_TESTSDKQS_DIALOG };
#endif

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support


// Implementation
protected:
	CTestSdkQSDlgAutoProxy* m_pAutoProxy;
	HICON m_hIcon;

	/////////////////////////////////////////////////////////////////////////////////
    // SA MP SDK Section

	CSpatialAnalyzerSDK m_NRKSdkQS;

	BOOL m_SDKConnected;

	enum MPStatus
	{
		SdkError = -1,
		Undone = 0,
		InProgress = 1,
		DoneSuccess = 2,
		DoneFatalError = 3,
		DoneMinorError = 4,
		CurrentTask = 5
	};
    
    BOOL CanExit();

	// Generated message map functions
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnClose();
	virtual void OnOK();
	virtual void OnCancel();
	DECLARE_MESSAGE_MAP()

	void TestFitProfile();
	void RandomCloudPointsTest();
	void RandomPointsTest();
	void FrameTest();
	void TrackingTest();

	afx_msg void OnBnClickedConnect();
	afx_msg void OnBnClickedDisconnect();  
	afx_msg void OnBnClickedTest();
	afx_msg void OnBnClickedButton8();
	afx_msg void OnBnClickedButton9();
	afx_msg void OnBnClickedButton10();    
	afx_msg void OnBnClickedButton11();          
	afx_msg void OnBnClickedButton13();       
	afx_msg void OnBnClickedButton14();
	afx_msg void OnBnClickedButton16();
	afx_msg void OnBnClickedButton17();
	afx_msg void OnBnClickedButton18();
	afx_msg void OnBnClickedButton19();
	afx_msg void OnBnClickedButton20();

	/////////////////////////////////////////////////////////////////////////////////
	// SA Pipeline Section

	CPipelineSDK m_pipelineSDK;

	DECLARE_EVENTSINK_MAP()

	void Pipeline_OnConnectToHardware(LPCTSTR connectData);
	void Pipeline_OnActivateWatchUpdating();
	void Pipeline_OnUnitsChange(long lengthUnits, long temperatureUnits);
	void Pipeline_OnOpCheck(LPCTSTR command);
	void Pipeline_OnSetColGroupTarget(LPCTSTR collectionName, LPCTSTR groupName, LPCTSTR targetName);
	void Pipeline_OnSAIPRequestPoints(LPCTSTR jsonPointObjects);
	void Pipeline_OnSAIPCreateDynamicReference(LPCTSTR dynRefName, LPCTSTR jsonPointObjects);
	void Pipeline_OnSAIPAutoMeasProximity(BOOL bProcessDone);
	void Pipeline_OnSAIPMeasGroup(LPCTSTR jsonPointObjects);
	void Pipeline_OnInstToWorkingTransformChanged(LPCTSTR workingFrameName, LPCTSTR jsonTransform, double instrumentScaleFactor);

	typedef enum
	{
		LU_INVALID = 0,
		LU_METERS,
		LU_CENTIMETERS,
		LU_MILLIMETERS,
		LU_FEET,
		LU_INCHES
	} LengthUnitsType;

	LengthUnitsType m_displayLengthUnits;

	CString m_collection;
	CString m_group;
	CString m_target;
	double m_probeRadius;

	CString m_frameCollection;
	CString m_frameName;

	afx_msg void OnBnClickedRandomMeasPoint();
	afx_msg void OnBnClickedRandomMeasPoints();
	afx_msg void OnBnClickedRandomCloud();
	
	afx_msg void OnBnClickedRandomFrame();
	afx_msg void OnBnClickedCameraUpdate();
	afx_msg void OnBnClickedTracking();
};
