
// TestSdkQSDlg.cpp : implementation file
//

#include "pch.h"
#include "framework.h"
#include "TestSdkQS.h"
#include "TestSdkQSDlg.h"
#include "DlgProxy.h"
#include "afxdialogex.h"
#include "SDKHelper.h"
#include <set>

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

// CAboutDlg dialog used for App About

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

// Dialog Data
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_ABOUTBOX };
#endif

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialogEx(IDD_ABOUTBOX)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
    
END_MESSAGE_MAP()


// CTestSdkQSDlg dialog

const unsigned short VALID_UNCERT_PARAM = 0x01;
const unsigned short VALID_PROBEDIR_PARAM = 0x02;


IMPLEMENT_DYNAMIC(CTestSdkQSDlg, CDialogEx);

CTestSdkQSDlg::CTestSdkQSDlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_TESTSDKQS_DIALOG, pParent)
    , m_collection(_T(""))
    , m_group(_T(""))
    , m_target(_T(""))
    , m_probeRadius(0)
    , m_frameCollection(_T(""))
    , m_frameName(_T(""))
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_pAutoProxy = nullptr;
}

CTestSdkQSDlg::~CTestSdkQSDlg()
{
	// If there is an automation proxy for this dialog, set
	//  its back pointer to this dialog to null, so it knows
	//  the dialog has been deleted.
	if (m_pAutoProxy != nullptr)
		m_pAutoProxy->m_pDialog = nullptr;
}

void CTestSdkQSDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialogEx::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_SAMPSDKCTRL1, m_NRKSdkQS);
    DDX_Control(pDX, IDC_SAINSTPIPELINECTRL1, m_pipelineSDK);
    DDX_Text(pDX, IDC_COLLECTION_EDIT, m_collection);
    DDX_Text(pDX, IDC_GROUP_EDIT, m_group);
    DDX_Text(pDX, IDC_TARGET_EDIT, m_target);
    DDX_Text(pDX, IDC_PROBERADIUS_EDIT, m_probeRadius);
    DDX_Text(pDX, IDC_FRAME_COLLECTION_EDIT, m_frameCollection);
    DDX_Text(pDX, IDC_FRAME_NAME_EDIT, m_frameName);
}

BEGIN_EVENTSINK_MAP(CTestSdkQSDlg, CDialogEx)
    // Event handler invoked once connected to Spatial Analyzer
    ON_EVENT(CTestSdkQSDlg, IDC_SAINSTPIPELINECTRL1, 0x64, CTestSdkQSDlg::Pipeline_OnConnectToHardware, VTS_BSTR)
    // Event handler invoked to notify instrument to begin live updates
    ON_EVENT(CTestSdkQSDlg, IDC_SAINSTPIPELINECTRL1, 0x6c, CTestSdkQSDlg::Pipeline_OnActivateWatchUpdating, VTS_NONE)
    // Event handler invoked when the length/temp units within Spatial Analyzer have changed
    ON_EVENT(CTestSdkQSDlg, IDC_SAINSTPIPELINECTRL1, 0x6b, CTestSdkQSDlg::Pipeline_OnUnitsChange, VTS_I4 VTS_I4)
    // Event handler invoked via MP Instrument OpCheck.
    ON_EVENT(CTestSdkQSDlg, IDC_SAINSTPIPELINECTRL1, 0x66, CTestSdkQSDlg::Pipeline_OnOpCheck, VTS_BSTR)
    // Event handler invoked via MP when the collection / group / target names have changed.
    ON_EVENT(CTestSdkQSDlg, IDC_SAINSTPIPELINECTRL1, 0x65, CTestSdkQSDlg::Pipeline_OnSetColGroupTarget, VTS_BSTR VTS_BSTR VTS_BSTR)
    // Dynamic Reference Event Handlers
    ON_EVENT(CTestSdkQSDlg, IDC_SAINSTPIPELINECTRL1, 0x67, CTestSdkQSDlg::Pipeline_OnSAIPRequestPoints, VTS_BSTR)
    ON_EVENT(CTestSdkQSDlg, IDC_SAINSTPIPELINECTRL1, 0x68, CTestSdkQSDlg::Pipeline_OnSAIPCreateDynamicReference, VTS_BSTR VTS_BSTR)
    // Auto Proximity Event Handler
    ON_EVENT(CTestSdkQSDlg, IDC_SAINSTPIPELINECTRL1, 0x6a, CTestSdkQSDlg::Pipeline_OnSAIPAutoMeasProximity, VTS_BOOL)
    // Guided Measure Event Handler
    ON_EVENT(CTestSdkQSDlg, IDC_SAINSTPIPELINECTRL1, 0x69, CTestSdkQSDlg::Pipeline_OnSAIPMeasGroup, VTS_BSTR)
    // Transform Updates
    ON_EVENT(CTestSdkQSDlg, IDC_SAINSTPIPELINECTRL1, 0x6d, CTestSdkQSDlg::Pipeline_OnInstToWorkingTransformChanged, VTS_BSTR VTS_BSTR VTS_R8)
END_EVENTSINK_MAP()


BEGIN_MESSAGE_MAP(CTestSdkQSDlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_CLOSE()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()

	ON_BN_CLICKED(IDC_BUTTON1, &CTestSdkQSDlg::OnBnClickedConnect)
	ON_BN_CLICKED(IDC_BUTTON2, &CTestSdkQSDlg::OnBnClickedTest)
	ON_BN_CLICKED(IDC_BUTTON8, &CTestSdkQSDlg::OnBnClickedButton8)
	ON_BN_CLICKED(IDC_BUTTON9, &CTestSdkQSDlg::OnBnClickedButton9)
	ON_BN_CLICKED(IDC_BUTTON10, &CTestSdkQSDlg::OnBnClickedButton10) 
	ON_BN_CLICKED(IDC_BUTTON13, &CTestSdkQSDlg::OnBnClickedButton13) 
	ON_BN_CLICKED(IDC_BUTTON14, &CTestSdkQSDlg::OnBnClickedButton14)  
	ON_BN_CLICKED(IDC_BUTTON15, &CTestSdkQSDlg::OnBnClickedDisconnect)
	ON_BN_CLICKED(IDC_BUTTON16, &CTestSdkQSDlg::OnBnClickedButton16)  
	ON_BN_CLICKED(IDC_BUTTON17, &CTestSdkQSDlg::OnBnClickedButton17)  
	ON_BN_CLICKED(IDC_BUTTON19, &CTestSdkQSDlg::OnBnClickedButton19)
	ON_BN_CLICKED(IDC_BUTTON20, &CTestSdkQSDlg::OnBnClickedButton20)

    ON_BN_CLICKED(IDC_RANDOMPOINT_BUTTON, &CTestSdkQSDlg::OnBnClickedRandomMeasPoint)
    ON_BN_CLICKED(IDC_RANDOMPOINTS_BUTTON, &CTestSdkQSDlg::OnBnClickedRandomMeasPoints)
    ON_BN_CLICKED(IDC_RANDOMCLOUD_BUTTON, &CTestSdkQSDlg::OnBnClickedRandomCloud)
    ON_BN_CLICKED(IDC_RANDOMFRAME_BUTTON, &CTestSdkQSDlg::OnBnClickedRandomFrame)
    ON_BN_CLICKED(IDC_CAMERAUPDATE_BUTTON, &CTestSdkQSDlg::OnBnClickedCameraUpdate)
    ON_BN_CLICKED(IDC_TRACKING_BUTTON, &CTestSdkQSDlg::OnBnClickedTracking)
END_MESSAGE_MAP()


// CTestSdkQSDlg message handlers

BOOL CTestSdkQSDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != nullptr)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	m_SDKConnected = FALSE;

    // Seed the random-number generator with the current time so that
    // the numbers will be different every time we run.
    srand((unsigned)time(NULL));

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CTestSdkQSDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CTestSdkQSDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CTestSdkQSDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

// Automation servers should not exit when a user closes the UI
//  if a controller still holds on to one of its objects.  These
//  message handlers make sure that if the proxy is still in use,
//  then the UI is hidden but the dialog remains around if it
//  is dismissed.

void CTestSdkQSDlg::OnClose()
{
	if (CanExit())
		CDialogEx::OnClose();
}

void CTestSdkQSDlg::OnOK()
{
	if (CanExit())
		CDialogEx::OnOK();
}

void CTestSdkQSDlg::OnCancel()
{
	if (CanExit())
		CDialogEx::OnCancel();
}

BOOL CTestSdkQSDlg::CanExit()
{
	// If the proxy object is still around, then the automation
	//  controller is still holding on to this application.  Leave
	//  the dialog around, but hide its UI.
	if (m_pAutoProxy != nullptr)
	{
		ShowWindow(SW_HIDE);
		return FALSE;
	}

	return TRUE;
}

void CTestSdkQSDlg::OnBnClickedConnect()
{
    if (!m_SDKConnected)
    {
        m_pipelineSDK.AboutBox();
        m_pipelineSDK.PopLogonDialog();

        m_NRKSdkQS.AboutBox();

        // NOTE: Default is to use the new QS interface to SA unless turned off...
        // QS mode is connects with SpatialAnalyzer as necessary vs maintaining 
        //  a constant connection.
        m_NRKSdkQS.SetSocketMode(FALSE);

        m_SDKConnected = m_NRKSdkQS.Connect(_T("localhost")); 
    }
}

//*************************************************************
// olga XIT-849 - release SA SDK OLE dispatch
//*************************************************************
void CTestSdkQSDlg::OnBnClickedDisconnect() // olga XIT-849
{
    if (!m_SDKConnected)
        return;

    m_SDKConnected = FALSE;

    // If there is an automation proxy for this dialog, set
    //  its back pointer to this dialog to NULL, so it knows
    //  the dialog has been deleted.
    if (m_pAutoProxy != NULL)
        m_pAutoProxy->m_pDialog = NULL;
}

void CTestSdkQSDlg::OnBnClickedTest()
{
    if (!m_SDKConnected)
        return;

    // *******************************************************************************************************
    // Reporting Operations >> Notify User String
    // *******************************************************************************************************
    m_NRKSdkQS.SetStep(_T("Notify User String"));
    m_NRKSdkQS.SetStringArg(_T("Notification Text"), _T("Spatial Analyzer SDK Sample.  Engineered for Extreme Measures."));
    m_NRKSdkQS.SetFontTypeArg(_T("Font"), _T("Arial"), 24, 255, 0, 0);
    m_NRKSdkQS.ExecuteStep();
    // *******************************************************************************************************

    m_NRKSdkQS.SetStep(_T("Set View Idle Update Frequency"));
    m_NRKSdkQS.SetIntegerArg(_T("Idle Count"), 10000);
    m_NRKSdkQS.ExecuteStep();

    DWORD TimeStart, TimeStop;
    int nbIteration = 20;
    int granularity = 5;
    CString errorMessage;
    CString pointCollectionName, pointGroupName, pointName;
    TimeStart = ::GetTickCount();
    bool bAbort = false;
    for (int col = 0; !bAbort && col < nbIteration; ++col)
    {
        pointCollectionName.Format(_T("collection%d"), col);
        for (int group = 0; !bAbort && group < nbIteration; ++group)
        {
            pointGroupName.Format(_T("group%d"), group);
            for (int i = 0; !bAbort && i < nbIteration; ++i)
            {
                pointName.Format(_T("point%d"), i);
                double x = col;
                double y = group;
                double z = i;
                m_NRKSdkQS.SetStep(_T("Construct a Point in Working Coordinates"));
                m_NRKSdkQS.SetPointNameArg(_T("Point Name"), pointCollectionName, pointGroupName, pointName);
                m_NRKSdkQS.SetVectorArg(_T("Working Coordinates"), x, y, z);

                DWORD _TimeStart = ::GetTickCount();
                BOOL bSendStatus = m_NRKSdkQS.ExecuteStep();
                DWORD _TimeStop = ::GetTickCount();
                //DWORD _Duration = _TimeStop - _TimeStart;
                //TRACE1("Construct Point Duration (MS): %d\n", _Duration);
                if (bSendStatus)
                {
                    LONG rCode;
                    m_NRKSdkQS.GetMPStepResult(&rCode);
                    if (rCode == SdkError)
                    {
                        CStringArray msgs;
                        // Something went wrong... check for any messages provided...
                        SDKHelper	helper(m_NRKSdkQS);
                        if (helper.GetMPStepMessagesHelper(msgs))
                        {
                            CString singleLine;
                            for (int i = 0; i < msgs.GetSize(); i++)
                            {
                                singleLine += msgs[i];
                                singleLine += _T("\r\n");
                            }
                            AfxMessageBox(singleLine);
                        }
                    }
                }
                else
                {
                    CString msg;
                    msg.Format(_T("Failed to send: Construct a Point in Working Coordinates %s::%s::%s\nContinue?"), pointCollectionName, pointGroupName, pointName);
                    if (AfxMessageBox(msg, MB_OKCANCEL | MB_ICONQUESTION) == IDCANCEL)
                    {
                        bAbort = true;
                    }
                }
            }
        }
    }
    TimeStop = ::GetTickCount();
    DWORD Duration = TimeStop - TimeStart;
    if (!bAbort)
    {
        CString msg;
        msg.Format(_T("Construct %d Points Duration (MS): %d"), nbIteration * nbIteration * nbIteration, Duration);
        //TRACE1("Construct Point ALL Duration (MS): %d\n", Duration);
        AfxMessageBox(msg);
        MessageBeep(-1);
    }
    else
    {
        return;
    }

    m_NRKSdkQS.SetStep(_T("Set View Idle Update Frequency"));
    m_NRKSdkQS.SetIntegerArg(_T("Idle Count"), 1000);
    m_NRKSdkQS.ExecuteStep();

    // *******************************************************************************************************
    // Construction Operations >> Points and Groups >> Construct a Point in Working Coordinates 
    // *******************************************************************************************************
    m_NRKSdkQS.SetStep(_T("Construct a Point in Working Coordinates"));
    m_NRKSdkQS.SetVectorArg(_T("Working Coordinates"), 10.1234, 20.2345, 30.5678);
    m_NRKSdkQS.SetPointNameArg(_T("Point Name"), _T(""), _T("TestGrp"), _T("TestPt"));
    BOOL bSendStatus = m_NRKSdkQS.ExecuteStep();
    // *******************************************************************************************************

    // *******************************************************************************************************
    // Process Flow Operations >> Ask for String
    // NOTE: Example illustrates attempting to execute a MP Step with an invalid argument
    // *******************************************************************************************************
    m_NRKSdkQS.SetStep(_T("Ask for String"));
    m_NRKSdkQS.SetStringArg(_T("Question to ask"), _T("Enter Sphere Name"));
    // NOTE: Should be "Initial Answer"... mistake added for error checking!
    m_NRKSdkQS.SetStringArg(_T("Initial Value"), _T("MySphere"));
    bSendStatus = m_NRKSdkQS.ExecuteStep();

    if (bSendStatus)
    {
        LONG rCode;
        m_NRKSdkQS.GetMPStepResult(&rCode);
        if (rCode == SdkError)
        {
            CStringArray msgs;
            // Something went wrong... check for any messages provided...
            SDKHelper	helper(m_NRKSdkQS);
            if (helper.GetMPStepMessagesHelper(msgs))
            {
                CString singleLine;
                for (int i = 0; i < msgs.GetSize(); i++)
                {
                    singleLine += msgs[i];
                    singleLine += _T("\r\n");
                }
                AfxMessageBox(singleLine);
            }
        }
    }
    // *******************************************************************************************************

    // *******************************************************************************************************
    // Process Flow Operations >> Ask for String
    // NOTE: This attempt has the proper parameters
    // *******************************************************************************************************
    m_NRKSdkQS.SetStep(_T("Ask for String"));
    m_NRKSdkQS.SetStringArg(_T("Question to ask"), _T("Enter Sphere Name"));
    m_NRKSdkQS.SetStringArg(_T("Initial Answer"), _T("MySphere"));
    bSendStatus = m_NRKSdkQS.ExecuteStep();

    if (bSendStatus)
    {
        LONG rCode;
        m_NRKSdkQS.GetMPStepResult(&rCode);
        if (rCode != DoneSuccess)
        {
            return;
        }
    }

    // Now get the answer
    CString sphereName;
    CComBSTR name;
    if (bSendStatus && m_NRKSdkQS.GetStringArg(_T("Answer"), &name))
    {
        sphereName = name;
        CString msg;
        msg.Format(_T("Sphere Name Entered: %s"), sphereName);
        AfxMessageBox(msg);
    }
    // Must release the BSTR returned.
    name.Empty();
    // *******************************************************************************************************

    // *******************************************************************************************************
    // Process Flow Operations >> Ask for Double
    // *******************************************************************************************************
    m_NRKSdkQS.SetStep(_T("Ask for Double"));
    m_NRKSdkQS.SetStringArg(_T("Question to ask"), _T("Enter Sphere Radius"));
    m_NRKSdkQS.SetDoubleArg(_T("Initial Value"), 11.5);
    bSendStatus = m_NRKSdkQS.ExecuteStep();

    DOUBLE radius;
    if (bSendStatus && m_NRKSdkQS.GetDoubleArg(_T("Answer"), &radius))
    {
        CString msg;
        msg.Format(_T("Radius Value Entered: %f"), radius);
        AfxMessageBox(msg);
    }
    // *******************************************************************************************************

    // *******************************************************************************************************
    // Construction Operations >> Spheres >> Construct Sphere
    // *******************************************************************************************************
    m_NRKSdkQS.SetStep(_T("Construct Sphere"));
    m_NRKSdkQS.SetObjectNameArg(_T("Sphere Name"), sphereName);
    m_NRKSdkQS.SetVectorArg(_T("Sphere Center (in working coordinates)"), 6.0, 12.0, 18.0);
    m_NRKSdkQS.SetDoubleArg(_T("Sphere Radius"), radius);
    bSendStatus = m_NRKSdkQS.ExecuteStep();
    // *******************************************************************************************************

    // *******************************************************************************************************
    // Construction Operations >> Points and Groups >> Construct Point at Object Origin
    // *******************************************************************************************************
    m_NRKSdkQS.SetStep(_T("Construct Point at Object Origin"));
    m_NRKSdkQS.SetCollectionObjectNameArg(_T("Object Name"), _T(""), sphereName);
    m_NRKSdkQS.SetPointNameArg(_T("Resultant Point Name"), _T(""), _T("TestGrp"), _T("ObjOrgPt"));
    bSendStatus = m_NRKSdkQS.ExecuteStep();

    // This section illustrates getting return values from the successfully sent MP Step
    if (bSendStatus)
    {
        LONG rCode;
        m_NRKSdkQS.GetMPStepResult(&rCode);
        if (rCode == DoneSuccess)
        {
            // The command executed successfully, now get the return values and display to user
            DOUBLE val;
            if (bSendStatus && m_NRKSdkQS.GetDoubleArg(_T("X Value"), &val))
            {
                CString msg;
                msg.Format(_T("X Value: %f"), val);
                AfxMessageBox(msg);
            }

            if (bSendStatus && m_NRKSdkQS.GetDoubleArg(_T("Y Value"), &val))
            {
                CString msg;
                msg.Format(_T("Y Value: %f"), val);
                AfxMessageBox(msg);
            }

            if (bSendStatus && m_NRKSdkQS.GetDoubleArg(_T("Z Value"), &val))
            {
                CString msg;
                msg.Format(_T("Z Value: %f"), val);
                AfxMessageBox(msg);
            }

            DOUBLE xVal, yVal, zVal;
            if (bSendStatus && m_NRKSdkQS.GetVectorArg(_T("Vector Representation"), &xVal, &yVal, &zVal))
            {
                CString msg;
                msg.Format(_T("Vector Value: %f %f %f"), xVal, yVal, zVal);
                AfxMessageBox(msg);
            }
        }
    }
    // *******************************************************************************************************

    // *******************************************************************************************************
    // Construction Operations >> Other MP Types >> Make a Transform from Doubles (Fixed XYZ)
    // *******************************************************************************************************
    m_NRKSdkQS.SetStep(_T("Make a Transform from Doubles (Fixed XYZ)"));
    m_NRKSdkQS.SetDoubleArg(_T("X"), 10.0);
    m_NRKSdkQS.SetDoubleArg(_T("Y"), 30.0);
    m_NRKSdkQS.SetDoubleArg(_T("Z"), 50.0);
    m_NRKSdkQS.SetDoubleArg(_T("Rx (Roll)"), 40.0);
    m_NRKSdkQS.SetDoubleArg(_T("Ry (Pitch)"), -30.0);
    m_NRKSdkQS.SetDoubleArg(_T("Rz (Yaw)"), -60.0);
    bSendStatus = m_NRKSdkQS.ExecuteStep();

    if (bSendStatus)
    {
        SDKHelper helper(m_NRKSdkQS);

        double T[4][4];
        if (helper.GetTransformArgHelper(_T("Resultant Transform"), T))
        {
            // *******************************************************************************************************
            // Construction Operations >> Frames >> Construct Frame
            // *******************************************************************************************************
            m_NRKSdkQS.SetStep(_T("Construct Frame"));
            m_NRKSdkQS.SetCollectionObjectNameArg(_T("New Frame Name"), _T(""), _T("Test Frame"));
            // Use the helper object to make life easier when setting a transform argument
            helper.SetTransformArgHelper(_T("Transform in Working Coordinates"), T);
            bSendStatus = m_NRKSdkQS.ExecuteStep();
            // *******************************************************************************************************
        }
    }
    // *******************************************************************************************************

    // *******************************************************************************************************
    // Construction Operations >> Other MP Types >> Get Working Transform of Object (Fixed XYZ)
    // *******************************************************************************************************
    m_NRKSdkQS.SetStep(_T("Get Working Transform of Object (Fixed XYZ)"));
    m_NRKSdkQS.SetCollectionObjectNameArg(_T("Object Name"), _T(""), sphereName);
    bSendStatus = m_NRKSdkQS.ExecuteStep();

    if (bSendStatus)
    {
        LONG rCode;
        m_NRKSdkQS.GetMPStepResult(&rCode);
        if (rCode == DoneSuccess)
        {
            SDKHelper helper(m_NRKSdkQS);
            double T[4][4];
            if (helper.GetTransformArgHelper(_T("Transform"), T))
            {
                helper.DebugMatrix(T);
            }
        }
    }
    // *******************************************************************************************************

    // *******************************************************************************************************
    // Instrument Operations >> Add New Instrument
    // *******************************************************************************************************
    m_NRKSdkQS.SetStep(_T("Add New Instrument"));
    m_NRKSdkQS.SetInstTypeNameArg(_T("Instrument Type"), _T("API Tracker III"));
    bSendStatus = m_NRKSdkQS.ExecuteStep();

    if (bSendStatus)
    {
        LONG rCode;
        m_NRKSdkQS.GetMPStepResult(&rCode);
        if (rCode == DoneSuccess)
        {
            long instId;
            m_NRKSdkQS.GetInstIdArg(_T("Instrument Added (result)"), &instId);
        }
    }
    // *******************************************************************************************************

    // *******************************************************************************************************
    // Instrument Operations >> Get Instrument Transform
    // *******************************************************************************************************
    m_NRKSdkQS.SetStep(_T("Get Instrument Transform"));
    m_NRKSdkQS.SetColInstIdArg(_T("Instrument ID"), _T(""), 0);
    m_NRKSdkQS.SetCollectionObjectNameArg(_T("Reference Frame"), _T(""), _T("WORLD"));
    bSendStatus = m_NRKSdkQS.ExecuteStep();

    if (bSendStatus)
    {
        LONG rCode;
        m_NRKSdkQS.GetMPStepResult(&rCode);
        if (rCode == DoneSuccess)
        {
            SDKHelper helper(m_NRKSdkQS);
            double T[4][4];
            if (helper.GetTransformArgHelper(_T("Transform"), T))
            {
                helper.DebugMatrix(T);
            }
        }
    }
    // *******************************************************************************************************

    // *******************************************************************************************************
    // Instrument Operations >> Get Last Instrument Index
    // *******************************************************************************************************
    m_NRKSdkQS.SetStep(_T("Get Last Instrument Index"));
    bSendStatus = m_NRKSdkQS.ExecuteStep();

    if (bSendStatus)
    {
        LONG rCode;
        m_NRKSdkQS.GetMPStepResult(&rCode);
        if (rCode == DoneSuccess)
        {
            long instId;
            if (m_NRKSdkQS.GetInstIdArg(_T("Instrument ID"), &instId))
            {

            }
            CComBSTR colName;
            if (m_NRKSdkQS.GetColInstIdArg(_T("Instrument ID"), &colName, &instId))
            {

            }
            colName.Empty();
        }
    }
    // *******************************************************************************************************

    // *******************************************************************************************************
    // View Control >> Hide Objects
    // *******************************************************************************************************
    CStringArray objNameList;
    CString item;
    item.Format(_T("%s::%s"), _T("A"), _T("Test Frame"));
    objNameList.Add(item);
    item.Format(_T("%s::%s"), _T("A"), sphereName);
    objNameList.Add(item);

    m_NRKSdkQS.SetStep(_T("Hide Objects"));
    {
        SDKHelper helper(m_NRKSdkQS);
        helper.SetCollectionObjectNameRefListArgHelper(_T("Objects To Hide"), objNameList);
    }
    bSendStatus = m_NRKSdkQS.ExecuteStep();
    // *******************************************************************************************************

    // *******************************************************************************************************
    // Construction Operations >> Other MP Types >> Make a Collection Object Name Reference List- Runtime Select
    // *******************************************************************************************************
    m_NRKSdkQS.SetStep(_T("Make a Collection Object Name Reference List- Runtime Select"));
    m_NRKSdkQS.SetStringArg(_T("User Prompt"), _T("Select Some Objects"));
    bSendStatus = m_NRKSdkQS.ExecuteStep();

    if (bSendStatus)
    {
        LONG rCode;
        m_NRKSdkQS.GetMPStepResult(&rCode);
        if (rCode == DoneSuccess)
        {
            SDKHelper helper(m_NRKSdkQS);
            CStringArray objNames;
            // Get and display the selected objects to the user
            if (helper.GetCollectionObjectNameRefListArgHelper(_T("Resultant Collection Object Name Reference List"), objNames))
            {
                for (INT_PTR row = 0; row < objNames.GetSize(); row++)
                {
                    TRACE1("%s\n", objNames[row]);
                }
                TRACE("\n");
            }
        }
    }
    // *******************************************************************************************************

    // *******************************************************************************************************
    // Construction Operations >> Other MP Types >> Make a Point Name Ref List - Runtime Select
    // *******************************************************************************************************
    m_NRKSdkQS.SetStep(_T("Make a Point Name Ref List - Runtime Select"));
    m_NRKSdkQS.SetStringArg(_T("User Prompt"), _T("Select Some Points"));
    bSendStatus = m_NRKSdkQS.ExecuteStep();

    if (bSendStatus)
    {
        LONG rCode;
        m_NRKSdkQS.GetMPStepResult(&rCode);
        if (rCode == DoneSuccess)
        {
            SDKHelper helper(m_NRKSdkQS);
            CStringArray ptNames;
            // Get and display the selected objects to the user
            if (helper.GetPointNameRefListArgHelper(_T("Resultant Point Name List"), ptNames))
            {
                for (INT_PTR row = 0; row < ptNames.GetSize(); row++)
                {
                    TRACE1("%s\n", ptNames[row]);
                }
                TRACE("\n");
            }
        }
    }
    // *******************************************************************************************************

    // *******************************************************************************************************
    // Construction Operations >> Other MP Types >> Append two Point Name Ref Lists
    // *******************************************************************************************************
    m_NRKSdkQS.SetStep(_T("Append two Point Name Ref Lists"));
    CStringArray ptNameListA;
    ptNameListA.Add(_T("A::Random::r2"));
    ptNameListA.Add(_T("A::Random::r4"));
    ptNameListA.Add(_T("A::Random::r6"));
    ptNameListA.Add(_T("A::Random::r8"));
    ptNameListA.Add(_T("A::Random::r10"));
    SDKHelper ptArrayHelper(m_NRKSdkQS);
    ptArrayHelper.SetPointNameRefListArgHelper(_T("Point Name List A"), ptNameListA);
    CStringArray ptNameListB;
    ptNameListB.Add(_T("A::Random1::r1"));
    ptNameListB.Add(_T("A::Random1::r3"));
    ptNameListB.Add(_T("A::Random1::r5"));
    ptNameListB.Add(_T("A::Random1::r7"));
    ptNameListB.Add(_T("A::Random1::r9"));
    ptNameListB.Add(_T("A::Random1::r11"));
    ptArrayHelper.SetPointNameRefListArgHelper(_T("Point Name List B"), ptNameListB);
    bSendStatus = m_NRKSdkQS.ExecuteStep();

    if (bSendStatus)
    {
        LONG rCode;
        m_NRKSdkQS.GetMPStepResult(&rCode);
        if (rCode == DoneSuccess)
        {
            SDKHelper helper(m_NRKSdkQS);
            CStringArray resultingNameList;
            // Get and display the selected objects to the user
            if (helper.GetPointNameRefListArgHelper(_T("Resultant Point Name List(A+B)"), resultingNameList))
            {
                for (INT_PTR row = 0; row < resultingNameList.GetSize(); row++)
                {
                    TRACE1("%s\n", resultingNameList[row]);
                }
                TRACE("\n");
            }
        }
    }
    // *******************************************************************************************************

    // *******************************************************************************************************
    // Analysis Operations >> Best Fit Transformation - Group to Group (Scale Free)
    // *******************************************************************************************************
    m_NRKSdkQS.SetStep(_T("Best Fit Transformation - Group to Group (Scale Free)"));
    m_NRKSdkQS.SetCollectionObjectNameArg(_T("Reference Group"), _T(""), _T("Random"));
    m_NRKSdkQS.SetCollectionObjectNameArg(_T("Corresponding Group"), _T(""), _T("Random1"));
    m_NRKSdkQS.SetDoubleArg(_T("Show Interface"), TRUE);
    bSendStatus = m_NRKSdkQS.ExecuteStep();

    if (bSendStatus)
    {
        LONG rCode;
        m_NRKSdkQS.GetMPStepResult(&rCode);
        if (rCode == DoneSuccess)
        {
            SDKHelper helper(m_NRKSdkQS);
            double T[4][4];
            if (helper.GetTransformArgHelper(_T("Transform in Working"), T))
            {
                helper.DebugMatrix(T);
            }
            TRACE("\n");
            double scale;
            if (helper.GetWorldTransformArgHelper(_T("Optimum Transform"), T, scale))
            {
                helper.DebugMatrix(T);
            }
            TRACE(_T("Scale: %.*f\n"), 4, scale);
        }
    }
    // *******************************************************************************************************
}

void CTestSdkQSDlg::OnBnClickedButton8()
{
    if (!m_SDKConnected)
        return;

    m_NRKSdkQS.SetStep(_T("Construct Frame"));
    m_NRKSdkQS.SetCollectionObjectNameArg(_T("New Frame Name"), _T(""), _T("Frame 1"));
    double T[4][4];
    T[0][0] = 0.813798; 	T[0][1] = -0.440970; 	T[0][2] = 0.378522; 	T[0][3] = 5.000000;
    T[1][0] = 0.469846; 	T[1][1] = 0.882564; 	T[1][2] = 0.018028; 	T[1][3] = 5.000000;
    T[2][0] = -0.342020; 	T[2][1] = 0.163176; 	T[2][2] = 0.925417; 	T[2][3] = 5.000000;
    T[3][0] = 0.000000; 	T[3][1] = 0.000000; 	T[3][2] = 0.000000; 	T[3][3] = 1.000000;

    SDKHelper helper(m_NRKSdkQS);
    helper.SetTransformArgHelper(_T("Transform in Working Coordinates"), T);
    m_NRKSdkQS.ExecuteStep();

    m_NRKSdkQS.SetStep(_T("Construct Frame"));
    m_NRKSdkQS.SetCollectionObjectNameArg(_T("New Frame Name"), _T(""), _T("Frame 2"));

    T[0][0] = 0.800235; 	T[0][1] = -0.446962; 	T[0][2] = 0.399811; 	T[0][3] = 10.000000;
    T[1][0] = 0.480829; 	T[1][1] = 0.876637; 	T[1][2] = 0.017627; 	T[1][3] = 10.000000;
    T[2][0] = -0.358368; 	T[2][1] = 0.178136; 	T[2][2] = 0.916428; 	T[2][3] = 10.000000;
    T[3][0] = 0.000000; 	T[3][1] = 0.000000; 	T[3][2] = 0.000000; 	T[3][3] = 1.000000;

    helper.SetTransformArgHelper(_T("Transform in Working Coordinates"), T);
    m_NRKSdkQS.ExecuteStep();

    m_NRKSdkQS.SetStep(_T("Make Scalar Tolerance"));
    m_NRKSdkQS.SetBoolArg(_T("Use High Tolerance"), TRUE);
    m_NRKSdkQS.SetDoubleArg(_T("High Tolerance"), 0.500000);
    m_NRKSdkQS.SetBoolArg(_T("Use Low Tolerance"), FALSE);
    m_NRKSdkQS.SetDoubleArg(_T("Low Tolerance"), 0.000000);
    m_NRKSdkQS.ExecuteStep();

    BOOL     bUseHigh;
    DOUBLE	highTol;
    BOOL     bUseLow;
    DOUBLE	lowTol;
    m_NRKSdkQS.GetToleranceScalarOptionsArg(_T("Resultant Tolerance Options"), &bUseHigh, &highTol, &bUseLow, &lowTol);

    m_NRKSdkQS.SetStep(_T("Make Vector Tolerance"));
    m_NRKSdkQS.SetBoolArg(_T("Use High X Tolerance"), TRUE);
    m_NRKSdkQS.SetDoubleArg(_T("High X Tolerance"), 10.000000);
    m_NRKSdkQS.SetBoolArg(_T("Use High Y Tolerance"), TRUE);
    m_NRKSdkQS.SetDoubleArg(_T("High Y Tolerance"), 11.000000);
    m_NRKSdkQS.SetBoolArg(_T("Use High Z Tolerance"), TRUE);
    m_NRKSdkQS.SetDoubleArg(_T("High Z Tolerance"), 12.000000);
    m_NRKSdkQS.SetBoolArg(_T("Use High Mag Tolerance"), TRUE);
    m_NRKSdkQS.SetDoubleArg(_T("High Mag Tolerance"), 13.000000);
    m_NRKSdkQS.SetBoolArg(_T("Use Low X Tolerance"), TRUE);
    m_NRKSdkQS.SetDoubleArg(_T("Low X Tolerance"), 1.000000);
    m_NRKSdkQS.SetBoolArg(_T("Use Low Y Tolerance"), TRUE);
    m_NRKSdkQS.SetDoubleArg(_T("Low Y Tolerance"), 2.000000);
    m_NRKSdkQS.SetBoolArg(_T("Use Low Z Tolerance"), TRUE);
    m_NRKSdkQS.SetDoubleArg(_T("Low Z Tolerance"), 3.000000);
    m_NRKSdkQS.SetBoolArg(_T("Use Low Mag Tolerance"), TRUE);
    m_NRKSdkQS.SetDoubleArg(_T("Low Mag Tolerance"), 4.000000);
    m_NRKSdkQS.ExecuteStep();

    BOOL	   bUseHighX;
    DOUBLE	highTolX;
    BOOL	   bUseHighY;
    DOUBLE	highTolY;
    BOOL	   bUseHighZ;
    DOUBLE	highTolZ;
    BOOL	   bUseHighM;
    DOUBLE	highTolM;
    BOOL	   bUseLowX;
    DOUBLE	lowTolX;
    BOOL	   bUseLowY;
    DOUBLE	lowTolY;
    BOOL	   bUseLowZ;
    DOUBLE	lowTolZ;
    BOOL	   bUseLowM;
    DOUBLE	lowTolM;
    m_NRKSdkQS.GetToleranceVectorOptionsArg(_T("Resultant Vector Tolerance"),
        &bUseHighX, &highTolX, &bUseHighY, &highTolY,
        &bUseHighZ, &highTolZ, &bUseHighM, &highTolM,
        &bUseLowX, &lowTolX, &bUseLowY, &lowTolY,
        &bUseLowZ, &lowTolZ, &bUseLowM, &lowTolM);

    m_NRKSdkQS.SetStep(_T("Make Frame to Frame Relationship"));
    m_NRKSdkQS.SetCollectionObjectNameArg(_T("Relationship Name"), _T(""), _T("Frame 1 to 2"));
    m_NRKSdkQS.SetCollectionObjectNameArg(_T("First Frame Name"), _T(""), _T("Frame 1"));
    m_NRKSdkQS.SetCollectionObjectNameArg(_T("Second Frame Name"), _T(""), _T("Frame 2"));
    m_NRKSdkQS.SetToleranceScalarOptionsArg(_T("Orientation Tolerance"), bUseHigh, highTol, bUseLow, lowTol);
    m_NRKSdkQS.SetToleranceVectorOptionsArg(_T("Position Tolerance"),
        bUseHighX, highTolX, bUseHighY, highTolY, bUseHighZ, highTolZ, bUseHighM, highTolM,
        bUseLowX, lowTolX, bUseLowY, lowTolY, bUseLowZ, lowTolZ, bUseLowM, lowTolM);
    m_NRKSdkQS.ExecuteStep();
}


void CTestSdkQSDlg::OnBnClickedButton9()
{
    if (!m_SDKConnected)
        return;

    m_NRKSdkQS.SetStep(_T("Construct Frame"));
    m_NRKSdkQS.SetCollectionObjectNameArg(_T("New Frame Name"), _T(""), _T("My Frame"));
    double T[4][4];
    T[0][0] = 0.987109; 	T[0][1] = -0.112363; 	T[0][2] = 0.113976; 	T[0][3] = 1.000000;
    T[1][0] = 0.121202; 	T[1][1] = 0.989879; 	T[1][2] = -0.073816; 	T[1][3] = 2.000000;
    T[2][0] = -0.104528; 	T[2][1] = 0.086678; 	T[2][2] = 0.990737; 	T[2][3] = 3.000000;
    T[3][0] = 0.000000; 	T[3][1] = 0.000000; 	T[3][2] = 0.000000; 	T[3][3] = 1.000000;
    SDKHelper helper(m_NRKSdkQS);
    helper.SetTransformArgHelper(_T("Transform in Working Coordinates"), T);
    m_NRKSdkQS.ExecuteStep();

    m_NRKSdkQS.SetStep(_T("Make Frame to Frame Relationship"));
    m_NRKSdkQS.SetCollectionObjectNameArg(_T("Relationship Name"), _T(""), _T("My Frame to World"));
    m_NRKSdkQS.SetCollectionObjectNameArg(_T("First Frame Name"), _T(""), _T("WORLD"));
    m_NRKSdkQS.SetCollectionObjectNameArg(_T("Second Frame Name"), _T(""), _T("My Frame"));
    m_NRKSdkQS.SetToleranceScalarOptionsArg(_T("Orientation Tolerance"), TRUE, 0.500000, TRUE, 0.500000);
    m_NRKSdkQS.SetToleranceVectorOptionsArg(_T("Position Tolerance"),
        TRUE, 2.000000, TRUE, 2.000000, TRUE, 2.000000, TRUE, 2.000000,
        TRUE, -2.000000, TRUE, -2.000000, TRUE, -2.000000, TRUE, -2.000000);
    m_NRKSdkQS.ExecuteStep();

    m_NRKSdkQS.SetStep(_T("Set Relationship Position Fit Constraints (Vector Type)"));
    m_NRKSdkQS.SetCollectionObjectNameArg(_T("Relationship Name"), _T(""), _T("My Frame to World"));
    m_NRKSdkQS.SetToleranceVectorOptionsArg(_T("Position Vector Constraint"),
        TRUE, 10.000000, TRUE, 10.000000, TRUE, 10.000000, FALSE, 10.000000,
        TRUE, -10.000000, TRUE, -10.000000, TRUE, -10.000000, FALSE, -10.000000);
    m_NRKSdkQS.ExecuteStep();

    m_NRKSdkQS.SetStep(_T("Set Relationship Orientation Fit Constraints (Vector Type)"));
    m_NRKSdkQS.SetCollectionObjectNameArg(_T("Relationship Name"), _T(""), _T("My Frame to World"));
    m_NRKSdkQS.SetToleranceVectorOptionsArg(_T("Orientation Vector Constraint"),
        TRUE, 15.000000, TRUE, 15.000000, TRUE, 15.000000, FALSE, 15.000000,
        TRUE, -15.000000, TRUE, -15.000000, TRUE, -15.000000, FALSE, -15.000000);
    m_NRKSdkQS.ExecuteStep();
}

//********************************************************************
// olga mantis #7823 - math functions
//********************************************************************
void CTestSdkQSDlg::OnBnClickedButton10()
{
    if (!m_SDKConnected)
        return;

    BOOL bSendStatus = FALSE;

    // angular units conversion
    m_NRKSdkQS.SetStep(_T("Double Angle Conversion"));

    CString angUnitsIN = _T("Degrees");
    CString angUnitsOUT = _T("Radians");
    double  valueIn = 1.0;
    double valueOUT = 0.0;

    // Available options: 
    // "Degrees", "Radians", "Milliradians", "Gons/Grad", "Mils", "Arcseconds" 
    m_NRKSdkQS.SetAngularUnitsArg(_T("Input Ang Units"), angUnitsIN);
    m_NRKSdkQS.SetDoubleArg(_T("Input Angle Double"), valueIn);

    // Available options: 
    // "Degrees", "Radians", "Milliradians", "Gons/Grad", "Mils", "Arcseconds" 
    m_NRKSdkQS.SetAngularUnitsArg(_T("Output Ang Units"), angUnitsOUT);
    bSendStatus = m_NRKSdkQS.ExecuteStep();

    if (bSendStatus)
    {
        if (m_NRKSdkQS.GetDoubleArg(_T("Output Angle Double"), &valueOUT))
        {
            CString msg;
            msg.Format(_T("%f (%s) = %f (%s)\n"), valueIn, angUnitsIN, valueOUT, angUnitsOUT);
            //          AfxMessageBox(msg);
            TRACE(msg);
        }
        else
            AfxMessageBox(_T("Subroutine call failed"));
    }
    //////////////////////////////////////////////////////////////////////////////////////////
    CString func = _T("sin(X)");
    valueOUT = 0.0;
    valueIn = 90.0;

    m_NRKSdkQS.SetStep(_T("Trig Function"));

    // Available options: 
    // "sin(X)", "cos(X)", "tan(X)", "asin(X)", "acos(X)", "atan(X)", "atan2(Y,X)", "Pi", 
    m_NRKSdkQS.SetTrigFunctionArg(_T("Function"), func);
    // Available options: 
    // "Degrees", "Deg:Min:Sec", "Radians", "Milliradians", "Gons/Grad", "Mils", "Arcseconds", "Deg:Min", 
    m_NRKSdkQS.SetAngularUnitsArg(_T("Angular Units"), angUnitsIN);
    m_NRKSdkQS.SetDoubleArg(_T("X Double In"), valueIn);
    m_NRKSdkQS.SetDoubleArg(_T("Y Double In"), 0.000000);

    bSendStatus = m_NRKSdkQS.ExecuteStep();

    if (bSendStatus)
    {
        if (m_NRKSdkQS.GetDoubleArg(_T("Double Result"), &valueOUT))
        {
            CString msg;
            msg.Format(_T("%s (%f %s) = %f\n"), func, valueIn, angUnitsIN, valueOUT);
            //          AfxMessageBox(msg);
            TRACE(msg);
        }
        else
            AfxMessageBox(_T("Subroutine call failed"));
    }

    //////////////////////////////////////////////////////////////////////////////////////////
    func = _T("log(X)");
    valueOUT = 0.0;
    valueIn = 100.0;

    m_NRKSdkQS.SetStep(_T("Logarithmic Function"));
    // Available options: 
    // "ln(X)", "log(X)", "e", 
    m_NRKSdkQS.SetLogarithmicFunctionArg(_T("Function"), func);
    m_NRKSdkQS.SetDoubleArg(_T("X Double In"), valueIn);
    bSendStatus = m_NRKSdkQS.ExecuteStep();

    if (bSendStatus)
    {
        if (m_NRKSdkQS.GetDoubleArg(_T("Double Result"), &valueOUT))
        {
            CString msg;
            msg.Format(_T("%s (%f) = %f\n"), func, valueIn, valueOUT);
            //          AfxMessageBox(msg);
            TRACE(msg);
        }
        else
            AfxMessageBox(_T("Subroutine call failed"));
    }
    ///////////////////////////////////////////////////////////////////////////////
    double A = 30.78;
    double B = 23.54;
    CString compSign = _T("<=");
    BOOL bValue;

    m_NRKSdkQS.SetStep(_T("Double Comparison (result)"));
    m_NRKSdkQS.SetDoubleArg(_T("Double A"), A);
    // Available options: 
    // "=", "<", ">", "<=", ">=", "!=", 
    m_NRKSdkQS.SetNumComparisonTypeArg(_T("Comparison Type"), compSign);
    m_NRKSdkQS.SetDoubleArg(_T("Double B"), B);
    bSendStatus = m_NRKSdkQS.ExecuteStep();

    if (bSendStatus)
    {
        if (m_NRKSdkQS.GetBoolArg(_T("Resultant Value"), &bValue))
        {
            CString msg;
            msg.Format(_T("%f%s%f? %s\n"), A, compSign, B, (bValue) ? _T("true") : _T("false"));
            AfxMessageBox(msg);
            TRACE(msg);
        }
        else
            AfxMessageBox(_T("Subroutine call failed"));
    }
    //////////////////////////////////////////////////////////////////////
    int C = 65;
    int D = 45;

    m_NRKSdkQS.SetStep(_T("Integer Comparison (result)"));
    m_NRKSdkQS.SetIntegerArg(_T("Integer A"), C);
    // Available options: 
    // "=", "<", ">", "<=", ">=", "!=", 
    m_NRKSdkQS.SetNumComparisonTypeArg(_T("Comparison Type"), compSign);
    m_NRKSdkQS.SetIntegerArg(_T("Integer B"), D);
    bSendStatus = m_NRKSdkQS.ExecuteStep();

    if (bSendStatus)
    {
        if (m_NRKSdkQS.GetBoolArg(_T("Resultant Value"), &bValue))
        {
            CString msg;
            msg.Format(_T("%d%s%d? %s\n"), C, compSign, D, (bValue) ? _T("true") : _T("false"));
            AfxMessageBox(msg);
            TRACE(msg);
        }
        else
            AfxMessageBox(_T("Subroutine call failed"));
    }
    //////////////////////////////////////////////////////////////////
    m_NRKSdkQS.SetStep(_T("Integer Math Operation"));
    m_NRKSdkQS.SetIntegerArg(_T("First Value"), C);
    // Available options: 
    // "+", "-", "*", "/", "%", 
    CString mathSign = _T("+");
    m_NRKSdkQS.SetMathOperationArg(_T("Operation"), mathSign);
    m_NRKSdkQS.SetIntegerArg(_T("Second Value"), D);
    bSendStatus = m_NRKSdkQS.ExecuteStep();

    if (bSendStatus)
    {
        long value;

        if (m_NRKSdkQS.GetIntegerArg(_T("Resultant Value"), &value))
        {
            CString msg;
            msg.Format(_T("Int: %d%s%d=%d\n"), C, mathSign, D, value);
            AfxMessageBox(msg);
            TRACE(msg);
        }
        else
            AfxMessageBox(_T("Subroutine call failed"));
    }
    ////////////////////////////////////////////////////////////////
    m_NRKSdkQS.SetStep(_T("Double Math Operation"));
    m_NRKSdkQS.SetDoubleArg(_T("First Value"), A);
    // Available options: 
    // "+", "-", "*", "/", "%", 
    m_NRKSdkQS.SetMathOperationArg(_T("Operation"), mathSign);
    m_NRKSdkQS.SetDoubleArg(_T("Second Value"), B);
    bSendStatus = m_NRKSdkQS.ExecuteStep();

    if (bSendStatus)
    {
        double value;

        if (m_NRKSdkQS.GetDoubleArg(_T("Resultant Value"), &value))
        {
            CString msg;
            msg.Format(_T("Double: %f%s%f=%f\n"), A, mathSign, B, value);
            AfxMessageBox(msg);
            TRACE(msg);
        }
        else
            AfxMessageBox(_T("Subroutine call failed"));
    }

}

//******************************************************************************************************
// olga XIT-719: transition to new SA Colorizer
// "Set Vector Group Colorization Options (All)"
//******************************************************************************************************
void CTestSdkQSDlg::OnBnClickedButton13()
{
    if (!m_SDKConnected)
        return;

    BOOL bSendStatus = FALSE;

    // olga XIT-917 - SA SDK SetColorizationOptionsArg fields:
    //   
    //    0.		LPCTSTR colorRangeMethod, 
    //    1.		LPCTSTR baseHighColor, 
    //    2.		LPCTSTR baseMidColor, 
    //    3.		LPCTSTR baseLowColor, 
    //    4.		VARIANT_BOOL bDrawTubes, 
    //    5.		VARIANT_BOOL bDrawArrowheads, 
    //    6.		VARIANT_BOOL bIndicateValues, 

    //    7.		DOUBLE vectorMagnification, 
    //    8.		LONG vectorWidth, 
    //    9.		VARIANT_BOOL bDrawBlotches, 
    //    10.		DOUBLE blotchSize, 
    //    11.		VARIANT_BOOL bShowOutOfToleranceOnly, 
    //    12.		VARIANT_BOOL bShowColorBarInView, 

    //    13.		VARIANT_BOOL bShowColorBarPercentages, 
    //    14.		VARIANT_BOOL bShowColorBarFractions, 

    //    15.		DOUBLE highSaturationLimit, 
    //    16.		DOUBLE lowSaturationLimit, 
    //    17.		DOUBLE highTolerance, 
    //    18.		DOUBLE lowTolerance

    // style name
    CString colorRangeMethod = _T("Discrete Colors");
    // base colors
    CString baseHighColor = _T("Blue");
    CString baseMidColor = _T("Green");
    CString baseLowColor = _T("Red");

    double highSaturationLimit = 100.00;
    double lowSaturationLimit = -5;
    double highTolerance = 0.5;
    double lowTolerance = -0.5;

    m_NRKSdkQS.SetStep(_T("Set Vector Group Colorization Options (All)"));
    m_NRKSdkQS.SetColorizationOptionsArg(_T("Colorization Options"),
        colorRangeMethod,
        baseHighColor, baseMidColor, baseLowColor,
        FALSE,           // tubes
        FALSE,          // Draw Arrow heads
        FALSE,          // Indicate Values
        5.0,           // vector magnification - 
        1,              // vector width
        TRUE,          // Draw Blotches
        5,              // blotch size - if it is too small, the tubes are invisible
        FALSE,          // color bar - out of tolerance
        TRUE,           // color bar - show
        TRUE,           // color bar - %
        TRUE,           // color bar - fractions
        highSaturationLimit, lowSaturationLimit,
        highTolerance, lowTolerance);
    m_NRKSdkQS.ExecuteStep();

    if (bSendStatus)
    {
        LONG rCode;
        m_NRKSdkQS.GetMPStepResult(&rCode);
        if (rCode == SdkError)
        {
            CStringArray msgs;
            // Something went wrong... check for any messages provided...
            SDKHelper	helper(m_NRKSdkQS);
            if (helper.GetMPStepMessagesHelper(msgs))
            {
                CString singleLine;
                for (int i = 0; i < msgs.GetSize(); i++)
                {
                    singleLine += msgs[i];
                    singleLine += _T("\r\n");
                }
                AfxMessageBox(singleLine);
            }
        }
    }
}

//*************************************************************************
// olga XIT-1135 - Test for Set/Get multi-line notes (EditText MP Argument)
// For example, Set/Get Object Notes
//*************************************************************************
void CTestSdkQSDlg::OnBnClickedButton14()
{
    if (!m_SDKConnected)
        return;

#if 0
    BOOL bSendStatus = FALSE;

    // olga XIT-1135 - first create notes
    CStringArray myNotes;
    myNotes.Add(_T("Line 1"));
    myNotes.Add(_T("Line 2"));
    myNotes.Add(_T("Line 3"));
    myNotes.Add(_T("Line 4"));

    SDKHelper helper(m_NRKSdkQS);
    // prepare a Set command
    m_NRKSdkQS.SetStep(_T("Set Object Notes"));
    m_NRKSdkQS.SetCollectionObjectNameArg(_T("Object"), _T("A"), _T("World"));
    helper.SetEditTextArgHelper(_T("Notes"), myNotes);
    bSendStatus = m_NRKSdkQS.ExecuteStep();

    // check that we succeeded - Get notes
    CStringArray objNotes;
    m_NRKSdkQS.SetStep(_T("Get Object Notes"));
    m_NRKSdkQS.SetCollectionObjectNameArg(_T("Object"), _T("A"), _T("World"));
    helper.GetEditTextArgHelper(_T("Notes"), objNotes);
    bSendStatus = m_NRKSdkQS.ExecuteStep();

    for (int i = 0; i < objNotes.GetSize(); i++)
        TRACE(_T("%s \n"), objNotes.GetAt(i));

    // show to user - results
    m_NRKSdkQS.SetStep(_T("Notify User Text Array"));
    helper.SetStringRefListArgHelper(_T("Notification Text"), objNotes);
    m_NRKSdkQS.SetFontTypeArg(_T("Font"), _T("MS Shell Dlg"), 8, 0, 0, 0);
    m_NRKSdkQS.SetBoolArg(_T("Auto expand to fit text?"), FALSE);
    bSendStatus = m_NRKSdkQS.ExecuteStep();
#endif
}
//*************************************************************************************
// olga 2018.09.24 XIT-1214
// * Construction Operations >> Make a Collection Object Name Reference List- Runtime Select
// * Construction Operations >> Construct Surfaces by Dissecting Surfaces from Ref List
// * Construction Operations >> Construct Points From Surfaces On UV Grid
//**************************************************************************************
void CTestSdkQSDlg::OnBnClickedButton16()
{
    if (!m_SDKConnected)
        return;

    BOOL bSendStatus = FALSE;

    // first - select surfaces
    m_NRKSdkQS.SetStep(_T("Make a Collection Object Name Reference List- Runtime Select"));
    m_NRKSdkQS.SetStringArg(_T("User Prompt"), _T("select surfaces"));
    m_NRKSdkQS.SetObjectTypeArg(_T("Object Type"), _T("Surface"));
    bSendStatus = m_NRKSdkQS.ExecuteStep();

    SDKHelper helper(m_NRKSdkQS);
    CStringArray surfaceNameList;
    helper.GetCollectionObjectNameRefListArgHelper(_T("Resultant Collection Object Name Reference List"), surfaceNameList);

    // disssect selected surfaces
    m_NRKSdkQS.SetStep(_T("Construct Surfaces by Dissecting Surfaces from Ref List"));
    helper.SetCollectionObjectNameRefListArgHelper(_T("Surfaces to Dissect"), surfaceNameList);
    bSendStatus = m_NRKSdkQS.ExecuteStep();

    CStringArray facesList;
    helper.GetCollectionObjectNameRefListArgHelper(_T("Resultant Surfaces List"), facesList);

    m_NRKSdkQS.SetStep(_T("Construct Points From Surfaces On UV Grid"));
    helper.SetCollectionObjectNameRefListArgHelper(_T("Surface List"), facesList);
    m_NRKSdkQS.SetStringArg(_T("UV Point Group Base Name"), _T("UV Points"));
    m_NRKSdkQS.SetBoolArg(_T("Make Each Line Separate Group?"), FALSE);
    m_NRKSdkQS.SetIntegerArg(_T("Number of U Grids"), 5);
    m_NRKSdkQS.SetIntegerArg(_T("Number of V Grids"), 5);
    // Available options: 
    // "Include Edges", "Exclude Edges", "Edges Only", 
    m_NRKSdkQS.SetEdgeModeArg(_T("Edge Point Mode"), _T("Include Edges"));
    bSendStatus = m_NRKSdkQS.ExecuteStep();

    if (bSendStatus)
    {
        LONG rCode;
        m_NRKSdkQS.GetMPStepResult(&rCode);
        if (rCode == SdkError)
        {
            CStringArray msgs;
            // Something went wrong... check for any messages provided...
            SDKHelper	helper(m_NRKSdkQS);
            if (helper.GetMPStepMessagesHelper(msgs))
            {
                CString singleLine;
                for (int i = 0; i < msgs.GetSize(); i++)
                {
                    singleLine += msgs[i];
                    singleLine += _T("\r\n");
                }
                AfxMessageBox(singleLine);
            }
        }
    }
}

//*********************************************************************************************************************
// olga 2018.09.24 XIT-1024 - Added 7 arguments to SA SDK to support all types of "Make <geometry> Fit Profile" commands:
// 1. MPDegreeOfFreedomArguement 
// 2. MPFitMethodArguement 
// 3. MPSlotTypeArguement 
// 4. MPCompTechniqueArguement 
// 5. MPNormalDirectionArguement 
// 6. MPMeasuredSideForRadialOffsetArguement 
//*********************************************************************************************************************
void CTestSdkQSDlg::OnBnClickedButton17()
{
    if (!m_SDKConnected)
        return;

    BOOL bSendStatus = FALSE;

    m_NRKSdkQS.SetStep(_T("Make Line Fit Profile"));
    m_NRKSdkQS.SetStringArg(_T("Fit Profile Name"), _T("myLine"));
    m_NRKSdkQS.SetBoolArg(_T("Reverse Normal Vector after fit?"), FALSE);
    m_NRKSdkQS.SetBoolArg(_T("Make Cardinal Points?"), TRUE);
    m_NRKSdkQS.SetBoolArg(_T("Cardinal Pt.1: Point A?"), TRUE);
    m_NRKSdkQS.SetBoolArg(_T("Cardinal Pt.2: Point B?"), TRUE);
    m_NRKSdkQS.SetBoolArg(_T("Cardinal Pt.3: Mid Point?"), TRUE);
    bSendStatus = m_NRKSdkQS.ExecuteStep();

    m_NRKSdkQS.SetStep(_T("Make Plane Fit Profile"));
    m_NRKSdkQS.SetStringArg(_T("Fit Profile Name"), _T("myPlane"));
    m_NRKSdkQS.SetMeasuredSideForPlanarOffsetArg(_T("Measured Side for Planar Offset"), _T("Above Plane"));
    m_NRKSdkQS.SetDoubleArg(_T("Override Planar Offset (-1.0 use current)"), -1.000000);
    m_NRKSdkQS.SetNormalDirectionArg(_T("Planar Offset Direction"), _T("Probing Direction"));
    m_NRKSdkQS.SetBoolArg(_T("Reverse Normal Vector after fit?"), FALSE);
    m_NRKSdkQS.SetBoolArg(_T("Make Cardinal Points?"), TRUE);
    m_NRKSdkQS.SetBoolArg(_T("Cardinal Pt.1: Centroid?"), TRUE);
    m_NRKSdkQS.SetBoolArg(_T("Cardinal Pt.2: Point on Normal?"), TRUE);
    bSendStatus = m_NRKSdkQS.ExecuteStep();

    m_NRKSdkQS.SetStep(_T("Make Circle Fit Profile"));
    m_NRKSdkQS.SetStringArg(_T("Fit Profile Name"), _T("myCircle"));
    m_NRKSdkQS.SetMeasuredSideForRadialOffsetArg(_T("Measured Side for Radial Offset"), _T("Outside"));
    m_NRKSdkQS.SetDoubleArg(_T("Override Radial Offset (-1.0 use current)"), -1.000000);
    m_NRKSdkQS.SetMeasuredSideForPlanarOffsetArg(_T("Measured Side for Planar Offset"), _T("Above Plane"));
    m_NRKSdkQS.SetDoubleArg(_T("Override Planar Offset (-1.0 use current)"), -1.000000);
    m_NRKSdkQS.SetNormalDirectionArg(_T("Planar Offset Direction"), _T("Probing Direction"));
    m_NRKSdkQS.SetDoubleArg(_T("Lock Radius (-1.0 do not lock)"), -1.000000);
    m_NRKSdkQS.SetCompTechniqueArg(_T("Circle Computation Technique"), _T("Standard"));
    m_NRKSdkQS.SetBoolArg(_T("Reverse Normal Vector after fit?"), FALSE);
    m_NRKSdkQS.SetBoolArg(_T("Make Cardinal Points?"), TRUE);
    m_NRKSdkQS.SetBoolArg(_T("Cardinal Pt.1: Center?"), TRUE);
    m_NRKSdkQS.SetBoolArg(_T("Cardinal Pt.2: Point on Normal?"), TRUE);
    bSendStatus = m_NRKSdkQS.ExecuteStep();

    m_NRKSdkQS.SetStep(_T("Make Slot Fit Profile"));
    m_NRKSdkQS.SetStringArg(_T("Fit Profile Name"), _T("mySlot"));
    m_NRKSdkQS.SetMeasuredSideForRadialOffsetArg(_T("Measured Side for Radial Offset"), _T("Outside"));
    m_NRKSdkQS.SetDoubleArg(_T("Override Radial Offset (-1.0 use current)"), -1.000000);
    m_NRKSdkQS.SetMeasuredSideForPlanarOffsetArg(_T("Measured Side for Planar Offset"), _T("Above Plane"));
    m_NRKSdkQS.SetDoubleArg(_T("Override Planar Offset (-1.0 use current)"), -1.000000);
    m_NRKSdkQS.SetNormalDirectionArg(_T("Planar Offset Direction"), _T("Probing Direction"));
    m_NRKSdkQS.SetSlotTypeArg(_T("Slot Type"), _T("Round"));
    m_NRKSdkQS.SetCompTechniqueArg(_T("Slot Computation Technique"), _T("Standard"));
    m_NRKSdkQS.SetBoolArg(_T("Reverse Normal Vector after fit?"), FALSE);
    m_NRKSdkQS.SetBoolArg(_T("Make Cardinal Points?"), TRUE);
    m_NRKSdkQS.SetBoolArg(_T("Cardinal Pt.1: Center?"), TRUE);
    m_NRKSdkQS.SetBoolArg(_T("Cardinal Pt.2: Point on Normal?"), TRUE);
    m_NRKSdkQS.SetBoolArg(_T("Cardinal Pt.3: Centerline Pt.1?"), TRUE);
    m_NRKSdkQS.SetBoolArg(_T("Cardinal Pt.4: Centerline Pt.2?"), TRUE);
    bSendStatus = m_NRKSdkQS.ExecuteStep();

    m_NRKSdkQS.SetStep(_T("Make Ellipse Fit Profile"));
    m_NRKSdkQS.SetStringArg(_T("Fit Profile Name"), _T("myEllipse"));
    m_NRKSdkQS.SetMeasuredSideForRadialOffsetArg(_T("Measured Side for Radial Offset"), _T("Outside"));
    m_NRKSdkQS.SetDoubleArg(_T("Override Radial Offset (-1.0 use current)"), -1.000000);
    m_NRKSdkQS.SetMeasuredSideForPlanarOffsetArg(_T("Measured Side for Planar Offset"), _T("Above Plane"));
    m_NRKSdkQS.SetDoubleArg(_T("Override Planar Offset (-1.0 use current)"), -1.000000);
    m_NRKSdkQS.SetNormalDirectionArg(_T("Planar Offset Direction"), _T("Probing Direction"));
    m_NRKSdkQS.SetBoolArg(_T("Reverse Normal Vector after fit?"), FALSE);
    m_NRKSdkQS.SetBoolArg(_T("Make Cardinal Points?"), TRUE);
    m_NRKSdkQS.SetBoolArg(_T("Cardinal Pt.1: Center?"), TRUE);
    m_NRKSdkQS.SetBoolArg(_T("Cardinal Pt.2: Point on Normal?"), TRUE);
    m_NRKSdkQS.SetBoolArg(_T("Cardinal Pt.3: Focal Pt.1?"), TRUE);
    m_NRKSdkQS.SetBoolArg(_T("Cardinal Pt.4: Focal Pt.2?"), TRUE);
    bSendStatus = m_NRKSdkQS.ExecuteStep();

    m_NRKSdkQS.SetStep(_T("Make Sphere Fit Profile"));
    m_NRKSdkQS.SetStringArg(_T("Fit Profile Name"), _T("mySphere"));
    m_NRKSdkQS.SetMeasuredSideForRadialOffsetArg(_T("Measured Side for Radial Offset"), _T("Outside"));
    m_NRKSdkQS.SetDoubleArg(_T("Override Radial Offset (-1.0 use current)"), -1.000000);
    m_NRKSdkQS.SetDoubleArg(_T("Lock Radius (-1.0 do not lock)"), -1.000000);
    m_NRKSdkQS.SetBoolArg(_T("Make Cardinal Points?"), TRUE);
    m_NRKSdkQS.SetBoolArg(_T("Cardinal Pt.1: Center?"), TRUE);
    bSendStatus = m_NRKSdkQS.ExecuteStep();

    m_NRKSdkQS.SetStep(_T("Make Cone Fit Profile"));
    m_NRKSdkQS.SetStringArg(_T("Fit Profile Name"), _T("myCone"));
    m_NRKSdkQS.SetMeasuredSideForRadialOffsetArg(_T("Measured Side for Radial Offset"), _T("Outside"));
    m_NRKSdkQS.SetDoubleArg(_T("Override Radial Offset (-1.0 use current)"), -1.000000);
    m_NRKSdkQS.SetDoubleArg(_T("Lock Angle in degrees (-1.0 do not lock)"), -1.000000);
    m_NRKSdkQS.SetBoolArg(_T("Make Cardinal Points?"), TRUE);
    m_NRKSdkQS.SetBoolArg(_T("Cardinal Pt.1: Vertex?"), TRUE);
    m_NRKSdkQS.SetBoolArg(_T("Cardinal Pt.2: Point on Axis?"), TRUE);
    m_NRKSdkQS.SetBoolArg(_T("Cardinal Pt.3: Cut Point on Axis?"), TRUE);
    bSendStatus = m_NRKSdkQS.ExecuteStep();

    m_NRKSdkQS.SetStep(_T("Make Paraboloid Fit Profile"));
    m_NRKSdkQS.SetStringArg(_T("Fit Profile Name"), _T("myParaboloid"));
    m_NRKSdkQS.SetMeasuredSideForRadialOffsetArg(_T("Measured Side for Radial Offset"), _T("Outside"));
    m_NRKSdkQS.SetDoubleArg(_T("Override Radial Offset (-1.0 use current)"), -1.000000);
    m_NRKSdkQS.SetDoubleArg(_T("Lock Focal Length (-1.0 do not lock)"), -1.000000);
    m_NRKSdkQS.SetDegreeOfFreedomArg(_T("Degree of Freedom"), _T("Any"));
    m_NRKSdkQS.SetBoolArg(_T("Make Cardinal Points?"), TRUE);
    m_NRKSdkQS.SetBoolArg(_T("Cardinal Pt.1: Vertex?"), TRUE);
    m_NRKSdkQS.SetBoolArg(_T("Cardinal Pt.2: Focal Point?"), TRUE);
    bSendStatus = m_NRKSdkQS.ExecuteStep();

    m_NRKSdkQS.SetStep(_T("Make Cylinder Fit Profile"));
    m_NRKSdkQS.SetStringArg(_T("Fit Profile Name"), _T("myCylinder"));
    m_NRKSdkQS.SetMeasuredSideForRadialOffsetArg(_T("Measured Side for Radial Offset"), _T("Outside"));
    m_NRKSdkQS.SetDoubleArg(_T("Override Radial Offset (-1.0 use current)"), -1.000000);
    m_NRKSdkQS.SetDoubleArg(_T("Lock Radius (-1.0 do not lock)"), -1.000000);
    m_NRKSdkQS.SetFitMethodArg(_T("Locked Radius Fit Method"), _T("Minimum RMS"));
    m_NRKSdkQS.SetCompTechniqueArg(_T("Cylinder Computation Technique"), _T("Standard"));
    m_NRKSdkQS.SetBoolArg(_T("Make Cardinal Points?"), TRUE);
    m_NRKSdkQS.SetBoolArg(_T("Cardinal Pt.1: Begin Pt?"), TRUE);
    m_NRKSdkQS.SetBoolArg(_T("Cardinal Pt.2: End Pt?"), TRUE);
    m_NRKSdkQS.SetBoolArg(_T("Cardinal Pt.3: Center?"), TRUE);
    bSendStatus = m_NRKSdkQS.ExecuteStep();


}

//******************************************************
// olga XIT-1380 - Instrument Operational Check
// olga XIT-584 - Set/Get Active Units
//******************************************************
void CTestSdkQSDlg::OnBnClickedButton19()
{
    if (!m_SDKConnected)
        return;

    SDKHelper helper(m_NRKSdkQS);
    BOOL bSendStatus = FALSE;

    // olga XIT-1380 - Instrument Operational Check
    //m_NRKSdkQS.SetStep(_T("Instrument Operational Check"));
    //m_NRKSdkQS.SetColInstIdArg(_T("Instrument to Check"), _T("A"), 0);
    //m_NRKSdkQS.SetStringArg(_T("Check Type"), _T("Valid Distance"));
    //bSendStatus = m_NRKSdkQS.ExecuteStep();

    //if (bSendStatus)
    //{
    //    LONG rCode;
    //    m_NRKSdkQS.GetMPStepResult(&rCode);
    //    if (rCode == DoneSuccess)
    //    {
    //        TRACE(_T("The check was performed successfully\n"));
    //    }
    //    else
    //         TRACE(_T("The check was not successful\n"));
    //}

    // olga XIT-584 - Set/Get Active Units
    m_NRKSdkQS.SetStep(_T("Set Active Units"));
    // Available options: 
    // "Meters", "Centimeters", "Millimeters", "Feet", "Inches", 
    m_NRKSdkQS.SetDistanceUnitsArg(_T("Length"), _T("Inches"));
    m_NRKSdkQS.SetBoolArg(_T("Display Inch Fractions?"), FALSE);
    m_NRKSdkQS.SetDoubleArg(_T("Inch Fraction Denominator?"), 16.000000);
    m_NRKSdkQS.SetBoolArg(_T("Simplify Inch Fraction?"), TRUE);
    // Available options: 
    // "Fahrenheit", "Celsius", 
    m_NRKSdkQS.SetTemperatureUnitsArg(_T("Temperature"), _T("Fahrenheit"));
    // Available options: 
    // "Degrees", "Deg:Min:Sec", "Radians", "Milliradians", 
    // "Gons/Grad", "Mils", "Arcseconds", "Deg:Min", 
    m_NRKSdkQS.SetAngularUnitsArg(_T("Angular"), _T("Degrees"));
    bSendStatus = m_NRKSdkQS.ExecuteStep();
    if (bSendStatus)
    {
        LONG rCode;
        m_NRKSdkQS.GetMPStepResult(&rCode);
        if (rCode == DoneSuccess)
        {
            TRACE(_T("Set Active Units success\n"));
        }
        else
            TRACE(_T("Set Active Units failure\n"));
    }

    // get them back
    m_NRKSdkQS.SetStep(_T("Get Active Units"));
    bSendStatus = m_NRKSdkQS.ExecuteStep();
    if (bSendStatus)
    {
        LONG rCode;
        m_NRKSdkQS.GetMPStepResult(&rCode);

        if (rCode == DoneSuccess)
        {
            // Now get the answer
            CString strUnit;
            CComBSTR bstrUnit;
            if (m_NRKSdkQS.GetStringArg(_T("Length"), &bstrUnit))
            {
                strUnit = bstrUnit;
                CString msg;
                msg.Format(_T("Length unit: %s"), strUnit);
                AfxMessageBox(msg);
            }
            // Must release the BSTR returned.
            bstrUnit.Empty();

            if (m_NRKSdkQS.GetStringArg(_T("Angular"), &bstrUnit))
            {
                strUnit = bstrUnit;
                CString msg;
                msg.Format(_T("Angular unit: %s"), strUnit);
                AfxMessageBox(msg);
            }
            // Must release the BSTR returned.
            bstrUnit.Empty();

            if (m_NRKSdkQS.GetStringArg(_T("Temperature"), &bstrUnit))
            {
                strUnit = bstrUnit;
                CString msg;
                msg.Format(_T("Temperature unit: %s"), strUnit);
                AfxMessageBox(msg);
            }
            // Must release the BSTR returned.
            bstrUnit.Empty();
        }
    }
}

//*****************************************************************
// olga 2019.07.18 XIT-586 - UDP Settings in Watch Window Template
// Test is with already running Faro Vantage
//*****************************************************************
void CTestSdkQSDlg::OnBnClickedButton20()
{
    if (!m_SDKConnected)
        return;

    SDKHelper helper(m_NRKSdkQS);
    BOOL bSendStatus = FALSE;

    // set watch window template
    m_NRKSdkQS.SetStep(_T("Watch Window Template 3D"));

    m_NRKSdkQS.SetCollectionObjectNameArg(_T("Watch Window Template Name"), _T(""), _T("New")); // A0

    // precision
    m_NRKSdkQS.SetIntegerArg(_T("Linear Precision"), 4);
    m_NRKSdkQS.SetIntegerArg(_T("Angular Precision"), 3);

    // font
    m_NRKSdkQS.SetFontTypeArg(_T("Font"), _T("MS Shell Dlg"), 8, 0, 0, 0);
    m_NRKSdkQS.SetColorArg(_T("Text Color"), 0, 0, 255);
    m_NRKSdkQS.SetColorArg(_T("Background Color"), 255, 255, 255);
    m_NRKSdkQS.SetColorArg(_T("Highlight Color"), 255, 0, 0);

    // deviation
    m_NRKSdkQS.SetBoolArg(_T("Show Deviation 1?"), TRUE);
    m_NRKSdkQS.SetBoolArg(_T("Show Deviation 2?"), TRUE);
    m_NRKSdkQS.SetBoolArg(_T("Show Deviation 3?"), TRUE);
    m_NRKSdkQS.SetBoolArg(_T("Show Deviation Mag?"), TRUE);

    // coordinate system
    m_NRKSdkQS.SetCoordinateSystemTypeArg(_T("Coordinate System"), _T("Cartesian"));

    // UDP
    m_NRKSdkQS.SetUdpTransmitSettingsArg(_T("UDP Network Transmit Settings"), TRUE, TRUE, _T(""), 10000);

    // frame
    m_NRKSdkQS.SetBoolArg(_T("Report In Working Frame?"), TRUE);
    m_NRKSdkQS.SetCollectionObjectNameArg(_T("Reference Frame"), _T(""), _T(""));

    // tolerance
    m_NRKSdkQS.SetToleranceVectorOptionsArg(_T("Default Tolerance (Closest Point & Point to Point)"),
        FALSE, 0.000000, FALSE, 0.000000, FALSE, 0.000000, FALSE, 0.000000,
        FALSE, 0.000000, FALSE, 0.000000, FALSE, 0.000000, FALSE, 0.000000);
    m_NRKSdkQS.SetDoubleArg(_T("Default Tolerance (Point to Objects)"), 0.000000);

    // misc
    m_NRKSdkQS.SetBoolArg(_T("Transparent Background?"), FALSE);
    m_NRKSdkQS.SetBoolArg(_T("Hide Units?"), FALSE);
    m_NRKSdkQS.SetBoolArg(_T("Show Graphical Guide?"), FALSE);

    bSendStatus = m_NRKSdkQS.ExecuteStep();

    if (bSendStatus)
    {
        LONG rCode;
        m_NRKSdkQS.GetMPStepResult(&rCode);
        if (rCode == DoneSuccess)
        {
            TRACE(_T("The operation was performed successfully\n"));
        }
        else
            TRACE(_T("The operation was not successful\n"));
    }

    // Construct a Point in Working Coordinates
    m_NRKSdkQS.SetStep(_T("Construct a Point in Working Coordinates"));
    m_NRKSdkQS.SetPointNameArg(_T("Point Name"), _T(""), _T("New"), _T("Point To Watch"));
    m_NRKSdkQS.SetVectorArg(_T("Working Coordinates"), 0.000000, 0.000000, 0.000000);
    bSendStatus = m_NRKSdkQS.ExecuteStep();

    // watch point to point in template based window
    m_NRKSdkQS.SetStep(_T("Watch Point To Point"));
    m_NRKSdkQS.SetColInstIdArg(_T("Instrument's ID"), _T(""), 0);
    m_NRKSdkQS.SetPointNameArg(_T("Reference Point"), _T(""), _T("New"), _T("Point To Watch"));
    m_NRKSdkQS.SetCollectionObjectNameArg(_T("3 DOF Watch Window Properties"), _T(""), _T("New"));
    m_NRKSdkQS.SetStringArg(_T("Measurement Mode"), _T(""));
    m_NRKSdkQS.SetBoolArg(_T("Pause MP Until Closed"), FALSE);
    m_NRKSdkQS.SetIntegerArg(_T("Window Top Left X Position"), 0);
    m_NRKSdkQS.SetIntegerArg(_T("Window Top Left Y Position"), 0);
    m_NRKSdkQS.SetIntegerArg(_T("Window Width"), 0);
    m_NRKSdkQS.SetIntegerArg(_T("Window Height"), 0);
    bSendStatus = m_NRKSdkQS.ExecuteStep();

    if (bSendStatus)
    {
        LONG rCode;
        m_NRKSdkQS.GetMPStepResult(&rCode);
        if (rCode == DoneSuccess)
        {
            TRACE(_T("The operation was performed successfully\n"));
        }
        else
            TRACE(_T("The operation was not successful\n"));
    }
}

// Event handler invoked once connected to Spatial Analyzer
void CTestSdkQSDlg::Pipeline_OnConnectToHardware(LPCTSTR selectedSAInstName)
{
    AfxMessageBox(selectedSAInstName);
    m_pipelineSDK.SetInstrumentRemoveAllPriorShotsOverride(TRUE);

    CString graphicsPath = theApp.ProgramDirectory;
    graphicsPath += _T("Graphics\\");

    // For testing request for loading simple instrument graphic at instrument base
    // NOTE: Specify an empty filename if no graphic desired for a particular component (instrument or probe).
    CString instGraphics(graphicsPath + _T("GSI_inca3.STL"));
    CString instProbe(graphicsPath + _T("Aicon MoveInspect Probe.STL"));
    m_pipelineSDK.SetInstrumentGraphics(instGraphics, instProbe);
}

// Event handler invoked to notify instrument to begin live updates
void CTestSdkQSDlg::Pipeline_OnActivateWatchUpdating()
{
    // Should now activate instrument to send live point updates to SA
}

// Event handler invoked when the length/temp units within Spatial Analyzer have changed
void CTestSdkQSDlg::Pipeline_OnUnitsChange(long lengthUnits, long temperatureUnits)
{
    // LU_INVALID = 0
    // LU_METERS = 1
    // LU_CENTIMETERS = 2
    // LU_MILLIMETERS = 3
    // LU_FEET = 4
    // LU_INCHES = 5

    // lengthUnits
    m_displayLengthUnits = (LengthUnitsType) lengthUnits;

    // TU_INVALID = 0,
    // TU_DEGS_C,
    // TU_DEGS_F

    // temperatureUnits
}

// Event handler invoked via MP Instrument OpCheck.
void CTestSdkQSDlg::Pipeline_OnOpCheck(LPCTSTR command)
{
    //AfxMessageBox(command);

    CString Command(command);

    // Illustrations...
    if (Command.CompareNoCase(_T("Start Server")))
    {

    }
    else if (Command.CompareNoCase(_T("Stop Server")))
    {

    }
    else if (Command.CompareNoCase(_T("Connect")))
    {

    }
}

// Event handler invoked via MP when the collection / group / target names have changed.
void CTestSdkQSDlg::Pipeline_OnSetColGroupTarget(LPCTSTR collectionName, LPCTSTR groupName, LPCTSTR targetName)
{
    CString msg;
    msg.Format(_T("Pipeline_OnSetColGroupTarget: %s::%s::%s"), collectionName, groupName, targetName);
    //AfxMessageBox(msg);
    m_collection = collectionName;
    m_group = groupName;
    m_target = targetName;
    UpdateData(TRUE);
}

// This class must be used for MP dynamic reference requests and for points returned from
// SpatialAnalyzer via the initiation of the 'RequestPointsFromSA()' call.
struct SAGroupPoint
{
public:
    std::string colName;
    std::string groupName;
    std::string pointName;

    std::vector<double> PointInInstrument;

    bool bHasUncert;
    std::vector<double> StdDev;
};

static void from_json(const nlohmann::json& j, SAGroupPoint& s)
{
    s.colName = j.at("colName").get<std::string>();
    s.groupName = j.at("groupName").get<std::string>();
    s.pointName = j.at("pointName").get<std::string>();
    s.PointInInstrument = j.at("PointInInstrument").get<std::vector<double>>();
    s.bHasUncert = j.at("bHasUncert").get<double>();
    s.StdDev = j.at("StdDev").get<std::vector<double>>();
}

// When 'RequestPointsFromSA()' called, this is the response from SA after user selects points.
// Normally take specified points and create a dynamic reference.
void CTestSdkQSDlg::Pipeline_OnSAIPRequestPoints(LPCTSTR jsonPointObjects)
{
    auto j = nlohmann::json::parse(std::wstring(jsonPointObjects));
    auto parsed = j.get<std::vector<SAGroupPoint>>();

    //// Use the extracted points to create the desired dynamic reference on the instrument...
    for (int i = 0; i < parsed.size(); i++)
    {
        SAGroupPoint& pt = parsed[i];
        CString foo;
        foo.Format(_T("%s::%s::%s : (%lf, %lf, %lf)\n"), CString(pt.colName.c_str()), CString(pt.groupName.c_str()), CString(pt.pointName.c_str()), pt.PointInInstrument[0], pt.PointInInstrument[1], pt.PointInInstrument[2]);
        TRACE(foo);
    }
}

void CTestSdkQSDlg::Pipeline_OnSAIPCreateDynamicReference(LPCTSTR dynRefName, LPCTSTR jsonPointObjects)
{
    CString name(dynRefName);

    auto j = nlohmann::json::parse(std::wstring(jsonPointObjects));
    auto parsed = j.get<std::vector<SAGroupPoint>>();

    //// Use the extracted points to create the desired dynamic reference on the instrument...
    for (int i = 0; i < parsed.size(); i++)
    {
        SAGroupPoint& pt = parsed[i];
        CString foo;
        foo.Format(_T("%s::%s::%s : (%lf, %lf, %lf)\n"), CString(pt.colName.c_str()), CString(pt.groupName.c_str()), CString(pt.pointName.c_str()), pt.PointInInstrument[0], pt.PointInInstrument[1], pt.PointInInstrument[2]);
        TRACE(foo);
    }
}

struct SACheckPointForInstrument
{
    bool DidFindPoint;
    std::string TargetNameToSend;
    double DistanceToClosest;
    double ToleranceForClosest;
};

static void from_json(const nlohmann::json& j, SACheckPointForInstrument& s)
{
    s.DidFindPoint = j.at("DidFindPoint").get<bool>();
    s.TargetNameToSend = j.at("TargetNameToSend").get<std::string>();
    s.DistanceToClosest = j.at("DistanceToClosest").get<double>();
    s.ToleranceForClosest = j.at("ToleranceForClosest").get<double>();
}

struct SAAutoMeasureTolerances
{
    double proximityTolerance;
    double axisProximityTolerance;
    double toneRampStartTolerance;
};

static void from_json(const nlohmann::json& j, SAAutoMeasureTolerances& s)
{
    s.proximityTolerance = j.at("proximityTolerance").get<double>();
    s.axisProximityTolerance = j.at("axisProximityTolerance").get<double>();
    s.toneRampStartTolerance = j.at("toneRampStartTolerance").get<double>();
}

struct SAAutoMeasureDestination
{
    std::string collection;
    std::string group;
    std::string target;
};

static void from_json(const nlohmann::json& j, SAAutoMeasureDestination& s)
{
    s.collection = j.at("Collection").get<std::string>();
    s.group = j.at("Group").get<std::string>();
    s.target = j.at("Target").get<std::string>();
}

// This will be invoked when performing the following within SpatialAnalyzer:
//   Instrument >> Automatic Measurement >> Auto-Correspond with Proximity Trigger >> Points
void CTestSdkQSDlg::Pipeline_OnSAIPAutoMeasProximity(BOOL bProcessDone)
{
    if (bProcessDone == FALSE) // Begin AutoMeasure
    {
        // In a real instrument interface, one would need to start live instrument
        // updating... as points arrive, check for closest point and update SA audible

        auto jsonReturn = m_pipelineSDK.GetCurAutoMeasureDestination();
        auto j = nlohmann::json::parse(std::wstring(jsonReturn));
        auto destination = j.get<SAAutoMeasureDestination>();

        CString foo(destination.collection.c_str());
        m_collection = foo;
        foo = destination.group.c_str();
        m_group = foo;
        foo = destination.target.c_str();
        m_target = foo;
        UpdateData(FALSE);

        // Get AutoMeasure Tolerances.  Provided via JSON response... 
        double proxTol, axisTol, rampZone;
        jsonReturn = m_pipelineSDK.GetCurAutoMeasureTolerances();

        j = nlohmann::json::parse(std::wstring(jsonReturn));
        auto tolerances = j.get<SAAutoMeasureTolerances>();

        // Now that we have the tolerances, setup the SA audible params...
        m_pipelineSDK.AudibleSetParams(tolerances.proximityTolerance, tolerances.toneRampStartTolerance);
        // Prepare the audible for error tone updates...
        m_pipelineSDK.AudibleStart();

        // Just for grins, play a couple tones....
        m_pipelineSDK.AudibleSetError(10.25);
        Sleep(2000);
        m_pipelineSDK.AudibleSetError(5.23);
        Sleep(2000);

        // Just for fun, lets try a quick point check
        double curPtInInchesX = 100.123;
        double curPtInInchesY = 50.456;
        double curPtInInchesZ = 25.234;
        double tipRadiusInInches = 0.25;
        jsonReturn = m_pipelineSDK.CheckPointForInstrument(curPtInInchesX, curPtInInchesY, curPtInInchesZ, tipRadiusInInches);
        auto jj = nlohmann::json::parse(std::wstring(jsonReturn));
        auto checkpoint = jj.get<SACheckPointForInstrument>();

        if (checkpoint.DidFindPoint)
        {
            auto closestPtName = checkpoint.TargetNameToSend;
            m_target = closestPtName.c_str();
        }
        m_pipelineSDK.AudibleSetError(checkpoint.DistanceToClosest);
    }
    else // End AutoMeasure
    {
        m_pipelineSDK.AudibleStop();
    }
}

struct SAMeasGroupPoint
{
    std::string Group;
    std::string Target;
    std::vector<double> Nominal;
};

static void from_json(const nlohmann::json& j, SAMeasGroupPoint& s)
{
    s.Group = j.at("Group").get<std::string>();
    s.Target = j.at("Target").get<std::string>();
    s.Nominal = j.at("Nominal").get<std::vector<double>>();
}

struct SAMeasGroup
{
    std::string TargetSuffix;
    std::string GroupSuffix;
    std::vector<SAMeasGroupPoint> Points;
};

static void from_json(const nlohmann::json& j, SAMeasGroup& s)
{
    s.TargetSuffix = j.at("TargetSuffix").get<std::string>();
    s.GroupSuffix = j.at("GroupSuffix").get<std::string>();
    s.Points = j.at("Points").get<std::vector<SAMeasGroupPoint>>();
}

struct SAMeasGuidePointDeltaInWorking
{
    double DeltaXInches;
    double DeltaYInches;
    double DeltaZInches;
    double DeltaMag;
};

static void from_json(const nlohmann::json& j, SAMeasGuidePointDeltaInWorking& s)
{
    s.DeltaXInches = j.at("DeltaXInches").get<double>();
    s.DeltaYInches = j.at("DeltaYInches").get<double>();
    s.DeltaZInches = j.at("DeltaZInches").get<double>();
    s.DeltaMag = j.at("DeltaMag").get<double>();
}

// Basic properties to simulate some basic guided measuring
std::wstring CurGroupTarget;
int activeGuidePtIndex = 0;
SAMeasGroup guideGroup;
std::wstring DeltaInWorking;
std::wstring DeltaMagnitude;
double ProbeRadius = 0.25;

// This will be invoked when performing the following within SpatialAnalyzer:
//   Instrument >> Automatic Measurement >> Measure Batch of Points
void CTestSdkQSDlg::Pipeline_OnSAIPMeasGroup(LPCTSTR jsonPointObjects)
{
    auto j = nlohmann::json::parse(std::wstring(jsonPointObjects));
    guideGroup = j.get<SAMeasGroup>();

    // Pretend we are beginning Guided Measuring...
    activeGuidePtIndex = 0;
    // Tell SpatialAnalyzer to display zoom view of point to user
    m_pipelineSDK.SetGuidedPointServoView(activeGuidePtIndex);
    // Display info about current active guide point somewhere in your gui
    CString foo;
    CString cg(guideGroup.Points[activeGuidePtIndex].Group.c_str());
    CString ct(guideGroup.Points[activeGuidePtIndex].Target.c_str());
    foo.Format(_T("%s::%s"), cg, ct);
    CurGroupTarget = foo.GetString();

    // Lets make up a point that our instrument might give us...
    double curPtInInchesX = 100.123;
    double curPtInInchesY = 50.456;
    double curPtInInchesZ = 25.234;
    double xUncert = 0; // 1 sigma uncertainty in INCHES
    double yUncert = 0; // 1 sigma uncertainty in INCHES
    double zUncert = 0; // 1 sigma uncertainty in INCHES
    double xProbeDir = 0; // Axis only probing direction
    double yProbeDir = 0.5;
    double zProbeDir = 0.5;

    auto deltaInWorkingInfo = m_pipelineSDK.GetGuidedDeltaInWorking(activeGuidePtIndex, curPtInInchesX, curPtInInchesY, curPtInInchesZ);
    auto jj = nlohmann::json::parse(std::wstring(deltaInWorkingInfo));
    auto deltaInWorking = jj.get<SAMeasGuidePointDeltaInWorking>();

    foo.Format(_T("Delta = %lf, %lf, %lf"), deltaInWorking.DeltaXInches, deltaInWorking.DeltaYInches, deltaInWorking.DeltaZInches);
    DeltaInWorking = foo.GetString();

    foo.Format(_T("Delta Mag = %lf"), deltaInWorking.DeltaMag);
    DeltaMagnitude = foo.GetString();

    // If the current live point is what is desired, then send to SA as measurement, else Update

    // Set Flags Parameter to indicate what parameters are valid (besides current point)
    unsigned short flags = (unsigned short)(VALID_UNCERT_PARAM | VALID_PROBEDIR_PARAM);

    // 
    // Example Update sending here
    m_pipelineSDK.UpdateSinglePoint(curPtInInchesX, curPtInInchesY, curPtInInchesZ,
        xUncert, yUncert, zUncert, xProbeDir, yProbeDir, zProbeDir, ProbeRadius, ProbeRadius, flags);
    Sleep(1500);
    curPtInInchesX += 10;
    curPtInInchesY += 20;
    curPtInInchesZ += 30;
    m_pipelineSDK.UpdateSinglePoint(curPtInInchesX, curPtInInchesY, curPtInInchesZ, xUncert, yUncert, zUncert, xProbeDir, yProbeDir, zProbeDir, ProbeRadius, ProbeRadius, flags);
    Sleep(1500);
    curPtInInchesX += 10;
    curPtInInchesY += 20;
    curPtInInchesZ += 30;
    m_pipelineSDK.UpdateSinglePoint(curPtInInchesX, curPtInInchesY, curPtInInchesZ, xUncert, yUncert, zUncert, xProbeDir, yProbeDir, zProbeDir, ProbeRadius, ProbeRadius, flags);
    Sleep(1500);
    curPtInInchesX += 10;
    curPtInInchesY += 20;
    curPtInInchesZ += 30;

    // Example Sending Measurement Here...
    std::string collection = "";
    std::string group = guideGroup.Points[activeGuidePtIndex].Group;
    std::string target = guideGroup.Points[activeGuidePtIndex].Target;
    if (!guideGroup.GroupSuffix.empty())
    {
        group += guideGroup.GroupSuffix;
    }
    if (!guideGroup.TargetSuffix.empty())
    {
        target += guideGroup.TargetSuffix;
    }
    CString c(collection.c_str());
    CString g(group.c_str());
    CString t(target.c_str());
    m_pipelineSDK.SendSinglePoint(c, g, t,
        curPtInInchesX, curPtInInchesY, curPtInInchesZ, xUncert, yUncert, zUncert, xProbeDir, yProbeDir, zProbeDir, ProbeRadius, ProbeRadius, flags);

    // Time to move on to the next
    activeGuidePtIndex++;

    //
    // If no more points to guide and measure, turn off Servo Mode.
    //
    m_pipelineSDK.EndGuidedPointServoView();
}

// Event Handler Invoked whenever instrument transform has changed within Spatial Analyzer
void CTestSdkQSDlg::Pipeline_OnInstToWorkingTransformChanged(LPCTSTR workingFrameName, LPCTSTR jsonTransform, double instrumentScaleFactor)
{
    // https://github.com/nlohmann/json
    // create an empty structure (null)
    CString foo(jsonTransform);
    ::std::wstring des(foo.GetString());
    nlohmann::json jdata;
    jdata = nlohmann::json::parse(des);
    auto T = jdata.get<std::array<std::array<double, 4>, 4>>();
}

void CTestSdkQSDlg::TestFitProfile()
{
        BOOL bSendStatus = FALSE;
        if (!m_SDKConnected)
            return;

        m_NRKSdkQS.SetStep(_T("Make Circle Fit Profile"));
        m_NRKSdkQS.SetStringArg(_T("Fit Profile Name"), _T("My SDK Fit Profile"));
        // Available options: 
        // "Inside", "Probe Center", "Outside", 
        m_NRKSdkQS.SetMeasuredSideForRadialOffsetArg(_T("Measured Side for Radial Offset"), _T("Inside"));
        m_NRKSdkQS.SetDoubleArg(_T("Override Radial Offset (-1.0 use current)"), -1.000000);
        // Available options: 
        // "Above Plane", "Probe Center", "Below Plane", 
        m_NRKSdkQS.SetMeasuredSideForPlanarOffsetArg(_T("Measured Side for Planar Offset"), _T("Below Plane"));
        m_NRKSdkQS.SetDoubleArg(_T("Override Planar Offset (-1.0 use current)"), -1.000000);
        // Available options: 
        // "Probing Direction", "Working Origin Positive", "Right Hand Rule", 
        m_NRKSdkQS.SetNormalDirectionArg(_T("Planar Offset Direction"), _T("Right Hand Rule"));
        m_NRKSdkQS.SetDoubleArg(_T("Lock Radius (-1.0 do not lock)"), -1.000000);
        // Available options: 
        // "Standard", "Max Inscribed", "Min Circumscribed", 
        m_NRKSdkQS.SetCompTechniqueArg(_T("Circle Computation Technique"), _T("Max Inscribed"));
        m_NRKSdkQS.SetBoolArg(_T("Reverse Normal Vector after fit?"), FALSE);
        m_NRKSdkQS.SetBoolArg(_T("Make Cardinal Points?"), TRUE);
        m_NRKSdkQS.SetBoolArg(_T("Cardinal Pt.1: Center?"), TRUE);
        m_NRKSdkQS.SetBoolArg(_T("Cardinal Pt.2: Point on Normal?"), TRUE);
        bSendStatus = m_NRKSdkQS.ExecuteStep();
        if (bSendStatus)
        {
            LONG rCode;
            m_NRKSdkQS.GetMPStepResult(&rCode);
            if (rCode == DoneSuccess)
            {
                TRACE(_T("Make Circle Fit Profile success\n"));
            }
            else
                TRACE(_T("Make Circle Fit Profile failure\n"));
        }

        AfxMessageBox(_T("Make Circle Fit Profile Step Complete"));
}


double fRand(double fMin, double fMax)
{
    double f = (double)rand() / RAND_MAX;
    return fMin + f * (fMax - fMin);
}

void CTestSdkQSDlg::RandomPointsTest()
{
    UpdateData(FALSE);

    // The number of points to be generated...
    int num = 1000;

    // x / y / z ranges...
    double xmin = -10.0;
    double ymin = -10.0;
    double zmin = -10.0;
    double xmax = 10.0;
    double ymax = 10.0;
    double zmax = 10.0;

    CString pointCol = m_collection;
    if (pointCol.IsEmpty())
        pointCol = _T("Test");
    CString pointGrp = m_group;
    if (pointGrp.IsEmpty())
        pointGrp = _T("Tester");
    CString pointTgt = m_target;
    if (pointTgt.IsEmpty())
        pointTgt = _T("Unused");

    double probeRadius = m_probeRadius;
    if (probeRadius == 0.)
    {
        probeRadius = 0.25;
    }

    // Test specifying individual point names
    bool bTestPointNaming = true;
    CString nameEven = _T("Scooby");
    CString nameOdd = _T("Shaggy");

    DWORD TimeStart = ::GetTickCount();
    int iterations = 10;
    for (int i = 0; i < iterations; i++)
    {
        double x, y, z;
        double xdiff, ydiff, zdiff;
        for (int ii = 0; ii < num; ii++)
        {
            x = fRand(xmin, xmax);
            y = fRand(ymin, ymax);
            z = fRand(zmin, zmax);
            if (!bTestPointNaming)
                m_pipelineSDK.AddMeasurement(x, y, z, 0.0, 0.0, 0.0);
            else
            {
                CString pointName;
                if ((ii == 0) || ((ii % 2) == 0))
                {
                    pointName.Format(_T("%s%d"), nameEven, ii);
                }
                else
                {
                    pointName.Format(_T("%s%d"), nameOdd, ii);
                }
                m_pipelineSDK.AddNamedMeasurement(pointName, x, y, z, 0.0, 0.0, 0.0, 0);
            }
        }

        m_pipelineSDK.SendMeasurements(pointCol, pointGrp, pointTgt, probeRadius, probeRadius);
        m_pipelineSDK.ClearMeasurements();
    }
    DWORD TimeStop = ::GetTickCount();
    DWORD Duration = TimeStop - TimeStart;
    {
        CString msg;
        msg.Format(_T("SendMeasurements %dX in Points Duration (MS): %d"), iterations, Duration);
        //TRACE1("Construct Point ALL Duration (MS): %d\n", Duration);
        AfxMessageBox(msg);
        MessageBeep(-1);
    }
}

void CTestSdkQSDlg::RandomCloudPointsTest()
{
    UpdateData(FALSE);

    // The number of points to be generated...
    int num = 10000;

    // x / y / z ranges...
    double xmin = -10.0;
    double ymin = -10.0;
    double zmin = -10.0;
    double xmax = 10.0;
    double ymax = 10.0;
    double zmax = 10.0;

    double x, y, z;
    double xdiff, ydiff, zdiff;
    for (int i = 0; i < num; i++)
    {
        x = fRand(xmin, xmax);
        y = fRand(ymin, ymax);
        z = fRand(zmin, zmax);
        m_pipelineSDK.AddCloudPoint(x, y, z);
    }

    CString cloudCol = _T("Test");
    CString cloudName = _T("TestCloud");

    m_pipelineSDK.SendCloud(cloudName, cloudCol);
    m_pipelineSDK.ClearCloud();
}

void CTestSdkQSDlg::FrameTest()
{
    UpdateData(FALSE);

    double xmin = -100.0;
    double ymin = -100.0;
    double zmin = -100.0;
    double xmax = 100.0;
    double ymax = 100.0;
    double zmax = 100.0;

    double x, y, z;
    x = fRand(xmin, xmax);
    y = fRand(ymin, ymax);
    z = fRand(zmin, zmax);

    double Rxmin = 0;
    double Rymin = 0;
    double Rzmin = 0;
    double Rxmax = 90.0;
    double Rymax = 90.0;
    double Rzmax = 90.0;

    double Rxval, Ryval, Rzval;
    Rxval = fRand(Rxmin, Rxmax);
    Ryval = fRand(Rymin, Rymax);
    Rzval = fRand(Rzmin, Rzmax);

    CString frameCol = m_frameCollection;
    if (frameCol.IsEmpty())
        frameCol = _T("Test");
    CString frameName = m_frameName;
    if (frameName.IsEmpty())
        frameName = _T("TestFrame");
    
    m_pipelineSDK.FrameUpdateToSA(frameCol, frameName, x, y, z, Rxval, Ryval, Rzval, false);
}

/// <summary>
/// Classes below MUST be used for communicating trans/track point information
///  to Spatial Analyzer via JSON.
/// </summary>
class SAPoint
{
public:
    SAPoint()
    {

    }

    std::string PointName;

    double x;
    double y;
    double z;
};

static void to_json(nlohmann::json& j, const SAPoint& s)
{
    j["PointName"] = s.PointName;
    j["x"] = s.x;
    j["y"] = s.y;
    j["z"] = s.z;
}

class SATrackingPointSet
{
public:
    SATrackingPointSet()
    {

    }
    std::vector<SAPoint> Pts;
};

static void to_json(nlohmann::json& j, const SATrackingPointSet& s)
{
    j["Pts"] = s.Pts;
}

void CTestSdkQSDlg::TrackingTest()
{
    double xmin = -40.0;
    double ymin = -40.0;
    double zmin = -40.0;
    double xmax = 40.0;
    double ymax = 40.0;
    double zmax = 40.0;

    // NOTE: Must Use SATrackingPointSet as shown below for SendPointSetTracking
    auto test = *new SATrackingPointSet();
    auto pt = *new SAPoint();
    pt.PointName = "Cool Test #1";
    pt.x = fRand(xmin, xmax);
    pt.y = fRand(ymin, ymax);
    pt.z = fRand(zmin, zmax);
    test.Pts.push_back(pt);
    pt = *new SAPoint();
    pt.PointName = "Cool Test #2";
    pt.x = fRand(xmin, xmax);
    pt.y = fRand(ymin, ymax);
    pt.z = fRand(zmin, zmax);
    test.Pts.push_back(pt);
    pt = *new SAPoint();
    pt.PointName = "Cool Test #3";
    pt.x = fRand(xmin, xmax);
    pt.y = fRand(ymin, ymax);
    pt.z = fRand(zmin, zmax);
    test.Pts.push_back(pt);

    // https://github.com/nlohmann/json
    // create an empty structure (null)
    nlohmann::json j;

    j = test;

    std::string foobar = j.dump();

    CString jsonPointObjects(foobar.c_str());

    // This is called from the instrument to SA to facilitate
    // trans-track with a group of points.  For photogrammetry systems, for example,
    // where you have a set of points you measure over and over.  The first call
    // SA gets when the SA mode is up establishes the nominal starting condition, then it moves from there.
    m_pipelineSDK.SendPointSetTracking(jsonPointObjects);
}

void CTestSdkQSDlg::OnBnClickedRandomMeasPoint()
{
    // Send Single Point
}


void CTestSdkQSDlg::OnBnClickedRandomMeasPoints()
{
    // Send many named points
    RandomPointsTest();
}


void CTestSdkQSDlg::OnBnClickedRandomCloud()
{
    // Send a cloud block
    RandomCloudPointsTest();
}


void CTestSdkQSDlg::OnBnClickedRandomFrame()
{
    FrameTest();
}

/// <summary>
/// Classes below MUST be used for communicating camera information
///  to Spatial Analyzer via JSON.
/// </summary>
struct InterfaceCamera
{
    int cameraId;

    double loc_x; // Inches
    double loc_y;
    double loc_z;
    double rot_x; // Degrees
    double rot_y;
    double rot_z;
};

static void to_json(nlohmann::json& j, const InterfaceCamera& s)
{
    j["cameraId"] = s.cameraId;
    j["loc_x"] = s.loc_x;
    j["loc_y"] = s.loc_y;
    j["loc_z"] = s.loc_z;
    j["rot_x"] = s.rot_x;
    j["rot_y"] = s.rot_y;
    j["rot_z"] = s.rot_z;
}

struct InterfaceCameras
{
    std::vector<InterfaceCamera> Cameras;
};

static void to_json(nlohmann::json& j, const InterfaceCameras& s)
{
    j["Cameras"] = s.Cameras;
}

void CTestSdkQSDlg::OnBnClickedCameraUpdate()
{
    // NOTE: Must Use InterfaceCameras as shown below for UpdateCameraTransforms
    InterfaceCameras pipelineCameraList;

    InterfaceCamera& camera = *new InterfaceCamera;
    camera.cameraId = 0;
    camera.loc_x = 10;
    camera.loc_y = 20;
    camera.loc_z = 30;
    camera.rot_x = 5;
    camera.rot_y = 10;
    camera.rot_z = 15;
    pipelineCameraList.Cameras.push_back(camera);
    InterfaceCamera& camera2 = *new InterfaceCamera;
    camera2.cameraId = 1;
    camera2.loc_x = 20;
    camera2.loc_y = 30;
    camera2.loc_z = 40;
    camera2.rot_x = 10;
    camera2.rot_y = 20;
    camera2.rot_z = 30;
    pipelineCameraList.Cameras.push_back(camera2);
    InterfaceCamera& camera3 = *new InterfaceCamera;
    camera3.cameraId = 2;
    camera3.loc_x = 30;
    camera3.loc_y = 40;
    camera3.loc_z = 50;
    camera3.rot_x = 25;
    camera3.rot_y = 30;
    camera3.rot_z = 45;
    pipelineCameraList.Cameras.push_back(camera3);

    // https://github.com/nlohmann/json
    // create an empty structure (null)
    nlohmann::json j;

    j = pipelineCameraList;

    std::string foobar = j.dump();

    CString jsonCameraObjects(foobar.c_str());
    m_pipelineSDK.UpdateCameraTransforms(jsonCameraObjects);
}


void CTestSdkQSDlg::OnBnClickedTracking()
{
    TrackingTest();
}
