
// TestSdkQS.cpp : Defines the class behaviors for the application.
//

#include "pch.h"
#include "framework.h"
#include "TestSdkQS.h"
#include "TestSdkQSDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CTestSdkQSApp

BEGIN_MESSAGE_MAP(CTestSdkQSApp, CWinApp)
	ON_COMMAND(ID_HELP, &CWinApp::OnHelp)
END_MESSAGE_MAP()

CString EnsureLongPath(LPCTSTR path)
{
	CString result;

	ASSERT(path != NULL);
	if (path == NULL)
		return result;
	result = path;

	_TCHAR buf[MAX_PATH + 1];
	ZeroMemory(buf, sizeof(_TCHAR) * (MAX_PATH + 1));
	if (GetLongPathName(path, buf, MAX_PATH) != 0)
	{
		buf[MAX_PATH] = 0;
		result = buf;
	}

	return result;
}


// CTestSdkQSApp construction

CTestSdkQSApp::CTestSdkQSApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}


// The one and only CTestSdkQSApp object

CTestSdkQSApp theApp;

const GUID CDECL BASED_CODE _tlid =
		{0x57c07e37,0xfecb,0x4fe0,{0x82,0x9a,0xf8,0x4b,0xfc,0x87,0x35,0xa2}};
const WORD _wVerMajor = 1;
const WORD _wVerMinor = 0;


// CTestSdkQSApp initialization

BOOL CTestSdkQSApp::InitInstance()
{
	InitCommonControls();

	CWinApp::InitInstance();

	if (!AfxSocketInit())
	{
		AfxMessageBox(IDP_SOCKETS_INIT_FAILED);
		return FALSE;
	}

	// Initialize OLE libraries
	if (!AfxOleInit())
	{
		AfxMessageBox(IDP_OLE_INIT_FAILED);
		return FALSE;
	}

	AfxEnableControlContainer();

	// Create the shell manager, in case the dialog contains
	// any shell tree view or shell list view controls.
	CShellManager *pShellManager = new CShellManager;

	// Activate "Windows Native" visual manager for enabling themes in MFC controls
	CMFCVisualManager::SetDefaultManager(RUNTIME_CLASS(CMFCVisualManagerWindows));

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	// of your final executable, you should remove from the following
	// the specific initialization routines you do not need
	// Change the registry key under which our settings are stored
	// TODO: You should modify this string to be something appropriate
	// such as the name of your company or organization
	SetRegistryKey(_T("New River Kinematics"));

	CString Path(m_pszHelpFilePath);
	int slash = Path.ReverseFind('\\');
	ProgramDirectory = Path.Left(slash);
	ProgramDirectory += _T("\\");
	CString _PD = EnsureLongPath(ProgramDirectory);
	ProgramDirectory = _PD;


	// Parse command line for automation or reg/unreg switches.
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	// App was launched with /Embedding or /Automation switch.
	// Run app as automation server.
	if (cmdInfo.m_bRunEmbedded || cmdInfo.m_bRunAutomated)
	{
		// Register class factories via CoRegisterClassObject().
		COleTemplateServer::RegisterAll();
	}
	// App was launched with /Unregserver or /Unregister switch.  Remove
	// entries from the registry.
	else if (cmdInfo.m_nShellCommand == CCommandLineInfo::AppUnregister)
	{
		COleObjectFactory::UpdateRegistryAll(FALSE);
		AfxOleUnregisterTypeLib(_tlid, _wVerMajor, _wVerMinor);
		return FALSE;
	}
	// App was launched standalone or with other switches (e.g. /Register
	// or /Regserver).  Update registry entries, including typelibrary.
	else
	{
		COleObjectFactory::UpdateRegistryAll();
		AfxOleRegisterTypeLib(AfxGetInstanceHandle(), _tlid);
		if (cmdInfo.m_nShellCommand == CCommandLineInfo::AppRegister)
			return FALSE;
	}

	CTestSdkQSDlg dlg;
	m_pMainWnd = &dlg;
	INT_PTR nResponse = dlg.DoModal();
	if (nResponse == IDOK)
	{
		// TODO: Place code here to handle when the dialog is
		//  dismissed with OK
	}
	else if (nResponse == IDCANCEL)
	{
		// TODO: Place code here to handle when the dialog is
		//  dismissed with Cancel
	}
	else if (nResponse == -1)
	{
		TRACE(traceAppMsg, 0, "Warning: dialog creation failed, so application is terminating unexpectedly.\n");
		TRACE(traceAppMsg, 0, "Warning: if you are using MFC controls on the dialog, you cannot #define _AFX_NO_MFC_CONTROLS_IN_DIALOGS.\n");
	}

	// Delete the shell manager created above.
	if (pShellManager != nullptr)
	{
		delete pShellManager;
	}

#if !defined(_AFXDLL) && !defined(_AFX_NO_MFC_CONTROLS_IN_DIALOGS)
	ControlBarCleanUp();
#endif

	// Since the dialog has been closed, return FALSE so that we exit the
	//  application, rather than start the application's message pump.
	return FALSE;
}

int CTestSdkQSApp::ExitInstance()
{
	AfxOleTerm(FALSE);

	return CWinApp::ExitInstance();
}
