/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.JarURLConnection;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.swing.JFrame;
import smx.ftp.Ftp;
import smx.ftp.FtpAbortedException;
import smx.ftp.FtpAlreadyConnectedException;
import smx.ftp.FtpBusyException;
import smx.ftp.FtpException;
import smx.ftp.FtpIOException;
import smx.ftp.FtpNoResponseException;
import smx.ftp.FtpNotConnectedException;
import smx.ftp.FtpOutOfPortsException;
import smx.tracker.ADMOnly;
import smx.tracker.AbortedException;
import smx.tracker.AdaptiveFilter;
import smx.tracker.AdaptiveFilterInternal;
import smx.tracker.AirExtTemp;
import smx.tracker.Alarm;
import smx.tracker.AlarmType;
import smx.tracker.AlreadyConnectedException;
import smx.tracker.ApplicationFailedException;
import smx.tracker.ApplicationResults;
import smx.tracker.AsyncMsg;
import smx.tracker.AverageFilter;
import smx.tracker.BadCommandException;
import smx.tracker.Change;
import smx.tracker.CommunicationException;
import smx.tracker.ConnectFailedException;
import smx.tracker.ContinueTrigger;
import smx.tracker.CustomPortsException;
import smx.tracker.DataFormatException;
import smx.tracker.DataTag;
import smx.tracker.DataTagDouble;
import smx.tracker.DataTagUnsigned16;
import smx.tracker.DataTagUnsigned32;
import smx.tracker.DataTagUnsigned8;
import smx.tracker.DeviationAlarm;
import smx.tracker.DeviceLockedException;
import smx.tracker.Diagnostic;
import smx.tracker.DisconnectFailedException;
import smx.tracker.DistanceMode;
import smx.tracker.DistanceSetException;
import smx.tracker.DistanceTrigger;
import smx.tracker.DoubleFaultException;
import smx.tracker.ExtTempType;
import smx.tracker.ExternalContinueTrigger;
import smx.tracker.ExternalStartTrigger;
import smx.tracker.FileAccessException;
import smx.tracker.Filter;
import smx.tracker.HardwareNotInstalledException;
import smx.tracker.HighAlarm;
import smx.tracker.InterfaceBusyException;
import smx.tracker.InterferometerOnly;
import smx.tracker.InterferometerSetByADM;
import smx.tracker.InternalDeviceFailureException;
import smx.tracker.InternalTrackerException;
import smx.tracker.IntervalTrigger;
import smx.tracker.LaserStateException;
import smx.tracker.LevelData;
import smx.tracker.LowAlarm;
import smx.tracker.MPEResultsData;
import smx.tracker.MaterialExtTemp;
import smx.tracker.MaterialTemperatureData;
import smx.tracker.MeasureCfg;
import smx.tracker.MeasureData;
import smx.tracker.MeasurePointData;
import smx.tracker.MeasurePointStdDev;
import smx.tracker.MeasureStdDev;
import smx.tracker.MirrorTargetType;
import smx.tracker.MotorStateException;
import smx.tracker.NoDataAvailableException;
import smx.tracker.NoResponseException;
import smx.tracker.NoTargetException;
import smx.tracker.NotConnectedException;
import smx.tracker.NullAlarm;
import smx.tracker.NullContinueTrigger;
import smx.tracker.NullExtTemp;
import smx.tracker.NullFilter;
import smx.tracker.NullStartTrigger;
import smx.tracker.PermissionException;
import smx.tracker.PrintException;
import smx.tracker.Probe;
import smx.tracker.ProbeCalibrationData;
import smx.tracker.ProbeCompHistoryData;
import smx.tracker.ProbeCompensationData;
import smx.tracker.RequestException;
import smx.tracker.SMRTargetType;
import smx.tracker.SimplePointPairData;
import smx.tracker.StartTrigger;
import smx.tracker.Status;
import smx.tracker.StdDevFilter;
import smx.tracker.TargetType;
import smx.tracker.Tracker;
import smx.tracker.TrackerApp;
import smx.tracker.TrackerException;
import smx.tracker.TrackerInterface;
import smx.tracker.TrackingStateException;
import smx.tracker.UnsupportedFeatureException;
import smx.tracker.UserSpecifiedDistance;
import smx.tracker.VideoCfg;
import smx.tracker.VideoData;
import smx.tracker.WeatherInformation;
import smx.tracker.WindowedSMRTargetType;
import smx.utility.PortUtility;
import smx.utility.TrkDatagramSocket;
import smx.utility.UtilityOutOfPortsException;

public class TrackerKeystone
implements TrackerInterface {
    private Ftp ftpClient = null;
    private LinkedList maintainApp = null;
    private String fileDirectory = "";
    private int[] measureTypeList = null;
    private boolean generalMeasureFlag = false;
    private boolean readInProgress = false;
    private Filter measureFilter = null;
    private int[] bkndMeasureTypeList = null;
    private boolean bkndReadInProgress = false;
    private boolean bkndGeneralMeasureFlag = false;
    private Filter bkndMeasureFilter = null;
    private int[] factoryBkndMeasureTypeList = null;
    private boolean factoryBkndReadInProgress = false;
    private boolean factoryBkndGeneralMeasureFlag = false;
    private Filter factoryBkndMeasureFilter = null;
    private boolean cmdInProgress = false;
    private String ipAddressToUse = null;
    private DatagramSocket dgSocket = null;
    private DatagramSocket bkndDgSocket = null;
    private DatagramSocket asyncSocket = null;
    private DatagramSocket factoryBkndDgSocket = null;
    private DatagramPacket packet = null;
    private DatagramPacket bkndPacket = null;
    private DatagramPacket asyncPacket = null;
    private DatagramPacket factoryBkndPacket = null;
    private final int DATAGRAM_SOCKET_TIMEOUT = 5000;
    private byte[] buf = null;
    private byte[] bkndBuf = null;
    private byte[] asyncBuf = null;
    private byte[] factoryBkndBuf = null;
    private BufferedReader asyncInput = null;
    private boolean asyncReadInProgress = false;
    private boolean asyncReadInterrupted = false;
    private int accessLevel = 0;
    private boolean isADMCapable = false;
    private boolean isLevelCapable = false;
    private boolean isIFMCapable = false;
    private boolean isADMOnlyCapable = false;
    private boolean isADMScanCapable = false;
    private boolean is_1_5_WindowedSMRTargetCapable = false;
    private boolean is_7_8_WindowedSMRTargetCapable = false;
    private boolean isResultReportCapable = false;
    private boolean isAdaptiveFilterCapable = false;
    private static final int UNSIGNED8 = 1;
    private static final int UNSIGNED16 = 2;
    private static final int UNSIGNED32 = 3;
    private static final int DOUBLE = 4;
    private static final int ACCESS_STANDARD = 0;
    private static final int ACCESS_ADMIN = 1;
    private static final int ACCESS_FACTORY = 2;
    private static final int JAR_FROM_TRACKER = 0;
    private static final int JAR_FROM_LOCAL = 1;
    private DataTag[] pointMeasurementTags = new DataTag[6];
    private boolean measureInProgress = false;
    private boolean bkndMeasureInProgress = false;
    private boolean factoryBkndMeasureInProgress = false;
    private MeasureCfg oldmeasureCfg = null;
    private DataTag[] oldmeasureTags = null;
    private int[] oldmeasureTypeList = null;
    private MeasureCfg oldbkndMeasureCfg = null;
    private DataTag[] oldbkndMeasureTags = null;
    private int[] oldbkndMeasureTypeList = null;
    private MeasureCfg oldfactoryBkndMeasureCfg = null;
    private DataTag[] oldfactoryBkndMeasureTags = null;
    private int[] oldfactoryBkndMeasureTypeList = null;
    private long MCUVersionNumber = 0L;
    private JarClassLoader jarClassLoader = null;
    private Map jarCache = Collections.synchronizedMap(new HashMap(500));
    private boolean factoryConnect = false;
    private boolean factoryDisconnect = false;
    private boolean JRE16 = false;
    ArrayList tmpDownloadedJarsPath = new ArrayList(10);
    Random generator = new Random();
    PortUtility portUtility;
    TrkDatagramSocket trkAsyncDgSocket = null;
    TrkDatagramSocket trkForeGndDgSocket = null;
    TrkDatagramSocket trkBackGndDgSocket = null;
    TrkDatagramSocket trkFactoryBackGndDgSocket = null;
    private static final int[] diagMap = new int[]{0, 8, 8, 8, 8, 8, 1, 4, 5, 8, 8, 3, 6, 8};
    private static final int[] changeMap = new int[]{0, 2, 1, 4, 3};
    private static final int[] statusMap = new int[]{0, 1, 2, 21, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 18, 16, 17, 19, 20, 0, 22, 23, 24};
    private static final int FILE_XFER_BUFFER_SIZE = 1200;
    private static final int TRACKER_SAMPLES_PER_SECOND = 1024;
    private static final int TRACKER_COMMAND_MIN_TIME_OUT = 15000;
    private static final double MAX_AIR_PRESSURE_VALUE = 900.0;
    private static final double MIN_AIR_PRESSURE_VALUE = 225.0;
    private static final double MAX_AIR_TEMP_VALUE = 60.0;
    private static final double MIN_AIR_TEMP_VALUE = -20.0;
    private static final double MAX_HUMIDITY_VALUE = 100.0;
    private static final double MIN_HUMIDITY_VALUE = 0.0;
    private static final int SAVE_CFG_SLEEP_TIME = 10000;
    private boolean initialLocalAppValueSet = false;
    private boolean loadingLocalApp = false;
    private boolean performanceParametersSetForTracker = false;
    private double admMPEOffset = 0.0;
    private double admMPEScale = 0.0;
    private double transverseMPEOffset = 0.0;
    private double transverseMPEScale = 0.0;

    public TrackerKeystone() {
        this.pointMeasurementTags[0] = new DataTagDouble("target.corrected.azimuth.value");
        this.pointMeasurementTags[1] = new DataTagUnsigned16("target.corrected.azimuth.status");
        this.pointMeasurementTags[2] = new DataTagDouble("target.corrected.zenith.value");
        this.pointMeasurementTags[3] = new DataTagUnsigned16("target.corrected.zenith.status");
        this.pointMeasurementTags[4] = new DataTagDouble("target.corrected.distance.value");
        this.pointMeasurementTags[5] = new DataTagUnsigned16("target.corrected.distance.status");
    }

    private boolean isUsingJRE16() {
        boolean bl = false;
        String string = System.getProperty("java.version").substring(0, 3);
        int n = Integer.parseInt(string.substring(0, 1));
        int n2 = Integer.parseInt(string.substring(2));
        if (n > 1) {
            bl = true;
        } else if (n == 1) {
            bl = n2 >= 6;
        }
        return bl;
    }

    @Override
    public synchronized void connect(String string, String string2, String string3) throws TrackerException {
        ConnectFailedException connectFailedException = null;
        if (this.ftpClient != null) {
            throw new AlreadyConnectedException();
        }
        try {
            this.trkAsyncDgSocket = new TrkDatagramSocket(this.portUtility);
            this.trkForeGndDgSocket = new TrkDatagramSocket(this.portUtility);
            this.trkBackGndDgSocket = new TrkDatagramSocket(this.portUtility);
            this.trkFactoryBackGndDgSocket = new TrkDatagramSocket(this.portUtility);
            if (-1 == string.indexOf(46) || !Tracker.isUserParameterValidIPAddress(string)) {
                string = Tracker.checkAndGetIPAddress(string, "TrackerKeystone");
            }
            this.ftpClient = new Ftp(this.portUtility);
            this.ftpClient.connect(string, string2, string3);
            this.ipAddressToUse = string;
            this.jarClassLoader = new JarClassLoader();
        }
        catch (FtpException ftpException) {
            this.ftpClient = null;
            if (ftpException instanceof FtpOutOfPortsException) {
                throw new ConnectFailedException(Tracker.res.getString("Out_Of_Ports"));
            }
            throw new ConnectFailedException(ftpException.toString());
        }
        this.JRE16 = this.isUsingJRE16();
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("system.version.mcu_firmware.num.value")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        this.MCUVersionNumber = (Long)objectArray[0];
        if (!this.JRE16 || this.MCUVersionNumber >> 24 < 5L) {
            // empty if block
        }
        try {
            Object[] objectArray2;
            DataTag[] dataTagArray2;
            Object[] objectArray3;
            this.setAccessLevel(string2);
            this.setAppInfo();
            this.isADMOnlyCapable = false;
            if (this.isADMCapable && (Long)(objectArray3 = this.readOneTimeData(dataTagArray2 = new DataTag[]{new DataTagUnsigned32("system.adm_alignment.value")}))[0] == 1L) {
                this.isADMOnlyCapable = true;
            }
            this.isADMScanCapable = false;
            dataTagArray2 = new DataTag[1];
            long l = 0x3000000L;
            if (this.MCUVersionNumber > l && this.isADMCapable) {
                dataTagArray2[0] = new DataTagUnsigned32("position_device.adm.velocity_comp_flag");
                objectArray3 = this.readOneTimeData(dataTagArray2);
                if (1L == (Long)objectArray3[0]) {
                    this.isADMScanCapable = true;
                }
            }
            this.is_1_5_WindowedSMRTargetCapable = false;
            long l2 = 0x3020000L;
            if (this.MCUVersionNumber > l2) {
                this.is_1_5_WindowedSMRTargetCapable = true;
            }
            this.is_7_8_WindowedSMRTargetCapable = false;
            long l3 = 0x5030000L;
            if (this.MCUVersionNumber > l3) {
                this.is_7_8_WindowedSMRTargetCapable = true;
            }
            this.isResultReportCapable = false;
            DataTag[] dataTagArray3 = new DataTag[]{new DataTagUnsigned32("system.aim_it.result.value")};
            try {
                objectArray2 = this.readOneTimeData(dataTagArray3);
                this.isResultReportCapable = true;
            }
            catch (TrackerException trackerException) {
                this.isResultReportCapable = false;
            }
            this.readOneTimeData(new DataTag[]{new DataTagDouble("system.spec.ifm.offset.status")});
            this.isAdaptiveFilterCapable = false;
            dataTagArray3[0] = new DataTagUnsigned32("system.serial_type.value");
            objectArray2 = this.readOneTimeData(dataTagArray3);
            long l4 = (Long)objectArray2[0];
            if (0L != (l4 & 0x40L)) {
                this.isAdaptiveFilterCapable = true;
            } else {
                dataTagArray3[0] = new DataTagUnsigned32("position_device.zenith_encoder.head3.input.sin.value");
                try {
                    this.readOneTimeData(dataTagArray3);
                    this.isAdaptiveFilterCapable = true;
                }
                catch (TrackerException trackerException) {
                    this.isAdaptiveFilterCapable = false;
                }
            }
        }
        catch (ConnectFailedException connectFailedException2) {
            connectFailedException = connectFailedException2;
        }
        catch (TrackerException trackerException) {
            connectFailedException = trackerException instanceof CustomPortsException ? new ConnectFailedException(Tracker.res.getString("Out_Of_Ports")) : new ConnectFailedException(Tracker.res.getString("Could_Not_Obtain_Needed_Info"));
        }
        if (connectFailedException != null) {
            try {
                this.ftpClient.disconnect();
            }
            catch (FtpException ftpException) {
                // empty catch block
            }
            this.cleanupInterface();
            throw connectFailedException;
        }
    }

    private boolean checkTags(DataTag[] dataTagArray, DataTag[] dataTagArray2) {
        if (dataTagArray == null || dataTagArray2 == null) {
            return false;
        }
        if (dataTagArray.length != dataTagArray2.length) {
            return false;
        }
        for (int i = 0; i < dataTagArray2.length; ++i) {
            if (dataTagArray[i].getName().equals(dataTagArray2[i].getName())) continue;
            return false;
        }
        return true;
    }

    private boolean checkTypeList(int[] nArray, int[] nArray2) {
        if (nArray == null || nArray2 == null) {
            return false;
        }
        if (nArray.length != nArray2.length) {
            return false;
        }
        for (int i = 0; i < nArray2.length; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    private Object checkAndSendCFGData(MeasureCfg measureCfg, DataTag[] dataTagArray, boolean bl, boolean bl2, Ftp ftp, String string) throws TrackerException {
        int[] nArray = null;
        int[] nArray2 = null;
        MeasureCfg measureCfg2 = null;
        DataTag[] dataTagArray2 = null;
        int[] nArray3 = null;
        if (bl) {
            if (bl2) {
                measureCfg2 = this.oldfactoryBkndMeasureCfg;
                dataTagArray2 = this.oldfactoryBkndMeasureTags;
                nArray3 = this.oldfactoryBkndMeasureTypeList;
            } else {
                measureCfg2 = this.oldbkndMeasureCfg;
                dataTagArray2 = this.oldbkndMeasureTags;
                nArray3 = this.oldbkndMeasureTypeList;
            }
        } else {
            measureCfg2 = this.oldmeasureCfg;
            dataTagArray2 = this.oldmeasureTags;
            nArray3 = this.oldmeasureTypeList;
        }
        nArray2 = this.createTypeList(dataTagArray);
        if (measureCfg2 != null && this.checkTags(dataTagArray2, dataTagArray) && this.checkTypeList(nArray3, nArray2) && measureCfg2.getContinueTrigger().equals(measureCfg.getContinueTrigger()) && measureCfg.getFilter().equals(measureCfg2.getFilter()) && measureCfg2.getStartTrigger().equals(measureCfg.getStartTrigger()) && measureCfg2.getSamplesPerObservation() == measureCfg.getSamplesPerObservation()) {
            return null;
        }
        this.sendMeasureCfg(ftp, measureCfg, dataTagArray, string);
        nArray = nArray2;
        measureCfg2 = new MeasureCfg(measureCfg.getSamplesPerObservation(), measureCfg.getFilter(), measureCfg.getStartTrigger(), measureCfg.getContinueTrigger());
        dataTagArray2 = new DataTag[dataTagArray.length];
        for (int i = 0; i < dataTagArray.length; ++i) {
            if (dataTagArray[i] instanceof DataTagDouble) {
                dataTagArray2[i] = new DataTagDouble(dataTagArray[i].getName());
                continue;
            }
            if (dataTagArray[i] instanceof DataTagUnsigned16) {
                dataTagArray2[i] = new DataTagUnsigned16(dataTagArray[i].getName());
                continue;
            }
            if (dataTagArray[i] instanceof DataTagUnsigned32) {
                dataTagArray2[i] = new DataTagUnsigned32(dataTagArray[i].getName());
                continue;
            }
            if (dataTagArray[i] instanceof DataTagUnsigned8) {
                dataTagArray2[i] = new DataTagUnsigned8(dataTagArray[i].getName());
                continue;
            }
            throw new TrackerException(Tracker.res.getString("Unknown_DataTag_Type_Passed"));
        }
        nArray3 = nArray;
        if (bl) {
            if (bl2) {
                this.oldfactoryBkndMeasureCfg = measureCfg2;
                this.oldfactoryBkndMeasureTags = dataTagArray2;
                this.oldfactoryBkndMeasureTypeList = nArray3;
            } else {
                this.oldbkndMeasureCfg = measureCfg2;
                this.oldbkndMeasureTags = dataTagArray2;
                this.oldbkndMeasureTypeList = nArray3;
            }
        } else {
            this.oldmeasureCfg = measureCfg2;
            this.oldmeasureTags = dataTagArray2;
            this.oldmeasureTypeList = nArray3;
        }
        return nArray;
    }

    private void setAccessLevel(String string) throws TrackerException {
        if (string.equalsIgnoreCase("user")) {
            this.accessLevel = 0;
        } else if (string.equalsIgnoreCase("admin")) {
            this.accessLevel = 1;
        } else if (string.equalsIgnoreCase("factory") || string.equalsIgnoreCase("supervis")) {
            this.accessLevel = 2;
        } else {
            throw new ConnectFailedException(Tracker.res.getString("Invalid_User_Name"));
        }
    }

    @Override
    public int sampleRate() throws TrackerException {
        return 1024;
    }

    private void closeCachedJars() {
        Collection collection = this.jarCache.values();
        for (JarFile jarFile : collection) {
            try {
                jarFile.close();
            }
            catch (Exception exception) {
                PrintException.print(exception);
            }
        }
        this.jarCache.clear();
        if (this.tmpDownloadedJarsPath.size() > 0) {
            for (int i = 0; i < this.tmpDownloadedJarsPath.size(); ++i) {
                File file = new File((String)this.tmpDownloadedJarsPath.get(i));
                if (!file.exists()) continue;
                file.delete();
            }
            this.tmpDownloadedJarsPath.clear();
        }
    }

    private void cleanupInterface() throws TrackerException {
        this.ftpClient = null;
        this.closeCachedJars();
        this.jarClassLoader = null;
        this.measureTypeList = null;
        this.generalMeasureFlag = false;
        this.readInProgress = false;
        this.measureFilter = null;
        this.bkndMeasureTypeList = null;
        this.bkndReadInProgress = false;
        this.bkndGeneralMeasureFlag = false;
        this.bkndMeasureFilter = null;
        this.factoryBkndMeasureTypeList = null;
        this.factoryBkndReadInProgress = false;
        this.factoryBkndGeneralMeasureFlag = false;
        this.factoryBkndMeasureFilter = null;
        this.cmdInProgress = false;
        this.dgSocket = null;
        this.bkndDgSocket = null;
        this.asyncSocket = null;
        this.factoryBkndDgSocket = null;
        this.packet = null;
        this.bkndPacket = null;
        this.asyncPacket = null;
        this.factoryBkndPacket = null;
        this.buf = null;
        this.bkndBuf = null;
        this.asyncBuf = null;
        this.factoryBkndBuf = null;
        this.asyncInput = null;
        this.asyncReadInProgress = false;
        this.asyncReadInterrupted = false;
        this.accessLevel = 0;
        this.isADMCapable = false;
        this.isLevelCapable = false;
        this.isIFMCapable = false;
        this.isADMOnlyCapable = false;
        this.measureInProgress = false;
        this.bkndMeasureInProgress = false;
        this.factoryBkndMeasureInProgress = false;
        this.oldmeasureCfg = null;
        this.oldmeasureTags = null;
        this.oldbkndMeasureCfg = null;
        this.oldbkndMeasureTags = null;
        this.oldfactoryBkndMeasureCfg = null;
        this.oldfactoryBkndMeasureTags = null;
    }

    @Override
    public void disconnect() throws TrackerException {
        if (!this.isConnected()) {
            return;
        }
        try {
            this.clearAppInfo();
            this.ftpClient.disconnect();
            this.cleanupInterface();
        }
        catch (FtpIOException ftpIOException) {
            this.cleanupInterface();
        }
        catch (FtpNoResponseException ftpNoResponseException) {
            this.cleanupInterface();
        }
        catch (FtpException ftpException) {
            throw new DisconnectFailedException();
        }
    }

    private boolean isConnected() {
        return this.ftpClient != null;
    }

    private boolean isMeasuring() {
        return this.measureInProgress;
    }

    @Override
    public void trackerCommand(String string, int n) throws TrackerException {
        if (n < 15000) {
            n = 15000;
        }
        if (string.equalsIgnoreCase("savecfg")) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.executeTrackerCommand(string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTrackerCommand(String string, int n) throws TrackerException {
        try {
            TrackerKeystone trackerKeystone = this;
            synchronized (trackerKeystone) {
                this.readyForCommand();
                this.cmdInProgress = true;
            }
            int n2 = this.ftpClient.command(string, n);
            if (n2 != 200) {
                throw this.exceptionFromResponse(this.ftpClient, n2);
            }
        }
        catch (FtpException ftpException) {
            throw this.convertFtpExc(ftpException);
        }
        finally {
            TrackerKeystone trackerKeystone = this;
            synchronized (trackerKeystone) {
                this.cmdInProgress = false;
            }
        }
    }

    @Override
    public void initialize() throws TrackerException {
        this.initialize(true);
    }

    @Override
    public void initialize(boolean bl) throws TrackerException {
        if (!this.readyToInitialize(bl)) {
            throw new TrackerException(Tracker.res.getString("Tracker_Is_Not_Ready"));
        }
        this.trackerCommand("init", 180000);
    }

    @Override
    public void initializeSmart() throws TrackerException {
        this.initializeSmart(true);
    }

    @Override
    public void initializeSmart(boolean bl) throws TrackerException {
        if (!this.readyToInitialize(bl)) {
            throw new TrackerException(Tracker.res.getString("Tracker_Is_Not_Ready"));
        }
        if (this.MCUVersionNumber > 0x2060000L) {
            this.trackerCommand("init smart", 180000);
        } else {
            this.trackerCommand("init", 180000);
        }
    }

    @Override
    public void move(double d, double d2, double d3, boolean bl) throws TrackerException {
        String string = "move " + d + " " + d2 + " " + d3 + (bl ? " r" : " a");
        try {
            this.trackerCommand(string, 15000);
        }
        catch (NoTargetException noTargetException) {
            // empty catch block
        }
    }

    @Override
    public void move(double d, double d2, double d3, boolean bl, boolean bl2) throws TrackerException {
        String string = "move " + d + " " + d2 + " " + d3 + (bl2 ? " r" : " a") + (bl ? " b" : " f");
        try {
            this.trackerCommand(string, 15000);
        }
        catch (NoTargetException noTargetException) {
            // empty catch block
        }
    }

    @Override
    public void home(boolean bl) throws TrackerException {
        this.trackerCommand("home" + (bl ? " b" : ""), 120000);
    }

    @Override
    public void toggleSightOrientation() throws TrackerException {
        this.trackerCommand("backsight", 600000);
    }

    @Override
    public void search(double d, double d2) throws TrackerException {
        this.trackerCommand("fr " + d + " " + d2, 600000);
    }

    @Override
    public void search(double d, double d2, int n) throws TrackerException {
        if (n < 1000) {
            throw new TrackerException(Tracker.res.getString("Timeout_Out_Of_Bounds"));
        }
        this.executeTrackerCommand("fr " + d + " " + d2, n);
    }

    @Override
    public void search(double d, int n) throws TrackerException {
        if (n < 1000) {
            throw new TrackerException(Tracker.res.getString("Timeout_Out_Of_Bounds"));
        }
        this.executeTrackerCommand("fr " + d, n);
    }

    @Override
    public void search(double d) throws TrackerException {
        this.trackerCommand("fr " + d, 600000);
    }

    @Override
    public void changeMotorState(boolean bl) throws TrackerException {
        this.trackerCommand("motors " + (bl ? "on auto_adjust" : "off"), 6000);
    }

    @Override
    public void changeTrackingState(boolean bl) throws TrackerException {
        String string = "tracking " + (bl ? "on" : "off");
        this.trackerCommand(string, 6000);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void changeDistanceMeasureMode(DistanceMode distanceMode) throws TrackerException {
        if (distanceMode instanceof InterferometerOnly) {
            if (!this.isIFMCapable) throw new UnsupportedFeatureException(Tracker.res.getString("IFM_Not_Installed"));
            this.trackerCommand("dist_mode ifm", 6000);
            return;
        } else if (distanceMode instanceof ADMOnly) {
            if (!this.isADMOnlyCapable) throw new UnsupportedFeatureException(Tracker.res.getString("ADM_Not_Installed"));
            this.trackerCommand("dist_mode adm auto_adjust", 6000);
            return;
        } else if (distanceMode instanceof InterferometerSetByADM) {
            if (!this.isIFMCapable || !this.isADMCapable) throw new UnsupportedFeatureException(Tracker.res.getString("IFM_ADM_Not_Installed"));
            this.trackerCommand("dist_mode ifm/adm auto_adjust", 6000);
            return;
        } else {
            if (!(distanceMode instanceof UserSpecifiedDistance)) throw new UnsupportedFeatureException(Tracker.res.getString("Mode_Not_Supported"));
            this.trackerCommand("dist_mode user", 6000);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void changeTargetType(TargetType targetType) throws TrackerException {
        String string = "";
        if (targetType instanceof SMRTargetType) {
            SMRTargetType sMRTargetType = (SMRTargetType)targetType;
            double d = sMRTargetType.getDiameter();
            string = d >= 0.038 && d <= 0.0382 ? "smr_1_1/2" : (d >= 0.0126 && d <= 0.0128 ? "smr_1/2" : (d >= 0.0221 && d <= 0.0223 ? "smr_7/8" : "smr_user"));
        } else if (targetType instanceof WindowedSMRTargetType) {
            WindowedSMRTargetType windowedSMRTargetType = (WindowedSMRTargetType)targetType;
            double d = windowedSMRTargetType.getDiameter();
            if (this.is_1_5_WindowedSMRTargetCapable && d >= 0.038 && d <= 0.0382) {
                string = "smr_1_1/2_windowed";
            } else {
                if (!this.is_7_8_WindowedSMRTargetCapable || !(d >= 0.022224) || !(d <= 0.022226)) throw new UnsupportedFeatureException(Tracker.res.getString("Target_Type_Not_Supported"));
                string = "smr_7/8_windowed";
            }
        } else {
            if (!(targetType instanceof MirrorTargetType)) throw new UnsupportedFeatureException(Tracker.res.getString("Target_Type_Not_Supported"));
            string = "mirror";
        }
        this.trackerCommand("target " + string, 1000);
    }

    @Override
    public synchronized void abort() {
        try {
            if (this.cmdInProgress) {
                this.ftpClient.abort();
            }
        }
        catch (FtpException ftpException) {
            // empty catch block
        }
    }

    @Override
    public void startMeasure(MeasureCfg measureCfg, DataTag[] dataTagArray) throws TrackerException {
        this.localStartMeasure(measureCfg, dataTagArray, true);
    }

    private synchronized void localStartMeasure(MeasureCfg measureCfg, DataTag[] dataTagArray, boolean bl) throws TrackerException {
        this.readyForCommand();
        Object object = this.checkAndSendCFGData(measureCfg, dataTagArray, false, false, this.ftpClient, "\\data\\measure.arg");
        int n = this.receiveMeasurementData(this.ftpClient);
        if (n != 200) {
            throw this.exceptionFromResponse(this.ftpClient, n);
        }
        if (object != null) {
            this.measureTypeList = (int[])object;
            this.measureFilter = measureCfg.getFilter();
        }
        this.generalMeasureFlag = bl;
        this.measureInProgress = true;
    }

    private void readyForCommand() throws InterfaceBusyException, NotConnectedException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        if (this.isMeasuring() || this.cmdInProgress) {
            throw new InterfaceBusyException(Tracker.res.getString("Measure_Or_Cmd_In_Progress"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMeasureCfg(Ftp ftp, MeasureCfg measureCfg, DataTag[] dataTagArray, String string) throws TrackerException {
        int n;
        TrackerException trackerException = null;
        try {
            n = ftp.sendStart(string);
            if (n != 150) {
                throw this.exceptionFromResponse(ftp, n);
            }
        }
        catch (FtpException ftpException) {
            throw this.convertFtpExc(ftpException);
        }
        try {
            ftp.sendLine("maxobs=0");
            ftp.sendLine("nsamps=" + measureCfg.getSamplesPerObservation());
            this.sendStartTrigger(ftp, measureCfg);
            this.sendContinueTrigger(ftp, measureCfg);
            this.sendFilter(ftp, measureCfg);
            for (int i = 0; i < dataTagArray.length; ++i) {
                ftp.sendLine("tag=" + dataTagArray[i].getName());
            }
        }
        catch (FtpException ftpException) {
            trackerException = this.convertFtpExc(ftpException);
        }
        catch (TrackerException trackerException2) {
            trackerException = trackerException2;
        }
        finally {
            block22: {
                try {
                    n = ftp.sendEnd(10000);
                    if (n != 226 && trackerException == null) {
                        trackerException = this.exceptionFromResponse(ftp, n);
                    }
                }
                catch (FtpException ftpException) {
                    if (trackerException != null) break block22;
                    trackerException = this.convertFtpExc(ftpException);
                }
            }
        }
        if (trackerException != null) {
            throw trackerException;
        }
    }

    private int receiveMeasurementData(Ftp ftp) throws TrackerException {
        try {
            this.dgSocket = this.trkForeGndDgSocket.createSocket();
            this.dgSocket.setSoTimeout(5000);
            byte[] byArray = ftp.getIPAddress().getAddress();
            int n = this.dgSocket.getLocalPort();
            int[] nArray = new int[4];
            for (int i = 0; i < 4; ++i) {
                nArray[i] = byArray[i];
                if (nArray[i] >= 0) continue;
                int n2 = i;
                nArray[n2] = nArray[n2] + 256;
            }
            int n3 = ftp.command("measure " + nArray[0] + "," + nArray[1] + "," + nArray[2] + "," + nArray[3] + "," + n / 256 + "," + n % 256, 10000);
            return n3;
        }
        catch (SocketException socketException) {
            this.trkForeGndDgSocket.closeSocket();
            if (socketException instanceof UtilityOutOfPortsException) {
                throw new CustomPortsException(Tracker.res.getString("Out_Of_Ports"));
            }
            throw new CommunicationException(Tracker.res.getString("Measurement_Data_Exception"));
        }
        catch (FtpException ftpException) {
            this.trkForeGndDgSocket.closeSocket();
            throw this.convertFtpExc(ftpException);
        }
    }

    private void sendStartTrigger(Ftp ftp, MeasureCfg measureCfg) throws FtpException, TrackerException {
        StartTrigger startTrigger = measureCfg.getStartTrigger();
        if (startTrigger instanceof ExternalStartTrigger) {
            ftp.sendLine("start_type=digio");
            return;
        }
        if (startTrigger instanceof NullStartTrigger) {
            ftp.sendLine("start_type=nopause");
            return;
        }
        throw new UnsupportedFeatureException(Tracker.res.getString("Unknown_Start_Trigger"));
    }

    private void sendContinueTrigger(Ftp ftp, MeasureCfg measureCfg) throws FtpException, TrackerException {
        ContinueTrigger continueTrigger = measureCfg.getContinueTrigger();
        if (continueTrigger instanceof NullContinueTrigger) {
            ftp.sendLine("nth_type=noseq");
            return;
        }
        if (continueTrigger instanceof ExternalContinueTrigger) {
            ftp.sendLine("nth_type=digio");
            return;
        }
        if (continueTrigger instanceof IntervalTrigger) {
            ftp.sendLine("nth_type=time");
            ftp.sendLine("obsrate=" + ((IntervalTrigger)continueTrigger).getObservationRate());
            return;
        }
        if (continueTrigger instanceof DistanceTrigger) {
            ftp.sendLine("nth_type=distance");
            ftp.sendLine("distance=" + ((DistanceTrigger)continueTrigger).getDistance());
            return;
        }
        throw new UnsupportedFeatureException(Tracker.res.getString("Unknown_Continue_Trigger"));
    }

    private void sendFilter(Ftp ftp, MeasureCfg measureCfg) throws FtpException, TrackerException {
        Filter filter = measureCfg.getFilter();
        if (filter instanceof NullFilter) {
            ftp.sendLine("filter=none");
            return;
        }
        if (filter instanceof AverageFilter) {
            ftp.sendLine("filter=firstorder");
            return;
        }
        if (filter instanceof StdDevFilter) {
            ftp.sendLine("filter=stddev");
            return;
        }
        if (filter instanceof AdaptiveFilter) {
            if (!this.isAdaptiveFilterCapable) {
                throw new UnsupportedFeatureException(Tracker.res.getString("Adaptive_Filter_Not_Supported"));
            }
            ftp.sendLine("filter=adaptive");
            ftp.sendLine("sdm=" + ((AdaptiveFilter)filter).getSdm());
            int n = 65535;
            if (filter instanceof AdaptiveFilterInternal) {
                n = ((AdaptiveFilterInternal)filter).getStatusMask();
            }
            ftp.sendLine("statusmask=" + n);
            return;
        }
        throw new UnsupportedFeatureException(Tracker.res.getString("Unknown_Filter"));
    }

    private TrackerException exceptionFromResponse(Ftp ftp, int n) {
        String string;
        try {
            string = ftp.getLastResponse();
        }
        catch (FtpException ftpException) {
            return new CommunicationException(Tracker.res.getString("Unexpected_FTP_Exception_Last_Response"));
        }
        switch (n) {
            case 340: {
                return new RequestException(string);
            }
            case 453: {
                return new InternalDeviceFailureException(string);
            }
            case 450: 
            case 452: 
            case 454: 
            case 455: 
            case 456: 
            case 555: {
                return new InternalTrackerException(string);
            }
            case 421: 
            case 425: 
            case 428: 
            case 429: 
            case 520: 
            case 530: {
                return new CommunicationException(string);
            }
            case 550: {
                return new PermissionException(string);
            }
            case 552: 
            case 557: {
                return new FileAccessException(string);
            }
            case 556: 
            case 558: {
                return this.exceptionFromReason(string);
            }
            case 500: 
            case 501: 
            case 503: {
                return new BadCommandException(string);
            }
        }
        return new TrackerException(string);
    }

    private TrackerException convertFtpExc(FtpException ftpException) {
        try {
            throw ftpException;
        }
        catch (FtpAbortedException ftpAbortedException) {
            return new AbortedException();
        }
        catch (FtpAlreadyConnectedException ftpAlreadyConnectedException) {
            return new AlreadyConnectedException();
        }
        catch (FtpBusyException ftpBusyException) {
            return new InterfaceBusyException(Tracker.res.getString("FTP_Busy"));
        }
        catch (FtpNoResponseException ftpNoResponseException) {
            return new NoResponseException();
        }
        catch (FtpNotConnectedException ftpNotConnectedException) {
            return new NotConnectedException();
        }
        catch (FtpOutOfPortsException ftpOutOfPortsException) {
            return new CustomPortsException(Tracker.res.getString("Out_Of_Ports"));
        }
        catch (FtpException ftpException2) {
            return new CommunicationException(Tracker.res.getString("Unexpected_FTP_Exception"));
        }
    }

    private TrackerException exceptionFromReason(String string) {
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken();
        try {
            n = Integer.parseInt(string2, 16);
        }
        catch (NumberFormatException numberFormatException) {
            return new CommunicationException(Tracker.res.getString("FTP_Response_String_Not_In_Expected_Format"));
        }
        String string3 = Tracker.res.getString("Code") + ": " + n;
        switch (n) {
            case 1: {
                return new DeviceLockedException(string3);
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 25: 
            case 48: {
                return new InternalTrackerException(string3);
            }
            case 5: 
            case 15: 
            case 23: 
            case 68: {
                return new MotorStateException(string3);
            }
            case 6: 
            case 19: {
                return new LaserStateException(string3);
            }
            case 13: {
                return new NoTargetException(string3);
            }
            case 18: {
                return new DoubleFaultException(string3);
            }
            case 69: {
                return new InternalDeviceFailureException(string3);
            }
            case 70: {
                return new HardwareNotInstalledException(string3);
            }
            case 27: 
            case 49: {
                return new DistanceSetException(string3);
            }
            case 30: {
                return new TrackingStateException(string3);
            }
        }
        return new TrackerException(string3);
    }

    private int[] createTypeList(DataTag[] dataTagArray) throws TrackerException {
        int n = dataTagArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            if (dataTagArray[i] instanceof DataTagUnsigned8) {
                nArray[i] = 1;
                continue;
            }
            if (dataTagArray[i] instanceof DataTagUnsigned16) {
                nArray[i] = 2;
                continue;
            }
            if (dataTagArray[i] instanceof DataTagUnsigned32) {
                nArray[i] = 3;
                continue;
            }
            if (dataTagArray[i] instanceof DataTagDouble) {
                nArray[i] = 4;
                continue;
            }
            throw new UnsupportedFeatureException(Tracker.res.getString("Unknown_Data_Tag"));
        }
        return nArray;
    }

    @Override
    public MeasureData[] readMeasureData(int n) throws TrackerException {
        MeasureData[] measureDataArray;
        this.testAndSetReadData(true);
        try {
            measureDataArray = this.readData(this.ftpClient, n, this.measureTypeList, this.measureFilter);
        }
        catch (IOException iOException) {
            throw new CommunicationException(Tracker.res.getString("Measurement_Data_Exception"));
        }
        catch (FtpException ftpException) {
            throw this.convertFtpExc(ftpException);
        }
        finally {
            this.releaseReadData();
        }
        return measureDataArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAndSetReadData(boolean bl) throws TrackerException {
        TrackerKeystone trackerKeystone = this;
        synchronized (trackerKeystone) {
            if (!this.isConnected()) {
                throw new NotConnectedException();
            }
            if (!this.isMeasuring() || bl != this.generalMeasureFlag) {
                throw new NoDataAvailableException();
            }
            if (this.readInProgress) {
                throw new InterfaceBusyException(Tracker.res.getString("Read_In_Progress"));
            }
            this.readInProgress = true;
        }
    }

    private MeasureData[] readData(Ftp ftp, int n, int[] nArray, Filter filter) throws IOException, FtpException {
        MeasureData[] measureDataArray = new MeasureData[n];
        for (int i = 0; i < n; ++i) {
            MeasureStdDev measureStdDev;
            this.buf = filter instanceof StdDevFilter ? new byte[(nArray.length * 8 + 8) * 2] : new byte[nArray.length * 8 + 8];
            this.packet = new DatagramPacket(this.buf, this.buf.length);
            this.receiveDgPacket(this.dgSocket, this.packet);
            if (null == this.packet) {
                throw new IOException();
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.packet.getData());
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            Object[] objectArray = new Object[nArray.length];
            long l = dataInputStream.readInt();
            long l2 = dataInputStream.readInt();
            double d = (double)l + (double)l2 / 1000000.0;
            for (int j = 0; j < nArray.length; ++j) {
                objectArray[j] = this.readDataElement(dataInputStream, nArray[j]);
            }
            if (filter instanceof StdDevFilter) {
                Object[] objectArray2 = new Object[nArray.length];
                for (int j = 0; j < nArray.length; ++j) {
                    objectArray2[j] = this.readDataElement(dataInputStream, nArray[j]);
                }
                measureStdDev = new MeasureStdDev(objectArray2);
            } else {
                measureStdDev = null;
            }
            measureDataArray[i] = new MeasureData(d, objectArray, measureStdDev);
        }
        return measureDataArray;
    }

    private void releaseReadData() {
        this.readInProgress = false;
    }

    private Object readDataElement(DataInputStream dataInputStream, int n) throws FtpException, IOException {
        Number number = null;
        switch (n) {
            case 1: {
                short s = (short)((short)dataInputStream.readByte() & 0xFF);
                number = new Short(s);
                dataInputStream.skip(7L);
                break;
            }
            case 2: {
                number = new Integer(dataInputStream.readUnsignedShort());
                dataInputStream.skip(6L);
                break;
            }
            case 3: {
                number = new Long((long)dataInputStream.readInt() & 0xFFFFFFFFL);
                dataInputStream.skip(4L);
                break;
            }
            case 4: {
                number = new Double(dataInputStream.readDouble());
            }
        }
        return number;
    }

    @Override
    public synchronized void stopMeasure() throws TrackerException {
        this.localStopMeasure(true);
    }

    private synchronized void localStopMeasure(boolean bl) throws TrackerException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        if (this.isMeasuring() && this.generalMeasureFlag == bl) {
            try {
                this.ftpClient.command("measure", 10000);
                this.trkForeGndDgSocket.closeSocket();
                this.packet = null;
                this.measureInProgress = false;
            }
            catch (FtpIOException ftpIOException) {
                this.trkForeGndDgSocket.closeSocket();
                this.packet = null;
                this.measureInProgress = false;
            }
            catch (FtpNoResponseException ftpNoResponseException) {
                this.trkForeGndDgSocket.closeSocket();
                this.packet = null;
                this.measureInProgress = false;
            }
            catch (FtpException ftpException) {
                this.trkForeGndDgSocket.closeSocket();
                throw this.convertFtpExc(ftpException);
            }
        }
    }

    @Override
    public void startMeasurePoint(MeasureCfg measureCfg) throws TrackerException {
        this.localStartMeasure(measureCfg, this.pointMeasurementTags, false);
    }

    @Override
    public MeasurePointData[] readMeasurePointData(int n) throws TrackerException {
        MeasurePointData[] measurePointDataArray;
        this.testAndSetReadData(false);
        try {
            measurePointDataArray = this.readPointData(this.ftpClient, n, this.measureFilter);
        }
        catch (IOException iOException) {
            throw new CommunicationException(Tracker.res.getString("Measurement_Data_Exception"));
        }
        catch (FtpException ftpException) {
            throw this.convertFtpExc(ftpException);
        }
        finally {
            this.releaseReadData();
        }
        return measurePointDataArray;
    }

    private MeasurePointData[] localReadPointData(Ftp ftp, int n, Filter filter, boolean bl, boolean bl2) throws IOException, FtpException {
        MeasurePointData[] measurePointDataArray = new MeasurePointData[n];
        for (int i = 0; i < n; ++i) {
            MeasurePointStdDev measurePointStdDev;
            double d;
            double d2;
            ByteArrayInputStream byteArrayInputStream;
            if (!bl) {
                this.buf = new byte[256];
                this.packet = new DatagramPacket(this.buf, this.buf.length);
                this.receiveDgPacket(this.dgSocket, this.packet);
                if (null == this.packet) {
                    throw new IOException();
                }
                byteArrayInputStream = new ByteArrayInputStream(this.packet.getData());
            } else if (bl2) {
                this.factoryBkndBuf = new byte[256];
                this.factoryBkndPacket = new DatagramPacket(this.factoryBkndBuf, this.factoryBkndBuf.length);
                this.receiveDgPacket(this.factoryBkndDgSocket, this.factoryBkndPacket);
                if (null == this.factoryBkndPacket) {
                    throw new IOException();
                }
                byteArrayInputStream = new ByteArrayInputStream(this.factoryBkndPacket.getData());
            } else {
                this.bkndBuf = new byte[256];
                this.bkndPacket = new DatagramPacket(this.bkndBuf, this.bkndBuf.length);
                this.receiveDgPacket(this.bkndDgSocket, this.bkndPacket);
                if (null == this.bkndPacket) {
                    throw new IOException();
                }
                byteArrayInputStream = new ByteArrayInputStream(this.bkndPacket.getData());
            }
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            long l = dataInputStream.readInt();
            long l2 = dataInputStream.readInt();
            double d3 = (double)l + (double)l2 / 1000000.0;
            double d4 = Math.IEEEremainder((Double)this.readDataElement(dataInputStream, 4), Math.PI * 2);
            int n2 = (Integer)this.readDataElement(dataInputStream, 2);
            double d5 = Math.IEEEremainder((Double)this.readDataElement(dataInputStream, 4), Math.PI * 2);
            int n3 = (Integer)this.readDataElement(dataInputStream, 2);
            double d6 = (Double)this.readDataElement(dataInputStream, 4);
            int n4 = (Integer)this.readDataElement(dataInputStream, 2);
            int n5 = n2 | n3 | n4;
            int n6 = (n5 & 1) != 0 ? 2 : ((n5 & 2) != 0 ? 1 : (filter instanceof AdaptiveFilter && (n5 & 0x1000) != 0 ? 1 : 0));
            if (filter instanceof StdDevFilter) {
                d2 = Math.IEEEremainder((Double)this.readDataElement(dataInputStream, 4), Math.PI);
                dataInputStream.skip(8L);
                d = Math.IEEEremainder((Double)this.readDataElement(dataInputStream, 4), Math.PI);
                dataInputStream.skip(8L);
                double d7 = (Double)this.readDataElement(dataInputStream, 4);
                measurePointStdDev = new MeasurePointStdDev(d2, d, d7);
            } else {
                measurePointStdDev = null;
            }
            d2 = 1.0E-25;
            d = 1.0E10;
            boolean bl3 = false;
            if (Math.abs(d4) < d2 && 0 == n2 || Math.abs(d5) < d2 && 0 == n3 || d6 < d2 && 0 == n4 || Math.abs(d4) > d && 0 == n2 || Math.abs(d5) > d && 0 == n3 || d6 > d && 0 == n4) {
                bl3 = true;
            }
            if (bl3) {
                --i;
                continue;
            }
            measurePointDataArray[i] = new MeasurePointData(d3, d4, d5, d6, n6, measurePointStdDev);
        }
        return measurePointDataArray;
    }

    private MeasurePointData[] readPointData(Ftp ftp, int n, Filter filter) throws IOException, FtpException {
        MeasurePointData[] measurePointDataArray = this.localReadPointData(ftp, n, filter, false, false);
        return measurePointDataArray;
    }

    @Override
    public synchronized void stopMeasurePoint() throws TrackerException {
        this.localStopMeasure(false);
    }

    @Override
    public synchronized void startBkndMeasure(MeasureCfg measureCfg, DataTag[] dataTagArray) throws TrackerException {
        this.localStartBkndMeasure(measureCfg, dataTagArray, true, false);
    }

    @Override
    public synchronized void startFactoryBkndMeasure(MeasureCfg measureCfg, DataTag[] dataTagArray) throws TrackerException {
        this.localStartBkndMeasure(measureCfg, dataTagArray, true, true);
    }

    private synchronized void localStartBkndMeasure(MeasureCfg measureCfg, DataTag[] dataTagArray, boolean bl, boolean bl2) throws TrackerException {
        this.readyForCommand();
        String string = "\\data\\bkndmeas1.arg";
        if (bl2) {
            if (this.isFactoryBkndMeasuring()) {
                throw new InterfaceBusyException(Tracker.res.getString("Factory_Bkgnd_Measurement_In_Progress"));
            }
            string = "\\data\\bkndmeas2.arg";
        } else if (this.isBkndMeasuring()) {
            throw new InterfaceBusyException(Tracker.res.getString("Bkgnd_Measurements_In_Progress"));
        }
        Object object = this.checkAndSendCFGData(measureCfg, dataTagArray, true, bl2, this.ftpClient, string);
        int n = this.receiveBkndMeasurementData(this.ftpClient, bl2);
        if (n != 200) {
            throw this.exceptionFromResponse(this.ftpClient, n);
        }
        if (bl2) {
            if (object != null) {
                this.factoryBkndMeasureTypeList = (int[])object;
                this.factoryBkndMeasureFilter = measureCfg.getFilter();
            }
            this.factoryBkndGeneralMeasureFlag = bl;
            this.factoryBkndMeasureInProgress = true;
        } else {
            if (object != null) {
                this.bkndMeasureTypeList = (int[])object;
                this.bkndMeasureFilter = measureCfg.getFilter();
            }
            this.bkndGeneralMeasureFlag = bl;
            this.bkndMeasureInProgress = true;
        }
    }

    private boolean isBkndMeasuring() {
        return this.bkndMeasureInProgress;
    }

    private boolean isFactoryBkndMeasuring() {
        return this.factoryBkndMeasureInProgress;
    }

    private int receiveBkndMeasurementData(Ftp ftp, boolean bl) throws TrackerException {
        DatagramSocket datagramSocket = null;
        try {
            datagramSocket = bl ? this.trkFactoryBackGndDgSocket.createSocket() : this.trkBackGndDgSocket.createSocket();
            datagramSocket.setSoTimeout(5000);
            byte[] byArray = ftp.getIPAddress().getAddress();
            int n = datagramSocket.getLocalPort();
            int[] nArray = new int[4];
            for (int i = 0; i < 4; ++i) {
                nArray[i] = byArray[i];
                if (nArray[i] >= 0) continue;
                int n2 = i;
                nArray[n2] = nArray[n2] + 256;
            }
            int n3 = ftp.command("bkndmeasure " + (bl ? "2 " : "1 ") + nArray[0] + "," + nArray[1] + "," + nArray[2] + "," + nArray[3] + "," + n / 256 + "," + n % 256, 10000);
            if (bl) {
                this.factoryBkndDgSocket = datagramSocket;
            } else {
                this.bkndDgSocket = datagramSocket;
            }
            return n3;
        }
        catch (SocketException socketException) {
            if (bl) {
                this.trkFactoryBackGndDgSocket.closeSocket();
            } else {
                this.trkBackGndDgSocket.closeSocket();
            }
            if (socketException instanceof UtilityOutOfPortsException) {
                throw new CustomPortsException(Tracker.res.getString("Out_Of_Ports"));
            }
            throw new CommunicationException(Tracker.res.getString("Measurement_Data_Exception"));
        }
        catch (FtpException ftpException) {
            if (bl) {
                this.trkFactoryBackGndDgSocket.closeSocket();
            } else {
                this.trkBackGndDgSocket.closeSocket();
            }
            throw this.convertFtpExc(ftpException);
        }
    }

    @Override
    public MeasureData[] readBkndMeasureData(int n) throws TrackerException {
        return this.localReadBkndMeasureData(n, false);
    }

    @Override
    public MeasureData[] readFactoryBkndMeasureData(int n) throws TrackerException {
        return this.localReadBkndMeasureData(n, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MeasureData[] localReadBkndMeasureData(int n, boolean bl) throws TrackerException {
        boolean bl2;
        MeasureData[] measureDataArray = null;
        do {
            bl2 = false;
            this.testAndSetBkndReadData(true, bl);
            try {
                measureDataArray = bl ? this.readBkndData(true, n, this.factoryBkndMeasureTypeList, this.factoryBkndMeasureFilter) : this.readBkndData(false, n, this.bkndMeasureTypeList, this.bkndMeasureFilter);
                bl2 = false;
            }
            catch (IOException iOException) {
                throw new CommunicationException(Tracker.res.getString("Measurement_Data_Exception"));
            }
            catch (FtpException ftpException) {
                bl2 = true;
            }
            finally {
                this.releaseBkndReadData(bl);
            }
        } while (bl2);
        return measureDataArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAndSetBkndReadData(boolean bl, boolean bl2) throws TrackerException {
        TrackerKeystone trackerKeystone = this;
        synchronized (trackerKeystone) {
            if (!this.isConnected()) {
                throw new NotConnectedException();
            }
            if (bl2) {
                if (!this.isFactoryBkndMeasuring() || bl != this.factoryBkndGeneralMeasureFlag) {
                    throw new NoDataAvailableException();
                }
                if (this.factoryBkndReadInProgress) {
                    throw new InterfaceBusyException(Tracker.res.getString("Factory_Background_Read_In_Progress"));
                }
                this.factoryBkndReadInProgress = true;
            } else {
                if (!this.isBkndMeasuring() || bl != this.bkndGeneralMeasureFlag) {
                    throw new NoDataAvailableException();
                }
                if (this.bkndReadInProgress) {
                    throw new InterfaceBusyException(Tracker.res.getString("Background_Read_In_Progress"));
                }
                this.bkndReadInProgress = true;
            }
        }
    }

    private void receiveDgPacket(DatagramSocket datagramSocket, DatagramPacket datagramPacket) throws IOException {
        while (true) {
            try {
                datagramSocket.receive(datagramPacket);
            }
            catch (InterruptedIOException interruptedIOException) {
                if (this.isConnected()) continue;
                throw new IOException();
            }
            break;
        }
    }

    private MeasureData[] readBkndData(boolean bl, int n, int[] nArray, Filter filter) throws IOException, FtpException {
        MeasureData[] measureDataArray = new MeasureData[n];
        for (int i = 0; i < n; ++i) {
            MeasureStdDev measureStdDev;
            ByteArrayInputStream byteArrayInputStream;
            if (bl) {
                this.factoryBkndBuf = filter instanceof StdDevFilter ? new byte[(nArray.length * 8 + 8) * 2] : new byte[nArray.length * 8 + 8];
                this.factoryBkndPacket = new DatagramPacket(this.factoryBkndBuf, this.factoryBkndBuf.length);
                this.receiveDgPacket(this.factoryBkndDgSocket, this.factoryBkndPacket);
                if (null == this.factoryBkndPacket) {
                    throw new IOException();
                }
                byteArrayInputStream = new ByteArrayInputStream(this.factoryBkndPacket.getData());
            } else {
                this.bkndBuf = filter instanceof StdDevFilter ? new byte[(nArray.length * 8 + 8) * 2] : new byte[nArray.length * 8 + 8];
                this.bkndPacket = new DatagramPacket(this.bkndBuf, this.bkndBuf.length);
                this.receiveDgPacket(this.bkndDgSocket, this.bkndPacket);
                if (null == this.bkndPacket) {
                    throw new IOException();
                }
                byteArrayInputStream = new ByteArrayInputStream(this.bkndPacket.getData());
            }
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            Object[] objectArray = new Object[nArray.length];
            long l = dataInputStream.readInt();
            long l2 = dataInputStream.readInt();
            double d = (double)l + (double)l2 / 1000000.0;
            for (int j = 0; j < nArray.length; ++j) {
                objectArray[j] = this.readDataElement(dataInputStream, nArray[j]);
            }
            if (filter instanceof StdDevFilter) {
                Object[] objectArray2 = new Object[nArray.length];
                for (int j = 0; j < nArray.length; ++j) {
                    objectArray2[j] = this.readDataElement(dataInputStream, nArray[j]);
                }
                measureStdDev = new MeasureStdDev(objectArray2);
            } else {
                measureStdDev = null;
            }
            measureDataArray[i] = new MeasureData(d, objectArray, measureStdDev);
        }
        return measureDataArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseBkndReadData(boolean bl) {
        TrackerKeystone trackerKeystone = this;
        synchronized (trackerKeystone) {
            if (bl) {
                this.factoryBkndReadInProgress = false;
            } else {
                this.bkndReadInProgress = false;
            }
        }
    }

    @Override
    public void stopBkndMeasure() throws TrackerException {
        this.localStopBkndMeasure(true, false);
    }

    @Override
    public void stopFactoryBkndMeasure() throws TrackerException {
        this.localStopBkndMeasure(true, true);
    }

    private synchronized void localStopBkndMeasure(boolean bl, boolean bl2) throws TrackerException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        if (bl2) {
            if (this.isFactoryBkndMeasuring() && bl == this.factoryBkndGeneralMeasureFlag) {
                try {
                    this.ftpClient.command("bkndmeasure 2", 10000);
                    this.trkFactoryBackGndDgSocket.closeSocket();
                    this.factoryBkndPacket = null;
                    this.factoryBkndMeasureInProgress = false;
                }
                catch (FtpIOException ftpIOException) {
                    this.trkFactoryBackGndDgSocket.closeSocket();
                    this.factoryBkndPacket = null;
                    this.factoryBkndMeasureInProgress = false;
                }
                catch (FtpNoResponseException ftpNoResponseException) {
                    this.trkFactoryBackGndDgSocket.closeSocket();
                    this.factoryBkndPacket = null;
                    this.factoryBkndMeasureInProgress = false;
                }
                catch (FtpException ftpException) {
                    this.trkFactoryBackGndDgSocket.closeSocket();
                    throw this.convertFtpExc(ftpException);
                }
            }
        } else if (this.isBkndMeasuring() && bl == this.bkndGeneralMeasureFlag) {
            try {
                this.ftpClient.command("bkndmeasure 1", 10000);
                this.trkBackGndDgSocket.closeSocket();
                this.bkndPacket = null;
                this.bkndMeasureInProgress = false;
            }
            catch (FtpIOException ftpIOException) {
                this.trkBackGndDgSocket.closeSocket();
                this.bkndPacket = null;
                this.bkndMeasureInProgress = false;
            }
            catch (FtpNoResponseException ftpNoResponseException) {
                this.trkBackGndDgSocket.closeSocket();
                this.bkndPacket = null;
                this.bkndMeasureInProgress = false;
            }
            catch (FtpException ftpException) {
                this.trkBackGndDgSocket.closeSocket();
                throw this.convertFtpExc(ftpException);
            }
        }
    }

    @Override
    public synchronized void startBkndMeasurePoint(MeasureCfg measureCfg) throws TrackerException {
        this.localStartBkndMeasurePoint(measureCfg, false);
    }

    @Override
    public synchronized void startFactoryBkndMeasurePoint(MeasureCfg measureCfg) throws TrackerException {
        this.localStartBkndMeasurePoint(measureCfg, true);
    }

    private synchronized void localStartBkndMeasurePoint(MeasureCfg measureCfg, boolean bl) throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagDouble("target.corrected.azimuth.value"), new DataTagUnsigned16("target.corrected.azimuth.status"), new DataTagDouble("target.corrected.zenith.value"), new DataTagUnsigned16("target.corrected.zenith.status"), new DataTagDouble("target.corrected.distance.value"), new DataTagUnsigned16("target.corrected.distance.status")};
        this.localStartBkndMeasure(measureCfg, dataTagArray, false, bl);
    }

    @Override
    public MeasurePointData[] readBkndMeasurePointData(int n) throws TrackerException {
        MeasurePointData[] measurePointDataArray = null;
        this.testAndSetBkndReadData(false, false);
        try {
            measurePointDataArray = this.readBkndPointData(this.ftpClient, false, n, this.bkndMeasureFilter);
        }
        catch (IOException iOException) {
            throw new CommunicationException(Tracker.res.getString("Measurement_Data_Exception"));
        }
        catch (FtpException ftpException) {
            throw this.convertFtpExc(ftpException);
        }
        finally {
            this.releaseBkndReadData(false);
        }
        return measurePointDataArray;
    }

    @Override
    public MeasurePointData[] readFactoryBkndMeasurePointData(int n) throws TrackerException {
        MeasurePointData[] measurePointDataArray = null;
        this.testAndSetBkndReadData(false, true);
        try {
            measurePointDataArray = this.readBkndPointData(this.ftpClient, true, n, this.factoryBkndMeasureFilter);
        }
        catch (IOException iOException) {
            throw new CommunicationException(Tracker.res.getString("Measurement_Data_Exception"));
        }
        catch (FtpException ftpException) {
            throw this.convertFtpExc(ftpException);
        }
        finally {
            this.releaseBkndReadData(true);
        }
        return measurePointDataArray;
    }

    @Override
    public void stopBkndMeasurePoint() throws TrackerException {
        this.localStopBkndMeasure(false, false);
    }

    @Override
    public void stopFactoryBkndMeasurePoint() throws TrackerException {
        this.localStopBkndMeasure(false, true);
    }

    private MeasurePointData[] readBkndPointData(Ftp ftp, boolean bl, int n, Filter filter) throws IOException, FtpException {
        MeasurePointData[] measurePointDataArray = this.localReadPointData(ftp, n, filter, true, bl);
        return measurePointDataArray;
    }

    @Override
    public synchronized void startAsync() throws TrackerException {
        int[] nArray = new int[4];
        this.readyForCommand();
        if (this.asyncRunning()) {
            throw new InterfaceBusyException(Tracker.res.getString("Async_Already_Running"));
        }
        try {
            this.asyncSocket = this.trkAsyncDgSocket.createSocket();
            this.asyncSocket.setSoTimeout(5000);
            int n = this.asyncSocket.getLocalPort();
            byte[] byArray = this.ftpClient.getIPAddress().getAddress();
            for (int i = 0; i < 4; ++i) {
                nArray[i] = byArray[i];
                if (nArray[i] >= 0) continue;
                int n2 = i;
                nArray[n2] = nArray[n2] + 256;
            }
            int n3 = this.ftpClient.command("asyncmsg " + nArray[0] + "," + nArray[1] + "," + nArray[2] + "," + nArray[3] + "," + n / 256 + "," + n % 256, 10000);
            this.asyncReadInterrupted = false;
            this.asyncReadInProgress = false;
            if (n3 != 228 && n3 == 556) {
                throw this.exceptionFromResponse(this.ftpClient, n3);
            }
        }
        catch (FtpException ftpException) {
            this.trkAsyncDgSocket.closeSocket();
            throw this.convertFtpExc(ftpException);
        }
        catch (IOException iOException) {
            this.trkAsyncDgSocket.closeSocket();
            if (iOException instanceof UtilityOutOfPortsException) {
                throw new CustomPortsException(Tracker.res.getString("Out_Of_Ports"));
            }
            throw new CommunicationException(Tracker.res.getString("IO_Exception"));
        }
    }

    private boolean asyncRunning() {
        return this.asyncSocket != null;
    }

    @Override
    public Status[] statusHistory() throws TrackerException {
        Object[] objectArray = this.getHistory("\\message\\stathst.dat", Status.class);
        int n = objectArray.length;
        Status[] statusArray = new Status[n];
        for (int i = 0; i < n; ++i) {
            statusArray[i] = (Status)objectArray[i];
        }
        return statusArray;
    }

    private Change[] changeHistory() throws TrackerException {
        Object[] objectArray = this.getHistory("\\message\\eventhst.dat", Change.class);
        int n = objectArray.length;
        Change[] changeArray = new Change[n];
        for (int i = 0; i < n; ++i) {
            changeArray[i] = (Change)objectArray[i];
        }
        return changeArray;
    }

    @Override
    public synchronized void stopAsync() throws TrackerException {
        this.readyForCommand();
        if (!this.asyncRunning()) {
            return;
        }
        try {
            this.ftpClient.command("asyncmsg", 1000);
            this.asyncSocket.close();
            this.asyncSocket = null;
            this.asyncPacket = null;
        }
        catch (FtpIOException ftpIOException) {
            this.asyncSocket.close();
            this.asyncSocket = null;
            this.asyncPacket = null;
        }
        catch (FtpNoResponseException ftpNoResponseException) {
            this.asyncSocket.close();
            this.asyncSocket = null;
            this.asyncPacket = null;
        }
        catch (FtpException ftpException) {
            throw this.convertFtpExc(ftpException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public AsyncMsg readAsyncMsg() throws TrackerException {
        String string = null;
        AsyncMsg asyncMsg = null;
        TrackerKeystone trackerKeystone = this;
        synchronized (trackerKeystone) {
            if (!this.asyncRunning()) {
                throw new NoDataAvailableException();
            }
            this.asyncReadInProgress = true;
        }
        try {
            while (!(string != null && asyncMsg != null || this.asyncReadInterrupted)) {
                try {
                    this.asyncBuf = new byte[256];
                    this.asyncPacket = new DatagramPacket(this.asyncBuf, this.asyncBuf.length);
                    this.receiveDgPacket(this.asyncSocket, this.asyncPacket);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.asyncPacket.getData());
                    this.asyncInput = new BufferedReader(new InputStreamReader(byteArrayInputStream));
                    string = this.asyncInput.readLine();
                    asyncMsg = this.convertLineToAsync(string);
                }
                catch (InterruptedIOException interruptedIOException) {
                }
                catch (IOException iOException) {
                    throw new NoDataAvailableException();
                    return asyncMsg;
                }
            }
        }
        finally {
            trackerKeystone = this;
            synchronized (trackerKeystone) {
                this.asyncReadInProgress = false;
                while (this.asyncReadInterrupted) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    @Override
    public Diagnostic[] diagnosticHistory() throws TrackerException {
        Object[] objectArray = this.getHistory("\\message\\diaghst.dat", Diagnostic.class);
        int n = objectArray.length;
        Diagnostic[] diagnosticArray = new Diagnostic[n];
        for (int i = 0; i < n; ++i) {
            diagnosticArray[i] = (Diagnostic)objectArray[i];
        }
        return diagnosticArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object[] getHistory(String string, Class clazz) throws TrackerException {
        ArrayList<AsyncMsg> arrayList = null;
        TrackerException trackerException = null;
        this.readyForCommand();
        try {
            arrayList = new ArrayList<AsyncMsg>();
            int n = this.ftpClient.receiveStart(string);
            if (150 != n) {
                throw this.exceptionFromResponse(this.ftpClient, n);
            }
            try {
                String string2;
                while (null != (string2 = this.ftpClient.receiveLine())) {
                    try {
                        AsyncMsg asyncMsg = this.convertLineToAsync(string2);
                        if (clazz != asyncMsg.getClass()) continue;
                        arrayList.add(asyncMsg);
                    }
                    catch (DataFormatException dataFormatException) {
                    }
                }
            }
            catch (FtpNoResponseException ftpNoResponseException) {
                // empty catch block
            }
        }
        catch (FtpException ftpException) {
            trackerException = this.convertFtpExc(ftpException);
        }
        finally {
            block21: {
                try {
                    int n = this.ftpClient.receiveEnd();
                    if (226 != n) {
                        trackerException = this.exceptionFromResponse(this.ftpClient, n);
                    }
                }
                catch (FtpException ftpException) {
                    if (null != trackerException) break block21;
                    trackerException = this.convertFtpExc(ftpException);
                }
            }
        }
        if (null != trackerException) {
            throw trackerException;
        }
        if (null != arrayList && 0 != arrayList.size()) {
            return arrayList.toArray();
        }
        throw new NoDataAvailableException();
    }

    private AsyncMsg convertLineToAsync(String string) throws TrackerException {
        AsyncMsg asyncMsg = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        try {
            String string2 = stringTokenizer.nextToken();
            switch (string2.charAt(0)) {
                case 'D': {
                    asyncMsg = this.convertToDiag(string, stringTokenizer);
                    break;
                }
                case 'E': {
                    asyncMsg = this.convertToChange(string, stringTokenizer);
                    break;
                }
                case 'S': {
                    asyncMsg = this.convertToStatus(string, stringTokenizer);
                    break;
                }
                case 'A': {
                    asyncMsg = this.convertToAlarm(string, stringTokenizer);
                    break;
                }
                default: {
                    throw new NoSuchElementException();
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new DataFormatException();
        }
        return asyncMsg;
    }

    private Diagnostic convertToDiag(String string, StringTokenizer stringTokenizer) {
        int n = Integer.parseInt(stringTokenizer.nextToken(), 16);
        int n2 = n < 0 || n >= diagMap.length ? 0 : diagMap[n];
        String string2 = "Code=" + n + " ";
        string2 = string2 + "Param1=" + stringTokenizer.nextToken() + " ";
        string2 = string2 + "Param2=" + stringTokenizer.nextToken() + " ";
        string2 = string2 + "Task=" + stringTokenizer.nextToken();
        double d = Double.parseDouble(stringTokenizer.nextToken());
        int n3 = Integer.parseInt(stringTokenizer.nextToken(), 16);
        return new Diagnostic(n2, d, n3, string2);
    }

    private Change convertToChange(String string, StringTokenizer stringTokenizer) {
        Object object;
        int n = Integer.parseInt(stringTokenizer.nextToken(), 16) & 0xFF;
        int n2 = n < 0 || n >= changeMap.length ? 0 : changeMap[n];
        int n3 = Integer.parseInt(stringTokenizer.nextToken());
        switch (n2) {
            case 2: {
                object = new Boolean(0 == n3);
                break;
            }
            case 1: {
                object = new Boolean(1 == n3);
                break;
            }
            case 4: {
                try {
                    object = this.constructTargetType(n3);
                }
                catch (TrackerException trackerException) {
                    object = null;
                }
                break;
            }
            case 3: {
                object = this.constructDistanceMode(n3);
                break;
            }
            default: {
                object = null;
            }
        }
        double d = Double.parseDouble(stringTokenizer.nextToken());
        int n4 = Integer.parseInt(stringTokenizer.nextToken(), 16);
        return new Change(n2, d, n4, string, object);
    }

    private Status convertToStatus(String string, StringTokenizer stringTokenizer) {
        int n = Integer.parseInt(stringTokenizer.nextToken(), 16) & 0xFF;
        String string2 = stringTokenizer.nextToken();
        double d = Double.parseDouble(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken(), 16);
        boolean bl = string2.compareToIgnoreCase("on") == 0;
        int n3 = n < 0 || n >= statusMap.length ? 0 : statusMap[n];
        return new Status(n3, bl, d, n2, string);
    }

    private Alarm convertToAlarm(String string, StringTokenizer stringTokenizer) {
        int n = Integer.parseInt(stringTokenizer.nextToken());
        String string2 = stringTokenizer.nextToken();
        double d = Double.parseDouble(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken(), 16);
        boolean bl = string2.compareToIgnoreCase("on") == 0;
        return new Alarm(n, bl, d, n2, string);
    }

    @Override
    public Alarm[] alarmHistory() throws TrackerException {
        Object[] objectArray = this.getHistory("\\message\\alarmhst.dat", Alarm.class);
        int n = objectArray.length;
        Alarm[] alarmArray = new Alarm[n];
        for (int i = 0; i < n; ++i) {
            alarmArray[i] = (Alarm)objectArray[i];
        }
        return alarmArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void writeOneTimeData(DataTag[] dataTagArray, Object[] objectArray) throws TrackerException {
        int n;
        TrackerException trackerException = null;
        this.readyForCommand();
        this.writeOneTimePoints(dataTagArray);
        try {
            n = this.ftpClient.sendStart("\\data\\singlbin.dat");
            if (150 != n) {
                throw this.exceptionFromResponse(this.ftpClient, n);
            }
        }
        catch (FtpException ftpException) {
            throw this.convertFtpExc(ftpException);
        }
        int[] nArray = this.createTypeList(dataTagArray);
        try {
            for (int i = 0; i < dataTagArray.length; ++i) {
                this.writeDataElement(objectArray[i], nArray[i]);
            }
        }
        catch (FtpException ftpException) {
            trackerException = this.convertFtpExc(ftpException);
        }
        finally {
            block18: {
                try {
                    n = this.ftpClient.sendEnd(10000);
                    if (226 != n) {
                        trackerException = this.exceptionFromResponse(this.ftpClient, n);
                    }
                }
                catch (FtpException ftpException) {
                    if (null != trackerException) break block18;
                    trackerException = this.convertFtpExc(ftpException);
                }
            }
        }
        if (null != trackerException) {
            throw trackerException;
        }
    }

    private void writeDataElement(Object object, int n) throws FtpException {
        switch (n) {
            case 1: {
                byte by = (byte)((Short)object & 0xFF);
                this.ftpClient.sendByte(by);
                this.ftpClient.sendByte((byte)0);
                this.ftpClient.sendUnsignedShort(0);
                this.ftpClient.sendUnsignedInt(0L);
                break;
            }
            case 2: {
                this.ftpClient.sendUnsignedShort(((Integer)object).intValue());
                this.ftpClient.sendUnsignedShort(0);
                this.ftpClient.sendUnsignedInt(0L);
                break;
            }
            case 3: {
                this.ftpClient.sendUnsignedInt(((Long)object).longValue());
                this.ftpClient.sendUnsignedInt(0L);
                break;
            }
            case 4: {
                this.ftpClient.sendDouble(((Double)object).doubleValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object[] readOneTimeData(DataTag[] dataTagArray) throws TrackerException {
        int n;
        TrackerException trackerException = null;
        this.readyForCommand();
        this.writeOneTimePoints(dataTagArray);
        Object[] objectArray = new Object[dataTagArray.length];
        int[] nArray = this.createTypeList(dataTagArray);
        try {
            n = this.ftpClient.receiveStart("\\data\\singlbin.dat");
            if (150 != n) {
                throw this.exceptionFromResponse(this.ftpClient, n);
            }
        }
        catch (FtpException ftpException) {
            throw this.convertFtpExc(ftpException);
        }
        try {
            for (int i = 0; i < dataTagArray.length; ++i) {
                objectArray[i] = this.readDataElement(this.ftpClient, nArray[i]);
            }
        }
        catch (FtpException ftpException) {
            trackerException = this.convertFtpExc(ftpException);
        }
        finally {
            block18: {
                try {
                    n = this.ftpClient.receiveEnd();
                    if (226 != n) {
                        trackerException = this.exceptionFromResponse(this.ftpClient, n);
                    }
                }
                catch (FtpException ftpException) {
                    if (null != trackerException) break block18;
                    trackerException = this.convertFtpExc(ftpException);
                }
            }
        }
        if (null != trackerException) {
            throw trackerException;
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOneTimePoints(DataTag[] dataTagArray) throws TrackerException {
        int n;
        TrackerException trackerException = null;
        try {
            n = this.ftpClient.sendStart("\\data\\single.arg");
            if (n != 150) {
                throw this.exceptionFromResponse(this.ftpClient, n);
            }
        }
        catch (FtpException ftpException) {
            throw this.convertFtpExc(ftpException);
        }
        try {
            for (int i = 0; i < dataTagArray.length; ++i) {
                this.ftpClient.sendLine(dataTagArray[i].getName());
            }
        }
        catch (FtpException ftpException) {
            trackerException = this.convertFtpExc(ftpException);
        }
        finally {
            block18: {
                try {
                    n = this.ftpClient.sendEnd(10000);
                    if (n != 226 && trackerException == null) {
                        trackerException = this.exceptionFromResponse(this.ftpClient, n);
                    }
                }
                catch (FtpException ftpException) {
                    if (trackerException != null) break block18;
                    trackerException = this.convertFtpExc(ftpException);
                }
            }
        }
        if (trackerException != null) {
            throw trackerException;
        }
    }

    private Object readDataElement(Ftp ftp, int n) throws FtpException {
        Number number = null;
        switch (n) {
            case 1: {
                short s = (short)((short)ftp.receiveByte() & 0xFF);
                number = new Short(s);
                ftp.receiveSkip(7);
                break;
            }
            case 2: {
                number = new Integer(ftp.receiveUnsignedShort());
                ftp.receiveSkip(6);
                break;
            }
            case 3: {
                number = new Long(ftp.receiveUnsignedInt());
                ftp.receiveSkip(4);
                break;
            }
            case 4: {
                number = new Double(ftp.receiveDouble());
            }
        }
        return number;
    }

    @Override
    public boolean connected() throws TrackerException {
        return this.isConnected();
    }

    @Override
    public boolean targetPresent() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("target.state")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        return ((Long)objectArray[0]).intValue() == 2;
    }

    @Override
    public boolean targetLocationValid() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned16("target.corrected.azimuth.status"), new DataTagUnsigned16("target.corrected.zenith.status"), new DataTagUnsigned16("target.corrected.distance.status")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        return (Integer)objectArray[0] == 0 && (Integer)objectArray[1] == 0 && (Integer)objectArray[2] == 0;
    }

    @Override
    public boolean motorsOn() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("servo.motor_state.current")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        return ((Long)objectArray[0]).intValue() == 1;
    }

    @Override
    public boolean initialized() throws TrackerException {
        return this.initialized(true);
    }

    @Override
    public boolean initialized(boolean bl) throws TrackerException {
        DataTag[] dataTagArray = new DataTag[4];
        DataTag[] dataTagArray2 = new DataTag[1];
        dataTagArray[0] = new DataTagUnsigned32("servo.motor_state.current");
        dataTagArray[1] = new DataTagUnsigned16("position_device.psd.raw.a.status");
        dataTagArray[2] = new DataTagUnsigned16("position_device.azimuth_encoder.reading.status");
        dataTagArray[3] = new DataTagUnsigned16("position_device.zenith_encoder.reading.status");
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        if ((Long)objectArray[0] != 0L && (Long)objectArray[0] != 1L) {
            return false;
        }
        if (0 != ((Integer)objectArray[1] & 0x20)) {
            return false;
        }
        if (0 != (1 & (Integer)objectArray[2]) || 0 != (0x20 & (Integer)objectArray[2]) || 0 != (1 & (Integer)objectArray[3]) || 0 != (0x20 & (Integer)objectArray[3])) {
            return false;
        }
        if (!bl) {
            dataTagArray2[0] = new DataTagUnsigned16("system.zero_correct.time.status");
            objectArray = this.readOneTimeData(dataTagArray2);
            if ((Integer)objectArray[0] != 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean trackingOn() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("servo.tracking_mode")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        return ((Long)objectArray[0]).intValue() == 0;
    }

    @Override
    public boolean admCapable() throws TrackerException {
        return this.isADMCapable;
    }

    @Override
    public boolean admOnlyCapable() {
        return this.isADMOnlyCapable;
    }

    @Override
    public boolean interferometerCapable() throws TrackerException {
        return this.isIFMCapable;
    }

    @Override
    public boolean levelCapable() throws TrackerException {
        return this.isLevelCapable;
    }

    @Override
    public DistanceMode distanceMeasureMode() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("system.distance_mode")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        return this.constructDistanceMode((int)((Long)objectArray[0]).longValue());
    }

    private DistanceMode constructDistanceMode(int n) {
        switch (n) {
            case 1: {
                return new InterferometerOnly();
            }
            case 3: {
                return new ADMOnly();
            }
            case 2: {
                return new InterferometerSetByADM();
            }
            case 0: {
                return new UserSpecifiedDistance();
            }
        }
        return new InterferometerOnly();
    }

    @Override
    public TargetType targetType() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("target.type")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        return this.constructTargetType((int)((Long)objectArray[0]).longValue());
    }

    private TargetType constructTargetType(int n) throws TrackerException {
        switch (n) {
            case 0: {
                return new SMRTargetType(0.0381);
            }
            case 1: {
                return new MirrorTargetType();
            }
            case 2: {
                return new SMRTargetType(0.0127);
            }
            case 3: {
                return new SMRTargetType(0.022225);
            }
            case 4: {
                return new SMRTargetType(0.0);
            }
            case 5: {
                return new WindowedSMRTargetType(0.0381);
            }
            case 6: {
                return new WindowedSMRTargetType(0.022225);
            }
        }
        throw new UnsupportedFeatureException(Tracker.res.getString("Target_Type_Not_Supported"));
    }

    @Override
    public boolean backsightOrientation() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("system.orientation")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        return ((Long)objectArray[0]).intValue() == 1;
    }

    @Override
    public LevelData measureLevel() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[6];
        Object[] objectArray = null;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (!this.isLevelCapable) {
            throw new UnsupportedFeatureException(Tracker.res.getString("Level_Not_Installed"));
        }
        this.trackerCommand("level run", 120000);
        dataTagArray[0] = new DataTagDouble("fine_level.tilt.rx.value");
        dataTagArray[1] = new DataTagUnsigned16("fine_level.tilt.rx.status");
        dataTagArray[2] = new DataTagDouble("fine_level.tilt.ry.value");
        dataTagArray[3] = new DataTagUnsigned16("fine_level.tilt.ry.status");
        dataTagArray[4] = new DataTagDouble("fine_level.tilt.rz.value");
        dataTagArray[5] = new DataTagUnsigned16("fine_level.tilt.rz.status");
        objectArray = this.readOneTimeData(dataTagArray);
        n = (Integer)objectArray[1];
        n2 = (Integer)objectArray[3];
        n3 = (Integer)objectArray[5];
        if ((n & 1) != 0 || (n2 & 1) != 0 || (n3 & 1) != 0) {
            throw new InternalDeviceFailureException(Tracker.res.getString("Level_Error"));
        }
        if ((n & 2) != 0 || (n2 & 2) != 0 || (n3 & 2) != 0) {
            throw new InternalDeviceFailureException(Tracker.res.getString("Level_Inaccurate"));
        }
        d = (Double)objectArray[0];
        d2 = (Double)objectArray[2];
        d3 = (Double)objectArray[4];
        return new LevelData(d, d2, d3);
    }

    @Override
    public MaterialTemperatureData measureMaterialTemperature() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[3];
        Object[] objectArray = null;
        double d = 0.0;
        int n = 0;
        int n2 = 0;
        dataTagArray[0] = new DataTagDouble("weather.current.ext_material.value");
        dataTagArray[1] = new DataTagUnsigned16("weather.current.ext_material.status");
        dataTagArray[2] = new DataTagUnsigned32("weather.current.ext_material.count");
        objectArray = this.readOneTimeData(dataTagArray);
        d = (Double)objectArray[0];
        n = (Integer)objectArray[1];
        n2 = (int)((Long)objectArray[2]).longValue();
        if (n2 == 0) {
            throw new InternalDeviceFailureException(Tracker.res.getString("Sensor_Not_Found"));
        }
        if ((n & 0x80) != 0) {
            throw new InternalDeviceFailureException(Tracker.res.getString("Sensor_Disabled"));
        }
        if ((n & 2) != 0) {
            throw new InternalDeviceFailureException(Tracker.res.getString("Sensor_Inaccurate"));
        }
        if ((n & 1) != 0) {
            throw new InternalDeviceFailureException(Tracker.res.getString("Sensor_Error"));
        }
        return new MaterialTemperatureData(d, n2);
    }

    @Override
    public TrackerApp startApplication(String string, String string2, Tracker tracker, JFrame jFrame) throws TrackerException {
        Class[] classArray = new Class[3];
        Object[] objectArray = new Object[3];
        this.readyForCommand();
        AppRec appRec = this.findAppInfo(string);
        if (!this.initialLocalAppValueSet) {
            this.loadingLocalApp = appRec.readFromLocal;
            this.initialLocalAppValueSet = true;
        }
        if (this.loadingLocalApp != appRec.readFromLocal) {
            this.closeCachedJars();
            this.jarClassLoader = null;
            this.jarClassLoader = new JarClassLoader();
            this.loadingLocalApp = appRec.readFromLocal;
        }
        if (appRec.isSet()) {
            throw new ApplicationFailedException(Tracker.res.getString("Application_Already_Running"));
        }
        try {
            this.jarClassLoader.setAppName(string);
            Class<?> clazz = this.jarClassLoader.loadClass(appRec.fullQualifiedName);
            classArray[0] = String.class;
            classArray[1] = Tracker.class;
            classArray[2] = JFrame.class;
            Constructor<?> constructor = clazz.getConstructor(classArray);
            objectArray[0] = string2;
            objectArray[1] = tracker;
            objectArray[2] = jFrame;
            TrackerApp trackerApp = (TrackerApp)constructor.newInstance(objectArray);
            for (int i = 0; i < this.maintainApp.size(); ++i) {
                appRec = (AppRec)this.maintainApp.get(i);
                if (!appRec.appName.equals(string)) continue;
                appRec.set(trackerApp);
                this.maintainApp.set(i, appRec);
                break;
            }
            return trackerApp;
        }
        catch (FtpException ftpException) {
            PrintException.print((Exception)((Object)ftpException));
            throw new ApplicationFailedException(Tracker.res.getString("Could_Not_Invoke_Application"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            PrintException.print(classNotFoundException);
            throw new ApplicationFailedException(classNotFoundException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            PrintException.print(illegalAccessException);
            throw new ApplicationFailedException(Tracker.res.getString("Illegal_Access"));
        }
        catch (InstantiationException instantiationException) {
            PrintException.print(instantiationException);
            throw new ApplicationFailedException(Tracker.res.getString("Instantiation_Failed"));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            PrintException.print(noSuchMethodException);
            throw new ApplicationFailedException(Tracker.res.getString("Could_Not_Get_Constructor"));
        }
        catch (InvocationTargetException invocationTargetException) {
            PrintException.print(invocationTargetException);
            throw new ApplicationFailedException(Tracker.res.getString("Could_Not_Invoke_Application"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void setAppInfo() throws TrackerException {
        var1_1 = 0;
        var2_2 = 0;
        this.maintainApp = new LinkedList<E>();
        var3_3 = null;
        var4_4 = "";
        var5_5 = "";
        try {
            var1_1 = this.ftpClient.receiveStart("\\signatur\\capability.dat");
            if (150 != var1_1) {
                throw this.exceptionFromResponse(this.ftpClient, var1_1);
            }
        }
        catch (FtpException var6_6) {
            throw this.convertFtpExc(var6_6);
        }
        try {
            block13: while (true) {
                if (var4_4 == null) {
                    break;
                }
                var4_4 = this.ftpClient.receiveLine();
                if (var4_4.indexOf(91) == -1) continue;
                var2_2 = var4_4.indexOf(93);
                var5_5 = var4_4.substring(1, var2_2);
                if (var5_5.toUpperCase(Locale.ENGLISH).equals("APPS")) {
                    var6_7 = "";
                    var7_11 = "";
                    var8_12 = "";
                    var9_13 = "";
                    var10_15 = null;
                    var11_16 = 0;
                    var12_17 = null;
                    var4_4 = this.ftpClient.receiveLine();
                    while (true) {
                        if (var4_4 == null || var4_4.equals("") || var4_4.indexOf(91) != -1) continue block13;
                        var12_17 = new StringTokenizer(var4_4, ",");
                        var6_7 = var12_17.nextToken().trim();
                        var7_11 = var12_17.nextToken().trim();
                        var8_12 = var12_17.nextToken().trim();
                        var12_17 = new StringTokenizer((String)var8_12, " ");
                        var11_16 = var12_17.countTokens();
                        var13_18 = new Object[2];
                        var10_15 = new String[var11_16];
                        for (var14_19 = 0; var14_19 < var11_16; ++var14_19) {
                            var9_13 = var12_17.nextToken().trim();
                            var10_15[var14_19] = var9_13.substring(1, var9_13.indexOf(34, 1));
                        }
                        var13_18[0] = var10_15;
                        var3_3 = new AppRec(var6_7, var7_11, var13_18, false);
                        this.maintainApp.add(var3_3);
                        var4_4 = this.ftpClient.receiveLine();
                    }
                }
                if (var5_5.toUpperCase(Locale.ENGLISH).equals("OPTIONAL HARDWARE")) {
                    var6_7 = "";
                    var7_11 = "";
                    var8_12 = null;
                    var9_14 = false;
                    var4_4 = this.ftpClient.receiveLine();
                    while (true) {
                        if (var4_4 == null || var4_4.equals("") || var4_4.indexOf(91) != -1) continue block13;
                        var8_12 = new StringTokenizer(var4_4, " ");
                        var6_7 = var8_12.nextToken().trim().toUpperCase(Locale.ENGLISH);
                        var8_12.nextToken();
                        var7_11 = var8_12.nextToken().trim();
                        if (var7_11.equals("0")) {
                            var9_14 = false;
                        } else if (var7_11.equals("1")) {
                            var9_14 = true;
                        }
                        if (var6_7.equals("IFM")) {
                            this.isIFMCapable = var9_14;
                        } else if (var6_7.equals("ADM")) {
                            this.isADMCapable = var9_14;
                        } else if (var6_7.equals("LEVEL")) {
                            this.isLevelCapable = var9_14;
                        }
                        var4_4 = this.ftpClient.receiveLine();
                    }
                }
                var4_4 = this.ftpClient.receiveLine();
                while (true) {
                    if (var4_4 != null && !var4_4.equals("") && var4_4.indexOf(91) == -1) ** break;
                    continue block13;
                    var4_4 = this.ftpClient.receiveLine();
                }
                break;
            }
        }
        catch (FtpException var6_9) {
            PrintException.print((Exception)var6_9);
        }
        finally {
            try {
                this.ftpClient.receiveEnd();
            }
            catch (FtpException var6_10) {}
        }
        this.loadLocalApp();
    }

    private void loadLocalApp() {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String[] stringArray = null;
        int n = 0;
        StringTokenizer stringTokenizer = null;
        AppRec appRec = null;
        AppRec appRec2 = null;
        boolean bl = false;
        this.fileDirectory = this.findClassPath();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.fileDirectory + "/apps/Apps.txt"));
            while ((string6 = bufferedReader.readLine()) != null) {
                int n2;
                stringTokenizer = new StringTokenizer(string6, ",");
                string = stringTokenizer.nextToken().trim();
                string2 = stringTokenizer.nextToken().trim();
                string3 = stringTokenizer.nextToken().trim();
                string4 = stringTokenizer.nextToken().trim();
                stringTokenizer = new StringTokenizer(string3, " ");
                n = stringTokenizer.countTokens();
                stringArray = new String[n];
                for (n2 = 0; n2 < n; ++n2) {
                    string5 = stringTokenizer.nextToken().trim();
                    stringArray[n2] = "/apps/" + string5.substring(1, string5.indexOf(34, 1));
                }
                stringTokenizer = new StringTokenizer(string4, "=");
                string5 = stringTokenizer.nextToken().trim();
                bl = string5.toUpperCase(Locale.ENGLISH).equals("LOADFIRST") ? (string5 = stringTokenizer.nextToken().trim()).toUpperCase(Locale.ENGLISH).equals("TRUE") : false;
                for (n2 = 0; n2 < this.maintainApp.size(); ++n2) {
                    appRec2 = (AppRec)this.maintainApp.get(n2);
                    if (!string.equals(appRec2.appName)) continue;
                    appRec2.readFromLocal = bl;
                    appRec2.jarFileName[1] = stringArray;
                    break;
                }
                if (n2 != this.maintainApp.size()) continue;
                Object[] objectArray = new Object[2];
                objectArray[1] = stringArray;
                appRec = new AppRec(string, string2, objectArray, true);
                this.maintainApp.add(appRec);
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String findClassPath() {
        String string = "";
        String string2 = "";
        String string3 = "";
        StringTokenizer stringTokenizer = null;
        StringTokenizer stringTokenizer2 = null;
        int n = 0;
        int n2 = 0;
        stringTokenizer = new StringTokenizer(System.getProperty("java.class.path"), ";");
        n = stringTokenizer.countTokens();
        for (int i = 0; i < n; ++i) {
            string = stringTokenizer.nextToken().trim();
            stringTokenizer2 = new StringTokenizer(string, "\\");
            n2 = stringTokenizer2.countTokens();
            string2 = "";
            string3 = "";
            if (string.startsWith("\\\\")) {
                string3 = string3 + "//";
            }
            for (int j = 0; j < n2; ++j) {
                string2 = stringTokenizer2.nextToken().trim();
                if (string2.toUpperCase(Locale.ENGLISH).equals("TRACKER.JAR")) {
                    return string3.substring(0, string3.length() - 1);
                }
                string3 = string3 + string2 + "/";
            }
        }
        return null;
    }

    private void clearAppInfo() throws TrackerException {
        if (this.maintainApp.size() == 0) {
            return;
        }
        for (int i = 0; i < this.maintainApp.size(); ++i) {
            AppRec appRec = (AppRec)this.maintainApp.get(i);
            if (!appRec.isSet()) continue;
            throw new InterfaceBusyException(Tracker.res.getString("Application_Running"));
        }
        this.maintainApp.clear();
    }

    private AppRec findAppInfo(String string) throws TrackerException {
        AppRec appRec = null;
        AppRec appRec2 = null;
        for (int i = 0; i < this.maintainApp.size(); ++i) {
            appRec = (AppRec)this.maintainApp.get(i);
            if (!string.equals(appRec.appName)) continue;
            for (int j = i + 1; j < this.maintainApp.size(); ++j) {
                appRec2 = (AppRec)this.maintainApp.get(j);
                if (!string.equals(appRec2.appName)) continue;
                if (appRec2.readFromLocal) {
                    appRec.readFromLocal = appRec2.readFromLocal;
                }
                return appRec;
            }
            return appRec;
        }
        throw new ApplicationFailedException(Tracker.res.getString("Unknown_Application_Name"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyApplication(String string, String string2) throws TrackerException {
        TrackerKeystone trackerKeystone = this;
        synchronized (trackerKeystone) {
            AppRec appRec = this.findAppInfo(string);
            if (appRec.isSet()) {
                appRec.app.modifyParameters(string2);
            }
        }
    }

    @Override
    public TrackerApp stopApplication(String string) throws TrackerException {
        TrackerApp trackerApp = this.stopApplication(string, true);
        return trackerApp;
    }

    private void localStopApplication(AppRec appRec) {
        appRec.app.stop();
        appRec.clear();
    }

    @Override
    public String[] startedApplications() throws TrackerException {
        AppRec appRec;
        int n;
        int n2 = 0;
        if (this.maintainApp.size() == 0) {
            return null;
        }
        for (n = 0; n < this.maintainApp.size(); ++n) {
            appRec = (AppRec)this.maintainApp.get(n);
            if (!appRec.isSet()) continue;
            ++n2;
        }
        if (n2 == 0) {
            return null;
        }
        String[] stringArray = new String[n2];
        int n3 = 0;
        for (n = 0; n < this.maintainApp.size(); ++n) {
            appRec = (AppRec)this.maintainApp.get(n);
            if (!appRec.isSet()) continue;
            stringArray[n3] = appRec.appName;
            ++n3;
        }
        return stringArray;
    }

    @Override
    public synchronized String[] availableApplications() throws TrackerException {
        String[] stringArray = new String[this.maintainApp.size()];
        for (int i = 0; i < this.maintainApp.size(); ++i) {
            AppRec appRec = (AppRec)this.maintainApp.get(i);
            stringArray[i] = appRec.appName;
        }
        return stringArray;
    }

    @Override
    public void writeFile(String string, String string2) throws TrackerException {
        int n;
        FileInputStream fileInputStream;
        this.readyForCommand();
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileAccessException(fileNotFoundException.toString());
        }
        catch (SecurityException securityException) {
            throw new FileAccessException(securityException.toString());
        }
        try {
            n = this.ftpClient.sendStart(string2);
            if (n != 150) {
                throw this.exceptionFromResponse(this.ftpClient, n);
            }
        }
        catch (FtpException ftpException) {
            throw this.convertFtpExc(ftpException);
        }
        try {
            int n2;
            byte[] byArray;
            int n3 = fileInputStream.available();
            int n4 = n3 / 1200;
            if (n4 > 0) {
                byArray = new byte[1200];
                for (int i = 0; i < n4; ++i) {
                    fileInputStream.read(byArray);
                    this.ftpClient.sendBuffer(byArray);
                }
            }
            if ((n2 = n3 % 1200) > 0) {
                byArray = new byte[n2];
                fileInputStream.read(byArray);
                this.ftpClient.sendBuffer(byArray);
            }
        }
        catch (FtpException ftpException) {
            try {
                this.ftpClient.sendAbort();
            }
            catch (FtpException ftpException2) {
                // empty catch block
            }
            throw this.convertFtpExc(ftpException);
        }
        catch (IOException iOException) {
            try {
                this.ftpClient.sendAbort();
            }
            catch (FtpException ftpException) {
                // empty catch block
            }
            throw new FileAccessException(iOException.toString());
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
        }
        try {
            n = this.ftpClient.sendEnd();
            if (n != 226) {
                throw this.exceptionFromResponse(this.ftpClient, n);
            }
        }
        catch (FtpException ftpException) {
            throw this.convertFtpExc(ftpException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFile(String string, String string2) throws TrackerException {
        FileOutputStream fileOutputStream;
        TrackerException trackerException = null;
        this.readyForCommand();
        byte[] byArray = new byte[1200];
        try {
            fileOutputStream = new FileOutputStream(string, false);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileAccessException(fileNotFoundException.toString());
        }
        catch (SecurityException securityException) {
            throw new FileAccessException(securityException.toString());
        }
        try {
            int n;
            int n2 = this.ftpClient.receiveStart(string2);
            if (150 != n2) {
                throw this.exceptionFromResponse(this.ftpClient, n2);
            }
            do {
                if ((n = this.ftpClient.receiveBuffer(byArray)) <= 0) continue;
                fileOutputStream.write(byArray, 0, n);
            } while (n > 0);
        }
        catch (FtpException ftpException) {
            trackerException = this.convertFtpExc(ftpException);
        }
        catch (IOException iOException) {
            trackerException = new FileAccessException(iOException.toString());
        }
        finally {
            block31: {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
                try {
                    int n = this.ftpClient.receiveEnd();
                    if (226 != n) {
                        trackerException = this.exceptionFromResponse(this.ftpClient, n);
                    }
                }
                catch (FtpException ftpException) {
                    if (null != trackerException) break block31;
                    trackerException = this.convertFtpExc(ftpException);
                }
            }
        }
        if (null != trackerException) {
            throw trackerException;
        }
    }

    @Override
    public void changeAlarmCfg(int n, AlarmType alarmType) throws TrackerException {
        DataTag[] dataTagArray = new DataTag[3];
        Object[] objectArray = new Object[3];
        if (n < 1 || n > 8) {
            throw new UnsupportedFeatureException(Tracker.res.getString("Unknown_Alarm_Number"));
        }
        String string = "alarm." + n;
        dataTagArray[0] = new DataTagUnsigned32(string + ".type");
        dataTagArray[1] = new DataTagDouble(string + ".setpoint");
        dataTagArray[2] = new DataTagDouble(string + ".deviation");
        this.fillAlarmData(alarmType, objectArray);
        this.writeOneTimeData(dataTagArray, objectArray);
    }

    private void fillAlarmData(AlarmType alarmType, Object[] objectArray) throws TrackerException {
        if (alarmType instanceof DeviationAlarm) {
            objectArray[0] = new Long(1L);
            objectArray[1] = new Double(((DeviationAlarm)alarmType).getSetPoint());
            objectArray[2] = new Double(((DeviationAlarm)alarmType).getDeviation());
            return;
        }
        if (alarmType instanceof NullAlarm) {
            objectArray[0] = new Long(0L);
            objectArray[1] = new Double(20.0);
            objectArray[2] = new Double(5.0);
            return;
        }
        if (alarmType instanceof HighAlarm) {
            objectArray[0] = new Long(2L);
            objectArray[1] = new Double(((HighAlarm)alarmType).getSetPoint());
            objectArray[2] = new Double(5.0);
            return;
        }
        if (alarmType instanceof LowAlarm) {
            objectArray[0] = new Long(3L);
            objectArray[1] = new Double(((LowAlarm)alarmType).getSetPoint());
            objectArray[2] = new Double(5.0);
            return;
        }
        throw new UnsupportedFeatureException(Tracker.res.getString("Unknown_Alarm_Type"));
    }

    @Override
    public AlarmType alarmCfg(int n) throws TrackerException {
        DataTag[] dataTagArray = new DataTag[3];
        Object[] objectArray = null;
        String string = "";
        if (n < 1 || n > 8) {
            throw new UnsupportedFeatureException(Tracker.res.getString("Unknown_Alarm_Number"));
        }
        string = "alarm." + n;
        dataTagArray[0] = new DataTagUnsigned32(string + ".type");
        dataTagArray[1] = new DataTagDouble(string + ".setpoint");
        dataTagArray[2] = new DataTagDouble(string + ".deviation");
        objectArray = this.readOneTimeData(dataTagArray);
        return this.getAlarmType(n, objectArray);
    }

    private AlarmType getAlarmType(int n, Object[] objectArray) throws TrackerException {
        long l = (Long)objectArray[0];
        if (l == 0L) {
            return new NullAlarm();
        }
        if (l == 2L) {
            return new HighAlarm((Double)objectArray[1]);
        }
        if (l == 3L) {
            return new LowAlarm((Double)objectArray[1]);
        }
        if (l == 1L) {
            return new DeviationAlarm((Double)objectArray[1], (Double)objectArray[2]);
        }
        return new NullAlarm();
    }

    @Override
    public ExtTempType externalTempType(int n) throws TrackerException {
        DataTag[] dataTagArray = new DataTag[1];
        if (n < 1 || n > 8) {
            throw new UnsupportedFeatureException(Tracker.res.getString("Unknown_Sensor_Number"));
        }
        String string = "weather.device.temperature.ext" + n + ".type";
        dataTagArray[0] = new DataTagUnsigned32(string);
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        ExtTempType extTempType = (Long)objectArray[0] == 1L ? new AirExtTemp() : ((Long)objectArray[0] == 2L ? new MaterialExtTemp() : new NullExtTemp());
        return extTempType;
    }

    @Override
    public void changeExternalTempType(int n, ExtTempType extTempType) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Cannot_Change_External_Temp_Type"));
    }

    @Override
    public boolean externalTempTypeChangeable() throws TrackerException {
        return false;
    }

    @Override
    public int numExternalTempSensors() throws TrackerException {
        return 8;
    }

    @Override
    public double measureExternalTempSensor(int n) throws TrackerException {
        DataTag[] dataTagArray = new DataTag[2];
        if (n < 1 || n > 8) {
            throw new UnsupportedFeatureException(Tracker.res.getString("Unknown_Sensor_Number"));
        }
        dataTagArray[0] = new DataTagDouble("weather.device.temperature.ext" + n + ".reading.value");
        dataTagArray[1] = new DataTagUnsigned16("weather.device.temperature.ext" + n + ".reading.status");
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        int n2 = (Integer)objectArray[1];
        if ((n2 & 1) != 0) {
            throw new InternalDeviceFailureException(Tracker.res.getString("Sensor_Error"));
        }
        if ((n2 & 2) != 0) {
            throw new InternalDeviceFailureException(Tracker.res.getString("Sensor_Inaccurate"));
        }
        return (Double)objectArray[0];
    }

    @Override
    public boolean standardPrivilege() throws TrackerException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        return this.accessLevel >= 0;
    }

    @Override
    public boolean adminPrivilege() throws TrackerException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        return this.accessLevel >= 1;
    }

    @Override
    public boolean factoryPrivilege() throws TrackerException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        return this.accessLevel >= 2;
    }

    @Override
    public void readFileAbort() {
        try {
            this.ftpClient.sendAbort();
        }
        catch (FtpException ftpException) {
            // empty catch block
        }
    }

    @Override
    public void writeFileAbort() {
        try {
            this.ftpClient.sendAbort();
        }
        catch (FtpException ftpException) {
            // empty catch block
        }
    }

    @Override
    public boolean admScanCapable() throws TrackerException {
        return this.isADMScanCapable;
    }

    @Override
    public TargetType[] availableTargetType() throws TrackerException {
        TargetType[] targetTypeArray = null;
        int n = 5;
        if (this.is_1_5_WindowedSMRTargetCapable) {
            ++n;
        }
        if (this.is_7_8_WindowedSMRTargetCapable) {
            ++n;
        }
        targetTypeArray = new TargetType[n];
        int n2 = 0;
        targetTypeArray[n2++] = new SMRTargetType(0.0381);
        targetTypeArray[n2++] = new MirrorTargetType();
        targetTypeArray[n2++] = new SMRTargetType(0.0127);
        targetTypeArray[n2++] = new SMRTargetType(0.022225);
        targetTypeArray[n2++] = new SMRTargetType(0.0);
        if (this.is_1_5_WindowedSMRTargetCapable) {
            targetTypeArray[n2++] = new WindowedSMRTargetType(0.0381);
        }
        if (this.is_7_8_WindowedSMRTargetCapable) {
            targetTypeArray[n2++] = new WindowedSMRTargetType(0.022225);
        }
        return targetTypeArray;
    }

    @Override
    public WeatherInformation getWeatherInfo() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[9];
        int n = 0;
        dataTagArray[0] = new DataTagDouble("weather.current.air_temperature.value");
        dataTagArray[1] = new DataTagUnsigned16("weather.current.air_temperature.status");
        dataTagArray[2] = new DataTagDouble("weather.current.air_pressure.value");
        dataTagArray[3] = new DataTagUnsigned16("weather.current.air_pressure.status");
        dataTagArray[4] = new DataTagDouble("weather.current.humidity.value");
        dataTagArray[5] = new DataTagUnsigned16("weather.current.humidity.status");
        dataTagArray[6] = new DataTagUnsigned32("weather.config.air_temperature.source");
        dataTagArray[7] = new DataTagUnsigned32("weather.config.air_pressure.source");
        dataTagArray[8] = new DataTagUnsigned32("weather.config.humidity.source");
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        double d = (Double)objectArray[0];
        double d2 = (Double)objectArray[2];
        double d3 = (Double)objectArray[4];
        long l = (Long)objectArray[6];
        long l2 = (Long)objectArray[7];
        long l3 = (Long)objectArray[8];
        n = (Integer)objectArray[1] | (Integer)objectArray[3] | (Integer)objectArray[5];
        if (0 == (n & 0xFFFFFFBF)) {
            return new WeatherInformation(d, d2, d3, l, l2, l3);
        }
        if ((n & 1) != 0) {
            throw new InternalDeviceFailureException(Tracker.res.getString("Sensor_Error"));
        }
        if ((n & 0x80) != 0) {
            throw new InternalDeviceFailureException(Tracker.res.getString("Sensor_Disabled"));
        }
        if ((n & 2) != 0) {
            throw new InternalDeviceFailureException(Tracker.res.getString("Sensor_Inaccurate"));
        }
        throw new InternalDeviceFailureException(Tracker.res.getString("Sensor_Unknown_Error"));
    }

    @Override
    public String getSerialNumber() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[4];
        String string = "";
        dataTagArray[0] = new DataTagUnsigned32("system.serial_num.value");
        dataTagArray[1] = new DataTagUnsigned32("system.serial_type.value");
        dataTagArray[2] = new DataTagUnsigned16("system.serial_num.status");
        dataTagArray[3] = new DataTagUnsigned16("system.serial_type.status");
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        long l = (Long)objectArray[0];
        long l2 = (Long)objectArray[1];
        int n = (Integer)objectArray[2];
        int n2 = (Integer)objectArray[3];
        if (0 == n && 0 == n2) {
            if (0L != (8L & l2)) {
                if (0L != (1L & l2) && 0L == (2L & l2)) {
                    string = "L04";
                }
            } else if (this.isAdaptiveFilterCapable) {
                if (0L != (2L & l2)) {
                    string = "Y01";
                    if (0L != (1L & l2)) {
                        string = "Y02";
                    }
                }
            } else if (this.isADMScanCapable) {
                if (0L != (2L & l2)) {
                    string = "X01";
                    if (0L != (1L & l2)) {
                        string = "X02";
                    }
                }
            } else if (0L != (1L & l2)) {
                string = "L01";
                if (0L != (2L & l2)) {
                    string = "L03";
                }
            }
        }
        if (string == "") {
            return new String("FARO Tracker");
        }
        string = string + "00";
        String string2 = "" + l;
        int n3 = 7 - string2.length();
        for (int i = 0; i < n3; ++i) {
            string = string + "0";
        }
        string = string + l;
        return string;
    }

    @Override
    public String getIPAddress() throws TrackerException {
        return this.ipAddressToUse;
    }

    @Override
    public boolean readyToInitialize(boolean bl) throws TrackerException {
        Object[] objectArray;
        DataTag[] dataTagArray = new DataTag[1];
        if (!bl) {
            dataTagArray[0] = new DataTagUnsigned32("system.smart_warmup.state");
            try {
                objectArray = this.readOneTimeData(dataTagArray);
                long l = (Long)objectArray[0];
                if (l == 1L) {
                    return false;
                }
            }
            catch (TrackerException trackerException) {
                // empty catch block
            }
        }
        dataTagArray[0] = new DataTagUnsigned32("system.serial_type.value");
        objectArray = this.readOneTimeData(dataTagArray);
        long l = (Long)objectArray[0];
        if (0L != (1L & l)) {
            dataTagArray[0] = new DataTagUnsigned32("position_device.interferometer.laser_control.state");
            objectArray = this.readOneTimeData(dataTagArray);
            long l2 = (Long)objectArray[0];
            if (l2 != 2L) {
                return false;
            }
        } else if (0L == (2L & l)) {
            return false;
        }
        return true;
    }

    @Override
    public synchronized void factoryConnect(String string, String string2, String string3) throws TrackerException {
        boolean bl;
        boolean bl2 = bl = this.accessLevel >= 2;
        if (!bl) {
            throw new PermissionException(Tracker.res.getString("Connect_As_Factory_To_Use_The_Method"));
        }
        if (this.isConnected()) {
            throw new TrackerException(Tracker.res.getString("Disconnect_As_Factory_To_Use_The_Method"));
        }
        if (!this.factoryDisconnect) {
            throw new TrackerException(Tracker.res.getString("Connect_Disconnect_With_Right_Methods"));
        }
        Object var5_5 = null;
        this.ftpClient = new Ftp(this.portUtility);
        try {
            this.ftpClient.connect(string, string2, string3);
            this.factoryConnect = true;
            this.factoryDisconnect = false;
        }
        catch (FtpException ftpException) {
            this.ftpClient = null;
            throw new ConnectFailedException(ftpException.toString());
        }
    }

    @Override
    public void factoryDisconnect() throws TrackerException {
        boolean bl;
        boolean bl2 = bl = this.accessLevel >= 2;
        if (!bl) {
            throw new PermissionException(Tracker.res.getString("Connect_As_Factory_To_Use_The_Method"));
        }
        if (!this.isConnected()) {
            throw new TrackerException(Tracker.res.getString("Connect_Disconnect_With_Right_Methods"));
        }
        try {
            this.ftpClient.disconnect();
        }
        catch (FtpIOException ftpIOException) {
        }
        catch (FtpNoResponseException ftpNoResponseException) {
        }
        catch (FtpException ftpException) {
            // empty catch block
        }
        this.ftpClient = null;
        this.factoryDisconnect = true;
        this.factoryConnect = false;
        this.oldmeasureCfg = null;
        this.oldmeasureTags = null;
        this.oldbkndMeasureCfg = null;
        this.oldbkndMeasureTags = null;
        this.oldfactoryBkndMeasureCfg = null;
        this.oldfactoryBkndMeasureTags = null;
    }

    @Override
    public TrackerApp stopApplication(String string, boolean bl) throws TrackerException {
        if (bl && !this.isConnected()) {
            throw new NotConnectedException();
        }
        AppRec appRec = this.findAppInfo(string);
        if (!appRec.isSet()) {
            return null;
        }
        TrackerApp trackerApp = appRec.app;
        this.localStopApplication(appRec);
        return trackerApp;
    }

    @Override
    public int applicationExitCode(String string) throws TrackerException {
        AppRec appRec = this.findAppInfo(string);
        if (appRec.app != null) {
            return appRec.app.applicationExitCode();
        }
        return appRec.appExitCode;
    }

    @Override
    public void releaseLock() throws TrackerException {
        this.trackerCommand("release_lock", 10000);
    }

    @Override
    public void startSlew(double d, double d2, double d3) throws TrackerException {
        double d4 = 2.0;
        int n = 10000;
        if (Math.abs(d) > d4 || Math.abs(d2) > d4) {
            throw new TrackerException(Tracker.res.getString("Invalid_Velocity_Value"));
        }
        if (d3 < 0.0) {
            throw new TrackerException(Tracker.res.getString("Invalid_Min_Value_Slew"));
        }
        if (d3 > 0.0) {
            this.trackerCommand("slew " + d + " " + d2 + " " + d3, n);
        } else {
            this.trackerCommand("slew " + d + " " + d2, n);
        }
    }

    @Override
    public void startSlew(double d, double d2) throws TrackerException {
        this.startSlew(d, d2, 0.0);
    }

    @Override
    public void stopSlew() throws TrackerException {
        this.startSlew(0.0, 0.0);
    }

    @Override
    public boolean isResultReportingCapable() throws TrackerException {
        return this.isResultReportCapable;
    }

    @Override
    public boolean isAdaptiveFilterCapable() throws TrackerException {
        return this.isAdaptiveFilterCapable;
    }

    @Override
    public ApplicationResults applicationResults(String string) throws TrackerException {
        if (!this.isResultReportCapable) {
            throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
        }
        DataTag[] dataTagArray = new DataTag[2];
        ApplicationResults applicationResults = null;
        if (string.equalsIgnoreCase("Pointing")) {
            dataTagArray[0] = new DataTagUnsigned32("system.aim_it.result.value");
            dataTagArray[1] = new DataTagUnsigned32("system.aim_it.time.value");
        } else if (string.equalsIgnoreCase("AngularAccuracy")) {
            dataTagArray[0] = new DataTagUnsigned32("system.aa_check.result.value");
            dataTagArray[1] = new DataTagUnsigned32("system.aa_check.time.value");
        } else if (string.equalsIgnoreCase("ADM")) {
            dataTagArray[0] = new DataTagUnsigned32("system.adm_check.result.value");
            dataTagArray[1] = new DataTagUnsigned32("system.adm_check.time.value");
        } else {
            if (string.equalsIgnoreCase("HealthChecks") || string.equalsIgnoreCase("StartupChecks") || string.equalsIgnoreCase("SelfCompensation")) {
                return this.getAppResults(string);
            }
            throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
        }
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        long l = (Long)objectArray[0];
        long l2 = (Long)objectArray[1];
        switch ((int)l) {
            case 0: {
                applicationResults = new ApplicationResults("Pass", l2);
                break;
            }
            case 1: {
                applicationResults = new ApplicationResults("Fail", l2);
                break;
            }
            case 2: {
                applicationResults = new ApplicationResults("Recommendation", l2);
                break;
            }
            default: {
                applicationResults = new ApplicationResults("Recommendation", l2);
            }
        }
        return applicationResults;
    }

    private ApplicationResults getAppResults(String string) throws TrackerException {
        if (!(string.equalsIgnoreCase("HealthChecks") || string.equalsIgnoreCase("StartupChecks") || string.equalsIgnoreCase("SelfCompensation"))) {
            return new ApplicationResults("Unknown result", 0L);
        }
        if (string.equalsIgnoreCase("SelfCompensation")) {
            string = "CompIT";
        }
        AppRec appRec = this.findAppInfo(string);
        int n = appRec.appExitCode;
        if (null != appRec.app) {
            return appRec.app.applicationResults();
        }
        if (0 == n || 1 == n) {
            if (appRec.app != null) {
                return appRec.app.applicationResults();
            }
            return appRec.appResults;
        }
        return new ApplicationResults("Unknown result", 0L);
    }

    @Override
    public boolean is_1_5_WindowedSMRTargetCapable() throws TrackerException {
        return this.is_1_5_WindowedSMRTargetCapable;
    }

    @Override
    public boolean is_7_8_WindowedSMRTargetCapable() throws TrackerException {
        return this.is_7_8_WindowedSMRTargetCapable;
    }

    private MPEResultsData getADMError(double d, double d2) throws TrackerException {
        double d3 = Math.abs(d - d2);
        double d4 = this.calculateADMMPE(d);
        return new MPEResultsData(d3, d4, d3 / d4, d3 <= d4);
    }

    private MPEResultsData getAACError(double[] dArray, double[] dArray2) throws TrackerException {
        double[] dArray3 = new double[]{dArray[0] - dArray2[0], dArray[1] - dArray2[1], dArray[2] - dArray2[2]};
        double d = this.distanceInSpace(dArray3);
        double d2 = this.distanceInSpace(dArray);
        double d3 = this.calculateTransverseMPE(d2);
        return new MPEResultsData(d, d3, d / d3, d <= d3);
    }

    @Override
    public MPEResultsData checkADMAgainstIFM(SimplePointPairData simplePointPairData) throws TrackerException {
        double[] dArray = simplePointPairData.getSecondPoint();
        double[] dArray2 = simplePointPairData.getFirstPoint();
        return this.getADMError(dArray2[2], dArray[2]);
    }

    private void pointSphereToCart(double[] dArray) {
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = Math.sin(dArray[1]);
        dArray[0] = d3 * Math.cos(d) * d4;
        dArray[1] = d3 * Math.sin(d) * d4;
        dArray[2] = d3 * Math.cos(d2);
    }

    private double distanceInSpace(double[] dArray) {
        return Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
    }

    @Override
    public MPEResultsData checkAngularAccuracyError(SimplePointPairData simplePointPairData) throws TrackerException {
        double[] dArray = simplePointPairData.getSecondPoint();
        double[] dArray2 = simplePointPairData.getFirstPoint();
        this.pointSphereToCart(dArray);
        this.pointSphereToCart(dArray2);
        return this.getAACError(dArray2, dArray);
    }

    @Override
    public boolean isSelfCompensationNoUICapable() throws TrackerException {
        String string = "CompIT";
        AppRec appRec = this.findAppInfo(string);
        Class<?> clazz = null;
        try {
            this.jarClassLoader.setAppName(string);
            clazz = this.jarClassLoader.loadClass(appRec.fullQualifiedName);
            return this.isSelfCompNoUISupported(clazz);
        }
        catch (FtpException ftpException) {
        }
        catch (TrackerException trackerException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    private boolean isSelfCompNoUISupported(Class clazz) {
        try {
            Class clazz2 = clazz.getSuperclass();
            Method method = clazz2.getMethod("isSelfCompNoUICapable", null);
            return true;
        }
        catch (Exception exception) {
            PrintException.print(exception);
        }
        catch (Error error) {
            PrintException.print(error);
        }
        return false;
    }

    @Override
    public void changeAirTemperatureToHardware() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("weather.config.air_temperature.source")};
        Object[] objectArray = new Object[]{new Long(1L)};
        this.writeOneTimeData(dataTagArray, objectArray);
    }

    @Override
    public void changeAirPressureToHardware() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("weather.config.air_pressure.source")};
        Object[] objectArray = new Object[]{new Long(1L)};
        this.writeOneTimeData(dataTagArray, objectArray);
    }

    @Override
    public void changeHumidityToHardware() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("weather.config.humidity.source")};
        Object[] objectArray = new Object[]{new Long(1L)};
        this.writeOneTimeData(dataTagArray, objectArray);
    }

    @Override
    public void changeAirTemperatureToManual(double d) throws TrackerException {
        DataTag[] dataTagArray = new DataTag[2];
        if (d > 60.0 || d < -20.0) {
            throw new TrackerException(Tracker.res.getString("Air_Temperature_Value_Out_Of_Bounds"));
        }
        dataTagArray[0] = new DataTagUnsigned32("weather.config.air_temperature.source");
        dataTagArray[1] = new DataTagDouble("weather.config.air_temperature.manual");
        Object[] objectArray = new Object[]{new Long(2L), new Double(d)};
        this.writeOneTimeData(dataTagArray, objectArray);
    }

    @Override
    public void changeAirPressureToManual(double d) throws TrackerException {
        DataTag[] dataTagArray = new DataTag[2];
        if (d > 900.0 || d < 225.0) {
            throw new TrackerException(Tracker.res.getString("Air_Pressure_Value_Out_Of_Bounds"));
        }
        dataTagArray[0] = new DataTagUnsigned32("weather.config.air_pressure.source");
        dataTagArray[1] = new DataTagDouble("weather.config.air_pressure.manual");
        Object[] objectArray = new Object[]{new Long(2L), new Double(d)};
        this.writeOneTimeData(dataTagArray, objectArray);
    }

    @Override
    public void changeHumidityToManual(double d) throws TrackerException {
        DataTag[] dataTagArray = new DataTag[2];
        if (d > 100.0 || d < 0.0) {
            throw new TrackerException(Tracker.res.getString("Humidity_Value_Out_Of_Bounds"));
        }
        dataTagArray[0] = new DataTagUnsigned32("weather.config.humidity.source");
        dataTagArray[1] = new DataTagDouble("weather.config.humidity.manual");
        Object[] objectArray = new Object[]{new Long(2L), new Double(d / 100.0)};
        this.writeOneTimeData(dataTagArray, objectArray);
    }

    @Override
    public void changeLedState(int n, int n2) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public VideoData[] readVideoData() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void startVideo(VideoCfg videoCfg) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void stopVideo() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void changeGestureState(boolean bl) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean gestureRecognitionOn() throws TrackerException {
        return false;
    }

    @Override
    public boolean wirelessCapable() throws TrackerException {
        return false;
    }

    @Override
    public boolean videoCapable() throws TrackerException {
        return false;
    }

    @Override
    public boolean gesturesCapable() throws TrackerException {
        return false;
    }

    @Override
    public void searchUsingCamera() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    private double calculateADMMPE(double d) throws TrackerException {
        DataTag[] dataTagArray;
        Object[] objectArray;
        if (0.0 == this.admMPEOffset && 0.0 == this.admMPEScale && null != (objectArray = this.readOneTimeData(dataTagArray = new DataTag[]{new DataTagDouble("system.spec.adm.offset.value"), new DataTagUnsigned16("system.spec.adm.offset.status"), new DataTagDouble("system.spec.adm.scale.value"), new DataTagUnsigned16("system.spec.adm.scale.status")}))) {
            int n = 0;
            this.admMPEOffset = (Double)objectArray[n++];
            int n2 = (Integer)objectArray[n++];
            this.admMPEScale = (Double)objectArray[n++];
            int n3 = (Integer)objectArray[n++];
            if (0 == n2 && 0 == n3) {
                this.performanceParametersSetForTracker = true;
            }
        }
        if (!this.performanceParametersSetForTracker) {
            throw new InternalTrackerException();
        }
        double d2 = this.admMPEOffset + d * this.admMPEScale;
        return d2;
    }

    private double calculateTransverseMPE(double d) throws TrackerException {
        DataTag[] dataTagArray;
        Object[] objectArray;
        double d2 = 0.0;
        if (0.0 == this.transverseMPEOffset && 0.0 == this.transverseMPEScale && null != (objectArray = this.readOneTimeData(dataTagArray = new DataTag[]{new DataTagDouble("system.spec.transverse.offset.value"), new DataTagUnsigned16("system.spec.transverse.offset.status"), new DataTagDouble("system.spec.transverse.scale.value"), new DataTagUnsigned16("system.spec.transverse.scale.status")}))) {
            int n = 0;
            this.transverseMPEOffset = (Double)objectArray[n++];
            int n2 = (Integer)objectArray[n++];
            this.transverseMPEScale = (Double)objectArray[n++];
            int n3 = (Integer)objectArray[n++];
            if (0 == n2 && 0 == n3) {
                this.performanceParametersSetForTracker = true;
            }
        }
        if (!this.performanceParametersSetForTracker) {
            throw new InternalTrackerException();
        }
        double d3 = this.transverseMPEOffset + d * this.transverseMPEScale;
        d2 = 2.0 * d3;
        return d2;
    }

    @Override
    public boolean isQuickCompensationNoUICapable() throws TrackerException {
        return false;
    }

    @Override
    public boolean isAACNoUICapable() throws TrackerException {
        return false;
    }

    @Override
    public int smartWarmupWaitState() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean home(boolean bl, boolean bl2) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public int applicationPercentComplete(String string) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void resetCameras() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void comboSearch(double d, double d2, double d3, double d4, double d5, boolean bl) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void comboSearchInternal(double d, double d2, double d3) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean didAACPassSinceInitialization() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean isNoUICompCalCapable() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public int batteryChargeRemaining(int n) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void factoryDisconnect(String string) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public int batteryState(int n) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void changePowerButtonState(boolean bl) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean powerButtonState() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void reboot() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean isFollowMeCapable() throws TrackerException {
        return false;
    }

    @Override
    public void changeFollowMeState(boolean bl) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean isFollowMeOn() throws TrackerException {
        return false;
    }

    @Override
    public double getFollowMeSearchRadius() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void changeFollowMeSearchRadius(double d) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean sixDofCapable() throws TrackerException {
        return false;
    }

    @Override
    public Probe[] availableProbes() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void addProbe(Probe probe) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void removeProbe(Probe probe) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void modifyProbe(Probe probe) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void changeProbe(Probe probe, boolean bl) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public Probe probe() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public String probeAdapter() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean probeAdapterConnected() throws TrackerException {
        return false;
    }

    @Override
    public ProbeCompensationData calcProbeCompensationParameters(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public ProbeCalibrationData calibrateProbeTip(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public ProbeCalibrationData calibrateISOProbeTip(double[] dArray, double[] dArray2, double[] dArray3) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void updateProbeCompensationParameters(Probe probe, ProbeCompensationData probeCompensationData) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void updateProbeCompensationParameters(Probe probe, double d, double d2, double d3) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void updateProbeCompensationParameters(Probe probe, double d, double d2, double d3, double d4) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean sixDofEnabled() throws TrackerException {
        return false;
    }

    @Override
    public void changeSixDofEnableState(boolean bl) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public int probeBatteryChargeRemaining() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void removeAllProbes() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void removeAllFactoryProbes() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public double getDelayFromPassiveToActiveFollowMe() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void setDelayFromPassiveToActiveFollowMe(double d) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public int probeBatteryState() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean probeBatteryStateChangeEventSupported() throws TrackerException {
        return false;
    }

    @Override
    public boolean wirelessStateChangeSupported() throws TrackerException {
        return false;
    }

    @Override
    public void changeWirelessState(boolean bl) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean wirelessOn() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean isCatEyeTargetCapable() throws TrackerException {
        return false;
    }

    @Override
    public boolean laserOn() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void changeLaserState(boolean bl) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public int connectionType() {
        int n = 0;
        if (this.isConnected()) {
            n = 1;
        }
        return n;
    }

    @Override
    public int runAutomatedComp() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void setPort(PortUtility portUtility) {
        this.portUtility = portUtility;
    }

    @Override
    public boolean homeRequired() throws TrackerException {
        return false;
    }

    @Override
    public boolean autoCompRequired() throws TrackerException {
        return false;
    }

    @Override
    public boolean autoReconnectCapable() throws TrackerException {
        return false;
    }

    @Override
    public boolean trackerBatteryEventCapable() throws TrackerException {
        return false;
    }

    @Override
    public boolean autoCompCapable() throws TrackerException {
        return false;
    }

    @Override
    public boolean sixProbe2Capable() {
        return false;
    }

    @Override
    public int probeModelType() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void removeCompFromProbeCompHistory(Probe probe, double d) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public void useCompFromProbeCompHistory(Probe probe, double d) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public ProbeCompHistoryData[] probeCompHistory(Probe probe) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    @Override
    public boolean probeCompHistoryCapable() throws TrackerException {
        return false;
    }

    private class AppRec {
        public String appName;
        public String fullQualifiedName;
        public Object[] jarFileName;
        public TrackerApp app;
        public boolean readFromLocal = false;
        public int appExitCode = 3;
        public ApplicationResults appResults;

        public AppRec(String string, String string2, Object[] objectArray, boolean bl) {
            this.appName = string;
            this.fullQualifiedName = string2;
            this.jarFileName = objectArray;
            this.readFromLocal = bl;
            this.app = null;
            this.appResults = new ApplicationResults("Unknown result", 0L);
        }

        public void set(TrackerApp trackerApp) {
            this.app = trackerApp;
            this.appExitCode = 2;
        }

        public void clear() {
            try {
                if (this.app != null) {
                    this.appExitCode = this.app.applicationExitCode();
                    this.appResults = this.app.applicationResults();
                }
            }
            catch (TrackerException trackerException) {
                // empty catch block
            }
            this.app = null;
        }

        public boolean isSet() {
            return this.app != null;
        }
    }

    private class JarClassLoader
    extends SecureClassLoader {
        private String[] jarNamesToUse = null;
        private String ipAddress = null;

        private void downLoadJarFiles(AppRec appRec, boolean bl) throws ClassNotFoundException, TrackerException, FtpException {
            Object object;
            Object object2;
            int n;
            String[] stringArray = null;
            if (bl) {
                stringArray = (String[])appRec.jarFileName[1];
            } else {
                stringArray = (String[])appRec.jarFileName[0];
                this.setIpAddress();
            }
            if (stringArray == null) {
                System.err.println("tmpjarnames == null");
                throw new ClassNotFoundException(Tracker.res.getString("Cannot_Find_App_In_Firmware_Or_Local"));
            }
            int n2 = stringArray.length;
            ArrayList<Object> arrayList = new ArrayList<Object>(10);
            ArrayList<String> arrayList2 = new ArrayList<String>(10);
            for (n = 0; n < n2; ++n) {
                object2 = (JarFile)TrackerKeystone.this.jarCache.get(stringArray[n]);
                if (object2 != null) continue;
                URL uRL = null;
                try {
                    Object object3;
                    if (bl) {
                        object = "jar:file:/";
                        if (TrackerKeystone.this.fileDirectory.startsWith("//")) {
                            object = (String)object + "/";
                        }
                        object = (String)object + TrackerKeystone.this.fileDirectory + stringArray[n] + "!/";
                        uRL = new URL((String)object);
                    } else {
                        object = System.getProperty("java.io.tmpdir");
                        object3 = (String)object + "\\" + this.generateJarName();
                        TrackerKeystone.this.readFile((String)object3, stringArray[n]);
                        uRL = new URL("jar", "", -1, "file:/" + (String)object3 + "!/");
                        TrackerKeystone.this.tmpDownloadedJarsPath.add(object3);
                    }
                    object = (JarURLConnection)uRL.openConnection();
                    ((URLConnection)object).setUseCaches(false);
                    ((URLConnection)object).connect();
                    object3 = ((JarURLConnection)object).getJarFile();
                    arrayList2.add(stringArray[n]);
                    arrayList.add(object3);
                    continue;
                }
                catch (Exception exception) {
                    System.err.println("jar downloading error for jar name : " + stringArray[n] + " exception = " + exception.toString() + " msg = " + exception.getMessage());
                    Tracker.formmater.applyPattern(Tracker.res.getString("Error_Downloading_Jar"));
                    throw new ClassNotFoundException(Tracker.formmater.format(new Object[]{stringArray[n]}));
                }
            }
            this.jarNamesToUse = stringArray;
            for (n = 0; n < arrayList2.size(); ++n) {
                TrackerKeystone.this.jarCache.put(arrayList2.get(n), arrayList.get(n));
            }
            Collection collection = TrackerKeystone.this.jarCache.values();
            object2 = collection.iterator();
            int n3 = 0;
            while (object2.hasNext()) {
                object = (JarFile)object2.next();
                ++n3;
            }
        }

        public void setAppName(String string) throws ClassNotFoundException, TrackerException, FtpException {
            AppRec appRec = TrackerKeystone.this.findAppInfo(string);
            if (appRec == null) {
                throw new ClassNotFoundException(string);
            }
            boolean bl = appRec.readFromLocal;
            try {
                this.downLoadJarFiles(appRec, bl);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.downLoadJarFiles(appRec, !bl);
            }
        }

        @Override
        public URL getResource(String string) {
            try {
                int n;
                boolean bl = false;
                if (string.startsWith("smx/tracker/appskeystone/utility")) {
                    bl = true;
                }
                String[] stringArray = null;
                stringArray = this.jarNamesToUse;
                int n2 = stringArray.length;
                JarFile jarFile = null;
                for (n = 0; n < n2 && !(bl ? stringArray[n].indexOf("utility") != -1 : stringArray[n].indexOf("utility") == -1); ++n) {
                }
                jarFile = (JarFile)TrackerKeystone.this.jarCache.get(stringArray[n]);
                if (jarFile != null) {
                    return new URL("jar:file:/" + jarFile.getName() + "!/" + string);
                }
            }
            catch (Exception exception) {
                System.err.println("ex = " + exception.getMessage() + "\ntostr = " + exception.toString());
                return null;
            }
            return null;
        }

        @Override
        public InputStream getResourceAsStream(String string) {
            try {
                InputStream inputStream = null;
                Collection collection = TrackerKeystone.this.jarCache.values();
                for (JarFile jarFile : collection) {
                    inputStream = jarFile.getInputStream(new ZipEntry(string));
                    if (inputStream == null) continue;
                    return inputStream;
                }
            }
            catch (IOException iOException) {
                System.err.println("ex = " + iOException.getMessage() + "\nnew getResource failed bcoz of Exception : " + iOException.toString());
                return null;
            }
            return null;
        }

        public Class findClass(String string) throws ClassNotFoundException {
            Class<?> clazz = null;
            try {
                Object object;
                String string2 = string.replace('.', '/') + ".class";
                InputStream inputStream = null;
                Collection collection = TrackerKeystone.this.jarCache.values();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext() && (inputStream = ((JarFile)(object = (JarFile)iterator.next())).getInputStream(new ZipEntry(string2))) == null) {
                }
                if (inputStream == null) {
                    Tracker.formmater.applyPattern(Tracker.res.getString("No_Class_Found"));
                    throw new ClassNotFoundException(Tracker.formmater.format(new Object[]{string}));
                }
                object = this.loadClassData(inputStream);
                clazz = this.defineClass(string, (byte[])object, 0, ((Object)object).length);
                if (clazz == null) {
                    Tracker.formmater.applyPattern(Tracker.res.getString("Error_Defining_Class"));
                    throw new ClassNotFoundException(Tracker.formmater.format(new Object[]{string}));
                }
            }
            catch (Exception exception) {
                Tracker.formmater.applyPattern(Tracker.res.getString("Error_Accessing_Jar"));
                throw new ClassNotFoundException(Tracker.formmater.format(new Object[]{string}));
            }
            return clazz;
        }

        private byte[] loadClassData(InputStream inputStream) throws IOException {
            int n;
            int n2 = inputStream.available();
            byte[] byArray = new byte[n2];
            for (int i = inputStream.read(byArray, 0, n2); i < n2; i += n) {
                n = inputStream.read(byArray, i, n2 - i);
            }
            inputStream.close();
            return byArray;
        }

        private void setIpAddress() throws FtpException {
            if (this.ipAddress != null) {
                return;
            }
            byte[] byArray = TrackerKeystone.this.ftpClient.getRemoteIPAddress().getAddress();
            int[] nArray = new int[4];
            for (int i = 0; i < 4; ++i) {
                nArray[i] = byArray[i];
                if (nArray[i] >= 0) continue;
                int n = i;
                nArray[n] = nArray[n] + 256;
            }
            this.ipAddress = nArray[0] + "." + nArray[1] + "." + nArray[2] + "." + nArray[3];
        }

        private String generateJarName() {
            String string = "jar_cachefi";
            for (int i = 0; i < 20; ++i) {
                int n = TrackerKeystone.this.generator.nextInt(9) + 1;
                string = string + n;
            }
            string = string + ".tmp";
            return string;
        }
    }

    public static class ApplicationResultCode {
        public static final int PASS = 0;
        public static final int FAIL = 1;
        public static final int RECOMMANDATION = 2;
    }

    public static class ApplicationExitCode {
        public static final int CLOSED = 0;
        public static final int CANCELLED = 1;
        public static final int RUNNING = 2;
        public static final int NEVER_RUN = 3;
        public static final int UNSUPPORTED = 4;
    }

    public static class EncoderImproveState {
        public static final int DISABLE = 0;
        public static final int ENABLE = 1;
    }

    public static class ADMVelocityCompState {
        public static final int DISABLE = 0;
        public static final int ENABLE = 1;
    }

    public static class ADMAutoAdjustState {
        public static final int DISABLE = 0;
        public static final int ENABLE = 1;
    }

    public static class OnTrackerTargetThermalCompState {
        public static final int OFF = 0;
        public static final int ON = 1;
    }

    public static class SmartWarmUpState {
        public static final int OFF = 0;
        public static final int ON = 1;
    }

    public static class PayloadThermalCompState {
        public static final int OFF = 0;
        public static final int ON = 1;
    }

    public static class AutoGainAdjustState {
        public static final int DISABLE = 0;
        public static final int ENABLE = 1;
    }

    public static class AzPostThermalCompState {
        public static final int OFF = 0;
        public static final int ON = 1;
    }

    public static class AlarmOutput {
        public static final int OFF = 0;
        public static final int ON = 1;
    }

    public static class SMART_WARMUP_STATE {
        public static final int DEFAULT = 0;
        public static final int IN_PROGRESS = 1;
        public static final int DONE = 2;
        public static final int TERMINATE = 3;
        public static final int ERROR = 4;
    }

    public static class TRACKER_TYPE {
        public static final int IFM = 1;
        public static final int ADM = 2;
        public static final int NO_FINE_LEVEL = 4;
        public static final int ADVANTAGE = 8;
        public static final int X = 16;
        public static final int CAMERA = 32;
        public static final int FORCE_V3 = 64;
    }

    public static class ADM_ALIGNMENT {
        public static final int PEAK = 0;
        public static final int COLINEAR = 1;
    }

    public static class ADMState {
        public static final int FINE = 0;
        public static final int COARSE = 1;
        public static final int FORCED_FINE = 2;
        public static final int FORCED_COARSE = 3;
        public static final int ERROR = 4;
    }

    public static class TrackerOrientation {
        public static final int Z_UP = 0;
        public static final int Z_DOWN = 1;
        public static final int Y_UP = 2;
        public static final int Y_DOWN = 3;
        public static final int X_DOWN = 4;
        public static final int X_UP = 5;
    }

    public static class TempSensorType {
        public static final int NONE = 0;
        public static final int AIR = 1;
        public static final int MATERIAL = 2;
    }

    public static class TargetState {
        public static final int NO_TARGET = 0;
        public static final int MARGINAL_TARGET = 1;
        public static final int TARGET_PRESENT = 2;
    }

    public static class DistanceMeasureMode {
        public static final int USER_SPECIFIED = 0;
        public static final int IFM_ONLY = 1;
        public static final int IFM_SET_BY_ADM = 2;
        public static final int ADM_ONLY = 3;
    }

    public static class TypeOfTarget {
        public static final int SMR_3_2 = 0;
        public static final int MIRROR = 1;
        public static final int SMR_1_2 = 2;
        public static final int SMR_7_8 = 3;
        public static final int SMR_USER = 4;
        public static final int SMR_3_2_WINDOWED = 5;
        public static final int SMR_7_8_WINDOWED = 6;
    }

    public static class FBSightMode {
        public static final int FRONTSIGHT = 0;
        public static final int BACKSIGHT = 1;
    }

    public static class TrackingMode {
        public static final int ON = 0;
        public static final int OFF = 1;
    }

    public static class MotorState {
        public static final int OFF = 0;
        public static final int ON = 1;
        public static final int FULL_MANUAL_CONTROL = 2;
        public static final int TORQUE_MANUAL_CONTROL = 3;
        public static final int FAILED = 4;
        public static final int NEVER_INITIALIZED = 5;
        public static final int FULL_MANUAL_FAILED = 6;
        public static final int FULL_MANUAL_NEVER_INITIALIZED = 7;
        public static final int INITIALIZING = 8;
    }

    public static class InternalTemperatureStability {
        public static final int NOT_STABLE = 0;
        public static final int STABLE = 1;
        public static final int CANNOT_DETERMINE_STABILITY = 2;
    }

    public static class ControlState {
        public static final int OFF = 0;
        public static final int ON_UNLOCKED = 1;
        public static final int ON_LOCKED = 2;
        public static final int MANUAL = 3;
        public static final int ERROR = 4;
    }

    public static class PointBeamState {
        public static final int OFF = 0;
        public static final int ON = 2;
        public static final int ERROR = 4;
    }

    public static class AlarmSelect {
        public static final int NONE = 0;
        public static final int DEVIATION = 1;
        public static final int HIGH = 2;
        public static final int LOW = 3;
    }

    public static class InputSelect {
        public static final int NO_SELECTION = 0;
        public static final int HARDWARE_INPUT = 1;
        public static final int MANUAL_INPUT = 2;
    }

    public static class StatusBits {
        public static final int DATA_ERROR = 1;
        public static final int DATA_INACCURATE = 2;
        public static final int DATA_HARDWARE_ERROR = 4;
        public static final int DATA_HARDWARE_INACCURATE = 8;
        public static final int DATA_NOT_COMPENSATED = 16;
        public static final int DATA_NOT_INITIALIZED = 32;
        public static final int DATA_MANUAL = 64;
        public static final int DATA_DISABLED = 128;
        public static final int DATA_DEFAULT = 256;
        public static final int DATA_SUPPORTING_DATA_INACCURATE = 512;
        public static final int DATA_SUPPORTING_DATA_ERROR = 1024;
        public static final int DATA_ADAPTIVE_SAMPLING_INVALID = 4096;
    }
}

