/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.JarURLConnection;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.SecureClassLoader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import smx.ftp.CypherFtp;
import smx.ftp.FtpAbortedException;
import smx.ftp.FtpAlreadyConnectedException;
import smx.ftp.FtpBusyException;
import smx.ftp.FtpDataSocketException;
import smx.ftp.FtpException;
import smx.ftp.FtpIOException;
import smx.ftp.FtpNoResponseException;
import smx.ftp.FtpNotConnectedException;
import smx.ftp.FtpOutOfPortsException;
import smx.tracker.ADMOnly;
import smx.tracker.AbortedException;
import smx.tracker.AdaptiveFilter;
import smx.tracker.AdaptiveFilterInternal;
import smx.tracker.AirExtTemp;
import smx.tracker.Alarm;
import smx.tracker.AlarmType;
import smx.tracker.AlreadyConnectedException;
import smx.tracker.ApplicationFailedException;
import smx.tracker.ApplicationResults;
import smx.tracker.AsyncMsg;
import smx.tracker.AverageFilter;
import smx.tracker.BadCommandException;
import smx.tracker.BatteryState;
import smx.tracker.CatEyeTargetType;
import smx.tracker.Change;
import smx.tracker.CommunicationException;
import smx.tracker.ConnectFailedException;
import smx.tracker.ContinueTrigger;
import smx.tracker.CustomPortsException;
import smx.tracker.DataFormatException;
import smx.tracker.DataTag;
import smx.tracker.DataTagDouble;
import smx.tracker.DataTagUnsigned16;
import smx.tracker.DataTagUnsigned32;
import smx.tracker.DataTagUnsigned8;
import smx.tracker.DeviationAlarm;
import smx.tracker.DeviceLockedException;
import smx.tracker.Diagnostic;
import smx.tracker.DisconnectFailedException;
import smx.tracker.DistanceMode;
import smx.tracker.DistanceSetException;
import smx.tracker.DistanceTrigger;
import smx.tracker.DoubleFaultException;
import smx.tracker.ExtTempType;
import smx.tracker.ExternalContinueTrigger;
import smx.tracker.ExternalStartTrigger;
import smx.tracker.FileAccessException;
import smx.tracker.Filter;
import smx.tracker.HardwareNotInstalledException;
import smx.tracker.HighAlarm;
import smx.tracker.InterfaceBusyException;
import smx.tracker.InterferometerOnly;
import smx.tracker.InterferometerSetByADM;
import smx.tracker.InternalDeviceFailureException;
import smx.tracker.InternalTrackerException;
import smx.tracker.InterpolationFilter;
import smx.tracker.IntervalTrigger;
import smx.tracker.LaserStateException;
import smx.tracker.LevelData;
import smx.tracker.LowAlarm;
import smx.tracker.MPEResultsData;
import smx.tracker.MaterialExtTemp;
import smx.tracker.MaterialTemperatureData;
import smx.tracker.MeasureCfg;
import smx.tracker.MeasureData;
import smx.tracker.MeasurePointData;
import smx.tracker.MeasurePointStdDev;
import smx.tracker.MeasureStdDev;
import smx.tracker.MirrorTargetType;
import smx.tracker.MotorStateException;
import smx.tracker.NoDataAvailableException;
import smx.tracker.NoResponseException;
import smx.tracker.NoTargetException;
import smx.tracker.NotConnectedException;
import smx.tracker.NullAlarm;
import smx.tracker.NullContinueTrigger;
import smx.tracker.NullExtTemp;
import smx.tracker.NullFilter;
import smx.tracker.NullStartTrigger;
import smx.tracker.PermissionException;
import smx.tracker.PrintException;
import smx.tracker.Probe;
import smx.tracker.ProbeBatteryState;
import smx.tracker.ProbeButtonChange;
import smx.tracker.ProbeCalibrationData;
import smx.tracker.ProbeCompHistoryData;
import smx.tracker.ProbeCompensationData;
import smx.tracker.ProbeManager;
import smx.tracker.RequestException;
import smx.tracker.SMRTargetType;
import smx.tracker.SimplePointPairData;
import smx.tracker.SixDofTargetType;
import smx.tracker.StartTrigger;
import smx.tracker.Status;
import smx.tracker.StdDevFilter;
import smx.tracker.TargetType;
import smx.tracker.Tracker;
import smx.tracker.TrackerApp;
import smx.tracker.TrackerException;
import smx.tracker.TrackerInterface;
import smx.tracker.TrackingStateException;
import smx.tracker.UnsupportedFeatureException;
import smx.tracker.UserSpecifiedDistance;
import smx.tracker.VideoCfg;
import smx.tracker.VideoData;
import smx.tracker.WeatherInformation;
import smx.tracker.WindowedSMRTargetType;
import smx.utility.PortUtility;
import smx.utility.TrkDatagramSocket;
import smx.utility.TrkServerSocket;
import smx.utility.UtilityOutOfPortsException;

public class TrackerCypher
implements TrackerInterface {
    private CypherFtp ftpClient = null;
    private LinkedList maintainApp = null;
    private String fileDirectory = "";
    private int[] measureTypeList = null;
    private boolean generalMeasureFlag = false;
    private boolean readInProgress = false;
    private Filter measureFilter = null;
    private int[] bkndMeasureTypeList = null;
    private boolean bkndReadInProgress = false;
    private boolean bkndGeneralMeasureFlag = false;
    private Filter bkndMeasureFilter = null;
    private int[] factoryBkndMeasureTypeList = null;
    private boolean factoryBkndReadInProgress = false;
    private boolean factoryBkndGeneralMeasureFlag = false;
    private Filter factoryBkndMeasureFilter = null;
    private boolean cmdInProgress = false;
    private DatagramSocket dgSocket = null;
    private DatagramSocket bkndDgSocket = null;
    private DatagramSocket asyncSocket = null;
    private DatagramSocket factoryBkndDgSocket = null;
    private DatagramPacket packet = null;
    private DatagramPacket bkndPacket = null;
    private DatagramPacket asyncPacket = null;
    private DatagramPacket factoryBkndPacket = null;
    private ServerSocket asyncTcpSocket = null;
    private Socket asyncTcpClientSocket = null;
    private final int DATAGRAM_SOCKET_TIMEOUT = 5000;
    private byte[] buf = null;
    private byte[] bkndBuf = null;
    private byte[] asyncBuf = null;
    private byte[] factoryBkndBuf = null;
    private BufferedReader asyncInput = null;
    private boolean asyncReadInProgress = false;
    private boolean asyncReadInterrupted = false;
    private int accessLevel = 0;
    private boolean isAsyncTcp = false;
    private static final int NUM_TRIES_TCP_SERVER = 100;
    private int numTriesTcpServerLeft = 100;
    private static final int TCP_SERVER_PORT = 55555;
    private static final int UNSIGNED8 = 1;
    private static final int UNSIGNED16 = 2;
    private static final int UNSIGNED32 = 3;
    private static final int DOUBLE = 4;
    private static final int ACCESS_STANDARD = 0;
    private static final int ACCESS_ADMIN = 1;
    private static final int ACCESS_FACTORY = 2;
    private static final int JAR_FROM_TRACKER = 0;
    private static final int JAR_FROM_LOCAL = 1;
    private DataTag[] pointMeasurementTags = new DataTag[6];
    private boolean measureInProgress = false;
    private boolean bkndMeasureInProgress = false;
    private boolean factoryBkndMeasureInProgress = false;
    private MeasureCfg oldmeasureCfg = null;
    private DataTag[] oldmeasureTags = null;
    private int[] oldmeasureTypeList = null;
    private MeasureCfg oldbkndMeasureCfg = null;
    private DataTag[] oldbkndMeasureTags = null;
    private int[] oldbkndMeasureTypeList = null;
    private MeasureCfg oldfactoryBkndMeasureCfg = null;
    private DataTag[] oldfactoryBkndMeasureTags = null;
    private int[] oldfactoryBkndMeasureTypeList = null;
    private long MCUVersionNumber = 0L;
    private JarClassLoader jarClassLoader = null;
    private Map jarCache = Collections.synchronizedMap(new HashMap(500));
    private boolean factoryConnect = false;
    private boolean factoryDisconnect = false;
    private int NUM_EXT_TEMP_SENSORS = 4;
    ArrayList tmpDownloadedJarsPath = new ArrayList(10);
    Random generator = new Random();
    private String subCompApp = "";
    private static final int[] diagMap = new int[]{0, 8, 8, 8, 8, 8, 1, 4, 5, 8, 8, 3, 6, 8};
    private static final int[] changeMap = new int[]{0, 2, 1, 4, 3};
    private static final int[] statusMap = new int[]{0, 1, 2, 21, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 18, 16, 17, 19, 20, 0, 22, 23, 24};
    private static final int FILE_XFER_BUFFER_SIZE = 1200;
    private static final int TRACKER_SAMPLES_PER_SECOND = 1024;
    private static final int TRACKER_COMMAND_MIN_TIME_OUT = 15000;
    private static final double MAX_AIR_PRESSURE_VALUE = 900.0;
    private static final double MIN_AIR_PRESSURE_VALUE = 225.0;
    private static final double MAX_AIR_TEMP_VALUE = 60.0;
    private static final double MIN_AIR_TEMP_VALUE = -20.0;
    private static final double MAX_HUMIDITY_VALUE = 100.0;
    private static final double MIN_HUMIDITY_VALUE = 0.0;
    private static int EXTENDED_THERMAL_TIME = 2700;
    private static int LONG_THERMAL_TIME = 1200;
    private static int QUICK_THERMAL_TIME = 300;
    private static int DONE_THERMAL_TIME = 0;
    boolean sixDofCapableTrk = false;
    private boolean initialLocalAppValueSet = false;
    private boolean loadingLocalApp = false;
    boolean generalVideoFlag = false;
    boolean videoInProgress = false;
    private VideoCfg oldVideoCfg = null;
    private Socket videoSocket;
    private ServerSocket videoServerSocket;
    private InputStream videoRawInput;
    private DataInputStream videoInputStream;
    private boolean performanceParametersSetForTracker = false;
    private double admMPEOffset = 0.0;
    private double admMPEScale = 0.0;
    private double transverseMPEOffset = 0.0;
    private double transverseMPEScale = 0.0;
    boolean printed_once = false;
    final double MINIMUM_PSD_REQUIRED_TO_SAY_WE_ARE_ON_THE_TARGET = 0.1;
    final double COMBO_SPIRAL_RADIUS_WHEN_DISTANCE_IS_NOT_KNOWN = 0.007;
    final double COMBO_SPIRAL_RADIUS_WITH_KNOWN_DISTANCE = 0.007;
    private final int COMBO_SPIRAL_SEARCH_TIME_OUT = 10000;
    final double TIGHT_TOLERANCE = 0.005;
    final double WIDE_TOLERANCE = 0.02;
    final int FAR_FROM_CENTER_X_PIXEL = 400;
    final int FAR_FROM_CENTER_Y_PIXEL = 250;
    final double TOO_FAR_FROM_SEARCH_LOCATION_FOR_SPIRAL = 0.003;
    PrintWriter combo_search_log_writer = null;
    int combo_writer_step = 1;
    static boolean showed_once = false;
    private final int CAMERA_GESTURE_STATE_START_LOOKING_FOR_TARGET = 4;
    final double TIGHT_TOLERANCE_2_AZ = 0.006;
    final double WIDE_TOLERANCE_2_AZ = 0.01;
    final double TIGHT_TOLERANCE_2 = 0.0035;
    final double WIDE_TOLERANCE_2 = 0.007;
    final int FAR_FROM_CENTER_X_PIXEL_2 = 300;
    final int FAR_FROM_CENTER_Y_PIXEL_2 = 100;
    private final int MAX_TIME_TO_WAIT_FOR_CAMERA_DATA_AFTER_A_MOVE = 3500;
    private int bat1Alarm1Value = 0;
    private int bat1Alarm2Value = 0;
    private int bat2Alarm1Value = 0;
    private int bat2Alarm2Value = 0;
    private int bat1State = -1;
    private int bat2State = -1;
    private String ipAddressToUse = null;
    private boolean printOutput = false;
    private boolean localFactoryAccess = false;
    String genProbeChangeEventTagName = "sixdof.probe_software.change.value";
    Probe changeProbe = null;
    boolean genProbeChangeTagSupported = false;
    String probeAdapterNamePrefix = "6PRB";
    private int[] mcuVNum;
    private long powerVersionNumber = -1L;
    boolean isCatEyeTargetCapable = false;
    private int connectionType = 0;
    static String sessionId = "";
    boolean sessionIdFound = false;
    public static final int MAX_COMMUNICATION_DROP_TRIES = 3;
    private static String reconnectIp = null;
    private static String userName = null;
    private static String password = null;
    private static PrintWriter debugWriter = null;
    private static boolean disconnectCalled = false;
    private static boolean communicationDropSupported = false;
    public static int NONE = 1;
    public static int CMD = 2;
    public static int SEND_FILE = 3;
    public static int RECEIVE_FILE = 4;
    public static int DISCONNECT = 5;
    boolean debugLog = false;
    private static final int NOOP_TIMEOUT = 1000;
    private static final int SEND_COMMAND_TIMEOUT = 3000;
    private static final int RECONNECT_TIMEOUT = 20000;
    private static final int RESP_WAIT_TIMEOUT = 15000;
    private boolean shortWarmupSupported = false;
    private boolean needHomeSupported = false;
    ProbeManager probeManager = null;
    private boolean sixProbeRev2Supported = false;
    private String probe_connect_tag = "sixdof.probe_adapter.active";
    private String probe_kin_adapter_connect_tag = "sixdof.kinematic_tip.active";
    private String probe_kin_adapter_change_tag = "sixdof.tip.tip_change.value";
    private String probe_model_type_tag = "sixdof.probe_adapter.model_type.value";
    static final int MAX_TIME_OUT_FOR_FILE_TRANSFER = 120000;
    PortUtility portUtility;
    TrkServerSocket trkVideoServerSocket = null;
    TrkDatagramSocket trkAsyncDgSocket = null;
    TrkDatagramSocket trkForeGndDgSocket = null;
    TrkDatagramSocket trkBackGndDgSocket = null;
    TrkDatagramSocket trkFactoryBackGndDgSocket = null;

    public TrackerCypher() {
        this.pointMeasurementTags[0] = new DataTagDouble("target.corrected.azimuth.value");
        this.pointMeasurementTags[1] = new DataTagUnsigned16("target.corrected.azimuth.status");
        this.pointMeasurementTags[2] = new DataTagDouble("target.corrected.zenith.value");
        this.pointMeasurementTags[3] = new DataTagUnsigned16("target.corrected.zenith.status");
        this.pointMeasurementTags[4] = new DataTagDouble("target.corrected.distance.value");
        this.pointMeasurementTags[5] = new DataTagUnsigned16("target.corrected.distance.status");
    }

    @Override
    public synchronized void connect(String string, String string2, String string3) throws TrackerException {
        int n;
        ConnectFailedException connectFailedException = null;
        if (this.ftpClient != null) {
            throw new AlreadyConnectedException();
        }
        disconnectCalled = false;
        this.trkVideoServerSocket = new TrkServerSocket(this.portUtility);
        this.trkAsyncDgSocket = new TrkDatagramSocket(this.portUtility);
        this.trkForeGndDgSocket = new TrkDatagramSocket(this.portUtility);
        this.trkBackGndDgSocket = new TrkDatagramSocket(this.portUtility);
        this.trkFactoryBackGndDgSocket = new TrkDatagramSocket(this.portUtility);
        if (-1 == string.indexOf(46) || !Tracker.isUserParameterValidIPAddress(string)) {
            string = Tracker.checkAndGetIPAddress(string, "TrackerCypher");
        }
        if ((n = Tracker.getTrkConnectionType()) == 0) {
            Tracker.setTrkConnectionType(3);
        }
        this.ftpClient = new CypherFtp(debugWriter, this.portUtility);
        try {
            this.ftpClient.connect(string, string2, string3);
            reconnectIp = this.ipAddressToUse = string;
            userName = string2;
            password = string3;
            TrackerCypher.logLine("------------------------------------------ ");
            TrackerCypher.logLine("Connect: " + string);
            this.jarClassLoader = new JarClassLoader();
        }
        catch (FtpException ftpException) {
            this.ftpClient = null;
            if (ftpException instanceof FtpOutOfPortsException) {
                throw new ConnectFailedException(Tracker.res.getString("Out_Of_Ports"));
            }
            throw new ConnectFailedException(ftpException.toString());
        }
        try {
            long l;
            this.checkIfConnectingToTrackerTypeSpecified();
            this.setAccessLevel(string2);
            this.mcuVNum = this.getFirmwareVersionNumber();
            long l2 = 0x2090000L;
            if (this.MCUVersionNumber >= l2) {
                communicationDropSupported = true;
            }
            this.shortWarmupSupported = this.checkIfTrkShortWarmupCapable();
            long l3 = 34144273L;
            if (this.MCUVersionNumber >= l3) {
                this.needHomeSupported = true;
            }
            if (this.MCUVersionNumber >= (l = 0x20B0000L)) {
                this.sixProbeRev2Supported = true;
            }
            this.getSessionId();
            this.setAppInfo();
            this.isCatEyeTargetCapable = false;
            long l4 = 33948672L;
            if (this.MCUVersionNumber >= l4) {
                this.isCatEyeTargetCapable = true;
            }
            this.sixDofCapableTrk = this.sixDofCapable();
            this.createMeasurePointTags();
            this.initSixDof();
            this.registerTrackerEvents();
        }
        catch (ConnectFailedException connectFailedException2) {
            connectFailedException = connectFailedException2;
        }
        catch (TrackerException trackerException) {
            connectFailedException = trackerException instanceof CustomPortsException ? new ConnectFailedException(Tracker.res.getString("Out_Of_Ports")) : new ConnectFailedException(Tracker.res.getString("Could_Not_Obtain_Needed_Info"));
        }
        if (connectFailedException != null) {
            try {
                this.ftpClient.disconnect();
            }
            catch (FtpException ftpException) {
                // empty catch block
            }
            this.cleanupInterface();
            throw connectFailedException;
        }
    }

    private void registerTrackerEvents() throws TrackerException {
        if (this.trackerBatteryEventCapable()) {
            this.readBatteryAlarmValues();
            this.registerEvents(15, "system.power.battery1.alarm1.value");
            this.registerEvents(16, "system.power.battery1.alarm2.value");
            this.registerEvents(17, "system.power.battery2.alarm1.value");
            this.registerEvents(18, "system.power.battery2.alarm2.value");
        }
        if (this.needHomeSupported) {
            this.registerEvents(20, "laser.control.need_home.value");
        }
        if (this.shortWarmupSupported) {
            this.registerEvents(19, "short.warmup.need_comp.value");
        }
    }

    private void initSixDof() throws TrackerException {
        if (this.sixDofCapableTrk) {
            this.registerEvents();
            this.probeManager = new ProbeManager(this.ftpClient, this.factoryPrivilege());
        }
    }

    private void registerEvents() throws TrackerException {
        this.registerEvents(11, "target.type");
        this.registerEvents(12, "sixdof.probe_adapter.active");
        try {
            this.readOneTimeData(new DataTag[]{new DataTagUnsigned32(this.genProbeChangeEventTagName)});
            this.genProbeChangeTagSupported = true;
            this.registerEvents(13, this.genProbeChangeEventTagName);
        }
        catch (TrackerException trackerException) {
            // empty catch block
        }
        if (this.checkFirmware261AndLater()) {
            this.registerEvents(14, "sixdof.probe_adapter.battery.percent_remaining.status");
        }
        if (this.sixProbeRev2Supported) {
            this.registerEvents(25, this.probe_kin_adapter_connect_tag);
            this.registerEvents(26, this.probe_kin_adapter_change_tag);
        }
    }

    private void registerEvents(int n, String string) throws TrackerException {
        String string2 = "configure_alarm " + n;
        string2 = string2 + " enable " + string + " change";
        this.executeTrackerCommand(string2, 10000);
    }

    private boolean checkTags(DataTag[] dataTagArray, DataTag[] dataTagArray2) {
        if (dataTagArray == null || dataTagArray2 == null) {
            return false;
        }
        if (dataTagArray.length != dataTagArray2.length) {
            return false;
        }
        for (int i = 0; i < dataTagArray2.length; ++i) {
            if (dataTagArray[i].getName().equals(dataTagArray2[i].getName())) continue;
            return false;
        }
        return true;
    }

    private boolean checkTypeList(int[] nArray, int[] nArray2) {
        if (nArray == null || nArray2 == null) {
            return false;
        }
        if (nArray.length != nArray2.length) {
            return false;
        }
        for (int i = 0; i < nArray2.length; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    private Object checkAndSendCFGData(MeasureCfg measureCfg, DataTag[] dataTagArray, boolean bl, boolean bl2, CypherFtp cypherFtp, String string) throws TrackerException {
        int[] nArray = null;
        int[] nArray2 = null;
        MeasureCfg measureCfg2 = null;
        DataTag[] dataTagArray2 = null;
        int[] nArray3 = null;
        if (bl) {
            if (bl2) {
                measureCfg2 = this.oldfactoryBkndMeasureCfg;
                dataTagArray2 = this.oldfactoryBkndMeasureTags;
                nArray3 = this.oldfactoryBkndMeasureTypeList;
            } else {
                measureCfg2 = this.oldbkndMeasureCfg;
                dataTagArray2 = this.oldbkndMeasureTags;
                nArray3 = this.oldbkndMeasureTypeList;
            }
        } else {
            measureCfg2 = this.oldmeasureCfg;
            dataTagArray2 = this.oldmeasureTags;
            nArray3 = this.oldmeasureTypeList;
        }
        nArray2 = TrackerCypher.createTypeList(dataTagArray);
        if (measureCfg2 != null && this.checkTags(dataTagArray2, dataTagArray) && this.checkTypeList(nArray3, nArray2) && measureCfg2.getContinueTrigger().equals(measureCfg.getContinueTrigger()) && measureCfg.getFilter().equals(measureCfg2.getFilter()) && measureCfg2.getStartTrigger().equals(measureCfg.getStartTrigger()) && measureCfg2.getSamplesPerObservation() == measureCfg.getSamplesPerObservation()) {
            return null;
        }
        this.sendMeasureCfg(cypherFtp, measureCfg, dataTagArray, string);
        nArray = nArray2;
        measureCfg2 = new MeasureCfg(measureCfg.getSamplesPerObservation(), measureCfg.getFilter(), measureCfg.getStartTrigger(), measureCfg.getContinueTrigger());
        dataTagArray2 = new DataTag[dataTagArray.length];
        for (int i = 0; i < dataTagArray.length; ++i) {
            if (dataTagArray[i] instanceof DataTagDouble) {
                dataTagArray2[i] = new DataTagDouble(dataTagArray[i].getName());
                continue;
            }
            if (dataTagArray[i] instanceof DataTagUnsigned16) {
                dataTagArray2[i] = new DataTagUnsigned16(dataTagArray[i].getName());
                continue;
            }
            if (dataTagArray[i] instanceof DataTagUnsigned32) {
                dataTagArray2[i] = new DataTagUnsigned32(dataTagArray[i].getName());
                continue;
            }
            if (dataTagArray[i] instanceof DataTagUnsigned8) {
                dataTagArray2[i] = new DataTagUnsigned8(dataTagArray[i].getName());
                continue;
            }
            throw new TrackerException(Tracker.res.getString("Unknown_DataTag_Type_Passed"));
        }
        nArray3 = nArray;
        if (bl) {
            if (bl2) {
                this.oldfactoryBkndMeasureCfg = measureCfg2;
                this.oldfactoryBkndMeasureTags = dataTagArray2;
                this.oldfactoryBkndMeasureTypeList = nArray3;
            } else {
                this.oldbkndMeasureCfg = measureCfg2;
                this.oldbkndMeasureTags = dataTagArray2;
                this.oldbkndMeasureTypeList = nArray3;
            }
        } else {
            this.oldmeasureCfg = measureCfg2;
            this.oldmeasureTags = dataTagArray2;
            this.oldmeasureTypeList = nArray3;
        }
        return nArray;
    }

    private void setAccessLevel(String string) throws TrackerException {
        if (string.equalsIgnoreCase("user")) {
            this.accessLevel = 0;
        } else if (string.equalsIgnoreCase("admin")) {
            this.accessLevel = 1;
        } else if (string.equalsIgnoreCase("factory") || string.equalsIgnoreCase("supervis")) {
            this.accessLevel = 2;
        } else {
            throw new ConnectFailedException(Tracker.res.getString("Invalid_User_Name"));
        }
    }

    @Override
    public int sampleRate() throws TrackerException {
        return 1024;
    }

    private void closeCachedJars() {
        Collection collection = this.jarCache.values();
        for (JarFile jarFile : collection) {
            try {
                jarFile.close();
            }
            catch (Exception exception) {
                PrintException.print(exception);
            }
        }
        this.jarCache.clear();
        if (this.tmpDownloadedJarsPath.size() > 0) {
            for (int i = 0; i < this.tmpDownloadedJarsPath.size(); ++i) {
                File file = new File((String)this.tmpDownloadedJarsPath.get(i));
                if (!file.exists()) continue;
                file.delete();
            }
            this.tmpDownloadedJarsPath.clear();
        }
    }

    private void cleanupInterface() throws TrackerException {
        this.ftpClient = null;
        this.closeCachedJars();
        this.jarClassLoader = null;
        this.measureTypeList = null;
        this.generalMeasureFlag = false;
        this.readInProgress = false;
        this.measureFilter = null;
        this.bkndMeasureTypeList = null;
        this.bkndReadInProgress = false;
        this.bkndGeneralMeasureFlag = false;
        this.bkndMeasureFilter = null;
        this.factoryBkndMeasureTypeList = null;
        this.factoryBkndReadInProgress = false;
        this.factoryBkndGeneralMeasureFlag = false;
        this.factoryBkndMeasureFilter = null;
        this.cmdInProgress = false;
        this.dgSocket = null;
        this.bkndDgSocket = null;
        this.asyncSocket = null;
        this.factoryBkndDgSocket = null;
        this.packet = null;
        this.bkndPacket = null;
        this.asyncPacket = null;
        this.factoryBkndPacket = null;
        this.buf = null;
        this.bkndBuf = null;
        this.asyncBuf = null;
        this.factoryBkndBuf = null;
        this.asyncInput = null;
        this.asyncReadInProgress = false;
        this.asyncReadInterrupted = false;
        this.accessLevel = 0;
        this.measureInProgress = false;
        this.bkndMeasureInProgress = false;
        this.factoryBkndMeasureInProgress = false;
        this.oldmeasureCfg = null;
        this.oldmeasureTags = null;
        this.oldbkndMeasureCfg = null;
        this.oldbkndMeasureTags = null;
        this.oldfactoryBkndMeasureCfg = null;
        this.oldfactoryBkndMeasureTags = null;
    }

    @Override
    public void disconnect() throws TrackerException {
        if (!this.isConnected()) {
            return;
        }
        TrackerCypher.logLine("IN Disconnect");
        disconnectCalled = true;
        try {
            this.clearAppInfo();
            this.ftpClient.disconnect();
            this.cleanupInterface();
        }
        catch (FtpIOException ftpIOException) {
            this.cleanupInterface();
            TrackerCypher.logLine("IN Disconnect FtpIOException");
            if (debugWriter != null) {
                ftpIOException.printStackTrace(debugWriter);
            }
        }
        catch (FtpNoResponseException ftpNoResponseException) {
            this.cleanupInterface();
            TrackerCypher.logLine("IN Disconnect FtpNoResponseException");
            if (debugWriter != null) {
                ftpNoResponseException.printStackTrace(debugWriter);
            }
        }
        catch (FtpException ftpException) {
            TrackerCypher.logLine("IN Disconnect FtpException");
            if (debugWriter != null) {
                ftpException.printStackTrace(debugWriter);
            }
            throw new DisconnectFailedException();
        }
        this.closeDebugLog();
    }

    private boolean isConnected() {
        return this.ftpClient != null;
    }

    private boolean isMeasuring() {
        return this.measureInProgress;
    }

    @Override
    public void trackerCommand(String string, int n) throws TrackerException {
        if (n < 15000) {
            n = 15000;
        }
        this.executeTrackerCommand(string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTrackerCommand(String string, int n) throws TrackerException {
        try {
            TrackerCypher trackerCypher = this;
            synchronized (trackerCypher) {
                this.readyForCommand();
                this.cmdInProgress = true;
            }
            int n2 = this.executeTrackerCommand(this.ftpClient, string, n);
            if (n2 != 200) {
                throw TrackerCypher.exceptionFromResponse(this.ftpClient, n2);
            }
        }
        catch (FtpException ftpException) {
            throw TrackerCypher.convertFtpExc(ftpException);
        }
        finally {
            TrackerCypher trackerCypher = this;
            synchronized (trackerCypher) {
                this.cmdInProgress = false;
            }
        }
    }

    @Override
    public void initialize() throws TrackerException {
        this.initialize(true);
    }

    @Override
    public void initialize(boolean bl) throws TrackerException {
        if (!this.readyToInitialize(bl)) {
            throw new TrackerException(Tracker.res.getString("Tracker_Is_Not_Ready"));
        }
        boolean bl2 = this.shouldRunLineJumpCorrection();
        this.executeInit("init");
        if (bl2) {
            this.customInitialize();
        }
    }

    private void customInitialize() throws TrackerException {
        try {
            this.runEncoderLineJumpCorrection();
        }
        catch (Exception exception) {
            PrintException.print(exception);
        }
        if (!this.customInitialized()) {
            throw new TrackerException(Tracker.res.getString("Failed_To_Initialize_Tracker"));
        }
    }

    private boolean shouldRunLineJumpCorrection() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned16("position_device.azimuth_encoder.reading.status"), new DataTagUnsigned16("position_device.zenith_encoder.reading.status")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        int n = (Integer)objectArray[0];
        int n2 = (Integer)objectArray[1];
        return 0 != (0x20 & n) && 0 != (0x20 & n2);
    }

    /*
     * Exception decompiling
     */
    private void runEncoderLineJumpCorrection() throws TrackerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 14[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void log(String string) {
        if (this.printOutput) {
            // empty if block
        }
    }

    private void log(PrintWriter printWriter, String string) {
        if (printWriter != null) {
            printWriter.println(string);
        }
        this.log(string);
    }

    private void saveRawData(DataTag[] dataTagArray, ArrayList arrayList) {
        String string = ",";
        String string2 = System.getProperty("user.dir");
        String string3 = "\\linejump.csv";
        try {
            String string4;
            Object object;
            File file = new File(string2 + string3);
            if (file.exists()) {
                object = Long.toString(System.currentTimeMillis());
                string4 = string2 + string3 + (String)object + ".csv";
                File file2 = new File(string4);
                if (file.exists()) {
                    file.renameTo(file2);
                }
            }
            object = new PrintWriter((Writer)new FileWriter(string2 + string3, true), false);
            string4 = "TimeStamp" + string;
            if (object != null) {
                int n;
                for (n = 0; n < dataTagArray.length; ++n) {
                    string4 = string4 + dataTagArray[n].getName() + string;
                }
                ((PrintWriter)object).println(string4);
                for (n = 0; n < arrayList.size(); ++n) {
                    MeasureData measureData = (MeasureData)arrayList.get(n);
                    String string5 = measureData.time() + string;
                    for (int i = 0; i < measureData.getNumDataElements(); ++i) {
                        if (measureData.getDataElement(i) instanceof Double) {
                            double d = (Double)measureData.getDataElement(i);
                            string5 = string5 + d + string;
                            continue;
                        }
                        if (measureData.getDataElement(i) instanceof Integer) {
                            int n2 = (Integer)measureData.getDataElement(i);
                            string5 = string5 + n2 + string;
                            continue;
                        }
                        if (!(measureData.getDataElement(i) instanceof Long)) continue;
                        long l = (Long)measureData.getDataElement(i);
                        string5 = string5 + l + string;
                    }
                    ((PrintWriter)object).println(string5);
                }
                ((PrintWriter)object).println();
                ((PrintWriter)object).flush();
                ((PrintWriter)object).close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected int[] convertToVersionNumber(long l) {
        long l2 = 255L;
        int[] nArray = new int[]{Integer.parseInt(Long.toString((l & l2 << 24) >> 24)), Integer.parseInt(Long.toString((l & l2 << 16) >> 16)), Integer.parseInt(Long.toString((l & l2 << 8) >> 8)), Integer.parseInt(Long.toString(l & l2))};
        return nArray;
    }

    private static String getLogFileEnvPath(String string) {
        String string2;
        String string3 = "";
        String string4 = System.getenv("APPDATA");
        string3 = string2 = System.getenv("ALLUSERSPROFILE");
        String string5 = System.getProperty("os.name");
        if (string5.equals("Windows XP")) {
            String string6 = string4.substring(string4.lastIndexOf("\\"), string4.length());
            string3 = string3 + string6;
        }
        string3 = string3 + "\\FARO Laser\\" + string;
        return string3;
    }

    @Override
    public void initializeSmart() throws TrackerException {
        this.initializeSmart(true);
    }

    @Override
    public void initializeSmart(boolean bl) throws TrackerException {
        if (!this.readyToInitialize(bl)) {
            throw new TrackerException(Tracker.res.getString("Tracker_Is_Not_Ready"));
        }
        boolean bl2 = this.shouldRunLineJumpCorrection();
        this.executeInit("init smart");
        if (bl2) {
            this.customInitialize();
        }
    }

    @Override
    public void move(double d, double d2, double d3, boolean bl) throws TrackerException {
        String string = "move " + d + " " + d2 + " " + d3 + (bl ? " r" : " a");
        try {
            this.trackerCommand(string, 15000);
        }
        catch (NoTargetException noTargetException) {
            // empty catch block
        }
    }

    @Override
    public void move(double d, double d2, double d3, boolean bl, boolean bl2) throws TrackerException {
        String string = "move " + d + " " + d2 + " " + d3 + (bl2 ? " r" : " a") + (bl ? " b" : " f");
        try {
            this.trackerCommand(string, 15000);
        }
        catch (NoTargetException noTargetException) {
            // empty catch block
        }
    }

    @Override
    public void home(boolean bl) throws TrackerException {
        this.trackerCommand("home" + (bl ? " b" : ""), 120000);
    }

    @Override
    public void toggleSightOrientation() throws TrackerException {
        this.trackerCommand("backsight", 600000);
    }

    @Override
    public void search(double d, int n) throws TrackerException {
        if (n < 1000) {
            throw new TrackerException(Tracker.res.getString("Timeout_Out_Of_Bounds"));
        }
        this.executeTrackerCommand("fr " + d, n);
    }

    @Override
    public void search(double d, double d2, int n) throws TrackerException {
        if (n < 1000) {
            throw new TrackerException(Tracker.res.getString("Timeout_Out_Of_Bounds"));
        }
        this.executeTrackerCommand("fr " + d + " " + d2, n);
    }

    @Override
    public void search(double d, double d2) throws TrackerException {
        this.trackerCommand("fr " + d + " " + d2, 600000);
    }

    @Override
    public void search(double d) throws TrackerException {
        this.trackerCommand("fr " + d, 600000);
    }

    @Override
    public void changeMotorState(boolean bl) throws TrackerException {
        this.trackerCommand("motors " + (bl ? "on auto_adjust" : "off"), 6000);
    }

    @Override
    public void changeTrackingState(boolean bl) throws TrackerException {
        String string = "tracking " + (bl ? "on" : "off");
        this.trackerCommand(string, 6000);
    }

    @Override
    public void changeDistanceMeasureMode(DistanceMode distanceMode) throws TrackerException {
        if (distanceMode instanceof ADMOnly) {
            this.trackerCommand("dist_mode adm auto_adjust", 6000);
        } else if (distanceMode instanceof UserSpecifiedDistance) {
            this.trackerCommand("dist_mode user", 6000);
        } else {
            throw new UnsupportedFeatureException(Tracker.res.getString("Mode_Not_Supported"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void changeTargetType(TargetType targetType) throws TrackerException {
        String string = "";
        if (targetType instanceof SMRTargetType) {
            SMRTargetType sMRTargetType = (SMRTargetType)targetType;
            double d = sMRTargetType.getDiameter();
            string = d >= 0.038 && d <= 0.0382 ? "smr_1_1/2" : (d >= 0.0126 && d <= 0.0128 ? "smr_1/2" : (d >= 0.0221 && d <= 0.0223 ? "smr_7/8" : "smr_user"));
        } else if (targetType instanceof WindowedSMRTargetType) {
            WindowedSMRTargetType windowedSMRTargetType = (WindowedSMRTargetType)targetType;
            double d = windowedSMRTargetType.getDiameter();
            if (d >= 0.038 && d <= 0.0382) {
                string = "smr_1_1/2_windowed";
            } else {
                if (!(d >= 0.022224) || !(d <= 0.022226)) throw new UnsupportedFeatureException(Tracker.res.getString("Target_Type_Not_Supported"));
                string = "smr_7/8_windowed";
            }
        } else if (targetType instanceof MirrorTargetType) {
            string = "mirror";
        } else if (targetType instanceof CatEyeTargetType) {
            if (!this.isCatEyeTargetCapable) throw new UnsupportedFeatureException(Tracker.res.getString("Target_Type_Not_Supported"));
            CatEyeTargetType catEyeTargetType = (CatEyeTargetType)targetType;
            double d = catEyeTargetType.getOffset();
            double d2 = catEyeTargetType.getDiameter();
            string = "cateye " + d + " " + d2;
        } else {
            if (!(targetType instanceof SixDofTargetType)) throw new UnsupportedFeatureException(Tracker.res.getString("Target_Type_Not_Supported"));
            string = "sixdof";
        }
        this.trackerCommand("target " + string, 1000);
        this.trackerCommand("savecfg", 15000);
    }

    @Override
    public synchronized void abort() {
        try {
            if (this.cmdInProgress) {
                this.ftpClient.abort();
            }
        }
        catch (FtpException ftpException) {
            // empty catch block
        }
    }

    @Override
    public void startMeasure(MeasureCfg measureCfg, DataTag[] dataTagArray) throws TrackerException {
        this.localStartMeasure(measureCfg, dataTagArray, true);
    }

    private synchronized void localStartMeasure(MeasureCfg measureCfg, DataTag[] dataTagArray, boolean bl) throws TrackerException {
        TrackerCypher.logLine("Start Measure: " + new Date().toString());
        this.readyForCommand();
        TrackerCypher.logLine("Send Measure Cfg: " + new Date().toString());
        Object object = this.checkAndSendCFGData(measureCfg, dataTagArray, false, false, this.ftpClient, "\\data\\measure.arg");
        TrackerCypher.logLine("in receiveMeasurementData: " + new Date().toString());
        int n = this.receiveMeasurementData(this.ftpClient);
        TrackerCypher.logLine("out receiveMeasurementData: " + n + " " + new Date().toString());
        if (n != 200) {
            throw TrackerCypher.exceptionFromResponse(this.ftpClient, n);
        }
        TrackerCypher.logLine("after in and out receiveMeasurementData: " + n + " " + new Date().toString());
        if (object != null) {
            this.measureTypeList = (int[])object;
            this.measureFilter = measureCfg.getFilter();
        }
        this.generalMeasureFlag = bl;
        this.measureInProgress = true;
        TrackerCypher.logLine("out localStartMeasure: " + n + " " + new Date().toString());
    }

    private void readyForCommand() throws InterfaceBusyException, NotConnectedException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        if (this.isMeasuring() || this.cmdInProgress) {
            throw new InterfaceBusyException(Tracker.res.getString("Measure_Or_Cmd_In_Progress"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMeasureCfg(CypherFtp cypherFtp, MeasureCfg measureCfg, DataTag[] dataTagArray, String string) throws TrackerException {
        int n;
        TrackerException trackerException = null;
        for (n = 0; n < 3; ++n) {
            int n2;
            trackerException = null;
            try {
                TrackerCypher.logLine("in sendMeasureCfg sendFTPStart : " + new Date().toString());
                n2 = TrackerCypher.sendFTPStart(cypherFtp, string);
                TrackerCypher.logLine("in sendMeasureCfg sendFTPStart : " + n2 + ": " + new Date().toString());
                if (n2 != 150) {
                    TrackerCypher.logLine("sendMeasureCfg sendFTPStart exceptionFromResponse : " + n2 + ": " + new Date().toString());
                    throw TrackerCypher.exceptionFromResponse(cypherFtp, n2);
                }
            }
            catch (FtpException ftpException) {
                throw TrackerCypher.convertFtpExc(ftpException);
            }
            TrackerCypher.logLine("in sendMeasureCfg sendLine : " + new Date().toString());
            try {
                cypherFtp.sendLine("maxobs=0");
                cypherFtp.sendLine("nsamps=" + measureCfg.getSamplesPerObservation());
                this.sendStartTrigger(cypherFtp, measureCfg);
                this.sendContinueTrigger(cypherFtp, measureCfg);
                this.sendFilter(cypherFtp, measureCfg);
                for (int i = 0; i < dataTagArray.length; ++i) {
                    cypherFtp.sendLine("tag=" + dataTagArray[i].getName());
                }
                TrackerCypher.logLine("out sendMeasureCfg sendLine : " + new Date().toString());
            }
            catch (FtpException ftpException) {
                trackerException = TrackerCypher.convertFtpExc(ftpException);
            }
            catch (TrackerException trackerException2) {
                trackerException = trackerException2;
            }
            finally {
                block23: {
                    try {
                        TrackerCypher.logLine("in sendMeasureCfg sendEnd : " + new Date().toString());
                        n2 = this.ftpClient.sendEnd(10000);
                        TrackerCypher.logLine("out sendMeasureCfg sendEnd : " + new Date().toString());
                        if (n2 != 226 && trackerException == null) {
                            TrackerCypher.logLine("sendMeasureCfg sendEnd exceptionFromResponse : " + n2 + ": " + new Date().toString());
                            trackerException = TrackerCypher.exceptionFromResponse(cypherFtp, n2);
                        }
                    }
                    catch (FtpException ftpException) {
                        if (trackerException != null) break block23;
                        trackerException = TrackerCypher.convertFtpExc(ftpException);
                    }
                }
            }
            if (trackerException == null) break;
        }
        if (n == 3 && trackerException != null) {
            TrackerCypher.logLine("sendMeasureCfg max tries throw ex: " + new Date().toString());
            throw trackerException;
        }
    }

    private int receiveMeasurementData(CypherFtp cypherFtp) throws TrackerException {
        try {
            this.dgSocket = this.trkForeGndDgSocket.createSocket();
            this.dgSocket.setSoTimeout(5000);
            byte[] byArray = cypherFtp.getIPAddress().getAddress();
            int n = this.dgSocket.getLocalPort();
            TrackerCypher.logLine("Measure port: " + n);
            int[] nArray = new int[4];
            for (int i = 0; i < 4; ++i) {
                nArray[i] = byArray[i];
                if (nArray[i] >= 0) continue;
                int n2 = i;
                nArray[n2] = nArray[n2] + 256;
            }
            int n3 = this.executeMeasureCommand(cypherFtp, "measure " + nArray[0] + "," + nArray[1] + "," + nArray[2] + "," + nArray[3] + "," + n / 256 + "," + n % 256, 10000);
            return n3;
        }
        catch (SocketException socketException) {
            this.trkForeGndDgSocket.closeSocket();
            if (socketException instanceof UtilityOutOfPortsException) {
                throw new CustomPortsException(Tracker.res.getString("Out_Of_Ports"));
            }
            throw new CommunicationException(Tracker.res.getString("Measurement_Data_Exception"));
        }
        catch (FtpException ftpException) {
            this.trkForeGndDgSocket.closeSocket();
            throw TrackerCypher.convertFtpExc(ftpException);
        }
    }

    private void sendStartTrigger(CypherFtp cypherFtp, MeasureCfg measureCfg) throws FtpException, TrackerException {
        StartTrigger startTrigger = measureCfg.getStartTrigger();
        if (startTrigger instanceof ExternalStartTrigger) {
            cypherFtp.sendLine("start_type=digio");
            return;
        }
        if (startTrigger instanceof NullStartTrigger) {
            cypherFtp.sendLine("start_type=nopause");
            return;
        }
        throw new UnsupportedFeatureException(Tracker.res.getString("Unknown_Start_Trigger"));
    }

    private void sendContinueTrigger(CypherFtp cypherFtp, MeasureCfg measureCfg) throws FtpException, TrackerException {
        ContinueTrigger continueTrigger = measureCfg.getContinueTrigger();
        if (continueTrigger instanceof NullContinueTrigger) {
            cypherFtp.sendLine("nth_type=noseq");
            return;
        }
        if (continueTrigger instanceof ExternalContinueTrigger) {
            cypherFtp.sendLine("nth_type=digio");
            return;
        }
        if (continueTrigger instanceof IntervalTrigger) {
            cypherFtp.sendLine("nth_type=time");
            cypherFtp.sendLine("obsrate=" + ((IntervalTrigger)continueTrigger).getObservationRate());
            return;
        }
        if (continueTrigger instanceof DistanceTrigger) {
            cypherFtp.sendLine("nth_type=distance");
            cypherFtp.sendLine("distance=" + ((DistanceTrigger)continueTrigger).getDistance());
            return;
        }
        throw new UnsupportedFeatureException(Tracker.res.getString("Unknown_Continue_Trigger"));
    }

    private void sendFilter(CypherFtp cypherFtp, MeasureCfg measureCfg) throws FtpException, TrackerException {
        Filter filter = measureCfg.getFilter();
        if (filter instanceof NullFilter) {
            cypherFtp.sendLine("filter=none");
            return;
        }
        if (filter instanceof AverageFilter) {
            cypherFtp.sendLine("filter=firstorder");
            return;
        }
        if (filter instanceof StdDevFilter) {
            cypherFtp.sendLine("filter=stddev");
            return;
        }
        if (filter instanceof AdaptiveFilter) {
            cypherFtp.sendLine("filter=adaptive");
            cypherFtp.sendLine("sdm=" + ((AdaptiveFilter)filter).getSdm());
            int n = 65535;
            if (filter instanceof AdaptiveFilterInternal) {
                n = ((AdaptiveFilterInternal)filter).getStatusMask();
            }
            cypherFtp.sendLine("statusmask=" + n);
            return;
        }
        if (filter instanceof InterpolationFilter) {
            cypherFtp.sendLine("filter=linearinterpolation");
            return;
        }
        throw new UnsupportedFeatureException(Tracker.res.getString("Unknown_Filter"));
    }

    private static TrackerException exceptionFromResponse(CypherFtp cypherFtp, int n) {
        String string;
        TrackerCypher.logLine("in getLastResponse exceptionFromResponse: " + n + " : " + new Date().toString());
        try {
            string = cypherFtp.getLastResponse();
            TrackerCypher.logLine("getLastResponse exceptionFromResponse: " + string + " : " + new Date().toString());
        }
        catch (FtpException ftpException) {
            TrackerCypher.logLine("Exception getLastResponse exceptionFromResponse");
            if (debugWriter != null) {
                ftpException.printStackTrace(debugWriter);
            }
            return new CommunicationException(Tracker.res.getString("Unexpected_FTP_Exception_Last_Response"));
        }
        switch (n) {
            case 340: {
                return new RequestException(string);
            }
            case 453: {
                return new InternalDeviceFailureException(string);
            }
            case 450: 
            case 452: 
            case 454: 
            case 455: 
            case 456: 
            case 555: {
                return new InternalTrackerException(string);
            }
            case 421: 
            case 425: 
            case 428: 
            case 429: 
            case 520: 
            case 530: {
                return new CommunicationException(string);
            }
            case 550: {
                return new PermissionException(string);
            }
            case 552: 
            case 557: {
                return new FileAccessException(string);
            }
            case 556: 
            case 558: {
                return TrackerCypher.exceptionFromReason(string);
            }
            case 500: 
            case 501: 
            case 503: {
                return new BadCommandException(string);
            }
        }
        return new TrackerException(string);
    }

    private static TrackerException convertFtpExc(FtpException ftpException) {
        try {
            throw ftpException;
        }
        catch (FtpAbortedException ftpAbortedException) {
            return new AbortedException();
        }
        catch (FtpAlreadyConnectedException ftpAlreadyConnectedException) {
            return new AlreadyConnectedException();
        }
        catch (FtpBusyException ftpBusyException) {
            return new InterfaceBusyException(Tracker.res.getString("FTP_Busy"));
        }
        catch (FtpNoResponseException ftpNoResponseException) {
            return new NoResponseException();
        }
        catch (FtpNotConnectedException ftpNotConnectedException) {
            return new NotConnectedException();
        }
        catch (FtpOutOfPortsException ftpOutOfPortsException) {
            return new CustomPortsException(Tracker.res.getString("Out_Of_Ports"));
        }
        catch (FtpException ftpException2) {
            if (ftpException2.getText().equals("")) {
                return new CommunicationException(Tracker.res.getString("Unexpected_FTP_Exception"));
            }
            return new CommunicationException(ftpException2.getText());
        }
    }

    private static TrackerException exceptionFromReason(String string) {
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken();
        try {
            n = Integer.parseInt(string2, 16);
        }
        catch (NumberFormatException numberFormatException) {
            return new CommunicationException(Tracker.res.getString("FTP_Response_String_Not_In_Expected_Format"));
        }
        String string3 = Tracker.res.getString("Code") + ": " + n;
        switch (n) {
            case 1: {
                return new DeviceLockedException(string3);
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 25: 
            case 48: {
                return new InternalTrackerException(string3);
            }
            case 5: 
            case 15: 
            case 23: 
            case 68: {
                return new MotorStateException(string3);
            }
            case 6: 
            case 19: {
                return new LaserStateException(string3);
            }
            case 13: {
                return new NoTargetException(string3);
            }
            case 18: {
                return new DoubleFaultException(string3);
            }
            case 69: {
                return new InternalDeviceFailureException(string3);
            }
            case 70: {
                return new HardwareNotInstalledException(string3);
            }
            case 27: 
            case 49: {
                return new DistanceSetException(string3);
            }
            case 30: {
                return new TrackingStateException(string3);
            }
            case 90: {
                return new TrackerException(Tracker.res.getString("ADM_Darklev_Execeded_Threshold"));
            }
            case 93: {
                return new TrackerException(Tracker.res.getString("ADM_Failed_To_Stabilize"));
            }
        }
        return new TrackerException(string3);
    }

    private static int[] createTypeList(DataTag[] dataTagArray) throws TrackerException {
        int n = dataTagArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            if (dataTagArray[i] instanceof DataTagUnsigned8) {
                nArray[i] = 1;
                continue;
            }
            if (dataTagArray[i] instanceof DataTagUnsigned16) {
                nArray[i] = 2;
                continue;
            }
            if (dataTagArray[i] instanceof DataTagUnsigned32) {
                nArray[i] = 3;
                continue;
            }
            if (dataTagArray[i] instanceof DataTagDouble) {
                nArray[i] = 4;
                continue;
            }
            throw new UnsupportedFeatureException(Tracker.res.getString("Unknown_Data_Tag"));
        }
        return nArray;
    }

    @Override
    public MeasureData[] readMeasureData(int n) throws TrackerException {
        MeasureData[] measureDataArray;
        this.testAndSetReadData(true);
        try {
            measureDataArray = this.readData(this.ftpClient, n, this.measureTypeList, this.measureFilter);
        }
        catch (IOException iOException) {
            throw new CommunicationException(Tracker.res.getString("Measurement_Data_Exception"));
        }
        catch (FtpException ftpException) {
            throw TrackerCypher.convertFtpExc(ftpException);
        }
        finally {
            this.releaseReadData();
        }
        return measureDataArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAndSetReadData(boolean bl) throws TrackerException {
        TrackerCypher trackerCypher = this;
        synchronized (trackerCypher) {
            if (!this.isConnected()) {
                throw new NotConnectedException();
            }
            if (!this.isMeasuring() || bl != this.generalMeasureFlag) {
                throw new NoDataAvailableException();
            }
            if (this.readInProgress) {
                throw new InterfaceBusyException(Tracker.res.getString("Read_In_Progress"));
            }
            this.readInProgress = true;
        }
    }

    private MeasureData[] readData(CypherFtp cypherFtp, int n, int[] nArray, Filter filter) throws IOException, FtpException {
        MeasureData[] measureDataArray = new MeasureData[n];
        for (int i = 0; i < n; ++i) {
            MeasureStdDev measureStdDev;
            this.buf = filter instanceof StdDevFilter ? new byte[(nArray.length * 8 + 8) * 2] : new byte[nArray.length * 8 + 8];
            this.packet = new DatagramPacket(this.buf, this.buf.length);
            this.receiveDgPacket(this.dgSocket, this.packet);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.packet.getData());
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            Object[] objectArray = new Object[nArray.length];
            long l = dataInputStream.readInt();
            long l2 = dataInputStream.readInt();
            double d = (double)l + (double)l2 / 1000000.0;
            for (int j = 0; j < nArray.length; ++j) {
                objectArray[j] = this.readDataElement(dataInputStream, nArray[j]);
            }
            if (filter instanceof StdDevFilter) {
                Object[] objectArray2 = new Object[nArray.length];
                for (int j = 0; j < nArray.length; ++j) {
                    objectArray2[j] = this.readDataElement(dataInputStream, nArray[j]);
                }
                measureStdDev = new MeasureStdDev(objectArray2);
            } else {
                measureStdDev = null;
            }
            measureDataArray[i] = new MeasureData(d, objectArray, measureStdDev);
        }
        return measureDataArray;
    }

    private void releaseReadData() {
        this.readInProgress = false;
    }

    private Object readDataElement(DataInputStream dataInputStream, int n) throws FtpException, IOException {
        Number number = null;
        switch (n) {
            case 1: {
                short s = (short)((short)dataInputStream.readByte() & 0xFF);
                number = new Short(s);
                dataInputStream.skip(7L);
                break;
            }
            case 2: {
                number = new Integer(dataInputStream.readUnsignedShort());
                dataInputStream.skip(6L);
                break;
            }
            case 3: {
                number = new Long((long)dataInputStream.readInt() & 0xFFFFFFFFL);
                dataInputStream.skip(4L);
                break;
            }
            case 4: {
                number = new Double(dataInputStream.readDouble());
            }
        }
        return number;
    }

    @Override
    public synchronized void stopMeasure() throws TrackerException {
        this.localStopMeasure(true);
    }

    private synchronized void localStopMeasure(boolean bl) throws TrackerException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        if (this.isMeasuring() && this.generalMeasureFlag == bl) {
            try {
                this.executeMeasureCommand(this.ftpClient, "measure", 10000);
                this.trkForeGndDgSocket.closeSocket();
                this.packet = null;
                this.measureInProgress = false;
            }
            catch (FtpIOException ftpIOException) {
                this.trkForeGndDgSocket.closeSocket();
                this.packet = null;
                this.measureInProgress = false;
            }
            catch (FtpNoResponseException ftpNoResponseException) {
                this.trkForeGndDgSocket.closeSocket();
                this.packet = null;
                this.measureInProgress = false;
            }
            catch (FtpException ftpException) {
                this.trkForeGndDgSocket.closeSocket();
                throw TrackerCypher.convertFtpExc(ftpException);
            }
        }
    }

    @Override
    public void startMeasurePoint(MeasureCfg measureCfg) throws TrackerException {
        this.localStartMeasure(measureCfg, this.pointMeasurementTags, false);
    }

    @Override
    public MeasurePointData[] readMeasurePointData(int n) throws TrackerException {
        MeasurePointData[] measurePointDataArray;
        this.testAndSetReadData(false);
        try {
            measurePointDataArray = this.readPointData(this.ftpClient, n, this.measureFilter);
        }
        catch (IOException iOException) {
            throw new CommunicationException(Tracker.res.getString("Measurement_Data_Exception"));
        }
        catch (FtpException ftpException) {
            throw TrackerCypher.convertFtpExc(ftpException);
        }
        finally {
            this.releaseReadData();
        }
        return measurePointDataArray;
    }

    private MeasurePointData[] localReadPointData(CypherFtp cypherFtp, int n, Filter filter, boolean bl, boolean bl2) throws IOException, FtpException {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        boolean bl3 = false;
        MeasurePointData[] measurePointDataArray = new MeasurePointData[n];
        int n5 = this.sixDofCapableTrk ? 512 : 256;
        for (int i = 0; i < n; ++i) {
            MeasurePointStdDev measurePointStdDev;
            double d4;
            ByteArrayInputStream byteArrayInputStream;
            if (!bl) {
                this.buf = new byte[n5];
                this.packet = new DatagramPacket(this.buf, this.buf.length);
                this.receiveDgPacket(this.dgSocket, this.packet);
                if (null == this.packet) {
                    throw new IOException();
                }
                byteArrayInputStream = new ByteArrayInputStream(this.packet.getData());
            } else if (bl2) {
                this.factoryBkndBuf = new byte[n5];
                this.factoryBkndPacket = new DatagramPacket(this.factoryBkndBuf, this.factoryBkndBuf.length);
                this.receiveDgPacket(this.factoryBkndDgSocket, this.factoryBkndPacket);
                if (null == this.factoryBkndPacket) {
                    throw new IOException();
                }
                byteArrayInputStream = new ByteArrayInputStream(this.factoryBkndPacket.getData());
            } else {
                this.bkndBuf = new byte[n5];
                this.bkndPacket = new DatagramPacket(this.bkndBuf, this.bkndBuf.length);
                this.receiveDgPacket(this.bkndDgSocket, this.bkndPacket);
                if (null == this.bkndPacket) {
                    throw new IOException();
                }
                byteArrayInputStream = new ByteArrayInputStream(this.bkndPacket.getData());
            }
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            long l = dataInputStream.readInt();
            long l2 = dataInputStream.readInt();
            double d5 = (double)l + (double)l2 / 1000000.0;
            double d6 = Math.IEEEremainder((Double)this.readDataElement(dataInputStream, 4), Math.PI * 2);
            int n6 = (Integer)this.readDataElement(dataInputStream, 2);
            double d7 = Math.IEEEremainder((Double)this.readDataElement(dataInputStream, 4), Math.PI * 2);
            int n7 = (Integer)this.readDataElement(dataInputStream, 2);
            double d8 = (Double)this.readDataElement(dataInputStream, 4);
            int n8 = (Integer)this.readDataElement(dataInputStream, 2);
            int n9 = n6 | n7 | n8;
            if (this.sixDofCapableTrk) {
                long l3 = (Long)this.readDataElement(dataInputStream, 3);
                d = (Double)this.readDataElement(dataInputStream, 4);
                n2 = (Integer)this.readDataElement(dataInputStream, 2);
                d2 = (Double)this.readDataElement(dataInputStream, 4);
                n3 = (Integer)this.readDataElement(dataInputStream, 2);
                d3 = (Double)this.readDataElement(dataInputStream, 4);
                n4 = (Integer)this.readDataElement(dataInputStream, 2);
                if (l3 == 8L) {
                    n9 = n6 | n7 | n8 | n2 | n3 | n4;
                    bl3 = true;
                }
            }
            int n10 = n9 == 0 ? 0 : ((n9 & 1) != 0 ? 2 : 1);
            if (filter instanceof StdDevFilter) {
                double d9 = -1.0;
                double d10 = -1.0;
                double d11 = -1.0;
                double d12 = Math.IEEEremainder((Double)this.readDataElement(dataInputStream, 4), Math.PI);
                dataInputStream.skip(8L);
                d4 = Math.IEEEremainder((Double)this.readDataElement(dataInputStream, 4), Math.PI);
                dataInputStream.skip(8L);
                double d13 = (Double)this.readDataElement(dataInputStream, 4);
                if (this.sixDofCapableTrk) {
                    dataInputStream.skip(8L);
                    dataInputStream.skip(8L);
                    d9 = (Double)this.readDataElement(dataInputStream, 4);
                    dataInputStream.skip(8L);
                    d10 = (Double)this.readDataElement(dataInputStream, 4);
                    dataInputStream.skip(8L);
                    d11 = (Double)this.readDataElement(dataInputStream, 4);
                }
                measurePointStdDev = new MeasurePointStdDev(d12, d4, d13, d9, d10, d11, this.sixDofCapableTrk);
            } else {
                measurePointStdDev = null;
            }
            double d14 = 1.0E-25;
            d4 = 1.0E10;
            boolean bl4 = false;
            if (Math.abs(d6) < d14 && 0 == n6 || Math.abs(d7) < d14 && 0 == n7 || d8 < d14 && 0 == n8 || Math.abs(d6) > d4 && 0 == n6 || Math.abs(d7) > d4 && 0 == n7 || d8 > d4 && 0 == n8 || this.sixDofCapableTrk && Math.abs(d) < d14 && 0 == n2 || this.sixDofCapableTrk && Math.abs(d2) < d14 && 0 == n3 || this.sixDofCapableTrk && Math.abs(d3) < d14 && 0 == n4) {
                bl4 = true;
            }
            if (bl4) {
                --i;
                continue;
            }
            measurePointDataArray[i] = new MeasurePointData(d5, d6, d7, d8, n10, measurePointStdDev, d, d2, d3, this.sixDofCapableTrk, bl3);
        }
        return measurePointDataArray;
    }

    private MeasurePointData[] readPointData(CypherFtp cypherFtp, int n, Filter filter) throws IOException, FtpException {
        MeasurePointData[] measurePointDataArray = this.localReadPointData(cypherFtp, n, filter, false, false);
        return measurePointDataArray;
    }

    @Override
    public synchronized void stopMeasurePoint() throws TrackerException {
        this.localStopMeasure(false);
    }

    @Override
    public synchronized void startBkndMeasure(MeasureCfg measureCfg, DataTag[] dataTagArray) throws TrackerException {
        this.localStartBkndMeasure(measureCfg, dataTagArray, true, false);
    }

    @Override
    public synchronized void startFactoryBkndMeasure(MeasureCfg measureCfg, DataTag[] dataTagArray) throws TrackerException {
        this.localStartBkndMeasure(measureCfg, dataTagArray, true, true);
    }

    private synchronized void localStartBkndMeasure(MeasureCfg measureCfg, DataTag[] dataTagArray, boolean bl, boolean bl2) throws TrackerException {
        this.readyForCommand();
        String string = "\\data\\bkndmeas1.arg";
        if (bl2) {
            if (this.isFactoryBkndMeasuring()) {
                throw new InterfaceBusyException(Tracker.res.getString("Factory_Bkgnd_Measurement_In_Progress"));
            }
            string = "\\data\\bkndmeas2.arg";
        } else if (this.isBkndMeasuring()) {
            throw new InterfaceBusyException(Tracker.res.getString("Bkgnd_Measurements_In_Progress"));
        }
        Object object = this.checkAndSendCFGData(measureCfg, dataTagArray, true, bl2, this.ftpClient, string);
        int n = this.receiveBkndMeasurementData(this.ftpClient, bl2);
        if (n != 200) {
            throw TrackerCypher.exceptionFromResponse(this.ftpClient, n);
        }
        if (bl2) {
            if (object != null) {
                this.factoryBkndMeasureTypeList = (int[])object;
                this.factoryBkndMeasureFilter = measureCfg.getFilter();
            }
            this.factoryBkndGeneralMeasureFlag = bl;
            this.factoryBkndMeasureInProgress = true;
        } else {
            if (object != null) {
                this.bkndMeasureTypeList = (int[])object;
                this.bkndMeasureFilter = measureCfg.getFilter();
            }
            this.bkndGeneralMeasureFlag = bl;
            this.bkndMeasureInProgress = true;
        }
    }

    private boolean isBkndMeasuring() {
        return this.bkndMeasureInProgress;
    }

    private boolean isFactoryBkndMeasuring() {
        return this.factoryBkndMeasureInProgress;
    }

    private int receiveBkndMeasurementData(CypherFtp cypherFtp, boolean bl) throws TrackerException {
        DatagramSocket datagramSocket = null;
        try {
            datagramSocket = bl ? this.trkFactoryBackGndDgSocket.createSocket() : this.trkBackGndDgSocket.createSocket();
            datagramSocket.setSoTimeout(5000);
            byte[] byArray = cypherFtp.getIPAddress().getAddress();
            int n = datagramSocket.getLocalPort();
            TrackerCypher.logLine("Bknd Measure port: " + n);
            int[] nArray = new int[4];
            for (int i = 0; i < 4; ++i) {
                nArray[i] = byArray[i];
                if (nArray[i] >= 0) continue;
                int n2 = i;
                nArray[n2] = nArray[n2] + 256;
            }
            int n3 = this.executeMeasureCommand(cypherFtp, "bkndmeasure " + (bl ? "2 " : "1 ") + nArray[0] + "," + nArray[1] + "," + nArray[2] + "," + nArray[3] + "," + n / 256 + "," + n % 256, 10000);
            if (bl) {
                this.factoryBkndDgSocket = datagramSocket;
            } else {
                this.bkndDgSocket = datagramSocket;
            }
            return n3;
        }
        catch (SocketException socketException) {
            if (bl) {
                this.trkFactoryBackGndDgSocket.closeSocket();
            } else {
                this.trkBackGndDgSocket.closeSocket();
            }
            if (socketException instanceof UtilityOutOfPortsException) {
                throw new CustomPortsException(Tracker.res.getString("Out_Of_Ports"));
            }
            throw new CommunicationException(Tracker.res.getString("Measurement_Data_Exception"));
        }
        catch (FtpException ftpException) {
            if (bl) {
                this.trkFactoryBackGndDgSocket.closeSocket();
            } else {
                this.trkBackGndDgSocket.closeSocket();
            }
            throw TrackerCypher.convertFtpExc(ftpException);
        }
    }

    @Override
    public MeasureData[] readBkndMeasureData(int n) throws TrackerException {
        return this.localReadBkndMeasureData(n, false);
    }

    @Override
    public MeasureData[] readFactoryBkndMeasureData(int n) throws TrackerException {
        return this.localReadBkndMeasureData(n, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MeasureData[] localReadBkndMeasureData(int n, boolean bl) throws TrackerException {
        boolean bl2;
        MeasureData[] measureDataArray = null;
        do {
            bl2 = false;
            this.testAndSetBkndReadData(true, bl);
            try {
                measureDataArray = bl ? this.readBkndData(true, n, this.factoryBkndMeasureTypeList, this.factoryBkndMeasureFilter) : this.readBkndData(false, n, this.bkndMeasureTypeList, this.bkndMeasureFilter);
                bl2 = false;
            }
            catch (IOException iOException) {
                throw new CommunicationException(Tracker.res.getString("Measurement_Data_Exception"));
            }
            catch (FtpException ftpException) {
                bl2 = true;
            }
            finally {
                this.releaseBkndReadData(bl);
            }
        } while (bl2);
        return measureDataArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAndSetBkndReadData(boolean bl, boolean bl2) throws TrackerException {
        TrackerCypher trackerCypher = this;
        synchronized (trackerCypher) {
            if (!this.isConnected()) {
                throw new NotConnectedException();
            }
            if (bl2) {
                if (!this.isFactoryBkndMeasuring() || bl != this.factoryBkndGeneralMeasureFlag) {
                    throw new NoDataAvailableException();
                }
                if (this.factoryBkndReadInProgress) {
                    throw new InterfaceBusyException(Tracker.res.getString("Factory_Background_Read_In_Progress"));
                }
                this.factoryBkndReadInProgress = true;
            } else {
                if (!this.isBkndMeasuring() || bl != this.bkndGeneralMeasureFlag) {
                    throw new NoDataAvailableException();
                }
                if (this.bkndReadInProgress) {
                    throw new InterfaceBusyException(Tracker.res.getString("Background_Read_In_Progress"));
                }
                this.bkndReadInProgress = true;
            }
        }
    }

    private void receiveDgPacket(DatagramSocket datagramSocket, DatagramPacket datagramPacket) throws IOException {
        while (true) {
            try {
                datagramSocket.receive(datagramPacket);
            }
            catch (InterruptedIOException interruptedIOException) {
                if (this.isConnected()) continue;
                throw new IOException();
            }
            break;
        }
    }

    private MeasureData[] readBkndData(boolean bl, int n, int[] nArray, Filter filter) throws IOException, FtpException {
        MeasureData[] measureDataArray = new MeasureData[n];
        for (int i = 0; i < n; ++i) {
            MeasureStdDev measureStdDev;
            ByteArrayInputStream byteArrayInputStream;
            if (bl) {
                this.factoryBkndBuf = filter instanceof StdDevFilter ? new byte[(nArray.length * 8 + 8) * 2] : new byte[nArray.length * 8 + 8];
                this.factoryBkndPacket = new DatagramPacket(this.factoryBkndBuf, this.factoryBkndBuf.length);
                this.receiveDgPacket(this.factoryBkndDgSocket, this.factoryBkndPacket);
                if (null == this.factoryBkndPacket) {
                    throw new IOException();
                }
                byteArrayInputStream = new ByteArrayInputStream(this.factoryBkndPacket.getData());
            } else {
                this.bkndBuf = filter instanceof StdDevFilter ? new byte[(nArray.length * 8 + 8) * 2] : new byte[nArray.length * 8 + 8];
                this.bkndPacket = new DatagramPacket(this.bkndBuf, this.bkndBuf.length);
                this.receiveDgPacket(this.bkndDgSocket, this.bkndPacket);
                if (null == this.bkndPacket) {
                    throw new IOException();
                }
                byteArrayInputStream = new ByteArrayInputStream(this.bkndPacket.getData());
            }
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            Object[] objectArray = new Object[nArray.length];
            long l = dataInputStream.readInt();
            long l2 = dataInputStream.readInt();
            double d = (double)l + (double)l2 / 1000000.0;
            for (int j = 0; j < nArray.length; ++j) {
                objectArray[j] = this.readDataElement(dataInputStream, nArray[j]);
            }
            if (filter instanceof StdDevFilter) {
                Object[] objectArray2 = new Object[nArray.length];
                for (int j = 0; j < nArray.length; ++j) {
                    objectArray2[j] = this.readDataElement(dataInputStream, nArray[j]);
                }
                measureStdDev = new MeasureStdDev(objectArray2);
            } else {
                measureStdDev = null;
            }
            measureDataArray[i] = new MeasureData(d, objectArray, measureStdDev);
        }
        return measureDataArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseBkndReadData(boolean bl) {
        TrackerCypher trackerCypher = this;
        synchronized (trackerCypher) {
            if (bl) {
                this.factoryBkndReadInProgress = false;
            } else {
                this.bkndReadInProgress = false;
            }
        }
    }

    @Override
    public void stopBkndMeasure() throws TrackerException {
        this.localStopBkndMeasure(true, false);
    }

    @Override
    public void stopFactoryBkndMeasure() throws TrackerException {
        this.localStopBkndMeasure(true, true);
    }

    private synchronized void localStopBkndMeasure(boolean bl, boolean bl2) throws TrackerException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        if (bl2) {
            if (this.isFactoryBkndMeasuring() && bl == this.factoryBkndGeneralMeasureFlag) {
                try {
                    this.executeMeasureCommand(this.ftpClient, "bkndmeasure 2", 10000);
                    this.trkFactoryBackGndDgSocket.closeSocket();
                    this.factoryBkndPacket = null;
                    this.factoryBkndMeasureInProgress = false;
                }
                catch (FtpIOException ftpIOException) {
                    this.trkFactoryBackGndDgSocket.closeSocket();
                    this.factoryBkndPacket = null;
                    this.factoryBkndMeasureInProgress = false;
                }
                catch (FtpNoResponseException ftpNoResponseException) {
                    this.trkFactoryBackGndDgSocket.closeSocket();
                    this.factoryBkndPacket = null;
                    this.factoryBkndMeasureInProgress = false;
                }
                catch (FtpException ftpException) {
                    this.trkFactoryBackGndDgSocket.closeSocket();
                    throw TrackerCypher.convertFtpExc(ftpException);
                }
            }
        } else if (this.isBkndMeasuring() && bl == this.bkndGeneralMeasureFlag) {
            try {
                this.executeMeasureCommand(this.ftpClient, "bkndmeasure 1", 10000);
                this.trkBackGndDgSocket.closeSocket();
                this.bkndPacket = null;
                this.bkndMeasureInProgress = false;
            }
            catch (FtpIOException ftpIOException) {
                this.trkBackGndDgSocket.closeSocket();
                this.bkndPacket = null;
                this.bkndMeasureInProgress = false;
            }
            catch (FtpNoResponseException ftpNoResponseException) {
                this.trkBackGndDgSocket.closeSocket();
                this.bkndPacket = null;
                this.bkndMeasureInProgress = false;
            }
            catch (FtpException ftpException) {
                this.trkBackGndDgSocket.closeSocket();
                throw TrackerCypher.convertFtpExc(ftpException);
            }
        }
    }

    @Override
    public synchronized void startBkndMeasurePoint(MeasureCfg measureCfg) throws TrackerException {
        this.localStartBkndMeasurePoint(measureCfg, false);
    }

    @Override
    public synchronized void startFactoryBkndMeasurePoint(MeasureCfg measureCfg) throws TrackerException {
        this.localStartBkndMeasurePoint(measureCfg, true);
    }

    private synchronized void localStartBkndMeasurePoint(MeasureCfg measureCfg, boolean bl) throws TrackerException {
        this.localStartBkndMeasure(measureCfg, this.pointMeasurementTags, false, bl);
    }

    @Override
    public MeasurePointData[] readBkndMeasurePointData(int n) throws TrackerException {
        MeasurePointData[] measurePointDataArray = null;
        this.testAndSetBkndReadData(false, false);
        try {
            measurePointDataArray = this.readBkndPointData(this.ftpClient, false, n, this.bkndMeasureFilter);
        }
        catch (IOException iOException) {
            throw new CommunicationException(Tracker.res.getString("Measurement_Data_Exception"));
        }
        catch (FtpException ftpException) {
            throw TrackerCypher.convertFtpExc(ftpException);
        }
        finally {
            this.releaseBkndReadData(false);
        }
        return measurePointDataArray;
    }

    @Override
    public MeasurePointData[] readFactoryBkndMeasurePointData(int n) throws TrackerException {
        MeasurePointData[] measurePointDataArray = null;
        this.testAndSetBkndReadData(false, true);
        try {
            measurePointDataArray = this.readBkndPointData(this.ftpClient, true, n, this.factoryBkndMeasureFilter);
        }
        catch (IOException iOException) {
            throw new CommunicationException(Tracker.res.getString("Measurement_Data_Exception"));
        }
        catch (FtpException ftpException) {
            throw TrackerCypher.convertFtpExc(ftpException);
        }
        finally {
            this.releaseBkndReadData(true);
        }
        return measurePointDataArray;
    }

    @Override
    public void stopBkndMeasurePoint() throws TrackerException {
        this.localStopBkndMeasure(false, false);
    }

    @Override
    public void stopFactoryBkndMeasurePoint() throws TrackerException {
        this.localStopBkndMeasure(false, true);
    }

    private MeasurePointData[] readBkndPointData(CypherFtp cypherFtp, boolean bl, int n, Filter filter) throws IOException, FtpException {
        MeasurePointData[] measurePointDataArray = this.localReadPointData(cypherFtp, n, filter, true, bl);
        return measurePointDataArray;
    }

    private ServerSocket createServerSocket(int n) throws TrackerException {
        ServerSocket serverSocket;
        try {
            serverSocket = new ServerSocket(n);
        }
        catch (IOException iOException) {
            --this.numTriesTcpServerLeft;
            if (this.numTriesTcpServerLeft == 0) {
                this.numTriesTcpServerLeft = 100;
                throw new CommunicationException(Tracker.res.getString("Tracker_Alarm_Error_No_Port_Available"));
            }
            return this.createServerSocket(n + 1);
        }
        return serverSocket;
    }

    private synchronized void startAsyncTcp() throws TrackerException {
        int[] nArray = new int[4];
        this.readyForCommand();
        if (this.asyncTcpRunning()) {
            throw new InterfaceBusyException(Tracker.res.getString("Async_Already_Running"));
        }
        try {
            this.asyncTcpSocket = this.createServerSocket(55555);
            int n = this.asyncTcpSocket.getLocalPort();
            TrackerCypher.logLine("Async TCP port: " + n);
            byte[] byArray = this.ftpClient.getIPAddress().getAddress();
            for (int i = 0; i < 4; ++i) {
                nArray[i] = byArray[i];
                if (nArray[i] >= 0) continue;
                int n2 = i;
                nArray[n2] = nArray[n2] + 256;
            }
            String string = "asyncmsg tcp " + nArray[0] + "," + nArray[1] + "," + nArray[2] + "," + nArray[3] + "," + n / 256 + "," + n % 256;
            int n3 = this.executeMeasureCommand(this.ftpClient, string, 10000);
            this.asyncReadInterrupted = false;
            this.asyncReadInProgress = false;
            if (n3 != 228) {
                if (n3 == 556) {
                    throw TrackerCypher.exceptionFromResponse(this.ftpClient, n3);
                }
                if (n3 == 501) {
                    this.isAsyncTcp = false;
                    this.startAsyncUdp();
                }
            }
        }
        catch (FtpException ftpException) {
            if (this.asyncTcpSocket != null) {
                try {
                    this.asyncTcpSocket.close();
                    this.asyncTcpSocket = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw TrackerCypher.convertFtpExc(ftpException);
        }
    }

    private synchronized void startAsyncUdp() throws TrackerException {
        int[] nArray = new int[4];
        this.readyForCommand();
        if (this.asyncUdpRunning()) {
            throw new InterfaceBusyException(Tracker.res.getString("Async_Already_Running"));
        }
        try {
            this.asyncSocket = this.trkAsyncDgSocket.createSocket();
            this.asyncSocket.setSoTimeout(5000);
            int n = this.asyncSocket.getLocalPort();
            TrackerCypher.logLine("Async UDP port: " + n);
            byte[] byArray = this.ftpClient.getIPAddress().getAddress();
            for (int i = 0; i < 4; ++i) {
                nArray[i] = byArray[i];
                if (nArray[i] >= 0) continue;
                int n2 = i;
                nArray[n2] = nArray[n2] + 256;
            }
            String string = "asyncmsg " + nArray[0] + "," + nArray[1] + "," + nArray[2] + "," + nArray[3] + "," + n / 256 + "," + n % 256;
            int n3 = this.executeMeasureCommand(this.ftpClient, string, 10000);
            this.asyncReadInterrupted = false;
            this.asyncReadInProgress = false;
            if (n3 != 228 && n3 == 556) {
                throw TrackerCypher.exceptionFromResponse(this.ftpClient, n3);
            }
        }
        catch (FtpException ftpException) {
            this.trkAsyncDgSocket.closeSocket();
            throw TrackerCypher.convertFtpExc(ftpException);
        }
        catch (IOException iOException) {
            this.trkAsyncDgSocket.closeSocket();
            if (iOException instanceof UtilityOutOfPortsException) {
                throw new CustomPortsException(Tracker.res.getString("Out_Of_Ports"));
            }
            throw new CommunicationException(Tracker.res.getString("IO_Exception"));
        }
    }

    @Override
    public synchronized void startAsync() throws TrackerException {
        this.startAsyncUdp();
    }

    private boolean asyncTcpRunning() {
        return this.asyncTcpSocket != null;
    }

    private boolean asyncUdpRunning() {
        return this.asyncSocket != null;
    }

    @Override
    public Status[] statusHistory() throws TrackerException {
        Object[] objectArray = this.getHistory("\\message\\stathst.dat", Status.class);
        int n = objectArray.length;
        Status[] statusArray = new Status[n];
        for (int i = 0; i < n; ++i) {
            statusArray[i] = (Status)objectArray[i];
        }
        return statusArray;
    }

    private Change[] changeHistory() throws TrackerException {
        Object[] objectArray = this.getHistory("\\message\\eventhst.dat", Change.class);
        int n = objectArray.length;
        Change[] changeArray = new Change[n];
        for (int i = 0; i < n; ++i) {
            changeArray[i] = (Change)objectArray[i];
        }
        return changeArray;
    }

    private synchronized void stopAsyncUdp() throws TrackerException {
        this.readyForCommand();
        if (!this.asyncUdpRunning()) {
            return;
        }
        try {
            this.executeMeasureCommand(this.ftpClient, "asyncmsg", 10000);
            this.trkAsyncDgSocket.closeSocket();
            this.asyncSocket = null;
            this.asyncPacket = null;
        }
        catch (FtpIOException ftpIOException) {
        }
        catch (FtpNoResponseException ftpNoResponseException) {
            this.trkAsyncDgSocket.closeSocket();
            this.asyncSocket = null;
            this.asyncPacket = null;
        }
        catch (FtpException ftpException) {
            this.trkAsyncDgSocket.closeSocket();
            throw TrackerCypher.convertFtpExc(ftpException);
        }
    }

    private synchronized void stopAsyncTcp() throws TrackerException {
        this.readyForCommand();
        if (!this.asyncTcpRunning()) {
            return;
        }
        try {
            this.executeMeasureCommand(this.ftpClient, "asyncmsg", 10000);
        }
        catch (FtpIOException ftpIOException) {
        }
        catch (FtpNoResponseException ftpNoResponseException) {
        }
        catch (FtpException ftpException) {
            throw TrackerCypher.convertFtpExc(ftpException);
        }
        finally {
            try {
                this.asyncTcpClientSocket.close();
                this.asyncTcpSocket.close();
                this.asyncTcpClientSocket = null;
                this.asyncTcpSocket = null;
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public synchronized void stopAsync() throws TrackerException {
        this.stopAsyncUdp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private AsyncMsg readAsyncMsgUdp() throws TrackerException {
        var1_1 = null;
        var2_2 /* !! */  = null;
        var4_3 = this;
        synchronized (var4_3) {
            if (!this.asyncUdpRunning()) {
                throw new NoDataAvailableException();
            }
            this.asyncReadInProgress = true;
        }
        while (true) {
            block52: {
                block51: {
                    if (var2_2 /* !! */  != null || this.asyncReadInterrupted) break;
                    this.asyncBuf = new byte[256];
                    this.asyncPacket = new DatagramPacket(this.asyncBuf, this.asyncBuf.length);
                    this.receiveDgPacket(this.asyncSocket, this.asyncPacket);
                    var4_3 = this.asyncPacket.getData();
                    var3_9 = new ByteArrayInputStream((byte[])var4_3);
                    this.asyncInput = new BufferedReader(new InputStreamReader(var3_9));
                    var5_7 = new DataInputStream(var3_9);
                    var6_10 = var5_7.readUnsignedShort();
                    var7_11 = (short)((short)var5_7.readByte() & 255);
                    var8_12 = (short)((short)var5_7.readByte() & 255);
                    var9_13 = 0.0;
                    var11_14 = 0;
                    var12_15 = 0;
                    if (var7_11 == 1) {
                        var11_14 = var5_7.readInt();
                        var12_15 = var5_7.readInt();
                        var9_13 = var11_14;
                    } else {
                        var9_13 = var5_7.readDouble();
                    }
                    var13_16 = var8_12 == 1;
                    var14_17 = System.currentTimeMillis() / 1000L;
                    if (var6_10 == 1 || var6_10 == 2) {
                        var16_18 = var6_10 == 1 ? 1 : 2;
                        if (!this.batteryPresent(var16_18)) continue;
                        var2_2 /* !! */  = new Alarm(var16_18, var13_16, var14_17, -1, Double.toString(var9_13));
                        continue;
                    }
                    if (var6_10 == 3) {
                        var16_19 = new DataTag[]{new DataTagUnsigned16("weather.device.temperature.ext1.reading.status")};
                        var17_30 /* !! */  = this.readOneTimeData(var16_19);
                        if ((Integer)var17_30 /* !! */ [0] != 0) continue;
                        var2_2 /* !! */  = new Alarm(var6_10, var13_16, var14_17, -1, Double.toString(var9_13));
                        continue;
                    }
                    if (var6_10 >= 21 && var6_10 <= 24) {
                        var16_20 = var11_14 != 0;
                        var2_2 /* !! */  = new ProbeButtonChange(var6_10, var16_20, var14_17, -1, Double.toString(var9_13));
                        continue;
                    }
                    if (var6_10 == 11) {
                        var16_21 = this.constructTargetType(var11_14);
                        var2_2 /* !! */  = new Change(4, var14_17, -1, "TARGET_TYPE change", var16_21);
                        continue;
                    }
                    if (var6_10 == 12) {
                        var16_22 = var11_14 != 0;
                        var2_2 /* !! */  = new Change(5, var14_17, -1, "PROBE_CONNECTED change", new Boolean(var16_22));
                        continue;
                    }
                    if (var6_10 == 4) {
                        var2_2 /* !! */  = new Alarm(var6_10, var13_16, var14_17, -1, Double.toString(var9_13));
                        continue;
                    }
                    if (var6_10 == 13 && var11_14 == 1) {
                        var16_23 = new Probe(this.changeProbe);
                        var2_2 /* !! */  = new Change(6, var14_17, -1, "PROBE_CHANGE change", var16_23);
                        continue;
                    }
                    if (var6_10 == 25) {
                        var16_24 = var11_14 != 0;
                        this.extractProbeFromAsyncPkt(var5_7, var16_24);
                        if (var16_24) {
                            var2_2 /* !! */  = new Change(6, var14_17, -1, "PROBE_CHANGE change", this.changeProbe);
                            continue;
                        }
                        var2_2 /* !! */  = new Change(13, var14_17, -1, "kinematic adapter disconnect", this.changeProbe);
                        continue;
                    }
                    if (var6_10 == 26) {
                        this.extractProbeFromAsyncPkt(var5_7, true);
                        var2_2 /* !! */  = new Change(6, var14_17, -1, "PROBE_CHANGE change", this.changeProbe);
                        continue;
                    }
                    if (var6_10 == 14) {
                        var16_25 = this.probeBatteryState((int)var9_13);
                        var17_30 /* !! */  = new ProbeBatteryState(var16_25);
                        var2_2 /* !! */  = new Change(7, var14_17, -1, "PROBE_BATTERY_STATE_CHANGE change", var17_30 /* !! */ );
                        continue;
                    }
                    if (var6_10 != 15 && var6_10 != 16) ** GOTO lbl108
                    var16_26 = this.getTrkBattery1State(var6_10, var11_14);
                    if (this.bat1State != var16_26) break block51;
                    var17_30 /* !! */  = null;
                    var18_31 = this;
                    synchronized (var18_31) {
                        this.asyncReadInProgress = false;
                        while (this.asyncReadInterrupted) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException var19_33) {}
                        }
                    }
                    return var17_30 /* !! */ ;
                }
                this.bat1State = var16_26;
                var17_30 /* !! */  = new BatteryState(var16_26);
                var2_2 /* !! */  = new Change(9, var14_17, -1, "TRACKER_BATTERY_1_STATE_CHANGE change", var17_30 /* !! */ );
                continue;
lbl108:
                // 1 sources

                if (var6_10 != 17 && var6_10 != 18) ** GOTO lbl133
                var16_27 = this.getTrkBattery2State(var6_10, var11_14);
                if (this.bat2State != var16_27) break block52;
                var17_30 /* !! */  = null;
                var18_32 = this;
                synchronized (var18_32) {
                    this.asyncReadInProgress = false;
                    while (this.asyncReadInterrupted) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException var19_34) {}
                    }
                }
                return var17_30 /* !! */ ;
            }
            this.bat2State = var16_27;
            var17_30 /* !! */  = new BatteryState(var16_27);
            var2_2 /* !! */  = new Change(10, var14_17, -1, "TRACKER_BATTERY_2_STATE_CHANGE change", var17_30 /* !! */ );
            continue;
lbl133:
            // 1 sources

            if (var6_10 == 19) {
                var16_28 = var11_14 == 1;
                var2_2 /* !! */  = new Change(11, var14_17, -1, "RUN_AUTO_COMP change", new Boolean(var16_28));
                continue;
            }
            if (var6_10 != 20) continue;
            var16_29 = var11_14 != 0;
            var2_2 /* !! */  = new Change(12, var14_17, -1, "NEED_HOME change", new Boolean(var16_29));
            continue;
            {
                catch (InterruptedIOException var4_4) {
                    continue;
                }
                catch (IOException var4_5) {
                    throw new NoDataAvailableException();
                }
            }
            break;
        }
        var4_3 = this;
        synchronized (var4_3) {
            this.asyncReadInProgress = false;
            while (this.asyncReadInterrupted) {
                try {
                    this.wait();
                }
                catch (InterruptedException var5_8) {}
            }
        }
        catch (Throwable var23_38) {
            var24_39 = this;
            synchronized (var24_39) {
                this.asyncReadInProgress = false;
                while (this.asyncReadInterrupted) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException var25_40) {}
                }
            }
            throw var23_38;
        }
        return var2_2 /* !! */ ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private AsyncMsg readAsyncMsgTcp() throws TrackerException {
        var1_1 = null;
        var2_2 /* !! */  = null;
        var4_3 = this;
        synchronized (var4_3) {
            if (!this.asyncTcpRunning()) {
                throw new NoDataAvailableException();
            }
            this.asyncReadInProgress = true;
        }
        while (true) {
            block57: {
                block56: {
                    block55: {
                        if (var2_2 /* !! */  != null || this.asyncReadInterrupted) break;
                        if (this.asyncTcpClientSocket == null && this.asyncTcpSocket != null) {
                            this.asyncTcpClientSocket = this.asyncTcpSocket.accept();
                        }
                        if (this.asyncTcpClientSocket != null) break block55;
                        var4_3 = null;
                        var5_8 = this;
                        synchronized (var5_8) {
                            this.asyncReadInProgress = false;
                            while (this.asyncReadInterrupted) {
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException var6_11) {}
                            }
                        }
                        return var4_3;
                    }
                    var4_3 = new DataInputStream(this.asyncTcpClientSocket.getInputStream());
                    var5_7 = var4_3.readUnsignedShort();
                    var6_10 = (short)((short)var4_3.readByte() & 255);
                    var7_12 = (short)((short)var4_3.readByte() & 255);
                    var8_14 = 0.0;
                    var10_15 = 0;
                    var11_16 = 0;
                    if (var6_10 == 1) {
                        var10_15 = var4_3.readInt();
                        var11_16 = var4_3.readInt();
                        var8_14 = var10_15;
                    } else {
                        var8_14 = var4_3.readDouble();
                    }
                    var12_17 = var7_12 == 1;
                    var13_18 = System.currentTimeMillis() / 1000L;
                    if (var5_7 == 1 || var5_7 == 2) {
                        var15_19 = var5_7 == 1 ? 1 : 2;
                        if (!this.batteryPresent(var15_19)) continue;
                        var2_2 /* !! */  = new Alarm(var15_19, var12_17, var13_18, -1, Double.toString(var8_14));
                        continue;
                    }
                    if (var5_7 == 3) {
                        var15_20 = new DataTag[]{new DataTagUnsigned16("weather.device.temperature.ext1.reading.status")};
                        var16_28 /* !! */  = this.readOneTimeData(var15_20);
                        if ((Integer)var16_28 /* !! */ [0] != 0) continue;
                        var2_2 /* !! */  = new Alarm(var5_7, var12_17, var13_18, -1, Double.toString(var8_14));
                        continue;
                    }
                    if (var5_7 >= 21 && var5_7 <= 24) {
                        var15_21 = var10_15 != 0;
                        var2_2 /* !! */  = new ProbeButtonChange(var5_7, var15_21, var13_18, -1, Double.toString(var8_14));
                        continue;
                    }
                    if (var5_7 == 11) {
                        var15_22 = this.constructTargetType(var10_15);
                        var2_2 /* !! */  = new Change(4, var13_18, -1, "TARGET_TYPE change", var15_22);
                        continue;
                    }
                    if (var5_7 == 12) {
                        var15_23 = var10_15 != 0;
                        var2_2 /* !! */  = new Change(5, var13_18, -1, "PROBE_CONNECTED change", new Boolean(var15_23));
                        continue;
                    }
                    if (var5_7 == 4) {
                        var2_2 /* !! */  = new Alarm(var5_7, var12_17, var13_18, -1, Double.toString(var8_14));
                        continue;
                    }
                    if (var5_7 == 13 && var10_15 == 1) {
                        var15_24 = new Probe(this.changeProbe);
                        var2_2 /* !! */  = new Change(6, var13_18, -1, "PROBE_CHANGE change", var15_24);
                        continue;
                    }
                    if (var5_7 == 14) {
                        var15_25 = this.probeBatteryState((int)var8_14);
                        var16_28 /* !! */  = new ProbeBatteryState(var15_25);
                        var2_2 /* !! */  = new Change(7, var13_18, -1, "PROBE_BATTERY_STATE_CHANGE change", var16_28 /* !! */ );
                        continue;
                    }
                    if (var5_7 != 15 && var5_7 != 16) ** GOTO lbl110
                    var15_26 = this.getTrkBattery1State(var5_7, var10_15);
                    if (this.bat1State != var15_26) break block56;
                    var16_28 /* !! */  = null;
                    var17_29 = this;
                    synchronized (var17_29) {
                        this.asyncReadInProgress = false;
                        while (this.asyncReadInterrupted) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException var18_31) {}
                        }
                    }
                    return var16_28 /* !! */ ;
                }
                this.bat1State = var15_26;
                var16_28 /* !! */  = new BatteryState(var15_26);
                var2_2 /* !! */  = new Change(9, var13_18, -1, "TRACKER_BATTERY_1_STATE_CHANGE change", var16_28 /* !! */ );
                continue;
lbl110:
                // 1 sources

                if (var5_7 != 17 && var5_7 != 18) continue;
                var15_27 = this.getTrkBattery2State(var5_7, var10_15);
                if (this.bat2State != var15_27) break block57;
                var16_28 /* !! */  = null;
                var17_30 = this;
                synchronized (var17_30) {
                    this.asyncReadInProgress = false;
                    while (this.asyncReadInterrupted) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException var18_32) {}
                    }
                }
                return var16_28 /* !! */ ;
            }
            this.bat2State = var15_27;
            var16_28 /* !! */  = new BatteryState(var15_27);
            var2_2 /* !! */  = new Change(10, var13_18, -1, "TRACKER_BATTERY_2_STATE_CHANGE change", var16_28 /* !! */ );
            {
                catch (SocketException var4_4) {
                }
                catch (IOException var4_5) {}
            }
            continue;
            break;
        }
        var4_3 = this;
        synchronized (var4_3) {
            this.asyncReadInProgress = false;
            while (this.asyncReadInterrupted) {
                try {
                    this.wait();
                }
                catch (InterruptedException var5_9) {}
            }
        }
        catch (Throwable var22_36) {
            var23_37 = this;
            synchronized (var23_37) {
                this.asyncReadInProgress = false;
                while (this.asyncReadInterrupted) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException var24_38) {}
                }
            }
            throw var22_36;
        }
        return var2_2 /* !! */ ;
    }

    @Override
    public AsyncMsg readAsyncMsg() throws TrackerException {
        return this.readAsyncMsgUdp();
    }

    @Override
    public Diagnostic[] diagnosticHistory() throws TrackerException {
        Object[] objectArray = this.getHistory("\\message\\diaghst.dat", Diagnostic.class);
        int n = objectArray.length;
        Diagnostic[] diagnosticArray = new Diagnostic[n];
        for (int i = 0; i < n; ++i) {
            diagnosticArray[i] = (Diagnostic)objectArray[i];
        }
        return diagnosticArray;
    }

    /*
     * Exception decompiling
     */
    private Object[] getHistory(String var1_1, Class var2_2) throws TrackerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 16[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private AsyncMsg convertLineToAsync(String string) throws TrackerException {
        AsyncMsg asyncMsg = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        try {
            String string2 = stringTokenizer.nextToken();
            switch (string2.charAt(0)) {
                case 'D': {
                    asyncMsg = this.convertToDiag(string, stringTokenizer);
                    break;
                }
                case 'E': {
                    asyncMsg = this.convertToChange(string, stringTokenizer);
                    break;
                }
                case 'S': {
                    asyncMsg = this.convertToStatus(string, stringTokenizer);
                    break;
                }
                case 'A': {
                    asyncMsg = this.convertToAlarm(string, stringTokenizer);
                    break;
                }
                default: {
                    throw new NoSuchElementException();
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new DataFormatException();
        }
        return asyncMsg;
    }

    private Diagnostic convertToDiag(String string, StringTokenizer stringTokenizer) {
        int n = Integer.parseInt(stringTokenizer.nextToken(), 16);
        int n2 = n < 0 || n >= diagMap.length ? 0 : diagMap[n];
        String string2 = "Code=" + n + " ";
        string2 = string2 + "Param1=" + stringTokenizer.nextToken() + " ";
        string2 = string2 + "Param2=" + stringTokenizer.nextToken() + " ";
        string2 = string2 + "Task=" + stringTokenizer.nextToken();
        double d = Double.parseDouble(stringTokenizer.nextToken());
        int n3 = Integer.parseInt(stringTokenizer.nextToken(), 16);
        return new Diagnostic(n2, d, n3, string2);
    }

    private Change convertToChange(String string, StringTokenizer stringTokenizer) {
        Object object;
        int n = Integer.parseInt(stringTokenizer.nextToken(), 16) & 0xFF;
        int n2 = n < 0 || n >= changeMap.length ? 0 : changeMap[n];
        int n3 = Integer.parseInt(stringTokenizer.nextToken());
        switch (n2) {
            case 2: {
                object = new Boolean(0 == n3);
                break;
            }
            case 1: {
                object = new Boolean(1 == n3);
                break;
            }
            case 4: {
                try {
                    object = this.constructTargetType(n3);
                }
                catch (TrackerException trackerException) {
                    object = null;
                }
                break;
            }
            case 3: {
                object = this.constructDistanceMode(n3);
                break;
            }
            default: {
                object = null;
            }
        }
        double d = Double.parseDouble(stringTokenizer.nextToken());
        int n4 = Integer.parseInt(stringTokenizer.nextToken(), 16);
        return new Change(n2, d, n4, string, object);
    }

    private Status convertToStatus(String string, StringTokenizer stringTokenizer) {
        int n = Integer.parseInt(stringTokenizer.nextToken(), 16) & 0xFF;
        String string2 = stringTokenizer.nextToken();
        double d = Double.parseDouble(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken(), 16);
        boolean bl = string2.compareToIgnoreCase("on") == 0;
        int n3 = n < 0 || n >= statusMap.length ? 0 : statusMap[n];
        return new Status(n3, bl, d, n2, string);
    }

    private Alarm convertToAlarm(String string, StringTokenizer stringTokenizer) {
        int n = Integer.parseInt(stringTokenizer.nextToken());
        String string2 = stringTokenizer.nextToken();
        double d = Double.parseDouble(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken(), 16);
        boolean bl = string2.compareToIgnoreCase("on") == 0;
        return new Alarm(n, bl, d, n2, string);
    }

    @Override
    public Alarm[] alarmHistory() throws TrackerException {
        Object[] objectArray = this.getHistory("\\message\\alarmhst.dat", Alarm.class);
        int n = objectArray.length;
        Alarm[] alarmArray = new Alarm[n];
        for (int i = 0; i < n; ++i) {
            alarmArray[i] = (Alarm)objectArray[i];
        }
        return alarmArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeOneTimeData(CypherFtp cypherFtp, DataTag[] dataTagArray, Object[] objectArray) throws TrackerException {
        int n;
        TrackerException trackerException = null;
        TrackerCypher.writeOneTimePoints(cypherFtp, dataTagArray);
        for (n = 0; n < 3; ++n) {
            int n2;
            trackerException = null;
            try {
                TrackerCypher.logLine("in storeOneTimeData sendFTPStart : " + new Date().toString());
                n2 = TrackerCypher.sendFTPStart(cypherFtp, "\\data\\singlbin.dat");
                TrackerCypher.logLine("out storeOneTimeData sendFTPStart : " + n2 + ":" + new Date().toString());
                if (150 != n2) {
                    TrackerCypher.logLine("storeOneTimeData sendFTPStart exceptionFromResponse : " + new Date().toString());
                    throw TrackerCypher.exceptionFromResponse(cypherFtp, n2);
                }
            }
            catch (FtpException ftpException) {
                throw TrackerCypher.convertFtpExc(ftpException);
            }
            int[] nArray = TrackerCypher.createTypeList(dataTagArray);
            TrackerCypher.logLine("in storeOneTimeData writeDataElement : " + new Date().toString());
            try {
                for (int i = 0; i < dataTagArray.length; ++i) {
                    TrackerCypher.writeDataElement(cypherFtp, objectArray[i], nArray[i]);
                }
                TrackerCypher.logLine("out storeOneTimeData writeDataElement : " + new Date().toString());
            }
            catch (FtpException ftpException) {
                trackerException = TrackerCypher.convertFtpExc(ftpException);
            }
            finally {
                block19: {
                    try {
                        TrackerCypher.logLine("in storeOneTimeData sendEnd : " + new Date().toString());
                        n2 = cypherFtp.sendEnd(10000);
                        TrackerCypher.logLine("out storeOneTimeData sendEnd : " + new Date().toString());
                        if (226 != n2) {
                            TrackerCypher.logLine("storeOneTimeData sendEnd exceptionFromResponse: " + new Date().toString());
                            trackerException = TrackerCypher.exceptionFromResponse(cypherFtp, n2);
                        }
                    }
                    catch (FtpException ftpException) {
                        if (null != trackerException) break block19;
                        trackerException = TrackerCypher.convertFtpExc(ftpException);
                    }
                }
            }
            if (trackerException == null) break;
        }
        if (n == 3 && null != trackerException) {
            TrackerCypher.logLine("storeOneTimeData maxtries throw ex: " + new Date().toString());
            throw trackerException;
        }
    }

    @Override
    public synchronized void writeOneTimeData(DataTag[] dataTagArray, Object[] objectArray) throws TrackerException {
        this.readyForCommand();
        this.storeOneTimeData(this.ftpClient, dataTagArray, objectArray);
    }

    private static void writeDataElement(CypherFtp cypherFtp, Object object, int n) throws FtpException {
        switch (n) {
            case 1: {
                byte by = (byte)((Short)object & 0xFF);
                cypherFtp.sendByte(by);
                cypherFtp.sendByte((byte)0);
                cypherFtp.sendUnsignedShort(0);
                cypherFtp.sendUnsignedInt(0L);
                break;
            }
            case 2: {
                cypherFtp.sendUnsignedShort(((Integer)object).intValue());
                cypherFtp.sendUnsignedShort(0);
                cypherFtp.sendUnsignedInt(0L);
                break;
            }
            case 3: {
                cypherFtp.sendUnsignedInt(((Long)object).longValue());
                cypherFtp.sendUnsignedInt(0L);
                break;
            }
            case 4: {
                cypherFtp.sendDouble(((Double)object).doubleValue());
            }
        }
    }

    static Object[] getTagData(CypherFtp cypherFtp, DataTag[] dataTagArray) throws TrackerException {
        Object[] objectArray = null;
        TrackerException trackerException = null;
        TrackerCypher.writeOneTimePoints(cypherFtp, dataTagArray);
        int n = 1;
        for (int i = 0; i < n; ++i) {
            trackerException = null;
            try {
                objectArray = TrackerCypher.readOneTimePoints(cypherFtp, dataTagArray);
            }
            catch (TrackerException trackerException2) {
                trackerException = trackerException2;
            }
            if (null == trackerException) break;
        }
        if (null != trackerException) {
            throw trackerException;
        }
        return objectArray;
    }

    @Override
    public synchronized Object[] readOneTimeData(DataTag[] dataTagArray) throws TrackerException {
        this.readyForCommand();
        return TrackerCypher.getTagData(this.ftpClient, dataTagArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object[] readOneTimePoints(CypherFtp cypherFtp, DataTag[] dataTagArray) throws TrackerException {
        int n;
        TrackerException trackerException = null;
        Object[] objectArray = new Object[dataTagArray.length];
        int[] nArray = TrackerCypher.createTypeList(dataTagArray);
        for (n = 0; n < 3; ++n) {
            int n2;
            trackerException = null;
            try {
                TrackerCypher.logLine("in readOneTimePoints receiveFTPStart: " + new Date().toString());
                n2 = TrackerCypher.receiveFTPStart(cypherFtp, "\\data\\singlbin.dat");
                TrackerCypher.logLine("out readOneTimePoints receiveFTPStart: " + new Date().toString());
                if (150 != n2) {
                    TrackerCypher.logLine("readOneTimePoints receiveFTPStart exceptionFromResponse: " + new Date().toString());
                    throw TrackerCypher.exceptionFromResponse(cypherFtp, n2);
                }
            }
            catch (FtpException ftpException) {
                throw TrackerCypher.convertFtpExc(ftpException);
            }
            TrackerCypher.logLine("in readOneTimePoints readDataElement: " + new Date().toString());
            try {
                for (int i = 0; i < dataTagArray.length; ++i) {
                    objectArray[i] = TrackerCypher.readDataElement(cypherFtp, nArray[i]);
                }
                TrackerCypher.logLine("out readOneTimePoints readDataElement: " + new Date().toString());
            }
            catch (FtpException ftpException) {
                trackerException = TrackerCypher.convertFtpExc(ftpException);
            }
            finally {
                block19: {
                    try {
                        TrackerCypher.logLine("in readOneTimePoints receiveEnd: " + new Date().toString());
                        n2 = cypherFtp.receiveEnd();
                        TrackerCypher.logLine("out readOneTimePoints receiveEnd: " + new Date().toString());
                        if (226 != n2) {
                            TrackerCypher.logLine("readOneTimePoints receiveEnd exceptionFromResponse: " + new Date().toString());
                            trackerException = TrackerCypher.exceptionFromResponse(cypherFtp, n2);
                        }
                    }
                    catch (FtpException ftpException) {
                        if (null != trackerException) break block19;
                        trackerException = TrackerCypher.convertFtpExc(ftpException);
                    }
                }
            }
            if (trackerException == null) break;
        }
        if (n == 3 && null != trackerException) {
            TrackerCypher.logLine("readOneTimePoints rmax tries throw trkex: " + new Date().toString());
            throw trackerException;
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeOneTimePoints(CypherFtp cypherFtp, DataTag[] dataTagArray) throws TrackerException {
        int n;
        TrackerException trackerException = null;
        for (n = 0; n < 3; ++n) {
            int n2;
            trackerException = null;
            try {
                TrackerCypher.logLine("in writeOneTimePoints sendFTPStart: " + new Date().toString());
                n2 = TrackerCypher.sendFTPStart(cypherFtp, "\\data\\single.arg");
                TrackerCypher.logLine("out writeOneTimePoints sendFTPStart: " + n2 + " : " + new Date().toString());
                if (n2 != 150) {
                    TrackerCypher.logLine("writeOneTimePoints sendFTPStart exceptionFromResponse: " + new Date().toString());
                    throw TrackerCypher.exceptionFromResponse(cypherFtp, n2);
                }
            }
            catch (FtpException ftpException) {
                throw TrackerCypher.convertFtpExc(ftpException);
            }
            try {
                TrackerCypher.logLine("in writeOneTimePoints sendLine : " + new Date().toString());
                for (int i = 0; i < dataTagArray.length; ++i) {
                    cypherFtp.sendLine(dataTagArray[i].getName());
                }
                TrackerCypher.logLine("out writeOneTimePoints sendLine : " + new Date().toString());
            }
            catch (FtpException ftpException) {
                trackerException = TrackerCypher.convertFtpExc(ftpException);
            }
            finally {
                block19: {
                    try {
                        TrackerCypher.logLine("in writeOneTimePoints sendEnd : " + new Date().toString());
                        n2 = cypherFtp.sendEnd(10000);
                        TrackerCypher.logLine("out writeOneTimePoints sendEnd : " + n2 + " : " + new Date().toString());
                        if (n2 != 226 && trackerException == null) {
                            TrackerCypher.logLine("writeOneTimePoints sendEnd exceptionFromResponse: " + new Date().toString());
                            trackerException = TrackerCypher.exceptionFromResponse(cypherFtp, n2);
                        }
                    }
                    catch (FtpException ftpException) {
                        if (trackerException != null) break block19;
                        trackerException = TrackerCypher.convertFtpExc(ftpException);
                    }
                }
            }
            if (trackerException == null) break;
        }
        if (n == 3 && trackerException != null) {
            TrackerCypher.logLine("writeOneTimePoints maxtries throw ex: " + new Date().toString());
            throw trackerException;
        }
    }

    private static Object readDataElement(CypherFtp cypherFtp, int n) throws FtpException {
        Number number = null;
        switch (n) {
            case 1: {
                short s = (short)((short)cypherFtp.receiveByte() & 0xFF);
                number = new Short(s);
                cypherFtp.receiveSkip(7);
                break;
            }
            case 2: {
                number = new Integer(cypherFtp.receiveUnsignedShort());
                cypherFtp.receiveSkip(6);
                break;
            }
            case 3: {
                number = new Long(cypherFtp.receiveUnsignedInt());
                cypherFtp.receiveSkip(4);
                break;
            }
            case 4: {
                number = new Double(cypherFtp.receiveDouble());
            }
        }
        return number;
    }

    @Override
    public boolean connected() throws TrackerException {
        return this.isConnected();
    }

    @Override
    public boolean targetPresent() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("target.state")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        return ((Long)objectArray[0]).intValue() == 2;
    }

    @Override
    public boolean targetLocationValid() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned16("target.corrected.azimuth.status"), new DataTagUnsigned16("target.corrected.zenith.status"), new DataTagUnsigned16("target.corrected.distance.status")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        return (Integer)objectArray[0] == 0 && (Integer)objectArray[1] == 0 && (Integer)objectArray[2] == 0;
    }

    @Override
    public boolean motorsOn() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("servo.motor_state.current")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        return ((Long)objectArray[0]).intValue() == 1;
    }

    @Override
    public boolean initialized() throws TrackerException {
        return this.initialized(true);
    }

    @Override
    public boolean initialized(boolean bl) throws TrackerException {
        DataTag[] dataTagArray = new DataTag[4];
        DataTag[] dataTagArray2 = new DataTag[1];
        dataTagArray[0] = new DataTagUnsigned32("servo.motor_state.current");
        dataTagArray[1] = new DataTagUnsigned16("position_device.psd.raw.a.status");
        dataTagArray[2] = new DataTagUnsigned16("position_device.azimuth_encoder.reading.status");
        dataTagArray[3] = new DataTagUnsigned16("position_device.zenith_encoder.reading.status");
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        if ((Long)objectArray[0] != 0L && (Long)objectArray[0] != 1L) {
            return false;
        }
        if (0 != ((Integer)objectArray[1] & 0x20)) {
            return false;
        }
        if (0 != (1 & (Integer)objectArray[2]) || 0 != (0x20 & (Integer)objectArray[2]) || 0 != (1 & (Integer)objectArray[3]) || 0 != (0x20 & (Integer)objectArray[3])) {
            return false;
        }
        if (!bl) {
            dataTagArray2[0] = new DataTagUnsigned16("system.zero_correct.time.status");
            objectArray = this.readOneTimeData(dataTagArray2);
            if ((Integer)objectArray[0] != 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean trackingOn() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("servo.tracking_mode")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        return ((Long)objectArray[0]).intValue() == 0;
    }

    @Override
    public boolean admCapable() throws TrackerException {
        return true;
    }

    @Override
    public boolean admOnlyCapable() {
        return true;
    }

    @Override
    public boolean interferometerCapable() throws TrackerException {
        return false;
    }

    @Override
    public boolean levelCapable() throws TrackerException {
        return true;
    }

    @Override
    public DistanceMode distanceMeasureMode() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("system.distance_mode")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        return this.constructDistanceMode((int)((Long)objectArray[0]).longValue());
    }

    private DistanceMode constructDistanceMode(int n) {
        switch (n) {
            case 1: {
                return new InterferometerOnly();
            }
            case 3: {
                return new ADMOnly();
            }
            case 2: {
                return new InterferometerSetByADM();
            }
            case 0: {
                return new UserSpecifiedDistance();
            }
        }
        return new InterferometerOnly();
    }

    @Override
    public TargetType targetType() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("target.type")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        return this.constructTargetType((int)((Long)objectArray[0]).longValue());
    }

    private TargetType constructTargetType(int n) throws TrackerException {
        switch (n) {
            case 0: {
                return new SMRTargetType(0.0381);
            }
            case 1: {
                return new MirrorTargetType();
            }
            case 2: {
                return new SMRTargetType(0.0127);
            }
            case 3: {
                return new SMRTargetType(0.022225);
            }
            case 4: {
                return new SMRTargetType(0.0);
            }
            case 5: {
                return new WindowedSMRTargetType(0.0381);
            }
            case 6: {
                return new WindowedSMRTargetType(0.022225);
            }
            case 7: {
                double[] dArray = this.getCatEyeTargetOffset();
                return new CatEyeTargetType(dArray[0], dArray[1]);
            }
            case 8: {
                return new SixDofTargetType();
            }
        }
        throw new UnsupportedFeatureException(Tracker.res.getString("Target_Type_Not_Supported"));
    }

    @Override
    public boolean backsightOrientation() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("system.orientation")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        return ((Long)objectArray[0]).intValue() == 1;
    }

    @Override
    public LevelData measureLevel() throws TrackerException {
        int n;
        int n2;
        int n3;
        double d;
        double d2;
        double d3;
        Object[] objectArray;
        DataTag[] dataTagArray;
        block12: {
            dataTagArray = new DataTag[6];
            objectArray = null;
            d3 = 0.0;
            d2 = 0.0;
            d = 0.0;
            n3 = 0;
            n2 = 0;
            n = 0;
            try {
                this.trackerCommand("level run", 180000);
            }
            catch (TrackerException trackerException) {
                String[] stringArray;
                String string = trackerException.getMessage();
                if (string.equals("") || (stringArray = string.split(":")).length <= 1) break block12;
                int n4 = -1;
                try {
                    n4 = Integer.parseInt(stringArray[1].trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                switch (n4) {
                    case 88: {
                        throw new InternalDeviceFailureException(Tracker.res.getString("Invalid_Level"));
                    }
                    case 51: {
                        throw new InternalDeviceFailureException(Tracker.res.getString("Failed_To_Measure_Level"));
                    }
                    case 91: {
                        throw new InternalDeviceFailureException(Tracker.res.getString("Tracker_Tilted_More_Than_2_Degrees"));
                    }
                    case 36: 
                    case 83: 
                    case 92: {
                        throw new InternalDeviceFailureException(Tracker.res.getString("Level_Error"));
                    }
                }
                throw trackerException;
            }
        }
        dataTagArray[0] = new DataTagDouble("fine_level.tilt.rx.value");
        dataTagArray[1] = new DataTagUnsigned16("fine_level.tilt.rx.status");
        dataTagArray[2] = new DataTagDouble("fine_level.tilt.ry.value");
        dataTagArray[3] = new DataTagUnsigned16("fine_level.tilt.ry.status");
        dataTagArray[4] = new DataTagDouble("fine_level.tilt.rz.value");
        dataTagArray[5] = new DataTagUnsigned16("fine_level.tilt.rz.status");
        objectArray = this.readOneTimeData(dataTagArray);
        n3 = (Integer)objectArray[1];
        n2 = (Integer)objectArray[3];
        n = (Integer)objectArray[5];
        if ((n3 & 1) != 0 || (n2 & 1) != 0 || (n & 1) != 0) {
            throw new InternalDeviceFailureException(Tracker.res.getString("Level_Error"));
        }
        if ((n3 & 2) != 0 || (n2 & 2) != 0 || (n & 2) != 0) {
            throw new InternalDeviceFailureException(Tracker.res.getString("Level_Inaccurate"));
        }
        d3 = (Double)objectArray[0];
        d2 = (Double)objectArray[2];
        d = (Double)objectArray[4];
        return new LevelData(d3, d2, d);
    }

    @Override
    public MaterialTemperatureData measureMaterialTemperature() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[3];
        Object[] objectArray = null;
        double d = 0.0;
        int n = 0;
        int n2 = 0;
        dataTagArray[0] = new DataTagDouble("weather.current.ext_material.value");
        dataTagArray[1] = new DataTagUnsigned16("weather.current.ext_material.status");
        dataTagArray[2] = new DataTagUnsigned32("weather.current.ext_material.count");
        objectArray = this.readOneTimeData(dataTagArray);
        d = (Double)objectArray[0];
        n = (Integer)objectArray[1];
        n2 = (int)((Long)objectArray[2]).longValue();
        if (n2 == 0) {
            throw new InternalDeviceFailureException(Tracker.res.getString("Sensor_Not_Found"));
        }
        if ((n & 0x80) != 0) {
            throw new InternalDeviceFailureException(Tracker.res.getString("Sensor_Disabled"));
        }
        if ((n & 2) != 0) {
            throw new InternalDeviceFailureException(Tracker.res.getString("Sensor_Inaccurate"));
        }
        if ((n & 1) != 0) {
            throw new InternalDeviceFailureException(Tracker.res.getString("Sensor_Error"));
        }
        return new MaterialTemperatureData(d, n2);
    }

    @Override
    public TrackerApp startApplication(String string, String string2, Tracker tracker, JFrame jFrame) throws TrackerException {
        TrackerCypher.logLine("Launch application: " + string);
        Class[] classArray = new Class[3];
        Object[] objectArray = new Object[3];
        this.readyForCommand();
        AppRec appRec = this.findAppInfo(string);
        if (!this.initialLocalAppValueSet) {
            this.loadingLocalApp = appRec.readFromLocal;
            this.initialLocalAppValueSet = true;
        }
        if (this.loadingLocalApp != appRec.readFromLocal) {
            this.closeCachedJars();
            this.jarClassLoader = null;
            this.jarClassLoader = new JarClassLoader();
            this.loadingLocalApp = appRec.readFromLocal;
        }
        if (appRec.isSet()) {
            throw new ApplicationFailedException(Tracker.res.getString("Application_Already_Running"));
        }
        try {
            int n;
            this.jarClassLoader.setAppName(string);
            Class<?> clazz = this.jarClassLoader.loadClass(appRec.fullQualifiedName);
            classArray[0] = String.class;
            classArray[1] = Tracker.class;
            classArray[2] = JFrame.class;
            Constructor<?> constructor = clazz.getConstructor(classArray);
            objectArray[0] = string2;
            objectArray[1] = tracker;
            objectArray[2] = jFrame;
            TrackerApp trackerApp = (TrackerApp)constructor.newInstance(objectArray);
            if ("CompIT".equalsIgnoreCase(string)) {
                n = 0;
                if (null != string2) {
                    n = string2.toUpperCase(Locale.ENGLISH).indexOf("QUICK_COMP");
                    if (-1 != n) {
                        this.subCompApp = "QuickComp";
                    } else if (-1 != string2.toUpperCase(Locale.ENGLISH).indexOf("AAC") || -1 != string2.toUpperCase(Locale.ENGLISH).indexOf("QBC")) {
                        this.subCompApp = "AngularAccuracy";
                    }
                }
            }
            for (n = 0; n < this.maintainApp.size(); ++n) {
                appRec = (AppRec)this.maintainApp.get(n);
                if (!appRec.appName.equals(string)) continue;
                appRec.set(trackerApp);
                this.maintainApp.set(n, appRec);
                if (this.subCompApp.length() <= 0) break;
                this.setSubAppStateForCompIT(trackerApp);
                break;
            }
            return trackerApp;
        }
        catch (FtpException ftpException) {
            PrintException.print((Exception)((Object)ftpException));
            TrackerCypher.logLine("Launch application FtpException: " + string);
            throw new ApplicationFailedException(Tracker.res.getString("Could_Not_Invoke_Application"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            PrintException.print(classNotFoundException);
            throw new ApplicationFailedException(classNotFoundException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            PrintException.print(illegalAccessException);
            throw new ApplicationFailedException(Tracker.res.getString("Illegal_Access"));
        }
        catch (InstantiationException instantiationException) {
            PrintException.print(instantiationException);
            throw new ApplicationFailedException(Tracker.res.getString("Instantiation_Failed"));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            PrintException.print(noSuchMethodException);
            throw new ApplicationFailedException(Tracker.res.getString("Could_Not_Get_Constructor"));
        }
        catch (InvocationTargetException invocationTargetException) {
            PrintException.print(invocationTargetException);
            throw new ApplicationFailedException(Tracker.res.getString("Could_Not_Invoke_Application"));
        }
    }

    private void setSubAppStateForCompIT(TrackerApp trackerApp) {
        AppRec appRec = null;
        for (int i = 0; i < this.maintainApp.size(); ++i) {
            appRec = (AppRec)this.maintainApp.get(i);
            if (!appRec.appName.equals(this.subCompApp)) continue;
            if (null != trackerApp) {
                appRec.set(trackerApp);
                this.maintainApp.set(i, appRec);
                break;
            }
            appRec.clear();
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void setAppInfo() throws TrackerException {
        var1_1 = 0;
        var2_2 = 0;
        this.maintainApp = new LinkedList<E>();
        var3_3 = null;
        var4_4 = "";
        var5_5 = "";
        try {
            var1_1 = TrackerCypher.receiveFTPStart(this.ftpClient, "\\signatur\\capability.dat");
            if (150 != var1_1) {
                throw TrackerCypher.exceptionFromResponse(this.ftpClient, var1_1);
            }
        }
        catch (FtpException var6_6) {
            throw TrackerCypher.convertFtpExc(var6_6);
        }
        try {
            block13: while (true) {
                if (var4_4 == null) {
                    break;
                }
                var4_4 = this.ftpClient.receiveLine();
                if (var4_4.indexOf(91) == -1) continue;
                var2_2 = var4_4.indexOf(93);
                var5_5 = var4_4.substring(1, var2_2);
                if (var5_5.toUpperCase(Locale.ENGLISH).equals("APPS")) {
                    var6_7 = "";
                    var7_11 = "";
                    var8_12 = "";
                    var9_13 = "";
                    var10_15 = null;
                    var11_16 = 0;
                    var12_17 = null;
                    var4_4 = this.ftpClient.receiveLine();
                    while (true) {
                        if (var4_4 == null || var4_4.equals("") || var4_4.indexOf(91) != -1) continue block13;
                        var12_17 = new StringTokenizer(var4_4, ",");
                        var6_7 = var12_17.nextToken().trim();
                        var7_11 = var12_17.nextToken().trim();
                        var8_12 = var12_17.nextToken().trim();
                        var12_17 = new StringTokenizer((String)var8_12, " ");
                        var11_16 = var12_17.countTokens();
                        var13_18 = new Object[2];
                        var10_15 = new String[var11_16];
                        for (var14_19 = 0; var14_19 < var11_16; ++var14_19) {
                            var9_13 = var12_17.nextToken().trim();
                            var10_15[var14_19] = var9_13.substring(1, var9_13.indexOf(34, 1));
                        }
                        var13_18[0] = var10_15;
                        var3_3 = new AppRec(var6_7, var7_11, var13_18, false);
                        this.maintainApp.add(var3_3);
                        if ("CompIT".equalsIgnoreCase(var6_7)) {
                            var14_20 = new AppRec("Pointing", var7_11, var13_18, false);
                            this.maintainApp.add(var14_20);
                            var14_20 = new AppRec("AngularAccuracy", var7_11, var13_18, false);
                            this.maintainApp.add(var14_20);
                            var14_20 = new AppRec("QuickComp", var7_11, var13_18, false);
                            this.maintainApp.add(var14_20);
                            var14_20 = new AppRec("ADM", var7_11, var13_18, false);
                            this.maintainApp.add(var14_20);
                        }
                        var4_4 = this.ftpClient.receiveLine();
                    }
                }
                if (var5_5.toUpperCase(Locale.ENGLISH).equals("OPTIONAL HARDWARE")) {
                    var6_7 = "";
                    var7_11 = "";
                    var8_12 = null;
                    var9_14 = false;
                    var4_4 = this.ftpClient.receiveLine();
                    while (true) {
                        if (var4_4 == null || var4_4.equals("") || var4_4.indexOf(91) != -1) continue block13;
                        var8_12 = new StringTokenizer(var4_4, " ");
                        var6_7 = var8_12.nextToken().trim().toUpperCase(Locale.ENGLISH);
                        var8_12.nextToken();
                        var7_11 = var8_12.nextToken().trim();
                        if (var7_11.equals("0")) {
                            var9_14 = false;
                        } else if (var7_11.equals("1")) {
                            var9_14 = true;
                        }
                        var4_4 = this.ftpClient.receiveLine();
                    }
                }
                var4_4 = this.ftpClient.receiveLine();
                while (true) {
                    if (var4_4 != null && !var4_4.equals("") && var4_4.indexOf(91) == -1) ** break;
                    continue block13;
                    var4_4 = this.ftpClient.receiveLine();
                }
                break;
            }
        }
        catch (FtpException var6_9) {
            PrintException.print((Exception)var6_9);
        }
        finally {
            try {
                this.ftpClient.receiveEnd();
            }
            catch (FtpException var6_10) {}
        }
        this.loadLocalApp();
    }

    private void loadLocalApp() {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String[] stringArray = null;
        int n = 0;
        StringTokenizer stringTokenizer = null;
        AppRec appRec = null;
        AppRec appRec2 = null;
        boolean bl = false;
        String string7 = "/apps/Cypher/";
        this.fileDirectory = this.findClassPath();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.fileDirectory + string7 + "Apps.txt"));
            while ((string6 = bufferedReader.readLine()) != null) {
                int n2;
                stringTokenizer = new StringTokenizer(string6, ",");
                string = stringTokenizer.nextToken().trim();
                string2 = stringTokenizer.nextToken().trim();
                string3 = stringTokenizer.nextToken().trim();
                string4 = stringTokenizer.nextToken().trim();
                stringTokenizer = new StringTokenizer(string3, " ");
                n = stringTokenizer.countTokens();
                stringArray = new String[n];
                for (n2 = 0; n2 < n; ++n2) {
                    string5 = stringTokenizer.nextToken().trim();
                    stringArray[n2] = string7 + string5.substring(1, string5.indexOf(34, 1));
                }
                stringTokenizer = new StringTokenizer(string4, "=");
                string5 = stringTokenizer.nextToken().trim();
                bl = string5.toUpperCase(Locale.ENGLISH).equals("LOADFIRST") ? (string5 = stringTokenizer.nextToken().trim()).toUpperCase(Locale.ENGLISH).equals("TRUE") : false;
                for (n2 = 0; n2 < this.maintainApp.size(); ++n2) {
                    appRec2 = (AppRec)this.maintainApp.get(n2);
                    if (!string.equals(appRec2.appName)) continue;
                    appRec2.readFromLocal = bl;
                    appRec2.jarFileName[1] = stringArray;
                    break;
                }
                if (n2 != this.maintainApp.size()) continue;
                Object[] objectArray = new Object[2];
                objectArray[1] = stringArray;
                appRec = new AppRec(string, string2, objectArray, bl);
                this.maintainApp.add(appRec);
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String findClassPath() {
        String string = "";
        String string2 = "";
        String string3 = "";
        StringTokenizer stringTokenizer = null;
        StringTokenizer stringTokenizer2 = null;
        int n = 0;
        int n2 = 0;
        stringTokenizer = new StringTokenizer(System.getProperty("java.class.path"), ";");
        n = stringTokenizer.countTokens();
        for (int i = 0; i < n; ++i) {
            string = stringTokenizer.nextToken().trim();
            stringTokenizer2 = new StringTokenizer(string, "\\");
            n2 = stringTokenizer2.countTokens();
            string2 = "";
            string3 = "";
            if (string.startsWith("\\\\")) {
                string3 = string3 + "//";
            }
            for (int j = 0; j < n2; ++j) {
                string2 = stringTokenizer2.nextToken().trim();
                if (string2.toUpperCase(Locale.ENGLISH).equals("TRACKER.JAR")) {
                    return string3.substring(0, string3.length() - 1);
                }
                string3 = string3 + string2 + "/";
            }
        }
        return null;
    }

    private void clearAppInfo() throws TrackerException {
        if (this.maintainApp.size() == 0) {
            return;
        }
        for (int i = 0; i < this.maintainApp.size(); ++i) {
            AppRec appRec = (AppRec)this.maintainApp.get(i);
            if (!appRec.isSet()) continue;
            throw new InterfaceBusyException(Tracker.res.getString("Application_Running"));
        }
        this.maintainApp.clear();
    }

    private AppRec findAppInfo(String string) throws TrackerException {
        AppRec appRec = null;
        AppRec appRec2 = null;
        for (int i = 0; i < this.maintainApp.size(); ++i) {
            appRec = (AppRec)this.maintainApp.get(i);
            if (!string.equals(appRec.appName)) continue;
            for (int j = i + 1; j < this.maintainApp.size(); ++j) {
                appRec2 = (AppRec)this.maintainApp.get(j);
                if (!string.equals(appRec2.appName)) continue;
                if (appRec2.readFromLocal) {
                    appRec.readFromLocal = appRec2.readFromLocal;
                }
                return appRec;
            }
            return appRec;
        }
        throw new ApplicationFailedException(Tracker.res.getString("Unknown_Application_Name"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyApplication(String string, String string2) throws TrackerException {
        TrackerCypher trackerCypher = this;
        synchronized (trackerCypher) {
            AppRec appRec = this.findAppInfo(string);
            if (appRec.isSet()) {
                appRec.app.modifyParameters(string2);
            }
        }
    }

    @Override
    public TrackerApp stopApplication(String string) throws TrackerException {
        TrackerApp trackerApp = this.stopApplication(string, true);
        return trackerApp;
    }

    private void localStopApplication(AppRec appRec) {
        appRec.app.stop();
        appRec.clear();
        this.setSubAppStateForCompIT(null);
    }

    @Override
    public String[] startedApplications() throws TrackerException {
        AppRec appRec;
        int n;
        int n2 = 0;
        if (this.maintainApp.size() == 0) {
            return null;
        }
        for (n = 0; n < this.maintainApp.size(); ++n) {
            appRec = (AppRec)this.maintainApp.get(n);
            if (!appRec.isSet()) continue;
            ++n2;
        }
        if (n2 == 0) {
            return null;
        }
        String[] stringArray = new String[n2];
        int n3 = 0;
        for (n = 0; n < this.maintainApp.size(); ++n) {
            appRec = (AppRec)this.maintainApp.get(n);
            if (!appRec.isSet()) continue;
            stringArray[n3] = appRec.appName;
            ++n3;
        }
        return stringArray;
    }

    @Override
    public synchronized String[] availableApplications() throws TrackerException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.maintainApp.size(); ++i) {
            AppRec appRec = (AppRec)this.maintainApp.get(i);
            if (appRec.appName.equals("QuickComp") || appRec.appName.equals("AngularAccuracy") || appRec.appName.equals("Pointing") || appRec.appName.equals("ADM")) continue;
            arrayList.add(appRec.appName);
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        arrayList = null;
        return stringArray;
    }

    @Override
    public void writeFile(String string, String string2) throws TrackerException {
        int n;
        TrackerException trackerException = null;
        this.readyForCommand();
        for (n = 0; n < 3; ++n) {
            int n2;
            FileInputStream fileInputStream;
            trackerException = null;
            try {
                fileInputStream = new FileInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new FileAccessException(fileNotFoundException.toString());
            }
            catch (SecurityException securityException) {
                throw new FileAccessException(securityException.toString());
            }
            try {
                TrackerCypher.logLine("in writeFile sendFTPStart : " + new Date().toString());
                n2 = TrackerCypher.sendFTPStart(this.ftpClient, string2);
                TrackerCypher.logLine("out writeFile sendFTPStart : " + n2 + ":" + new Date().toString());
                if (n2 != 150) {
                    TrackerCypher.logLine("writeFile sendFTPStart exceptionFromResponse: " + n2 + ":" + new Date().toString());
                    throw TrackerCypher.exceptionFromResponse(this.ftpClient, n2);
                }
            }
            catch (FtpException ftpException) {
                throw TrackerCypher.convertFtpExc(ftpException);
            }
            try {
                int n3;
                byte[] byArray;
                TrackerCypher.logLine("in writeFile send : " + new Date().toString());
                int n4 = fileInputStream.available();
                int n5 = n4 / 1200;
                if (n5 > 0) {
                    byArray = new byte[1200];
                    for (int i = 0; i < n5; ++i) {
                        fileInputStream.read(byArray);
                        this.ftpClient.sendBuffer(byArray);
                    }
                }
                if ((n3 = n4 % 1200) > 0) {
                    byArray = new byte[n3];
                    fileInputStream.read(byArray);
                    this.ftpClient.sendBuffer(byArray);
                }
                TrackerCypher.logLine("out writeFile send : " + new Date().toString());
            }
            catch (FtpException ftpException) {
                try {
                    TrackerCypher.logLine("in writeFile sendAbort 1 : " + new Date().toString());
                    this.ftpClient.sendAbort();
                    TrackerCypher.logLine("out writeFile sendAbort 1: " + new Date().toString());
                }
                catch (FtpException ftpException2) {
                    // empty catch block
                }
                throw TrackerCypher.convertFtpExc(ftpException);
            }
            catch (IOException iOException) {
                try {
                    TrackerCypher.logLine("in writeFile sendAbort 2: " + new Date().toString());
                    this.ftpClient.sendAbort();
                    TrackerCypher.logLine("out writeFile sendAbort 2: " + new Date().toString());
                }
                catch (FtpException ftpException) {
                    // empty catch block
                }
                throw new FileAccessException(iOException.toString());
            }
            finally {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
            try {
                TrackerCypher.logLine("in writeFile sendEnd : " + new Date().toString());
                n2 = this.ftpClient.sendEnd();
                TrackerCypher.logLine("out writeFile sendEnd : " + n2 + ":" + new Date().toString());
                if (n2 != 226) {
                    TrackerCypher.logLine("writeFile sendEnd exceptionFromResponse: " + n2 + ":" + new Date().toString());
                    trackerException = TrackerCypher.exceptionFromResponse(this.ftpClient, n2);
                }
            }
            catch (FtpException ftpException) {
                trackerException = TrackerCypher.convertFtpExc(ftpException);
            }
            if (trackerException == null) break;
        }
        if (n == 3 && null != trackerException) {
            TrackerCypher.logLine("writeFile max tries throwex : " + new Date().toString());
            throw trackerException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFile(String string, String string2) throws TrackerException {
        int n;
        TrackerException trackerException = null;
        this.readyForCommand();
        byte[] byArray = new byte[1200];
        for (n = 0; n < 3; ++n) {
            int n2;
            FileOutputStream fileOutputStream;
            trackerException = null;
            try {
                fileOutputStream = new FileOutputStream(string, false);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new FileAccessException(fileNotFoundException.toString());
            }
            catch (SecurityException securityException) {
                throw new FileAccessException(securityException.toString());
            }
            try {
                int n3;
                TrackerCypher.logLine("in readFile receiveFTPStart : " + new Date().toString());
                n2 = TrackerCypher.receiveFTPStart(this.ftpClient, string2);
                TrackerCypher.logLine("out readFile receiveFTPStart : " + n2 + ":" + new Date().toString());
                if (150 != n2) {
                    TrackerCypher.logLine(" readFile exceptionFromResponse : " + new Date().toString());
                    throw TrackerCypher.exceptionFromResponse(this.ftpClient, n2);
                }
                TrackerCypher.logLine("in readFile receiveBuffer : " + new Date().toString());
                do {
                    if ((n3 = this.ftpClient.receiveBuffer(byArray)) <= 0) continue;
                    fileOutputStream.write(byArray, 0, n3);
                } while (n3 > 0);
                TrackerCypher.logLine("out readFile receiveBuffer : " + new Date().toString());
            }
            catch (FtpIOException ftpIOException) {
                trackerException = TrackerCypher.convertFtpExc((FtpException)((Object)ftpIOException));
            }
            catch (FtpException ftpException) {
                trackerException = TrackerCypher.convertFtpExc(ftpException);
            }
            catch (IOException iOException) {
                trackerException = new FileAccessException(iOException.toString());
            }
            finally {
                block38: {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                    try {
                        TrackerCypher.logLine("in readFile receiveEnd : " + new Date().toString());
                        n2 = this.ftpClient.receiveEnd();
                        TrackerCypher.logLine("out readFile receiveEnd : " + n2 + ":" + new Date().toString());
                        if (226 != n2) {
                            TrackerCypher.logLine("readFile exceptionFromResponse : " + new Date().toString());
                            trackerException = TrackerCypher.exceptionFromResponse(this.ftpClient, n2);
                        }
                    }
                    catch (FtpException ftpException) {
                        if (null != trackerException) break block38;
                        trackerException = TrackerCypher.convertFtpExc(ftpException);
                    }
                }
            }
            if (trackerException == null) break;
        }
        if (n == 3 && null != trackerException) {
            TrackerCypher.logLine("readFile max tries throw ex : " + new Date().toString());
            throw trackerException;
        }
    }

    @Override
    public void changeAlarmCfg(int n, AlarmType alarmType) throws TrackerException {
        String string = "";
        String string2 = "";
        if (alarmType != null && alarmType instanceof DeviationAlarm) {
            throw new UnsupportedFeatureException(Tracker.res.getString("DeviationAlarm_Not_Supported"));
        }
        if (n < 1 || n > 24) {
            Tracker.formmater.applyPattern(Tracker.res.getString("Unknown_Alarm_Index_Number"));
            throw new UnsupportedFeatureException(Tracker.formmater.format(new Object[]{n}));
        }
        if (n >= 21 && n <= 24) {
            Tracker.formmater.applyPattern(Tracker.res.getString("Internal_Alarm_Index_Number"));
            throw new UnsupportedFeatureException(Tracker.formmater.format(new Object[]{n}));
        }
        if (alarmType instanceof DeviationAlarm) {
            throw new UnsupportedFeatureException(Tracker.res.getString("Alarm_Not_Supported"));
        }
        string = "configure_alarm " + n;
        if (n == 1 || n == 2) {
            int n2 = n == 1 ? 1 : 2;
            boolean bl = this.batteryPresent(n2);
            if (!bl) {
                throw new InternalDeviceFailureException(Tracker.res.getString("Battery_Not_Present"));
            }
            string2 = "system.power.battery" + n2 + ".percent_remaining.value";
            string = string + this.getAlarmSetPoint(alarmType, string2, true);
        } else if (n == 3) {
            DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned16("weather.device.temperature.ext1.reading.status")};
            Object[] objectArray = this.readOneTimeData(dataTagArray);
            if ((Integer)objectArray[0] != 0) {
                throw new InternalDeviceFailureException(Tracker.res.getString("Sensor_Not_Present"));
            }
            string2 = "weather.device.temperature.ext1.reading.value";
            string = string + this.getAlarmSetPoint(alarmType, string2, false);
        } else if (n == 4) {
            this.checkIfSixDofCapable();
            this.checkIfProbeAdapterConnected();
            string2 = "sixdof.probe_adapter.battery.percent_remaining.value";
            string = string + this.getAlarmSetPoint(alarmType, string2, true);
            string = string + " 5";
        }
        this.executeTrackerCommand(string, 18000);
    }

    private String getAlarmSetPoint(AlarmType alarmType, String string, boolean bl) {
        double d;
        String string2 = "";
        if (alarmType instanceof LowAlarm) {
            d = ((LowAlarm)alarmType).getSetPoint();
            if (bl) {
                d = (int)d;
            }
            string2 = " enable " + string + " low " + d;
        }
        if (alarmType instanceof HighAlarm) {
            d = ((HighAlarm)alarmType).getSetPoint();
            if (bl) {
                d = (int)d;
            }
            string2 = " enable " + string + " high " + d;
        } else if (alarmType instanceof NullAlarm) {
            string2 = " disable";
        }
        return string2;
    }

    private void fillAlarmData(AlarmType alarmType, Object[] objectArray) throws TrackerException {
        if (alarmType instanceof DeviationAlarm) {
            objectArray[0] = new Long(1L);
            objectArray[1] = new Double(((DeviationAlarm)alarmType).getSetPoint());
            objectArray[2] = new Double(((DeviationAlarm)alarmType).getDeviation());
            return;
        }
        if (alarmType instanceof NullAlarm) {
            objectArray[0] = new Long(0L);
            objectArray[1] = new Double(20.0);
            objectArray[2] = new Double(5.0);
            return;
        }
        if (alarmType instanceof HighAlarm) {
            objectArray[0] = new Long(2L);
            objectArray[1] = new Double(((HighAlarm)alarmType).getSetPoint());
            objectArray[2] = new Double(5.0);
            return;
        }
        if (alarmType instanceof LowAlarm) {
            objectArray[0] = new Long(3L);
            objectArray[1] = new Double(((LowAlarm)alarmType).getSetPoint());
            objectArray[2] = new Double(5.0);
            return;
        }
        throw new UnsupportedFeatureException(Tracker.res.getString("Unknown_Alarm_Type"));
    }

    @Override
    public AlarmType alarmCfg(int n) throws TrackerException {
        if (n < 1 || n > 24) {
            Tracker.formmater.applyPattern(Tracker.res.getString("Unknown_Alarm_Number"));
            throw new UnsupportedFeatureException(Tracker.formmater.format(new Object[]{n}));
        }
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("alarm.config." + n + ".enabled"), new DataTagUnsigned32("alarm.config." + n + ".dbindex"), new DataTagUnsigned32("alarm.config." + n + ".type"), new DataTagDouble("alarm.config." + n + ".setpoint")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        long l = (Long)objectArray[2];
        if (l == 1L) {
            return new HighAlarm(((Double)objectArray[3]).intValue());
        }
        if (l == 2L) {
            return new LowAlarm(((Double)objectArray[3]).intValue());
        }
        return new NullAlarm();
    }

    private AlarmType getAlarmType(int n, Object[] objectArray) throws TrackerException {
        long l = (Long)objectArray[0];
        if (l == 0L) {
            return new NullAlarm();
        }
        if (l == 2L) {
            return new HighAlarm((Double)objectArray[1]);
        }
        if (l == 3L) {
            return new LowAlarm((Double)objectArray[1]);
        }
        if (l == 1L) {
            return new DeviationAlarm((Double)objectArray[1], (Double)objectArray[2]);
        }
        return new NullAlarm();
    }

    @Override
    public ExtTempType externalTempType(int n) throws TrackerException {
        DataTag[] dataTagArray = new DataTag[1];
        if (n < 1 || n > this.NUM_EXT_TEMP_SENSORS) {
            throw new UnsupportedFeatureException(Tracker.res.getString("Unknown_Sensor_Number"));
        }
        String string = "weather.device.temperature.ext" + n + ".type";
        dataTagArray[0] = new DataTagUnsigned32(string);
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        ExtTempType extTempType = (Long)objectArray[0] == 1L ? new AirExtTemp() : ((Long)objectArray[0] == 2L ? new MaterialExtTemp() : new NullExtTemp());
        return extTempType;
    }

    @Override
    public void changeExternalTempType(int n, ExtTempType extTempType) throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Cannot_Change_External_Temp_Type"));
    }

    @Override
    public boolean externalTempTypeChangeable() throws TrackerException {
        return false;
    }

    @Override
    public int numExternalTempSensors() throws TrackerException {
        return this.NUM_EXT_TEMP_SENSORS;
    }

    @Override
    public double measureExternalTempSensor(int n) throws TrackerException {
        DataTag[] dataTagArray = new DataTag[2];
        if (n < 1 || n > this.NUM_EXT_TEMP_SENSORS) {
            throw new UnsupportedFeatureException(Tracker.res.getString("Unknown_Sensor_Number"));
        }
        dataTagArray[0] = new DataTagDouble("weather.device.temperature.ext" + n + ".reading.value");
        dataTagArray[1] = new DataTagUnsigned16("weather.device.temperature.ext" + n + ".reading.status");
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        int n2 = (Integer)objectArray[1];
        if ((n2 & 1) != 0) {
            throw new UnsupportedFeatureException(Tracker.res.getString("Sensor_Error"));
        }
        if ((n2 & 2) != 0) {
            throw new UnsupportedFeatureException(Tracker.res.getString("Sensor_Inaccurate"));
        }
        return (Double)objectArray[0];
    }

    @Override
    public boolean standardPrivilege() throws TrackerException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        return this.accessLevel >= 0;
    }

    @Override
    public boolean adminPrivilege() throws TrackerException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        return this.accessLevel >= 1;
    }

    @Override
    public boolean factoryPrivilege() throws TrackerException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        return this.accessLevel >= 2;
    }

    @Override
    public void readFileAbort() {
        try {
            this.ftpClient.sendAbort();
        }
        catch (FtpException ftpException) {
            // empty catch block
        }
    }

    @Override
    public void writeFileAbort() {
        try {
            this.ftpClient.sendAbort();
        }
        catch (FtpException ftpException) {
            // empty catch block
        }
    }

    @Override
    public boolean admScanCapable() throws TrackerException {
        return true;
    }

    @Override
    public TargetType[] availableTargetType() throws TrackerException {
        TargetType[] targetTypeArray = null;
        int n = 8;
        if (this.isCatEyeTargetCapable) {
            ++n;
        }
        int n2 = 0;
        targetTypeArray = new TargetType[n];
        targetTypeArray[n2++] = new SMRTargetType(0.0381);
        targetTypeArray[n2++] = new MirrorTargetType();
        targetTypeArray[n2++] = new SMRTargetType(0.0127);
        targetTypeArray[n2++] = new SMRTargetType(0.022225);
        targetTypeArray[n2++] = new SMRTargetType(0.0);
        targetTypeArray[n2++] = new WindowedSMRTargetType(0.0381);
        targetTypeArray[n2++] = new WindowedSMRTargetType(0.022225);
        targetTypeArray[n2++] = new SixDofTargetType();
        if (this.isCatEyeTargetCapable) {
            double[] dArray = this.getCatEyeTargetOffset();
            targetTypeArray[n2++] = new CatEyeTargetType(dArray[0], dArray[1]);
        }
        return targetTypeArray;
    }

    @Override
    public WeatherInformation getWeatherInfo() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[9];
        int n = 0;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        dataTagArray[0] = new DataTagDouble("weather.current.air_temperature.value");
        dataTagArray[1] = new DataTagUnsigned16("weather.current.air_temperature.status");
        dataTagArray[2] = new DataTagDouble("weather.current.air_pressure.value");
        dataTagArray[3] = new DataTagUnsigned16("weather.current.air_pressure.status");
        dataTagArray[4] = new DataTagDouble("weather.current.humidity.value");
        dataTagArray[5] = new DataTagUnsigned16("weather.current.humidity.status");
        dataTagArray[6] = new DataTagUnsigned32("weather.config.air_temperature.source");
        dataTagArray[7] = new DataTagUnsigned32("weather.config.air_pressure.source");
        dataTagArray[8] = new DataTagUnsigned32("weather.config.humidity.source");
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        double d = (Double)objectArray[0];
        double d2 = (Double)objectArray[2];
        double d3 = (Double)objectArray[4];
        l = (Long)objectArray[6];
        l2 = (Long)objectArray[7];
        l3 = (Long)objectArray[8];
        n = (Integer)objectArray[1] | (Integer)objectArray[3] | (Integer)objectArray[5];
        if (0 == (n & 0xFFFFFFBF)) {
            return new WeatherInformation(d, d2, d3, l, l2, l3);
        }
        if ((n & 1) != 0) {
            throw new InternalDeviceFailureException(Tracker.res.getString("Sensor_Error"));
        }
        if ((n & 0x80) != 0) {
            throw new InternalDeviceFailureException(Tracker.res.getString("Sensor_Disabled"));
        }
        if ((n & 2) != 0) {
            throw new InternalDeviceFailureException(Tracker.res.getString("Sensor_Inaccurate"));
        }
        throw new InternalDeviceFailureException(Tracker.res.getString("Sensor_Unknown_Error"));
    }

    @Override
    public String getSerialNumber() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[4];
        String string = "";
        dataTagArray[0] = new DataTagUnsigned32("system.serial_num.value");
        dataTagArray[1] = new DataTagUnsigned32("system.serial_type.value");
        dataTagArray[2] = new DataTagUnsigned16("system.serial_num.status");
        dataTagArray[3] = new DataTagUnsigned16("system.serial_type.status");
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        long l = (Long)objectArray[0];
        long l2 = (Long)objectArray[1];
        int n = (Integer)objectArray[2];
        int n2 = (Integer)objectArray[3];
        if (0 == n && 0 == n2 && 0L != (2L & l2)) {
            String string2 = string = this.sixDofCapableTrk ? "V30" : "V20";
        }
        if (string == "") {
            return this.sixDofCapableTrk ? new String("VantageS6") : new String("VantageS");
        }
        string = string + "00";
        String string3 = "" + l;
        int n3 = 7 - string3.length();
        for (int i = 0; i < n3; ++i) {
            string = string + "0";
        }
        string = string + l;
        return string;
    }

    @Override
    public String getIPAddress() throws TrackerException {
        return this.ipAddressToUse;
    }

    @Override
    public boolean readyToInitialize(boolean bl) throws TrackerException {
        DataTag[] dataTagArray = new DataTag[1];
        if (!bl) {
            dataTagArray[0] = new DataTagUnsigned32("system.smart_warmup.state");
            try {
                Object[] objectArray = this.readOneTimeData(dataTagArray);
                long l = (Long)objectArray[0];
                if (l == 1L) {
                    return false;
                }
            }
            catch (TrackerException trackerException) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    public synchronized void factoryConnect(String string, String string2, String string3) throws TrackerException {
        boolean bl;
        boolean bl2 = bl = this.accessLevel >= 2;
        if (this.localFactoryAccess) {
            bl = true;
        }
        if (!bl) {
            throw new PermissionException(Tracker.res.getString("Connect_As_Factory_To_Use_The_Method"));
        }
        if (this.isConnected()) {
            throw new TrackerException(Tracker.res.getString("Disconnect_As_Factory_To_Use_The_Method"));
        }
        if (!this.factoryDisconnect) {
            throw new TrackerException(Tracker.res.getString("Connect_Disconnect_With_Right_Methods"));
        }
        try {
            this.connectFtp(string, string2, string3);
        }
        catch (FtpException ftpException) {
            if (ftpException instanceof FtpOutOfPortsException) {
                throw new ConnectFailedException(Tracker.res.getString("Out_Of_Ports"));
            }
            throw new ConnectFailedException(ftpException.toString());
        }
    }

    @Override
    public void factoryDisconnect() throws TrackerException {
        boolean bl;
        boolean bl2 = bl = this.accessLevel >= 2;
        if (this.localFactoryAccess) {
            bl = true;
        }
        if (!bl) {
            throw new PermissionException(Tracker.res.getString("Connect_As_Factory_To_Use_The_Method"));
        }
        if (!this.isConnected()) {
            throw new TrackerException(Tracker.res.getString("Connect_As_Factory_To_Call_FactoryDisconnect_Method"));
        }
        this.disconnectFtp();
    }

    @Override
    public TrackerApp stopApplication(String string, boolean bl) throws TrackerException {
        if (bl && !this.isConnected()) {
            throw new NotConnectedException();
        }
        AppRec appRec = this.findAppInfo(string);
        if (!appRec.isSet()) {
            return null;
        }
        TrackerApp trackerApp = appRec.app;
        this.localStopApplication(appRec);
        return trackerApp;
    }

    @Override
    public int applicationExitCode(String string) throws TrackerException {
        AppRec appRec = this.findAppInfo(string);
        if (appRec.app != null) {
            return appRec.app.applicationExitCode();
        }
        return appRec.appExitCode;
    }

    @Override
    public void releaseLock() throws TrackerException {
        this.trackerCommand("release_lock", 10000);
    }

    @Override
    public void startSlew(double d, double d2, double d3) throws TrackerException {
        double d4 = 2.0;
        int n = 10000;
        if (Math.abs(d) > d4 || Math.abs(d2) > d4) {
            throw new TrackerException(Tracker.res.getString("Invalid_Velocity_Value"));
        }
        if (d3 < 0.0) {
            throw new TrackerException(Tracker.res.getString("Invalid_Min_Value_Slew"));
        }
        if (d3 > 0.0) {
            this.trackerCommand("slew " + d + " " + d2 + " " + d3, n);
        } else {
            this.trackerCommand("slew " + d + " " + d2, n);
        }
    }

    @Override
    public void startSlew(double d, double d2) throws TrackerException {
        this.startSlew(d, d2, 0.0);
    }

    @Override
    public void stopSlew() throws TrackerException {
        this.startSlew(0.0, 0.0);
    }

    @Override
    public boolean isResultReportingCapable() throws TrackerException {
        return true;
    }

    @Override
    public boolean isAdaptiveFilterCapable() throws TrackerException {
        return true;
    }

    @Override
    public ApplicationResults applicationResults(String string) throws TrackerException {
        String[] stringArray;
        DataTag[] dataTagArray = new DataTag[2];
        ApplicationResults applicationResults = null;
        AppRec appRec = this.findAppInfo(string);
        if (string.equalsIgnoreCase("Pointing")) {
            dataTagArray[0] = new DataTagUnsigned32("system.aim_it.result.value");
            dataTagArray[1] = new DataTagUnsigned32("system.aim_it.time.value");
        } else if (string.equalsIgnoreCase("AngularAccuracy")) {
            dataTagArray[0] = new DataTagUnsigned32("system.aa_check.result.value");
            dataTagArray[1] = new DataTagUnsigned32("system.aa_check.time.value");
        } else if (string.equalsIgnoreCase("ADM")) {
            dataTagArray[0] = new DataTagUnsigned32("system.adm_check.result.value");
            dataTagArray[1] = new DataTagUnsigned32("system.adm_check.time.value");
        } else if (string.equalsIgnoreCase("QuickComp")) {
            dataTagArray[0] = new DataTagUnsigned32("system.quick_comp.result.value");
            dataTagArray[1] = new DataTagUnsigned32("system.quick_comp.time.value");
        } else {
            if (string.equalsIgnoreCase("HealthChecks") || string.equalsIgnoreCase("StartupChecks") || string.equalsIgnoreCase("FirmwareLoader")) {
                int n = appRec.appExitCode;
                if (appRec.app != null) {
                    n = appRec.app.applicationExitCode();
                }
                if (n == 0 || n == 1) {
                    if (appRec.app != null) {
                        return appRec.app.applicationResults();
                    }
                    return appRec.appResults;
                }
                return new ApplicationResults("Unknown result", 0L);
            }
            throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
        }
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        long l = (Long)objectArray[0];
        long l2 = (Long)objectArray[1];
        String string2 = "";
        boolean bl = false;
        String string3 = null;
        if (null != appRec && null != appRec.appResults) {
            string2 = appRec.appResults.getResult();
        }
        if (2 == (stringArray = string2.split(string + "-")).length) {
            String[] stringArray2;
            string2 = stringArray[1].trim();
            int n = string2.indexOf(64);
            if (-1 != n && 2 == (stringArray2 = string2.split("@")).length) {
                string2 = stringArray2[1].trim();
                try {
                    String[] stringArray3 = stringArray2[0].trim().split(":");
                    if (2 == stringArray3.length) {
                        string2 = stringArray3[0] + ":" + string2;
                        int n2 = Integer.parseInt(stringArray3[0].trim());
                        bl = 1 == n2;
                        string3 = stringArray2[0].trim();
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else {
            string2 = "";
        }
        switch ((int)l) {
            case 0: {
                applicationResults = new ApplicationResults("Pass", string2, l2);
                break;
            }
            case 1: {
                applicationResults = new ApplicationResults("Fail", string2, l2);
                break;
            }
            case 2: {
                applicationResults = new ApplicationResults("Recommendation", string2, l2);
                break;
            }
            default: {
                applicationResults = new ApplicationResults("Unknown", l2);
            }
        }
        applicationResults.setRawMeasurements(string3);
        return applicationResults;
    }

    @Override
    public boolean is_1_5_WindowedSMRTargetCapable() throws TrackerException {
        return true;
    }

    @Override
    public boolean is_7_8_WindowedSMRTargetCapable() throws TrackerException {
        return true;
    }

    private MPEResultsData getADMError(double d, double d2) throws TrackerException {
        double d3 = Math.abs(d - d2);
        double d4 = this.calculateADMMPE(d);
        return new MPEResultsData(d3, d4, d3 / d4, d3 <= d4);
    }

    private MPEResultsData getAACError(double[] dArray, double[] dArray2) throws TrackerException {
        double[] dArray3 = new double[]{dArray[0] - dArray2[0], dArray[1] - dArray2[1], dArray[2] - dArray2[2]};
        double d = this.distanceInSpace(dArray3);
        double d2 = this.distanceInSpace(dArray);
        double d3 = this.calculateTransverseMPE(d2);
        return new MPEResultsData(d, d3, d / d3, d <= d3);
    }

    @Override
    public MPEResultsData checkADMAgainstIFM(SimplePointPairData simplePointPairData) throws TrackerException {
        double[] dArray = simplePointPairData.getSecondPoint();
        double[] dArray2 = simplePointPairData.getFirstPoint();
        return this.getADMError(dArray2[2], dArray[2]);
    }

    private void pointSphereToCart(double[] dArray) {
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = Math.sin(dArray[1]);
        dArray[0] = d3 * Math.cos(d) * d4;
        dArray[1] = d3 * Math.sin(d) * d4;
        dArray[2] = d3 * Math.cos(d2);
    }

    private double distanceInSpace(double[] dArray) {
        return Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
    }

    @Override
    public MPEResultsData checkAngularAccuracyError(SimplePointPairData simplePointPairData) throws TrackerException {
        double[] dArray = simplePointPairData.getSecondPoint();
        double[] dArray2 = simplePointPairData.getFirstPoint();
        this.pointSphereToCart(dArray);
        this.pointSphereToCart(dArray2);
        return this.getAACError(dArray2, dArray);
    }

    @Override
    public boolean isSelfCompensationNoUICapable() throws TrackerException {
        String string = "CompIT";
        AppRec appRec = this.findAppInfo(string);
        Class<?> clazz = null;
        try {
            this.jarClassLoader.setAppName(string);
            clazz = this.jarClassLoader.loadClass(appRec.fullQualifiedName);
            return this.isSelfCompNoUISupported(clazz);
        }
        catch (FtpException ftpException) {
        }
        catch (TrackerException trackerException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    private boolean isSelfCompNoUISupported(Class clazz) {
        try {
            Class clazz2 = clazz.getSuperclass();
            Method method = clazz2.getMethod("isSelfCompNoUICapable", null);
            return true;
        }
        catch (Exception exception) {
            PrintException.print(exception);
        }
        catch (Error error) {
            PrintException.print(error);
        }
        return false;
    }

    @Override
    public void changeAirTemperatureToHardware() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("weather.config.air_temperature.source")};
        Object[] objectArray = new Object[]{new Long(1L)};
        this.writeOneTimeData(dataTagArray, objectArray);
    }

    @Override
    public void changeAirPressureToHardware() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("weather.config.air_pressure.source")};
        Object[] objectArray = new Object[]{new Long(1L)};
        this.writeOneTimeData(dataTagArray, objectArray);
    }

    @Override
    public void changeHumidityToHardware() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("weather.config.humidity.source")};
        Object[] objectArray = new Object[]{new Long(1L)};
        this.writeOneTimeData(dataTagArray, objectArray);
    }

    @Override
    public void changeAirTemperatureToManual(double d) throws TrackerException {
        DataTag[] dataTagArray = new DataTag[2];
        if (d > 60.0 || d < -20.0) {
            throw new TrackerException(Tracker.res.getString("Air_Temperature_Value_Out_Of_Bounds"));
        }
        dataTagArray[0] = new DataTagUnsigned32("weather.config.air_temperature.source");
        dataTagArray[1] = new DataTagDouble("weather.config.air_temperature.manual");
        Object[] objectArray = new Object[]{new Long(2L), new Double(d)};
        this.writeOneTimeData(dataTagArray, objectArray);
    }

    @Override
    public void changeAirPressureToManual(double d) throws TrackerException {
        DataTag[] dataTagArray = new DataTag[2];
        if (d > 900.0 || d < 225.0) {
            throw new TrackerException(Tracker.res.getString("Air_Pressure_Value_Out_Of_Bounds"));
        }
        dataTagArray[0] = new DataTagUnsigned32("weather.config.air_pressure.source");
        dataTagArray[1] = new DataTagDouble("weather.config.air_pressure.manual");
        Object[] objectArray = new Object[]{new Long(2L), new Double(d)};
        this.writeOneTimeData(dataTagArray, objectArray);
    }

    @Override
    public void changeHumidityToManual(double d) throws TrackerException {
        DataTag[] dataTagArray = new DataTag[2];
        if (d > 100.0 || d < 0.0) {
            throw new TrackerException(Tracker.res.getString("Humidity_Value_Out_Of_Bounds"));
        }
        dataTagArray[0] = new DataTagUnsigned32("weather.config.humidity.source");
        dataTagArray[1] = new DataTagDouble("weather.config.humidity.manual");
        Object[] objectArray = new Object[]{new Long(2L), new Double(d / 100.0)};
        this.writeOneTimeData(dataTagArray, objectArray);
    }

    @Override
    public void changeLedState(int n, int n2) throws TrackerException {
        String string = "triad";
        String string2 = "";
        switch (n) {
            case 1: {
                string2 = "blue";
                break;
            }
            case 0: {
                string2 = "yellow";
                break;
            }
            case 2: {
                string2 = "blue yellow";
            }
        }
        String string3 = "";
        switch (n2) {
            case 1: {
                string3 = "1";
                break;
            }
            case 0: {
                string3 = "0";
                break;
            }
            case 2: {
                string3 = "2";
                break;
            }
            case 3: {
                string3 = "5";
                break;
            }
            case 4: {
                string3 = "15";
            }
        }
        this.trackerCommand("led " + string + " " + string2 + " " + string3, 180000);
    }

    private void checkIfConnectingToTrackerTypeSpecified() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagDouble("case_temperature.16.reading.value")};
        try {
            this.readOneTimeData(dataTagArray);
        }
        catch (TrackerException trackerException) {
            if (trackerException instanceof CustomPortsException) {
                throw new ConnectFailedException(Tracker.res.getString("Out_Of_Ports"));
            }
            throw new ConnectFailedException(Tracker.res.getString("Tracker_Type_And_Tracker_Connected_Not_Same"));
        }
    }

    @Override
    public void startVideo(VideoCfg videoCfg) throws TrackerException {
        this.localStartVideo(videoCfg, true);
    }

    private synchronized void localStartVideo(VideoCfg videoCfg, boolean bl) throws TrackerException {
        this.readyForCommand();
        int n = this.beginVideoTransfer(this.ftpClient);
        if (n != 222) {
            throw TrackerCypher.exceptionFromResponse(this.ftpClient, n);
        }
        this.generalVideoFlag = bl;
        this.videoInProgress = true;
    }

    private void readyForVideoCommand() throws InterfaceBusyException, NotConnectedException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        if (this.cmdInProgress) {
            throw new InterfaceBusyException(Tracker.res.getString("Command_In_Progress"));
        }
        if (this.videoInProgress) {
            throw new InterfaceBusyException(Tracker.res.getString("Video_In_Progress"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendVideoCfg(CypherFtp cypherFtp, VideoCfg videoCfg, String string) throws TrackerException {
        int n;
        TrackerException trackerException = null;
        for (n = 0; n < 3; ++n) {
            int n2;
            trackerException = null;
            try {
                n2 = TrackerCypher.sendFTPStart(cypherFtp, string);
                if (n2 != 150) {
                    throw TrackerCypher.exceptionFromResponse(cypherFtp, n2);
                }
            }
            catch (FtpException ftpException) {
                throw TrackerCypher.convertFtpExc(ftpException);
            }
            try {
                this.ftpClient.sendLine("frmrate=" + videoCfg.getFrameRate());
                this.ftpClient.sendLine("imgwdth=" + videoCfg.getImageWidth());
                this.ftpClient.sendLine("imght=" + videoCfg.getImageHeight());
                this.ftpClient.sendLine("camera=" + videoCfg.getCameraInUse());
            }
            catch (FtpException ftpException) {
                trackerException = TrackerCypher.convertFtpExc(ftpException);
            }
            finally {
                block18: {
                    try {
                        n2 = this.ftpClient.sendEnd(10000);
                        if (n2 != 226 && trackerException == null) {
                            trackerException = TrackerCypher.exceptionFromResponse(cypherFtp, n2);
                        }
                    }
                    catch (FtpException ftpException) {
                        if (trackerException != null) break block18;
                        trackerException = TrackerCypher.convertFtpExc(ftpException);
                    }
                }
            }
            if (trackerException == null) break;
        }
        if (n == 3 && trackerException != null) {
            throw trackerException;
        }
    }

    private int receiveVideoData2(CypherFtp cypherFtp) throws TrackerException {
        try {
            this.dgSocket = new DatagramSocket();
            this.dgSocket.setSoTimeout(5000);
            byte[] byArray = cypherFtp.getIPAddress().getAddress();
            int n = this.dgSocket.getLocalPort();
            int[] nArray = new int[4];
            for (int i = 0; i < 4; ++i) {
                nArray[i] = byArray[i];
                if (nArray[i] >= 0) continue;
                int n2 = i;
                nArray[n2] = nArray[n2] + 256;
            }
            int n3 = this.executeMeasureCommand(cypherFtp, "click_to_drive " + nArray[0] + "," + nArray[1] + "," + nArray[2] + "," + nArray[3] + "," + n / 256 + "," + n % 256, 10000);
            return n3;
        }
        catch (SocketException socketException) {
            if (this.dgSocket != null) {
                this.dgSocket.close();
            }
            throw new CommunicationException(Tracker.res.getString("Video_Data_Exception"));
        }
        catch (FtpException ftpException) {
            throw TrackerCypher.convertFtpExc(ftpException);
        }
    }

    private void checkAndSendVideoCFG(VideoCfg videoCfg, CypherFtp cypherFtp, String string) throws TrackerException {
        VideoCfg videoCfg2 = this.oldVideoCfg;
        if (!videoCfg2.equals(videoCfg)) {
            this.sendVideoCfg(cypherFtp, videoCfg, string);
        }
        this.oldVideoCfg = new VideoCfg(videoCfg.getFrameRate(), videoCfg.getImageWidth(), videoCfg.getImageHeight(), videoCfg.getCameraInUse());
    }

    @Override
    public synchronized void stopVideo() throws TrackerException {
        this.localStopVideo(true);
    }

    private void cleanupVideoSockets() throws TrackerException {
        try {
            this.videoSocket.close();
            this.trkVideoServerSocket.closeSocket();
            this.videoRawInput.close();
            this.videoInputStream.close();
            this.videoSocket = null;
            this.videoServerSocket = null;
            this.videoRawInput = null;
            this.videoInputStream = null;
        }
        catch (IOException iOException) {
            throw new TrackerException(Tracker.res.getString("Failed_To_Close_Video_Sockets"));
        }
    }

    private synchronized void localStopVideo(boolean bl) throws TrackerException {
        if (!this.isConnected()) {
            throw new NotConnectedException();
        }
        if (this.videoInProgress) {
            try {
                this.executeMeasureCommand(this.ftpClient, "target_data", 10000);
                this.videoInProgress = false;
                this.generalVideoFlag = false;
                this.cleanupVideoSockets();
            }
            catch (FtpException ftpException) {
                this.cleanupVideoSockets();
                throw TrackerCypher.convertFtpExc(ftpException);
            }
        }
    }

    private int beginVideoTransfer(CypherFtp cypherFtp) throws TrackerException {
        int n = 9;
        if (null != this.videoSocket || this.videoInProgress) {
            throw new InterfaceBusyException(Tracker.res.getString("Video_Transmission_In_Progress"));
        }
        try {
            int n2;
            this.videoServerSocket = this.trkVideoServerSocket.createSocket();
            byte[] byArray = cypherFtp.getIPAddress().getAddress();
            int[] nArray = new int[4];
            for (n2 = 0; n2 < 4; ++n2) {
                nArray[n2] = byArray[n2];
                if (nArray[n2] >= 0) continue;
                int n3 = n2;
                nArray[n3] = nArray[n3] + 256;
            }
            n2 = this.videoServerSocket.getLocalPort();
            n = this.executeMeasureCommand(cypherFtp, "target_data " + nArray[0] + "," + nArray[1] + "," + nArray[2] + "," + nArray[3] + "," + n2 / 256 + "," + n2 % 256, 10000);
            try {
                this.videoServerSocket.setSoTimeout(10000);
                this.videoSocket = this.videoServerSocket.accept();
                this.videoSocket.setReceiveBufferSize(65536);
            }
            catch (IOException iOException) {
                this.trkVideoServerSocket.closeSocket();
                throw new TrackerException(Tracker.res.getString("Target_Data_Problem"));
            }
        }
        catch (Exception exception) {
            PrintException.print(exception);
            this.trkVideoServerSocket.closeSocket();
            if (exception instanceof UtilityOutOfPortsException) {
                throw new CustomPortsException(Tracker.res.getString("Out_Of_Ports"));
            }
            throw new TrackerException(exception.getMessage());
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public VideoData[] readVideoData() throws TrackerException {
        VideoData videoData = null;
        if (!this.videoInProgress) {
            return null;
        }
        try {
            CharSequence charSequence;
            int n;
            byte[] byArray;
            int n2;
            Long l;
            Long l2;
            int n3;
            ByteBuffer byteBuffer;
            block14: {
                if (null == this.videoRawInput && null == this.videoInputStream) {
                    this.videoRawInput = this.videoSocket.getInputStream();
                    this.videoInputStream = new DataInputStream(this.videoRawInput);
                }
                int n4 = 0;
                int n5 = 0;
                while ((n5 = this.videoInputStream.available()) <= 0) {
                    ++n4;
                    try {
                        Thread.currentThread();
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (n4 < 100) continue;
                }
                if (n5 <= 0) {
                    throw new NoDataAvailableException();
                }
                byteBuffer = null;
                Object var5_8 = null;
                n3 = 0;
                l2 = null;
                l = null;
                n2 = 0;
                byArray = null;
                n3 = 0;
                n = -1;
                Runtime runtime = Runtime.getRuntime();
                long l3 = runtime.maxMemory();
                long l4 = runtime.totalMemory();
                long l5 = runtime.freeMemory();
                do {
                    Long l6 = new Long((long)this.videoInputStream.readInt() & 0xFFFFFFFFL);
                    charSequence = Long.toHexString(l6);
                    if (!((String)charSequence).equalsIgnoreCase("12345678")) continue;
                    n = VideoData.VIDEO_TYPE;
                    break block14;
                } while (!((String)charSequence).equalsIgnoreCase("12345679") && !((String)charSequence).equalsIgnoreCase("1234567A"));
                n = VideoData.TARGET_TYPE;
            }
            l = new Long((long)this.videoInputStream.readInt() & 0xFFFFFFFFL);
            if (VideoData.VIDEO_TYPE == n) {
                // empty if block
            }
            l2 = new Long((long)this.videoInputStream.readInt() & 0xFFFFFFFFL);
            int n6 = (int)l.longValue();
            byteBuffer = ByteBuffer.allocate(n6);
            n2 = n6 - n3;
            byArray = byteBuffer.array();
            do {
                n3 = n2 > 1200 ? (n3 += this.videoInputStream.read(byArray, n3, 1200)) : (n3 += this.videoInputStream.read(byArray, n3, n2));
                n2 = n6 - n3;
            } while ((long)n3 < l);
            charSequence = Charset.forName("ISO-8859-1").decode(byteBuffer);
            if (VideoData.TARGET_TYPE == n) {
                String string = new String(((CharBuffer)charSequence).array());
            }
            videoData = new VideoData(0.0, byArray, ((CharBuffer)charSequence).array(), n, l, l2);
            byteBuffer.clear();
            if (0 == n3 - (int)l.longValue() && 0 == n2) return new VideoData[]{videoData};
        }
        catch (IOException iOException) {
            throw new TrackerException(Tracker.res.getString("Video_IO_Exception"));
        }
        catch (NullPointerException nullPointerException) {
            if (this.videoInProgress) {
                throw new TrackerException(Tracker.res.getString("Video_Socket_Null_Exception"));
            }
            PrintException.print(nullPointerException);
            throw new TrackerException(Tracker.res.getString("Video_Stopped_No_Video_To_Show"));
        }
        return new VideoData[]{videoData};
    }

    JarFile getJarFile(String string) {
        if (null == this.jarCache || this.jarCache.isEmpty()) {
            return null;
        }
        Set set = this.jarCache.keySet();
        Object[] objectArray = set.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!((String)objectArray[i]).toLowerCase(Locale.ENGLISH).endsWith(string.toLowerCase(Locale.ENGLISH))) continue;
            return (JarFile)this.jarCache.get(objectArray[i]);
        }
        return null;
    }

    @Override
    public void changeGestureState(boolean bl) throws TrackerException {
        String string = "gesture_ctrl " + (bl ? "on" : "off");
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("target_camera.gesture_mode")};
        this.trackerCommand(string, 6000);
        if (bl) {
            Object[] objectArray = new Object[]{new Long(1L)};
            this.writeOneTimeData(dataTagArray, objectArray);
        } else {
            Object[] objectArray = new Object[]{new Long(0L)};
            this.writeOneTimeData(dataTagArray, objectArray);
        }
        this.trackerCommand("savecfg", 15000);
    }

    @Override
    public boolean gestureRecognitionOn() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("target_camera.gesture_mode")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        return ((Long)objectArray[0]).intValue() == 1;
    }

    @Override
    public boolean wirelessCapable() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("system.serial_type.value")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        return (((Long)objectArray[0]).intValue() & 1) != 0;
    }

    @Override
    public boolean videoCapable() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("system.serial_type.value")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        return (((Long)objectArray[0]).intValue() & 4) != 0;
    }

    @Override
    public boolean gesturesCapable() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("system.serial_type.value")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        return (((Long)objectArray[0]).intValue() & 8) != 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void searchUsingCamera() throws TrackerException {
        if (!this.videoCapable()) {
            throw new TrackerException(Tracker.res.getString("Video_Disabled_Camera_Search_Not_Supported"));
        }
        if (!this.checkFirmwareValidForForceGesture()) {
            this.searchUsingCamera_old();
            return;
        }
        if (this.checkFirmwareValidForAutomationModeAllTargetTypes()) {
            DataTag[] dataTagArray = new DataTag[]{new DataTagDouble("target_camera.diag.center_smr.x.value"), new DataTagDouble("target_camera.diag.center_smr.y.value"), new DataTagDouble("target_camera.diag.center_smr.estimated_distance.value")};
            Object[] objectArray = this.readOneTimeData(dataTagArray);
            double d = (Double)objectArray[0];
            double d2 = (Double)objectArray[1];
            double d3 = (Double)objectArray[2];
            if (!(d >= 0.0) || !(d2 >= 0.0) || !(d3 > 0.0)) throw new TrackerException(Tracker.res.getString("No_Target_In_Field_Of_View"));
            DataTag[] dataTagArray2 = new DataTag[]{new DataTagDouble("servo.data.azimuth.command_pos"), new DataTagDouble("servo.data.zenith.command_pos"), new DataTagDouble("target_camera.compensation.tracking_center_x.value"), new DataTagDouble("target_camera.compensation.tracking_center_y.value"), new DataTagDouble("target_camera.compensation.scale_factor.value")};
            Object[] objectArray2 = this.readOneTimeData(dataTagArray2);
            double d4 = this.convertXPixelToAzAngle(d, (Double)objectArray2[0], (Double)objectArray2[1], (Double)objectArray2[2], (Double)objectArray2[4]);
            double d5 = this.convertYPixelToZeAngle(d2, (Double)objectArray2[1], (Double)objectArray2[3], (Double)objectArray2[4]);
            double d6 = (Double)objectArray2[0];
            double d7 = (Double)objectArray2[1];
            this.comboSearchInternal_New(d4, d5, d3, -1.0, -1.0, false, false, d6, d7);
            return;
        } else {
            this.trackerCommand("force_gesture -1 -1 --no_spiral --use_tracking_center", 75000);
            if (this.targetPresent()) return;
            throw new TrackerException(Tracker.res.getString("Cameras_Failed_To_Find_Target"));
        }
    }

    public void searchUsingCamera_old() throws TrackerException {
        int n;
        if (!this.videoCapable()) {
            throw new TrackerException(Tracker.res.getString("Video_Disabled_Camera_Search_Not_Supported"));
        }
        DataTag[] dataTagArray = new DataTag[]{new DataTagDouble("target_camera.diag.center_smr.x.value"), new DataTagDouble("target_camera.diag.center_smr.y.value"), new DataTagUnsigned32("target_camera.diag.tgt_count.registered")};
        double d = 0.0;
        double d2 = 0.0;
        for (n = 0; n < 3; ++n) {
            Object[] objectArray = this.readOneTimeData(dataTagArray);
            d = (Double)objectArray[0];
            d2 = (Double)objectArray[1];
            long l = (Long)objectArray[2];
            if (!Double.isNaN(d) && !Double.isNaN(d2) && d != 0.0 && d2 != 0.0 && l >= 1L) break;
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (n == 3) {
            throw new TrackerException(Tracker.res.getString("No_Target_In_Field_Of_View"));
        }
        int n2 = 10000;
        this.log("finding targets @(" + d + ", " + d2 + ")");
        this.trackerCommand("force_gesture  " + d + " " + d2, n2);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int n3 = 10;
        for (int i = 0; i < n3; ++i) {
            if (this.targetPresent()) {
                return;
            }
            try {
                Thread.sleep(n2 / n3);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!this.targetPresent()) {
            throw new TrackerException(Tracker.res.getString("Cameras_Failed_To_Find_Target"));
        }
    }

    private boolean customInitialized() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[4];
        DataTag[] dataTagArray2 = new DataTag[1];
        dataTagArray[0] = new DataTagUnsigned32("servo.motor_state.current");
        dataTagArray[1] = new DataTagUnsigned16("position_device.psd.raw.a.status");
        dataTagArray[2] = new DataTagUnsigned16("position_device.azimuth_encoder.reading.status");
        dataTagArray[3] = new DataTagUnsigned16("position_device.zenith_encoder.reading.status");
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        if ((Long)objectArray[0] != 1L) {
            return false;
        }
        if (0 != ((Integer)objectArray[1] & 0x20)) {
            return false;
        }
        return 0 == (1 & (Integer)objectArray[2]) && 0 == (0x20 & (Integer)objectArray[2]) && 0 == (1 & (Integer)objectArray[3]) && 0 == (0x20 & (Integer)objectArray[3]);
    }

    private void readTrackerPerformanceParameters() throws TrackerException {
        DataTag[] dataTagArray;
        Object[] objectArray;
        if (0.0 == this.admMPEOffset && 0.0 == this.admMPEScale && null != (objectArray = this.readOneTimeData(dataTagArray = new DataTag[]{new DataTagDouble("system.spec.adm.offset.value"), new DataTagUnsigned16("system.spec.adm.offset.status"), new DataTagDouble("system.spec.adm.scale.value"), new DataTagUnsigned16("system.spec.adm.scale.status"), new DataTagDouble("system.spec.transverse.offset.value"), new DataTagUnsigned16("system.spec.transverse.offset.status"), new DataTagDouble("system.spec.transverse.scale.value"), new DataTagUnsigned16("system.spec.transverse.scale.status")}))) {
            int n = 0;
            this.admMPEOffset = (Double)objectArray[n++];
            int n2 = (Integer)objectArray[n++];
            this.admMPEScale = (Double)objectArray[n++];
            int n3 = (Integer)objectArray[n++];
            this.transverseMPEOffset = (Double)objectArray[n++];
            int n4 = (Integer)objectArray[n++];
            this.transverseMPEScale = (Double)objectArray[n++];
            int n5 = (Integer)objectArray[n++];
            if (0 == n2 && 0 == n3 && 0 == n4 && 0 == n5) {
                this.performanceParametersSetForTracker = true;
            }
        }
        if (!this.performanceParametersSetForTracker) {
            throw new InternalTrackerException();
        }
    }

    private double calculateADMMPE(double d) throws TrackerException {
        this.readTrackerPerformanceParameters();
        double d2 = this.admMPEOffset + d * this.admMPEScale;
        return d2;
    }

    private double calculateTransverseMPE(double d) throws TrackerException {
        double d2 = 0.0;
        this.readTrackerPerformanceParameters();
        double d3 = this.transverseMPEOffset + d * this.transverseMPEScale;
        d2 = 2.0 * d3;
        return d2;
    }

    private Class getCompITSuperClass() throws TrackerException {
        String string = "CompIT";
        AppRec appRec = this.findAppInfo(string);
        Class<?> clazz = null;
        try {
            this.jarClassLoader.setAppName(string);
            clazz = this.jarClassLoader.loadClass(appRec.fullQualifiedName);
            Class<?> clazz2 = clazz.getSuperclass();
        }
        catch (Exception exception) {
            throw new InternalTrackerException();
        }
        return clazz;
    }

    @Override
    public boolean isQuickCompensationNoUICapable() throws TrackerException {
        try {
            Class clazz = this.getCompITSuperClass();
            Method method = clazz.getMethod("isQuickCompNoUICapable", null);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean isAACNoUICapable() throws TrackerException {
        try {
            Class clazz = this.getCompITSuperClass();
            Method method = clazz.getMethod("isAACNoUICapable", null);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private long stabilityTime() throws TrackerException {
        long l;
        Object[] objectArray;
        long l2;
        long l3;
        this.readyForCommand();
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("system.thermal_init.time.value"), new DataTagUnsigned32("system.smart_warmup.state")};
        for (int i = 0; i < 20; ++i) {
            Object[] objectArray2 = this.readOneTimeData(dataTagArray);
            long l4 = (Long)objectArray2[0];
            long l5 = (Long)objectArray2[1];
            if (l4 != 0L || l5 != 1L) break;
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if ((l3 = (l2 = ((Long)(objectArray = this.readOneTimeData(new DataTag[]{new DataTagUnsigned32("system.thermal_init.time.value"), new DataTagUnsigned32("system.os_init.time.value")}))[0]).longValue()) - (l = ((Long)objectArray[1]).longValue())) > 0L) {
            return Math.round((double)l3 * 1.024);
        }
        return 0L;
    }

    @Override
    public boolean home(boolean bl, boolean bl2) throws TrackerException {
        int[] nArray = this.getFirmwareVersionNumber();
        boolean bl3 = true;
        if (nArray[0] <= 1 && nArray[1] <= 1 && nArray[2] < 25) {
            bl3 = false;
        }
        if (!bl3) {
            this.home(bl);
            if (bl2) {
                return this.targetLocationValid();
            }
            return true;
        }
        try {
            this.trackerCommand("home" + (bl ? " b" : "") + (bl2 ? " target_required" : ""), 120000);
        }
        catch (NoTargetException noTargetException) {
            return false;
        }
        return true;
    }

    @Override
    public int smartWarmupWaitState() throws TrackerException {
        boolean bl = this.readyToInitialize(false);
        if (!bl) {
            long l = this.stabilityTime();
            if (l > (long)EXTENDED_THERMAL_TIME) {
                return 1;
            }
            if (l > (long)LONG_THERMAL_TIME && l <= (long)EXTENDED_THERMAL_TIME) {
                return 2;
            }
            if (l > (long)QUICK_THERMAL_TIME && l <= (long)LONG_THERMAL_TIME) {
                return 3;
            }
            if (l > (long)DONE_THERMAL_TIME && l <= (long)QUICK_THERMAL_TIME) {
                return 4;
            }
        }
        return 0;
    }

    @Override
    public int applicationPercentComplete(String string) throws TrackerException {
        AppRec appRec = this.findAppInfo(string);
        if (null != appRec && appRec.app != null) {
            if (!this.printed_once) {
                this.printed_once = true;
                AppRec appRec2 = null;
                for (int i = 0; i < this.maintainApp.size(); ++i) {
                    appRec2 = (AppRec)this.maintainApp.get(i);
                }
            }
            return appRec.app.applicationPercentComplete();
        }
        Tracker.formmater.applyPattern("App_Not_Running");
        throw new TrackerException(Tracker.formmater.format(new Object[]{string}));
    }

    @Override
    public void resetCameras() throws TrackerException {
        if (!this.videoCapable()) {
            throw new TrackerException(Tracker.res.getString("Video_Disabled_Reset_Camera_Not_Supported"));
        }
        this.executeTrackerCommand("set_camera_mode reset", 18000);
        Object[] objectArray = new Object[1];
        for (int i = 0; i < 21; ++i) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            objectArray = this.readOneTimeData(new DataTag[]{new DataTagUnsigned32("target_camera.diag.system_ready")});
            if ((Long)objectArray[0] == 1L) break;
        }
        if ((Long)objectArray[0] == 0L) {
            throw new TrackerException(Tracker.res.getString("Failed_To_Reset_Cameras"));
        }
    }

    private void runSpiralSearch(double d, double d2, int n) throws TrackerException {
        try {
            if (d2 > 0.0) {
                this.log("\t SPIRAL with ADM");
                this.search(d, d2, n);
            } else {
                this.log("\t SPIRAL");
                this.search(d, n);
            }
        }
        catch (TrackerException trackerException) {
            // empty catch block
        }
    }

    MeasureData extractFactoryBkndDataFromTracker(int n) {
        MeasureData[] measureDataArray = null;
        try {
            measureDataArray = this.readFactoryBkndMeasureData(n);
        }
        catch (TrackerException trackerException) {
            return null;
        }
        if (measureDataArray == null) {
            return null;
        }
        return measureDataArray[0];
    }

    int checkAndRunSpiralSearch(Object[] objectArray, DataTag[] dataTagArray, int n, double d) throws TrackerException {
        boolean bl;
        boolean bl2;
        if (null == objectArray) {
            objectArray = this.readOneTimeData(dataTagArray);
        }
        this.logComboSearch("carss");
        this.logComboSearch(objectArray);
        double d2 = (Double)objectArray[5] * 100.0;
        double d3 = (Double)objectArray[0];
        double d4 = (Double)objectArray[1];
        double d5 = (Double)objectArray[9];
        double d6 = (Double)objectArray[10];
        double d7 = (Double)objectArray[3];
        int n2 = (Integer)objectArray[4];
        boolean bl3 = bl2 = 1 != (n2 & 1);
        if (!bl2 && d > 0.0) {
            d7 = d;
            bl2 = true;
        }
        this.log("adm = (" + d7 + ", " + n2 + "), psd% = " + d2 + ", while camera coords are (" + d3 + ", " + d4 + ") - @ (" + d5 + ", " + d6 + ")");
        boolean bl4 = bl = d2 > 0.1;
        if (bl || bl2) {
            this.log("INITIATE SPIRAL SEARCH");
            if (bl2) {
                this.runSpiralSearch(0.007, d7, n);
            } else {
                this.runSpiralSearch(0.007, -1.0, n);
            }
            objectArray = this.readOneTimeData(dataTagArray);
            d2 = (Double)objectArray[5] * 100.0;
            int n3 = ((Long)objectArray[8]).intValue();
            d5 = (Double)objectArray[9];
            d6 = (Double)objectArray[10];
            this.log("\t AFTER SPIRAL, psd% = " + d2 + ", and target state = " + n3 + " @ (" + d5 + ", " + d6 + ")");
            this.logComboSearch("as-");
            this.logComboSearch(objectArray);
            if (2 == n3) {
                this.log("\t\t SPIRAL Search FOUND IT!!!");
                return 0;
            }
            return 1;
        }
        return -1;
    }

    private void createComboDebugWriter() {
        try {
            String string = "ComboSearch";
            String string2 = TrackerCypher.getLogFileEnvPath(string + "Log.txt");
            if (!showed_once) {
                JOptionPane.showMessageDialog(null, string2, "Debug File Location", 0);
                showed_once = true;
            }
            this.combo_search_log_writer = new PrintWriter((Writer)new FileWriter(string2, true), false);
            this.log(this.combo_search_log_writer, "");
            this.log(this.combo_search_log_writer, "Combo Search debug info:");
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception, "Error", 0);
        }
    }

    private void closeComboDebugWriter() {
        if (null != this.combo_search_log_writer) {
            this.combo_search_log_writer.flush();
            this.combo_search_log_writer.close();
            this.combo_search_log_writer = null;
        }
    }

    private void logComboSearch(String string) {
        this.log(this.combo_search_log_writer, string);
    }

    private void logComboSearch(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append((Double)objectArray[0]);
        stringBuffer.append(',');
        stringBuffer.append((Double)objectArray[1]);
        stringBuffer.append(',');
        stringBuffer.append(((Long)objectArray[2]).intValue());
        stringBuffer.append(',');
        stringBuffer.append((Double)objectArray[3]);
        stringBuffer.append(',');
        stringBuffer.append((Integer)objectArray[4]);
        stringBuffer.append(',');
        stringBuffer.append((Double)objectArray[5]);
        stringBuffer.append(',');
        stringBuffer.append((Double)objectArray[6]);
        stringBuffer.append(',');
        stringBuffer.append((Double)objectArray[7]);
        stringBuffer.append(',');
        stringBuffer.append(((Long)objectArray[8]).intValue());
        stringBuffer.append(',');
        stringBuffer.append((Double)objectArray[9]);
        stringBuffer.append(',');
        stringBuffer.append((Double)objectArray[10]);
        stringBuffer.append(',');
        stringBuffer.append(((Long)objectArray[11]).intValue());
        stringBuffer.append(',');
        stringBuffer.append(((Long)objectArray[12]).intValue());
        stringBuffer.append(',');
        stringBuffer.append(((Long)objectArray[13]).intValue());
        stringBuffer.append(',');
        stringBuffer.append(((Long)objectArray[14]).intValue());
        stringBuffer.append(',');
        stringBuffer.append(((Long)objectArray[15]).intValue());
        stringBuffer.append(',');
        this.log(this.combo_search_log_writer, stringBuffer.toString());
    }

    private int waitTillCamerasAreDoneSearching() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("target_camera.diag.camera_state"), new DataTagUnsigned32("target.state")};
        boolean bl = false;
        long l = System.currentTimeMillis();
        long l2 = System.currentTimeMillis() - l;
        int n = -1;
        while (l2 < 10000L) {
            l2 = System.currentTimeMillis() - l;
            Object[] objectArray = this.readOneTimeData(dataTagArray);
            n = ((Long)objectArray[1]).intValue();
            int n2 = ((Long)objectArray[0]).intValue();
            this.log("CAM state: " + n2);
            if (!bl && n2 < 4) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (l2 < 2000L) continue;
                this.log("Camera Search state didn't change till min time out");
                break;
            }
            bl = true;
            if (n2 >= 4) continue;
            break;
        }
        this.log("\n\t\t\t\t\ttotal time waiting for camera hunt: " + l2 + ", and the target state value = " + n);
        return n;
    }

    private double convertXPixelToAzAngle(double d, double d2, double d3, double d4, double d5) throws TrackerException {
        double d6 = (d4 - d) * d5;
        d6 /= Math.sin(d3);
        return d6 += d2;
    }

    private double convertYPixelToZeAngle(double d, double d2, double d3, double d4) throws TrackerException {
        double d5 = (d3 - d) * -d4;
        d5 = d2 + d5;
        return d5;
    }

    private boolean checkIfCameraSearchFoundTargetCloseToNominal(DataTag[] dataTagArray, double d, double d2, double d3, double d4) throws TrackerException {
        this.log("Checking...with tols (" + d3 + ", " + d4 + ")");
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        double d5 = (Double)objectArray[9];
        double d6 = (Double)objectArray[10];
        this.log("Delta from Nominal : (" + Math.abs(d5 - d) + ", " + Math.abs(d6 - d2) + ")");
        if (Math.abs(d5 - d) > d3 || Math.abs(d6 - d2) > d4) {
            this.log("Moving back to NOMINAL location");
            this.executeTrackerCommand("moveaxis " + d + " " + d2 + " a", 15000);
            return false;
        }
        return true;
    }

    @Override
    public void comboSearch(double d, double d2, double d3, double d4, double d5, boolean bl) throws TrackerException {
        boolean bl2 = false;
        if (!this.videoCapable()) {
            throw new TrackerException(Tracker.res.getString("Video_Disabled_Combo_Search_Not_Supported"));
        }
        double d6 = d;
        double d7 = d2;
        if (this.checkFirmwareValidForAutomationModeAllTargetTypes()) {
            double d8;
            double d9;
            bl2 = false;
            DataTag[] dataTagArray = new DataTag[]{new DataTagDouble("target_camera.diag.center_smr.x.value"), new DataTagDouble("target_camera.diag.center_smr.y.value"), new DataTagDouble("target_camera.diag.center_smr.estimated_distance.value")};
            Object[] objectArray = this.readOneTimeData(dataTagArray);
            if (d < -0.99 && d > -1.01 && d2 < -0.99 && d2 > -1.01 && d3 < -0.99 && d3 > -1.01) {
                DataTag[] dataTagArray2 = new DataTag[]{new DataTagDouble("servo.data.azimuth.command_pos"), new DataTagDouble("servo.data.zenith.command_pos")};
                Object[] objectArray2 = this.readOneTimeData(dataTagArray2);
                d9 = (Double)objectArray[0];
                d8 = (Double)objectArray[1];
                d3 = (Double)objectArray[2];
                if (d9 >= 0.0 && d8 > 0.0 && d3 > 0.0 && d4 < 0.0 && d5 < 0.0) {
                    DataTag[] dataTagArray3 = new DataTag[]{new DataTagDouble("servo.data.azimuth.command_pos"), new DataTagDouble("servo.data.zenith.command_pos"), new DataTagDouble("target_camera.compensation.tracking_center_x.value"), new DataTagDouble("target_camera.compensation.tracking_center_y.value"), new DataTagDouble("target_camera.compensation.scale_factor.value")};
                    Object[] objectArray3 = this.readOneTimeData(dataTagArray3);
                    d = this.convertXPixelToAzAngle(d9, (Double)objectArray3[0], (Double)objectArray3[1], (Double)objectArray3[2], (Double)objectArray3[4]);
                    d2 = this.convertYPixelToZeAngle(d8, (Double)objectArray3[1], (Double)objectArray3[3], (Double)objectArray3[4]);
                    d6 = (Double)objectArray2[0];
                    d7 = (Double)objectArray2[1];
                } else {
                    d = (Double)objectArray2[0];
                    d2 = (Double)objectArray2[1];
                    d6 = (Double)objectArray2[0];
                    d7 = (Double)objectArray2[1];
                }
            }
            if (d3 <= 0.0) {
                double d10 = (Double)objectArray[0];
                d9 = (Double)objectArray[1];
                d8 = (Double)objectArray[2];
                d3 = d10 >= 0.0 && d9 >= 0.0 && d8 > 0.0 ? d8 : 15.0;
            }
        } else {
            bl2 = d3 < 0.0;
        }
        this.comboSearchInternal_New(d, d2, d3, d4, d5, bl, bl2, d6, d7);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void comboSearchInternal(double d, double d2, double d3) throws TrackerException {
        double d4 = d;
        double d5 = d2;
        if (!this.videoCapable()) {
            throw new TrackerException(Tracker.res.getString("Video_Disabled_Combo_Search_Not_Supported"));
        }
        if (this.checkFirmwareValidForAutomationModeAllTargetTypes()) {
            DataTag[] dataTagArray = new DataTag[]{new DataTagDouble("target_camera.diag.center_smr.x.value"), new DataTagDouble("target_camera.diag.center_smr.y.value"), new DataTagDouble("target_camera.diag.center_smr.estimated_distance.value")};
            Object[] objectArray = this.readOneTimeData(dataTagArray);
            if (d < -0.99 && d > -1.01 && d2 < -0.99 && d2 > -1.01 && d3 < -0.99 && d3 > -1.01) {
                DataTag[] dataTagArray2 = new DataTag[]{new DataTagDouble("servo.data.azimuth.command_pos"), new DataTagDouble("servo.data.zenith.command_pos"), new DataTagDouble("target_camera.compensation.tracking_center_x.value"), new DataTagDouble("target_camera.compensation.tracking_center_y.value"), new DataTagDouble("target_camera.compensation.scale_factor.value")};
                Object[] objectArray2 = this.readOneTimeData(dataTagArray2);
                double d6 = (Double)objectArray[0];
                double d7 = (Double)objectArray[1];
                d3 = (Double)objectArray[2];
                d = this.convertXPixelToAzAngle(d6, (Double)objectArray2[0], (Double)objectArray2[1], (Double)objectArray2[2], (Double)objectArray2[4]);
                d2 = this.convertYPixelToZeAngle(d7, (Double)objectArray2[1], (Double)objectArray2[3], (Double)objectArray2[4]);
                d4 = (Double)objectArray2[0];
                d5 = (Double)objectArray2[1];
            } else if (d3 <= 0.0) {
                double d8 = (Double)objectArray[0];
                double d9 = (Double)objectArray[1];
                double d10 = (Double)objectArray[2];
                d3 = d8 >= 0.0 && d9 >= 0.0 && d10 > 0.0 ? d10 : 15.0;
            }
            if (!(d3 > 0.0)) throw new TrackerException(Tracker.res.getString("No_Target_In_Field_Of_View"));
            this.comboSearchInternal_New(d, d2, d3, -1.0, -1.0, true, false, d4, d5);
            return;
        } else {
            this.comboSearchInternal_New(d, d2, d3, -1.0, -1.0, true, true, d4, d5);
        }
    }

    private Object[] getCameraSearchData(DataTag[] dataTagArray) throws TrackerException {
        return this.getCameraSearchData(dataTagArray, false);
    }

    private Object[] getCameraSearchData(DataTag[] dataTagArray, boolean bl) throws TrackerException {
        long l = System.currentTimeMillis();
        double d = 0.0;
        double d2 = 0.0;
        Object[] objectArray = null;
        long l2 = 0L;
        double d3 = 0.0;
        boolean bl2 = false;
        int n = 0;
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (System.currentTimeMillis() - l <= 3500L) {
            bl2 = false;
            l2 = 0L;
            d3 = 0.0;
            d = 0.0;
            d2 = 0.0;
            objectArray = this.readOneTimeData(dataTagArray);
            d = (Double)objectArray[0];
            d2 = (Double)objectArray[1];
            l2 = (Long)objectArray[2];
            d3 = (Double)objectArray[5] * 100.0;
            n = ((Long)objectArray[8]).intValue();
            int n2 = (Integer)objectArray[4];
            if (!bl && 2 == n && 0 == n2) {
                return null;
            }
            if (!Double.isNaN(d) && !Double.isNaN(d2) && d != 0.0 && d2 != 0.0 && l2 >= 1L) break;
            bl2 = true;
        }
        if (null == objectArray || bl2 && d3 < 0.05) {
            throw new TrackerException(Tracker.res.getString("No_Target_In_Field_Of_View"));
        }
        this.log("Time to get CAM data after a move = " + (System.currentTimeMillis() - l) + " millis");
        return objectArray;
    }

    @Override
    public boolean didAACPassSinceInitialization() throws TrackerException {
        ApplicationResults applicationResults = this.applicationResults("AngularAccuracy");
        long l = applicationResults.getTime();
        Date date = new Date(l * 1000L);
        this.log("Last AAC: " + applicationResults.getResult() + ", ran @ : " + applicationResults.getTime() + " Date: " + date.toString() + " (Details:" + applicationResults.getDetails() + ")");
        Object[] objectArray = this.getTrackerPowerupTime();
        boolean bl = false;
        if (null != objectArray) {
            if (((Boolean)objectArray[0]).booleanValue()) {
                long l2 = (Long)objectArray[1];
                long l3 = System.currentTimeMillis();
                long l4 = -1L;
                int n = 1;
                if (objectArray.length > 2) {
                    l4 = (Long)objectArray[2];
                    n = (Integer)objectArray[3];
                }
                this.log("Tracker Powered on since @ " + l2 + " seconds, in other words @ " + new Date(l3 - l2 * 1000L).toString());
                if (0 != n) {
                    this.log("Tracker is not initialized yet!");
                } else {
                    this.log("Tracker initialized @ " + l4 + " seconds since powered on, in other words @ " + new Date(l3 - (l2 - l4) * 1000L).toString());
                    long l5 = l3 - (l2 - l4) * 1000L;
                    if (l * 1000L >= l5) {
                        if (applicationResults.getResult().trim().equalsIgnoreCase("pass")) {
                            this.log("Last AAC since initializing the tracker passed, so OK to use the tracker :) .");
                            bl = true;
                        } else {
                            bl = false;
                            this.log("Last AAC that was run after initializing the tracker failed. Re-run AAC.");
                        }
                    } else {
                        bl = false;
                        this.log("Tracker accuracy is not checked since initializing the tracker. Run AAC.");
                    }
                }
            } else {
                this.log("Failed to get the tracker start up time. Possible communication issue.");
                throw new TrackerException(Tracker.res.getString("Failed_Communication_Issue"));
            }
        }
        return bl;
    }

    private Object[] getTrackerPowerupTime() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("system.os_init.time.value"), new DataTagUnsigned32("system.zero_correct.time.value"), new DataTagUnsigned16("system.zero_correct.time.status")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        boolean bl = false;
        if (null != objectArray) {
            bl = true;
            return new Object[]{new Boolean(bl), (Long)objectArray[0], objectArray[1], objectArray[2]};
        }
        return null;
    }

    @Override
    public boolean isNoUICompCalCapable() throws TrackerException {
        try {
            Class clazz = this.getCompITSuperClass();
            Method method = clazz.getMethod("isNoUICompCalCapable", null);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean batteryPresent(int n) throws TrackerException {
        if (n < 1 || n > 2) {
            throw new UnsupportedFeatureException(Tracker.res.getString("Unknown_Battery_Number"));
        }
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned16("system.power.battery" + n + ".percent_remaining.status")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        int n2 = (Integer)objectArray[0];
        return n2 == 0;
    }

    @Override
    public int batteryChargeRemaining(int n) throws TrackerException {
        boolean bl = this.batteryPresent(n);
        if (!bl) {
            throw new InternalDeviceFailureException(Tracker.res.getString("Battery_Not_Present"));
        }
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("system.power.battery" + n + ".percent_remaining.value"), new DataTagUnsigned16("system.power.battery" + n + ".percent_remaining.status")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        if ((Integer)objectArray[1] != 0) {
            throw new InternalDeviceFailureException(Tracker.res.getString("Battery_Error"));
        }
        int n2 = ((Long)objectArray[0]).intValue();
        return n2;
    }

    @Override
    public void factoryDisconnect(String string) throws TrackerException {
        CypherFtp cypherFtp = new CypherFtp(debugWriter, this.portUtility);
        try {
            cypherFtp.connect(this.ipAddressToUse, "factory", string);
            this.localFactoryAccess = true;
            cypherFtp.disconnect();
        }
        catch (FtpException ftpException) {
            throw new PermissionException(Tracker.res.getString("Connect_As_Factory_To_Use_The_Method"));
        }
        finally {
            cypherFtp = null;
        }
        this.factoryDisconnect();
    }

    @Override
    public int batteryState(int n) throws TrackerException {
        int n2;
        boolean bl = this.batteryPresent(n);
        if (!bl) {
            return 4;
        }
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("system.power.battery" + n + ".alarm1.value"), new DataTagUnsigned32("system.power.battery" + n + ".alarm2.value"), new DataTagUnsigned16("system.power.battery" + n + ".alarm1.status"), new DataTagUnsigned16("system.power.battery" + n + ".alarm2.status")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        int n3 = (Integer)objectArray[2];
        int n4 = (Integer)objectArray[3];
        if (n3 != 0 || n4 != 0) {
            throw new InternalDeviceFailureException(Tracker.res.getString("Battery_Error"));
        }
        int n5 = ((Long)objectArray[0]).intValue();
        int n6 = n5 > (n2 = ((Long)objectArray[1]).intValue()) ? n5 : n2;
        return this.getExtendedTrkBatteryState(n6);
    }

    @Override
    public void changePowerButtonState(boolean bl) throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("system.power.button.value")};
        long l = bl ? 2L : 1L;
        Object[] objectArray = new Object[]{new Long(l)};
        this.writeOneTimeData(dataTagArray, objectArray);
        this.trackerCommand("savecfg power_psoc", 180000);
    }

    @Override
    public boolean powerButtonState() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("system.power.button.value")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        boolean bl = (Long)objectArray[0] == 2L;
        return bl;
    }

    private void connectFtp(String string, String string2, String string3) throws FtpException {
        Object var4_4 = null;
        this.ftpClient = new CypherFtp(debugWriter, this.portUtility);
        try {
            this.ftpClient.connect(string, string2, string3);
            this.factoryConnect = true;
            this.factoryDisconnect = false;
            this.localFactoryAccess = false;
        }
        catch (FtpException ftpException) {
            this.ftpClient = null;
            throw ftpException;
        }
    }

    private void disconnectFtp() throws DisconnectFailedException {
        try {
            this.ftpClient.disconnect();
            this.ftpClient = null;
            this.factoryDisconnect = true;
            this.factoryConnect = false;
            this.oldmeasureCfg = null;
            this.oldmeasureTags = null;
            this.oldbkndMeasureCfg = null;
            this.oldbkndMeasureTags = null;
            this.oldfactoryBkndMeasureCfg = null;
            this.oldfactoryBkndMeasureTags = null;
        }
        catch (FtpIOException ftpIOException) {
        }
        catch (FtpNoResponseException ftpNoResponseException) {
        }
        catch (FtpException ftpException) {
            throw new DisconnectFailedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reboot() throws TrackerException {
        Object object = this;
        synchronized (object) {
            this.cmdInProgress = true;
        }
        try {
            object = "user";
            String string = "";
            if (this.factoryPrivilege()) {
                object = "factory";
                string = "4253";
            }
            CypherFtp cypherFtp = new CypherFtp(debugWriter, this.portUtility);
            try {
                if (cypherFtp != null) {
                    cypherFtp.connect(this.ipAddressToUse, (String)object, string);
                }
            }
            catch (FtpException ftpException) {
                cypherFtp = null;
                if (ftpException instanceof FtpOutOfPortsException) {
                    throw new CustomPortsException(Tracker.res.getString("Out_Of_Ports"));
                }
                throw new TrackerException(Tracker.res.getString("Failed_To_Establish_Communications_To_Reboot_Tracker"));
            }
            try {
                this.disconnectFtp();
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bl = true;
            try {
                if (cypherFtp != null) {
                    int n = cypherFtp.command("reboot", 10000);
                    if (n != 200) {
                        throw TrackerCypher.exceptionFromResponse(this.ftpClient, n);
                    }
                }
            }
            catch (Exception exception) {
                bl = false;
            }
            finally {
                boolean bl2;
                String string2;
                boolean bl3;
                block72: {
                    try {
                        if (cypherFtp != null) {
                            try {
                                cypherFtp.disconnect();
                            }
                            catch (FtpException ftpException) {}
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    cypherFtp = null;
                    bl3 = false;
                    string2 = Tracker.res.getString("Failed_To_Reboot_Tracker");
                    bl2 = false;
                    if (!bl) {
                        try {
                            this.connectFtp(this.ipAddressToUse, (String)object, string);
                            bl3 = true;
                        }
                        catch (Exception exception) {
                            if (exception instanceof FtpOutOfPortsException) {
                                string2 = Tracker.res.getString("Failed_To_Reboot_Tracker_Communications_Failed_Out_Of_Ports");
                                bl2 = true;
                                break block72;
                            }
                            string2 = Tracker.res.getString("Failed_To_Reboot_Tracker_Communications_Failed");
                        }
                    } else {
                        try {
                            Thread.sleep(30000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        for (int i = 0; !bl3 && i < 15; ++i) {
                            try {
                                this.connectFtp(this.ipAddressToUse, (String)object, string);
                                bl3 = true;
                                continue;
                            }
                            catch (Exception exception) {
                                if (exception instanceof FtpOutOfPortsException) {
                                    string2 = Tracker.res.getString("Failed_To_Connect_After_Reboot_Out_Of_Ports");
                                    bl2 = true;
                                } else {
                                    string2 = Tracker.res.getString("Failed_To_Connect_After_Reboot");
                                }
                                try {
                                    Thread.sleep(10000L);
                                    continue;
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                        }
                    }
                }
                if (!bl || !bl3) {
                    if (bl2) {
                        throw new CustomPortsException(string2);
                    }
                    throw new TrackerException(string2);
                }
            }
        }
        finally {
            object = this;
            synchronized (object) {
                this.cmdInProgress = false;
            }
        }
        this.initSixDof();
        this.registerTrackerEvents();
    }

    private void comboSearchInternal_New(double d, double d2, double d3, double d4, double d5, boolean bl, boolean bl2, double d6, double d7) throws TrackerException {
        DataTag[] dataTagArray;
        Object[] objectArray;
        if (!this.checkFirmwareValidForForceGesture()) {
            throw new TrackerException(Tracker.res.getString("Upgrade_Firmware_Combo_Search"));
        }
        DataTag[] dataTagArray2 = new DataTag[]{new DataTagDouble("position_device.azimuth_encoder.reading.value"), new DataTagDouble("position_device.zenith_encoder.reading.value")};
        Object[] objectArray2 = this.readOneTimeData(dataTagArray2);
        double[] dArray = new double[]{(Double)objectArray2[0], (Double)objectArray2[1]};
        String string = bl2 ? "force_gesture " : "force_gesture2 ";
        string = string + d + " " + d2;
        if (d3 > 0.0) {
            string = string + " --distance " + d3;
        }
        if (this.checkFirmwareValidForAzimuthZenithLimitInForceGesture() && d4 > 0.0 && d5 > 0.0) {
            string = string + " --azimuth_limit " + d4;
            string = string + " --zenith_limit " + d5;
        }
        if (this.checkFirmwareValidForAzimuthZenithTargetInForceGesture()) {
            string = string + " --azimuth_target " + d6;
            string = string + " --zenith_target " + d7;
        }
        string = string + (!bl ? " --no_spiral" : "");
        string = string + " --use_tracking_center";
        this.trackerCommand(string, 75000);
        if (bl && ((Long)(objectArray = this.readOneTimeData(dataTagArray = new DataTag[]{new DataTagUnsigned32("position_device.adm.state")}))[0]).intValue() != 10) {
            if (d3 > 0.0) {
                try {
                    this.search(0.025, d3, 5000);
                }
                catch (Exception exception) {}
            } else {
                try {
                    this.search(0.025, 15.0, 5000);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        dataTagArray = new DataTag[]{new DataTagUnsigned32("position_device.adm.state")};
        objectArray = this.readOneTimeData(dataTagArray);
        if (!this.targetPresent() || ((Long)objectArray[0]).intValue() != 10) {
            if (!this.targetPresent()) {
                throw new TrackerException(Tracker.res.getString("Cameras_Failed_To_Find_Target"));
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            dataTagArray[0] = new DataTagUnsigned32("position_device.adm.state");
            objectArray = this.readOneTimeData(dataTagArray);
            if (!this.targetPresent() || ((Long)objectArray[0]).intValue() != 10) {
                throw new TrackerException(Tracker.res.getString("Cameras_Failed_To_Find_Target"));
            }
        }
        if (d4 > 0.0 && d5 > 0.0) {
            double[] dArray2 = new double[2];
            if (d < 0.0 && d2 < 0.0) {
                dataTagArray2 = new DataTag[]{new DataTagDouble("position_device.azimuth_encoder.reading.value"), new DataTagDouble("position_device.zenith_encoder.reading.value")};
                objectArray2 = this.readOneTimeData(dataTagArray2);
                dArray2[0] = (Double)objectArray2[0];
                dArray2[1] = (Double)objectArray2[1];
            } else {
                dArray[0] = d;
                dArray[1] = d2;
                dataTagArray[0] = new DataTagUnsigned32("position_device.adm.state");
                objectArray = this.readOneTimeData(dataTagArray);
                if (((Long)objectArray[0]).intValue() == 10) {
                    dataTagArray2 = new DataTag[]{new DataTagDouble("target.corrected.azimuth.value"), new DataTagDouble("target.corrected.zenith.value")};
                    objectArray2 = this.readOneTimeData(dataTagArray2);
                    dArray2[0] = (Double)objectArray2[0];
                    dArray2[1] = (Double)objectArray2[1];
                } else {
                    dataTagArray2 = new DataTag[]{new DataTagDouble("position_device.azimuth_encoder.reading.value"), new DataTagDouble("position_device.zenith_encoder.reading.value")};
                    objectArray2 = this.readOneTimeData(dataTagArray2);
                    dArray2[0] = (Double)objectArray2[0];
                    dArray2[1] = (Double)objectArray2[1];
                }
            }
            double d8 = Math.IEEEremainder(dArray[0], Math.PI * 2);
            double d9 = Math.IEEEremainder(dArray[1], Math.PI * 2);
            double d10 = Math.IEEEremainder(dArray2[0], Math.PI * 2);
            double d11 = Math.IEEEremainder(dArray2[1], Math.PI * 2);
            double d12 = Math.abs(Math.IEEEremainder(d10 - d8, Math.PI * 2));
            double d13 = Math.abs(Math.IEEEremainder(d11 - d9, Math.PI * 2));
            if (d12 > d4 || d13 > d5) {
                dataTagArray2 = new DataTag[]{new DataTagDouble("position_device.azimuth_encoder.reading.value"), new DataTagDouble("position_device.zenith_encoder.reading.value")};
                objectArray2 = this.readOneTimeData(dataTagArray2);
                dArray2[0] = (Double)objectArray2[0];
                dArray2[1] = (Double)objectArray2[1];
                d10 = Math.IEEEremainder(dArray2[0], Math.PI * 2);
                d11 = Math.IEEEremainder(dArray2[1], Math.PI * 2);
                d12 = Math.abs(Math.IEEEremainder(d10 - d8, Math.PI * 2));
                d13 = Math.abs(Math.IEEEremainder(d11 - d9, Math.PI * 2));
                if (d12 > d4 || d13 > d5) {
                    if (d < 0.0 && d2 < 0.0) {
                        this.trackerCommand("moveaxis " + dArray[0] + " " + dArray[1] + " a", 15000);
                    } else {
                        this.move(dArray[0], dArray[1], d3, false);
                    }
                    throw new TrackerException(Tracker.res.getString("Cameras_Failed_To_Find_Target_OOT"));
                }
            }
        }
    }

    private boolean checkFirmwareValidForForceGesture() throws TrackerException {
        int[] nArray = this.getFirmwareVersionNumber();
        if (nArray[0] < 1) {
            return false;
        }
        if (nArray[0] == 1 && nArray[1] < 1) {
            return false;
        }
        return nArray[0] != 1 || nArray[1] != 1 || nArray[2] >= 24;
    }

    private boolean checkFirmwareValidForFollowMe() throws TrackerException {
        int[] nArray = this.getFirmwareVersionNumber();
        if (nArray[0] < 1) {
            return false;
        }
        return nArray[0] != 1 || nArray[1] >= 2;
    }

    private int[] getFirmwareVersionNumber() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("system.version.mcu_firmware.num.value")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        this.MCUVersionNumber = (Long)objectArray[0];
        int[] nArray = this.convertToVersionNumber(this.MCUVersionNumber);
        return nArray;
    }

    @Override
    public boolean isFollowMeCapable() throws TrackerException {
        return this.checkFirmwareValidForFollowMe();
    }

    @Override
    public boolean isFollowMeOn() throws TrackerException {
        if (!this.checkFirmwareValidForFollowMe()) {
            return false;
        }
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("target_camera.use_smartlock_on_beam_break")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        return ((Long)objectArray[0]).intValue() == 1;
    }

    @Override
    public void changeFollowMeState(boolean bl) throws TrackerException {
        if (!this.checkFirmwareValidForFollowMe()) {
            throw new TrackerException(Tracker.res.getString("Upgrade_Firmware_Follow_Me"));
        }
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("target_camera.use_smartlock_on_beam_break")};
        if (bl) {
            Object[] objectArray = new Object[]{new Long(1L)};
            this.writeOneTimeData(dataTagArray, objectArray);
        } else {
            Object[] objectArray = new Object[]{new Long(0L)};
            this.writeOneTimeData(dataTagArray, objectArray);
        }
        this.trackerCommand("savecfg", 15000);
    }

    @Override
    public double getFollowMeSearchRadius() throws TrackerException {
        if (!this.checkFirmwareValidForFollowMe()) {
            throw new TrackerException(Tracker.res.getString("Upgrade_Firmware_Follow_Me"));
        }
        DataTag[] dataTagArray = new DataTag[]{new DataTagDouble("target_camera.smartlock_search_radius_from_center_distance")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        double d = (Double)objectArray[0];
        return d;
    }

    @Override
    public void changeFollowMeSearchRadius(double d) throws TrackerException {
        if (!this.checkFirmwareValidForFollowMe()) {
            throw new TrackerException(Tracker.res.getString("Upgrade_Firmware_Follow_Me"));
        }
        if (!(d >= 0.0) || !(d <= 20.0)) {
            throw new TrackerException(Tracker.res.getString("Search_Radius_Out_Of_Range_Follow_Me"));
        }
        DataTag[] dataTagArray = new DataTag[]{new DataTagDouble("target_camera.smartlock_search_radius_from_center_distance")};
        Object[] objectArray = new Object[]{new Double(d)};
        this.writeOneTimeData(dataTagArray, objectArray);
        this.trackerCommand("savecfg", 15000);
    }

    private boolean checkFirmwareValidForAzimuthZenithTargetInForceGesture() throws TrackerException {
        int[] nArray = this.getFirmwareVersionNumber();
        if (nArray[0] < 2) {
            return false;
        }
        return nArray[0] != 2 || nArray[1] >= 6;
    }

    private boolean checkFirmwareValidForAzimuthZenithLimitInForceGesture() throws TrackerException {
        int[] nArray = this.getFirmwareVersionNumber();
        if (nArray[0] < 1) {
            return false;
        }
        return nArray[0] != 1 || nArray[1] >= 2;
    }

    private boolean checkFirmwareValidForAutomationModeAllTargetTypes() throws TrackerException {
        int[] nArray = this.getFirmwareVersionNumber();
        if (nArray[0] < 1) {
            return false;
        }
        return nArray[0] != 1 || nArray[1] >= 2;
    }

    @Override
    public boolean sixDofCapable() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("system.serial_type.value")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        return (((Long)objectArray[0]).intValue() & 0x20) != 0;
    }

    private void createMeasurePointTags() {
        this.pointMeasurementTags = new DataTag[6];
        if (this.sixDofCapableTrk) {
            this.pointMeasurementTags = new DataTag[13];
        }
        this.pointMeasurementTags[0] = new DataTagDouble("target.corrected.azimuth.value");
        this.pointMeasurementTags[1] = new DataTagUnsigned16("target.corrected.azimuth.status");
        this.pointMeasurementTags[2] = new DataTagDouble("target.corrected.zenith.value");
        this.pointMeasurementTags[3] = new DataTagUnsigned16("target.corrected.zenith.status");
        this.pointMeasurementTags[4] = new DataTagDouble("target.corrected.distance.value");
        this.pointMeasurementTags[5] = new DataTagUnsigned16("target.corrected.distance.status");
        if (this.sixDofCapableTrk) {
            this.pointMeasurementTags[6] = new DataTagUnsigned32("target.type");
            this.pointMeasurementTags[7] = new DataTagDouble("target.sixdof.a.value");
            this.pointMeasurementTags[8] = new DataTagUnsigned16("target.sixdof.a.status");
            this.pointMeasurementTags[9] = new DataTagDouble("target.sixdof.b.value");
            this.pointMeasurementTags[10] = new DataTagUnsigned16("target.sixdof.b.status");
            this.pointMeasurementTags[11] = new DataTagDouble("target.sixdof.c.value");
            this.pointMeasurementTags[12] = new DataTagUnsigned16("target.sixdof.c.status");
        }
    }

    @Override
    public Probe[] availableProbes() throws TrackerException {
        int n = this.getProbeTypeConnected();
        this.resetAllProbes(n);
        Probe[] probeArray = this.probeManager.availableProbes("", n);
        return probeArray;
    }

    @Override
    public void addProbe(Probe probe) throws TrackerException {
        int n = this.getProbeTypeConnected();
        if (n == 2) {
            throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported_For_6Probe_2_0"));
        }
        this.resetAllProbes(n);
        String string = probe.getAdapterName();
        this.checkIfAdapterExists(string);
        this.probeManager.addProbe(probe, string, n);
    }

    @Override
    public void removeProbe(Probe probe) throws TrackerException {
        int n = this.getProbeTypeConnected();
        this.resetAllProbes(n);
        this.probeManager.removeProbe(probe, n);
    }

    @Override
    public void modifyProbe(Probe probe) throws TrackerException {
        int n = this.getProbeTypeConnected();
        this.resetAllProbes(n);
        this.probeManager.modifyProbe(probe, n);
        if (n == 1) {
            boolean bl = probe.active();
            if (bl && this.probeAdapterConnected()) {
                this.changeProbe = probe;
                this.generateProbeChangeEvent(1L);
            }
            return;
        }
    }

    @Override
    public void changeProbe(Probe probe, boolean bl) throws TrackerException {
        int n = this.getProbeTypeConnected();
        if (n == 2) {
            throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported_For_6Probe_2_0"));
        }
        this.resetAllProbes(n);
        String string = probe.getName();
        String string2 = probe.getAdapterName();
        String string3 = this.probeAdapter();
        this.probeManager.changeProbe(probe, bl, string3, n);
        DataTag[] dataTagArray = new DataTag[]{new DataTagDouble("sixdof.calibration.tip_vector.x.value"), new DataTagDouble("sixdof.calibration.tip_vector.y.value"), new DataTagDouble("sixdof.calibration.tip_vector.z.value")};
        double[] dArray = this.probeManager.getCalibrationValues(probe);
        if (bl && probe.compensated()) {
            this.writeOneTimeData(dataTagArray, new Object[]{new Double(dArray[0]), new Double(dArray[1]), new Double(dArray[2])});
            this.writeOneTimeData(new DataTag[]{new DataTagUnsigned32("sixdof.calibration.tip_vector.timestamp.value")}, new Object[]{new Long(new Double(dArray[3]).longValue())});
        } else {
            this.writeOneTimeData(dataTagArray, new Object[]{new Double(dArray[0]), new Double(dArray[1]), new Double(dArray[2])});
        }
        this.changeProbe = probe;
        this.generateProbeChangeEvent(1L);
    }

    @Override
    public Probe probe() throws TrackerException {
        int n = this.getProbeTypeConnected();
        String string = this.probeAdapter();
        this.resetAllProbes(n);
        Probe probe = this.probeManager.getActiveProbe(string, n);
        return probe;
    }

    private String[] availableProbeAdapters() throws TrackerException {
        this.checkIfSixDofCapable();
        this.checkIfProbeAdapterConnected();
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("sixdof.probe_adapter.serial_number.1.value")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        String string = this.getProbeSerialNum(((Long)objectArray[0]).toString());
        return new String[]{string};
    }

    @Override
    public String probeAdapter() throws TrackerException {
        this.checkIfSixDofCapable();
        this.checkIfProbeAdapterConnected();
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("sixdof.probe_adapter.serial_number.1.value")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        String string = this.getProbeSerialNum(((Long)objectArray[0]).toString());
        return string;
    }

    @Override
    public boolean probeAdapterConnected() throws TrackerException {
        boolean bl = false;
        if (this.sixDofCapableTrk) {
            DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("sixdof.probe_adapter.active")};
            Object[] objectArray = this.readOneTimeData(dataTagArray);
            bl = (Long)objectArray[0] != 0L;
        }
        return bl;
    }

    private void checkIfSixDofCapable() throws TrackerException {
        if (!this.sixDofCapableTrk) {
            throw new TrackerException(Tracker.res.getString("Not_Six_Dof_Capable"));
        }
    }

    private void checkIfAdapterExists(String string) throws TrackerException {
        boolean bl = false;
        String[] stringArray = this.availableProbeAdapters();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new TrackerException(Tracker.res.getString("Probe_Adapter_Not_Supported"));
        }
    }

    private void checkIfProbeAdapterConnected() throws TrackerException {
        if (!this.probeAdapterConnected()) {
            throw new TrackerException(Tracker.res.getString("Probe_Adapter_Not_Connected"));
        }
    }

    private void resetAllProbes(int n) throws TrackerException {
        if (n != 1) {
            return;
        }
        if (this.checkIfNeedToResetProbes()) {
            this.probeManager.resetAllProbes();
        }
    }

    private boolean checkIfNeedToResetProbes() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned16("sixdof.calibration.tip_vector.x.status"), new DataTagUnsigned16("sixdof.calibration.tip_vector.y.status"), new DataTagUnsigned16("sixdof.calibration.tip_vector.z.status"), new DataTagUnsigned16("sixdof.calibration.tip_vector.timestamp.status")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        int n = (Integer)objectArray[0];
        int n2 = (Integer)objectArray[1];
        int n3 = (Integer)objectArray[2];
        int n4 = (Integer)objectArray[3];
        return (n & 0x20) != 0 && (n2 & 0x20) != 0 && (n3 & 0x20) != 0 && (n4 & 0x20) != 0;
    }

    private Object[] getSmartProbeInfo() throws TrackerException {
        return null;
    }

    private Probe createProbe(Object[] objectArray) {
        String string = (String)objectArray[0];
        String string2 = (String)objectArray[1];
        double d = (Double)objectArray[2];
        double d2 = (Double)objectArray[3];
        double d3 = (Double)objectArray[4];
        double d4 = (Double)objectArray[5];
        double d5 = (Double)objectArray[6];
        double d6 = (Double)objectArray[7];
        int n = (Integer)objectArray[8];
        int n2 = (Integer)objectArray[9];
        double d7 = (Double)objectArray[10];
        int n3 = (Integer)objectArray[11];
        int n4 = (Integer)objectArray[12];
        Probe probe = new Probe(string, string2, d, d2, d3, d4, d5, d6, n, n2, d7, n3, n4);
        return probe;
    }

    @Override
    public ProbeCompensationData calcProbeCompensationParameters(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6) throws TrackerException {
        this.checkIfSixDofCapable();
        this.checkIfProbeAdapterConnected();
        if (dArray.length == 0 || dArray2.length == 0 || dArray3.length == 0 || dArray4.length == 0 || dArray5.length == 0 || dArray6.length == 0) {
            throw new TrackerException(Tracker.res.getString("Cannot_Calculate_Calibration_Parameters_Length_Arrays_Zero"));
        }
        if (dArray.length != dArray2.length || dArray.length != dArray3.length || dArray.length != dArray4.length || dArray.length != dArray5.length || dArray.length != dArray6.length) {
            throw new TrackerException(Tracker.res.getString("Cannot_Calculate_Calibration_Parameters_Incorrect_Length_Arrays"));
        }
        this.sendProbeCompensationData(dArray, dArray2, dArray3, dArray4, dArray5, dArray6);
        Object[] objectArray = this.readProbeCompensationResult();
        int n = (Integer)objectArray[0];
        int n2 = (Integer)objectArray[1];
        double d = (Double)objectArray[2];
        double d2 = (Double)objectArray[3];
        double d3 = (Double)objectArray[4];
        double d4 = (Double)objectArray[5];
        double d5 = (Double)objectArray[6];
        double d6 = (Double)objectArray[7];
        if (n2 == 1) {
            throw new TrackerException(Tracker.res.getString("Cannot_Calculate_Calibration_Parameters_Insufficient_Data"));
        }
        if (n2 == 2) {
            throw new TrackerException(Tracker.res.getString("Cannot_Calculate_Calibration_Parameters_Invalid_Data"));
        }
        DataTag[] dataTagArray = new DataTag[]{new DataTagDouble("sixdof.probe_adapter.case_temperature.value")};
        Object[] objectArray2 = this.readOneTimeData(dataTagArray);
        double d7 = (Double)objectArray2[0];
        double d8 = System.currentTimeMillis() / 1000L;
        ProbeCompensationData probeCompensationData = new ProbeCompensationData(d, d2, d3, d4, d5, d6, d7, d8, n);
        return probeCompensationData;
    }

    private void sendISOProbeCalibrationData(double[] dArray, double[] dArray2, double[] dArray3) throws TrackerException {
        ArrayList<String> arrayList = new ArrayList<String>(dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            arrayList.add(dArray[i] + "," + dArray2[i] + "," + dArray3[i]);
        }
        TrackerCypher.writeFileContents(this.ftpClient, "\\data\\raw_tip_samples.dat", arrayList);
    }

    private void sendProbeCalibrationData(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6) throws TrackerException {
        ArrayList<String> arrayList = new ArrayList<String>(dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            arrayList.add(dArray[i] + "," + dArray2[i] + "," + dArray3[i] + "," + dArray4[i] + "," + dArray5[i] + "," + dArray6[i]);
        }
        TrackerCypher.writeFileContents(this.ftpClient, "\\data\\raw_tip_samples.dat", arrayList);
    }

    private Object[] readISOProbeCalibrationResult() throws TrackerException {
        Object[] objectArray = null;
        String string = TrackerCypher.readFileContents(this.ftpClient, "\\data\\iso_calibration.dat");
        if (string == null || string.length() == 0) {
            throw new TrackerException(Tracker.res.getString("Failed_To_Obtain_Calibration_Results"));
        }
        try {
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                int n = Integer.parseInt(stringTokenizer.nextToken().trim());
                int n2 = Integer.parseInt(stringTokenizer.nextToken().trim());
                double d = Double.parseDouble(stringTokenizer.nextToken().trim());
                objectArray = new Object[]{new Integer(n), new Integer(n2), new Double(d)};
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new TrackerException(Tracker.res.getString("Failed_To_Obtain_Calibration_Results_Invalid_Format"));
        }
        return objectArray;
    }

    private Object[] readProbeCalibrationResult() throws TrackerException {
        Object[] objectArray = null;
        String string = TrackerCypher.readFileContents(this.ftpClient, "\\data\\tip_calibration.dat");
        if (string == null || string.length() == 0) {
            throw new TrackerException(Tracker.res.getString("Failed_To_Obtain_Calibration_Results"));
        }
        try {
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                int n = Integer.parseInt(stringTokenizer.nextToken().trim());
                int n2 = Integer.parseInt(stringTokenizer.nextToken().trim());
                double d = Double.parseDouble(stringTokenizer.nextToken().trim());
                double d2 = Double.parseDouble(stringTokenizer.nextToken().trim());
                double d3 = Double.parseDouble(stringTokenizer.nextToken().trim());
                objectArray = new Object[]{new Integer(n), new Integer(n2), new Double(d), new Double(d2), new Double(d3)};
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new TrackerException(Tracker.res.getString("Failed_To_Obtain_Calibration_Results_Invalid_Format"));
        }
        return objectArray;
    }

    @Override
    public ProbeCalibrationData calibrateProbeTip(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6) throws TrackerException {
        this.checkIfSixDofCapable();
        this.checkIfProbeAdapterConnected();
        if (dArray.length == 0 || dArray2.length == 0 || dArray3.length == 0 || dArray4.length == 0 || dArray5.length == 0 || dArray6.length == 0) {
            throw new TrackerException(Tracker.res.getString("Cannot_Calculate_Calibration_Parameters_Length_Arrays_Zero"));
        }
        if (dArray.length != dArray2.length || dArray.length != dArray3.length || dArray.length != dArray4.length || dArray.length != dArray5.length || dArray.length != dArray6.length) {
            throw new TrackerException(Tracker.res.getString("Cannot_Calculate_Calibration_Parameters_Incorrect_Length_Arrays"));
        }
        this.sendProbeCalibrationData(dArray, dArray2, dArray3, dArray4, dArray5, dArray6);
        Object[] objectArray = this.readProbeCalibrationResult();
        int n = (Integer)objectArray[0];
        int n2 = (Integer)objectArray[1];
        double d = (Double)objectArray[2];
        double d2 = (Double)objectArray[3];
        double d3 = (Double)objectArray[4];
        if (n2 == 1) {
            throw new TrackerException(Tracker.res.getString("Cannot_Calculate_Calibration_Parameters_Insufficient_Data"));
        }
        if (n2 == 2) {
            throw new TrackerException(Tracker.res.getString("Cannot_Calculate_Calibration_Parameters_Invalid_Data"));
        }
        DataTag[] dataTagArray = new DataTag[]{new DataTagDouble("sixdof.probe_adapter.case_temperature.value")};
        Object[] objectArray2 = this.readOneTimeData(dataTagArray);
        double d4 = (Double)objectArray2[0];
        double d5 = System.currentTimeMillis() / 1000L;
        ProbeCalibrationData probeCalibrationData = new ProbeCalibrationData(d, d2, d3, d4, d5, n);
        return probeCalibrationData;
    }

    @Override
    public ProbeCalibrationData calibrateISOProbeTip(double[] dArray, double[] dArray2, double[] dArray3) throws TrackerException {
        this.checkIfSixDofCapable();
        this.checkIfProbeAdapterConnected();
        if (dArray.length == 0 || dArray2.length == 0 || dArray3.length == 0) {
            throw new TrackerException(Tracker.res.getString("Cannot_Calculate_Calibration_Parameters_Length_Arrays_Zero"));
        }
        if (dArray.length != dArray2.length || dArray.length != dArray3.length) {
            throw new TrackerException(Tracker.res.getString("Cannot_Calculate_Calibration_Parameters_Incorrect_Length_Arrays"));
        }
        this.sendISOProbeCalibrationData(dArray, dArray2, dArray3);
        Object[] objectArray = this.readISOProbeCalibrationResult();
        int n = (Integer)objectArray[0];
        int n2 = (Integer)objectArray[1];
        double d = (Double)objectArray[2];
        if (n2 == 1) {
            throw new TrackerException(Tracker.res.getString("Cannot_Calculate_Calibration_Parameters_Insufficient_Data"));
        }
        if (n2 == 2) {
            throw new TrackerException(Tracker.res.getString("Cannot_Calculate_Calibration_Parameters_Invalid_Data"));
        }
        DataTag[] dataTagArray = new DataTag[]{new DataTagDouble("sixdof.probe_adapter.case_temperature.value")};
        Object[] objectArray2 = this.readOneTimeData(dataTagArray);
        double d2 = (Double)objectArray2[0];
        double d3 = System.currentTimeMillis() / 1000L;
        ProbeCalibrationData probeCalibrationData = new ProbeCalibrationData(d, -1.0, -1.0, d2, d3, n);
        return probeCalibrationData;
    }

    @Override
    public void updateProbeCompensationParameters(Probe probe, double d, double d2, double d3) throws TrackerException {
        int n = this.getProbeTypeConnected();
        DataTag[] dataTagArray = new DataTag[]{new DataTagDouble("sixdof.probe_adapter.case_temperature.value")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        double d4 = (Double)objectArray[0];
        this.probeManager.updateProbeCompensation(probe, d, d2, d3, -1.0, d4, n);
    }

    @Override
    public void updateProbeCompensationParameters(Probe probe, double d, double d2, double d3, double d4) throws TrackerException {
        int n = this.getProbeTypeConnected();
        DataTag[] dataTagArray = new DataTag[]{new DataTagDouble("sixdof.probe_adapter.case_temperature.value")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        double d5 = (Double)objectArray[0];
        this.probeManager.updateProbeCompensation(probe, d, d2, d3, d4, d5, n);
    }

    @Override
    public void updateProbeCompensationParameters(Probe probe, ProbeCompensationData probeCompensationData) throws TrackerException {
        int n = this.getProbeTypeConnected();
        this.probeManager.updateProbeCompensation(probe, probeCompensationData, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendProbeCompensationData_Old(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6) throws TrackerException {
        int n;
        TrackerException trackerException = null;
        for (n = 0; n < 3; ++n) {
            int n2;
            trackerException = null;
            try {
                n2 = TrackerCypher.sendFTPStart(this.ftpClient, "\\data\\raw_tip_samples.dat");
                if (n2 != 150) {
                    throw TrackerCypher.exceptionFromResponse(this.ftpClient, n2);
                }
            }
            catch (FtpException ftpException) {
                throw TrackerCypher.convertFtpExc(ftpException);
            }
            try {
                for (int i = 0; i < dArray.length; ++i) {
                    this.ftpClient.sendLine(dArray[i] + "," + dArray2[i] + "," + dArray3[i] + "," + dArray4[i] + "," + dArray5[i] + "," + dArray6[i]);
                }
            }
            catch (FtpException ftpException) {
                trackerException = TrackerCypher.convertFtpExc(ftpException);
            }
            finally {
                block19: {
                    try {
                        n2 = this.ftpClient.sendEnd(10000);
                        if (n2 != 226 && trackerException == null) {
                            trackerException = TrackerCypher.exceptionFromResponse(this.ftpClient, n2);
                        }
                    }
                    catch (FtpException ftpException) {
                        if (trackerException != null) break block19;
                        trackerException = TrackerCypher.convertFtpExc(ftpException);
                    }
                }
            }
            if (trackerException == null) break;
        }
        if (n == 3 && trackerException != null) {
            throw trackerException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] readProbeCompensationResult_old() throws TrackerException {
        int n;
        TrackerException trackerException = null;
        Object[] objectArray = null;
        for (n = 0; n < 3; ++n) {
            block24: {
                int n2;
                trackerException = null;
                try {
                    n2 = TrackerCypher.receiveFTPStart(this.ftpClient, "\\data\\tip_compensation.dat");
                    if (150 != n2) {
                        throw TrackerCypher.exceptionFromResponse(this.ftpClient, n2);
                    }
                }
                catch (FtpException ftpException) {
                    throw TrackerCypher.convertFtpExc(ftpException);
                }
                block18: while (true) {
                    try {
                        try {
                            while (true) {
                                String string;
                                if (null == (string = this.ftpClient.receiveLine())) {
                                    break block24;
                                }
                                try {
                                    if (string == null) continue block18;
                                    StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                                    int n3 = Integer.parseInt(stringTokenizer.nextToken().trim());
                                    int n4 = Integer.parseInt(stringTokenizer.nextToken().trim());
                                    double d = Double.parseDouble(stringTokenizer.nextToken().trim());
                                    double d2 = Double.parseDouble(stringTokenizer.nextToken().trim());
                                    double d3 = Double.parseDouble(stringTokenizer.nextToken().trim());
                                    objectArray = new Object[]{new Double(d), new Double(d2), new Double(d3), new Integer(n3), new Integer(n4)};
                                    continue block18;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (FtpNoResponseException ftpNoResponseException) {
                            // empty catch block
                            break block24;
                        }
                    }
                    catch (FtpException ftpException) {
                        trackerException = TrackerCypher.convertFtpExc(ftpException);
                        break block24;
                    }
                }
                finally {
                    block25: {
                        try {
                            n2 = this.ftpClient.receiveEnd();
                            if (226 != n2) {
                                trackerException = TrackerCypher.exceptionFromResponse(this.ftpClient, n2);
                            }
                        }
                        catch (FtpException ftpException) {
                            if (null != trackerException) break block25;
                            trackerException = TrackerCypher.convertFtpExc(ftpException);
                        }
                    }
                }
            }
            if (null == trackerException) break;
        }
        if (n == 3 && null != trackerException) {
            throw trackerException;
        }
        return objectArray;
    }

    private void sendProbeCompensationData(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6) throws TrackerException {
        ArrayList<String> arrayList = new ArrayList<String>(dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            arrayList.add(dArray[i] + "," + dArray2[i] + "," + dArray3[i] + "," + dArray4[i] + "," + dArray5[i] + "," + dArray6[i]);
        }
        TrackerCypher.writeFileContents(this.ftpClient, "\\data\\raw_tip_samples.dat", arrayList);
    }

    private Object[] readProbeCompensationResult() throws TrackerException {
        Object[] objectArray = null;
        String string = TrackerCypher.readFileContents(this.ftpClient, "\\data\\tip_compensation.dat");
        if (string == null || string.length() == 0) {
            throw new TrackerException("Failed to obtain calibration results");
        }
        try {
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                int n = Integer.parseInt(stringTokenizer.nextToken().trim());
                int n2 = Integer.parseInt(stringTokenizer.nextToken().trim());
                double d = Double.parseDouble(stringTokenizer.nextToken().trim());
                double d2 = Double.parseDouble(stringTokenizer.nextToken().trim());
                double d3 = Double.parseDouble(stringTokenizer.nextToken().trim());
                double d4 = Double.parseDouble(stringTokenizer.nextToken().trim());
                double d5 = Double.parseDouble(stringTokenizer.nextToken().trim());
                double d6 = Double.parseDouble(stringTokenizer.nextToken().trim());
                objectArray = new Object[]{new Integer(n), new Integer(n2), new Double(d), new Double(d2), new Double(d3), new Double(d4), new Double(d5), new Double(d6)};
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new TrackerException("Failed to obtain calibration results in the right format");
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeFileContents(CypherFtp cypherFtp, String string, ArrayList arrayList) throws TrackerException {
        int n;
        TrackerException trackerException = null;
        for (n = 0; n < 3; ++n) {
            int n2;
            trackerException = null;
            try {
                TrackerCypher.logLine("in writeFileContents sendFTPStart : " + new Date().toString());
                n2 = TrackerCypher.sendFTPStart(cypherFtp, string);
                TrackerCypher.logLine("out writeFileContents sendFTPStart : " + n2 + ": " + new Date().toString());
                if (n2 != 150) {
                    TrackerCypher.logLine("writeFileContents sendFTPStart exceptionFromResponse: " + new Date().toString());
                    throw TrackerCypher.exceptionFromResponse(cypherFtp, n2);
                }
            }
            catch (FtpException ftpException) {
                throw TrackerCypher.convertFtpExc(ftpException);
            }
            try {
                TrackerCypher.logLine("in writeFileContents sendLine : " + new Date().toString());
                for (int i = 0; i < arrayList.size(); ++i) {
                    cypherFtp.sendLine((String)arrayList.get(i));
                }
                TrackerCypher.logLine("out writeFileContents sendLine : " + new Date().toString());
            }
            catch (FtpException ftpException) {
                trackerException = TrackerCypher.convertFtpExc(ftpException);
            }
            finally {
                block19: {
                    try {
                        TrackerCypher.logLine("in writeFileContents sendEnd : " + new Date().toString());
                        n2 = cypherFtp.sendEnd(120000);
                        TrackerCypher.logLine("out writeFileContents sendEnd : " + n2 + new Date().toString());
                        if (n2 != 226 && trackerException == null) {
                            TrackerCypher.logLine("writeFileContents sendEnd exceptionFromResponse: " + new Date().toString());
                            trackerException = TrackerCypher.exceptionFromResponse(cypherFtp, n2);
                        }
                    }
                    catch (FtpException ftpException) {
                        if (trackerException != null) break block19;
                        trackerException = TrackerCypher.convertFtpExc(ftpException);
                    }
                }
            }
            if (null == trackerException) break;
        }
        if (n == 3 && null != trackerException) {
            TrackerCypher.logLine("writeFileContents throw ex max tries: " + new Date().toString());
            throw trackerException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String readFileContents(CypherFtp cypherFtp, String string) throws TrackerException {
        int n;
        String string2 = "";
        TrackerException trackerException = null;
        for (n = 0; n < 3; ++n) {
            int n2;
            trackerException = null;
            string2 = "";
            try {
                TrackerCypher.logLine("in readFileContents receiveFTPStart: " + new Date().toString());
                n2 = TrackerCypher.receiveFTPStart(cypherFtp, string);
                TrackerCypher.logLine("out readFileContents after receiveFTPStart: " + n2 + " " + new Date().toString());
                if (150 != n2) {
                    TrackerCypher.logLine("readFileContents throw exceptionFromResponse receiveFTPStart: " + n2 + " " + new Date().toString());
                    throw TrackerCypher.exceptionFromResponse(cypherFtp, n2);
                }
            }
            catch (FtpException ftpException) {
                throw TrackerCypher.convertFtpExc(ftpException);
            }
            try {
                TrackerCypher.logLine("in readFileContents receiveLine: " + n2 + " " + new Date().toString());
                try {
                    String string3;
                    while (null != (string3 = cypherFtp.receiveLine())) {
                        string2 = string2 + string3;
                    }
                }
                catch (FtpNoResponseException ftpNoResponseException) {
                    // empty catch block
                }
                TrackerCypher.logLine("out readFileContents receiveLine: " + n2 + " " + new Date().toString());
            }
            catch (FtpException ftpException) {
                trackerException = TrackerCypher.convertFtpExc(ftpException);
            }
            finally {
                block21: {
                    try {
                        TrackerCypher.logLine("in readFileContents receiveEnd: " + new Date().toString());
                        n2 = cypherFtp.receiveEnd();
                        TrackerCypher.logLine("out readFileContents receiveEnd: " + n2 + " " + new Date().toString());
                        if (226 != n2) {
                            TrackerCypher.logLine("readFileContents throw exceptionFromResponse receiveEnd: " + n2 + " " + new Date().toString());
                            trackerException = TrackerCypher.exceptionFromResponse(cypherFtp, n2);
                        }
                    }
                    catch (FtpException ftpException) {
                        if (null != trackerException) break block21;
                        trackerException = TrackerCypher.convertFtpExc(ftpException);
                    }
                }
            }
            if (null == trackerException) break;
        }
        if (n == 3 && null != trackerException) {
            TrackerCypher.logLine("readFileContents throw ex max tries: " + new Date().toString());
            throw trackerException;
        }
        return string2;
    }

    @Override
    public boolean sixDofEnabled() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("sixdof.probe_adapter.pairing.enable.value")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        return ((Long)objectArray[0]).intValue() == 1;
    }

    @Override
    public void changeSixDofEnableState(boolean bl) throws TrackerException {
        this.checkIfSixDofCapable();
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("sixdof.probe_adapter.pairing.enable.value")};
        Object[] objectArray = new Object[]{new Long(bl ? 1L : 0L)};
        this.writeOneTimeData(dataTagArray, objectArray);
        this.trackerCommand("savecfg", 15000);
    }

    @Override
    public int probeBatteryChargeRemaining() throws TrackerException {
        this.checkIfSixDofCapable();
        this.checkIfProbeAdapterConnected();
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("sixdof.probe_adapter.battery.percent_remaining.value"), new DataTagUnsigned16("sixdof.probe_adapter.battery.percent_remaining.status")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        int n = (Integer)objectArray[1];
        if (n != 0 && (n & 0x8000) != 0) {
            throw new InternalDeviceFailureException(Tracker.res.getString("Probe_Battery_Error"));
        }
        int n2 = ((Long)objectArray[0]).intValue();
        return n2;
    }

    private void generateProbeChangeEvent(long l) throws TrackerException {
        if (this.genProbeChangeTagSupported) {
            this.writeOneTimeData(new DataTag[]{new DataTagUnsigned32(this.genProbeChangeEventTagName)}, new Object[]{new Long(0L)});
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.writeOneTimeData(new DataTag[]{new DataTagUnsigned32(this.genProbeChangeEventTagName)}, new Object[]{new Long(l)});
        }
    }

    private String getProbeSerialNum(String string) {
        String string2 = "";
        int n = 7 - string.length();
        for (int i = 0; i < n; ++i) {
            string2 = string2 + "0";
        }
        String string3 = this.probeAdapterNamePrefix + string2 + string;
        return string3;
    }

    @Override
    public void removeAllProbes() throws TrackerException {
        if (!this.factoryPrivilege()) {
            throw new PermissionException(Tracker.res.getString("Internal_API_Only"));
        }
        int n = this.getProbeTypeConnected();
        this.probeManager.removeAllProbes(n);
    }

    @Override
    public void removeAllFactoryProbes() throws TrackerException {
        if (!this.factoryPrivilege()) {
            throw new PermissionException(Tracker.res.getString("Internal_API_Only"));
        }
        int n = this.getProbeTypeConnected();
        this.probeManager.removeAllFactoryProbes(n);
    }

    @Override
    public double getDelayFromPassiveToActiveFollowMe() throws TrackerException {
        if (!this.checkFirmwareValidForFollowMe()) {
            throw new TrackerException(Tracker.res.getString("Upgrade_Firmware_Follow_Me"));
        }
        DataTag[] dataTagArray = new DataTag[]{new DataTagDouble("target_camera.smartlock_delay_before_restart")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        double d = (Double)objectArray[0];
        return d;
    }

    @Override
    public void setDelayFromPassiveToActiveFollowMe(double d) throws TrackerException {
        if (!this.checkFirmwareValidForFollowMe()) {
            throw new TrackerException(Tracker.res.getString("Upgrade_Firmware_Follow_Me"));
        }
        if (!(d >= 0.0) || !(d <= 5.0)) {
            throw new TrackerException(Tracker.res.getString("Delay_Out_Of_Range_Passive_to_Active_Follow_Me"));
        }
        DataTag[] dataTagArray = new DataTag[]{new DataTagDouble("target_camera.smartlock_delay_before_restart")};
        Object[] objectArray = new Object[]{new Double(d)};
        this.writeOneTimeData(dataTagArray, objectArray);
        this.trackerCommand("savecfg", 15000);
    }

    @Override
    public int probeBatteryState() throws TrackerException {
        this.checkIfSixDofCapable();
        this.checkIfProbeAdapterConnected();
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned16("sixdof.probe_adapter.battery.percent_remaining.status")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        int n = (Integer)objectArray[0];
        int n2 = this.probeBatteryState(n);
        return n2;
    }

    private int probeBatteryState(int n) throws TrackerException {
        if (n != 0) {
            if ((n & 2) != 0) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    @Override
    public boolean probeBatteryStateChangeEventSupported() throws TrackerException {
        return this.sixDofCapableTrk && this.checkFirmware261AndLater();
    }

    private boolean checkFirmware261AndLater() throws TrackerException {
        if (this.mcuVNum[0] < 2) {
            return false;
        }
        if (this.mcuVNum[0] == 2 && this.mcuVNum[1] < 6) {
            return false;
        }
        return this.mcuVNum[0] != 2 || this.mcuVNum[1] != 6 || this.mcuVNum[2] >= 1;
    }

    @Override
    public boolean wirelessStateChangeSupported() throws TrackerException {
        if (!this.wirelessCapable()) {
            return false;
        }
        long l = 33948672L;
        long l2 = 0x1130000L;
        if (this.powerVersionNumber == -1L) {
            this.powerVersionNumber = this.getPowerVersionNumber();
        }
        return this.MCUVersionNumber >= l && this.powerVersionNumber >= l2;
    }

    @Override
    public void changeWirelessState(boolean bl) throws TrackerException {
        if (!this.wirelessCapable()) {
            throw new TrackerException(Tracker.res.getString("Not_Wireless_Capable"));
        }
        if (!this.wirelessStateChangeSupported()) {
            throw new UnsupportedFeatureException(Tracker.res.getString("Change_Wireless_State_not_Supported"));
        }
        String string = bl ? "wifi on" : "wifi off";
        this.executeTrackerCommand(string, 180000);
    }

    @Override
    public boolean wirelessOn() throws TrackerException {
        if (!this.wirelessCapable()) {
            return false;
        }
        if (!this.wirelessStateChangeSupported()) {
            return false;
        }
        Object[] objectArray = this.readOneTimeData(new DataTag[]{new DataTagUnsigned32("system.wifi.configuration.state.value")});
        return ((Long)objectArray[0]).intValue() == 1;
    }

    private long getPowerVersionNumber() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("system.power.psoc_version_dc.value")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        if (objectArray != null && objectArray[0] != null) {
            return (Long)objectArray[0];
        }
        return 0L;
    }

    @Override
    public boolean isCatEyeTargetCapable() throws TrackerException {
        return this.isCatEyeTargetCapable;
    }

    private double[] getCatEyeTargetOffset() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagDouble("target.user.radius_offset"), new DataTagDouble("target.user.cateye.ball.diameter.value")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        double d = (Double)objectArray[0];
        double d2 = (Double)objectArray[1];
        return new double[]{d, d2};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getSessionId() {
        int n;
        if (!communicationDropSupported) {
            return null;
        }
        boolean bl = false;
        Object[] objectArray = new Object[]{new Boolean(false), ""};
        if (this.ftpClient == null) {
            return new Object[]{new Boolean(bl), ""};
        }
        String string = "";
        try {
            n = this.ftpClient.receiveStart("\\data\\session.dat");
            if (150 == n) {
                string = this.ftpClient.receiveLine();
                TrackerCypher.logLine("SessionID: " + string);
            }
        }
        catch (FtpException ftpException) {
        }
        finally {
            try {
                n = this.ftpClient.receiveEnd();
                if (226 == n) {
                    bl = true;
                }
            }
            catch (FtpException ftpException) {}
        }
        this.sessionIdFound = true;
        sessionId = string;
        return new Object[]{new Boolean(bl), string};
    }

    static void printTime(String string) {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        String string2 = simpleDateFormat.format(date);
    }

    private static int checkCommunicationAndDoSendCommandOnly(CypherFtp cypherFtp, String string, int n) throws TrackerException, FtpException {
        int n2 = -1;
        if (cypherFtp == null) {
            return n2;
        }
        if (!communicationDropSupported) {
            if (n == CMD) {
                cypherFtp.commandOnly(string);
            }
            if (n == SEND_FILE) {
                n2 = cypherFtp.sendStart(string);
            }
            if (n == RECEIVE_FILE) {
                n2 = cypherFtp.receiveStart(string);
            }
            return n2;
        }
        int n3 = -1;
        boolean bl = false;
        try {
            TrackerCypher.logLine("");
            TrackerCypher.logLine("Before noop : " + new Date().toString());
            n3 = cypherFtp.commandIgnoreDataSocket("noop", 1000);
            TrackerCypher.logLine("After noop: " + n3 + " : " + new Date().toString());
            if (n == CMD) {
                TrackerCypher.logLine("Before cmd : " + string + ":" + new Date().toString());
                cypherFtp.commandOnly(string);
                TrackerCypher.logLine("After cmd : " + string + ":" + new Date().toString());
            }
            if (n == SEND_FILE) {
                TrackerCypher.logLine("Before sendStart : " + string + ":" + new Date().toString());
                n2 = cypherFtp.sendStart(string);
                TrackerCypher.logLine("After sendStart : " + string + ":" + new Date().toString());
            }
            if (n == RECEIVE_FILE) {
                TrackerCypher.logLine("Before receiveStart : " + string + ":" + new Date().toString());
                n2 = cypherFtp.receiveStart(string);
                TrackerCypher.logLine("After receiveStart : " + string + ":" + new Date().toString());
            }
        }
        catch (FtpIOException ftpIOException) {
            TrackerCypher.logLine("Send Command Drop for FtpIOException: " + new Date().toString() + " : " + string);
            bl = true;
        }
        catch (FtpDataSocketException ftpDataSocketException) {
            TrackerCypher.logLine("Send Command Drop for  FtpDataSocketException: " + new Date().toString() + " : " + string);
            bl = true;
        }
        catch (FtpNoResponseException ftpNoResponseException) {
            TrackerCypher.logLine("***********Send Command Drop FtpNoResponseException: " + new Date().toString() + " : " + string);
            bl = true;
        }
        catch (FtpException ftpException) {
            TrackerCypher.logLine("Send Command Drop for  FtpException: " + new Date().toString() + " : " + string);
            throw ftpException;
        }
        if (bl) {
            int n4;
            Throwable throwable = null;
            for (n4 = 0; n4 < 3 && !disconnectCalled; ++n4) {
                TrackerCypher.logLine("Reconnecting..." + string + " " + (n4 + 1) + " " + new Date().toString());
                long l = System.currentTimeMillis();
                while (!disconnectCalled) {
                    boolean bl2 = TrackerCypher.sendPingRequest(reconnectIp);
                    TrackerCypher.logLine("send command: ping reequest: " + string + " " + bl2 + " " + new Date().toString());
                    if (bl2) break;
                    long l2 = System.currentTimeMillis() - l;
                    if (l2 <= 3000L) continue;
                    TrackerCypher.logLine("timeelapsed send command:" + string + " " + l2 + " " + new Date().toString());
                    throw new FtpException(Tracker.res.getString("Comm_Failed_Send_Command"));
                }
                if (disconnectCalled) {
                    return n2;
                }
                try {
                    TrackerCypher.logLine("before disconnectBeforeReconnect..." + string + " " + (n4 + 1) + " " + new Date().toString());
                    cypherFtp.disconnectBeforeReconnect();
                    TrackerCypher.logLine("after disconnectBeforeReconnect..." + string + " " + (n4 + 1) + " " + new Date().toString());
                }
                catch (FtpException ftpException) {
                    // empty catch block
                }
                try {
                    TrackerCypher.logLine("before connect to(itr, ip, sessionId) " + (n4 + 1) + " " + reconnectIp + "  " + sessionId + " " + new Date().toString());
                    n2 = cypherFtp.connect(reconnectIp, "reconnect", "");
                    TrackerCypher.logLine("after connect to(itr, ip, resp) " + (n4 + 1) + "," + reconnectIp + "," + n2 + "," + new Date().toString());
                    if (n2 != 230) {
                        throw TrackerCypher.exceptionFromResponse(cypherFtp, n2);
                    }
                    TrackerCypher.logLine("before reconnect to(itr, ip, sessionId, resp) " + (n4 + 1) + "," + reconnectIp + "," + sessionId + "," + new Date().toString());
                    n2 = cypherFtp.command("reconnect " + sessionId, 20000);
                    TrackerCypher.logLine("after reconnect to(itr, ip, sessionId, resp) " + (n4 + 1) + "," + reconnectIp + "," + sessionId + "," + n2 + "," + new Date().toString());
                    if (n2 != 200) {
                        throw TrackerCypher.exceptionFromResponse(cypherFtp, n2);
                    }
                    if (n == CMD) {
                        TrackerCypher.logLine("before Tracker Command: " + (n4 + 1) + " " + string + " : " + new Date().toString());
                        cypherFtp.commandOnly(string);
                        TrackerCypher.logLine("after Tracker Command: " + (n4 + 1) + " " + string + " : " + new Date().toString());
                    }
                    if (n == SEND_FILE) {
                        TrackerCypher.logLine("before Sending sendStart: " + (n4 + 1) + " " + string + " : " + new Date().toString());
                        n2 = cypherFtp.sendStart(string);
                        TrackerCypher.logLine("after sendStart: " + (n4 + 1) + " " + string + " : " + new Date().toString());
                    }
                    if (n == RECEIVE_FILE) {
                        TrackerCypher.logLine("before receiveStart: " + (n4 + 1) + " " + string + " : " + new Date().toString());
                        n2 = cypherFtp.receiveStart(string);
                        TrackerCypher.logLine("after receiveStart: " + (n4 + 1) + " " + string + " : " + new Date().toString());
                    }
                    return n2;
                }
                catch (FtpIOException ftpIOException) {
                    TrackerCypher.logLine("Send Command FTPIOExp Try " + (n4 + 1) + " " + ftpIOException.toString() + " " + new Date().toString());
                    throwable = ftpIOException;
                    continue;
                }
                catch (FtpDataSocketException ftpDataSocketException) {
                    TrackerCypher.logLine("Send Command FTPDataSocketExp Try " + (n4 + 1) + " " + ftpDataSocketException.toString() + " " + new Date().toString());
                    throwable = ftpDataSocketException;
                    continue;
                }
                catch (FtpNoResponseException ftpNoResponseException) {
                    TrackerCypher.logLine("*********** Send Command FtpNoResponseException Try " + (n4 + 1) + " " + ftpNoResponseException.toString() + " " + new Date().toString());
                    throwable = ftpNoResponseException;
                    continue;
                }
                catch (FtpException ftpException) {
                    TrackerCypher.logLine("Send Command FTPExp Try" + (n4 + 1) + " " + ftpException.toString() + " " + new Date().toString());
                    throw ftpException;
                }
            }
            if (n4 == 3 && throwable != null && !disconnectCalled) {
                TrackerCypher.logLine("Send Command failed 3 attempts: " + throwable.toString());
                throw throwable;
            }
        }
        return n2;
    }

    private static int sendFTPStart(CypherFtp cypherFtp, String string) throws FtpException, TrackerException {
        int n = TrackerCypher.checkCommunicationAndDoSendCommandOnly(cypherFtp, string, SEND_FILE);
        return n;
    }

    private static int receiveFTPStart(CypherFtp cypherFtp, String string) throws FtpException, TrackerException {
        int n = TrackerCypher.checkCommunicationAndDoSendCommandOnly(cypherFtp, string, RECEIVE_FILE);
        return n;
    }

    private int executeMeasureCommand(CypherFtp cypherFtp, String string, int n) throws FtpException, TrackerException {
        TrackerCypher.logLine("Send Measure: " + string + " " + new Date().toString());
        int n2 = this.executeTrackerCommand(cypherFtp, string, n);
        TrackerCypher.logLine("OUT Send Measure: " + new Date().toString());
        return n2;
    }

    private static void logLine(String string) {
        if (debugWriter != null) {
            debugWriter.println(string);
        }
    }

    private static boolean sendPingRequest(String string) {
        if (null == string) {
            return false;
        }
        boolean bl = false;
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            bl = inetAddress.isReachable(100);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    private static int checkCommunicationAndDoGetResponseOnly(CypherFtp cypherFtp, String string, int n, long l) throws TrackerException, FtpException {
        int n2;
        int n3 = -1;
        if (cypherFtp == null) {
            return n3;
        }
        TrackerCypher.logLine("");
        int n4 = -1;
        boolean bl = false;
        Throwable throwable = null;
        long l2 = 0L;
        for (n2 = 0; n2 < 3 && !disconnectCalled; ++n2) {
            while (!disconnectCalled) {
                boolean bl2 = TrackerCypher.sendPingRequest(reconnectIp);
                TrackerCypher.logLine("get response: ping request: " + bl2 + " " + new Date().toString());
                if (bl2) break;
                l2 = System.currentTimeMillis() - l;
                if (l2 <= (long)n) continue;
                TrackerCypher.logLine("timeelapsed get respose:" + l2 + " " + new Date().toString());
                throw new FtpException(Tracker.res.getString("Comm_Failed_Get_Response"));
            }
            long l3 = (long)n - l2;
            if (disconnectCalled) {
                return n3;
            }
            TrackerCypher.logLine("Before disconnectBeforeReconnect: " + string + " " + (n2 + 1) + " " + new Date().toString());
            try {
                cypherFtp.disconnectBeforeReconnect();
                TrackerCypher.logLine("After disconnectBeforeReconnect: " + string + " " + (n2 + 1) + " " + new Date().toString());
            }
            catch (FtpException ftpException) {
                // empty catch block
            }
            try {
                TrackerCypher.logLine("before connect to wait for resp " + (n2 + 1) + " " + reconnectIp + " " + new Date().toString());
                n3 = cypherFtp.connect(reconnectIp, "reconnect", "");
                TrackerCypher.logLine("after connect to(itr, ip, response) " + (n2 + 1) + " " + reconnectIp + " " + n3 + " " + new Date().toString());
                if (n3 != 230) {
                    throw TrackerCypher.exceptionFromResponse(cypherFtp, n3);
                }
                String string2 = "reconn_last_cmd_response " + sessionId + " " + string;
                TrackerCypher.logLine("before " + string2 + " " + (n2 + 1) + " " + reconnectIp + new Date().toString());
                n3 = cypherFtp.command(string2, 20000);
                TrackerCypher.logLine("after " + string2 + " " + (n2 + 1) + " " + reconnectIp + " " + n3 + " " + new Date().toString());
                if (n3 != 200) {
                    throw TrackerCypher.exceptionFromResponse(cypherFtp, n3);
                }
                TrackerCypher.logLine("before reconnectTrkAndWaitForResp wait for getAbortableResponse: " + (n2 + 1) + " " + n + ": " + new Date().toString());
                n3 = cypherFtp.responseOnly(n);
                TrackerCypher.logLine("after reconnectTrkAndWaitForResp getAbortableResponse: " + (n2 + 1) + " " + n3 + ": " + new Date().toString());
                return n3;
            }
            catch (FtpIOException ftpIOException) {
                TrackerCypher.logLine("FtpIOException reconnectTrkAndWaitForResp" + (n2 + 1) + "  " + new Date().toString());
                throwable = ftpIOException;
                continue;
            }
            catch (FtpDataSocketException ftpDataSocketException) {
                TrackerCypher.logLine("FtpDataSocketException reconnectTrkAndWaitForResp" + (n2 + 1) + "  " + new Date().toString());
                throwable = ftpDataSocketException;
                continue;
            }
            catch (FtpNoResponseException ftpNoResponseException) {
                TrackerCypher.logLine("**************FtpNoResponseException reconnectTrkAndWaitForResp" + (n2 + 1) + "  " + new Date().toString());
                throwable = ftpNoResponseException;
                continue;
            }
            catch (FtpException ftpException) {
                TrackerCypher.logLine("FtpException reconnectTrkAndWaitForResp" + ftpException.toString() + " " + new Date().toString());
                throw ftpException;
            }
        }
        if (n2 == 3 && throwable != null && !disconnectCalled) {
            TrackerCypher.logLine("throw exception reconnectTrkAndWaitForResp failed 3 attempts " + throwable.toString());
            throw throwable;
        }
        if (n3 == -1) {
            TrackerCypher.logLine("response -1  ");
        }
        TrackerCypher.logLine("reconnectTrkAndWaitForResp return response: " + n3 + " : " + new Date().toString());
        return n3;
    }

    private int executeTrackerCommand(CypherFtp cypherFtp, String string, int n) throws FtpException, TrackerException {
        int n2 = 0;
        if (!communicationDropSupported) {
            n2 = this.ftpClient.command(string, n);
            return n2;
        }
        int n3 = 2;
        int n4 = 0;
        do {
            this.sendCommand(cypherFtp, string);
            n2 = this.getResponse(cypherFtp, string, n);
            if (n2 != 563) break;
            if (n2 != 563) continue;
            TrackerCypher.logLine("******************GOT 563 RESPONSE: " + string + " : " + new Date().toString());
        } while (++n4 < n3);
        return n2;
    }

    private int getResponse(CypherFtp cypherFtp, String string, int n) throws TrackerException, FtpException {
        int n2;
        boolean bl = false;
        long l = System.currentTimeMillis();
        try {
            bl = true;
            TrackerCypher.logLine("Before wait for Resp: " + string + " : " + new Date().toString());
            n2 = cypherFtp.responseOnly(n);
            TrackerCypher.logLine("After wait for response: " + n2 + " : " + new Date().toString());
        }
        catch (FtpException ftpException) {
            if (ftpException instanceof FtpIOException || ftpException instanceof FtpNoResponseException) {
                TrackerCypher.logLine("Wifi drop when waiting for response: " + new Date().toString());
                Object var9_10 = null;
                try {
                    TrackerCypher.logLine("Before Reconnect and wait for resp  " + new Date().toString());
                    int n3 = TrackerCypher.checkCommunicationAndDoGetResponseOnly(cypherFtp, string, n, l);
                    TrackerCypher.logLine("After Reconnect and wait for resp  " + new Date().toString());
                    return n3;
                }
                catch (FtpException ftpException2) {
                    if (ftpException2 instanceof FtpIOException || ftpException2 instanceof FtpNoResponseException) {
                        TrackerCypher.logLine("GET RESP Drop 2: " + new Date().toString());
                        if (ftpException instanceof FtpNoResponseException) {
                            TrackerCypher.logLine("*******************NO RESP EXP WHILE WAITING FOR RESP SECOND TIME: " + new Date().toString());
                        }
                        long l2 = System.currentTimeMillis() - l;
                        long l3 = (long)n - l2;
                        try {
                            TrackerCypher.logLine("Waiting for timeout: " + l3);
                            Thread.sleep(l3);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        long l4 = System.currentTimeMillis() - l;
                        TrackerCypher.logLine("cmd total time taken: " + l4);
                        TrackerCypher.logLine("before Reconnect and wait for resp after timeout done " + new Date().toString());
                        int n4 = TrackerCypher.checkCommunicationAndDoGetResponseOnly(cypherFtp, string, 15000, System.currentTimeMillis());
                        TrackerCypher.logLine("after Reconnect and wait for resp after timeout done: " + new Date().toString());
                        return n4;
                    }
                    TrackerCypher.logLine("Throw FTP Exception WAIT For cmd resp DROP 2 : " + new Date().toString());
                    throw ftpException2;
                }
            }
            TrackerCypher.logLine("Throw Exception WAIT For cmd resp Drop1 : " + new Date().toString());
            throw ftpException;
        }
        return n2;
    }

    private void sendCommand(CypherFtp cypherFtp, String string) throws TrackerException, FtpException {
        try {
            TrackerCypher.logLine("");
            TrackerCypher.logLine("Execute Tracker Command: " + string + " : " + new Date().toString());
            TrackerCypher.logLine("Before send command: " + string + " : " + new Date().toString());
            TrackerCypher.checkCommunicationAndDoSendCommandOnly(cypherFtp, string, CMD);
            TrackerCypher.logLine("After send command: " + string + " : " + new Date().toString());
        }
        catch (FtpException ftpException) {
            TrackerCypher.logLine("Exception send Tracker Command: " + ftpException.toString() + " : " + new Date().toString());
            throw ftpException;
        }
    }

    private void openDebugLog() {
    }

    private void closeDebugLog() {
        if (this.debugLog && debugWriter != null) {
            debugWriter.flush();
            debugWriter.close();
        }
    }

    @Override
    public boolean laserOn() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("position_device.pointer_beam.state")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        return ((Long)objectArray[0]).intValue() == 1;
    }

    @Override
    public void changeLaserState(boolean bl) throws TrackerException {
        String string = "pointer_beam_mode  " + (bl ? "on" : "off");
        this.trackerCommand(string, 1000);
    }

    @Override
    public int connectionType() {
        int n = 0;
        if (this.isConnected()) {
            return Tracker.getTrkConnectionType();
        }
        return n;
    }

    private int getTrkBattery1State(int n, int n2) {
        if (n == 15) {
            this.bat1Alarm1Value = n2;
        }
        if (n == 16) {
            this.bat1Alarm2Value = n2;
        }
        return this.getTrkBattery1State();
    }

    private int getTrkBattery1State() {
        int n = this.bat1Alarm1Value > this.bat1Alarm2Value ? this.bat1Alarm1Value : this.bat1Alarm2Value;
        return this.getTrkBatteryState(n);
    }

    private int getTrkBattery2State(int n, int n2) {
        if (n == 17) {
            this.bat2Alarm1Value = n2;
        }
        if (n == 18) {
            this.bat2Alarm2Value = n2;
        }
        return this.getTrkBattery2State();
    }

    private int getTrkBattery2State() {
        int n = this.bat2Alarm1Value > this.bat2Alarm2Value ? this.bat2Alarm1Value : this.bat2Alarm2Value;
        return this.getTrkBatteryState(n);
    }

    private int getTrkBatteryState(int n) {
        if (n == 0) {
            return 4;
        }
        return this.getExtendedTrkBatteryState(n);
    }

    private int getExtendedTrkBatteryState(int n) {
        if ((n & 0x8000) != 0) {
            return 3;
        }
        if ((n & 0x4000) != 0) {
            return 3;
        }
        if ((n & 0x1000) != 0) {
            return 3;
        }
        if ((n & 0x10) != 0) {
            return 2;
        }
        if ((n & 0x80) == 0) {
            return 1;
        }
        return 0;
    }

    private void readBatteryAlarmValues() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("system.power.battery1.alarm1.value"), new DataTagUnsigned32("system.power.battery1.alarm2.value"), new DataTagUnsigned32("system.power.battery2.alarm1.value"), new DataTagUnsigned32("system.power.battery2.alarm2.value")};
        Object[] objectArray = this.readOneTimeData(dataTagArray);
        if (objectArray != null) {
            this.bat1Alarm1Value = ((Long)objectArray[0]).intValue();
            this.bat1Alarm2Value = ((Long)objectArray[1]).intValue();
            this.bat2Alarm1Value = ((Long)objectArray[2]).intValue();
            this.bat2Alarm2Value = ((Long)objectArray[3]).intValue();
        }
        this.bat1State = this.getTrkBattery1State();
        this.bat2State = this.getTrkBattery2State();
    }

    @Override
    public void setPort(PortUtility portUtility) {
        this.portUtility = portUtility;
    }

    @Override
    public int runAutomatedComp() throws TrackerException {
        if (!this.shortWarmupSupported) {
            throw new UnsupportedFeatureException(Tracker.res.getString("Tracker_Is_Not_Auto_Comp_Capable"));
        }
        try {
            this.trackerCommand("autocomp", 180000);
        }
        catch (TrackerException trackerException) {
            String[] stringArray;
            String string = trackerException.getMessage();
            int n = -1;
            if (!string.equals("") && (stringArray = string.split(":")).length > 1) {
                try {
                    n = Integer.parseInt(stringArray[1].trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            switch (n) {
                case 94: 
                case 96: 
                case 98: {
                    return 3;
                }
                case 95: 
                case 97: 
                case 99: {
                    return 4;
                }
                case 100: 
                case 101: {
                    return 2;
                }
                case 102: {
                    return 5;
                }
                case 103: {
                    return 6;
                }
            }
            throw trackerException;
        }
        return 1;
    }

    @Override
    public boolean homeRequired() throws TrackerException {
        if (!this.needHomeSupported) {
            return false;
        }
        Object[] objectArray = this.readOneTimeData(new DataTag[]{new DataTagUnsigned32("laser.control.need_home.value")});
        boolean bl = ((Long)objectArray[0]).intValue() == 1;
        return bl;
    }

    @Override
    public boolean autoCompRequired() throws TrackerException {
        if (!this.shortWarmupSupported) {
            return false;
        }
        Object[] objectArray = this.readOneTimeData(new DataTag[]{new DataTagUnsigned32("short.warmup.need_comp.value")});
        boolean bl = ((Long)objectArray[0]).intValue() == 1;
        return bl;
    }

    @Override
    public boolean autoReconnectCapable() throws TrackerException {
        return communicationDropSupported;
    }

    @Override
    public boolean trackerBatteryEventCapable() throws TrackerException {
        long l = 0x2000000L;
        return this.MCUVersionNumber >= l;
    }

    @Override
    public boolean autoCompCapable() throws TrackerException {
        return this.shortWarmupSupported;
    }

    @Override
    public boolean sixProbe2Capable() {
        return this.sixProbeRev2Supported;
    }

    @Override
    public int probeModelType() throws TrackerException {
        Object[] objectArray;
        int n;
        int n2 = 0;
        if (!this.sixDofCapableTrk) {
            return n2;
        }
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32(this.probe_connect_tag)};
        if (this.sixProbeRev2Supported) {
            dataTagArray = new DataTag[]{new DataTagUnsigned32(this.probe_model_type_tag)};
        }
        if ((n = ((Long)(objectArray = this.readOneTimeData(dataTagArray))[0]).intValue()) == 0) {
            n2 = 0;
        } else if (n == 1) {
            n2 = 1;
        } else if (n == 2) {
            n2 = 2;
        }
        return n2;
    }

    public boolean kinematicAdapterConnectedToSixProbe2() throws TrackerException {
        if (!this.sixDofCapableTrk) {
            return false;
        }
        if (!this.sixProbeRev2Supported) {
            return false;
        }
        Object[] objectArray = this.readOneTimeData(new DataTag[]{new DataTagUnsigned32(this.probe_kin_adapter_connect_tag)});
        boolean bl = ((Long)objectArray[0]).intValue() == 1;
        return bl;
    }

    @Override
    public void removeCompFromProbeCompHistory(Probe probe, double d) throws TrackerException {
        int n = this.getProbeTypeConnected();
        if (n == 1) {
            throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported_For_6Probe_1_0"));
        }
        this.probeManager.removeCompFromProbeCompHistory(probe, d, n);
    }

    @Override
    public void useCompFromProbeCompHistory(Probe probe, double d) throws TrackerException {
        int n = this.getProbeTypeConnected();
        if (n == 1) {
            throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported_For_6Probe_1_0"));
        }
        this.probeManager.useCompFromProbeCompHistory(probe, d, n);
    }

    @Override
    public ProbeCompHistoryData[] probeCompHistory(Probe probe) throws TrackerException {
        int n = this.getProbeTypeConnected();
        if (n == 1) {
            throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported_For_6Probe_1_0"));
        }
        return this.probeManager.probeCompHistory(probe, n);
    }

    @Override
    public boolean probeCompHistoryCapable() throws TrackerException {
        if (!this.sixDofCapableTrk) {
            return false;
        }
        if (!this.sixProbeRev2Supported) {
            return false;
        }
        return this.probeModelType() == 2;
    }

    private int getProbeTypeConnected() throws TrackerException {
        Object[] objectArray;
        long l;
        if (!this.sixDofCapableTrk) {
            throw new TrackerException(Tracker.res.getString("Not_Six_Dof_Capable"));
        }
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32(this.probe_connect_tag)};
        if (this.sixProbeRev2Supported) {
            dataTagArray = new DataTag[]{new DataTagUnsigned32(this.probe_model_type_tag)};
        }
        if ((l = ((Long)(objectArray = this.readOneTimeData(dataTagArray))[0]).longValue()) == 0L) {
            throw new TrackerException(Tracker.res.getString("Probe_Adapter_Not_Connected"));
        }
        return (int)l;
    }

    private void extractProbeFromAsyncPkt(DataInputStream dataInputStream, boolean bl) throws IOException, UnsupportedEncodingException {
        short s = (short)((short)dataInputStream.readByte() & 0xFF);
        dataInputStream.skipBytes(3);
        double d = dataInputStream.readDouble();
        double d2 = dataInputStream.readDouble();
        double d3 = dataInputStream.readDouble();
        double d4 = dataInputStream.readDouble();
        double d5 = dataInputStream.readDouble();
        double d6 = dataInputStream.readDouble();
        long l = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
        long l2 = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
        double d7 = (long)dataInputStream.readInt() & 0xFFFFFFFFL;
        Long l3 = new Long((long)dataInputStream.readInt() & 0xFFFFFFFFL);
        Long l4 = new Long((long)dataInputStream.readInt() & 0xFFFFFFFFL);
        Long l5 = new Long((long)dataInputStream.readInt() & 0xFFFFFFFFL);
        byte[] byArray = new byte[16];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = dataInputStream.readByte();
        }
        String string = new String(byArray, "UTF-8").trim();
        int n = l3.intValue();
        int n2 = l4.intValue();
        int n3 = l5.intValue();
        this.changeProbe = new Probe(string, this.getProbeSerialNum(String.valueOf(l)), d4, d, d2, d3, d7, d5, 2, n, -1.0, n2, 0, String.valueOf(l2), d6, true);
    }

    private void generateDebugProbeEvent(boolean bl) throws TrackerException {
        String[] stringArray;
        String string = "6PRB0199998";
        String string2 = "";
        try {
            stringArray = new File("C:\\temp\\autoProbe.txt");
            if (stringArray.exists()) {
                BufferedReader bufferedReader = new BufferedReader(new FileReader((File)stringArray));
                string2 = bufferedReader.readLine();
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        stringArray = string2.split(",");
        int n = Integer.parseInt(stringArray[0]);
        String string3 = stringArray[1];
        if (bl) {
            try {
                Probe probe;
                this.probeManager.setAllProbesToInactive();
                this.changeProbe = probe = this.probeManager.getProbeBySerialAndActive(string3);
            }
            catch (Exception exception) {
                Probe probe = new Probe("Default", string, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 2, 1, -1.0, 0, 0, string3, -1.0, true);
                this.changeProbe = this.probeManager.createDummyProbe(probe);
            }
        } else {
            try {
                Probe probe;
                this.probeManager.setAllProbesToInactive();
                this.changeProbe = probe = this.probeManager.getProbeBySerial(string3);
            }
            catch (Exception exception) {
                Probe probe = new Probe("Default", string, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 2, 0, -1.0, 0, 0, string3, -1.0, true);
                this.changeProbe = this.probeManager.createDummyProbe(probe);
            }
        }
    }

    private boolean checkIfTrkShortWarmupCapable() throws TrackerException {
        Object[] objectArray = this.readOneTimeData(new DataTag[]{new DataTagUnsigned32("system.serial_type.value")});
        return (((Long)objectArray[0]).intValue() & 0x100) != 0;
    }

    private void executeInit(String string) throws TrackerException {
        Object[] objectArray = null;
        try {
            objectArray = this.readOneTimeData(new DataTag[]{new DataTagUnsigned32("system.init.command.timeout.value")});
        }
        catch (TrackerException trackerException) {
            // empty catch block
        }
        if (objectArray != null && objectArray[0] != null) {
            int n = ((Long)objectArray[0]).intValue() * 1000;
            this.trackerCommand(string + " timeout", n);
        } else {
            this.trackerCommand(string, 180000);
        }
    }

    public static class FollowMeMode {
        public static final int ON = 1;
        public static final int OFF = 0;
    }

    public static class GestureRecognitionMode {
        public static final int ON = 1;
        public static final int OFF = 0;
    }

    private class AppRec {
        public String appName;
        public String fullQualifiedName;
        public Object[] jarFileName;
        public TrackerApp app;
        public boolean readFromLocal = false;
        public int appExitCode = 3;
        public ApplicationResults appResults;
        public int appPercentComplete = -1;

        public AppRec(String string, String string2, Object[] objectArray, boolean bl) {
            this.appName = string;
            this.fullQualifiedName = string2;
            this.jarFileName = objectArray;
            this.readFromLocal = bl;
            this.app = null;
            this.appResults = new ApplicationResults("Unknown result", 0L);
        }

        public void set(TrackerApp trackerApp) {
            this.app = trackerApp;
            this.appExitCode = 2;
            this.appPercentComplete = 1;
        }

        public void clear() {
            try {
                if (this.app != null) {
                    this.appExitCode = this.app.applicationExitCode();
                    this.appResults = this.app.applicationResults();
                    this.appPercentComplete = this.app.applicationPercentComplete();
                }
            }
            catch (TrackerException trackerException) {
                // empty catch block
            }
            this.app = null;
        }

        public boolean isSet() {
            return this.app != null;
        }

        void setAppName(String string) {
            this.appName = string;
        }
    }

    private class JarClassLoader
    extends SecureClassLoader {
        private String[] jarNamesToUse = null;
        private String ipAddress = null;

        private void downLoadJarFiles(AppRec appRec, boolean bl) throws ClassNotFoundException, TrackerException, FtpException {
            Object object;
            Object object2;
            int n;
            String[] stringArray = null;
            if (bl) {
                stringArray = (String[])appRec.jarFileName[1];
            } else {
                stringArray = (String[])appRec.jarFileName[0];
                this.setIpAddress();
            }
            if (stringArray == null) {
                System.err.println("tmpjarnames == null");
                throw new ClassNotFoundException(Tracker.res.getString("Cannot_Find_App_In_Firmware_Or_Local"));
            }
            int n2 = stringArray.length;
            ArrayList<Object> arrayList = new ArrayList<Object>(10);
            ArrayList<String> arrayList2 = new ArrayList<String>(10);
            for (n = 0; n < n2; ++n) {
                object2 = (JarFile)TrackerCypher.this.jarCache.get(stringArray[n]);
                if (object2 != null) continue;
                URL uRL = null;
                try {
                    Object object3;
                    if (bl) {
                        object = "jar:file:/";
                        if (TrackerCypher.this.fileDirectory.startsWith("//")) {
                            object = (String)object + "/";
                        }
                        object = (String)object + TrackerCypher.this.fileDirectory + stringArray[n] + "!/";
                        uRL = new URL((String)object);
                        TrackerCypher.logLine("Download jar: " + (String)object);
                    } else {
                        object = System.getProperty("java.io.tmpdir");
                        object3 = (String)object + "\\" + this.generateJarName();
                        TrackerCypher.logLine("Download jar: " + (String)object3);
                        TrackerCypher.this.readFile((String)object3, stringArray[n]);
                        uRL = new URL("jar", "", -1, "file:/" + (String)object3 + "!/");
                        TrackerCypher.this.tmpDownloadedJarsPath.add(object3);
                    }
                    object = (JarURLConnection)uRL.openConnection();
                    ((URLConnection)object).setUseCaches(false);
                    ((URLConnection)object).connect();
                    object3 = ((JarURLConnection)object).getJarFile();
                    arrayList2.add(stringArray[n]);
                    arrayList.add(object3);
                    continue;
                }
                catch (Exception exception) {
                    System.err.println("jar downloading error for jar name : " + stringArray[n] + " exception = " + exception.toString() + " msg = " + exception.getMessage());
                    Tracker.formmater.applyPattern(Tracker.res.getString("Error_Downloading_Jar"));
                    throw new ClassNotFoundException(Tracker.formmater.format(new Object[]{stringArray[n]}));
                }
            }
            this.jarNamesToUse = stringArray;
            for (n = 0; n < arrayList2.size(); ++n) {
                TrackerCypher.this.jarCache.put(arrayList2.get(n), arrayList.get(n));
            }
            Collection collection = TrackerCypher.this.jarCache.values();
            object2 = collection.iterator();
            int n3 = 0;
            while (object2.hasNext()) {
                object = (JarFile)object2.next();
                ++n3;
            }
        }

        public void setAppName(String string) throws ClassNotFoundException, TrackerException, FtpException {
            AppRec appRec = TrackerCypher.this.findAppInfo(string);
            if (appRec == null) {
                throw new ClassNotFoundException(string);
            }
            boolean bl = appRec.readFromLocal;
            try {
                this.downLoadJarFiles(appRec, bl);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.downLoadJarFiles(appRec, !bl);
            }
        }

        @Override
        public URL getResource(String string) {
            try {
                int n;
                boolean bl = false;
                if (string.startsWith("smx/tracker/appskeystone/utility")) {
                    bl = true;
                }
                String[] stringArray = null;
                stringArray = this.jarNamesToUse;
                int n2 = stringArray.length;
                JarFile jarFile = null;
                for (n = 0; n < n2 && !(bl ? stringArray[n].indexOf("utility") != -1 : stringArray[n].indexOf("utility") == -1); ++n) {
                }
                jarFile = (JarFile)TrackerCypher.this.jarCache.get(stringArray[n]);
                if (jarFile != null) {
                    return new URL("jar:file:/" + jarFile.getName() + "!/" + string);
                }
            }
            catch (Exception exception) {
                System.err.println("ex = " + exception.getMessage() + "\ntostr = " + exception.toString());
                return null;
            }
            return null;
        }

        @Override
        public InputStream getResourceAsStream(String string) {
            try {
                InputStream inputStream = null;
                Collection collection = TrackerCypher.this.jarCache.values();
                for (JarFile jarFile : collection) {
                    inputStream = jarFile.getInputStream(new ZipEntry(string));
                    if (inputStream == null) continue;
                    return inputStream;
                }
            }
            catch (IOException iOException) {
                System.err.println("ex = " + iOException.getMessage() + "\nnew getResource failed bcoz of Exception : " + iOException.toString());
                return null;
            }
            return null;
        }

        public Class findClass(String string) throws ClassNotFoundException {
            Class<?> clazz = null;
            try {
                Object object;
                String string2 = string.replace('.', '/') + ".class";
                InputStream inputStream = null;
                Collection collection = TrackerCypher.this.jarCache.values();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext() && (inputStream = ((JarFile)(object = (JarFile)iterator.next())).getInputStream(new ZipEntry(string2))) == null) {
                }
                if (inputStream == null) {
                    Tracker.formmater.applyPattern(Tracker.res.getString("No_Class_Found"));
                    throw new ClassNotFoundException(Tracker.formmater.format(new Object[]{string}));
                }
                object = this.loadClassData(inputStream);
                clazz = this.defineClass(string, (byte[])object, 0, ((Object)object).length);
                if (clazz == null) {
                    Tracker.formmater.applyPattern(Tracker.res.getString("Error_Defining_Class"));
                    throw new ClassNotFoundException(Tracker.formmater.format(new Object[]{string}));
                }
            }
            catch (Exception exception) {
                Tracker.formmater.applyPattern(Tracker.res.getString("Error_Accessing_Jar"));
                throw new ClassNotFoundException(Tracker.formmater.format(new Object[]{string}));
            }
            return clazz;
        }

        private byte[] loadClassData(InputStream inputStream) throws IOException {
            int n;
            int n2 = inputStream.available();
            byte[] byArray = new byte[n2];
            for (int i = inputStream.read(byArray, 0, n2); i < n2; i += n) {
                n = inputStream.read(byArray, i, n2 - i);
            }
            inputStream.close();
            return byArray;
        }

        private void setIpAddress() throws FtpException {
            if (this.ipAddress != null) {
                return;
            }
            byte[] byArray = TrackerCypher.this.ftpClient.getRemoteIPAddress().getAddress();
            int[] nArray = new int[4];
            for (int i = 0; i < 4; ++i) {
                nArray[i] = byArray[i];
                if (nArray[i] >= 0) continue;
                int n = i;
                nArray[n] = nArray[n] + 256;
            }
            this.ipAddress = nArray[0] + "." + nArray[1] + "." + nArray[2] + "." + nArray[3];
        }

        private String generateJarName() {
            String string = "jar_cachefv";
            for (int i = 0; i < 20; ++i) {
                int n = TrackerCypher.this.generator.nextInt(9) + 1;
                string = string + n;
            }
            string = string + ".tmp";
            return string;
        }
    }

    public static class ProbeType {
        public static final int PROBE_TYPE_NONE = 0;
        public static final int SIX_PROBE_1_0 = 1;
        public static final int SIX_PROBE_2_0 = 2;
    }

    public static class LaserState {
        public static final int ON = 1;
        public static final int OFF = 0;
    }

    public static class WirelessState {
        public static final int ON = 1;
        public static final int OFF = 0;
    }

    public static class ProbePairingState {
        public static final int ON = 1;
        public static final int OFF = 0;
    }

    public static class SmartProbeState {
        public static final int CONNECTED = 1;
        public static final int NOT_CONNECTED = 0;
    }

    public static class SixDofProbeAdapterState {
        public static final int CONNECTED = 1;
        public static final int NOT_CONNECTED = 0;
    }

    public static class PowerButtonState {
        public static final int ON = 2;
        public static final int OFF = 1;
    }

    public static class BatteryStateInformation {
        public static final int OVER_CHARGED_ALARM = 32768;
        public static final int TERMINATE_CHARGE_ALARM = 16384;
        public static final int OVER_TEMP_ALARM = 4096;
        public static final int TERMINATE_DISCHARGE_ALARM = 2048;
        public static final int REMAINING_CAPACITY_ALARM = 512;
        public static final int REMAINING_TIME_ALARM = 256;
        public static final int INITIALIZED = 128;
        public static final int DISCHARGING = 64;
        public static final int FULLY_CHARGED = 32;
        public static final int FULLY_DISCHARGED = 16;
    }

    public static class TrackerCapabilities {
        public static final int WIRELESS = 1;
        public static final int VIDEO = 4;
        public static final int GESTURES = 8;
        public static final int SIX_DOF = 32;
        public static final int SHORT_WARMUP = 256;
    }

    public static class ApplicationResultCode {
        public static final int PASS = 0;
        public static final int FAIL = 1;
        public static final int RECOMMANDATION = 2;
    }

    public static class ApplicationExitCode {
        public static final int CLOSED = 0;
        public static final int CANCELLED = 1;
        public static final int RUNNING = 2;
        public static final int NEVER_RUN = 3;
        public static final int UNSUPPORTED = 4;
    }

    public static class EncoderImproveState {
        public static final int DISABLE = 0;
        public static final int ENABLE = 1;
    }

    public static class ADMVelocityCompState {
        public static final int DISABLE = 0;
        public static final int ENABLE = 1;
    }

    public static class ADMAutoAdjustState {
        public static final int DISABLE = 0;
        public static final int ENABLE = 1;
    }

    public static class OnTrackerTargetThermalCompState {
        public static final int OFF = 0;
        public static final int ON = 1;
    }

    public static class SmartWarmUpState {
        public static final int OFF = 0;
        public static final int ON = 1;
    }

    public static class PayloadThermalCompState {
        public static final int OFF = 0;
        public static final int ON = 1;
    }

    public static class AutoGainAdjustState {
        public static final int DISABLE = 0;
        public static final int ENABLE = 1;
    }

    public static class AzPostThermalCompState {
        public static final int OFF = 0;
        public static final int ON = 1;
    }

    public static class AlarmOutput {
        public static final int OFF = 0;
        public static final int ON = 1;
    }

    public static class SMART_WARMUP_STATE {
        public static final int DEFAULT = 0;
        public static final int IN_PROGRESS = 1;
        public static final int DONE = 2;
        public static final int TERMINATE = 3;
        public static final int ERROR = 4;
    }

    public static class TRACKER_TYPE {
        public static final int VANTAGES = 2;
    }

    public static class ADM_ALIGNMENT {
        public static final int PEAK = 0;
        public static final int COLINEAR = 1;
    }

    public static class ADMState {
        public static final int FINE = 0;
        public static final int COARSE = 1;
        public static final int FORCED_FINE = 2;
        public static final int FORCED_COARSE = 3;
        public static final int ERROR = 4;
    }

    public static class TrackerOrientation {
        public static final int Z_UP = 0;
        public static final int Z_DOWN = 1;
        public static final int Y_UP = 2;
        public static final int Y_DOWN = 3;
        public static final int X_DOWN = 4;
        public static final int X_UP = 5;
    }

    public static class TempSensorType {
        public static final int NONE = 0;
        public static final int AIR = 1;
        public static final int MATERIAL = 2;
    }

    public static class TargetState {
        public static final int NO_TARGET = 0;
        public static final int MARGINAL_TARGET = 1;
        public static final int TARGET_PRESENT = 2;
    }

    public static class DistanceMeasureMode {
        public static final int USER_SPECIFIED = 0;
        public static final int IFM_ONLY = 1;
        public static final int IFM_SET_BY_ADM = 2;
        public static final int ADM_ONLY = 3;
    }

    public static class TypeOfTarget {
        public static final int SMR_3_2 = 0;
        public static final int MIRROR = 1;
        public static final int SMR_1_2 = 2;
        public static final int SMR_7_8 = 3;
        public static final int SMR_USER = 4;
        public static final int SMR_3_2_WINDOWED = 5;
        public static final int SMR_7_8_WINDOWED = 6;
    }

    public static class FBSightMode {
        public static final int FRONTSIGHT = 0;
        public static final int BACKSIGHT = 1;
    }

    public static class TrackingMode {
        public static final int ON = 0;
        public static final int OFF = 1;
    }

    public static class MotorState {
        public static final int OFF = 0;
        public static final int ON = 1;
        public static final int FULL_MANUAL_CONTROL = 2;
        public static final int TORQUE_MANUAL_CONTROL = 3;
        public static final int FAILED = 4;
        public static final int NEVER_INITIALIZED = 5;
        public static final int FULL_MANUAL_FAILED = 6;
        public static final int FULL_MANUAL_NEVER_INITIALIZED = 7;
        public static final int INITIALIZING = 8;
    }

    public static class InternalTemperatureStability {
        public static final int NOT_STABLE = 0;
        public static final int STABLE = 1;
        public static final int CANNOT_DETERMINE_STABILITY = 2;
    }

    public static class ControlState {
        public static final int OFF = 0;
        public static final int ON_UNLOCKED = 1;
        public static final int ON_LOCKED = 2;
        public static final int MANUAL = 3;
        public static final int ERROR = 4;
    }

    public static class PointBeamState {
        public static final int OFF = 0;
        public static final int ON = 2;
        public static final int ERROR = 4;
    }

    public static class AlarmSelect {
        public static final int NONE = 0;
        public static final int DEVIATION = 1;
        public static final int HIGH = 2;
        public static final int LOW = 3;
    }

    public static class InputSelect {
        public static final int NO_SELECTION = 0;
        public static final int HARDWARE_INPUT = 1;
        public static final int MANUAL_INPUT = 2;
    }

    public static class StatusBits {
        public static final int DATA_ERROR = 1;
        public static final int DATA_INACCURATE = 2;
        public static final int DATA_HARDWARE_ERROR = 4;
        public static final int DATA_HARDWARE_INACCURATE = 8;
        public static final int DATA_NOT_COMPENSATED = 16;
        public static final int DATA_NOT_INITIALIZED = 32;
        public static final int DATA_MANUAL = 64;
        public static final int DATA_DISABLED = 128;
        public static final int DATA_DEFAULT = 256;
        public static final int DATA_SUPPORTING_DATA_INACCURATE = 512;
        public static final int DATA_SUPPORTING_DATA_ERROR = 1024;
        public static final int DATA_SIXDOF_NOT_CONNECTED = 2048;
        public static final int DATA_SIXDOF_ERROR = 32768;
    }
}

