/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.ImageProducer;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JPanel;
import smx.tracker.PrintException;
import smx.tracker.Tracker;
import smx.tracker.TrackerApp;
import smx.tracker.TrackerException;

class TrackerAppFrame
extends JFrame {
    private AddRemoveListener addRemoveListener;
    private Tracker trk;
    private String appName;
    private boolean frameAlwaysOnTop;
    JPanel appPanel = new JPanel();
    GridLayout grid1 = new GridLayout();

    public native void windowAlwaysOnTop(String var1, boolean var2);

    private void addCustomIcon() {
        try {
            URL uRL = this.getClass().getResource("/smx/tracker/appsicon.gif");
            if (this.trk.getTrackerType().equals("TrackerCypher")) {
                uRL = this.getClass().getResource("/smx/tracker/appsiconcypher.gif");
            }
            this.setIconImage(this.createImage((ImageProducer)uRL.getContent()));
        }
        catch (Exception exception) {
            PrintException.print(exception);
        }
    }

    private void setCenterLocation() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        int n = (dimension.width - dimension2.width) / 2;
        int n2 = (dimension.height - dimension2.height) / 2;
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        this.setLocation(n, n2);
    }

    TrackerAppFrame(String string, Tracker tracker, boolean bl) {
        super(string);
        this.appName = string;
        this.frameAlwaysOnTop = bl;
        this.trk = tracker;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            PrintException.print(exception);
        }
        this.addRemoveListener = new AddRemoveListener();
        this.appPanel.addContainerListener(this.addRemoveListener);
        this.addCustomIcon();
        this.pack();
    }

    JPanel getAppPanel() {
        return this.appPanel;
    }

    private void appAdded() {
        this.pack();
        this.setCenterLocation();
        Component[] componentArray = this.appPanel.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof TrackerApp) || componentArray[i].isVisible()) continue;
            this.setVisible(false);
            return;
        }
        this.setVisible(true);
    }

    void appRemoved() {
        this.appPanel.removeContainerListener(this.addRemoveListener);
        this.setVisible(false);
        this.dispose();
    }

    private void jbInit() throws Exception {
        this.setDefaultCloseOperation(0);
        this.setResizable(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                TrackerAppFrame.this.this_windowClosing(windowEvent);
            }

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                TrackerAppFrame.this.this_windowOpened(windowEvent);
            }
        });
        this.appPanel.setLayout(this.grid1);
        this.getContentPane().add(this.appPanel);
    }

    void this_windowClosing(WindowEvent windowEvent) {
        try {
            this.trk.stopApplication(this.appName);
        }
        catch (TrackerException trackerException) {
            // empty catch block
        }
    }

    void this_windowOpened(WindowEvent windowEvent) {
        try {
            if (this.frameAlwaysOnTop) {
                this.windowAlwaysOnTop(this.appName, true);
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    private class AddRemoveListener
    implements ContainerListener {
        private AddRemoveListener() {
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            TrackerAppFrame.this.appAdded();
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            TrackerAppFrame.this.appRemoved();
        }
    }
}

