/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JPanel;
import smx.tracker.ApplicationResults;
import smx.tracker.Tracker;
import smx.tracker.TrackerException;
import smx.tracker.UnsupportedFeatureException;
import smx.utility.UnitsConversion;

public class TrackerApp
extends JPanel {
    private static final int MIN_DECIMAL_PLACES = 1;
    protected Tracker trk = null;
    protected JFrame frame = null;
    private static final String DEFAULT_LENGTH_NAME = "m";
    private static final int DEFAULT_LENGTH_DECIMAL_PLACES = 8;
    private static final String DEFAULT_ANGULAR_NAME = "rad";
    private static final int DEFAULT_ANGULAR_DECIMAL_PLACES = 7;
    private static final String DEFAULT_PRESSURE_NAME = "mmHg";
    private static final int DEFAULT_PRESSURE_DECIMAL_PLACES = 2;
    private static final String DEFAULT_TEMPERATURE_NAME = "\u00b0C";
    private static final int DEFAULT_TEMPERATURE_DECIMAL_PLACES = 2;
    protected UnitsConversion lengthUnits = new UnitsConversion("m", 1.0, 0.0, 0.0, 8);
    protected UnitsConversion angularUnits = new UnitsConversion("rad", 1.0, 0.0, 0.0, 7);
    protected UnitsConversion pressureUnits = new UnitsConversion("mmHg", 1.0, 0.0, 0.0, 2);
    protected UnitsConversion temperatureUnits = new UnitsConversion("\u00b0C", 1.0, 0.0, 0.0, 2);
    int[] appExitLock = new int[1];

    public TrackerApp() {
    }

    private void processLengthUnits(String string) {
        try {
            int n;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            String string2 = stringTokenizer.nextToken();
            string2 = string2.trim();
            if (0 == string2.length()) {
                return;
            }
            String string3 = stringTokenizer.nextToken();
            double d = Double.parseDouble(string3 = string3.trim());
            if (d <= 0.0) {
                return;
            }
            try {
                String string4 = stringTokenizer.nextToken();
                string4 = string4.trim();
                n = Integer.parseInt(string4);
                if (n < 1) {
                    return;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                n = UnitsConversion.calculateDecimalPlaces((double)1.0, (int)8, (double)d);
                n = Math.max(1, n);
            }
            this.lengthUnits = new UnitsConversion(string2, d, 0.0, 0.0, n);
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void processAngularUnits(String string) {
        try {
            int n;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            String string2 = stringTokenizer.nextToken();
            string2 = string2.trim();
            if (0 == string2.length()) {
                return;
            }
            String string3 = stringTokenizer.nextToken();
            double d = Double.parseDouble(string3 = string3.trim());
            if (d <= 0.0) {
                return;
            }
            try {
                String string4 = stringTokenizer.nextToken();
                string4 = string4.trim();
                n = Integer.parseInt(string4);
                if (n < 1) {
                    return;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                n = UnitsConversion.calculateDecimalPlaces((double)1.0, (int)7, (double)d);
                n = Math.max(1, n);
            }
            this.angularUnits = new UnitsConversion(string2, d, 0.0, 0.0, n);
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void processPressureUnits(String string) {
        try {
            int n;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            String string2 = stringTokenizer.nextToken();
            string2 = string2.trim();
            if (0 == string2.length()) {
                return;
            }
            String string3 = stringTokenizer.nextToken();
            double d = Double.parseDouble(string3 = string3.trim());
            if (d <= 0.0) {
                return;
            }
            try {
                String string4 = stringTokenizer.nextToken();
                string4 = string4.trim();
                n = Integer.parseInt(string4);
                if (n < 1) {
                    return;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                n = UnitsConversion.calculateDecimalPlaces((double)1.0, (int)2, (double)d);
                n = Math.max(1, n);
            }
            this.pressureUnits = new UnitsConversion(string2, d, 0.0, 0.0, n);
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void processTemperatureUnits(String string) {
        try {
            int n;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            String string2 = stringTokenizer.nextToken();
            string2 = string2.trim();
            if (0 == string2.length()) {
                return;
            }
            String string3 = stringTokenizer.nextToken();
            double d = Double.parseDouble(string3 = string3.trim());
            if (d <= 0.0) {
                return;
            }
            string3 = stringTokenizer.nextToken();
            string3 = string3.trim();
            double d2 = Double.parseDouble(string3);
            try {
                String string4 = stringTokenizer.nextToken();
                string4 = string4.trim();
                n = Integer.parseInt(string4);
                if (n < 1) {
                    return;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                n = UnitsConversion.calculateDecimalPlaces((double)1.0, (int)2, (double)d);
                n = Math.max(1, n);
            }
            this.temperatureUnits = new UnitsConversion(string2, d, 0.0, d2, n);
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void processUnits(String string) {
        try {
            int n = string.indexOf("=");
            if (-1 == n) {
                return;
            }
            String string2 = string.substring(1, n);
            string2 = string2.trim();
            String string3 = string.substring(n + 1);
            string3 = string3.trim();
            if (string2.startsWith("Length")) {
                this.processLengthUnits(string3);
                return;
            }
            if (string2.startsWith("Angular")) {
                this.processAngularUnits(string3);
                return;
            }
            if (string2.startsWith("Pressure")) {
                this.processPressureUnits(string3);
                return;
            }
            if (string2.startsWith("Temperature")) {
                this.processTemperatureUnits(string3);
                return;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private void processParam(String string) {
        if (null == string) {
            return;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "-", true);
            while (true) {
                String string2;
                if (!(string2 = stringTokenizer.nextToken()).equals("-")) {
                    continue;
                }
                while ((string2 = stringTokenizer.nextToken()).equals("-")) {
                }
                string2 = string2.trim();
                switch (string2.charAt(0)) {
                    case 'u': {
                        this.processUnits(string2);
                    }
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    public TrackerApp(String string, Tracker tracker, JFrame jFrame) {
        this.appExitLock[0] = 0;
        this.trk = tracker;
        this.frame = jFrame;
        this.processParam(string);
    }

    public synchronized void modifyParameters(String string) {
        this.processParam(string);
    }

    public void waitUntilStable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.trk = null;
        this.frame = null;
        int[] nArray = this.appExitLock;
        synchronized (this.appExitLock) {
            this.appExitLock[0] = 1;
            this.appExitLock.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void abortApp() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }

    public int applicationExitCode() throws TrackerException {
        return 4;
    }

    public ApplicationResults applicationResults() throws TrackerException {
        return new ApplicationResults(Tracker.res.getString("Unknown_Result"), 0L);
    }

    public int applicationPercentComplete() throws TrackerException {
        throw new UnsupportedFeatureException(Tracker.res.getString("Feature_Not_Supported"));
    }
}

