/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import smx.ftp.CypherFtp;
import smx.tracker.Probe;
import smx.tracker.ProbeCompHistoryData;
import smx.tracker.Tracker;
import smx.tracker.TrackerCypher;
import smx.tracker.TrackerException;

public class ProbeKinematicParser {
    private String readFileName = "";
    private String writeFileName = "";
    CypherFtp ftp;
    String filePath = "C:\\temp\\tips.dat";
    private String probeSrNumKey = "ProbeSerialNumber";
    private String tipSrNumKey = "TipSerialNumber";
    private String tipNameKey = "TipName";
    private String tipDiameterKey = "TipDiameter";
    private String tipXKey = "TipX";
    private String tipYKey = "TipY";
    private String tipZKey = "TipZ";
    private String tipCompDateKey = "TipCompTime";
    private String tipCompTempKey = "TipCompTemp";
    private String tipActiveKey = "TipActive";
    private String tipCompensatedKey = "TipCompensated";
    private String tipTypeKey = "TipType";
    private String compHistoryArrayKey = "CompHistory";
    private String tipCompInUseKey = "TipInUse";
    private String tipCompErrorKey = "TipError";
    private String tipFactoryKey = "TipFactory";
    private String kinematicTipArrayName = "kinematicTipsData";
    boolean debug = false;
    private String commandFile = "\\data\\kinematic_tip.dat";
    private String responseFile = "\\data\\response.dat";
    private String tipMountSrNum = "";
    private String tipName = "";
    private String tipDiameter = "";
    private Probe tipProbe;
    Probe probe;
    MessageFormat form = new MessageFormat("");
    private Probe dummyProbe;
    String probeAdapterNamePrefix = "6PRB";
    private final int COMMAND_OK = 200;
    private final int INVALID_PARAMETERS = 201;
    private final int PROBE_NOT_FOUND = 202;
    private final int INVALID_NAME = 203;
    private final int INVALID_DIAMETER = 204;
    private final int NO_COMP_FOR_SPECIFIED_TIME = 205;
    private final int UNKNOWN_COMMAND = 206;
    private final int CANNOT_DELETE_COMP_IN_USE = 207;
    private final int NO_KINEMATIC_ADAPTER_CONNECTED = 208;
    private final int CANNOT_ADD_COMP_REACHED_MAX_LIMIT = 209;
    private final int NO_PROBES_FOUND = 210;
    private final int CANNOT_ADD_TIP_COMP_ALREADY_EXISTS = 211;
    private final int NOT_CONNECTED_TO_PROBE = 212;
    private final int KINEMATIC_PROBE_NOT_READY = 213;
    private final int FAILED_TO_UPDATE_COMP_TO_PROBE = 214;
    private PrintWriter debugWriter = null;

    public ProbeKinematicParser(CypherFtp cypherFtp) {
        this.ftp = cypherFtp;
    }

    protected Probe[] availableProbes() throws TrackerException {
        String string = this.processCmd("all_tips");
        Probe[] probeArray = this.createProbeList(string);
        if (probeArray == null) {
            throw new TrackerException(Tracker.res.getString("No_Probes_6Probe_2_0"));
        }
        return probeArray;
    }

    protected Probe getActiveProbe() throws TrackerException {
        String string = this.processCmd("active_tip");
        JSONObject jSONObject = new JSONObject(string);
        Probe probe = this.createProbe(jSONObject);
        if (probe == null) {
            throw new TrackerException(Tracker.res.getString("No_Active_Probe_6Probe_2_0"));
        }
        return probe;
    }

    protected void modifyProbe(Probe probe) throws TrackerException {
        this.processCmd("modify_tip " + probe.getSerialNumber() + " \"" + probe.getName() + "\" " + probe.getDiameter());
    }

    protected void updateProbeComp(Probe probe, double d, double d2, double d3, double d4, double d5, double d6) throws TrackerException {
        long l = new Double(d6).longValue();
        String string = "add_tip_comp " + d + " " + d2 + " " + d3 + " " + d4 + " " + l + " \"" + probe.getName() + "\" " + probe.getDiameter();
        this.processCmd(string);
    }

    protected void removeProbeComp(Probe probe, double d) throws TrackerException {
        long l = new Double(d).longValue();
        this.processCmd("remove_tip_comp " + probe.getSerialNumber() + " " + l);
    }

    protected void useProbeComp(Probe probe, double d) throws TrackerException {
        long l = new Double(d).longValue();
        this.processCmd("use_tip_comp " + probe.getSerialNumber() + " " + l);
    }

    protected ProbeCompHistoryData[] probeCompHistory_1(Probe probe) throws TrackerException {
        String string = this.processCmd("all_tips");
        ProbeCompHistoryData[] probeCompHistoryDataArray = this.getCompHistory(string, probe.getSerialNumber());
        if (probeCompHistoryDataArray == null) {
            throw new TrackerException(Tracker.res.getString("No_Probe_Comp_History_Found"));
        }
        return probeCompHistoryDataArray;
    }

    protected ProbeCompHistoryData[] probeCompHistory(Probe probe) throws TrackerException {
        String string = this.processCmd("comp_by_serial " + probe.getSerialNumber());
        ProbeCompHistoryData[] probeCompHistoryDataArray = this.getCompHistory(string, probe.getSerialNumber());
        if (probeCompHistoryDataArray == null) {
            throw new TrackerException(Tracker.res.getString("No_Probe_Comp_History_Found"));
        }
        return probeCompHistoryDataArray;
    }

    protected boolean probeCompHistoryAvailable(Probe probe) throws TrackerException {
        String string = this.processCmd("all_tips");
        if (string.equals(String.valueOf(202))) {
            return false;
        }
        ProbeCompHistoryData[] probeCompHistoryDataArray = this.getCompHistory(string, probe.getSerialNumber());
        return probeCompHistoryDataArray != null;
    }

    protected void removeProbe(Probe probe) throws TrackerException {
        this.processCmd("remove_by_serial " + probe.getSerialNumber());
    }

    protected void removeAllFactoryProbes() throws TrackerException {
        this.processCmd("remove_factory_tips");
    }

    protected void removeAllProbes() throws TrackerException {
        this.processCmd("remove_all_tips");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFileLocal(String string) throws TrackerException {
        String string2 = "";
        BufferedReader bufferedReader = null;
        try {
            String string3;
            File file = new File(string);
            bufferedReader = new BufferedReader(new FileReader(file));
            StringBuffer stringBuffer = new StringBuffer();
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string3);
            }
            string2 = stringBuffer.toString();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return string2;
    }

    private Probe[] createProbeList(String string) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            JSONArray jSONArray = (JSONArray)jSONObject.get(this.kinematicTipArrayName);
            int n = jSONArray.length();
            Probe[] probeArray = new Probe[n];
            for (int i = 0; i < n; ++i) {
                Probe probe;
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                probeArray[i] = probe = this.createProbe(jSONObject2);
            }
            return probeArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Probe createProbe(JSONObject jSONObject) {
        try {
            Object object;
            String string = this.getProbeSerialNum(String.valueOf(jSONObject.getLong(this.probeSrNumKey)));
            String string2 = String.valueOf(jSONObject.getLong(this.tipSrNumKey));
            String string3 = jSONObject.getString(this.tipNameKey);
            double d = jSONObject.getDouble(this.tipDiameterKey);
            double d2 = jSONObject.getDouble(this.tipXKey);
            double d3 = jSONObject.getDouble(this.tipYKey);
            double d4 = jSONObject.getDouble(this.tipZKey);
            double d5 = jSONObject.getDouble(this.tipCompErrorKey);
            double d6 = jSONObject.getDouble(this.tipCompDateKey);
            double d7 = jSONObject.getDouble(this.tipCompTempKey);
            int n = jSONObject.getInt(this.tipTypeKey);
            int n2 = jSONObject.getInt(this.tipActiveKey);
            double d8 = 0.0;
            int n3 = jSONObject.getInt(this.tipCompensatedKey);
            int n4 = jSONObject.getInt(this.tipFactoryKey);
            ProbeCompHistoryData[] probeCompHistoryDataArray = null;
            if (jSONObject.has(this.compHistoryArrayKey)) {
                object = jSONObject.getJSONArray(this.compHistoryArrayKey);
                int n5 = object.length();
                probeCompHistoryDataArray = new ProbeCompHistoryData[n5];
                for (int i = 0; i < n5; ++i) {
                    ProbeCompHistoryData probeCompHistoryData;
                    JSONObject jSONObject2 = object.getJSONObject(i);
                    double d9 = jSONObject2.getDouble(this.tipDiameterKey);
                    double d10 = jSONObject2.getDouble(this.tipXKey);
                    double d11 = jSONObject2.getDouble(this.tipYKey);
                    double d12 = jSONObject2.getDouble(this.tipZKey);
                    double d13 = jSONObject2.getDouble(this.tipCompDateKey);
                    double d14 = jSONObject2.getDouble(this.tipCompTempKey);
                    double d15 = jSONObject2.getDouble(this.tipCompErrorKey);
                    boolean bl = jSONObject2.getInt(this.tipCompInUseKey) != 0;
                    probeCompHistoryDataArray[i] = probeCompHistoryData = new ProbeCompHistoryData(d9, d10, d11, d12, d15, d14, d13, bl);
                }
            }
            object = new Probe(string3, string, d, d2, d3, d4, d6, d7, 2, n2, d8, n3, n4, string2, d5, true);
            return object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private ProbeCompHistoryData[] getCompHistory(String string, String string2) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            JSONArray jSONArray = (JSONArray)jSONObject.get(this.compHistoryArrayKey);
            int n = jSONArray.length();
            ProbeCompHistoryData[] probeCompHistoryDataArray = new ProbeCompHistoryData[n];
            for (int i = 0; i < n; ++i) {
                ProbeCompHistoryData probeCompHistoryData;
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                double d = jSONObject2.getDouble(this.tipDiameterKey);
                double d2 = jSONObject2.getDouble(this.tipXKey);
                double d3 = jSONObject2.getDouble(this.tipYKey);
                double d4 = jSONObject2.getDouble(this.tipZKey);
                double d5 = jSONObject2.getDouble(this.tipCompDateKey);
                double d6 = jSONObject2.getDouble(this.tipCompTempKey);
                double d7 = jSONObject2.getDouble(this.tipCompErrorKey);
                boolean bl = jSONObject2.getInt(this.tipCompInUseKey) != 0;
                probeCompHistoryDataArray[i] = probeCompHistoryData = new ProbeCompHistoryData(d, d2, d3, d4, d7, d6, d5, bl);
            }
            return probeCompHistoryDataArray;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    private void updateFile(JSONObject jSONObject) {
        File file = new File(this.filePath);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(jSONObject.toString());
            fileWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String processCmd(String string) throws TrackerException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        TrackerCypher.writeFileContents(this.ftp, this.commandFile, arrayList);
        String string2 = TrackerCypher.readFileContents(this.ftp, this.responseFile);
        this.processResponse(string2);
        return string2;
    }

    private void processResponse(String string) throws TrackerException {
        int n = -1;
        try {
            n = Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        switch (n) {
            case 200: {
                return;
            }
            case 201: {
                throw new TrackerException(Tracker.res.getString("Invalid_Parameters_6Probe_2_0"));
            }
            case 202: {
                throw new TrackerException(Tracker.res.getString("No_Probe_Found_Serial_Num_6Probe_2_0"));
            }
            case 203: {
                throw new TrackerException(Tracker.res.getString("Probe_Name_Out_Of_Limit_6Probe_2_0"));
            }
            case 204: {
                throw new TrackerException(Tracker.res.getString("Probe_Diameter_Out_Of_Range_6Probe_2_0"));
            }
            case 205: {
                throw new TrackerException(Tracker.res.getString("Connot_Find_Comp_For_Time_6Probe_2_0"));
            }
            case 206: {
                throw new TrackerException(Tracker.res.getString("Command_Not_Found_6Probe_2_0"));
            }
            case 207: {
                throw new TrackerException(Tracker.res.getString("Cannot_Remove_Comp_In_Use_6Probe_2_0"));
            }
            case 208: {
                throw new TrackerException(Tracker.res.getString("No_Kinematic_Adapter_Connected_6Probe_2_0"));
            }
            case 209: {
                throw new TrackerException(Tracker.res.getString("Cannot_Add_Comp_Reached_Max_Limit_6Probe_2_0"));
            }
            case 210: {
                throw new TrackerException(Tracker.res.getString("No_Probes_6Probe_2_0"));
            }
            case 211: {
                throw new TrackerException(Tracker.res.getString("Cannot_Add_Comp_Already_Exists_6Probe_2_0"));
            }
            case 212: {
                throw new TrackerException(Tracker.res.getString("Probe_Adapter_Not_Connected"));
            }
            case 213: {
                throw new TrackerException(Tracker.res.getString("Probe_Adapter_Not_Ready"));
            }
            case 214: {
                throw new TrackerException(Tracker.res.getString("Failed_To_Update_Compensation_To_Probe"));
            }
        }
        throw new TrackerException(Tracker.res.getString("FARO_Trk_Exp") + "(" + Tracker.res.getString("Code") + ":" + n + ")");
    }

    private String processDebugTestCmd(String string) throws TrackerException {
        try {
            if (string.startsWith("all_tips")) {
                String string2 = this.readFileLocal(this.filePath);
                return string2;
            }
            String string3 = this.readFileLocal(this.filePath);
            JSONObject jSONObject = null;
            JSONArray jSONArray = null;
            int n = 0;
            if (!(string3.isEmpty() || string3.equals("") || string3.equals("{}"))) {
                jSONObject = new JSONObject(string3);
                jSONArray = (JSONArray)jSONObject.get(this.kinematicTipArrayName);
                n = jSONArray.length();
            }
            if (string.equals("active_tip")) {
                for (int i = 0; i < n; ++i) {
                    JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                    int n2 = jSONObject2.getInt(this.tipActiveKey);
                    if (n2 != 1) continue;
                    return jSONObject2.toString();
                }
                if (this.dummyProbe != null) {
                    JSONObject jSONObject3 = this.createProbeJsonObj(this.dummyProbe);
                    return jSONObject3.toString();
                }
                return String.valueOf(210);
            }
            if (string.startsWith("get_tip_by_serial")) {
                String[] stringArray = string.split(" ");
                if (n == 0) {
                    return String.valueOf(202);
                }
                for (int i = 0; i < n; ++i) {
                    JSONObject jSONObject4 = jSONArray.getJSONObject(i);
                    int n3 = jSONObject4.getInt(this.tipSrNumKey);
                    int n4 = Integer.parseInt(stringArray[1]);
                    if (n4 != n3) continue;
                    return jSONObject4.toString();
                }
                return String.valueOf(202);
            }
            if (string.startsWith("remove_by_serial")) {
                String[] stringArray = string.split(" ");
                if (n == 0) {
                    return String.valueOf(202);
                }
                for (int i = 0; i < n; ++i) {
                    JSONObject jSONObject5 = jSONArray.getJSONObject(i);
                    int n5 = jSONObject5.getInt(this.tipSrNumKey);
                    int n6 = Integer.parseInt(stringArray[1]);
                    if (n6 != n5) continue;
                    jSONArray.remove(i);
                    break;
                }
                this.updateFile(jSONObject);
            } else {
                if (string.startsWith("modify_tip")) {
                    if (n == 0) {
                        return String.valueOf(202);
                    }
                    String[] stringArray = string.split(" ");
                    for (int i = 0; i < n; ++i) {
                        JSONObject jSONObject6 = jSONArray.getJSONObject(i);
                        int n7 = jSONObject6.getInt(this.tipSrNumKey);
                        int n8 = Integer.parseInt(stringArray[1]);
                        if (n8 != n7) continue;
                        jSONObject6.put(this.tipNameKey, (Object)stringArray[2]);
                        jSONObject6.put(this.tipDiameterKey, Double.parseDouble(stringArray[3]));
                        break;
                    }
                    this.updateFile(jSONObject);
                    return String.valueOf(200);
                }
                if (string.startsWith("add_tip_comp")) {
                    String[] stringArray = string.split(" ");
                    boolean bl = false;
                    if (n > 0) {
                        for (int i = 0; i < n; ++i) {
                            JSONObject jSONObject7 = jSONArray.getJSONObject(i);
                            int n9 = jSONObject7.getInt(this.tipSrNumKey);
                            int n10 = Integer.parseInt(stringArray[1]);
                            if (n10 != n9) continue;
                            jSONObject7.put(this.tipCompensatedKey, 1);
                            if (stringArray[2].length() > 16) {
                                return String.valueOf(203);
                            }
                            if (Double.parseDouble(stringArray[3]) <= 0.0) {
                                return String.valueOf(204);
                            }
                            jSONObject7.put(this.tipNameKey, (Object)stringArray[2]);
                            jSONObject7.put(this.tipDiameterKey, Double.parseDouble(stringArray[3]));
                            jSONObject7.put(this.tipXKey, Double.parseDouble(stringArray[4]));
                            jSONObject7.put(this.tipYKey, Double.parseDouble(stringArray[5]));
                            jSONObject7.put(this.tipZKey, Double.parseDouble(stringArray[6]));
                            jSONObject7.put(this.tipCompErrorKey, Double.parseDouble(stringArray[7]));
                            jSONObject7.put(this.tipCompTempKey, Double.parseDouble(stringArray[8]));
                            jSONObject7.put(this.tipCompDateKey, Double.parseDouble(stringArray[9]));
                            if (!jSONObject7.has(this.compHistoryArrayKey)) continue;
                            JSONArray jSONArray2 = jSONObject7.getJSONArray(this.compHistoryArrayKey);
                            int n11 = jSONArray2.length();
                            for (int j = 0; j < n11; ++j) {
                                JSONObject jSONObject8 = jSONArray2.getJSONObject(j);
                                jSONObject8.put(this.tipCompInUseKey, 0);
                            }
                            JSONObject jSONObject9 = new JSONObject();
                            jSONObject9.put(this.tipDiameterKey, (Object)stringArray[3]);
                            jSONObject9.put(this.tipXKey, Double.parseDouble(stringArray[4]));
                            jSONObject9.put(this.tipYKey, Double.parseDouble(stringArray[5]));
                            jSONObject9.put(this.tipZKey, Double.parseDouble(stringArray[6]));
                            jSONObject9.put(this.tipCompErrorKey, Double.parseDouble(stringArray[7]));
                            jSONObject9.put(this.tipCompTempKey, Double.parseDouble(stringArray[8]));
                            jSONObject9.put(this.tipCompDateKey, Double.parseDouble(stringArray[9]));
                            jSONObject9.put(this.tipCompInUseKey, 1);
                            jSONArray2.put((Object)jSONObject9);
                            bl = true;
                            break;
                        }
                    }
                    if (!bl) {
                        JSONObject jSONObject10 = this.createProbeJsonObj(this.probe, Double.parseDouble(stringArray[4]), Double.parseDouble(stringArray[5]), Double.parseDouble(stringArray[6]), Double.parseDouble(stringArray[7]), Double.parseDouble(stringArray[8]), Double.parseDouble(stringArray[9]));
                        if (jSONObject == null) {
                            jSONObject = new JSONObject();
                            jSONArray = new JSONArray();
                            jSONArray.put((Object)jSONObject10);
                            jSONObject.put(this.kinematicTipArrayName, (Object)jSONArray);
                        } else {
                            jSONArray.put((Object)jSONObject10);
                        }
                    }
                    this.updateFile(jSONObject);
                    return String.valueOf(200);
                }
                if (string.startsWith("remove_tip_comp")) {
                    String[] stringArray = string.split(" ");
                    if (n == 0) {
                        return String.valueOf(202);
                    }
                    block9: for (int i = 0; i < n; ++i) {
                        JSONObject jSONObject11 = jSONArray.getJSONObject(i);
                        int n12 = jSONObject11.getInt(this.tipSrNumKey);
                        int n13 = Integer.parseInt(stringArray[1]);
                        if (n13 != n12 || !jSONObject11.has(this.compHistoryArrayKey)) continue;
                        JSONArray jSONArray3 = jSONObject11.getJSONArray(this.compHistoryArrayKey);
                        int n14 = jSONArray3.length();
                        for (int j = 0; j < n14; ++j) {
                            boolean bl;
                            JSONObject jSONObject12 = jSONArray3.getJSONObject(j);
                            double d = jSONObject12.getDouble(this.tipCompDateKey);
                            double d2 = Double.parseDouble(stringArray[2]);
                            if (d2 != d) continue;
                            boolean bl2 = bl = jSONObject12.getInt(this.tipCompInUseKey) != 0;
                            if (bl) {
                                return String.valueOf(207);
                            }
                            jSONArray3.remove(j);
                            continue block9;
                        }
                    }
                    this.updateFile(jSONObject);
                    return String.valueOf(200);
                }
                if (string.startsWith("use_tip_comp")) {
                    String[] stringArray = string.split(" ");
                    if (n == 0) {
                        return String.valueOf(202);
                    }
                    for (int i = 0; i < n; ++i) {
                        double d;
                        double d3;
                        JSONObject jSONObject13;
                        int n15;
                        JSONObject jSONObject14 = jSONArray.getJSONObject(i);
                        int n16 = jSONObject14.getInt(this.tipSrNumKey);
                        int n17 = Integer.parseInt(stringArray[1]);
                        if (n17 != n16 || !jSONObject14.has(this.compHistoryArrayKey)) continue;
                        JSONArray jSONArray4 = jSONObject14.getJSONArray(this.compHistoryArrayKey);
                        int n18 = jSONArray4.length();
                        for (n15 = 0; n15 < n18; ++n15) {
                            jSONObject13 = jSONArray4.getJSONObject(n15);
                            d3 = jSONObject13.getDouble(this.tipCompDateKey);
                            d = Double.parseDouble(stringArray[2]);
                            if (d != d3) continue;
                            double d4 = jSONObject13.getDouble(this.tipXKey);
                            double d5 = jSONObject13.getDouble(this.tipYKey);
                            double d6 = jSONObject13.getDouble(this.tipZKey);
                            double d7 = jSONObject13.getDouble(this.tipDiameterKey);
                            double d8 = jSONObject13.getDouble(this.tipCompDateKey);
                            double d9 = jSONObject13.getDouble(this.tipCompTempKey);
                            jSONObject14.put(this.tipXKey, d4);
                            jSONObject14.put(this.tipYKey, d5);
                            jSONObject14.put(this.tipZKey, d6);
                            jSONObject14.put(this.tipDiameterKey, d7);
                            jSONObject14.put(this.tipCompDateKey, d8);
                            jSONObject14.put(this.tipCompTempKey, d9);
                            jSONObject13.put(this.tipCompInUseKey, 1);
                            break;
                        }
                        for (n15 = 0; n15 < n18; ++n15) {
                            jSONObject13 = jSONArray4.getJSONObject(n15);
                            d3 = jSONObject13.getDouble(this.tipCompDateKey);
                            d = Double.parseDouble(stringArray[2]);
                            if (d == d3) continue;
                            jSONObject13.put(this.tipCompInUseKey, 0);
                        }
                    }
                    this.updateFile(jSONObject);
                } else if (string.startsWith("set_all_tips_inactive")) {
                    if (n == 0) {
                        return String.valueOf(202);
                    }
                    for (int i = 0; i < n; ++i) {
                        JSONObject jSONObject15 = jSONArray.getJSONObject(i);
                        int n19 = jSONObject15.getInt(this.tipActiveKey);
                        if (n19 != 1) continue;
                        jSONObject15.put(this.tipActiveKey, 0);
                    }
                    this.updateFile(jSONObject);
                } else if (string.startsWith("set_tip_active")) {
                    String[] stringArray = string.split(" ");
                    if (n == 0) {
                        return String.valueOf(202);
                    }
                    boolean bl = false;
                    for (int i = 0; i < n; ++i) {
                        JSONObject jSONObject16 = jSONArray.getJSONObject(i);
                        int n20 = jSONObject16.getInt(this.tipSrNumKey);
                        int n21 = Integer.parseInt(stringArray[1]);
                        if (n21 != n20) continue;
                        jSONObject16.put(this.tipActiveKey, 1);
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        return String.valueOf(202);
                    }
                    this.updateFile(jSONObject);
                } else if (string.startsWith("comp_by_serial")) {
                    String[] stringArray = string.split(" ");
                    if (n == 0) {
                        return String.valueOf(202);
                    }
                    for (int i = 0; i < n; ++i) {
                        JSONArray jSONArray5;
                        int n22;
                        JSONObject jSONObject17 = jSONArray.getJSONObject(i);
                        int n23 = jSONObject17.getInt(this.tipSrNumKey);
                        int n24 = Integer.parseInt(stringArray[1]);
                        if (n24 != n23 || !jSONObject17.has(this.compHistoryArrayKey) || (n22 = (jSONArray5 = jSONObject17.getJSONArray(this.compHistoryArrayKey)).length()) <= 0) continue;
                        JSONObject jSONObject18 = new JSONObject();
                        jSONObject18.put(this.compHistoryArrayKey, (Object)jSONArray5);
                        return jSONObject18.toString();
                    }
                    return String.valueOf(210);
                }
            }
            return String.valueOf(200);
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return String.valueOf(202);
    }

    protected Probe createDummyProbe(Probe probe) {
        this.dummyProbe = probe;
        return probe;
    }

    protected Probe getDummyProbe(String string, String string2) {
        return this.dummyProbe;
    }

    protected void setAllProbesToInactive() throws TrackerException {
        String string = this.processCmd("set_all_tips_inactive");
    }

    protected Probe getProbeBySerial(String string) throws TrackerException {
        String string2 = this.processCmd("get_tip_by_serial " + string);
        if (string2.equals(String.valueOf(202))) {
            throw new TrackerException(Tracker.res.getString("No_Active_Probe"));
        }
        JSONObject jSONObject = new JSONObject(string2);
        Probe probe = this.createProbe(jSONObject);
        if (probe == null) {
            throw new TrackerException(Tracker.res.getString("No_Active_Probe"));
        }
        return probe;
    }

    public Probe getProbeBySerialAndActive(String string) throws TrackerException {
        String string2 = this.processCmd("set_tip_active " + string);
        if (string2.equals(String.valueOf(202))) {
            throw new TrackerException(Tracker.res.getString("No_Active_Probe"));
        }
        string2 = this.processCmd("get_tip_by_serial " + string);
        if (string2.equals(String.valueOf(202))) {
            throw new TrackerException(Tracker.res.getString("No_Active_Probe"));
        }
        JSONObject jSONObject = new JSONObject(string2);
        Probe probe = this.createProbe(jSONObject);
        if (probe == null) {
            throw new TrackerException(Tracker.res.getString("No_Active_Probe"));
        }
        return probe;
    }

    private JSONObject createProbeJsonObj(Probe probe) {
        JSONObject jSONObject = new JSONObject();
        String[] stringArray = probe.getAdapterName().split(this.probeAdapterNamePrefix);
        jSONObject.put(this.probeSrNumKey, Long.parseLong(stringArray[1]));
        jSONObject.put(this.tipSrNumKey, Long.parseLong(probe.getSerialNumber()));
        jSONObject.put(this.tipNameKey, (Object)probe.getName());
        jSONObject.put(this.tipDiameterKey, probe.getDiameter());
        jSONObject.put(this.tipXKey, probe.getX());
        jSONObject.put(this.tipYKey, probe.getY());
        jSONObject.put(this.tipZKey, probe.getZ());
        jSONObject.put(this.tipCompErrorKey, probe.getError());
        jSONObject.put(this.tipCompDateKey, probe.getDateOfCalibration());
        jSONObject.put(this.tipCompTempKey, probe.getTemp());
        jSONObject.put(this.tipActiveKey, probe.active() ? 1 : 0);
        jSONObject.put(this.tipFactoryKey, 1);
        jSONObject.put(this.tipCompensatedKey, probe.compensated() ? 1 : 0);
        jSONObject.put(this.tipTypeKey, probe.type());
        jSONObject.put("TipVersion", 1);
        jSONObject.put("TipFlags", 25);
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put(this.tipXKey, probe.getX());
        jSONObject2.put(this.tipYKey, probe.getY());
        jSONObject2.put(this.tipZKey, probe.getZ());
        jSONObject2.put(this.tipDiameterKey, probe.getDiameter());
        jSONObject2.put(this.tipCompErrorKey, probe.getError());
        jSONObject2.put(this.tipCompDateKey, probe.getDateOfCalibration());
        jSONObject2.put(this.tipCompTempKey, probe.getTemp());
        jSONObject2.put(this.tipCompInUseKey, 0);
        JSONArray jSONArray = new JSONArray();
        jSONArray.put((Object)jSONObject2);
        jSONObject.put(this.compHistoryArrayKey, (Object)jSONArray);
        return jSONObject;
    }

    private JSONObject createProbeJsonObj(Probe probe, double d, double d2, double d3, double d4, double d5, double d6) {
        JSONObject jSONObject = new JSONObject();
        String[] stringArray = probe.getAdapterName().split(this.probeAdapterNamePrefix);
        jSONObject.put(this.probeSrNumKey, Long.parseLong(stringArray[1]));
        jSONObject.put(this.tipSrNumKey, Long.parseLong(probe.getSerialNumber()));
        jSONObject.put(this.tipNameKey, (Object)probe.getName());
        jSONObject.put(this.tipDiameterKey, probe.getDiameter());
        jSONObject.put(this.tipXKey, d);
        jSONObject.put(this.tipYKey, d2);
        jSONObject.put(this.tipZKey, d3);
        jSONObject.put(this.tipCompErrorKey, d4);
        jSONObject.put(this.tipCompDateKey, d6);
        jSONObject.put(this.tipCompTempKey, d5);
        jSONObject.put(this.tipActiveKey, probe.active() ? 1 : 0);
        jSONObject.put(this.tipFactoryKey, 1);
        jSONObject.put(this.tipCompensatedKey, 1);
        jSONObject.put(this.tipTypeKey, probe.type());
        jSONObject.put("TipVersion", 1);
        jSONObject.put("TipFlags", 25);
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put(this.tipXKey, d);
        jSONObject2.put(this.tipYKey, d2);
        jSONObject2.put(this.tipZKey, d3);
        jSONObject2.put(this.tipDiameterKey, probe.getDiameter());
        jSONObject2.put(this.tipCompErrorKey, d4);
        jSONObject2.put(this.tipCompDateKey, d6);
        jSONObject2.put(this.tipCompTempKey, d5);
        jSONObject2.put(this.tipCompInUseKey, 1);
        JSONArray jSONArray = new JSONArray();
        jSONArray.put((Object)jSONObject2);
        jSONObject.put("CompHistory", (Object)jSONArray);
        return jSONObject;
    }

    private String getProbeSerialNum(String string) {
        String string2 = "";
        int n = 7 - string.length();
        for (int i = 0; i < n; ++i) {
            string2 = string2 + "0";
        }
        String string3 = this.probeAdapterNamePrefix + string2 + string;
        return string3;
    }

    public static void main(String[] stringArray) {
        try {
            ProbeKinematicParser probeKinematicParser = new ProbeKinematicParser(null);
            Probe[] probeArray = probeKinematicParser.availableProbes();
            ProbeCompHistoryData[] probeCompHistoryDataArray = probeKinematicParser.probeCompHistory(probeArray[0]);
            probeKinematicParser.useProbeComp(probeArray[0], probeCompHistoryDataArray[0].getTime());
        }
        catch (TrackerException trackerException) {
            // empty catch block
        }
    }
}

