/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.DatagramPacket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import smx.tracker.CypherInfo;
import smx.tracker.NetworkCardInfo;
import smx.tracker.TrackerReachable;
import smx.tracker.TrkInfo;
import smx.tracker.VantageIonInfo;

public class FindTrackers {
    public static final int PACKET_LENGTH = 300;
    public static final int TIMEOUT = 1000;
    public static final int PORT = 4000;
    public static final int MULTICAST_TTL = 32;
    public static final int OLD_PORT = 4000;
    public static final String OLD_GROUP = "224.0.0.40";
    public static final int NEW_PORT = 54000;
    public static final String NEW_GROUP = "239.0.0.40";
    protected static final String OLD_RESP = "Tracker IP Resp";
    protected static final String NEW_RESP = "TrackerV2 network response";
    public static String LEGACY_BROADCAST_NAME = "Legacy_Broadcast";
    public static String WIRED_BROADCAST_NAME = "Wired_Broadcast";
    public static String WIFI_BROADCAST_NAME = "WiFi_Broadcast";
    private Vector<Object[]> dpVectorList = new Vector(10);
    private Vector<NetworkCardInfo> NICAddrs = new Vector(10);
    private PrintWriter debugWriter = null;
    private boolean findReachableTrks = true;
    public static final int NO_WIFI = 0;
    public static final int WIFI_ON = 1;
    public static final int WIFI_OFF = 2;
    Vector<NetworkCardInfo> networkCardsList = new Vector(10);
    String serialNum = "";
    private int THREAD_TIMEOUT = 10;

    public FindTrackers(PrintWriter printWriter) {
        this(printWriter, "", false);
    }

    public FindTrackers(PrintWriter printWriter, String string, boolean bl) {
        this.debugWriter = printWriter;
        this.serialNum = string;
        this.findReachableTrks = bl;
    }

    public static void main(String[] stringArray) {
        try {
            FindTrackers findTrackers = new FindTrackers(null, "1119", false);
            long l = System.currentTimeMillis();
            Vector[] vectorArray = findTrackers.findTrackers();
            long l2 = System.currentTimeMillis();
            Vector vector = vectorArray[0];
            int n = vector.size();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Vector[] findTrackers() throws Exception {
        Vector<NetworkCardInfo> vector;
        block4: {
            this.dpVectorList.clear();
            vector = this.getNICsHostAddressesAndSubNets();
            int n = vector.size();
            if (n == 0) {
                throw new IOException();
            }
            this.logLine("NUm Cards: " + n);
            this.logLine("-----------------------------------------------------------------");
            int n2 = 3;
            int n3 = n2 * n;
            final CountDownLatch countDownLatch = new CountDownLatch(n3);
            ExecutorService executorService = Executors.newFixedThreadPool(n2);
            executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        String string = "Tracker IP Address Identification";
                        InetAddress inetAddress = InetAddress.getByName(FindTrackers.OLD_GROUP);
                        FindTrackers.this.findTrackersThreads(string, inetAddress, 4000, vector, "", LEGACY_BROADCAST_NAME, countDownLatch);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        String string = "TrackerV2 network command all get eth1";
                        InetAddress inetAddress = InetAddress.getByName(FindTrackers.NEW_GROUP);
                        FindTrackers.this.findTrackersThreads(string, inetAddress, 54000, vector, "", WIRED_BROADCAST_NAME, countDownLatch);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        String string = "TrackerV2 network command all get wlan0";
                        InetAddress inetAddress = InetAddress.getByName(FindTrackers.NEW_GROUP);
                        FindTrackers.this.findTrackersThreads(string, inetAddress, 54000, vector, "", WIFI_BROADCAST_NAME, countDownLatch);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            executorService.shutdown();
            while (!executorService.isTerminated()) {
            }
            try {
                countDownLatch.await(this.THREAD_TIMEOUT, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                if (this.debugWriter == null) break block4;
                interruptedException.printStackTrace(this.debugWriter);
            }
        }
        this.logLine("Done waiting for all threads");
        Vector<TrkInfo> vector2 = this.getTrackerInfo(this.serialNum, vector);
        return new Vector[]{vector2, this.networkCardsList};
    }

    private void findTrackers(String string, InetAddress inetAddress, int n, Vector<NetworkCardInfo> vector, String string2, String string3) throws IOException {
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            this.findTrackersAndAddToList(vector, string, inetAddress, n, string2, string3, i);
        }
    }

    private void findTrackersThreads(String string, InetAddress inetAddress, int n, Vector<NetworkCardInfo> vector, String string2, String string3, CountDownLatch countDownLatch) throws IOException {
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            new FindTrackerThread(string, inetAddress, n, vector, string2, string3 + "_" + (i + 1), i, countDownLatch);
        }
    }

    private void findTrackersAndAddToList(Vector<NetworkCardInfo> vector, String string, InetAddress inetAddress, int n, String string2, String string3, int n2) {
        try {
            NetworkCardInfo networkCardInfo = vector.elementAt(n2);
            InetAddress inetAddress2 = networkCardInfo.getIPAddress();
            String string4 = inetAddress2.getHostAddress();
            string4 = string4.substring(0, string4.lastIndexOf("."));
            MulticastSocket multicastSocket = this.sendPacket(string, inetAddress, inetAddress2, n);
            boolean bl = false;
            while (!bl) {
                try {
                    byte[] byArray = new byte[300];
                    DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                    multicastSocket.receive(datagramPacket);
                    if (datagramPacket == null) continue;
                    this.addToList(string4, datagramPacket, inetAddress2.getHostAddress(), networkCardInfo.getSubNet(), networkCardInfo.getNetworkInterface(), string2);
                    datagramPacket = null;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    bl = true;
                }
            }
            multicastSocket.leaveGroup(inetAddress);
            multicastSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private synchronized void addToList(String string, DatagramPacket datagramPacket, String string2, String string3, NetworkInterface networkInterface, String string4) {
        boolean bl = false;
        string = string.substring(0, string.lastIndexOf("."));
        String string5 = new String(datagramPacket.getData());
        if (string5.startsWith(OLD_RESP) || string5.startsWith(NEW_RESP)) {
            if (string4.equals(networkInterface.getDisplayName())) {
                bl = true;
            }
            this.logLine(string5.replaceAll("\n", "").trim());
            String string6 = "Fail";
            String string7 = "Invalid Format";
            if (string5.startsWith(NEW_RESP) && (string5.contains(string6) || string5.contains(string7))) {
                return;
            }
            String string8 = this.getTrackerIpAddress(string5);
            boolean bl2 = false;
            if (this.findReachableTrks && !string8.equals("None")) {
                string8 = string8.substring(0, string8.lastIndexOf("."));
                if (string.equals(string8 = string8.substring(0, string8.lastIndexOf(".")))) {
                    bl2 = true;
                }
            } else {
                bl2 = true;
            }
            if (bl2) {
                string5 = string5.replaceAll("\n", "");
                this.dpVectorList.add(new Object[]{string5, string2, string3, networkInterface, Thread.currentThread().getName(), bl});
            }
        }
    }

    private Vector<NetworkCardInfo> getNICsHostAddressesAndSubNets() throws SocketException {
        this.logLine("-----------------------------------------------------------------");
        Vector<NetworkCardInfo> vector = new Vector<NetworkCardInfo>(10, 1);
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            if (!networkInterface.isUp()) continue;
            Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
            while (enumeration2.hasMoreElements()) {
                InetAddress inetAddress = enumeration2.nextElement();
                if (inetAddress instanceof Inet6Address || inetAddress.isLoopbackAddress()) continue;
                short s = networkInterface.getInterfaceAddresses().get(0).getNetworkPrefixLength();
                String string = this.getSubnetMask(s);
                vector.addElement(new NetworkCardInfo(inetAddress, string, networkInterface));
            }
        }
        return vector;
    }

    private MulticastSocket sendPacket(String string, InetAddress inetAddress, InetAddress inetAddress2, int n) throws IOException {
        MulticastSocket multicastSocket = new MulticastSocket(n);
        multicastSocket.setLoopbackMode(false);
        multicastSocket.setTimeToLive(32);
        multicastSocket.setInterface(inetAddress2);
        multicastSocket.joinGroup(inetAddress);
        DatagramPacket datagramPacket = new DatagramPacket(string.getBytes(), string.length(), inetAddress, n);
        multicastSocket.send(datagramPacket);
        multicastSocket.setSoTimeout(1000);
        return multicastSocket;
    }

    private String getTrackerIpAddress(String string) {
        String string2;
        String[] stringArray;
        String string3 = "";
        if (string.startsWith(OLD_RESP)) {
            String string4 = FindTrackers.getLegacyTrkInfo(string, OLD_RESP);
            String string5 = string4.substring(OLD_RESP.length() + 1, string4.length());
            String[] stringArray2 = string5.split(" ");
            if (stringArray2.length > 1) {
                string3 = stringArray2[1];
            }
        } else if (string.startsWith(NEW_RESP) && (stringArray = (string2 = string.substring(NEW_RESP.length() + 1, string.length())).split(" ")).length > 4) {
            string3 = stringArray[4];
        }
        return string3;
    }

    private String getSubnetMask(int n) {
        int n2 = -1 << 32 - n;
        int n3 = (byte)((n2 & 0xFF000000) >> 24) & 0xFF;
        int n4 = (byte)((n2 & 0xFF0000) >> 16) & 0xFF;
        int n5 = (byte)((n2 & 0xFF00) >> 8) & 0xFF;
        int n6 = (byte)(n2 & 0xFF) & 0xFF;
        String string = n3 + "." + n4 + "." + n5 + "." + n6;
        return string;
    }

    private void logLine(String string) {
        if (this.debugWriter != null) {
            this.debugWriter.println(string);
        }
    }

    private Vector<TrkInfo> getTrackerInfo(Vector<NetworkCardInfo> vector) throws Exception {
        return this.getTrackerInfo(null, vector);
    }

    private Vector<TrkInfo> getTrackerInfo(String string, Vector<NetworkCardInfo> vector) throws Exception {
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this.logLine("---------------------------------------------------------------");
        int n = this.dpVectorList.size();
        HashMap<Object, Integer> hashMap2 = new HashMap<Object, Integer>();
        for (int i = 0; i < n; ++i) {
            Object object5;
            boolean bl2;
            Object object6;
            object4 = this.dpVectorList.get(i);
            String hashMap4 = (String)object4[1];
            object3 = (String)object4[2];
            String string2 = (String)object4[0];
            if (!string2.startsWith(NEW_RESP) && !string2.startsWith(OLD_RESP)) continue;
            if (string2.startsWith(OLD_RESP)) {
                String string3 = FindTrackers.getLegacyTrkInfo(string2, OLD_RESP);
                object2 = string3.substring(OLD_RESP.length() + 1, string3.length()).trim();
                object = ((String)object2).split(",");
                String string4 = "";
                object6 = "";
                String string5 = "";
                String string6 = "";
                String string7 = "";
                bl2 = false;
                int n2 = 0;
                int n3 = 0;
                if (((Object)object).length <= 2) continue;
                String string8 = ((String)object[0]).trim();
                string4 = ((String)object[1]).trim();
                object6 = ((String)object[2]).trim();
                if (((Object)object).length > 3) {
                    string5 = ((String)object[3]).trim();
                    if (string5.equals("WIFI_ON") || string5.equals("WIFI_OFF")) {
                        bl2 = string5.equals("WIFI_ON") ? true : 2 != 0;
                        n2 = 1;
                    }
                    if (string5.equals("WIFI_ON")) {
                        n3 = 1;
                    }
                }
                if (((Object)object).length > 4) {
                    string6 = ((String)object[4]).trim();
                }
                if (((Object)object).length > 5) {
                    string7 = ((String)object[5]).trim();
                }
                object5 = new VantageIonInfo(string8, string4, (String)object6, bl2 ? 1 : 0, string6, string7, hashMap4, (String)object3, (NetworkInterface)object4[3], (String)object4[4], (String)object4[0], TrkInfo.LEGACY_PACKET, n2, n3);
                hashMap2.put(object5, Integer.parseInt(string8));
                continue;
            }
            if (!string2.startsWith(NEW_RESP)) continue;
            int n4 = 0;
            object = string2.substring(NEW_RESP.length() + 1, string2.length()).trim();
            int n5 = ((String)object).indexOf(" ");
            object6 = ((String)object).split(" ");
            int n6 = 1;
            if (object6[2].trim().equalsIgnoreCase("True")) {
                n6 = 2;
            }
            int n7 = TrkInfo.CYPHER_WIRED_PACKET;
            boolean bl3 = false;
            bl2 = false;
            String string9 = null;
            if (object6[1].trim().equalsIgnoreCase("wlan0")) {
                n4 = 1;
                n7 = TrkInfo.CYPHER_WIFI_PACKET;
                if (object6[8].trim().equalsIgnoreCase("True")) {
                    bl3 = true;
                }
                if (object6[9].trim().equalsIgnoreCase("True")) {
                    bl2 = true;
                }
                if (((String[])object6).length > 10 && !object6[10].trim().equalsIgnoreCase("None")) {
                    string9 = object6[10].trim();
                }
            }
            String string10 = "";
            boolean bl4 = false;
            object5 = "";
            bl = true;
            boolean bl5 = false;
            boolean bl6 = true;
            int n8 = 0;
            int n9 = 11;
            if (((String[])object6).length > n9) {
                bl5 = true;
                for (int j = n9; j < ((String[])object6).length; ++j) {
                    String[] stringArray = object6[j].split(":");
                    if (stringArray.length <= 1) continue;
                    String string11 = stringArray[0];
                    if (string11.equalsIgnoreCase("ssid")) {
                        string10 = stringArray[1];
                        continue;
                    }
                    if (string11.equalsIgnoreCase("wifi_state")) {
                        bl4 = stringArray[1].equalsIgnoreCase("up");
                        continue;
                    }
                    if (string11.equalsIgnoreCase("type")) {
                        object5 = stringArray[1];
                        continue;
                    }
                    if (string11.equalsIgnoreCase("enet1")) {
                        bl = stringArray[1].equalsIgnoreCase("1");
                        continue;
                    }
                    if (string11.equalsIgnoreCase("sessions")) {
                        bl6 = stringArray[1].equalsIgnoreCase("1");
                        continue;
                    }
                    if (!string11.equalsIgnoreCase("serial_type")) continue;
                    n8 = Integer.parseInt(stringArray[1]);
                }
            }
            CypherInfo cypherInfo = new CypherInfo(object6[0].trim(), object6[4].trim(), object6[5].trim(), n6, bl2, string9, bl3, hashMap4, (String)object3, (NetworkInterface)object4[3], (String)object4[4], (String)object4[0], string10, bl4, (String)object5, bl, bl5, bl6, n7, 2, n4, n8);
            hashMap2.put(cypherInfo, Integer.parseInt(object6[0].trim()));
        }
        HashMap hashMap3 = new HashMap();
        for (Map.Entry entry : hashMap2.entrySet()) {
            object3 = new ArrayList();
            if (hashMap3.containsKey(entry.getValue())) {
                object3 = (List)hashMap3.get(entry.getValue());
            }
            object3.add(entry.getKey());
            hashMap3.put(entry.getValue(), object3);
        }
        object4 = new Vector();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Map.Entry entry : hashMap3.entrySet()) {
            int n10;
            Object object7;
            object2 = (List)entry.getValue();
            object = new ArrayList();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n11 = object2.size();
            for (int i = 0; i < n11; ++i) {
                object7 = (TrkInfo)object2.get(i);
                if (((TrkInfo)object7).getPacketType() == TrkInfo.LEGACY_PACKET) {
                    hashMap.put(((TrkInfo)object7).getSrNum(), object7);
                    continue;
                }
                if (((TrkInfo)object7).getPacketType() == TrkInfo.CYPHER_WIRED_PACKET) {
                    ((ArrayList)object).add(object7);
                    continue;
                }
                if (((TrkInfo)object7).getPacketType() != TrkInfo.CYPHER_WIFI_PACKET) continue;
                arrayList.add(object7);
            }
            ArrayList<TrkInfo> arrayList2 = new ArrayList<TrkInfo>();
            object7 = new ArrayList();
            ArrayList<TrkInfo> arrayList3 = new ArrayList<TrkInfo>();
            ArrayList<TrkInfo> arrayList4 = new ArrayList<TrkInfo>();
            int n12 = ((ArrayList)object).size();
            for (n10 = 0; n10 < n12; ++n10) {
                TrkInfo trkInfo = (TrkInfo)((ArrayList)object).get(n10);
                boolean bl7 = FindTrackers.checkIfIPaddressAreWithinSameSubnet(trkInfo.getIpAdd(), trkInfo.getIpMask(), trkInfo.getNetworkCardIpAdd(), trkInfo.getNetworkCardIpMask());
                if (bl7) {
                    arrayList2.add(trkInfo);
                    continue;
                }
                ((ArrayList)object7).add(trkInfo);
            }
            n10 = arrayList.size();
            for (int i = 0; i < n10; ++i) {
                TrkInfo trkInfo = (TrkInfo)arrayList.get(i);
                bl = FindTrackers.checkIfIPaddressAreWithinSameSubnet(trkInfo.getIpAdd(), trkInfo.getIpMask(), trkInfo.getNetworkCardIpAdd(), trkInfo.getNetworkCardIpMask());
                if (bl) {
                    arrayList3.add(trkInfo);
                    continue;
                }
                arrayList4.add(trkInfo);
            }
            if (arrayList2.size() > 0) {
                ((Vector)object4).add((TrkInfo)arrayList2.get(0));
            } else if (((ArrayList)object7).size() > 0) {
                ((Vector)object4).add((TrkInfo)((ArrayList)object7).get(0));
            }
            if (arrayList3.size() > 0) {
                ((Vector)object4).add((TrkInfo)arrayList3.get(0));
                continue;
            }
            if (arrayList4.size() <= 0) continue;
            ((Vector)object4).add((TrkInfo)arrayList4.get(0));
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            ((Vector)object4).add(entry.getValue());
        }
        this.sortNetworkCards(vector, (Vector<TrkInfo>)object4);
        object3 = new Vector();
        int n13 = ((Vector)object4).size();
        if (!string.equals("")) {
            for (int i = 0; i < n13; ++i) {
                String string12;
                int n14;
                int n15;
                int n16;
                object = (TrkInfo)((Vector)object4).get(new Integer(i));
                String string13 = ((TrkInfo)object).getSrNum();
                String string14 = string13.substring((n16 = string13.length()) - (n15 = Math.min(n16, n14 = string.length())), n16);
                if (!string14.equalsIgnoreCase(string12 = string.substring(n14 - n15, n14))) continue;
                ((Vector)object3).add(object);
            }
        } else {
            object3 = object4;
        }
        int n17 = ((Vector)object3).size();
        TrackerReachable trackerReachable = new TrackerReachable((Vector<TrkInfo>)object3, this.networkCardsList, this.debugWriter);
        trackerReachable.checkIfTrackersReachable();
        return object3;
    }

    public static String getLegacyTrkInfo(String string, String string2) {
        String string3 = string2 + ",";
        if (string.startsWith(string2)) {
            int n = 0;
            String string4 = string.substring(16, string.length());
            int n2 = 16;
            String string5 = string4.substring(n2 * 0, n2 * 1).trim();
            String string6 = string4.substring(n2 * 1, n2 * 2).trim();
            String string7 = string4.substring(n2 * 2, n2 * 3).trim();
            long l = FindTrackers.StringToLong(string7);
            string3 = string3 + l + "," + string5 + "," + string6;
            String string8 = "";
            String string9 = "";
            int n3 = string4.length();
            if (n3 > 48) {
                String string10 = string4.substring(n2 * 3, n2 * 4).trim();
                string10 = string10.trim();
                string3 = string3 + "," + string10;
                if (string10.equals("WIFI_ON") || string10.equals("WIFI_OFF")) {
                    n = string10.equals("WIFI_ON") ? 1 : 2;
                    String string11 = string4.substring(n2 * 4, n2 * 5).trim();
                    string3 = string3 + "," + string11;
                    if (string10.equals("WIFI_ON")) {
                        string5 = string11;
                    }
                    string8 = string4.substring(n2 * 5, n2 * 6).trim();
                    if (string4.length() > n2 * 6) {
                        string9 = string4.substring(n2 * 6, n3).trim();
                        string3 = string3 + "," + string9;
                    }
                }
            }
        }
        return string3;
    }

    public static long StringToLong(String string) {
        int[] nArray = new int[4];
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            nArray[n++] = Integer.parseInt(stringTokenizer.nextToken());
        }
        long l = 0L;
        for (n = 0; n < 4; ++n) {
            l = (long)((double)l + (double)nArray[3 - n] * Math.pow(256.0, n));
        }
        return l;
    }

    public static boolean checkIfIPaddressAreWithinSameSubnet(String string, String string2, String string3, String string4) {
        int n;
        if (string.equalsIgnoreCase("None") || string2.equalsIgnoreCase("None")) {
            return false;
        }
        String[] stringArray = string.split("\\.");
        String[] stringArray2 = string3.split("\\.");
        String[] stringArray3 = string2.split("\\.");
        String[] stringArray4 = string4.split("\\.");
        int n2 = stringArray.length;
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        String string5 = "";
        String string6 = "";
        for (n = 0; n < n2; ++n) {
            nArray[n] = Integer.parseInt(stringArray[n]) & Integer.parseInt(stringArray3[n]);
            nArray2[n] = Integer.parseInt(stringArray2[n]) & Integer.parseInt(stringArray4[n]);
            string5 = string5 + nArray[n];
            string6 = string6 + nArray2[n];
            if (n >= 3) continue;
            string5 = string5 + ".";
            string6 = string6 + ".";
        }
        n = 1;
        for (int i = 0; i < 2; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            n = 0;
        }
        return n != 0;
    }

    private boolean checkIfIPaddressAreWithinSameSubnet(TrkInfo trkInfo) {
        return FindTrackers.checkIfIPaddressAreWithinSameSubnet(trkInfo, trkInfo.getNetworkCardIpAdd(), trkInfo.getNetworkCardIpMask());
    }

    private static boolean checkIfIPaddressAreWithinSameSubnet(TrkInfo trkInfo, String string, String string2) {
        String string3 = trkInfo.getIpAdd();
        String string4 = trkInfo.getIpMask();
        if (trkInfo instanceof VantageIonInfo) {
            if (((VantageIonInfo)trkInfo).getWifiMode() == 1) {
                string3 = ((VantageIonInfo)trkInfo).getWifiIp();
            }
        } else if (trkInfo instanceof CypherInfo && (string3.equalsIgnoreCase("None") || string4.equalsIgnoreCase("None"))) {
            return false;
        }
        return FindTrackers.checkIfIPaddressAreWithinSameSubnet(string3, trkInfo.getIpMask(), string, string2);
    }

    private ReachableInfo checkIfTrackersHaveSameIP(TrkInfo trkInfo, Vector<TrkInfo> vector) {
        String string;
        Object object;
        boolean bl = false;
        int n = vector.size();
        String string2 = "";
        String string3 = "";
        if (trkInfo instanceof VantageIonInfo) {
            string2 = ((VantageIonInfo)trkInfo).getSrNum();
            string3 = ((VantageIonInfo)trkInfo).getIpAdd();
        }
        if (trkInfo instanceof CypherInfo) {
            string2 = ((CypherInfo)trkInfo).getSrNum();
            string3 = ((CypherInfo)trkInfo).getIpAdd();
        }
        for (int i = 0; i < n && !bl; ++i) {
            TrkInfo trkInfo2;
            object = vector.get(new Integer(i));
            string = "";
            String string4 = "";
            if (object instanceof VantageIonInfo) {
                trkInfo2 = (VantageIonInfo)object;
                if (((VantageIonInfo)trkInfo2).getWifiMode() == 1) continue;
                string = trkInfo2.getSrNum();
                string4 = trkInfo2.getIpAdd();
            }
            if (object instanceof CypherInfo) {
                trkInfo2 = (CypherInfo)object;
                if (trkInfo2.getPacketType() == TrkInfo.CYPHER_WIFI_PACKET) continue;
                string = trkInfo2.getSrNum();
                string4 = trkInfo2.getIpAdd();
            }
            if (string2.equals(string) || !string3.equals(string4)) continue;
            bl = true;
        }
        REACHABLE_STATE rEACHABLE_STATE = bl ? REACHABLE_STATE.NO : REACHABLE_STATE.YES;
        object = bl ? "Duplicate IP" : "N/A";
        string = bl ? "Resolve IP Conflict" : "N/A";
        return new ReachableInfo(rEACHABLE_STATE, (String)object, string);
    }

    private void sortNetworkCards(Vector<NetworkCardInfo> vector, Vector<TrkInfo> vector2) {
        Object object;
        int n = vector2.size();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i = 0; i < n; ++i) {
            String string;
            TrkInfo object2 = vector2.get(i);
            object = object2.getNetworkInterface();
            if (object == null || hashMap.containsKey(string = ((NetworkInterface)object).getDisplayName())) continue;
            hashMap.put(((NetworkInterface)object).getDisplayName(), object);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object = (String)entry.getKey();
            for (int i = 0; i < vector.size(); ++i) {
                NetworkCardInfo networkCardInfo = vector.get(i);
                NetworkInterface networkInterface = networkCardInfo.getNetworkInterface();
                if (!networkInterface.getDisplayName().equals(object)) continue;
                this.networkCardsList.add(networkCardInfo);
            }
        }
    }

    static enum REACHABLE_STATE {
        NONE,
        YES,
        NO;

    }

    class ReachableInfo {
        REACHABLE_STATE state;
        String details;
        String recommendation;

        ReachableInfo(REACHABLE_STATE rEACHABLE_STATE, String string, String string2) {
            this.state = rEACHABLE_STATE;
            this.details = string;
            this.recommendation = string2;
        }

        public REACHABLE_STATE getReachableState() {
            return this.state;
        }

        public String getDetails() {
            return this.details;
        }

        public String getRecommendation() {
            return this.recommendation;
        }
    }

    private class FindTrackerThread
    implements Runnable {
        String msg;
        InetAddress group;
        int port;
        Vector<NetworkCardInfo> NICAddrs;
        String wifiCardName;
        String threadName;
        int x;
        CountDownLatch latch;

        public FindTrackerThread(String string, InetAddress inetAddress, int n, Vector<NetworkCardInfo> vector, String string2, String string3, int n2, CountDownLatch countDownLatch) {
            this.msg = string;
            this.group = inetAddress;
            this.port = n;
            this.NICAddrs = vector;
            this.x = n2;
            this.threadName = string3;
            this.wifiCardName = string2;
            this.latch = countDownLatch;
            Thread thread = new Thread((Runnable)this, this.threadName);
            thread.setDaemon(true);
            thread.start();
        }

        @Override
        public void run() {
            String string = Thread.currentThread().getName();
            FindTrackers.this.findTrackersAndAddToList(this.NICAddrs, this.msg, this.group, this.port, this.wifiCardName, string, this.x);
            if (this.latch != null) {
                this.latch.countDown();
            }
        }
    }
}

