/*
 * Decompiled with CFR 0.152.
 */
package smx.ftp;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.util.Date;
import smx.ftp.Ftp;
import smx.ftp.FtpAbortedException;
import smx.ftp.FtpBusyException;
import smx.ftp.FtpDataSocketException;
import smx.ftp.FtpException;
import smx.ftp.FtpIOException;
import smx.ftp.FtpNoResponseException;
import smx.ftp.FtpNotConnectedException;
import smx.utility.PortUtility;

public class CypherFtp
extends Ftp {
    public static final int COMMAND_NOT_FOUND = 563;
    public static final int SESSION_NOT_FOUND = 564;
    public static final int CANNOT_OPEN_DATA_CONNECTION = 425;

    public CypherFtp(boolean bl) {
        super(bl);
    }

    public CypherFtp() {
        super(false);
    }

    public CypherFtp(PortUtility portUtility) {
        this(null, portUtility);
    }

    public CypherFtp(PrintWriter printWriter, PortUtility portUtility) {
        super(printWriter, portUtility);
        this.debugWriter = printWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int responseOnly(int n) throws FtpException {
        int n2 = -1;
        try {
            n2 = this.callGetAbortableResponse(n);
        }
        catch (FtpAbortedException ftpAbortedException) {
        }
        catch (FtpNotConnectedException ftpNotConnectedException) {
            this.commandState = 0;
            throw new FtpIOException();
        }
        catch (FtpException ftpException) {
            this.commandState = 0;
            throw ftpException;
        }
        CypherFtp cypherFtp = this;
        synchronized (cypherFtp) {
            if (2 == this.commandState) {
                CypherFtp cypherFtp2 = this;
                synchronized (cypherFtp2) {
                    this.commandState = 3;
                    this.notify();
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                throw new FtpAbortedException();
            }
            this.commandState = 0;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int endTransfer(int n) throws FtpException {
        int n2;
        CypherFtp cypherFtp = this;
        synchronized (cypherFtp) {
            if (null != this.dataSocket) {
                try {
                    this.dataSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        try {
            n2 = this.callGetAbortableResponse(n);
        }
        finally {
            cypherFtp = this;
            synchronized (cypherFtp) {
                if (null != this.dataSocket) {
                    this.cleanDataSocket();
                }
            }
        }
        return n2;
    }

    public int commandIgnoreDataSocket(String string, int n) throws FtpException {
        this.commandOnlyIgnoreDataSocket(string);
        int n2 = this.responseOnly(n);
        if (n2 != 200) {
            this.logLine("Cypher FTP NOOP response: " + n2 + " " + new Date().toString());
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commandOnlyIgnoreDataSocket(String string) throws FtpException {
        CypherFtp cypherFtp = this;
        synchronized (cypherFtp) {
            if (null == this.commandSocket) {
                throw new FtpNotConnectedException();
            }
            if (0 != this.commandState) {
                this.logLine("FtpBusyException Cypher FTP commandOnlyIgnoreDataSocket " + new Date().toString());
                throw new FtpBusyException();
            }
            this.flushOldResponses();
            this.sendCommand(string);
            this.commandState = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnectBeforeReconnect() throws FtpException {
        this.logLine("In of Cypher FTP disconnectBeforeReconnect: " + new Date().toString());
        try {
            CypherFtp cypherFtp = this;
            synchronized (cypherFtp) {
                if (null != this.dataSocket) {
                    try {
                        this.logLine("datasocket close before Cypher FTP ");
                        this.dataSocket.close();
                        this.logLine("datasocket close after Cypher FTP");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.cleanDataSocket();
                }
            }
        }
        finally {
            if (this.commandSocket != null) {
                try {
                    this.logLine("commandSocket close before Cypher FTP");
                    this.commandSocket.close();
                    this.logLine("commandSocket close after Cypher FTP");
                }
                catch (IOException iOException) {}
                this.commandSocket = null;
                this.commandInput = null;
                this.commandOutput = null;
                if (this.portUtility != null && this.portUtility.useCustomPort()) {
                    this.logLine("closePort " + this.cmdPort);
                    this.portUtility.closePort(this.cmdPort);
                }
            }
        }
        this.logLine("Out of disconnectBeforeReconnect Cypher FTP: " + new Date().toString());
    }

    public int getAbortableResponse(int n) throws FtpException {
        int n2 = 0 != n ? n : 500;
        long l = 100L;
        while (true) {
            int n3 = Math.min(n2, 500);
            long l2 = System.currentTimeMillis();
            try {
                return this.getResponse(n3);
            }
            catch (InterruptedIOException interruptedIOException) {
                long l3 = System.currentTimeMillis();
                double d = l3 - l2;
                if (d < (double)(500L - l) || d > (double)(500L + l)) {
                    this.logLine("---------------------Cypher FTP wifi drop : " + d + " " + new Date().toString());
                    throw new FtpNotConnectedException();
                }
                if (this.responseIsInterrupted) {
                    throw new FtpAbortedException();
                }
                if (n <= 0) continue;
                n2 -= n3;
                n3 = Math.min(n2, 500);
                if (0 != n2) continue;
                this.logLine("getAbortableResponse Cypher FTP throw no response exp: " + new Date().toString());
                throw new FtpNoResponseException();
            }
            catch (IOException iOException) {
                this.logLine("#####################Cypher FTP getAbortableResponse throw IOException: " + new Date().toString());
                throw new FtpIOException();
            }
            break;
        }
    }

    private int callGetAbortableResponse(int n) throws FtpException {
        this.logLine("in Cypher FTP getAbortableResponse: " + new Date().toString());
        int n2 = this.getAbortableResponse(n);
        this.logLine("out Cypher FTP getAbortableResponse: " + new Date().toString());
        return n2;
    }

    @Override
    protected int beginTransfer(String string) throws FtpException {
        int n;
        try {
            n = super.beginTransfer(string);
            this.logLine("Cypher FTP commandOnly response " + n + " " + new Date().toString());
            if (n == 425) {
                this.logLine("-------------------------Cypher FTP 425 425 425 425 " + new Date().toString());
                throw new FtpDataSocketException();
            }
        }
        catch (FtpException ftpException) {
            try {
                if (this.dataSocket != null) {
                    this.logLine("-------------------------Cypher FTP Closing data socket " + new Date().toString());
                    this.dataSocket.close();
                    this.dataSocket = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ftpException;
        }
        return n;
    }
}

