/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.AppsKeystoneSim.SimulatorAPI;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.Nest;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.SimuData;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.Trackers;

public class TargetNewNestDialog
extends JDialog
implements ActionListener {
    private Nest nest;
    private SimuData simuData;
    private JButton ok;
    private JButton cancel;
    private JButton current;
    private LinkedList nestList;
    private LinkedList trackerList;
    private JTextField nameIn;
    private JTextField[] posIn;
    private boolean okClick;
    private int coordinate;

    public TargetNewNestDialog(JFrame jFrame, LinkedList linkedList, LinkedList linkedList2, int n, SimuData simuData) {
        super(jFrame, "New Nest", true);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        this.setLocation(dimension.width / 6, dimension.height / 2);
        this.setSize(300, 220);
        this.setResizable(false);
        this.simuData = simuData;
        this.posIn = new JTextField[3];
        this.trackerList = new LinkedList();
        Trackers trackers = new Trackers();
        Trackers trackers2 = new Trackers();
        for (int i = 0; i < linkedList2.size(); ++i) {
            trackers = (Trackers)linkedList2.get(i);
            trackers2 = (Trackers)trackers.clone();
            this.trackerList.add(i, trackers2);
        }
        this.nestList = new LinkedList();
        Nest nest = new Nest();
        Nest nest2 = new Nest();
        for (int i = 0; i < linkedList.size(); ++i) {
            nest = (Nest)linkedList.get(i);
            nest2 = (Nest)nest.clone();
            this.nestList.add(i, nest2);
        }
        this.coordinate = n;
        this.okClick = false;
        this.nest = new Nest();
        this.buildNMADialog();
    }

    public boolean isOkClicked() {
        return this.okClick;
    }

    public LinkedList showDialog() {
        this.show();
        return this.nestList;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ok) {
            double[] dArray;
            Cloneable cloneable;
            int n;
            int n2;
            double[] dArray2 = new double[3];
            if (this.nameIn.getText().equals("")) {
                JOptionPane.showConfirmDialog(this, "Please provide a nest name", "Error", 2, 0);
                return;
            }
            for (n2 = 0; n2 < this.nestList.size(); ++n2) {
                if (!this.nameIn.getText().equals(((Nest)this.nestList.get(n2)).getNestName())) continue;
                JOptionPane.showConfirmDialog(this, "This nest name already exsit, please enter another name.", "Error", 2, 0);
                return;
            }
            for (n2 = 0; n2 < 3; ++n2) {
                if (this.posIn[n2].getText().equals("")) {
                    JOptionPane.showConfirmDialog(this, "Please provide nest's complete position", "Error", 2, 0);
                    return;
                }
                dArray2[n2] = new Double(this.posIn[n2].getText().trim());
            }
            double[] dArray3 = new double[3];
            if (this.coordinate == 1) {
                if (dArray2[1] >= -Math.PI && dArray2[1] <= 0.0) {
                    dArray2 = this.simuData.back_to_front(dArray2[0], dArray2[1], dArray2[2]);
                }
                dArray3 = this.simuData.sphere_to_cart(dArray2[0], dArray2[1], dArray2[2]);
            } else {
                dArray3 = dArray2;
            }
            for (n = 0; n < this.trackerList.size(); ++n) {
                cloneable = (Trackers)this.trackerList.get(n);
                dArray = ((Trackers)cloneable).getPosition();
                if (!(Math.sqrt(Math.pow(dArray[0] - dArray3[0], 2.0) + Math.pow(dArray[1] - dArray3[1], 2.0) + Math.pow(dArray[2] - dArray3[2], 2.0)) <= 0.1)) continue;
                JOptionPane.showConfirmDialog(this, "This nest is too close to a tracker, please enter another position.", "Error", 2, 0);
                return;
            }
            for (n = 0; n < this.nestList.size(); ++n) {
                cloneable = (Nest)this.nestList.get(n);
                dArray = ((Nest)cloneable).getPosition();
                double[] dArray4 = new double[3];
                dArray4 = this.coordinate == 1 ? this.simuData.sphere_to_cart(dArray[0], dArray[1], dArray[2]) : dArray;
                if (!(Math.sqrt(Math.pow(dArray4[0] - dArray3[0], 2.0) + Math.pow(dArray4[1] - dArray3[1], 2.0) + Math.pow(dArray4[2] - dArray3[2], 2.0)) <= 0.1)) continue;
                JOptionPane.showConfirmDialog(this, "This nest is too close to another nest, please enter another position.", "Error", 2, 0);
                return;
            }
            this.nest.setNestName(this.nameIn.getText());
            this.nest.setAbsPosition(dArray2);
            this.nestList.add(this.nest);
            this.okClick = true;
        }
        this.dispose();
    }

    private void buildNMADialog() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel("Name");
        JLabel jLabel2 = new JLabel(this.nest.getNestName());
        JLabel jLabel3 = new JLabel("X");
        JLabel jLabel4 = new JLabel("Y");
        JLabel jLabel5 = new JLabel("Z");
        JLabel jLabel6 = new JLabel("Azimuth");
        JLabel jLabel7 = new JLabel("Zenith");
        JLabel jLabel8 = new JLabel("Distance");
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.left = 30;
        gridBagConstraints.insets.right = 10;
        this.add(jLabel, gridBagConstraints, jPanel, 0, 0, 1, 1);
        this.nameIn = new JTextField(this.nest.getNestName(), 10);
        this.add(this.nameIn, gridBagConstraints, jPanel, 1, 0, 2, 1);
        if (this.coordinate == 0) {
            this.add(jLabel3, gridBagConstraints, jPanel, 0, 1, 1, 1);
            this.add(jLabel4, gridBagConstraints, jPanel, 0, 2, 1, 1);
            this.add(jLabel5, gridBagConstraints, jPanel, 0, 3, 1, 1);
        } else {
            this.add(jLabel6, gridBagConstraints, jPanel, 0, 1, 1, 1);
            this.add(jLabel7, gridBagConstraints, jPanel, 0, 2, 1, 1);
            this.add(jLabel8, gridBagConstraints, jPanel, 0, 3, 1, 1);
        }
        double[] dArray = this.nest.getPosition();
        for (int i = 0; i < 3; ++i) {
            this.posIn[i] = new JTextField("", 10);
            this.add(this.posIn[i], gridBagConstraints, jPanel, 1, i + 1, 2, 1);
        }
        this.ok = new JButton("OK");
        this.cancel = new JButton("Cancel");
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        gridBagConstraints.insets.top = 15;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.insets.left = 10;
        this.add(this.ok, gridBagConstraints, jPanel, 0, 4, 1, 1);
        this.add(this.cancel, gridBagConstraints, jPanel, 1, 4, 1, 1);
        this.getContentPane().add(jPanel);
    }

    private void add(Component component, GridBagConstraints gridBagConstraints, JPanel jPanel, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        jPanel.add(component, gridBagConstraints);
    }
}

