/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.AppsKeystoneSim.SimulatorAPI;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.LinkedList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.Constants;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.Nest;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.NestMRDialog;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.NestNMADialog;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.SimuData;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.Target;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.TrackerSimInterface;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.mainPanel;

public class NestPanel
extends mainPanel
implements ListSelectionListener,
ActionListener {
    private LinkedList trackerList;
    private LinkedList nestList;
    private LinkedList targetList;
    private SimuData simuData;
    private Nest nest;
    private JButton[] button;
    private JFrame parent;
    private JList nameList;
    private DefaultListModel model;
    private int index;
    private int coordinate;
    private TrackerSimInterface trkKeystoneSim;
    private NumberFormat form = NumberFormat.getNumberInstance();

    public NestPanel(JFrame jFrame, TrackerSimInterface trackerSimInterface) {
        this.setLayout(new BorderLayout());
        this.parent = jFrame;
        this.trkKeystoneSim = trackerSimInterface;
        this.index = 0;
        this.simuData = new SimuData();
        this.trackerList = new LinkedList();
        this.nestList = new LinkedList();
        this.targetList = new LinkedList();
        this.button = new JButton[4];
        this.model = new DefaultListModel();
        this.addList();
        this.addButton();
        this.form.setMaximumFractionDigits(8);
    }

    @Override
    public void setSimuData(SimuData simuData) {
        this.simuData = simuData;
        this.trackerList = this.simuData.getTrackerList();
        this.nestList = this.simuData.getNestList();
        this.targetList = this.simuData.getTargetList();
        this.coordinate = this.simuData.getCoord();
        this.prepareList();
        if (this.nestList.size() != 0) {
            Nest nest = (Nest)this.nestList.getFirst();
            String string = this.form.format(nest.getPosition()[0]);
            String string2 = this.form.format(nest.getPosition()[1]);
            String string3 = this.form.format(nest.getPosition()[2]);
            String string4 = this.coordinate == 0 ? "X = " + string + " Y = " + string2 + " Z = " + string3 : "Az = " + string + "  Ze = " + string2 + "  D = " + string3;
            this.nameList.setToolTipText(string4);
        }
    }

    @Override
    public SimuData getSimuData() {
        this.simuData.setTargetList(this.targetList);
        this.simuData.setNestList(this.nestList);
        return this.simuData;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n;
        JList jList = null;
        if (listSelectionEvent.getValueIsAdjusting()) {
            jList = (JList)listSelectionEvent.getSource();
            this.index = jList.getSelectedIndex();
        }
        if (this.nestList.size() == 0) {
            this.nameList.setToolTipText("There is no nest in the list");
            return;
        }
        Nest nest = (Nest)this.nestList.get(this.index);
        if (!nest.getNestName().startsWith("TMR_")) {
            for (n = 1; n < 4; ++n) {
                this.button[n].setEnabled(true);
            }
        } else {
            for (n = 1; n < 4; ++n) {
                this.button[n].setEnabled(false);
            }
        }
        String string = this.form.format(nest.getPosition()[0]);
        String string2 = this.form.format(nest.getPosition()[1]);
        String string3 = this.form.format(nest.getPosition()[2]);
        String string4 = this.coordinate == 0 ? "X = " + string + "  Y = " + string2 + "  Z = " + string3 : "Az = " + string + "  Ze = " + string2 + "  D = " + string3;
        this.nameList.setToolTipText(string4);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        if (jButton == this.button[3]) {
            if (this.nestList.size() == 0) {
                JOptionPane.showConfirmDialog(this, "There is no nest to delete.", "Error", 2, 0);
                return;
            }
            if (this.OnDelete()) {
                this.setModifiedFlag(true);
            }
            if (this.nestList.size() == 0) {
                this.nameList.setToolTipText("There is no nest in the list");
            }
        } else if (jButton == this.button[2]) {
            Nest nest;
            NestMRDialog nestMRDialog = new NestMRDialog(this.parent, this.nestList, this.trackerList, this.index, 2, this.coordinate, this.simuData, this.trkKeystoneSim);
            this.nestList = nestMRDialog.showDialog();
            if (nestMRDialog.isOkClicked()) {
                this.model.set(this.index, ((Nest)this.nestList.get(this.index)).getInfoForNestList());
                this.setModifiedFlag(true);
                this.trkKeystoneSim.setSimNestList(this.nestList);
                nest = (Nest)this.nestList.get(this.index);
                this.trkKeystoneSim.setSimPosition(this.coordinate, nest);
            }
            nest = (Nest)this.nestList.get(this.index);
            String string = this.form.format(nest.getPosition()[0]);
            String string2 = this.form.format(nest.getPosition()[1]);
            String string3 = this.form.format(nest.getPosition()[2]);
            String string4 = this.coordinate == 0 ? "X = " + string + "  Y = " + string2 + "  Z = " + string3 : "Az = " + string + "  Ze = " + string2 + "  D = " + string3;
            this.nameList.setToolTipText(string4);
        } else {
            Object object;
            Object object2;
            for (int i = 0; i < 2; ++i) {
                if (jButton != this.button[i]) continue;
                object2 = new NestNMADialog(this.parent, this.nestList, this.trackerList, this.index, Constants.NEST_DIALOG_TITLE[i], i, this.coordinate, this.simuData);
                this.nestList = ((NestNMADialog)object2).showDialog();
                if (!((NestNMADialog)object2).isOkClicked()) continue;
                if (jButton == this.button[0]) {
                    this.model.addElement(((Nest)this.nestList.getLast()).getInfoForNestList());
                } else {
                    this.model.set(this.index, ((Nest)this.nestList.get(this.index)).getInfoForNestList());
                }
                this.setModifiedFlag(true);
                this.trkKeystoneSim.setSimNestList(this.nestList);
                object = (Nest)this.nestList.get(this.index);
                this.trkKeystoneSim.setSimPosition(this.coordinate, (Nest)object);
            }
            Nest nest = (Nest)this.nestList.get(this.index);
            object = this.form.format(nest.getPosition()[0]);
            String string = this.form.format(nest.getPosition()[1]);
            String string5 = this.form.format(nest.getPosition()[2]);
            object2 = this.coordinate == 0 ? "X = " + (String)object + "  Y = " + string + "  Z = " + string5 : "Az = " + (String)object + "  Ze = " + string + "  D = " + string5;
            this.nameList.setToolTipText((String)object2);
        }
    }

    public boolean OnDelete() {
        Nest nest = (Nest)this.nestList.get(this.index);
        int n = !nest.getClassmateName().equals("") ? JOptionPane.showConfirmDialog(this, "The target in this nest will also be deleted, are you sure you want to delete this nest?", "Delete confirmation", 2, 2) : JOptionPane.showConfirmDialog(this, "Are you sure you want to delete this nest?", "Delete confirmation", 2, 2);
        if (n == 0) {
            for (int i = 0; i < this.targetList.size(); ++i) {
                Target target = (Target)this.targetList.get(i);
                if (!nest.getClassmateName().equals(target.getTargetName())) continue;
                this.targetList.remove(i);
            }
            this.model.remove(this.index);
            this.nestList.remove(this.index);
            this.trkKeystoneSim.setSimNestList(this.nestList);
            this.trkKeystoneSim.setSimTargetList(this.targetList);
            if (this.index > this.nestList.size() - 1) {
                --this.index;
            }
            this.nameList.setSelectedIndex(this.index);
            return true;
        }
        return false;
    }

    private void prepareList() {
        this.model.clear();
        for (int i = 0; i < this.nestList.size(); ++i) {
            Nest nest = (Nest)this.nestList.get(i);
            this.model.addElement(nest.getInfoForNestList());
        }
    }

    private void addList() {
        this.prepareList();
        this.nameList = new JList(this.model);
        this.nameList.setSelectionMode(0);
        this.nameList.setSelectedIndex(this.index);
        this.nameList.addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.nameList);
        this.add((Component)jScrollPane, "North");
    }

    private void addButton() {
        JPanel jPanel = new JPanel();
        for (int i = 0; i < 4; ++i) {
            this.button[i] = new JButton(Constants.NESTBUTTON[i]);
            this.button[i].addActionListener(this);
            jPanel.add(this.button[i]);
        }
        this.add((Component)jPanel, "South");
    }
}

