/*
 * Decompiled with CFR 0.152.
 */
package smx.utility;

import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import smx.utility.UtilityOutOfPortsException;

public class PortUtility {
    private int startRange = 0;
    private int endRange = 0;
    private boolean useCustomPort = false;
    Map<Integer, Boolean> portMap = new HashMap<Integer, Boolean>();
    PrintWriter debugWriter = null;

    public PortUtility(boolean bl) {
        this(0, 0, bl, null);
    }

    public PortUtility(int n, int n2, boolean bl, PrintWriter printWriter) {
        int n3;
        this.startRange = n;
        this.endRange = n2;
        this.useCustomPort = bl;
        this.debugWriter = printWriter;
        int n4 = Math.max(this.endRange, this.startRange);
        for (int i = n3 = Math.min(this.endRange, this.startRange); i <= n4; ++i) {
            this.portMap.put(i, false);
        }
    }

    public boolean checkIfAnyPortAvailable() {
        for (Map.Entry<Integer, Boolean> entry : this.portMap.entrySet()) {
            Boolean bl = entry.getValue();
            if (bl.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public int getAvailablePort() throws UtilityOutOfPortsException {
        for (Map.Entry<Integer, Boolean> entry : this.portMap.entrySet()) {
            Boolean bl = entry.getValue();
            if (bl.booleanValue()) continue;
            int n = entry.getKey();
            if (this.debugWriter != null) {
                this.debugWriter.println("OPEN PORT: " + n + " " + new Date().toString());
            }
            this.portMap.replace(n, true);
            return n;
        }
        throw new UtilityOutOfPortsException();
    }

    public void closePort(int n) {
        if (this.debugWriter != null) {
            this.debugWriter.println("CLOSE PORT: " + n + " " + new Date().toString());
        }
        if (this.portMap.containsKey(n)) {
            this.portMap.replace(n, false);
        }
    }

    public boolean useCustomPort() {
        return this.useCustomPort;
    }

    public int startRange() {
        return this.startRange;
    }

    public int endRange() {
        return this.endRange;
    }
}

