/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.apps4xxx.utility;

public class XMath {
    public static final double PI = Math.PI;
    public static final double TINY = 1.0E-14;
    public static final double SMALL = 1.0E-6;

    public static final void pointPolarToCart(double[] dArray) {
        double d = dArray[0];
        double d2 = dArray[1];
        dArray[0] = d * Math.cos(d2);
        dArray[1] = d * Math.sin(d2);
    }

    public static final void pointSphereToCart(double[] dArray) {
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = Math.sin(dArray[2]);
        dArray[0] = d * Math.cos(d2) * d4;
        dArray[1] = d * Math.sin(d2) * d4;
        dArray[2] = d * Math.cos(d3);
    }

    public static void pointCartToPolar(double[] dArray) {
        if (Math.abs(dArray[0]) < 1.0E-14 && Math.abs(dArray[1]) < 1.0E-14) {
            if (Math.abs(dArray[2]) < 1.0E-14) {
                dArray[2] = 0.0;
                dArray[1] = 0.0;
                dArray[0] = 0.0;
            } else {
                dArray[1] = 0.0;
                dArray[0] = 0.0;
            }
        } else {
            double d = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1]);
            dArray[1] = Math.atan2(dArray[1], dArray[0]);
            dArray[0] = d;
        }
    }

    public static final int pointCartToSphere(double[] dArray) {
        if (Math.abs(dArray[0]) < 1.0E-14 && Math.abs(dArray[1]) < 1.0E-14) {
            if (Math.abs(dArray[2]) < 1.0E-14) {
                dArray[2] = 0.0;
                dArray[1] = 0.0;
                dArray[0] = 0.0;
                return -1;
            }
            if (dArray[2] > 0.0) {
                dArray[0] = dArray[2];
                dArray[2] = 0.0;
                dArray[1] = 0.0;
                return -2;
            }
            dArray[0] = -dArray[2];
            dArray[1] = 0.0;
            dArray[2] = -Math.PI;
            return -3;
        }
        double d = XMath.get3DPtDistance(dArray);
        dArray[2] = Math.acos(dArray[2] / d);
        dArray[1] = Math.atan2(dArray[1], dArray[0]);
        dArray[0] = d;
        return 0;
    }

    double vectorNormalize(double[] dArray) {
        double d = XMath.get3DPtDistance(dArray);
        if (d < 1.0E-14) {
            dArray[0] = 0.0;
            dArray[1] = 0.0;
            dArray[2] = 0.0;
            return 0.0;
        }
        dArray[0] = dArray[0] / d;
        dArray[1] = dArray[1] / d;
        dArray[2] = dArray[2] / d;
        return d;
    }

    public static void vectorCross(double[] dArray, double[] dArray2, double[] dArray3) {
        dArray3[0] = dArray[1] * dArray2[2] - dArray2[1] * dArray[2];
        dArray3[1] = dArray[2] * dArray2[0] - dArray[0] * dArray2[2];
        dArray3[2] = dArray[0] * dArray2[1] - dArray2[0] * dArray[1];
    }

    public static void xfrmPointFrom2to1(double[] dArray, double[] dArray2, double d) {
        double[] dArray3 = dArray2;
        double d2 = dArray[0] * dArray3[0] + dArray[1] * dArray3[1] + dArray[2] * dArray3[2] + dArray[3] * d;
        double d3 = dArray[4] * dArray3[0] + dArray[5] * dArray3[1] + dArray[6] * dArray3[2] + dArray[7] * d;
        double d4 = dArray[8] * dArray3[0] + dArray[9] * dArray3[1] + dArray[10] * dArray3[2] + dArray[11] * d;
        dArray2[0] = d2;
        dArray2[1] = d3;
        dArray2[2] = d4;
    }

    public static void xfrmPointFrom1to2(double[] dArray, double[] dArray2, double d) {
        double[] dArray3 = dArray2;
        double d2 = (double)-1 * (dArray[0] * dArray[3] + dArray[4] * dArray[7] + dArray[8] * dArray[11]);
        double d3 = (double)-1 * (dArray[1] * dArray[3] + dArray[5] * dArray[7] + dArray[9] * dArray[11]);
        double d4 = (double)-1 * (dArray[2] * dArray[3] + dArray[6] * dArray[7] + dArray[10] * dArray[11]);
        double d5 = dArray[0] * dArray3[0] + dArray[4] * dArray3[1] + dArray[8] * dArray3[2] + d2 * d;
        double d6 = dArray[1] * dArray3[0] + dArray[5] * dArray3[1] + dArray[9] * dArray3[2] + d3 * d;
        double d7 = dArray[2] * dArray3[0] + dArray[6] * dArray3[1] + dArray[10] * dArray3[2] + d4 * d;
        dArray2[0] = d5;
        dArray2[1] = d6;
        dArray2[2] = d7;
    }

    public static void pointCopyToFrom(double[] dArray, double[] dArray2) {
        dArray[0] = dArray2[0];
        dArray[1] = dArray2[1];
        dArray[2] = dArray2[2];
    }

    public static void pointDifference(double[] dArray, double[] dArray2, double[] dArray3) {
        dArray3[0] = dArray[0] - dArray2[0];
        dArray3[1] = dArray[1] - dArray2[1];
        dArray3[2] = dArray[2] - dArray2[2];
    }

    public static double get3DPtDistance(double[] dArray) {
        return Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
    }

    public static double getStandardDeviation(double[] dArray, int n) {
        double d = 0.0;
        if (n < 2) {
            return d;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            if (Math.abs(dArray[i]) < 1.0E-14) {
                dArray[i] = 0.0;
            }
            d2 += dArray[i];
            d3 += dArray[i] * dArray[i];
        }
        double d4 = d2 / (double)n;
        double d5 = Math.sqrt(d3 / (double)n);
        d = Math.sqrt(Math.abs((double)n * d3 - d2 * d2) / (double)(n * (n - 1)));
        return d;
    }

    public static double roundToSinglePrecision(double d) {
        int n = (int)((double)10 * d);
        double d2 = (double)10 * d - (double)n;
        d2 = d2 >= 0.5 ? 1.0 : 0.0;
        return (double)n / (double)10 + d2 / (double)10;
    }

    static {
        PI = Math.PI;
        TINY = 1.0E-14;
        SMALL = 1.0E-6;
    }
}

