/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.apps4xxx.utility;

import smx.tracker.DataTag;
import smx.tracker.DataTagDouble;
import smx.tracker.DataTagUnsigned32;
import smx.tracker.Tracker;
import smx.tracker.TrackerException;

public class ClosureMath {
    private long TMR_Type = 0L;
    private double[] locationData = null;

    public ClosureMath(Tracker tracker) throws TrackerException {
        this.TMR_Type = this.readTMRType(tracker);
        this.locationData = this.readDistance(tracker, this.TMR_Type);
    }

    private long readTMRType(Tracker tracker) throws TrackerException {
        Object[] objectArray = null;
        DataTag[] dataTagArray = new DataTag[1];
        long l = 0L;
        dataTagArray[0] = new DataTagUnsigned32("TMR_TYPE.Int_Output");
        objectArray = tracker.readOneTimeData(dataTagArray);
        l = (Long)objectArray[0];
        return l;
    }

    public long getTMRType() {
        return this.TMR_Type;
    }

    private double[] readDistance(Tracker tracker, long l) throws TrackerException {
        Object[] objectArray = null;
        if (l == (long)0) {
            double[] dArray = new double[2];
            DataTag[] dataTagArray = new DataTag[]{new DataTagDouble("TMR_DIST.OutPut"), new DataTagDouble("TMR_DIST_BACK.OutPut")};
            objectArray = tracker.readOneTimeData(dataTagArray);
            dArray[0] = (Double)objectArray[0];
            dArray[1] = (Double)objectArray[1];
            return dArray;
        }
        if (l == (long)1) {
            double[] dArray = new double[4];
            DataTag[] dataTagArray = new DataTag[]{new DataTagDouble("TMR_DIST.OutPut"), new DataTagDouble("TMR_DIST_BACK.OutPut"), new DataTagDouble("TMR_1_2_DIST.OutPut"), new DataTagDouble("TMR_1_2_DIST_BACK.OutPut")};
            objectArray = tracker.readOneTimeData(dataTagArray);
            dArray[0] = (Double)objectArray[0];
            dArray[1] = (Double)objectArray[1];
            dArray[2] = (Double)objectArray[2];
            dArray[3] = (Double)objectArray[2];
            return dArray;
        }
        return null;
    }

    public double getClosureAgainstTMR(long l, long l2, double d) {
        double d2 = 0.0;
        if (this.TMR_Type == (long)0) {
            if (l2 == (long)0) {
                d2 = d - this.locationData[0];
            } else if (l2 == (long)1) {
                d2 = d - this.locationData[1];
            }
        } else if (this.TMR_Type == (long)1) {
            if (l != (long)2) {
                if (l2 == (long)0) {
                    d2 = d - this.locationData[0];
                } else if (l2 == (long)1) {
                    d2 = d - this.locationData[1];
                }
            } else if (l2 == (long)0) {
                d2 = d - this.locationData[2];
            } else if (l2 == (long)1) {
                d2 = d - this.locationData[3];
            }
        }
        return d2 / (double)1000000;
    }

    public double getClosureAgainstPoint(double d, double d2) {
        double d3 = d * (double)1000000 - d2;
        return d3 / (double)1000000;
    }
}

