/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.apps4xxx.trackerpad;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.TooManyListenersException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import smx.tracker.DataTag;
import smx.tracker.DataTagDouble;
import smx.tracker.DataTagUnsigned8;
import smx.tracker.TrackerException;
import smx.tracker.apps4xxx.trackerpad.TrackerPad;
import smx.tracker.apps4xxx.trackerpad.TrackerPadThread;
import smx.tracker.apps4xxx.utility.GlassComponent;
import smx.tracker.apps4xxx.utility.ThreadListener;
import smx.tracker.apps4xxx.utility.TrackerExceptionString;
import smx.utility.UnitsConversion;

public class WeatherCfg
extends JDialog {
    private Object[] dataReading = null;
    private TrackerPadThread padThread = null;
    private boolean okClicked = false;
    private saveCmdComplete saveListener = new saveCmdComplete();
    private UnitsConversion pressureUnits = null;
    private UnitsConversion temperatureUnits = null;
    JPanel panel1 = new JPanel();
    JPanel pressurePanel = new JPanel();
    JPanel humidityPanel = new JPanel();
    JPanel temperaturePanel = new JPanel();
    JPanel buttonPanel = new JPanel();
    JRadioButton manualPressureRadio = new JRadioButton();
    JRadioButton hardwarePressureRadio = new JRadioButton();
    JRadioButton manualTempRadio = new JRadioButton();
    JRadioButton hardwareTempRadio = new JRadioButton();
    JTextField pressureText = new JTextField();
    JTextField humidityText = new JTextField();
    JTextField tempText = new JTextField();
    TitledBorder titledBorder1;
    TitledBorder titledBorder2;
    TitledBorder titledBorder3;
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JLabel jLabel3 = new JLabel();
    JLabel jLabel4 = new JLabel();
    JButton Apply = new JButton();
    JButton OK = new JButton();
    JButton Cancel = new JButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    GridBagLayout gridBagLayout4 = new GridBagLayout();
    GridBagLayout gridBagLayout5 = new GridBagLayout();

    private void restoreCursor() {
        GlassComponent.setWaitState(false, this);
    }

    public WeatherCfg(Frame frame, String string, Object[] objectArray, TrackerPadThread trackerPadThread, UnitsConversion unitsConversion, UnitsConversion unitsConversion2, boolean bl) {
        super(frame, string, bl);
        this.dataReading = objectArray;
        this.padThread = trackerPadThread;
        this.pressureUnits = unitsConversion;
        this.temperatureUnits = unitsConversion2;
        this.setGlassPane(new GlassComponent());
        try {
            this.jbInit();
            this.pack();
            this.setLocationRelativeTo(frame);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public WeatherCfg() {
        this(null, "", null, null, null, null, false);
    }

    void jbInit() throws Exception {
        this.panel1.setLayout(this.gridBagLayout5);
        this.pressurePanel.setLayout(this.gridBagLayout2);
        this.humidityPanel.setLayout(this.gridBagLayout3);
        this.temperaturePanel.setLayout(this.gridBagLayout4);
        this.titledBorder1 = new TitledBorder(new EtchedBorder(0, Color.white, new Color(134, 134, 134)), TrackerPad.res.getString("Air_Pressure"));
        this.titledBorder2 = new TitledBorder(new EtchedBorder(0, Color.white, new Color(134, 134, 134)), TrackerPad.res.getString("Humidity"));
        this.titledBorder3 = new TitledBorder(new EtchedBorder(0, Color.white, new Color(134, 134, 134)), TrackerPad.res.getString("Air_Temperature"));
        this.manualPressureRadio.setText(TrackerPad.res.getString("Manual"));
        this.hardwarePressureRadio.setText(TrackerPad.res.getString("Hardware"));
        this.manualTempRadio.setText(TrackerPad.res.getString("Manual"));
        this.hardwareTempRadio.setText(TrackerPad.res.getString("Hardware"));
        this.jLabel1.setText(TrackerPad.res.getString("Manual"));
        this.jLabel2.setText(TrackerPad.res.getString("Percentage"));
        this.jLabel3.setText(TrackerPad.res.getString("mmHg"));
        this.jLabel4.setText(TrackerPad.res.getString("Degree"));
        this.Apply.setText(TrackerPad.res.getString("Apply"));
        this.OK.setText(TrackerPad.res.getString("OK"));
        this.Cancel.setText(TrackerPad.res.getString("Cancel"));
        this.jLabel3.setText(this.pressureUnits.displayName());
        this.jLabel4.setText(this.temperatureUnits.displayName());
        double d = (Double)this.dataReading[0];
        this.pressureText.setText(this.pressureUnits.convertToDisplayStr(d));
        double d2 = (Double)this.dataReading[2];
        this.humidityText.setText(TrackerPad.form.format(d2 * (double)100));
        double d3 = (Double)this.dataReading[3];
        this.tempText.setText(this.temperatureUnits.convertToDisplayStr(d3));
        if ((Short)this.dataReading[1] == 1) {
            this.hardwarePressureRadio.setSelected(true);
            this.pressureText.setEnabled(false);
            this.pressureText.setEditable(false);
        } else if ((Short)this.dataReading[1] == 2) {
            this.manualPressureRadio.setSelected(true);
            this.pressureText.setEditable(true);
            this.pressureText.setEnabled(true);
        }
        if ((Short)this.dataReading[4] == 1) {
            this.hardwareTempRadio.setSelected(true);
            this.tempText.setEditable(false);
            this.tempText.setEnabled(false);
        } else if ((Short)this.dataReading[4] == 2) {
            this.manualTempRadio.setSelected(true);
            this.tempText.setEditable(true);
            this.tempText.setEnabled(true);
        }
        this.jLabel4.setForeground(Color.black);
        this.jLabel4.setMaximumSize(new Dimension(4, 21));
        this.jLabel4.setMinimumSize(new Dimension(4, 21));
        this.jLabel4.setPreferredSize(new Dimension(4, 21));
        this.jLabel3.setForeground(Color.black);
        this.jLabel3.setMaximumSize(new Dimension(4, 21));
        this.jLabel3.setMinimumSize(new Dimension(4, 21));
        this.jLabel3.setPreferredSize(new Dimension(4, 21));
        this.jLabel2.setForeground(Color.black);
        this.jLabel2.setMaximumSize(new Dimension(4, 21));
        this.jLabel2.setMinimumSize(new Dimension(4, 21));
        this.jLabel2.setPreferredSize(new Dimension(4, 21));
        this.jLabel1.setForeground(Color.black);
        this.manualPressureRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WeatherCfg.this.manualPressureRadio_actionPerformed(actionEvent);
            }
        });
        this.hardwarePressureRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WeatherCfg.this.hardwarePressureRadio_actionPerformed(actionEvent);
            }
        });
        this.manualTempRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WeatherCfg.this.manualTempRadio_actionPerformed(actionEvent);
            }
        });
        this.hardwareTempRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WeatherCfg.this.hardwareTempRadio_actionPerformed(actionEvent);
            }
        });
        this.pressurePanel.setBorder(this.titledBorder1);
        this.pressurePanel.setMinimumSize(new Dimension(300, 80));
        this.pressurePanel.setPreferredSize(new Dimension(300, 80));
        this.humidityPanel.setBorder(this.titledBorder2);
        this.humidityPanel.setMinimumSize(new Dimension(300, 80));
        this.humidityPanel.setPreferredSize(new Dimension(300, 80));
        this.temperaturePanel.setBorder(this.titledBorder3);
        this.temperaturePanel.setMinimumSize(new Dimension(300, 80));
        this.temperaturePanel.setPreferredSize(new Dimension(300, 80));
        this.pressureText.setMaximumSize(new Dimension(4, 21));
        this.humidityText.setMaximumSize(new Dimension(4, 21));
        this.tempText.setMaximumSize(new Dimension(4, 21));
        this.buttonPanel.setLayout(this.gridBagLayout1);
        this.Apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WeatherCfg.this.Apply_actionPerformed(actionEvent);
            }
        });
        this.OK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WeatherCfg.this.OK_actionPerformed(actionEvent);
            }
        });
        this.Cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WeatherCfg.this.Cancel_actionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.pressurePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(17, 21, 0, 23), 0, 0));
        this.pressurePanel.add((Component)this.hardwarePressureRadio, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(12, 72, 0, 0), 0, -4));
        this.pressurePanel.add((Component)this.manualPressureRadio, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 72, 8, 0), 14, -4));
        this.pressurePanel.add((Component)this.pressureText, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 7, 8, 0), 55, 0));
        this.pressurePanel.add((Component)this.jLabel3, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 8, 51), 64, 0));
        this.panel1.add((Component)this.humidityPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 21, 0, 23), 0, 0));
        this.humidityPanel.add((Component)this.jLabel2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(26, 9, 8, 103), 29, 0));
        this.humidityPanel.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(26, 87, 8, 0), 24, 4));
        this.humidityPanel.add((Component)this.humidityText, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(26, 7, 8, 0), 37, 0));
        this.panel1.add((Component)this.temperaturePanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 21, 0, 23), 0, 0));
        this.temperaturePanel.add((Component)this.hardwareTempRadio, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(12, 72, 0, 0), 0, -4));
        this.temperaturePanel.add((Component)this.manualTempRadio, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 72, 8, 0), 14, -4));
        this.temperaturePanel.add((Component)this.tempText, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 7, 8, 0), 55, 0));
        this.temperaturePanel.add((Component)this.jLabel4, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 8, 51), 64, 0));
        this.panel1.add((Component)this.buttonPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(9, 15, 15, 16), 0, -3));
        this.buttonPanel.add((Component)this.Apply, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 45, 2, 0), 17, 0));
        this.buttonPanel.add((Component)this.OK, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 20, 2, 0), 29, 0));
        this.buttonPanel.add((Component)this.Cancel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 20, 2, 44), 7, 0));
    }

    void Apply_actionPerformed(ActionEvent actionEvent) {
        this.okClicked = false;
        this.saveParameters();
    }

    void OK_actionPerformed(ActionEvent actionEvent) {
        this.okClicked = true;
        this.saveParameters();
    }

    void Cancel_actionPerformed(ActionEvent actionEvent) {
        this.clearExclusiveAccess();
        this.dispose();
    }

    private void clearExclusiveAccess() {
        Object[] objectArray = new Object[]{new Integer(1), new Integer(1)};
        this.padThread.sendCommand(objectArray);
        this.padThread.receiveResponse();
    }

    private void saveParameters() {
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = new Object[5];
        Object[] objectArray3 = new Object[4];
        String[] stringArray = new String[3];
        char[] cArray = null;
        DataTag[] dataTagArray = new DataTag[5];
        stringArray[0] = this.pressureText.getText().trim();
        stringArray[1] = this.humidityText.getText().trim();
        stringArray[2] = this.tempText.getText().trim();
        for (int i = 0; i < 3; ++i) {
            try {
                cArray = stringArray[i].toCharArray();
                for (int j = 0; j < cArray.length; ++j) {
                    if (!Character.isLetter(cArray[j])) continue;
                    throw new ParseException("", j);
                }
                objectArray[i] = new Double(TrackerPad.form.parse(stringArray[i]).doubleValue());
                continue;
            }
            catch (ParseException parseException) {
                JOptionPane.showMessageDialog(this, TrackerPad.res.getString("Enter_Number"), TrackerPad.res.getString("Error"), 0);
                return;
            }
        }
        double d = (Double)objectArray[1];
        if (d > (double)100 || d < 0.0) {
            JOptionPane.showMessageDialog(this, TrackerPad.res.getString("Humidity_Check"), TrackerPad.res.getString("Error"), 0);
            return;
        }
        objectArray2[0] = objectArray[0];
        objectArray2[2] = new Double(d / (double)100);
        objectArray2[3] = objectArray[2];
        if (this.hardwarePressureRadio.isSelected()) {
            objectArray2[1] = new Short(1);
        }
        if (this.manualPressureRadio.isSelected()) {
            objectArray2[1] = new Short(2);
        }
        if (!this.hardwarePressureRadio.isSelected() && !this.manualPressureRadio.isSelected()) {
            objectArray2[1] = new Short(0);
        }
        if (this.hardwareTempRadio.isSelected()) {
            objectArray2[4] = new Short(1);
        }
        if (this.manualTempRadio.isSelected()) {
            objectArray2[4] = new Short(2);
        }
        if (!this.hardwareTempRadio.isSelected() && !this.manualTempRadio.isSelected()) {
            objectArray2[4] = new Short(0);
        }
        dataTagArray[0] = new DataTagDouble("air_pressure.manual_input");
        dataTagArray[1] = new DataTagUnsigned8("air_pressure.input_selector");
        dataTagArray[2] = new DataTagDouble("humidity.manual_input");
        dataTagArray[3] = new DataTagDouble("ambient_temp.manual_input");
        dataTagArray[4] = new DataTagUnsigned8("ambient_temp.input_selector");
        objectArray3[0] = new Integer(26);
        objectArray3[1] = this.okClicked ? new Integer(1) : new Integer(0);
        objectArray3[2] = dataTagArray;
        objectArray3[3] = objectArray2;
        try {
            this.padThread.addThreadListener(this.saveListener);
        }
        catch (TooManyListenersException tooManyListenersException) {
            JOptionPane.showMessageDialog(this, TrackerPad.res.getString("Too_Many_Listener"), TrackerPad.res.getString("Internal_Error"), 0);
            return;
        }
        GlassComponent.setWaitState(true, this);
        this.padThread.sendCommand(objectArray3);
    }

    void hardwarePressureRadio_actionPerformed(ActionEvent actionEvent) {
        this.manualPressureRadio.setSelected(false);
        this.pressureText.setEditable(false);
        this.pressureText.setEnabled(false);
    }

    void manualPressureRadio_actionPerformed(ActionEvent actionEvent) {
        this.hardwarePressureRadio.setSelected(false);
        this.pressureText.setEditable(true);
        this.pressureText.setEnabled(true);
    }

    void hardwareTempRadio_actionPerformed(ActionEvent actionEvent) {
        this.manualTempRadio.setSelected(false);
        this.tempText.setEditable(false);
        this.tempText.setEnabled(false);
    }

    void manualTempRadio_actionPerformed(ActionEvent actionEvent) {
        this.hardwareTempRadio.setSelected(false);
        this.tempText.setEditable(true);
        this.tempText.setEnabled(true);
    }

    private class saveCmdComplete
    implements ThreadListener,
    Runnable {
        private saveCmdComplete() {
        }

        public void commandComplete() {
            WeatherCfg.this.padThread.removeThreadListener(this);
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            Object[] objectArray = WeatherCfg.this.padThread.receiveResponse();
            if (objectArray[0] != null) {
                TrackerExceptionString.displayErrorToUser(null, (TrackerException)((Object)objectArray[0]), TrackerPad.res.getString("Error"), "");
            }
            if (WeatherCfg.this.okClicked) {
                WeatherCfg.this.dispose();
            }
            WeatherCfg.this.restoreCursor();
        }
    }
}

