/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.apps4xxx.trackerpad;

import java.io.IOException;
import java.util.TooManyListenersException;
import smx.tracker.AbortedException;
import smx.tracker.AlarmType;
import smx.tracker.AverageFilter;
import smx.tracker.ContinueTrigger;
import smx.tracker.DataTag;
import smx.tracker.DataTagDouble;
import smx.tracker.DataTagUnsigned32;
import smx.tracker.DistanceMode;
import smx.tracker.ExtTempType;
import smx.tracker.Filter;
import smx.tracker.InterfaceBusyException;
import smx.tracker.InterferometerOnly;
import smx.tracker.InterferometerSetByADM;
import smx.tracker.IntervalTrigger;
import smx.tracker.MeasureCfg;
import smx.tracker.MeasureData;
import smx.tracker.MirrorTargetType;
import smx.tracker.NullStartTrigger;
import smx.tracker.SMRTargetType;
import smx.tracker.StartTrigger;
import smx.tracker.TargetType;
import smx.tracker.Tracker;
import smx.tracker.TrackerException;
import smx.tracker.apps4xxx.utility.ThreadListener;
import smx.tracker.event.FactoryBkndMeasureDataListener;
import smx.utility.ThreadComm;

class TrackerPadThread
implements Runnable {
    public static final int NULL_COMMAND = 0;
    public static final int NOP = 1;
    public static final int HOME = 2;
    public static final int BACKSIGHT = 3;
    public static final int TRACKING = 4;
    public static final int MOTORS = 5;
    public static final int INITIALIZE = 6;
    public static final int FIND_BEAM = 7;
    public static final int GET_SEARCH_DATA = 8;
    public static final int SEARCH = 9;
    public static final int GET_TEMP_CFG_DATA = 10;
    public static final int SET_TEMP_CFG_DATA = 11;
    public static final int SET_AXIS_VELOCITY = 12;
    public static final int GET_DISTANCE_MEASURE_MODE = 13;
    public static final int SET_DISTANCE_MEASURE_MODE = 14;
    public static final int GET_TARGET_TYPE = 15;
    public static final int SET_TARGET_TYPE = 16;
    public static final int SHUTTER = 17;
    public static final int GET_TIME_STAMP = 19;
    public static final int WRITE_TIME_STAMP = 20;
    public static final int START_BKND_MEASURE = 21;
    public static final int STOP_BKND_MEASURE = 22;
    public static final int SET_DISTANCE_THEN_MOVE = 23;
    public static final int READ_ONE_TIME_DATA = 24;
    public static final int HIGHLIGHT_BEAM = 25;
    public static final int WRITE_ONE_TIME_DATA = 26;
    public static final int SET_DISTANCE = 27;
    public static final int KEEP_EXCLUSIVE_ACCESS_AT_END = 0;
    public static final int CLEAR_EXCLUSIVE_ACCESS_AT_END = 1;
    public static final int SAMPLE_RATE = 1;
    public static final double DATA_LISTENER_RATE = 0.25;
    private Tracker trk = null;
    private ThreadComm command = new ThreadComm();
    private ThreadComm response = new ThreadComm();
    private boolean shutdownFlag = false;
    private boolean commandInProgress = false;
    private ThreadListener listener = null;
    private boolean hasExclusiveAccess = false;

    TrackerPadThread(Tracker tracker, ThreadListener threadListener) {
        Thread thread = new Thread((Runnable)this, "Tracker Pad Thread");
        thread.setDaemon(true);
        this.trk = tracker;
        this.listener = threadListener;
        thread.start();
    }

    TrackerPadThread(Tracker tracker) {
        this(tracker, null);
    }

    public synchronized void sendCommand(Object[] objectArray) {
        try {
            this.response.flush();
            this.command.send(objectArray);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Object[] receiveResponse() {
        try {
            Object[] objectArray = this.response.receive();
            return objectArray;
        }
        catch (IOException iOException) {
            Object[] objectArray = null;
            return objectArray;
        }
    }

    private Object[] getSearchData() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagDouble("dist.output")};
        Object[] objectArray = this.trk.readOneTimeData(dataTagArray);
        return objectArray;
    }

    private Object[] getTempCfgData() throws TrackerException {
        int n = 0;
        Object[] objectArray = new Object[16];
        for (int i = 0; i < 8; ++i) {
            objectArray[n] = this.trk.externalTempType(i + 1);
            objectArray[++n] = this.trk.alarmCfg(i + 1);
            ++n;
        }
        return objectArray;
    }

    private void setTempCfgData(Object[] objectArray) throws TrackerException {
        int n = 0;
        for (int i = 0; i < 8; ++i) {
            this.trk.changeExternalTempType(i + 1, (ExtTempType)objectArray[n]);
            this.trk.changeAlarmCfg(i + 1, (AlarmType)objectArray[++n]);
            ++n;
        }
    }

    private Object[] getStateInfo(DataTag[] dataTagArray) {
        Object[] objectArray;
        try {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            objectArray = this.trk.readOneTimeData(dataTagArray);
        }
        catch (TrackerException trackerException) {
            objectArray = new Object[]{trackerException};
        }
        return objectArray;
    }

    private Object[] getTimeStamp() throws TrackerException {
        Object[] objectArray = new Object[1];
        DataTag[] dataTagArray = new DataTag[]{new DataTagDouble("Dist.Output")};
        this.trk.startMeasure(new MeasureCfg(1, (Filter)new AverageFilter(), (StartTrigger)new NullStartTrigger(), (ContinueTrigger)new IntervalTrigger(0.25)), dataTagArray);
        MeasureData[] measureDataArray = this.trk.readMeasureData(1);
        this.trk.stopMeasure();
        double d = measureDataArray[0].time();
        objectArray[0] = new Double(d);
        return objectArray;
    }

    private void writeTimeStamp(String string) throws TrackerException {
        this.trk.command(string, 3000);
    }

    private void startBkndMeasurement(FactoryBkndMeasureDataListener factoryBkndMeasureDataListener, DataTag[] dataTagArray) throws TrackerException {
        this.trk.setFactoryBkndMeasureBlocking(true);
        this.trk.addFactoryBkndMeasureDataListener(factoryBkndMeasureDataListener);
        this.trk.startFactoryBkndMeasure(new MeasureCfg(1, (Filter)new AverageFilter(), (StartTrigger)new NullStartTrigger(), (ContinueTrigger)new IntervalTrigger(0.25)), dataTagArray);
    }

    private void stopBkndMeasurement(FactoryBkndMeasureDataListener factoryBkndMeasureDataListener) throws TrackerException {
        this.trk.removeFactoryBkndMeasureDataListener(factoryBkndMeasureDataListener);
        this.trk.stopFactoryBkndMeasure();
    }

    private void setDistAndMove(String string, String string2, String string3) throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("Target.Int_Output")};
        Object[] objectArray = this.trk.readOneTimeData(dataTagArray);
        long l = (Long)objectArray[0];
        if (l == (long)1 || l == (long)4) {
            this.trk.command(String.valueOf(String.valueOf(new StringBuffer("moveto ").append(string).append(" ").append(string2).append(" ").append(string3).append(" c3"))), 2000);
        } else {
            this.trk.command(String.valueOf(String.valueOf(new StringBuffer("moveto ").append(string).append(" ").append(string2).append(" ").append(string3).append("! c3"))), 2000);
        }
    }

    private Object[] readOneTimeData(DataTag[] dataTagArray) throws TrackerException {
        Object[] objectArray = this.trk.readOneTimeData(dataTagArray);
        return objectArray;
    }

    private void setDistance(double d) throws TrackerException {
        DistanceMode distanceMode = this.trk.distanceMeasureMode();
        TargetType targetType = this.trk.targetType();
        if (distanceMode instanceof InterferometerOnly) {
            if (targetType instanceof SMRTargetType) {
                this.trk.command(String.valueOf(String.valueOf(new StringBuffer("sd ").append(d).append("!"))), 6000);
            } else if (targetType instanceof MirrorTargetType) {
                this.trk.command("sd ".concat(String.valueOf(String.valueOf(d))), 6000);
            }
        } else if (distanceMode instanceof InterferometerSetByADM && (targetType instanceof SMRTargetType || targetType instanceof MirrorTargetType)) {
            this.trk.command(String.valueOf(String.valueOf(new StringBuffer("sd ").append(d).append("?"))), 6000);
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void setExclusiveAccess() throws TrackerException {
        int n;
        for (n = 0; n < 10; ++n) {
            try {
                this.trk.setExclusiveAccess();
                break;
            }
            catch (InterfaceBusyException interfaceBusyException) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        if (10 == n) {
            this.trk.setExclusiveAccess();
        }
        this.hasExclusiveAccess = true;
    }

    private void clearExclusiveAccess() throws TrackerException {
        this.trk.clearExclusiveAccess();
        this.hasExclusiveAccess = false;
    }

    /*
     * Loose catch block
     */
    public void run() {
        Object object2222;
        boolean bl;
        Object[] objectArray;
        DataTag[] dataTagArray;
        int n;
        int n2;
        block65: {
            n2 = 0;
            n = 0;
            dataTagArray = new DataTag[]{new DataTagUnsigned32("motor_state.int_output"), new DataTagUnsigned32("control_mode.int_output"), new DataTagUnsigned32("adm_state.int_output"), new DataTagUnsigned32("shutter_state.int_output")};
            objectArray = new Object[]{null, null, null};
            bl = this.trk.getBlocking();
            this.setExclusiveAccess();
            this.trk.setBlocking(true);
            objectArray[1] = this.getStateInfo(dataTagArray);
            Object var10_6 = null;
            try {
                if (this.hasExclusiveAccess) {
                    this.trk.setBlocking(bl);
                    this.clearExclusiveAccess();
                }
                break block65;
            }
            catch (TrackerException object2222) {}
            break block65;
            {
                catch (TrackerException trackerException) {
                    objectArray[0] = trackerException;
                    var10_6 = null;
                    try {
                        if (this.hasExclusiveAccess) {
                            this.trk.setBlocking(bl);
                            this.clearExclusiveAccess();
                        }
                        break block65;
                    }
                    catch (TrackerException object2222) {}
                }
            }
            catch (Throwable throwable) {
                Object var10_7 = null;
                try {
                    if (this.hasExclusiveAccess) {
                        this.trk.setBlocking(bl);
                        this.clearExclusiveAccess();
                    }
                }
                catch (TrackerException trackerException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            this.response.send(objectArray);
            if (this.listener != null) {
                this.listener.commandComplete();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (objectArray[0] != null) {
            return;
        }
        while (!this.shutdownFlag) {
            boolean bl2 = false;
            try {
                Object[] objectArray2;
                this.command.browse();
                object2222 = this;
                synchronized (object2222) {
                    objectArray2 = this.command.receive();
                    this.commandInProgress = true;
                    n2 = (Integer)objectArray2[0];
                    n = (Integer)objectArray2[1];
                    objectArray = new Object[]{null, null, null};
                }
                if (n2 != 0 && !this.hasExclusiveAccess) {
                    this.setExclusiveAccess();
                    bl = this.trk.getBlocking();
                    this.trk.setBlocking(true);
                }
                switch (n2) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        this.trk.home(((Boolean)objectArray2[2]).booleanValue());
                        break;
                    }
                    case 3: {
                        this.trk.toggleSightOrientation();
                        break;
                    }
                    case 4: {
                        this.trk.changeTrackingState(((Boolean)objectArray2[2]).booleanValue());
                        break;
                    }
                    case 5: {
                        this.trk.changeMotorState(((Boolean)objectArray2[2]).booleanValue());
                        break;
                    }
                    case 6: {
                        this.trk.initialize();
                        break;
                    }
                    case 7: {
                        this.trk.command("hilightbeam", 10000);
                        break;
                    }
                    case 8: {
                        objectArray[2] = this.getSearchData();
                        break;
                    }
                    case 10: {
                        objectArray[2] = this.getTempCfgData();
                        break;
                    }
                    case 25: {
                        this.trk.command("hilightbeam", 10000);
                        break;
                    }
                    case 11: {
                        this.setTempCfgData((Object[])objectArray2[2]);
                        break;
                    }
                    case 9: {
                        if (4 == objectArray2.length) {
                            this.trk.search(((Double)objectArray2[2]).doubleValue(), ((Double)objectArray2[3]).doubleValue());
                        } else {
                            this.trk.search(((Double)objectArray2[2]).doubleValue());
                        }
                        break;
                    }
                    case 12: {
                        bl2 = true;
                        this.trk.command(String.valueOf(String.valueOf(new StringBuffer("slew ").append((Double)objectArray2[2]).append(" ").append((Double)objectArray2[3]).append(" 0.5"))), 500000);
                        break;
                    }
                    case 13: {
                        objectArray[2] = new Object[1];
                        ((Object[])objectArray[2])[0] = this.trk.distanceMeasureMode();
                        break;
                    }
                    case 14: {
                        this.trk.changeDistanceMeasureMode((DistanceMode)objectArray2[2]);
                        break;
                    }
                    case 15: {
                        objectArray[2] = new Object[1];
                        ((Object[])objectArray[2])[0] = this.trk.targetType();
                        break;
                    }
                    case 16: {
                        this.trk.changeTargetType((TargetType)objectArray2[2]);
                        break;
                    }
                    case 17: {
                        this.trk.command("shutter ".concat(String.valueOf(String.valueOf((Boolean)objectArray2[2] != false ? "open" : "close"))), 6000);
                        break;
                    }
                    case 19: {
                        objectArray[2] = this.getTimeStamp();
                        break;
                    }
                    case 20: {
                        this.writeTimeStamp(objectArray2[2].toString());
                        break;
                    }
                    case 21: {
                        this.startBkndMeasurement((FactoryBkndMeasureDataListener)objectArray2[2], (DataTag[])objectArray2[3]);
                        break;
                    }
                    case 22: {
                        this.stopBkndMeasurement((FactoryBkndMeasureDataListener)objectArray2[2]);
                        break;
                    }
                    case 23: {
                        this.setDistAndMove(objectArray2[2].toString(), objectArray2[3].toString(), objectArray2[4].toString());
                        break;
                    }
                    case 24: {
                        objectArray[2] = this.readOneTimeData((DataTag[])objectArray2[2]);
                        break;
                    }
                    case 26: {
                        this.trk.writeOneTimeData((DataTag[])objectArray2[2], (Object[])objectArray2[3]);
                        break;
                    }
                    case 27: {
                        this.setDistance((Double)objectArray2[2]);
                        break;
                    }
                    default: {
                        throw new TrackerException("Thread received unexpected command");
                    }
                }
            }
            catch (TrackerException trackerException) {
                objectArray[0] = trackerException instanceof AbortedException ? null : trackerException;
            }
            catch (IOException iOException) {
                if (this.shutdownFlag) break;
                iOException.printStackTrace();
            }
            object2222 = this;
            synchronized (object2222) {
                this.commandInProgress = false;
                objectArray[1] = !bl2 ? this.getStateInfo(dataTagArray) : null;
                try {
                    if (this.hasExclusiveAccess && 1 == n) {
                        this.trk.setBlocking(bl);
                        this.clearExclusiveAccess();
                    }
                }
                catch (TrackerException trackerException) {
                    trackerException.printStackTrace();
                }
                try {
                    this.response.send(objectArray);
                    if (this.listener != null) {
                        this.listener.commandComplete();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        this.response.close();
        try {
            if (this.hasExclusiveAccess) {
                this.trk.setBlocking(bl);
                this.clearExclusiveAccess();
            }
        }
        catch (TrackerException trackerException) {
            // empty catch block
        }
    }

    public void shutdown() {
        this.shutdownFlag = true;
        this.command.close();
        for (int i = 0; i < 5 && this.commandInProgress; ++i) {
            this.trk.abort();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void addThreadListener(ThreadListener threadListener) throws TooManyListenersException {
        if (this.listener != null) {
            throw new TooManyListenersException();
        }
        this.listener = threadListener;
    }

    public void removeThreadListener(ThreadListener threadListener) {
        if (threadListener == this.listener) {
            this.listener = null;
        }
    }

    static {
        NULL_COMMAND = 0;
        NOP = 1;
        HOME = 2;
        BACKSIGHT = 3;
        TRACKING = 4;
        MOTORS = 5;
        INITIALIZE = 6;
        FIND_BEAM = 7;
        GET_SEARCH_DATA = 8;
        SEARCH = 9;
        GET_TEMP_CFG_DATA = 10;
        SET_TEMP_CFG_DATA = 11;
        SET_AXIS_VELOCITY = 12;
        GET_DISTANCE_MEASURE_MODE = 13;
        SET_DISTANCE_MEASURE_MODE = 14;
        GET_TARGET_TYPE = 15;
        SET_TARGET_TYPE = 16;
        SHUTTER = 17;
        GET_TIME_STAMP = 19;
        WRITE_TIME_STAMP = 20;
        START_BKND_MEASURE = 21;
        STOP_BKND_MEASURE = 22;
        SET_DISTANCE_THEN_MOVE = 23;
        READ_ONE_TIME_DATA = 24;
        HIGHLIGHT_BEAM = 25;
        WRITE_ONE_TIME_DATA = 26;
        SET_DISTANCE = 27;
        KEEP_EXCLUSIVE_ACCESS_AT_END = 0;
        CLEAR_EXCLUSIVE_ACCESS_AT_END = 1;
        SAMPLE_RATE = 1;
        DATA_LISTENER_RATE = 0.25;
    }
}

