/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.apps4xxx.trackerpad;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TooManyListenersException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import smx.tracker.DataTag;
import smx.tracker.DataTagDouble;
import smx.tracker.DataTagUnsigned32;
import smx.tracker.DataTagUnsigned8;
import smx.tracker.DistanceMode;
import smx.tracker.InterferometerOnly;
import smx.tracker.InterferometerSetByADM;
import smx.tracker.TargetType;
import smx.tracker.Tracker;
import smx.tracker.TrackerApp;
import smx.tracker.TrackerException;
import smx.tracker.apps4xxx.PleaseWait;
import smx.tracker.apps4xxx.trackerpad.DistanceModeCfg;
import smx.tracker.apps4xxx.trackerpad.DriveOptUtil;
import smx.tracker.apps4xxx.trackerpad.DriveOption;
import smx.tracker.apps4xxx.trackerpad.SearchCfg;
import smx.tracker.apps4xxx.trackerpad.SetDistance;
import smx.tracker.apps4xxx.trackerpad.TargetTypeCfg;
import smx.tracker.apps4xxx.trackerpad.TempCfg;
import smx.tracker.apps4xxx.trackerpad.TrackerPadThread;
import smx.tracker.apps4xxx.trackerpad.WeatherCfg;
import smx.tracker.apps4xxx.trackerpad.setTime;
import smx.tracker.apps4xxx.utility.ThreadListener;
import smx.tracker.apps4xxx.utility.TrackerExceptionString;
import smx.tracker.event.BusyEvent;
import smx.tracker.event.BusyListener;

public class TrackerPad
extends TrackerApp {
    private TrackerPadThread padThread = null;
    private boolean busy = false;
    private boolean buttonLockout = false;
    private PleaseWait pleaseWaitDialog = null;
    private setDistCmdComplete setDistListener = new setDistCmdComplete();
    private boolean trackingOn = true;
    private boolean motorsOn = false;
    private boolean motorsFailed = true;
    private boolean admCapable = false;
    private boolean backsightMode = false;
    private boolean shutterOpen = true;
    private boolean appIsStable = false;
    private String appFraction = "";
    private ThreadCmdComplete threadComplete = new ThreadCmdComplete();
    private BusyThreadListener busyListener = new BusyThreadListener();
    public static final ResourceBundle res = ResourceBundle.getBundle("smx.tracker.apps4xxx.trackerpad.TrackerPadBundle", Locale.getDefault());
    public static MessageFormat formatter = new MessageFormat("");
    public static NumberFormat form = NumberFormat.getNumberInstance(Locale.getDefault());
    JButton homeButton = new JButton();
    JButton trackingButton = new JButton();
    JButton motorsButton = new JButton();
    JButton searchButton = new JButton();
    JButton distanceModeButton = new JButton();
    JButton initializeButton = new JButton();
    JButton findBeamButton = new JButton();
    JButton setTargetButton = new JButton();
    JButton weatherButton = new JButton();
    JButton tempCfgButton = new JButton();
    JButton backsightButton = new JButton();
    JPanel buttonPanel = new JPanel();
    JPanel closePanel = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JButton closeButton = new JButton();
    GridLayout gridLayout1 = new GridLayout();
    JButton shutterButton = new JButton();
    JButton timeButton = new JButton();
    JButton driveOptionButton = new JButton();
    JButton setDistanceButton = new JButton();
    static Class class$smx$tracker$TrackerException;

    private void enableButtons(boolean bl) {
        boolean bl2 = bl && !this.buttonLockout;
        Component[] componentArray = this.buttonPanel.getComponents();
        int n = componentArray.length;
        for (int i = 0; i < n; ++i) {
            if (!(componentArray[i] instanceof JButton)) continue;
            ((JButton)componentArray[i]).setEnabled(bl2);
        }
        this.closeButton.setEnabled(bl);
        if (bl) {
            if (!this.motorsOn || this.motorsFailed) {
                this.homeButton.setEnabled(false);
                this.searchButton.setEnabled(false);
                this.findBeamButton.setEnabled(false);
                this.driveOptionButton.setEnabled(false);
                this.backsightButton.setEnabled(false);
            }
            if (!this.admCapable) {
                this.distanceModeButton.setEnabled(true);
            }
            if (this.motorsFailed) {
                this.motorsButton.setEnabled(false);
            }
            if (this.motorsOn) {
                this.motorsButton.setText(res.getString("Turn_Motors_Off"));
            } else {
                this.motorsButton.setText(res.getString("Turn_Motors_On"));
            }
            if (this.trackingOn) {
                this.trackingButton.setText(res.getString("Turn_Tracking_Off"));
            } else {
                this.trackingButton.setText(res.getString("Turn_Tracking_On"));
            }
            if (this.shutterOpen) {
                this.shutterButton.setText(res.getString("Close_Shutter"));
            } else {
                this.shutterButton.setText(res.getString("Open_Shutter"));
            }
        }
    }

    private void setButtonLockout(boolean bl) {
        this.buttonLockout = bl;
    }

    private synchronized void setBusy(boolean bl) {
        this.busy = bl;
        this.enableButtons(!bl);
    }

    private void padInit() {
        this.trk.addBusyListener((BusyListener)this.busyListener);
        this.padThread = new TrackerPadThread(this.trk, this.threadComplete);
    }

    private void processAppFraction(String string) {
        if (string == null) {
            return;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "-", true);
            while (true) {
                String string2;
                if (!(string2 = stringTokenizer.nextToken()).equals("-")) {
                    continue;
                }
                while ((string2 = stringTokenizer.nextToken()).equals("-")) {
                }
                string2 = string2.trim();
                switch (string2.charAt(0)) {
                    case 'a': {
                        this.appFraction = string2.substring(1).trim();
                        this.appFraction = this.appFraction.toUpperCase();
                    }
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    private void processButtonSetting(String string) {
        JButton jButton = null;
        try {
            boolean bl;
            String string2 = string.substring(1);
            string2 = string2.trim();
            int n = string.indexOf("=");
            if (-1 == n) {
                return;
            }
            String string3 = string.substring(n + 1);
            if ((string3 = string3.trim()).equalsIgnoreCase("off")) {
                bl = false;
            } else if (string3.equalsIgnoreCase("on")) {
                bl = true;
            } else {
                return;
            }
            if (string2.startsWith("Initialize")) {
                jButton = this.initializeButton;
            }
            if (string2.startsWith("Home")) {
                jButton = this.homeButton;
            }
            if (string2.startsWith("MotorState")) {
                jButton = this.motorsButton;
            }
            if (string2.startsWith("TrackingMode")) {
                jButton = this.trackingButton;
            }
            if (string2.startsWith("ShutterState")) {
                jButton = this.shutterButton;
            }
            if (string2.startsWith("Backsight")) {
                jButton = this.backsightButton;
            }
            if (string2.startsWith("SearchT")) {
                jButton = this.searchButton;
            }
            if (string2.startsWith("HighlightBeam")) {
                jButton = this.findBeamButton;
            }
            if (string2.startsWith("DriveOption")) {
                jButton = this.driveOptionButton;
            }
            if (string2.startsWith("DistMode")) {
                jButton = this.distanceModeButton;
            }
            if (string2.startsWith("SetTarget")) {
                jButton = this.setTargetButton;
            }
            if (string2.startsWith("SetWeather")) {
                jButton = this.weatherButton;
            }
            if (string2.startsWith("TempConfig")) {
                jButton = this.tempCfgButton;
            }
            if (string2.startsWith("SetTime")) {
                jButton = this.timeButton;
            }
            if (string2.startsWith("SetDistance")) {
                jButton = this.setDistanceButton;
            }
            if (jButton != null) {
                if (bl) {
                    this.buttonPanel.add(jButton);
                } else {
                    this.buttonPanel.remove(jButton);
                }
            }
            if (string2.startsWith("Close")) {
                jButton = this.closeButton;
                if (bl) {
                    this.closePanel.add(jButton);
                } else {
                    this.closePanel.remove(jButton);
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private void processParam(String string) {
        if (string == null) {
            return;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "-", true);
            while (true) {
                String string2;
                if (!(string2 = stringTokenizer.nextToken()).equals("-")) {
                    continue;
                }
                while ((string2 = stringTokenizer.nextToken()).equals("-")) {
                }
                string2 = string2.trim();
                switch (string2.charAt(0)) {
                    case 'b': {
                        this.processButtonSetting(string2);
                    }
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    public TrackerPad(String string, Tracker tracker, JFrame jFrame) {
        super(string, tracker, jFrame);
        this.processAppFraction(string);
        try {
            if (!this.appFraction.equals("")) {
                ((JComponent)((Object)this)).setVisible(false);
            } else {
                this.jbInit();
            }
            this.processParam(string);
            this.padInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.homeButton.setText(res.getString("Home"));
        this.homeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrackerPad.this.homeButton_actionPerformed(actionEvent);
            }
        });
        ((Container)((Object)this)).setLayout(this.borderLayout1);
        this.trackingButton.setText(res.getString("Tracking"));
        this.trackingButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrackerPad.this.trackingButton_actionPerformed(actionEvent);
            }
        });
        this.motorsButton.setText(res.getString("Motors"));
        this.motorsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrackerPad.this.motorsButton_actionPerformed(actionEvent);
            }
        });
        this.searchButton.setText(res.getString("Search"));
        this.searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrackerPad.this.searchButton_actionPerformed(actionEvent);
            }
        });
        this.distanceModeButton.setText(res.getString("Distance_Measure_Mode"));
        this.distanceModeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrackerPad.this.distanceModeButton_actionPerformed(actionEvent);
            }
        });
        this.initializeButton.setText(res.getString("Initialize"));
        this.initializeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrackerPad.this.initializeButton_actionPerformed(actionEvent);
            }
        });
        this.findBeamButton.setText(res.getString("Highlight_Beam"));
        this.findBeamButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrackerPad.this.findBeamButton_actionPerformed(actionEvent);
            }
        });
        this.setTargetButton.setText(res.getString("Set_Target_Type"));
        this.setTargetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrackerPad.this.setTargetButton_actionPerformed(actionEvent);
            }
        });
        this.weatherButton.setText(res.getString("Weather_Settings"));
        this.weatherButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrackerPad.this.weatherButton_actionPerformed(actionEvent);
            }
        });
        this.tempCfgButton.setText(res.getString("Temperature_Sensor_Config"));
        this.tempCfgButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrackerPad.this.tempCfgButton_actionPerformed(actionEvent);
            }
        });
        this.backsightButton.setText(res.getString("Backsight"));
        this.backsightButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrackerPad.this.backsightButton_actionPerformed(actionEvent);
            }
        });
        this.buttonPanel.setLayout(this.gridLayout1);
        this.closeButton.setText(res.getString("Close"));
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrackerPad.this.closeButton_actionPerformed(actionEvent);
            }
        });
        this.gridLayout1.setColumns(1);
        this.gridLayout1.setRows(0);
        this.gridLayout1.setVgap(3);
        this.shutterButton.setText(res.getString("Shutter"));
        this.shutterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrackerPad.this.shutterButton_actionPerformed(actionEvent);
            }
        });
        this.timeButton.setText(res.getString("Set_Time"));
        this.timeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrackerPad.this.timeButton_actionPerformed(actionEvent);
            }
        });
        this.driveOptionButton.setText(res.getString("Drive_Option"));
        this.driveOptionButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrackerPad.this.driveOptionButton_actionPerformed(actionEvent);
            }
        });
        this.setDistanceButton.setText(res.getString("Set_Distance"));
        this.setDistanceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrackerPad.this.setDistanceButton_actionPerformed(actionEvent);
            }
        });
        ((Container)((Object)this)).add(this.closePanel, "South");
        ((Container)((Object)this)).add(this.buttonPanel, "Center");
        this.buttonPanel.add((Component)this.initializeButton, null);
        this.buttonPanel.add((Component)this.homeButton, null);
        this.buttonPanel.add((Component)this.motorsButton, null);
        this.buttonPanel.add((Component)this.trackingButton, null);
        this.buttonPanel.add((Component)this.shutterButton, null);
        this.buttonPanel.add((Component)this.backsightButton, null);
        this.buttonPanel.add((Component)this.searchButton, null);
        this.buttonPanel.add((Component)this.findBeamButton, null);
        this.buttonPanel.add((Component)this.driveOptionButton, null);
        this.buttonPanel.add((Component)this.distanceModeButton, null);
        this.buttonPanel.add((Component)this.setTargetButton, null);
        this.buttonPanel.add((Component)this.weatherButton, null);
        this.buttonPanel.add((Component)this.tempCfgButton, null);
        this.buttonPanel.add((Component)this.timeButton, null);
        this.buttonPanel.add((Component)this.setDistanceButton, null);
    }

    private synchronized void signalAppStable() {
        if (!this.appIsStable) {
            this.appIsStable = true;
            ((Object)((Object)this)).notifyAll();
        }
    }

    public synchronized void waitUntilStable() {
        try {
            while (!this.appIsStable) {
                ((Object)((Object)this)).wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void stop() {
        this.trk.removeBusyListener((BusyListener)this.busyListener);
        this.setButtonLockout(true);
        this.enableButtons(false);
        this.padThread.shutdown();
        this.padThread = null;
        super.stop();
    }

    private Object[] processResponse(Object[] objectArray) {
        Object[] objectArray2;
        if (objectArray[0] != null) {
            TrackerExceptionString.displayErrorToUser(this.frame, (TrackerException)((Object)objectArray[0]), res.getString("Error"), "");
        }
        if ((class$smx$tracker$TrackerException == null ? (class$smx$tracker$TrackerException = TrackerPad.class$("smx.tracker.TrackerException")) : class$smx$tracker$TrackerException).isAssignableFrom((objectArray2 = (Object[])objectArray[1])[0].getClass())) {
            TrackerExceptionString.displayErrorToUser(this.frame, (TrackerException)((Object)objectArray2[0]), res.getString("Error"), "");
        } else {
            this.motorsOn = (long)1 == (Long)objectArray2[0];
            this.motorsFailed = (long)2 == (Long)objectArray2[0];
            this.trackingOn = (long)0 == (Long)objectArray2[1];
            this.admCapable = (long)1 == (Long)objectArray2[2];
            this.shutterOpen = (long)1 == (Long)objectArray2[3];
        }
        return (Object[])objectArray[2];
    }

    private void onThreadCmdComplete() {
        if (this.pleaseWaitDialog != null) {
            this.pleaseWaitDialog.dispose();
            this.pleaseWaitDialog = null;
        }
        Object[] objectArray = this.padThread.receiveResponse();
        this.processResponse(objectArray);
        this.setBusy(false);
    }

    private Object[] doThreadTransaction(Object[] objectArray, String string, boolean bl) {
        if (!bl) {
            try {
                this.padThread.addThreadListener(this.threadComplete);
            }
            catch (TooManyListenersException tooManyListenersException) {
                JOptionPane.showMessageDialog((Component)((Object)this), res.getString("Too_Many_Listener"), res.getString("Internal_Error"), 0);
                Object[] objectArray2 = null;
                return objectArray2;
            }
            this.setBusy(true);
            this.pleaseWaitDialog = new PleaseWait((Frame)this.frame, string, this.trk, true);
        }
        this.padThread.sendCommand(objectArray);
        if (bl) {
            Object[] objectArray3 = this.padThread.receiveResponse();
            this.processResponse(objectArray3);
            return (Object[])objectArray3[2];
        }
        return null;
    }

    void homeButton_actionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = new Object[]{new Integer(2), new Integer(1), new Boolean(this.backsightMode)};
        this.doThreadTransaction(objectArray, res.getString("Home"), false);
    }

    void initializeButton_actionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = new Object[]{new Integer(6), new Integer(1)};
        this.doThreadTransaction(objectArray, res.getString("Initialize"), false);
    }

    void trackingButton_actionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = new Object[]{new Integer(4), new Integer(1), new Boolean(!this.trackingOn)};
        this.doThreadTransaction(objectArray, res.getString("Change_Tracking"), false);
    }

    void findBeamButton_actionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = new Object[]{new Integer(7), new Integer(1)};
        this.doThreadTransaction(objectArray, res.getString("Highlight_Beam"), false);
    }

    void searchButton_actionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = new Object[]{new Integer(8), new Integer(0)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, "Get Search Data", true);
        if (objectArray2 == null) {
            return;
        }
        SearchCfg searchCfg = new SearchCfg(this.frame, res.getString("Search_Config"), true, this.lengthUnits, objectArray2);
        if (searchCfg.paramsSet()) {
            if (searchCfg.useEstimatedRange()) {
                objectArray = new Object[4];
                objectArray[2] = new Double(searchCfg.searchRadius());
                objectArray[3] = new Double(searchCfg.estimatedRange());
            } else {
                objectArray = new Object[3];
                objectArray[2] = new Double(searchCfg.searchRadius());
            }
            objectArray[0] = new Integer(9);
            objectArray[1] = new Integer(1);
            this.doThreadTransaction(objectArray, res.getString("SearchT"), false);
        } else {
            objectArray[0] = new Integer(1);
            objectArray[1] = new Integer(1);
            this.doThreadTransaction(objectArray, "NOP", true);
        }
    }

    void motorsButton_actionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = new Object[]{new Integer(5), new Integer(1), new Boolean(!this.motorsOn)};
        this.doThreadTransaction(objectArray, res.getString("Change_Motor_State"), false);
    }

    void tempCfgButton_actionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = new Object[]{new Integer(10), new Integer(0)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, "Read Temperature Data", true);
        if (objectArray2 == null) {
            return;
        }
        TempCfg tempCfg = new TempCfg((Frame)this.frame, res.getString("Temperature_Config"), true, objectArray2);
        objectArray2 = tempCfg.getData();
        if (objectArray2 != null) {
            objectArray = new Object[]{new Integer(11), new Integer(1), objectArray2};
            objectArray2 = this.doThreadTransaction(objectArray, "Write Temperature Data", true);
        } else {
            objectArray[0] = new Integer(1);
            objectArray[1] = new Integer(1);
            objectArray2 = this.doThreadTransaction(objectArray, "NOP", true);
        }
    }

    void onBusy(BusyEvent busyEvent) {
        this.setBusy(busyEvent.getCommandState() || busyEvent.getMeasureState());
    }

    void backsightButton_actionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = new Object[]{new Integer(3), new Integer(1)};
        this.doThreadTransaction(objectArray, res.getString("Backsight"), false);
        this.backsightMode = !this.backsightMode;
    }

    void distanceModeButton_actionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = new Object[]{new Integer(13), new Integer(0)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, "Get Distance Mode", true);
        DistanceMode distanceMode = (DistanceMode)objectArray2[0];
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("adm_meas_time.int_output")};
        objectArray = new Object[]{new Integer(24), new Integer(0), dataTagArray};
        objectArray2 = this.doThreadTransaction(objectArray, "Read one time data", true);
        long l = (Long)objectArray2[0] / (long)1000000;
        Long l2 = new Long(l);
        String string = l2.toString();
        DistanceModeCfg distanceModeCfg = new DistanceModeCfg(this.frame, res.getString("Select_Dist_Measure_Mode"), true, distanceMode, string);
        distanceMode = distanceModeCfg.getMode();
        if (distanceMode != null) {
            objectArray = new Object[]{new Integer(14), new Integer(1), distanceMode};
            this.doThreadTransaction(objectArray, res.getString("Set_Distance_Mode"), true);
        } else {
            objectArray = new Object[]{new Integer(1), new Integer(1)};
            this.doThreadTransaction(objectArray, "NOP", true);
        }
        double d = distanceModeCfg.getADMMeasTime();
        if (d != 0.0) {
            dataTagArray = new DataTag[]{new DataTagUnsigned32("adm_meas_time.int_output")};
            Object[] objectArray3 = new Object[]{new Long((long)(d * (double)1000000))};
            System.out.println(" ADM meas time (micro secs)= ".concat(String.valueOf(String.valueOf((Long)objectArray3[0]))));
            objectArray = new Object[]{new Integer(26), new Integer(1), dataTagArray, objectArray3};
            this.doThreadTransaction(objectArray, "Write one time data", true);
        } else {
            objectArray = new Object[]{new Integer(1), new Integer(1)};
            this.doThreadTransaction(objectArray, "NOP", true);
        }
    }

    void setTargetButton_actionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = new Object[]{new Integer(15), new Integer(0)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, "Get Target Type", true);
        TargetType targetType = (TargetType)objectArray2[0];
        TargetTypeCfg targetTypeCfg = new TargetTypeCfg((Frame)this.frame, res.getString("Select_Target"), true, targetType);
        targetType = targetTypeCfg.getTargetType();
        if (targetType != null) {
            objectArray = new Object[]{new Integer(16), new Integer(1), targetType};
            this.doThreadTransaction(objectArray, res.getString("Set_Target_TypeT"), false);
        } else {
            objectArray = new Object[]{new Integer(1), new Integer(1)};
            this.doThreadTransaction(objectArray, "NOP", true);
        }
    }

    void closeButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.trk.stopApplication("TrackerPad");
        }
        catch (TrackerException trackerException) {
            // empty catch block
        }
    }

    void shutterButton_actionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = new Object[]{new Integer(17), new Integer(1), new Boolean(!this.shutterOpen)};
        this.doThreadTransaction(objectArray, res.getString("Change_Shutter_State"), false);
    }

    void timeButton_actionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = new Object[]{new Integer(19), new Integer(0)};
        Object[] objectArray2 = this.doThreadTransaction(objectArray, "", true);
        setTime setTime2 = new setTime(this.frame, res.getString("Set_TimeT"), objectArray2, this.padThread, true);
        objectArray[0] = new Integer(1);
        objectArray[1] = new Integer(1);
        this.doThreadTransaction(objectArray, "NOP", true);
    }

    void driveOptionButton_actionPerformed(ActionEvent actionEvent) {
        DriveOption driveOption = new DriveOption(this.frame, res.getString("Drive_Option"), this.padThread, this.trackingOn, this.backsightMode, this.motorsOn, this.lengthUnits, this.angularUnits, this.trk, true);
        driveOption.show();
    }

    void weatherButton_actionPerformed(ActionEvent actionEvent) {
        DataTag[] dataTagArray = new DataTag[5];
        Object[] objectArray = null;
        Object[] objectArray2 = null;
        dataTagArray[0] = new DataTagDouble("air_pressure.manual_input");
        dataTagArray[1] = new DataTagUnsigned8("air_pressure.input_selector");
        dataTagArray[2] = new DataTagDouble("humidity.manual_input");
        dataTagArray[3] = new DataTagDouble("ambient_temp.manual_input");
        dataTagArray[4] = new DataTagUnsigned8("ambient_temp.input_selector");
        objectArray = new Object[]{new Integer(24), new Integer(0), dataTagArray};
        objectArray2 = this.doThreadTransaction(objectArray, "Read one time data", true);
        WeatherCfg weatherCfg = new WeatherCfg(this.frame, res.getString("Weather_Config"), objectArray2, this.padThread, this.pressureUnits, this.temperatureUnits, true);
        weatherCfg.show();
    }

    private void showAppFraction() {
        if (!this.appFraction.equals("")) {
            if (this.appFraction.equals("SEARCH_CFG")) {
                DriveOptUtil.searchTarget(this.padThread, this.frame, this.trk, this.lengthUnits);
                return;
            }
            if (this.appFraction.equals("SET_DISTANCE")) {
                if (!this.openSetDistance()) {
                    return;
                }
            } else {
                DriveOption driveOption = new DriveOption(this.frame, res.getString("Drive_OptionT"), this.padThread, this.trackingOn, this.backsightMode, this.motorsOn, this.lengthUnits, this.angularUnits, this.trk, true);
                if (this.appFraction.equals("VISUAL_DRIVE")) {
                    driveOption.openVisualDrive();
                } else if (this.appFraction.equals("ANGULAR_DRIVE")) {
                    driveOption.openAngularDrive();
                } else if (this.appFraction.equals("MANUAL_DRIVE")) {
                    driveOption.openManualDrive();
                }
            }
            this.closeApplication();
        }
    }

    void setDistanceButton_actionPerformed(ActionEvent actionEvent) {
        this.openSetDistance();
    }

    private boolean openSetDistance() {
        DataTag[] dataTagArray = new DataTag[1];
        Object[] objectArray = null;
        Object[] objectArray2 = null;
        Object[] objectArray3 = null;
        DistanceMode distanceMode = null;
        dataTagArray[0] = new DataTagDouble("Dist.Output");
        objectArray = new Object[]{new Integer(24), new Integer(0), dataTagArray};
        objectArray2 = this.doThreadTransaction(objectArray, "Read one time data", true);
        objectArray = new Object[]{new Integer(13), new Integer(0)};
        objectArray3 = this.doThreadTransaction(objectArray, "Get Distance Mode", true);
        distanceMode = (DistanceMode)objectArray3[0];
        if (distanceMode instanceof InterferometerOnly) {
            SetDistance setDistance = new SetDistance(this.frame, res.getString("Set_DistanceT"), this.padThread, objectArray2, this.lengthUnits, true);
            objectArray = new Object[]{new Integer(1), new Integer(1)};
            this.doThreadTransaction(objectArray, "NOP", true);
            return true;
        }
        if (distanceMode instanceof InterferometerSetByADM) {
            this.pleaseWaitDialog = new PleaseWait((Frame)this.frame, "Set distance", this.trk, true);
            objectArray = new Object[]{new Integer(27), new Integer(1), new Double((Double)objectArray2[0])};
            try {
                this.padThread.addThreadListener(this.setDistListener);
            }
            catch (TooManyListenersException tooManyListenersException) {
                // empty catch block
            }
            this.padThread.sendCommand(objectArray);
            return false;
        }
        return true;
    }

    private void closeApplication() {
        try {
            this.trk.stopApplication("TrackerPad");
        }
        catch (TrackerException trackerException) {
            // empty catch block
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class setDistCmdComplete
    implements ThreadListener {
        private setDistCmdComplete() {
        }

        public void commandComplete() {
            TrackerPad.this.padThread.removeThreadListener(this);
            Object[] objectArray = TrackerPad.this.padThread.receiveResponse();
            if (TrackerPad.this.pleaseWaitDialog != null) {
                TrackerPad.this.pleaseWaitDialog.dispose();
            }
            if (objectArray[0] != null) {
                TrackerExceptionString.displayErrorToUser(TrackerPad.this.frame, (TrackerException)((Object)objectArray[0]), res.getString("Error"), "");
            }
            System.out.println("after set dist");
            if (TrackerPad.this.appFraction.equals("SET_DISTANCE")) {
                TrackerPad.this.closeApplication();
            }
        }
    }

    private class BusyThreadListener
    implements BusyListener,
    Runnable {
        private ArrayList event = new ArrayList();

        private BusyThreadListener() {
        }

        public void stateChanged(BusyEvent busyEvent) {
            this.event.add(busyEvent);
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            TrackerPad.this.onBusy((BusyEvent)this.event.remove(0));
        }
    }

    private class ThreadCmdComplete
    implements ThreadListener,
    Runnable {
        private ThreadCmdComplete() {
        }

        public void commandComplete() {
            SwingUtilities.invokeLater(this);
            TrackerPad.this.padThread.removeThreadListener(this);
            TrackerPad.this.signalAppStable();
        }

        public void run() {
            TrackerPad.this.onThreadCmdComplete();
            TrackerPad.this.showAppFraction();
        }
    }
}

