/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.apps4xxx.trackerpad;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.TooManyListenersException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import smx.tracker.DataTag;
import smx.tracker.DataTagDouble;
import smx.tracker.DataTagUnsigned16;
import smx.tracker.MeasureData;
import smx.tracker.Tracker;
import smx.tracker.TrackerException;
import smx.tracker.apps4xxx.trackerpad.DriveOptUtil;
import smx.tracker.apps4xxx.trackerpad.TrackerPad;
import smx.tracker.apps4xxx.trackerpad.TrackerPadThread;
import smx.tracker.apps4xxx.utility.GlassComponent;
import smx.tracker.apps4xxx.utility.ThreadListener;
import smx.tracker.event.FactoryBkndMeasureDataEvent;
import smx.tracker.event.FactoryBkndMeasureDataListener;
import smx.utility.UnitsConversion;

public class ManualDrive
extends JDialog {
    private Frame frame = new Frame();
    private UnitsConversion angularUnits = null;
    private UnitsConversion lengthUnits = null;
    private TrackerPadThread padThread = null;
    private BkndMeasureData bkndListener = new BkndMeasureData();
    private Tracker trk = null;
    private MeasureData[] dataDisplayed = null;
    private double az = 0.0;
    private double ze = 0.0;
    private String azStr = "";
    private String zeStr = "";
    private int azStatus = 0;
    private int zeStatus = 0;
    private boolean error = false;
    private boolean searchInProgress = false;
    private motorsOnCmdComplete motorsOnListener = new motorsOnCmdComplete();
    private motorsOffCmdComplete motorsOffListener = new motorsOffCmdComplete();
    JPanel panel1 = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JButton motorsOff = new JButton();
    JButton motorsOn = new JButton();
    JButton search = new JButton();
    JButton close = new JButton();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JTextField azReading = new JTextField();
    JTextField zeReading = new JTextField();
    JLabel azUnit = new JLabel();
    JLabel zeUnit = new JLabel();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    GridBagLayout gridBagLayout3 = new GridBagLayout();

    private void updateDisplay(FactoryBkndMeasureDataEvent factoryBkndMeasureDataEvent) {
        try {
            this.dataDisplayed = this.trk.readFactoryBkndMeasureData(factoryBkndMeasureDataEvent.getNumMeasurements());
            if (this.error) {
                return;
            }
            if (this.searchInProgress) {
                return;
            }
            this.az = Math.IEEEremainder((Double)this.dataDisplayed[0].getDataElement(0), 1296000.0);
            this.az = Math.toRadians(this.az / (double)3600);
            this.azStatus = (Integer)this.dataDisplayed[0].getDataElement(1);
            this.ze = Math.IEEEremainder((Double)this.dataDisplayed[0].getDataElement(2), 1296000.0);
            this.ze = Math.toRadians(this.ze / (double)3600);
            this.zeStatus = (Integer)this.dataDisplayed[0].getDataElement(3);
            if ((this.azStatus & 2) != 0 || (this.zeStatus & 2) != 0) {
                this.azStr = "";
                this.zeStr = "";
                this.error = true;
                JOptionPane.showConfirmDialog(this, TrackerPad.res.getString("Encoder_Error"), TrackerPad.res.getString("Error"), 0, 0);
                this.stopBkndMeasure();
                this.dispose();
                return;
            }
            this.azStr = this.angularUnits.convertToDisplayStr(this.az);
            this.azReading.setText(this.azStr);
            this.zeStr = this.angularUnits.convertToDisplayStr(this.ze);
            this.zeReading.setText(this.zeStr);
        }
        catch (TrackerException trackerException) {
            trackerException.printStackTrace();
        }
    }

    private void showMotorErrorDialog(String string) {
        JOptionPane.showMessageDialog(this, string, TrackerPad.res.getString("Error"), 0);
    }

    public void restoreCursor() {
        GlassComponent.setWaitState(false, this);
    }

    public void setSearchInProgressFlag(boolean bl) {
        this.searchInProgress = bl;
    }

    public ManualDrive(Frame frame, String string, UnitsConversion unitsConversion, UnitsConversion unitsConversion2, TrackerPadThread trackerPadThread, Tracker tracker, boolean bl) {
        super(frame, string, bl);
        this.frame = frame;
        this.angularUnits = unitsConversion2;
        this.lengthUnits = unitsConversion;
        this.padThread = trackerPadThread;
        this.trk = tracker;
        this.setGlassPane(new GlassComponent());
        try {
            this.jbInit();
            this.pack();
            this.setLocationRelativeTo(frame);
            this.startBkndMeasure(this.bkndListener);
            ((Component)this).setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ManualDrive() {
        this(null, "", null, null, null, null, false);
    }

    void jbInit() throws Exception {
        this.panel1.setLayout(this.gridBagLayout1);
        this.panel1.setPreferredSize(new Dimension(510, 320));
        this.jPanel2.setLayout(this.gridBagLayout3);
        this.motorsOff.setEnabled(false);
        this.motorsOff.setMaximumSize(new Dimension(119, 27));
        this.motorsOff.setMinimumSize(new Dimension(119, 27));
        this.motorsOff.setText(TrackerPad.res.getString("Turn_Motors_Off"));
        this.motorsOn.setText(TrackerPad.res.getString("Turn_Motors_On"));
        this.search.setText(TrackerPad.res.getString("Search"));
        this.close.setText(TrackerPad.res.getString("Close"));
        this.jLabel1.setText(TrackerPad.res.getString("Az"));
        this.jLabel2.setText(TrackerPad.res.getString("Ze"));
        this.azUnit.setText(TrackerPad.res.getString("Radians"));
        this.zeUnit.setText(TrackerPad.res.getString("Radians"));
        this.motorsOff.setMnemonic(TrackerPad.res.getString("Mnemonic_Key_M_For_Motors").charAt(0));
        this.motorsOff.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ManualDrive.this.motorsOff_actionPerformed(actionEvent);
            }
        });
        this.motorsOn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ManualDrive.this.motorsOn_actionPerformed(actionEvent);
            }
        });
        this.motorsOn.setMnemonic(TrackerPad.res.getString("Mnemonic_Key_M_For_Motors").charAt(0));
        this.search.setEnabled(false);
        this.search.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ManualDrive.this.search_actionPerformed(actionEvent);
            }
        });
        this.search.setMnemonic(TrackerPad.res.getString("Mnemonic_Key_S_For_Search").charAt(0));
        this.close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ManualDrive.this.close_actionPerformed(actionEvent);
            }
        });
        this.jPanel1.setLayout(this.gridBagLayout2);
        this.jLabel1.setFont(new Font("SansSerif", 1, 36));
        this.jLabel2.setFont(new Font("SansSerif", 1, 36));
        if (this.angularUnits.displayName().equals(TrackerPad.res.getString("Angular_Degree_Symbol"))) {
            this.azUnit.setFont(new Font("Dialog", 1, 21));
            this.zeUnit.setFont(new Font("Dialog", 1, 21));
        }
        this.azUnit.setText(this.angularUnits.displayName());
        this.zeUnit.setText(this.angularUnits.displayName());
        this.azReading.setEnabled(false);
        this.azReading.setFont(new Font("SansSerif", 1, 46));
        this.azReading.setDisabledTextColor(Color.black);
        this.azReading.setEditable(false);
        this.zeReading.setEnabled(false);
        this.zeReading.setFont(new Font("SansSerif", 1, 46));
        this.zeReading.setDisabledTextColor(Color.black);
        this.zeReading.setEditable(false);
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.jPanel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel1.add((Component)this.azReading, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(23, 6, 3, 2), 0, 10));
        this.jPanel1.add((Component)this.zeUnit, new GridBagConstraints(2, 1, 1, 1, 0.0, 1.0, 10, 1, new Insets(10, 6, 6, 2), 0, 0));
        this.jPanel1.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(20, 10, 2, 2), 9, 19));
        this.jPanel1.add((Component)this.jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 10, 1, new Insets(10, 10, 2, 2), 7, 19));
        this.jPanel1.add((Component)this.azUnit, new GridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(20, 6, 2, 2), 0, 0));
        this.jPanel1.add((Component)this.zeReading, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 6, 6, 2), 0, 10));
        this.panel1.add((Component)this.jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel2.add((Component)this.motorsOff, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 15), 0, 0));
        this.jPanel2.add((Component)this.search, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 15), 0, 0));
        this.jPanel2.add((Component)this.motorsOn, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 15, 5, 0), 0, 0));
        this.jPanel2.add((Component)this.close, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(5, 15, 0, 0), 0, 0));
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                ManualDrive.this.this_componentResized(componentEvent);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ManualDrive.this.stopBkndMeasure();
            }
        });
    }

    void motorsOff_actionPerformed(ActionEvent actionEvent) {
        if (this.motorsOn.isEnabled()) {
            return;
        }
        Object[] objectArray = new Object[]{new Integer(5), new Integer(0), new Boolean(false)};
        try {
            this.padThread.addThreadListener(this.motorsOffListener);
        }
        catch (TooManyListenersException tooManyListenersException) {
            JOptionPane.showMessageDialog(this, TrackerPad.res.getString("Too_Many_Listener"), TrackerPad.res.getString("Internal_Error"), 0);
            return;
        }
        this.setCursor();
        this.padThread.sendCommand(objectArray);
    }

    void motorsOn_actionPerformed(ActionEvent actionEvent) {
        if (this.motorsOff.isEnabled()) {
            return;
        }
        Object[] objectArray = new Object[]{new Integer(5), new Integer(0), new Boolean(true)};
        try {
            this.padThread.addThreadListener(this.motorsOnListener);
        }
        catch (TooManyListenersException tooManyListenersException) {
            JOptionPane.showMessageDialog(this, TrackerPad.res.getString("Too_Many_Listener"), TrackerPad.res.getString("Internal_Error"), 0);
            return;
        }
        this.setCursor();
        this.padThread.sendCommand(objectArray);
    }

    void search_actionPerformed(ActionEvent actionEvent) {
        DriveOptUtil.setParentDialog(this);
        DriveOptUtil.searchTarget(this.padThread, this.frame, this.trk, this.lengthUnits);
    }

    public void setCursor() {
        GlassComponent.setWaitState(true, this);
    }

    void close_actionPerformed(ActionEvent actionEvent) {
        this.stopBkndMeasure();
        this.dispose();
    }

    private void startBkndMeasure(FactoryBkndMeasureDataListener factoryBkndMeasureDataListener) {
        DataTag[] dataTagArray = new DataTag[]{new DataTagDouble("az_motor_in.output"), new DataTagUnsigned16("az_motor_in.status"), new DataTagDouble("el_motor_in.output"), new DataTagUnsigned16("el_motor_in.status")};
        Object[] objectArray = DriveOptUtil.startBkndMeasure(this.padThread, dataTagArray, factoryBkndMeasureDataListener);
        if (objectArray[0] != null) {
            JOptionPane.showConfirmDialog(this, TrackerPad.res.getString("Start_Measure_Failure"), TrackerPad.res.getString("Error"), 2, 0);
            this.dispose();
        }
    }

    private void stopBkndMeasure() {
        Object[] objectArray = DriveOptUtil.stopBkndMeasure(this.padThread, this.bkndListener);
        if (objectArray[0] != null) {
            JOptionPane.showConfirmDialog(this, TrackerPad.res.getString("Stop_Measure_Failure"), TrackerPad.res.getString("Error"), 2, 0);
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (keyEvent.getKeyCode() == 27) {
            this.stopBkndMeasure();
            this.dispose();
        }
    }

    private void this_componentResized(ComponentEvent componentEvent) {
        if (this.azStr.equals("") && this.zeStr.equals("")) {
            return;
        }
        this.resizeFont();
    }

    private void resizeFont() {
        Font font = null;
        font = this.calculateFont();
        if (font == null) {
            return;
        }
        this.azReading.setFont(font);
        this.zeReading.setFont(font);
    }

    private Font calculateFont() {
        FontMetrics fontMetrics;
        boolean bl = false;
        Font font = null;
        double d = 1.0E-10;
        Font font2 = this.azReading.getFont();
        int n = font2.getSize();
        Dimension dimension = this.azReading.getSize();
        if ((double)dimension.width < d || (double)dimension.height < d) {
            return null;
        }
        FontMetrics fontMetrics2 = ((Component)this.azReading).getFontMetrics(font2);
        int n2 = 0;
        n2 = this.azStr.length() > this.zeStr.length() ? fontMetrics2.stringWidth(String.valueOf(String.valueOf(this.azStr)).concat("-")) : fontMetrics2.stringWidth(String.valueOf(String.valueOf(this.zeStr)).concat("-"));
        int n3 = fontMetrics2.getHeight();
        while (n3 > dimension.height || n2 > dimension.width) {
            font = new Font(font2.getFontName(), font2.getStyle(), --n);
            fontMetrics = this.getFontMetrics(font);
            n2 = this.azStr.length() > this.zeStr.length() ? fontMetrics.stringWidth(String.valueOf(String.valueOf(this.azStr)).concat("-")) : fontMetrics.stringWidth(String.valueOf(String.valueOf(this.zeStr)).concat("-"));
            n3 = fontMetrics.getHeight();
        }
        while (n3 < dimension.height && n2 < dimension.width) {
            font = new Font(font2.getFontName(), font2.getStyle(), ++n);
            fontMetrics = this.getFontMetrics(font);
            n2 = this.azStr.length() > this.zeStr.length() ? fontMetrics.stringWidth(String.valueOf(String.valueOf(this.azStr)).concat("-")) : fontMetrics.stringWidth(String.valueOf(String.valueOf(this.zeStr)).concat("-"));
            n3 = fontMetrics.getHeight();
        }
        font = new Font(font2.getFontName(), font2.getStyle(), n - 2);
        return font;
    }

    private class BkndMeasureData
    implements FactoryBkndMeasureDataListener,
    Runnable {
        FactoryBkndMeasureDataEvent data;

        private BkndMeasureData() {
        }

        public void dataAvailable(FactoryBkndMeasureDataEvent factoryBkndMeasureDataEvent) {
            this.data = factoryBkndMeasureDataEvent;
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            ManualDrive.this.updateDisplay(this.data);
        }
    }

    private class motorsOffCmdComplete
    implements ThreadListener,
    Runnable {
        private motorsOffCmdComplete() {
        }

        public void commandComplete() {
            ManualDrive.this.padThread.removeThreadListener(this);
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            Object[] objectArray = ManualDrive.this.padThread.receiveResponse();
            if (objectArray[0] != null) {
                ManualDrive.this.showMotorErrorDialog(TrackerPad.res.getString("Motor_Off_Failure"));
                return;
            }
            ManualDrive.this.motorsOn.setEnabled(true);
            ManualDrive.this.motorsOff.setEnabled(false);
            ManualDrive.this.search.setEnabled(false);
            ManualDrive.this.restoreCursor();
        }
    }

    private class motorsOnCmdComplete
    implements ThreadListener,
    Runnable {
        private motorsOnCmdComplete() {
        }

        public void commandComplete() {
            ManualDrive.this.padThread.removeThreadListener(this);
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            Object[] objectArray = ManualDrive.this.padThread.receiveResponse();
            if (objectArray[0] != null) {
                ManualDrive.this.showMotorErrorDialog(TrackerPad.res.getString("Motor_On_Failure"));
                return;
            }
            ManualDrive.this.motorsOn.setEnabled(false);
            ManualDrive.this.motorsOff.setEnabled(true);
            ManualDrive.this.search.setEnabled(true);
            ManualDrive.this.restoreCursor();
        }
    }
}

