/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.apps4xxx.trackerpad;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import smx.tracker.DataTag;
import smx.tracker.DataTagDouble;
import smx.tracker.DataTagUnsigned16;
import smx.tracker.Tracker;
import smx.tracker.apps4xxx.trackerpad.AngularDrive;
import smx.tracker.apps4xxx.trackerpad.ManualDrive;
import smx.tracker.apps4xxx.trackerpad.TrackerPad;
import smx.tracker.apps4xxx.trackerpad.TrackerPadThread;
import smx.tracker.apps4xxx.trackerpad.VisualDrive;
import smx.utility.UnitsConversion;

public class DriveOption
extends JDialog {
    private TrackerPadThread padThread = null;
    private boolean trackingOn = true;
    private boolean motorsOn = false;
    private boolean backsightMode = false;
    private Frame frame = null;
    private UnitsConversion angularUnits = null;
    private UnitsConversion lengthUnits = null;
    private Tracker trk = null;
    JPanel panel1 = new JPanel();
    JButton visualDrive = new JButton();
    JButton angularDrive = new JButton();
    JButton manualDrive = new JButton();
    JButton cancel = new JButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();

    public DriveOption(Frame frame, String string, TrackerPadThread trackerPadThread, boolean bl, boolean bl2, boolean bl3, UnitsConversion unitsConversion, UnitsConversion unitsConversion2, Tracker tracker, boolean bl4) {
        super(frame, string, bl4);
        this.padThread = trackerPadThread;
        this.trackingOn = bl;
        this.motorsOn = bl3;
        this.backsightMode = bl2;
        this.frame = frame;
        this.angularUnits = unitsConversion2;
        this.lengthUnits = unitsConversion;
        this.trk = tracker;
        try {
            this.jbInit();
            this.pack();
            this.setLocationRelativeTo(frame);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public DriveOption() {
        this(null, "", null, true, false, false, null, null, null, false);
    }

    void jbInit() throws Exception {
        this.panel1.setLayout(this.gridBagLayout1);
        this.visualDrive.setText(TrackerPad.res.getString("Visual_Drive"));
        this.angularDrive.setText(TrackerPad.res.getString("Angular_Drive"));
        this.manualDrive.setText(TrackerPad.res.getString("Manual_Drive"));
        this.cancel.setText(TrackerPad.res.getString("Cancel"));
        this.visualDrive.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DriveOption.this.visualDrive_actionPerformed(actionEvent);
            }
        });
        this.angularDrive.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DriveOption.this.angularDrive_actionPerformed(actionEvent);
            }
        });
        this.manualDrive.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DriveOption.this.manualDrive_actionPerformed(actionEvent);
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DriveOption.this.cancel_actionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.cancel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(31, 44, 45, 61), 44, 0));
        this.panel1.add((Component)this.visualDrive, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(42, 61, 0, 0), 8, 0));
        this.panel1.add((Component)this.angularDrive, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(42, 44, 0, 61), 0, 0));
        this.panel1.add((Component)this.manualDrive, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(31, 61, 45, 0), 2, 0));
    }

    void visualDrive_actionPerformed(ActionEvent actionEvent) {
        this.openVisualDrive();
    }

    public void openVisualDrive() {
        Object[] objectArray = new Object[]{new Integer(4), new Integer(0), new Boolean(false)};
        this.padThread.sendCommand(objectArray);
        this.padThread.receiveResponse();
        this.dispose();
        VisualDrive visualDrive = new VisualDrive(this.frame, TrackerPad.res.getString("Visual_DriveT"), true, this.backsightMode, this.lengthUnits, this.angularUnits, this.trk, this.padThread);
        objectArray = new Object[]{new Integer(4), new Integer(1), new Boolean(this.trackingOn)};
        this.padThread.sendCommand(objectArray);
        this.padThread.receiveResponse();
    }

    void angularDrive_actionPerformed(ActionEvent actionEvent) {
        this.openAngularDrive();
    }

    public void openAngularDrive() {
        DataTag[] dataTagArray = new DataTag[]{new DataTagDouble("az_motor_in.output"), new DataTagUnsigned16("az_motor_in.status"), new DataTagDouble("el_motor_in.output"), new DataTagUnsigned16("el_motor_in.status"), new DataTagDouble("dist.output"), new DataTagUnsigned16("dist.status")};
        Object[] objectArray = new Object[]{new Integer(24), new Integer(0), dataTagArray};
        this.padThread.sendCommand(objectArray);
        Object[] objectArray2 = this.padThread.receiveResponse();
        Object[] objectArray3 = (Object[])objectArray2[2];
        int n = (Integer)objectArray3[1];
        int n2 = (Integer)objectArray3[3];
        int n3 = (Integer)objectArray3[5];
        if (n3 == 1) {
            objectArray3[4] = new Double(5.0);
        }
        this.dispose();
        if ((n & 2) != 0 || (n2 & 2) != 0) {
            JOptionPane.showMessageDialog(this, TrackerPad.res.getString("Encoder_Error"), TrackerPad.res.getString("Error"), 0);
        } else {
            AngularDrive angularDrive = new AngularDrive(this.frame, TrackerPad.res.getString("Angular_DriveT"), this.lengthUnits, this.angularUnits, this.padThread, objectArray3, this.trk, true);
        }
        objectArray = new Object[]{new Integer(1), new Integer(1)};
        this.padThread.sendCommand(objectArray);
        this.padThread.receiveResponse();
    }

    void manualDrive_actionPerformed(ActionEvent actionEvent) {
        this.openManualDrive();
    }

    public void openManualDrive() {
        Object[] objectArray = new Object[]{new Integer(5), new Integer(0), new Boolean(false)};
        this.padThread.sendCommand(objectArray);
        this.padThread.receiveResponse();
        objectArray[0] = new Integer(4);
        objectArray[1] = new Integer(0);
        objectArray[2] = new Boolean(true);
        this.padThread.sendCommand(objectArray);
        this.padThread.receiveResponse();
        this.dispose();
        ManualDrive manualDrive = new ManualDrive(this.frame, TrackerPad.res.getString("Manual_DriveT"), this.lengthUnits, this.angularUnits, this.padThread, this.trk, true);
        objectArray[0] = new Integer(5);
        objectArray[1] = new Integer(0);
        objectArray[2] = new Boolean(this.motorsOn);
        this.padThread.sendCommand(objectArray);
        this.padThread.receiveResponse();
        objectArray[0] = new Integer(4);
        objectArray[1] = new Integer(0);
        objectArray[2] = new Boolean(this.trackingOn);
        this.padThread.sendCommand(objectArray);
        this.padThread.receiveResponse();
        objectArray = new Object[]{new Integer(1), new Integer(1)};
        this.padThread.sendCommand(objectArray);
        this.padThread.receiveResponse();
    }

    void cancel_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }
}

