/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.apps4xxx.trackerpad;

import java.awt.Frame;
import java.util.TooManyListenersException;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import smx.tracker.DataTag;
import smx.tracker.Tracker;
import smx.tracker.TrackerException;
import smx.tracker.apps4xxx.PleaseWait;
import smx.tracker.apps4xxx.trackerpad.AngularDrive;
import smx.tracker.apps4xxx.trackerpad.ManualDrive;
import smx.tracker.apps4xxx.trackerpad.SearchCfg;
import smx.tracker.apps4xxx.trackerpad.TrackerPad;
import smx.tracker.apps4xxx.trackerpad.TrackerPadThread;
import smx.tracker.apps4xxx.trackerpad.VisualDrive;
import smx.tracker.apps4xxx.utility.ThreadListener;
import smx.tracker.apps4xxx.utility.TrackerExceptionString;
import smx.tracker.event.FactoryBkndMeasureDataListener;
import smx.utility.UnitsConversion;

public class DriveOptUtil {
    private static TrackerPadThread thread = null;
    private static searchCmdComplete searchListener = new searchCmdComplete();
    private static PleaseWait waitDlg = null;
    private static AngularDrive angularDialog = null;
    private static ManualDrive manualDialog = null;
    private static VisualDrive visualDialog = null;
    private static Tracker trkInf = null;
    private static boolean useEstimatedRangeFlag = false;

    private static void closeTrackerPad() {
        try {
            trkInf.stopApplication("TrackerPad");
        }
        catch (TrackerException trackerException) {
            // empty catch block
        }
    }

    public static final Object[] startBkndMeasure(TrackerPadThread trackerPadThread, DataTag[] dataTagArray, FactoryBkndMeasureDataListener factoryBkndMeasureDataListener) {
        thread = trackerPadThread;
        Object[] objectArray = new Object[]{new Integer(21), new Integer(0), factoryBkndMeasureDataListener, dataTagArray};
        trackerPadThread.sendCommand(objectArray);
        Object[] objectArray2 = trackerPadThread.receiveResponse();
        return objectArray2;
    }

    public static final Object[] stopBkndMeasure(TrackerPadThread trackerPadThread, FactoryBkndMeasureDataListener factoryBkndMeasureDataListener) {
        Object[] objectArray = new Object[]{new Integer(22), new Integer(0), factoryBkndMeasureDataListener};
        trackerPadThread.sendCommand(objectArray);
        Object[] objectArray2 = trackerPadThread.receiveResponse();
        return objectArray2;
    }

    public static final void searchTarget(TrackerPadThread trackerPadThread, Frame frame, Tracker tracker, UnitsConversion unitsConversion) {
        thread = trackerPadThread;
        trkInf = tracker;
        Object[] objectArray = null;
        Object[] objectArray2 = null;
        objectArray = new Object[]{new Integer(8), new Integer(0)};
        trackerPadThread.sendCommand(objectArray);
        objectArray2 = trackerPadThread.receiveResponse();
        objectArray2 = (Object[])objectArray2[2];
        if (objectArray2 == null) {
            return;
        }
        SearchCfg searchCfg = new SearchCfg(frame, TrackerPad.res.getString("Search_Config"), true, unitsConversion, objectArray2);
        if (searchCfg.paramsSet()) {
            if (searchCfg.useEstimatedRange()) {
                objectArray = new Object[4];
                objectArray[2] = new Double(searchCfg.searchRadius());
                objectArray[3] = new Double(searchCfg.estimatedRange());
            } else {
                objectArray = new Object[3];
                objectArray[2] = new Double(searchCfg.searchRadius());
            }
            objectArray[0] = new Integer(9);
            objectArray[1] = new Integer(0);
            try {
                trackerPadThread.addThreadListener(searchListener);
            }
            catch (TooManyListenersException tooManyListenersException) {
                JOptionPane.showMessageDialog(frame, TrackerPad.res.getString("Too_Many_Listener"), TrackerPad.res.getString("Internal_Error"), 0);
                return;
            }
            waitDlg = new PleaseWait(frame, TrackerPad.res.getString("Search_Config"), TrackerPad.res.getString("Search_Wait"), tracker, true, true);
            if (angularDialog != null) {
                angularDialog.setCursor();
            } else if (manualDialog != null) {
                manualDialog.setSearchInProgressFlag(true);
                manualDialog.setCursor();
            } else if (visualDialog != null) {
                visualDialog.setSearchInProgressFlag(true);
                visualDialog.setCursor();
            }
            trackerPadThread.sendCommand(objectArray);
        } else if (angularDialog == null && manualDialog == null && visualDialog == null) {
            objectArray[0] = new Integer(1);
            objectArray[1] = new Integer(1);
            trackerPadThread.sendCommand(objectArray);
            trackerPadThread.receiveResponse();
            DriveOptUtil.closeTrackerPad();
        } else {
            angularDialog = null;
            manualDialog = null;
            visualDialog = null;
        }
    }

    public static void setParentDialog(JDialog jDialog) {
        if (jDialog instanceof AngularDrive) {
            angularDialog = (AngularDrive)jDialog;
        } else if (jDialog instanceof ManualDrive) {
            manualDialog = (ManualDrive)jDialog;
        } else if (jDialog instanceof VisualDrive) {
            visualDialog = (VisualDrive)jDialog;
        }
    }

    public static void setUseEstimatedRangeFlag(boolean bl) {
        useEstimatedRangeFlag = bl;
    }

    public static boolean getUseEstimatedRangeFlag() {
        return useEstimatedRangeFlag;
    }

    private static final class searchCmdComplete
    implements ThreadListener,
    Runnable {
        private searchCmdComplete() {
        }

        public void commandComplete() {
            thread.removeThreadListener(this);
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            Object[] objectArray = thread.receiveResponse();
            if (objectArray[0] != null) {
                TrackerExceptionString.displayErrorToUser(null, (TrackerException)((Object)objectArray[0]), TrackerPad.res.getString("Error"), "");
            }
            waitDlg.dispose();
            if (angularDialog != null) {
                angularDialog.restoreCursor();
                angularDialog = null;
            } else if (manualDialog != null) {
                manualDialog.setSearchInProgressFlag(false);
                manualDialog.restoreCursor();
                manualDialog = null;
            } else if (visualDialog != null) {
                visualDialog.setSearchInProgressFlag(false);
                visualDialog.restoreCursor();
                visualDialog = null;
            } else {
                DriveOptUtil.closeTrackerPad();
            }
        }
    }
}

