/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.apps4xxx.trackerpad;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.ParseException;
import java.util.TooManyListenersException;
import javax.swing.DefaultFocusManager;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import smx.tracker.DataTag;
import smx.tracker.DataTagDouble;
import smx.tracker.DataTagUnsigned16;
import smx.tracker.MeasureData;
import smx.tracker.Tracker;
import smx.tracker.TrackerException;
import smx.tracker.apps4xxx.trackerpad.DriveOptUtil;
import smx.tracker.apps4xxx.trackerpad.TrackerPad;
import smx.tracker.apps4xxx.trackerpad.TrackerPadThread;
import smx.tracker.apps4xxx.utility.GlassComponent;
import smx.tracker.apps4xxx.utility.ThreadListener;
import smx.tracker.event.FactoryBkndMeasureDataEvent;
import smx.tracker.event.FactoryBkndMeasureDataListener;
import smx.utility.UnitsConversion;

public class AngularDrive
extends JDialog {
    private Frame frame = new Frame();
    private UnitsConversion angularUnits = null;
    private UnitsConversion lengthUnits = null;
    private TrackerPadThread padThread = null;
    private Object[] response = null;
    private BkndMeasureData bkndListener = new BkndMeasureData();
    private Tracker trk = null;
    private boolean error = false;
    private int azStatus = 0;
    private int zeStatus = 0;
    private moveCmdComplete moveListener = new moveCmdComplete();
    JPanel panel1 = new JPanel();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JTextField azReading = new JTextField();
    JTextField zeReading = new JTextField();
    JButton move = new JButton();
    JButton search = new JButton();
    JButton close = new JButton();
    JLabel azUnit = new JLabel();
    JLabel zeUnit = new JLabel();
    JLabel jLabel3 = new JLabel();
    JTextField distReading = new JTextField();
    JLabel distUnit = new JLabel();
    JCheckBox setDistance = new JCheckBox();
    JPanel jPanel1 = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GridBagLayout gridBagLayout2 = new GridBagLayout();

    private void updateDisplay(FactoryBkndMeasureDataEvent factoryBkndMeasureDataEvent) {
        try {
            MeasureData[] measureDataArray = this.trk.readFactoryBkndMeasureData(factoryBkndMeasureDataEvent.getNumMeasurements());
            if (this.error) {
                return;
            }
            this.azStatus = (Integer)measureDataArray[0].getDataElement(1);
            this.zeStatus = (Integer)measureDataArray[0].getDataElement(3);
            if ((this.azStatus & 2) != 0 || (this.zeStatus & 2) != 0) {
                this.error = true;
                JOptionPane.showMessageDialog(this, TrackerPad.res.getString("Encoder_Error"), TrackerPad.res.getString("Error"), 0);
                this.stopBkndMeasure();
                this.dispose();
                return;
            }
        }
        catch (TrackerException trackerException) {
            trackerException.printStackTrace();
        }
    }

    private void showErrorDialog() {
        JOptionPane.showMessageDialog(this, TrackerPad.res.getString("Move_Failure"), TrackerPad.res.getString("Error"), 0);
    }

    public void restoreCursor() {
        GlassComponent.setWaitState(false, this);
    }

    public AngularDrive(Frame frame, String string, UnitsConversion unitsConversion, UnitsConversion unitsConversion2, TrackerPadThread trackerPadThread, Object[] objectArray, Tracker tracker, boolean bl) {
        super(frame, string, bl);
        this.frame = frame;
        this.lengthUnits = unitsConversion;
        this.angularUnits = unitsConversion2;
        this.padThread = trackerPadThread;
        this.response = objectArray;
        this.trk = tracker;
        this.setGlassPane(new GlassComponent());
        try {
            this.jbInit();
            this.pack();
            this.setLocationRelativeTo(frame);
            this.startBkndMeasure(this.bkndListener);
            ((Component)this).setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public AngularDrive() {
        this(null, "", null, null, null, null, null, false);
    }

    void jbInit() throws Exception {
        this.panel1.setLayout(this.gridBagLayout2);
        this.jLabel1.setText(TrackerPad.res.getString("Az"));
        this.jLabel2.setText(TrackerPad.res.getString("Ze"));
        this.move.setText(TrackerPad.res.getString("Move"));
        this.search.setText(TrackerPad.res.getString("Search"));
        this.close.setText(TrackerPad.res.getString("Close"));
        this.azUnit.setText(TrackerPad.res.getString("Radians"));
        this.zeUnit.setText(TrackerPad.res.getString("Radians"));
        this.jLabel3.setText(TrackerPad.res.getString("Dist"));
        this.distUnit.setText(TrackerPad.res.getString("Meters"));
        this.setDistance.setText(TrackerPad.res.getString("Use_Estimated_Distance"));
        FocusManager.setCurrentManager(new MyFocusManager(this));
        this.azReading.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 9) {
                    AngularDrive.this.azReading.requestFocus();
                    AngularDrive.this.azReading.selectAll();
                }
            }
        });
        this.zeReading.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 9) {
                    AngularDrive.this.zeReading.requestFocus();
                    AngularDrive.this.zeReading.selectAll();
                }
            }
        });
        this.distReading.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 9) {
                    if (AngularDrive.this.distReading.isEnabled()) {
                        AngularDrive.this.distReading.requestFocus();
                        AngularDrive.this.distReading.selectAll();
                    } else {
                        AngularDrive.this.move.requestFocus();
                    }
                }
            }
        });
        this.setDistance.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AngularDrive.this.setDistance_actionPerformed(actionEvent);
            }
        });
        this.move.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AngularDrive.this.move_actionPerformed(actionEvent);
            }
        });
        this.search.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AngularDrive.this.search_actionPerformed(actionEvent);
            }
        });
        this.close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AngularDrive.this.close_actionPerformed(actionEvent);
            }
        });
        double d = Math.IEEEremainder((Double)this.response[2], 1296000.0);
        d = Math.toRadians(d / (double)3600);
        this.zeReading.setMaximumSize(new Dimension(4, 21));
        this.zeReading.setText(this.angularUnits.convertToDisplayStr(d));
        double d2 = Math.IEEEremainder((Double)this.response[0], 1296000.0);
        d2 = Math.toRadians(d2 / (double)3600);
        this.azReading.setMaximumSize(new Dimension(4, 21));
        this.azReading.setText(this.angularUnits.convertToDisplayStr(d2));
        double d3 = (Double)this.response[4] / (double)1000000;
        this.distReading.setEnabled(false);
        this.distReading.setMaximumSize(new Dimension(4, 21));
        this.distReading.setEditable(false);
        this.distReading.setText(this.lengthUnits.convertToDisplayStr(d3));
        if (this.angularUnits.displayName().equals(TrackerPad.res.getString("Angular_Degree_Symbol"))) {
            this.azUnit.setFont(new Font("Dialog", 1, 18));
            this.zeUnit.setFont(new Font("Dialog", 1, 18));
        }
        this.azUnit.setMaximumSize(new Dimension(4, 21));
        this.azUnit.setMinimumSize(new Dimension(4, 21));
        this.azUnit.setPreferredSize(new Dimension(4, 21));
        this.azUnit.setText(this.angularUnits.displayName());
        this.zeUnit.setMaximumSize(new Dimension(4, 21));
        this.zeUnit.setMinimumSize(new Dimension(4, 21));
        this.zeUnit.setPreferredSize(new Dimension(4, 21));
        this.zeUnit.setText(this.angularUnits.displayName());
        this.distUnit.setMaximumSize(new Dimension(4, 21));
        this.distUnit.setMinimumSize(new Dimension(4, 21));
        this.distUnit.setPreferredSize(new Dimension(4, 21));
        this.distUnit.setText(this.lengthUnits.displayName());
        this.panel1.setMinimumSize(new Dimension(359, 245));
        this.panel1.setPreferredSize(new Dimension(359, 245));
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.azReading, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(34, 0, 0, 0), 88, 1));
        this.panel1.add((Component)this.zeReading, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(13, 0, 0, 0), 88, 0));
        this.panel1.add((Component)this.zeUnit, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(13, 12, 0, 50), 85, 0));
        this.panel1.add((Component)this.distReading, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(14, 0, 0, 0), 88, 0));
        this.panel1.add((Component)this.distUnit, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(13, 12, 0, 50), 85, 1));
        this.panel1.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(34, 54, 0, 0), 19, 5));
        this.panel1.add((Component)this.jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(13, 54, 0, 0), 28, 4));
        this.panel1.add((Component)this.jLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(13, 54, 0, 0), 13, 5));
        this.panel1.add((Component)this.setDistance, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 10, 0, new Insets(16, 54, 0, 73), 76, 0));
        this.panel1.add((Component)this.jPanel1, new GridBagConstraints(0, 4, 3, 1, 1.0, 1.0, 10, 1, new Insets(12, 13, 31, 20), 0, -3));
        this.jPanel1.add((Component)this.move, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 20, 2, 0), 21, 0));
        this.jPanel1.add((Component)this.search, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 23, 2, 0), 1, 0));
        this.jPanel1.add((Component)this.close, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 22, 2, 12), 17, 0));
        this.panel1.add((Component)this.azUnit, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(34, 12, 0, 50), 85, 1));
    }

    void move_actionPerformed(ActionEvent actionEvent) {
        String[] stringArray = new String[3];
        char[] cArray = null;
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = new Object[5];
        stringArray[0] = this.azReading.getText().trim();
        stringArray[1] = this.zeReading.getText().trim();
        stringArray[2] = this.distReading.getText().trim();
        for (int i = 0; i < 3; ++i) {
            try {
                cArray = stringArray[i].toCharArray();
                for (int j = 0; j < cArray.length; ++j) {
                    if (!Character.isLetter(cArray[j])) continue;
                    throw new ParseException("", j);
                }
                objectArray[i] = new Double(TrackerPad.form.parse(stringArray[i]).doubleValue());
                continue;
            }
            catch (ParseException parseException) {
                JOptionPane.showMessageDialog(this, TrackerPad.res.getString("Enter_Number"), TrackerPad.res.getString("Error"), 0);
                return;
            }
        }
        objectArray2[0] = new Integer(23);
        objectArray2[1] = new Integer(0);
        objectArray2[2] = "".concat(String.valueOf(String.valueOf(this.angularUnits.convertFrom(((Double)objectArray[0]).doubleValue()))));
        objectArray2[3] = "".concat(String.valueOf(String.valueOf(this.angularUnits.convertFrom(((Double)objectArray[1]).doubleValue()))));
        objectArray2[4] = "".concat(String.valueOf(String.valueOf(this.lengthUnits.convertFrom(((Double)objectArray[2]).doubleValue()))));
        try {
            this.padThread.addThreadListener(this.moveListener);
        }
        catch (TooManyListenersException tooManyListenersException) {
            JOptionPane.showMessageDialog(this, TrackerPad.res.getString("Too_Many_Listener"), TrackerPad.res.getString("Internal_Error"), 0);
            return;
        }
        this.setCursor();
        this.padThread.sendCommand(objectArray2);
    }

    public void setCursor() {
        GlassComponent.setWaitState(true, this);
    }

    void search_actionPerformed(ActionEvent actionEvent) {
        DriveOptUtil.setParentDialog(this);
        if (this.setDistance.isSelected()) {
            DriveOptUtil.setUseEstimatedRangeFlag(true);
        } else {
            DriveOptUtil.setUseEstimatedRangeFlag(false);
        }
        DriveOptUtil.searchTarget(this.padThread, this.frame, this.trk, this.lengthUnits);
    }

    void close_actionPerformed(ActionEvent actionEvent) {
        this.stopBkndMeasure();
        this.dispose();
    }

    private void startBkndMeasure(FactoryBkndMeasureDataListener factoryBkndMeasureDataListener) {
        DataTag[] dataTagArray = new DataTag[]{new DataTagDouble("az_motor_in.output"), new DataTagUnsigned16("az_motor_in.status"), new DataTagDouble("el_motor_in.output"), new DataTagUnsigned16("el_motor_in.status")};
        Object[] objectArray = DriveOptUtil.startBkndMeasure(this.padThread, dataTagArray, factoryBkndMeasureDataListener);
        if (objectArray[0] != null) {
            JOptionPane.showMessageDialog(this, TrackerPad.res.getString("Start_Measure_Failure"), TrackerPad.res.getString("Error"), 0);
            this.dispose();
        }
    }

    private void stopBkndMeasure() {
        Object[] objectArray = DriveOptUtil.stopBkndMeasure(this.padThread, this.bkndListener);
        if (objectArray[0] != null) {
            JOptionPane.showMessageDialog(this, TrackerPad.res.getString("Stop_Measure_Failure"), TrackerPad.res.getString("Error"), 0);
        }
    }

    void setDistance_actionPerformed(ActionEvent actionEvent) {
        if (!this.setDistance.isSelected()) {
            this.distReading.setEditable(false);
            this.distReading.setEnabled(false);
        } else {
            this.distReading.setEditable(true);
            this.distReading.setEnabled(true);
        }
    }

    private class BkndMeasureData
    implements FactoryBkndMeasureDataListener,
    Runnable {
        FactoryBkndMeasureDataEvent data;

        private BkndMeasureData() {
        }

        public void dataAvailable(FactoryBkndMeasureDataEvent factoryBkndMeasureDataEvent) {
            this.data = factoryBkndMeasureDataEvent;
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            AngularDrive.this.updateDisplay(this.data);
        }
    }

    private class MyFocusManager
    extends DefaultFocusManager {
        private MyFocusManager(AngularDrive angularDrive) {
        }

        public void processKeyEvent(Component component, KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 9) {
                return;
            }
            super.processKeyEvent(component, keyEvent);
        }
    }

    private class moveCmdComplete
    implements ThreadListener,
    Runnable {
        private moveCmdComplete() {
        }

        public void commandComplete() {
            AngularDrive.this.padThread.removeThreadListener(this);
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            Object[] objectArray = AngularDrive.this.padThread.receiveResponse();
            if (objectArray[0] != null) {
                AngularDrive.this.showErrorDialog();
            }
            AngularDrive.this.restoreCursor();
        }
    }
}

