/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.apps4xxx.operationalchecks;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import smx.tracker.AirExtTemp;
import smx.tracker.ExtTempType;
import smx.tracker.MaterialExtTemp;
import smx.tracker.NullExtTemp;
import smx.tracker.apps4xxx.operationalchecks.OpChecksPanel;
import smx.tracker.apps4xxx.operationalchecks.OperationalChecks;
import smx.tracker.apps4xxx.utility.tools.XTool;
import smx.tracker.apps4xxx.utility.tools.debug.Assert;

public class OpChecksSMRPane
extends OpChecksPanel {
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel1_parent = new JPanel();
    JPanel jPanelSMR_parent = new JPanel();
    JPanel jPanelWeather = new JPanel();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    Component component1;
    Component component2;
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    Component component3;
    JProgressBar jProgressBar2 = new JProgressBar(0, 100);
    ImageIcon smrImage;
    private Icon autoSettingIcon;
    private Icon errorSettingIcon;
    private Icon manualSettingIcon;
    private final int Air = 0;
    private final int Material = 1;
    private final double SMR_INTENSITY_THRESHOLD = 20.0;
    private StringBuffer dataToBeSaved = new StringBuffer(5000);
    private StringBuffer extTempSensorDetails = new StringBuffer(5000);
    GridBagLayout gridBagLayout4 = new GridBagLayout();
    JPanel jPanel3 = new JPanel();
    JPanel jPanel4 = new JPanel();
    GridBagLayout gridBagLayout5 = new GridBagLayout();
    JLabel jLabel3 = new JLabel();
    JLabel jLabel4 = new JLabel();
    JTextField jTextField1 = new JTextField();
    JLabel jLabel5 = new JLabel();
    JLabel jLabel6 = new JLabel();
    JLabel jLabel7 = new JLabel();
    JTextField jTextField2 = new JTextField();
    JLabel jLabel8 = new JLabel();
    JLabel jLabel9 = new JLabel();
    JLabel jLabel10 = new JLabel();
    JTextField jTextField3 = new JTextField();
    JLabel jLabel11 = new JLabel();
    Component component5;
    Component component6;
    Component component7;
    Border border1;
    TitledBorder titledBorder1;
    Border border2;
    GridBagLayout gridBagLayout6 = new GridBagLayout();
    GridBagLayout gridBagLayout7 = new GridBagLayout();
    JLabel jLabel_1_2 = new JLabel();
    JLabel jLabel_1_3 = new JLabel();
    JTextField jTextField_1 = new JTextField();
    JLabel jLabel_1_4 = new JLabel();
    Component verticalSpacer_1;
    JLabel jLabel_2_2 = new JLabel();
    JLabel jLabel_2_3 = new JLabel();
    JTextField jTextField_2 = new JTextField();
    JLabel jLabel_2_4 = new JLabel();
    Component verticalSpacer_2;
    JLabel jLabel_3_2 = new JLabel();
    JLabel jLabel_3_3 = new JLabel();
    JTextField jTextField_3 = new JTextField();
    JLabel jLabel_3_4 = new JLabel();
    Component verticalSpacer_3;
    JLabel jLabel_4_2 = new JLabel();
    JLabel jLabel_4_3 = new JLabel();
    JTextField jTextField_4 = new JTextField();
    JLabel jLabel_4_4 = new JLabel();
    Component verticalSpacer_4;
    JLabel jLabel_5_2 = new JLabel();
    JLabel jLabel_5_3 = new JLabel();
    JTextField jTextField_5 = new JTextField();
    JLabel jLabel_5_4 = new JLabel();
    Component verticalSpacer_5;
    JLabel jLabel_6_2 = new JLabel();
    JLabel jLabel_6_3 = new JLabel();
    JTextField jTextField_6 = new JTextField();
    JLabel jLabel_6_4 = new JLabel();
    Component verticalSpacer_6;
    JLabel jLabel_7_2 = new JLabel();
    JLabel jLabel_7_3 = new JLabel();
    JTextField jTextField_7 = new JTextField();
    JLabel jLabel_7_4 = new JLabel();
    Component verticalSpacer_7;
    JLabel jLabel_8_2 = new JLabel();
    JLabel jLabel_8_3 = new JLabel();
    JTextField jTextField_8 = new JTextField();
    JLabel jLabel_8_4 = new JLabel();
    Component verticalSpacer_8;
    Border border3;
    TitledBorder titledBorder2;
    Border border4;
    TitledBorder titledBorder3;
    GridBagLayout gridBagLayout8 = new GridBagLayout();
    JLabel jLabel_1_1 = new JLabel();
    JLabel jLabel_2_1 = new JLabel();
    JLabel jLabel_3_1 = new JLabel();
    JLabel jLabel_4_1 = new JLabel();
    JLabel jLabel_5_1 = new JLabel();
    JLabel jLabel_6_1 = new JLabel();
    JLabel jLabel_7_1 = new JLabel();
    JLabel jLabel_8_1 = new JLabel();

    public OpChecksSMRPane(String string) {
        super(string);
        this.parentTabPane = OperationalChecks.parentApp;
        this.opChecksThread = OperationalChecks.parentAppCommandThread;
        this.displayFormat.setMinimumFractionDigits(1);
        this.displayFormat.setMaximumFractionDigits(1);
        Image image = OperationalChecks.parentApp.loadImage("opchecksauto.gif", OperationalChecks.parentApp.packagePath);
        if (image == null) {
            System.err.println("Couldn't load image auto");
        } else {
            this.autoSettingIcon = new ImageIcon(image);
        }
        image = OperationalChecks.parentApp.loadImage("opchecksmanual.gif", OperationalChecks.parentApp.packagePath);
        if (image == null) {
            System.err.println("Couldn't load image manual");
        } else {
            this.manualSettingIcon = new ImageIcon(image);
        }
        image = OperationalChecks.parentApp.loadImage("opcheckserror.gif", OperationalChecks.parentApp.packagePath);
        if (image == null) {
            System.err.println("Couldn't load image error");
        } else {
            this.errorSettingIcon = new ImageIcon(image);
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void onComponentResized(ComponentEvent componentEvent) {
        if (this.jLabel2.getText().length() == 0) {
            return;
        }
        Font font = XTool.calculateMaxFontThatFits(this.jLabel2, this.oldDimension);
        if (font == null) {
            return;
        }
        this.jLabel2.setFont(font);
    }

    protected String getDataToBeSaved() {
        return String.valueOf(String.valueOf(this.dataToBeSaved.toString())).concat(String.valueOf(String.valueOf(this.extTempSensorDetails.toString())));
    }

    private String getSensorType(ExtTempType extTempType) {
        if (extTempType instanceof AirExtTemp) {
            return this.res.getString("Air");
        }
        if (extTempType instanceof MaterialExtTemp) {
            return this.res.getString("Material");
        }
        if (extTempType instanceof NullExtTemp) {
            return this.res.getString("NotUsed");
        }
        Assert.isTrue(false, "Unknown ext temp sensor type returned by tracker driver");
        return "DRIVER_EXCEPTION";
    }

    private void addExtTempSensorResults(String string, JTextField jTextField, int n, JLabel jLabel, String string2, JLabel jLabel2, JLabel jLabel3, String string3) {
        String string4 = this.jLabel5.getText();
        jLabel3.setText(string4);
        jLabel2.setText(string2);
        this.extTempSensorDetails.append(this.res.getString("External_temperature_sensors"));
        this.extTempSensorDetails.append(" ").append(string3).append(" - ");
        this.extTempSensorDetails.append(string2);
        jTextField.setText(string);
        if (n == 0) {
            this.extTempSensorDetails.append(" : ").append(this.res.getString("Valid"));
            this.extTempSensorDetails.append(" @ ").append(string).append(string4);
            jLabel.setIcon(this.autoSettingIcon);
        } else if (n == 8) {
            this.extTempSensorDetails.append(" : ").append(this.res.getString("Manual"));
            this.extTempSensorDetails.append(" @ ").append(string).append(string4);
            jLabel.setIcon(this.manualSettingIcon);
        } else {
            jLabel.setIcon(this.errorSettingIcon);
            jTextField.setText("");
        }
        this.extTempSensorDetails.append(XTool.lineSeparator());
    }

    public void setupOneTimeExternalTemperatureSensorData(Object[] objectArray) {
        Object[] objectArray2 = (Object[])objectArray[0];
        ExtTempType[] extTempTypeArray = (ExtTempType[])objectArray[1];
        int n = 0;
        int n2 = 0;
        this.addExtTempSensorResults(OperationalChecks.parentApp.localTemperatureUnits.convertToDisplayStr(((Double)objectArray2[n2++]).doubleValue()), this.jTextField_1, (Integer)objectArray2[n2++], this.jLabel_1_3, this.getSensorType(extTempTypeArray[n++]), this.jLabel_1_2, this.jLabel_1_4, "1");
        this.addExtTempSensorResults(OperationalChecks.parentApp.localTemperatureUnits.convertToDisplayStr(((Double)objectArray2[n2++]).doubleValue()), this.jTextField_2, (Integer)objectArray2[n2++], this.jLabel_2_3, this.getSensorType(extTempTypeArray[n++]), this.jLabel_2_2, this.jLabel_2_4, "2");
        this.addExtTempSensorResults(OperationalChecks.parentApp.localTemperatureUnits.convertToDisplayStr(((Double)objectArray2[n2++]).doubleValue()), this.jTextField_3, (Integer)objectArray2[n2++], this.jLabel_3_3, this.getSensorType(extTempTypeArray[n++]), this.jLabel_3_2, this.jLabel_3_4, "3");
        this.addExtTempSensorResults(OperationalChecks.parentApp.localTemperatureUnits.convertToDisplayStr(((Double)objectArray2[n2++]).doubleValue()), this.jTextField_4, (Integer)objectArray2[n2++], this.jLabel_4_3, this.getSensorType(extTempTypeArray[n++]), this.jLabel_4_2, this.jLabel_4_4, "4");
        this.addExtTempSensorResults(OperationalChecks.parentApp.localTemperatureUnits.convertToDisplayStr(((Double)objectArray2[n2++]).doubleValue()), this.jTextField_5, (Integer)objectArray2[n2++], this.jLabel_5_3, this.getSensorType(extTempTypeArray[n++]), this.jLabel_5_2, this.jLabel_5_4, "5");
        this.addExtTempSensorResults(OperationalChecks.parentApp.localTemperatureUnits.convertToDisplayStr(((Double)objectArray2[n2++]).doubleValue()), this.jTextField_6, (Integer)objectArray2[n2++], this.jLabel_6_3, this.getSensorType(extTempTypeArray[n++]), this.jLabel_6_2, this.jLabel_6_4, "6");
        this.addExtTempSensorResults(OperationalChecks.parentApp.localTemperatureUnits.convertToDisplayStr(((Double)objectArray2[n2++]).doubleValue()), this.jTextField_7, (Integer)objectArray2[n2++], this.jLabel_7_3, this.getSensorType(extTempTypeArray[n++]), this.jLabel_7_2, this.jLabel_7_4, "7");
        this.addExtTempSensorResults(OperationalChecks.parentApp.localTemperatureUnits.convertToDisplayStr(((Double)objectArray2[n2++]).doubleValue()), this.jTextField_8, (Integer)objectArray2[n2++], this.jLabel_8_3, this.getSensorType(extTempTypeArray[n++]), this.jLabel_8_2, this.jLabel_8_4, "8");
        this.extTempSensorDetails.append(XTool.lineSeparator());
    }

    private void addStatusResults(String string, int n, String string2, String string3, JLabel jLabel, JTextField jTextField) {
        this.dataToBeSaved.append(string);
        jTextField.setText(string2);
        string3 = " ".concat(String.valueOf(String.valueOf(string3)));
        if (n == 0) {
            this.dataToBeSaved.append(" : ").append(this.res.getString("Valid"));
            this.dataToBeSaved.append(" @ ").append(string2).append(string3);
            jLabel.setIcon(this.autoSettingIcon);
        } else if (n == 8) {
            this.dataToBeSaved.append(" : ").append(this.res.getString("Manual"));
            this.dataToBeSaved.append(" @ ").append(string2).append(string3);
            jLabel.setIcon(this.manualSettingIcon);
        } else {
            this.dataToBeSaved.append(" : ").append(this.res.getString("Invalid"));
            jLabel.setIcon(this.errorSettingIcon);
        }
        this.dataToBeSaved.append(XTool.lineSeparator());
    }

    public void displayTargetPosition() {
        String string = XTool.lineSeparator();
        this.dataToBeSaved.delete(0, this.dataToBeSaved.length());
        double d = this.parentTabPane.temperature;
        String string2 = this.parentTabPane.localTemperatureUnits.convertToDisplayStr(d);
        this.addStatusResults(this.res.getString("Temperature"), this.parentTabPane.temperatureStatus, string2, this.jLabel5.getText(), this.jLabel4, this.jTextField1);
        d = this.parentTabPane.pressure;
        string2 = this.parentTabPane.localPressureUnits.convertToDisplayStr(d);
        this.addStatusResults(this.res.getString("Pressure"), this.parentTabPane.pressureStatus, string2, this.jLabel8.getText(), this.jLabel7, this.jTextField2);
        string2 = this.displayFormat.format(this.parentTabPane.humidity);
        this.addStatusResults(this.res.getString("Humidity"), this.parentTabPane.humidityStatus, string2, "%", this.jLabel10, this.jTextField3);
        if (this.parentTabPane.averageSMRIntensity < 20.0) {
            this.jLabel2.setForeground(Color.red);
        } else {
            this.jLabel2.setForeground(Color.green);
        }
        string2 = this.displayFormat.format(this.parentTabPane.averageSMRIntensity);
        this.jLabel2.setText(string2);
        this.dataToBeSaved.append(this.parentTabPane.baselineIntensitySet ? this.res.getString("SMR_return_power") : this.res.getString("SMR_intensity"));
        this.dataToBeSaved.append(" : ").append(string2).append(string);
        this.dataToBeSaved.append(XTool.lineSeparator());
        if (!this.fontCalculatedOnce) {
            this.onComponentResized(null);
            this.fontCalculatedOnce = true;
        }
        this.jProgressBar2.setValue((int)this.parentTabPane.averageSMRIntensity);
    }

    void onHome(ActionEvent actionEvent) {
        super.onHome(actionEvent);
        this.parentTabPane.startFactoryBkndMeasurementForTargetPos();
    }

    protected void enableAllControls(boolean bl) {
        this.ctrlHome.setEnabled(bl);
        this.ctrlSave.setEnabled(bl);
        this.ctrlSaveAs.setEnabled(bl);
    }

    private void jbInit() throws Exception {
        super.initialize();
        this.ctrlSave.setEnabled(true);
        this.ctrlSaveAs.setEnabled(true);
        Image image = this.parentTabPane.loadImage("opcheckssmr.gif", OperationalChecks.parentApp.packagePath);
        if (image == null) {
            System.err.println("Couldn't load image opcheckssmr");
        } else {
            this.smrImage = new ImageIcon(image);
        }
        this.component1 = Box.createHorizontalStrut(8);
        this.component2 = Box.createHorizontalStrut(8);
        this.component3 = Box.createHorizontalStrut(8);
        this.component5 = Box.createVerticalStrut(8);
        this.component6 = Box.createVerticalStrut(8);
        this.component7 = Box.createVerticalStrut(8);
        this.border1 = new EtchedBorder(0, Color.white, new Color(134, 134, 134));
        this.titledBorder1 = new TitledBorder(this.border1, this.parentTabPane.baselineIntensitySet ? this.res.getString("SMR_return_power") : this.res.getString("SMR_intensity"));
        this.border2 = BorderFactory.createCompoundBorder(this.titledBorder1, BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.verticalSpacer_1 = Box.createVerticalStrut(8);
        this.verticalSpacer_2 = Box.createVerticalStrut(8);
        this.verticalSpacer_3 = Box.createVerticalStrut(8);
        this.verticalSpacer_4 = Box.createVerticalStrut(8);
        this.verticalSpacer_5 = Box.createVerticalStrut(8);
        this.verticalSpacer_6 = Box.createVerticalStrut(8);
        this.verticalSpacer_7 = Box.createVerticalStrut(8);
        this.verticalSpacer_8 = Box.createVerticalStrut(8);
        this.border3 = new EtchedBorder(0, Color.white, new Color(134, 134, 134));
        this.titledBorder2 = new TitledBorder(this.border3, this.res.getString("Weather"));
        this.border4 = new EtchedBorder(0, Color.white, new Color(134, 134, 134));
        this.titledBorder3 = new TitledBorder(this.border4, this.res.getString("External_temperature_sensors"));
        this.setLayout(this.gridBagLayout1);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                OpChecksSMRPane.this.onComponentResized(componentEvent);
            }
        });
        this.jPanel1_parent.setLayout(this.gridBagLayout8);
        this.jPanelWeather.setLayout(this.gridBagLayout4);
        this.jPanel3.setLayout(this.gridBagLayout5);
        this.jLabel3.setText(this.res.getString("Temperature"));
        this.jLabel4.setMinimumSize(new Dimension(25, 17));
        this.jLabel4.setPreferredSize(new Dimension(25, 17));
        this.jTextField1.setMinimumSize(new Dimension(63, 22));
        this.jTextField1.setPreferredSize(new Dimension(63, 22));
        this.jTextField1.setEditable(false);
        this.jLabel5.setMinimumSize(new Dimension(55, 17));
        this.jLabel5.setPreferredSize(new Dimension(55, 17));
        this.jLabel5.setText("");
        this.jLabel6.setText(this.res.getString("Pressure"));
        this.jLabel7.setMinimumSize(new Dimension(25, 17));
        this.jLabel7.setPreferredSize(new Dimension(25, 17));
        this.jTextField2.setMinimumSize(new Dimension(63, 22));
        this.jTextField2.setPreferredSize(new Dimension(63, 22));
        this.jTextField2.setEditable(false);
        this.jLabel8.setMinimumSize(new Dimension(55, 17));
        this.jLabel8.setPreferredSize(new Dimension(55, 17));
        this.jLabel8.setText("");
        this.jLabel9.setText(this.res.getString("Humidity"));
        this.jLabel10.setMinimumSize(new Dimension(25, 17));
        this.jLabel10.setPreferredSize(new Dimension(25, 17));
        this.jTextField3.setMinimumSize(new Dimension(63, 22));
        this.jTextField3.setPreferredSize(new Dimension(63, 22));
        this.jTextField3.setEditable(false);
        this.jLabel11.setMinimumSize(new Dimension(55, 17));
        this.jLabel11.setPreferredSize(new Dimension(55, 17));
        this.jLabel11.setText("");
        this.jPanelSMR_parent.setBorder(this.border2);
        this.jPanelSMR_parent.setLayout(this.gridBagLayout6);
        this.jPanel4.setLayout(this.gridBagLayout7);
        this.jLabel_1_2.setText("");
        this.jLabel_1_3.setMinimumSize(new Dimension(25, 17));
        this.jLabel_1_3.setPreferredSize(new Dimension(25, 17));
        this.jLabel_1_3.setText("");
        this.jTextField_1.setMinimumSize(new Dimension(63, 22));
        this.jTextField_1.setPreferredSize(new Dimension(63, 22));
        this.jTextField_1.setEditable(false);
        this.jTextField_1.setText("");
        this.jLabel_1_4.setMinimumSize(new Dimension(35, 17));
        this.jLabel_1_4.setPreferredSize(new Dimension(35, 17));
        this.jLabel_1_4.setText("");
        this.jLabel_2_2.setText("");
        this.jLabel_2_3.setMinimumSize(new Dimension(25, 17));
        this.jLabel_2_3.setPreferredSize(new Dimension(25, 17));
        this.jLabel_2_3.setText("");
        this.jTextField_2.setMinimumSize(new Dimension(63, 22));
        this.jTextField_2.setPreferredSize(new Dimension(63, 22));
        this.jTextField_2.setEditable(false);
        this.jTextField_2.setText("");
        this.jLabel_2_4.setMinimumSize(new Dimension(35, 17));
        this.jLabel_2_4.setPreferredSize(new Dimension(35, 17));
        this.jLabel_2_4.setText("");
        this.jLabel_3_2.setText("");
        this.jLabel_3_3.setMinimumSize(new Dimension(25, 17));
        this.jLabel_3_3.setPreferredSize(new Dimension(25, 17));
        this.jLabel_3_3.setText("");
        this.jTextField_3.setMinimumSize(new Dimension(63, 22));
        this.jTextField_3.setPreferredSize(new Dimension(63, 22));
        this.jTextField_3.setEditable(false);
        this.jTextField_3.setText("");
        this.jLabel_3_4.setMinimumSize(new Dimension(35, 17));
        this.jLabel_3_4.setPreferredSize(new Dimension(35, 17));
        this.jLabel_3_4.setText("");
        this.jLabel_4_2.setText("");
        this.jLabel_4_3.setMinimumSize(new Dimension(25, 17));
        this.jLabel_4_3.setPreferredSize(new Dimension(25, 17));
        this.jLabel_4_3.setText("");
        this.jTextField_4.setMinimumSize(new Dimension(63, 22));
        this.jTextField_4.setPreferredSize(new Dimension(63, 22));
        this.jTextField_4.setEditable(false);
        this.jTextField_4.setText("");
        this.jLabel_4_4.setMinimumSize(new Dimension(35, 17));
        this.jLabel_4_4.setPreferredSize(new Dimension(35, 17));
        this.jLabel_4_4.setText("");
        this.jLabel_5_2.setText("");
        this.jLabel_5_3.setMinimumSize(new Dimension(25, 17));
        this.jLabel_5_3.setPreferredSize(new Dimension(25, 17));
        this.jLabel_5_3.setText("");
        this.jTextField_5.setMinimumSize(new Dimension(63, 22));
        this.jTextField_5.setPreferredSize(new Dimension(63, 22));
        this.jTextField_5.setEditable(false);
        this.jTextField_5.setText("");
        this.jLabel_5_4.setMinimumSize(new Dimension(35, 17));
        this.jLabel_5_4.setPreferredSize(new Dimension(35, 17));
        this.jLabel_5_4.setText("");
        this.jLabel_6_2.setText("");
        this.jLabel_6_3.setMinimumSize(new Dimension(25, 17));
        this.jLabel_6_3.setPreferredSize(new Dimension(25, 17));
        this.jLabel_6_3.setText("");
        this.jTextField_6.setMinimumSize(new Dimension(63, 22));
        this.jTextField_6.setPreferredSize(new Dimension(63, 22));
        this.jTextField_6.setEditable(false);
        this.jTextField_6.setText("");
        this.jLabel_6_4.setMinimumSize(new Dimension(35, 17));
        this.jLabel_6_4.setPreferredSize(new Dimension(35, 17));
        this.jLabel_6_4.setText("");
        this.jLabel_7_2.setText("");
        this.jLabel_7_3.setMinimumSize(new Dimension(25, 17));
        this.jLabel_7_3.setPreferredSize(new Dimension(25, 17));
        this.jLabel_7_3.setText("");
        this.jTextField_7.setMinimumSize(new Dimension(63, 22));
        this.jTextField_7.setPreferredSize(new Dimension(63, 22));
        this.jTextField_7.setEditable(false);
        this.jTextField_7.setText("");
        this.jLabel_7_4.setMinimumSize(new Dimension(35, 17));
        this.jLabel_7_4.setPreferredSize(new Dimension(35, 17));
        this.jLabel_7_4.setText("");
        this.jLabel_8_2.setText("");
        this.jLabel_8_3.setMinimumSize(new Dimension(25, 17));
        this.jLabel_8_3.setPreferredSize(new Dimension(25, 17));
        this.jLabel_8_3.setText("");
        this.jTextField_8.setMinimumSize(new Dimension(63, 22));
        this.jTextField_8.setPreferredSize(new Dimension(63, 22));
        this.jTextField_8.setEditable(false);
        this.jTextField_8.setText("");
        this.jLabel_8_4.setMinimumSize(new Dimension(35, 17));
        this.jLabel_8_4.setPreferredSize(new Dimension(35, 17));
        this.jLabel_8_4.setText("");
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.parentTabPane.localTemperatureUnits.displayName());
        StringBuffer stringBuffer2 = new StringBuffer(100);
        stringBuffer2.append(this.parentTabPane.localPressureUnits.displayName());
        StringBuffer stringBuffer3 = new StringBuffer(100);
        if (stringBuffer.length() > 4) {
            stringBuffer3.append("(").append(stringBuffer.substring(0, 4)).append(")");
        } else {
            stringBuffer3.append("(").append(stringBuffer).append(")");
        }
        StringBuffer stringBuffer4 = new StringBuffer(100);
        if (stringBuffer2.length() > 4) {
            stringBuffer4.append("(").append(stringBuffer2.substring(0, 4)).append(")");
        } else {
            stringBuffer4.append("(").append(stringBuffer2).append(")");
        }
        this.jLabel5.setText(stringBuffer3.toString());
        this.jLabel8.setText(stringBuffer4.toString());
        this.jLabel11.setText("%");
        this.jPanel3.setBorder(this.titledBorder2);
        this.jPanel4.setBorder(this.titledBorder3);
        this.jLabel_1_1.setText("1  ");
        this.jLabel_2_1.setText("2  ");
        this.jLabel_3_1.setText("3  ");
        this.jLabel_4_1.setText("4  ");
        this.jLabel_5_1.setText("5  ");
        this.jLabel_6_1.setText("6  ");
        this.jLabel_7_1.setText("7  ");
        this.jLabel_8_1.setText("8  ");
        this.jPanel1_parent.add((Component)this.jPanelWeather, new GridBagConstraints(0, 0, 1, 1, 0.5, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanelWeather.add((Component)this.jPanel3, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.4, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel3.add((Component)this.jLabel3, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel3.add((Component)this.jLabel4, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel3.add((Component)this.jTextField1, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel3.add((Component)this.jLabel5, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel3.add((Component)this.jLabel6, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel3.add((Component)this.jLabel7, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel3.add((Component)this.jTextField2, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel3.add((Component)this.jLabel8, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel3.add((Component)this.jLabel9, new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel3.add((Component)this.jLabel10, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel3.add((Component)this.jTextField3, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel3.add((Component)this.jLabel11, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel3.add(this.component5, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 10, 3, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel3.add(this.component6, new GridBagConstraints(0, 4, 1, 1, 0.0, 1.0, 10, 3, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel3.add(this.component7, new GridBagConstraints(0, 6, 1, 1, 0.0, 1.0, 10, 3, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanelWeather.add((Component)this.jPanel4, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel4.add((Component)this.jLabel_1_1, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jLabel_1_2, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 0, 0), 0, 0));
        this.jPanel4.add((Component)this.jLabel_1_3, new GridBagConstraints(2, 1, 1, 2, 0.0, 1.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jTextField_1, new GridBagConstraints(3, 1, 1, 2, 0.0, 1.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jLabel_1_4, new GridBagConstraints(4, 1, 1, 2, 0.0, 1.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add(this.verticalSpacer_1, new GridBagConstraints(0, 3, 2, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel4.add((Component)this.jLabel_2_1, new GridBagConstraints(0, 4, 1, 1, 0.0, 1.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jLabel_2_2, new GridBagConstraints(1, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jLabel_2_3, new GridBagConstraints(2, 4, 1, 1, 0.0, 1.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jTextField_2, new GridBagConstraints(3, 4, 1, 1, 0.0, 1.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jLabel_2_4, new GridBagConstraints(4, 4, 1, 1, 0.0, 1.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add(this.verticalSpacer_2, new GridBagConstraints(0, 5, 2, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel4.add((Component)this.jLabel_3_1, new GridBagConstraints(0, 6, 1, 1, 0.0, 1.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jLabel_3_2, new GridBagConstraints(1, 6, 2, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jLabel_3_3, new GridBagConstraints(2, 6, 1, 1, 0.0, 1.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jTextField_3, new GridBagConstraints(3, 6, 1, 1, 0.0, 1.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jLabel_3_4, new GridBagConstraints(4, 6, 1, 1, 0.0, 1.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add(this.verticalSpacer_3, new GridBagConstraints(0, 7, 2, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel4.add((Component)this.jLabel_4_1, new GridBagConstraints(0, 8, 1, 1, 0.0, 1.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jLabel_4_2, new GridBagConstraints(1, 8, 2, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jLabel_4_3, new GridBagConstraints(2, 8, 1, 1, 0.0, 1.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jTextField_4, new GridBagConstraints(3, 8, 1, 1, 0.0, 1.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jLabel_4_4, new GridBagConstraints(4, 8, 1, 1, 0.0, 1.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add(this.verticalSpacer_4, new GridBagConstraints(0, 9, 2, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel4.add((Component)this.jLabel_5_1, new GridBagConstraints(0, 10, 1, 1, 0.0, 1.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jLabel_5_2, new GridBagConstraints(1, 10, 2, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jLabel_5_3, new GridBagConstraints(2, 10, 1, 1, 0.0, 1.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jTextField_5, new GridBagConstraints(3, 10, 1, 1, 0.0, 1.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jLabel_5_4, new GridBagConstraints(4, 10, 1, 1, 0.0, 1.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add(this.verticalSpacer_5, new GridBagConstraints(0, 11, 2, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel4.add((Component)this.jLabel_6_1, new GridBagConstraints(0, 12, 1, 1, 0.0, 1.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jLabel_6_2, new GridBagConstraints(1, 12, 2, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jLabel_6_3, new GridBagConstraints(2, 12, 1, 1, 0.0, 1.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jTextField_6, new GridBagConstraints(3, 12, 1, 1, 0.0, 1.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jLabel_6_4, new GridBagConstraints(4, 12, 1, 1, 0.0, 1.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add(this.verticalSpacer_6, new GridBagConstraints(0, 13, 2, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel4.add((Component)this.jLabel_7_1, new GridBagConstraints(0, 14, 1, 1, 0.0, 1.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jLabel_7_2, new GridBagConstraints(1, 14, 2, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jLabel_7_3, new GridBagConstraints(2, 14, 1, 1, 0.0, 1.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jTextField_7, new GridBagConstraints(3, 14, 1, 1, 0.0, 1.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jLabel_7_4, new GridBagConstraints(4, 14, 1, 1, 0.0, 1.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add(this.verticalSpacer_7, new GridBagConstraints(0, 15, 2, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel4.add((Component)this.jLabel_8_1, new GridBagConstraints(0, 16, 1, 1, 0.0, 1.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jLabel_8_2, new GridBagConstraints(1, 16, 2, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jLabel_8_3, new GridBagConstraints(2, 16, 1, 1, 0.0, 1.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jTextField_8, new GridBagConstraints(3, 16, 1, 1, 0.0, 1.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jLabel_8_4, new GridBagConstraints(4, 16, 1, 1, 0.0, 1.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add(this.verticalSpacer_8, new GridBagConstraints(0, 17, 2, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1_parent.add((Component)this.jPanelSMR_parent, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanelSMR_parent.add((Component)this.jPanel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel1.setLayout(this.gridBagLayout2);
        this.jLabel1.setMaximumSize(new Dimension(45, 35));
        this.jLabel1.setMinimumSize(new Dimension(45, 35));
        this.jLabel1.setPreferredSize(new Dimension(45, 35));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel2.setVerticalAlignment(0);
        this.jLabel2.setBackground(Color.black);
        this.jLabel2.setOpaque(true);
        this.jLabel1.setIcon(this.smrImage);
        this.jLabel2.setFont(new Font("Dialog", 1, 35));
        this.jLabel2.setForeground(Color.green);
        this.jLabel2.setMaximumSize(new Dimension(555, 355));
        this.jLabel2.setMinimumSize(new Dimension(125, 35));
        this.jLabel2.setPreferredSize(new Dimension(125, 35));
        this.jLabel2.setRequestFocusEnabled(false);
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setVerticalAlignment(0);
        this.jLabel2.setText("");
        this.ctrlHome.setMaximumSize(new Dimension(65, 27));
        this.ctrlHome.setMinimumSize(new Dimension(65, 27));
        this.ctrlHome.setPreferredSize(new Dimension(65, 27));
        this.ctrlHome.setMargin(new Insets(2, 2, 2, 2));
        this.ctrlHome.setText(this.res.getString("Home"));
        this.ctrlHome.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OpChecksSMRPane.this.onHome(actionEvent);
            }
        });
        this.jProgressBar2.setMaximumSize(new Dimension(45, 15));
        this.jProgressBar2.setMinimumSize(new Dimension(45, 15));
        this.jProgressBar2.setPreferredSize(new Dimension(45, 15));
        this.add((Component)this.jPanel1_parent, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.8, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel1.add((Component)this.jLabel1, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.25, 10, 1, new Insets(2, 2, 5, 2), 0, 0));
        this.jPanel1.add((Component)this.jLabel2, new GridBagConstraints(1, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(5, 2, 2, 2), 0, 0));
        this.jPanel1.add((Component)this.jProgressBar2, new GridBagConstraints(1, 2, 3, 1, 1.0, 0.1, 10, 1, new Insets(2, 0, 2, 0), 0, 0));
        this.jPanel1.add((Component)this.ctrlHome, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 0, new Insets(1, 5, 2, 0), 0, 0));
        this.jPanel1.add((Component)this.ctrlSave, new GridBagConstraints(2, 3, 1, 1, 1.0, 0.0, 10, 0, new Insets(1, 5, 2, 0), 0, 0));
        this.jPanel1.add((Component)this.ctrlSaveAs, new GridBagConstraints(3, 3, 1, 1, 1.0, 0.0, 10, 0, new Insets(1, 5, 2, 0), 0, 0));
    }
}

