/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.apps4xxx.asyncmsgdisplay;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import smx.tracker.Alarm;
import smx.tracker.Diagnostic;
import smx.tracker.InterfaceBusyException;
import smx.tracker.NoDataAvailableException;
import smx.tracker.Status;
import smx.tracker.Tracker;
import smx.tracker.TrackerApp;
import smx.tracker.TrackerException;
import smx.tracker.apps4xxx.asyncmsgdisplay.AlarmDetails;
import smx.tracker.apps4xxx.asyncmsgdisplay.DiagDetails;
import smx.tracker.apps4xxx.asyncmsgdisplay.StatusDetails;
import smx.tracker.event.AlarmEvent;
import smx.tracker.event.AlarmListener;
import smx.tracker.event.DiagnosticEvent;
import smx.tracker.event.DiagnosticListener;
import smx.tracker.event.StatusEvent;
import smx.tracker.event.StatusListener;

public class AsyncMsgDisplay
extends TrackerApp {
    private AsyncDispStatusListener statusListener = new AsyncDispStatusListener();
    private AsyncDispAlarmListener alarmListener = new AsyncDispAlarmListener();
    private AsyncDispDiagListener diagListener = new AsyncDispDiagListener();
    private boolean applicationIsStable = false;
    public static ResourceBundle res = ResourceBundle.getBundle("smx.tracker.appskeystone.asyncmsgdisplay.AsyncMsgDisplayBundle", Locale.getDefault());
    Border border1;
    TitledBorder titledBorder1;
    Border border2;
    TitledBorder titledBorder2;
    Border border3;
    TitledBorder titledBorder3;
    JScrollPane errorScrollPane = new JScrollPane();
    JScrollPane statusScrollPane = new JScrollPane();
    JScrollPane alarmScrollPane = new JScrollPane();
    JList errorList = new JList(new DefaultListModel());
    JList statusList = new JList(new DefaultListModel());
    JList alarmList = new JList(new DefaultListModel());
    Border border4;
    TitledBorder titledBorder4;
    Border border5;
    TitledBorder titledBorder5;
    Border border6;
    TitledBorder titledBorder6;

    public AsyncMsgDisplay(String string, Tracker tracker, JFrame jFrame) {
        super(string, tracker, jFrame);
        try {
            this.jbInit();
            this.trk.addStatusListener((StatusListener)this.statusListener);
            this.trk.addAlarmListener((AlarmListener)this.alarmListener);
            this.trk.addDiagnosticListener((DiagnosticListener)this.diagListener);
            new AsyncThread(this.trk);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.border4 = BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134));
        this.border5 = BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134));
        this.border6 = BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134));
        this.titledBorder4 = new TitledBorder(this.border4, res.getString("Alarm"));
        this.titledBorder5 = new TitledBorder(this.border5, res.getString("Status"));
        this.titledBorder6 = new TitledBorder(this.border6, res.getString("Error"));
        this.statusScrollPane.setBorder(this.titledBorder5);
        this.statusScrollPane.setMaximumSize(new Dimension(210, 110));
        this.statusScrollPane.setMinimumSize(new Dimension(210, 110));
        this.statusScrollPane.setPreferredSize(new Dimension(210, 110));
        this.alarmScrollPane.setBorder(this.titledBorder4);
        this.alarmScrollPane.setMaximumSize(new Dimension(170, 110));
        this.alarmScrollPane.setMinimumSize(new Dimension(170, 110));
        this.alarmScrollPane.setPreferredSize(new Dimension(170, 110));
        this.errorScrollPane.setBorder(this.titledBorder6);
        this.errorScrollPane.setMaximumSize(new Dimension(210, 110));
        this.errorScrollPane.setMinimumSize(new Dimension(210, 110));
        this.errorScrollPane.setPreferredSize(new Dimension(210, 110));
        this.errorList.setMaximumSize(new Dimension(170, 70));
        this.errorList.setMinimumSize(new Dimension(170, 70));
        this.errorList.setPreferredSize(new Dimension(170, 70));
        this.errorList.setSelectionMode(0);
        this.errorList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                AsyncMsgDisplay.this.errorList_mouseClicked(mouseEvent);
            }
        });
        this.statusList.setMaximumSize(new Dimension(170, 70));
        this.statusList.setMinimumSize(new Dimension(170, 70));
        this.statusList.setPreferredSize(new Dimension(170, 70));
        this.statusList.setSelectionMode(0);
        this.statusList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                AsyncMsgDisplay.this.statusList_mouseClicked(mouseEvent);
            }
        });
        this.alarmList.setMaximumSize(new Dimension(130, 70));
        this.alarmList.setMinimumSize(new Dimension(130, 70));
        this.alarmList.setPreferredSize(new Dimension(130, 70));
        this.alarmList.setSelectionMode(0);
        this.alarmList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                AsyncMsgDisplay.this.alarmList_mouseClicked(mouseEvent);
            }
        });
        ((Container)((Object)this)).add(this.statusScrollPane, null);
        this.statusScrollPane.getViewport().add((Component)this.statusList, null);
        ((Container)((Object)this)).add(this.alarmScrollPane, null);
        this.alarmScrollPane.getViewport().add((Component)this.alarmList, null);
        ((Container)((Object)this)).add(this.errorScrollPane, null);
        this.errorScrollPane.getViewport().add((Component)this.errorList, null);
    }

    private synchronized void notifyAppStable() {
        if (!this.applicationIsStable) {
            this.applicationIsStable = true;
            ((Object)((Object)this)).notifyAll();
        }
    }

    public synchronized void waitUntilStable() {
        try {
            while (!this.applicationIsStable) {
                ((Object)((Object)this)).wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void stop() {
        this.trk.removeStatusListener((StatusListener)this.statusListener);
        this.trk.removeAlarmListener((AlarmListener)this.alarmListener);
        this.trk.removeDiagnosticListener((DiagnosticListener)this.diagListener);
        super.stop();
    }

    private void insertAlarm(Alarm alarm) {
        int n = 0;
        DefaultListModel defaultListModel = (DefaultListModel)this.alarmList.getModel();
        int n2 = defaultListModel.getSize();
        for (n = 0; n < n2; ++n) {
            AlarmListElement alarmListElement = (AlarmListElement)defaultListModel.getElementAt(n);
            if (alarm.getAlarmNumber() < alarmListElement.msg.getAlarmNumber()) break;
            if (alarm.getAlarmNumber() != alarmListElement.msg.getAlarmNumber()) continue;
            return;
        }
        defaultListModel.add(n, new AlarmListElement(this, alarm));
    }

    private void removeAlarm(Alarm alarm) {
        int n = 0;
        DefaultListModel defaultListModel = (DefaultListModel)this.alarmList.getModel();
        int n2 = defaultListModel.getSize();
        for (n = 0; n < n2; ++n) {
            AlarmListElement alarmListElement = (AlarmListElement)defaultListModel.getElementAt(n);
            if (alarm.getAlarmNumber() < alarmListElement.msg.getAlarmNumber()) {
                return;
            }
            if (alarm.getAlarmNumber() == alarmListElement.msg.getAlarmNumber()) break;
        }
        if (n == n2) {
            return;
        }
        defaultListModel.removeElementAt(n);
    }

    private void onAlarm(Alarm alarm) {
        if (alarm.getState()) {
            this.insertAlarm(alarm);
        } else {
            this.removeAlarm(alarm);
        }
    }

    private void insertStatus(Status status) {
        int n = 0;
        DefaultListModel defaultListModel = (DefaultListModel)this.statusList.getModel();
        int n2 = defaultListModel.getSize();
        for (n = 0; n < n2; ++n) {
            StatusListElement statusListElement = (StatusListElement)defaultListModel.getElementAt(n);
            if (status.getCode() < statusListElement.msg.getCode()) break;
            if (status.getCode() != statusListElement.msg.getCode()) continue;
            return;
        }
        defaultListModel.add(n, new StatusListElement(this, status));
    }

    private void removeStatus(Status status) {
        int n = 0;
        DefaultListModel defaultListModel = (DefaultListModel)this.statusList.getModel();
        int n2 = defaultListModel.getSize();
        for (n = 0; n < n2; ++n) {
            StatusListElement statusListElement = (StatusListElement)defaultListModel.getElementAt(n);
            if (status.getCode() < statusListElement.msg.getCode()) {
                return;
            }
            if (status.getCode() == statusListElement.msg.getCode()) break;
        }
        if (n == n2) {
            return;
        }
        defaultListModel.removeElementAt(n);
    }

    private void onStatus(Status status) {
        if (status.getState()) {
            this.insertStatus(status);
        } else {
            this.removeStatus(status);
        }
    }

    private boolean diagInList(Diagnostic diagnostic) {
        DefaultListModel defaultListModel = (DefaultListModel)this.errorList.getModel();
        int n = defaultListModel.getSize();
        for (int i = 0; i < n; ++i) {
            DiagListElement diagListElement = (DiagListElement)defaultListModel.getElementAt(i);
            if (diagnostic.getCode() != diagListElement.msg.getCode() || diagnostic.getID() != diagListElement.msg.getID()) continue;
            return true;
        }
        return false;
    }

    private void onDiagnostic(Diagnostic diagnostic) {
        DefaultListModel defaultListModel = (DefaultListModel)this.errorList.getModel();
        int n = defaultListModel.getSize();
        if (this.diagInList(diagnostic)) {
            return;
        }
        if (25 == n) {
            defaultListModel.removeElementAt(n - 1);
        }
        defaultListModel.add(0, new DiagListElement(this, diagnostic));
    }

    private void errorList_mouseClicked(MouseEvent mouseEvent) {
        if (2 == mouseEvent.getClickCount()) {
            DefaultListModel defaultListModel = (DefaultListModel)this.errorList.getModel();
            int n = this.errorList.locationToIndex(mouseEvent.getPoint());
            if (n >= 0) {
                DiagListElement diagListElement = (DiagListElement)defaultListModel.getElementAt(n);
                DiagDetails diagDetails = new DiagDetails((Frame)this.frame, diagListElement.toString(), true, diagListElement.msg);
                ((Component)diagDetails).setVisible(true);
            }
        }
    }

    void statusList_mouseClicked(MouseEvent mouseEvent) {
        if (2 == mouseEvent.getClickCount()) {
            DefaultListModel defaultListModel = (DefaultListModel)this.statusList.getModel();
            int n = this.statusList.locationToIndex(mouseEvent.getPoint());
            if (n >= 0) {
                StatusListElement statusListElement = (StatusListElement)defaultListModel.getElementAt(n);
                StatusDetails statusDetails = new StatusDetails((Frame)this.frame, statusListElement.toString(), true, statusListElement.msg);
                ((Component)statusDetails).setVisible(true);
            }
        }
    }

    void alarmList_mouseClicked(MouseEvent mouseEvent) {
        if (2 == mouseEvent.getClickCount()) {
            DefaultListModel defaultListModel = (DefaultListModel)this.alarmList.getModel();
            int n = this.alarmList.locationToIndex(mouseEvent.getPoint());
            if (n >= 0) {
                AlarmListElement alarmListElement = (AlarmListElement)defaultListModel.getElementAt(n);
                AlarmDetails alarmDetails = new AlarmDetails((Frame)this.frame, alarmListElement.toString(), true, alarmListElement.msg);
                ((Component)alarmDetails).setVisible(true);
            }
        }
    }

    private class AsyncDispStatusListener
    implements StatusListener,
    Runnable {
        private ArrayList msg = new ArrayList();

        private AsyncDispStatusListener() {
        }

        public void statusChanged(StatusEvent statusEvent) {
            this.msg.add(statusEvent.getStatus());
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            AsyncMsgDisplay.this.onStatus((Status)this.msg.remove(0));
        }
    }

    private class DiagListElement {
        public Diagnostic msg;

        DiagListElement(AsyncMsgDisplay asyncMsgDisplay, Diagnostic diagnostic) {
            this.msg = diagnostic;
        }

        public String toString() {
            switch (this.msg.getCode()) {
                case 6: {
                    return res.getString("Default_Cfg_Loaded");
                }
                case 3: {
                    return res.getString("Device_Failed");
                }
                case 2: {
                    return res.getString("Device_Reset");
                }
                case 8: {
                    return res.getString("Internal_Tracker_Error");
                }
                case 7: {
                    return res.getString("No_Encoder_Maps_Loaded");
                }
                case 1: {
                    return res.getString("Motor_Failure");
                }
                case 5: {
                    return res.getString("Realtime_Clock_Not_Set");
                }
                case 4: {
                    return res.getString("Realtime_Clock_Has_Been_Reset");
                }
            }
            return res.getString("Unkown_Error");
        }
    }

    private class StatusListElement {
        public Status msg;

        StatusListElement(AsyncMsgDisplay asyncMsgDisplay, Status status) {
            this.msg = status;
        }

        public String toString() {
            switch (this.msg.getCode()) {
                case 1: {
                    return res.getString("Measuring");
                }
                case 2: {
                    return res.getString("Need_Distance_Reset");
                }
                case 3: {
                    return res.getString("Laser_Not_Locked");
                }
                case 4: {
                    return res.getString("Isolator_Temp_Out_Of_Range");
                }
                case 5: {
                    return res.getString("Weather_Reading_Inaccurate");
                }
                case 6: {
                    return res.getString("Motors_Turned_Off");
                }
                case 7: {
                    return res.getString("Marginal_Target");
                }
                case 8: {
                    return res.getString("IFM_Dropout");
                }
                case 9: {
                    return res.getString("ADM_Dropout");
                }
                case 10: {
                    return res.getString("High_Radial_Speed");
                }
                case 11: {
                    return res.getString("No_Target");
                }
                case 12: {
                    return res.getString("Searching_For_Target");
                }
                case 13: {
                    return res.getString("Shutter_Closed");
                }
                case 14: {
                    return res.getString("Laser_Off");
                }
                case 15: {
                    return res.getString("Level_Enabled");
                }
                case 16: {
                    return res.getString("Motor_Position_Inaccurate");
                }
                case 17: {
                    return res.getString("Manual_Position_Change");
                }
                case 18: {
                    return res.getString("Clock_Set_Pending");
                }
                case 19: {
                    return res.getString("Close_To_Low_Physical_Stop");
                }
                case 20: {
                    return res.getString("Close_To_High_Physical_Stop");
                }
                case 21: {
                    return res.getString("ADM_Inaccurate");
                }
            }
            return res.getString("Unknown");
        }
    }

    private class AlarmListElement {
        public Alarm msg;

        AlarmListElement(AsyncMsgDisplay asyncMsgDisplay, Alarm alarm) {
            this.msg = alarm;
        }

        public String toString() {
            return String.valueOf(String.valueOf(res.getString("Alarm_Number"))).concat(String.valueOf(String.valueOf(this.msg.getAlarmNumber())));
        }
    }

    private class AsyncDispDiagListener
    implements DiagnosticListener,
    Runnable {
        private ArrayList msg = new ArrayList();

        private AsyncDispDiagListener() {
        }

        public void diagnosticReported(DiagnosticEvent diagnosticEvent) {
            this.msg.add(diagnosticEvent.getDiagnostic());
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            AsyncMsgDisplay.this.onDiagnostic((Diagnostic)this.msg.remove(0));
        }
    }

    private class AsyncDispAlarmListener
    implements AlarmListener,
    Runnable {
        private ArrayList msg = new ArrayList();

        private AsyncDispAlarmListener() {
        }

        public void alarmChanged(AlarmEvent alarmEvent) {
            this.msg.add(alarmEvent.getAlarm());
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            AsyncMsgDisplay.this.onAlarm((Alarm)this.msg.remove(0));
        }
    }

    private class AsyncThread
    implements Runnable {
        private Tracker trk;

        private void setExclusiveAccess() throws TrackerException {
            int n;
            for (n = 0; n < 10; ++n) {
                try {
                    this.trk.setExclusiveAccess();
                    break;
                }
                catch (InterfaceBusyException interfaceBusyException) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            if (10 == n) {
                this.trk.setExclusiveAccess();
            }
        }

        private void clearExclusiveAccess() throws TrackerException {
            this.trk.clearExclusiveAccess();
        }

        public AsyncThread(Tracker tracker) {
            Thread thread = new Thread((Runnable)this, "Async Display Thread");
            thread.setDaemon(true);
            this.trk = tracker;
            thread.start();
        }

        public void run() {
            Alarm[] alarmArray = null;
            Diagnostic[] diagnosticArray = null;
            Status[] statusArray = null;
            try {
                int n;
                int n2;
                this.setExclusiveAccess();
                try {
                    alarmArray = this.trk.alarmHistory();
                    n2 = alarmArray.length;
                    for (n = 0; n < n2; ++n) {
                        AsyncMsgDisplay.this.onAlarm(alarmArray[n]);
                    }
                }
                catch (NoDataAvailableException noDataAvailableException) {
                    // empty catch block
                }
                try {
                    diagnosticArray = this.trk.diagnosticHistory();
                    n2 = diagnosticArray.length;
                    for (n = 0; n < n2; ++n) {
                        AsyncMsgDisplay.this.onDiagnostic(diagnosticArray[n]);
                    }
                }
                catch (NoDataAvailableException noDataAvailableException) {
                    // empty catch block
                }
                try {
                    statusArray = this.trk.statusHistory();
                    n2 = statusArray.length;
                    for (n = 0; n < n2; ++n) {
                        AsyncMsgDisplay.this.onStatus(statusArray[n]);
                    }
                }
                catch (NoDataAvailableException noDataAvailableException) {
                    // empty catch block
                }
                this.clearExclusiveAccess();
            }
            catch (TrackerException trackerException) {
                trackerException.printStackTrace();
            }
            AsyncMsgDisplay.this.notifyAppStable();
        }
    }
}

