/*
 * Decompiled with CFR 0.152.
 */
package ipaddressutility;

import ipaddressutility.CypherInfo;
import ipaddressutility.HelperUtility;
import ipaddressutility.NetworkCardInfo;
import ipaddressutility.TrackerReachableInfo;
import ipaddressutility.TrkInfo;
import ipaddressutility.VantageIonInfo;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class TrackerReachable {
    Vector<TrkInfo> trksFoundList;
    Vector<NetworkCardInfo> nicAddrsList;
    public static final int WIRELESS = 1;
    PrintWriter debugWriter = null;
    private int TIMEOUT = 1;
    private int PING_TIMEOUT = 1000;
    HashMap<String, Boolean> wifiPingedIpsList = new HashMap();
    String notApplicable = "N/A";

    public TrackerReachable(Vector<TrkInfo> vector, Vector<NetworkCardInfo> vector2, PrintWriter printWriter) {
        this.trksFoundList = vector;
        this.nicAddrsList = vector2;
        this.debugWriter = printWriter;
    }

    public void checkIfTrackerReachable(TrkInfo trkInfo) throws Exception {
        if (trkInfo instanceof CypherInfo) {
            TrackerReachableInfo trackerReachableInfo = this.getCypherReachableDetails(trkInfo, this.trksFoundList, "", null, this.nicAddrsList, false);
            CypherInfo cypherInfo = (CypherInfo)trkInfo;
            cypherInfo.setReachable(trackerReachableInfo.getReachableState().ordinal());
            cypherInfo.setReachableDetails(trackerReachableInfo.getDetails());
            cypherInfo.setReachableRecommendation(trackerReachableInfo.getRecommendation());
        } else {
            TrackerReachableInfo[] trackerReachableInfoArray = this.getVantageIONReachableDetails(trkInfo, this.trksFoundList, "", null, this.nicAddrsList);
            VantageIonInfo vantageIonInfo = (VantageIonInfo)trkInfo;
            vantageIonInfo.setWiredReachable(trackerReachableInfoArray[0].getReachableState().ordinal());
            vantageIonInfo.setWiredReachableDetails(trackerReachableInfoArray[0].getDetails());
            vantageIonInfo.setWiredReachableRecommendation(trackerReachableInfoArray[0].getRecommendation());
            if (vantageIonInfo.getModelType() == 1) {
                vantageIonInfo.setWifiReachable(trackerReachableInfoArray[1].getReachableState().ordinal());
                vantageIonInfo.setWifiReachableDetails(trackerReachableInfoArray[1].getDetails());
                vantageIonInfo.setWifiReachableRecommendation(trackerReachableInfoArray[1].getRecommendation());
            }
        }
    }

    private TrackerReachableInfo getCypherReachableDetails(TrkInfo trkInfo, Vector<TrkInfo> vector, String string, Object[] objectArray, Vector<NetworkCardInfo> vector2, boolean bl) throws Exception {
        TrackerReachableInfo trackerReachableInfo = null;
        if (trkInfo instanceof CypherInfo) {
            String string2;
            CypherInfo cypherInfo = (CypherInfo)trkInfo;
            if (cypherInfo.getPacketType() == CypherInfo.CYPHER_WIFI_PACKET) {
                string2 = "";
                if (cypherInfo.supportsWifiSSIDInfo()) {
                    if (!cypherInfo.sessionsAvailable()) {
                        return new TrackerReachableInfo(TrackerReachableInfo.REACHABLE_STATE.NO, "Out of sessions", "Reboot tracker and try to connect again or please wait for 15 minutes and then try to connect again.");
                    }
                    if ((cypherInfo.getSerialType() & 1) == 0) {
                        return new TrackerReachableInfo(TrackerReachableInfo.REACHABLE_STATE.NO, "Tracker is not Wifi capable", "Cannot use  tracker in Wifi mode");
                    }
                    string2 = cypherInfo.getTrkSSID();
                    if (!cypherInfo.isTrkWifiOn()) {
                        return new TrackerReachableInfo(TrackerReachableInfo.REACHABLE_STATE.NO, "Tracker Wifi is off", "Turn tracker Wifi on and connect to SSID " + string2);
                    }
                }
                trackerReachableInfo = this.getCypherWifiReachableDetails(true, cypherInfo, vector2, string2);
            }
            if (cypherInfo.getPacketType() == CypherInfo.CYPHER_WIRED_PACKET) {
                if (cypherInfo.supportsWifiSSIDInfo()) {
                    if (!cypherInfo.sessionsAvailable()) {
                        return new TrackerReachableInfo(TrackerReachableInfo.REACHABLE_STATE.NO, "Out of sessions", "Reboot tracker and try to connect again or please wait for 15 minutes and then try to connect again.");
                    }
                    if (!cypherInfo.isEthernetOn()) {
                        return new TrackerReachableInfo(TrackerReachableInfo.REACHABLE_STATE.NO, "No ethernet cable", "Connect ethernet cable from tracker to PC");
                    }
                }
                if (cypherInfo.getStaticDynamicInfo() == 2) {
                    string2 = cypherInfo.getIpAdd();
                    if (string2.equals("None") || string2.equals("0.0.0.0")) {
                        TrackerReachableInfo.REACHABLE_STATE rEACHABLE_STATE = TrackerReachableInfo.REACHABLE_STATE.NO;
                        String string3 = "DHCP IP address not available";
                        String string4 = "Tracker is in DHCP mode. Reconfigure tracker to a Static IP address or plug tracker ethernet cable into DHCP server network and connect the computer to the same network.";
                        return new TrackerReachableInfo(rEACHABLE_STATE, string3, string4);
                    }
                    boolean bl2 = this.sendPingRequest(cypherInfo.getIpAdd());
                    if (bl2) {
                        return new TrackerReachableInfo(TrackerReachableInfo.REACHABLE_STATE.YES, "Tracker can be reached in wired mode (DHCP)", this.notApplicable);
                    }
                    return new TrackerReachableInfo(TrackerReachableInfo.REACHABLE_STATE.NO, "Tracker is in DHCP mode but connot be reached", "Plug tracker ethernet cable into DHCP server network and connect the computer to the same network.");
                }
                trackerReachableInfo = this.getWiredReachableDetails(cypherInfo, vector2);
            }
        }
        return trackerReachableInfo;
    }

    private TrackerReachableInfo getWiredReachableDetails(TrkInfo trkInfo, Vector<NetworkCardInfo> vector) {
        TrackerReachableInfo.REACHABLE_STATE rEACHABLE_STATE;
        String string = this.notApplicable;
        String string2 = this.notApplicable;
        if (this.sendPingRequest(trkInfo.getIpAdd())) {
            return new TrackerReachableInfo(TrackerReachableInfo.REACHABLE_STATE.YES, "Tracker can be reached in wired mode", "This is a valid connection configuration. No changes required.");
        }
        boolean bl = this.checkIfIPaddressAreWithinSameSubnet(trkInfo);
        TrackerReachableInfo.REACHABLE_STATE rEACHABLE_STATE2 = rEACHABLE_STATE = bl ? TrackerReachableInfo.REACHABLE_STATE.YES : TrackerReachableInfo.REACHABLE_STATE.NO;
        if (bl) {
            string = "Tracker can be reached in wired mode";
        } else {
            Object[] objectArray = this.checkIfTrkCanBeReachedFromAnotherNIC(trkInfo, vector);
            if (((Boolean)objectArray[0]).booleanValue()) {
                string = "Not connected to computer";
                string2 = "Connect ethernet cable from tracker to PC network card #" + ((Integer)objectArray[1] + 1) + ". See below.";
            } else {
                string = "PC network card IP address not in the same subnet tracker IP address.";
                string2 = "Change the PC network IP address to be in the same subnet of tracker IP address or vice versa.";
                String string3 = trkInfo.getIpAdd();
                if (string3.startsWith("128.128.128.")) {
                    string2 = string3.equals("128.128.128.10") ? "Set the PC network card IP address to 128.128.128.11" : "Set the PC network card IP address to 128.128.128.10";
                }
            }
        }
        return new TrackerReachableInfo(rEACHABLE_STATE, string, string2);
    }

    private boolean checkIfIPaddressAreWithinSameSubnet(TrkInfo trkInfo) {
        return TrackerReachable.checkIfIPaddressAreWithinSameSubnet(trkInfo, trkInfo.getNetworkCardIpAdd(), trkInfo.getNetworkCardIpMask());
    }

    private static boolean checkIfIPaddressAreWithinSameSubnet(TrkInfo trkInfo, String string, String string2) {
        return HelperUtility.checkIfIPaddressAreWithinSameSubnet(trkInfo.getIpAdd(), trkInfo.getIpMask(), string, string2);
    }

    private Object[] checkIfTrkCanBeReachedFromAnotherNIC(TrkInfo trkInfo, Vector vector) {
        return this.checkIfTrkCanBeReachedFromAnotherNIC(trkInfo.getIpAdd(), trkInfo.getIpMask(), trkInfo, vector);
    }

    private TrackerReachableInfo[] getVantageIONReachableDetails(TrkInfo trkInfo, Vector<TrkInfo> vector, String string, Object[] objectArray, Vector<NetworkCardInfo> vector2) throws Exception {
        TrackerReachableInfo[] trackerReachableInfoArray = new TrackerReachableInfo[2];
        if (trkInfo instanceof VantageIonInfo) {
            VantageIonInfo vantageIonInfo = (VantageIonInfo)trkInfo;
            trackerReachableInfoArray[0] = this.getWiredReachableDetails(vantageIonInfo, vector2);
            if (vantageIonInfo.getModelType() == 1) {
                String string2 = vantageIonInfo.getSSIDName();
                trackerReachableInfoArray[1] = this.getVantageIONWifiReachableDetails(true, vantageIonInfo, vector2, string2);
            }
        }
        return trackerReachableInfoArray;
    }

    private TrackerReachableInfo getVantageIONWifiReachableDetails(boolean bl, TrkInfo trkInfo, Vector<NetworkCardInfo> vector, String string) throws Exception {
        TrackerReachableInfo.REACHABLE_STATE rEACHABLE_STATE;
        String string2 = this.notApplicable;
        String string3 = this.notApplicable;
        VantageIonInfo vantageIonInfo = (VantageIonInfo)trkInfo;
        if (vantageIonInfo.getWifiMode() == 0) {
            return new TrackerReachableInfo(TrackerReachableInfo.REACHABLE_STATE.NONE, string2, string3);
        }
        if (vantageIonInfo.getWifiMode() == 2) {
            return new TrackerReachableInfo(TrackerReachableInfo.REACHABLE_STATE.NO, "Wifi is off", "Turn Wifi on and connect to tracker SSID " + string);
        }
        boolean bl2 = HelperUtility.checkIfIPaddressAreWithinSameSubnet(vantageIonInfo.getWifiIp(), vantageIonInfo.getIpMask(), vantageIonInfo.getNetworkCardIpAdd(), vantageIonInfo.getNetworkCardIpMask());
        TrackerReachableInfo.REACHABLE_STATE rEACHABLE_STATE2 = rEACHABLE_STATE = bl2 ? TrackerReachableInfo.REACHABLE_STATE.YES : TrackerReachableInfo.REACHABLE_STATE.NO;
        if (bl2) {
            string2 = "Tracker can be reached in Wifi mode";
            string3 = "This is a valid connection configuration. No changes required.";
        } else {
            Object[] objectArray = this.checkIfTrkCanBeReachedFromAnotherNIC(vantageIonInfo.getWifiIp(), vantageIonInfo.getIpMask(), vantageIonInfo, vector);
            if (((Boolean)objectArray[0]).booleanValue()) {
                string2 = "Computer not connected to tracker SSID";
                string3 = "Connect to tracker SSID " + string;
            } else {
                string2 = "Computer not connected to tracker SSID ";
                string3 = "Connect to tracker SSID " + string;
            }
        }
        boolean bl3 = this.wifiPingedIpsList.get(trkInfo.getSrNum());
        if (!bl3) {
            rEACHABLE_STATE = TrackerReachableInfo.REACHABLE_STATE.NO;
            string2 = "Computer not connected to tracker SSID ";
            string3 = "Connect to tracker SSID " + string;
        }
        return new TrackerReachableInfo(rEACHABLE_STATE, string2, string3);
    }

    private TrackerReachableInfo getCypherWifiReachableDetails(boolean bl, TrkInfo trkInfo, Vector<NetworkCardInfo> vector, String string) {
        String string2;
        TrackerReachableInfo.REACHABLE_STATE rEACHABLE_STATE;
        String string3 = this.notApplicable;
        String string4 = this.notApplicable;
        boolean bl2 = this.checkIfIPaddressAreWithinSameSubnet(trkInfo);
        TrackerReachableInfo.REACHABLE_STATE rEACHABLE_STATE2 = rEACHABLE_STATE = bl2 ? TrackerReachableInfo.REACHABLE_STATE.YES : TrackerReachableInfo.REACHABLE_STATE.NO;
        if (bl2) {
            string3 = "Tracker can be reached in Wifi mode";
            string4 = "This is a valid connection configuration. No changes required.";
        } else {
            Object[] objectArray = this.checkIfTrkCanBeReachedFromAnotherNIC(trkInfo, vector);
            if (((Boolean)objectArray[0]).booleanValue()) {
                string3 = "Computer not connected to tracker SSID";
                string4 = "Connect to tracker SSID " + string;
                if (string.equals("") && trkInfo.getPacketType() == TrkInfo.CYPHER_WIFI_PACKET) {
                    string2 = this.getSSIDNameFromSrNum(trkInfo);
                    string4 = "Connect to tracker SSID ending with serial number " + string2;
                }
            } else {
                string3 = "Computer not connected to tracker SSID";
                string4 = "Connect to tracker SSID " + string;
                if (string.equals("") && trkInfo.getPacketType() == TrkInfo.CYPHER_WIFI_PACKET) {
                    string2 = this.getSSIDNameFromSrNum(trkInfo);
                    string4 = "Connect to tracker SSID ending with serial number " + string2;
                }
            }
        }
        boolean bl3 = this.wifiPingedIpsList.get(trkInfo.getSrNum());
        if (!bl3) {
            rEACHABLE_STATE = TrackerReachableInfo.REACHABLE_STATE.NO;
            string3 = "Computer not connected to tracker SSID";
            string4 = "Connect to tracker SSID " + string;
            if (string.equals("") && trkInfo.getPacketType() == TrkInfo.CYPHER_WIFI_PACKET) {
                string2 = this.getSSIDNameFromSrNum(trkInfo);
                string4 = "Connect to tracker SSID ending with serial number " + string2;
            }
        }
        return new TrackerReachableInfo(rEACHABLE_STATE, string3, string4);
    }

    private Object[] checkIfTrkCanBeReachedFromAnotherNIC(String string, String string2, TrkInfo trkInfo, Vector vector) {
        boolean bl = false;
        int n = 0;
        int n2 = vector.size();
        if (n2 == 0) {
            return new Object[]{bl, n};
        }
        int n3 = 0;
        while (n3 < n2) {
            NetworkCardInfo networkCardInfo = (NetworkCardInfo)vector.get(n3);
            String string3 = networkCardInfo.getIPAddress().getHostAddress();
            String string4 = networkCardInfo.getSubNet();
            if (!(string3.equals(trkInfo.getNetworkCardIpAdd()) && string4.equals(trkInfo.getNetworkCardIpMask()) || !(bl = HelperUtility.checkIfIPaddressAreWithinSameSubnet(string, string2, string3, string4)))) {
                networkCardInfo.getNetworkInterface();
                n = n3;
                break;
            }
            ++n3;
        }
        return new Object[]{new Boolean(bl), new Integer(n)};
    }

    private boolean checkIfTrackerIPAndNetworkCardIPSame(String string, String string2) {
        String[] stringArray;
        int n;
        String[] stringArray2 = string.split("\\.");
        int n2 = stringArray2.length;
        if (n2 != (n = (stringArray = string2.split("\\.")).length)) {
            return true;
        }
        if (n2 < 4 || n < 4) {
            return true;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (stringArray2[n3] != stringArray[n3]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private boolean sendPingRequest(String string) {
        if (string == null) {
            return false;
        }
        boolean bl = false;
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            bl = inetAddress.isReachable(this.PING_TIMEOUT);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return bl;
    }

    protected void checkIfTrackersReachable() {
        int n = this.trksFoundList.size();
        System.currentTimeMillis();
        this.CheckIfAnyWifiIpIsPingable();
        CountDownLatch countDownLatch = new CountDownLatch(n);
        int n2 = 0;
        while (n2 < n) {
            TrkInfo trkInfo = this.trksFoundList.get(n2);
            new CheckIfTrkReachableThread(trkInfo, "TrkReachThread_" + (n2 + 1), countDownLatch);
            ++n2;
        }
        try {
            countDownLatch.await(this.TIMEOUT, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            this.logLine("Reachable Threads timeout");
        }
        this.checkIfReachableTrackersHaveSameIP();
    }

    private void logLine(String string) {
        if (this.debugWriter != null) {
            this.debugWriter.println(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void CheckIfAnyWifiIpIsPingable() {
        void var7_12;
        Object object;
        CheckIfWifiIpPingableThread[] checkIfWifiIpPingableThreadArray;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = this.trksFoundList.size();
        int n2 = 0;
        while (n2 < n) {
            checkIfWifiIpPingableThreadArray = this.trksFoundList.get(n2);
            if (checkIfWifiIpPingableThreadArray instanceof CypherInfo) {
                if (checkIfWifiIpPingableThreadArray.getPacketType() == CypherInfo.CYPHER_WIFI_PACKET) {
                    hashMap.put(checkIfWifiIpPingableThreadArray.getIpAdd(), checkIfWifiIpPingableThreadArray.getSrNum());
                }
            } else {
                VantageIonInfo vantageIonInfo = (VantageIonInfo)checkIfWifiIpPingableThreadArray;
                if (vantageIonInfo.getModelType() == 1) {
                    hashMap.put(vantageIonInfo.getWifiIp(), vantageIonInfo.getSrNum());
                }
            }
            ++n2;
        }
        CountDownLatch countDownLatch = new CountDownLatch(n);
        checkIfWifiIpPingableThreadArray = new CheckIfWifiIpPingableThread[n];
        int n3 = 0;
        for (Map.Entry entry : hashMap.entrySet()) {
            object = (String)entry.getKey();
            checkIfWifiIpPingableThreadArray[n3] = new CheckIfWifiIpPingableThread((String)object, "SSID", countDownLatch);
            ++n3;
        }
        try {
            countDownLatch.await(this.TIMEOUT, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            this.logLine("Reachable Threads timeout");
        }
        HashMap<String, Boolean> hashMap2 = new HashMap<String, Boolean>();
        n3 = 0;
        for (Map.Entry entry : hashMap.entrySet()) {
            String string = (String)entry.getKey();
            hashMap2.put(string, checkIfWifiIpPingableThreadArray[n3].pingable());
            ++n3;
        }
        boolean bl = false;
        while (var7_12 < n) {
            object = this.trksFoundList.get((int)var7_12);
            boolean bl2 = false;
            if (object instanceof CypherInfo) {
                if (((TrkInfo)object).getPacketType() == CypherInfo.CYPHER_WIFI_PACKET && hashMap2.containsKey(((TrkInfo)object).getIpAdd())) {
                    bl2 = (Boolean)hashMap2.get(((TrkInfo)object).getIpAdd());
                }
            } else {
                VantageIonInfo vantageIonInfo = (VantageIonInfo)object;
                if (vantageIonInfo.getModelType() == 1 && hashMap2.containsKey(vantageIonInfo.getWifiIp())) {
                    bl2 = (Boolean)hashMap2.get(vantageIonInfo.getWifiIp());
                }
            }
            this.wifiPingedIpsList.put(((TrkInfo)object).getSrNum(), bl2);
            ++var7_12;
        }
    }

    private void checkIfReachableTrackersHaveSameIP() {
        int n = this.trksFoundList.size();
        int n2 = 0;
        while (n2 < n) {
            block11: {
                Object object;
                String string;
                Object object2;
                TrkInfo trkInfo;
                TrkInfo trkInfo2 = this.trksFoundList.get(n2);
                if (trkInfo2 instanceof VantageIonInfo && ((VantageIonInfo)(trkInfo = (VantageIonInfo)trkInfo2)).getWifiMode() == 1 || trkInfo2 instanceof CypherInfo && ((CypherInfo)(trkInfo = (CypherInfo)trkInfo2)).getPacketType() == TrkInfo.CYPHER_WIFI_PACKET) break block11;
                boolean bl = false;
                String string2 = "";
                String string3 = "";
                if (trkInfo2 instanceof VantageIonInfo) {
                    string2 = ((VantageIonInfo)trkInfo2).getSrNum();
                    string3 = ((VantageIonInfo)trkInfo2).getIpAdd();
                }
                if (trkInfo2 instanceof CypherInfo) {
                    string2 = ((CypherInfo)trkInfo2).getSrNum();
                    string3 = ((CypherInfo)trkInfo2).getIpAdd();
                }
                int n3 = 0;
                while (n3 < n && !bl) {
                    block13: {
                        block14: {
                            TrkInfo trkInfo3;
                            block12: {
                                object2 = this.trksFoundList.get(new Integer(n3));
                                string = "";
                                object = "";
                                if (!(object2 instanceof VantageIonInfo)) break block12;
                                trkInfo3 = (VantageIonInfo)object2;
                                if (((VantageIonInfo)trkInfo3).getWifiMode() == 1) break block13;
                                string = trkInfo3.getSrNum();
                                object = trkInfo3.getIpAdd();
                            }
                            if (!(object2 instanceof CypherInfo)) break block14;
                            trkInfo3 = (CypherInfo)object2;
                            if (((CypherInfo)trkInfo3).getPacketType() == TrkInfo.CYPHER_WIFI_PACKET) break block13;
                            string = trkInfo3.getSrNum();
                            object = trkInfo3.getIpAdd();
                        }
                        if (!string2.equals(string) && string3.equals(object)) {
                            bl = true;
                        }
                    }
                    ++n3;
                }
                if (bl) {
                    TrackerReachableInfo.REACHABLE_STATE rEACHABLE_STATE = TrackerReachableInfo.REACHABLE_STATE.NO;
                    object2 = "Duplicate IP";
                    string = "Resolve IP Conflict";
                    if (trkInfo2 instanceof VantageIonInfo) {
                        object = (VantageIonInfo)trkInfo2;
                        ((VantageIonInfo)object).setWiredReachable(rEACHABLE_STATE.ordinal());
                        ((VantageIonInfo)object).setWiredReachableDetails((String)object2);
                        ((VantageIonInfo)object).setWiredReachableRecommendation(string);
                    }
                    if (trkInfo2 instanceof CypherInfo) {
                        object = (CypherInfo)trkInfo2;
                        ((CypherInfo)object).setReachable(rEACHABLE_STATE.ordinal());
                        ((CypherInfo)object).setReachableDetails((String)object2);
                        ((CypherInfo)object).setReachableRecommendation(string);
                    }
                }
            }
            ++n2;
        }
    }

    private String getSSIDNameFromSrNum(TrkInfo trkInfo) {
        String string = trkInfo.getSrNum();
        int n = string.length();
        if (n > 4) {
            string = string.substring(n - 4, n);
        }
        return string;
    }

    private class CheckIfTrkReachableThread
    implements Runnable {
        TrkInfo trkInfo;
        CountDownLatch latch;

        public CheckIfTrkReachableThread(TrkInfo trkInfo, String string, CountDownLatch countDownLatch) {
            this.trkInfo = trkInfo;
            this.latch = countDownLatch;
            Thread thread = new Thread((Runnable)this, string);
            thread.setDaemon(true);
            thread.start();
        }

        @Override
        public void run() {
            Thread.currentThread().getName();
            try {
                TrackerReachable.this.checkIfTrackerReachable(this.trkInfo);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (this.latch != null) {
                this.latch.countDown();
            }
        }
    }

    private class CheckIfWifiIpPingableThread
    implements Runnable {
        String ip;
        CountDownLatch latch;
        boolean ping = false;

        public CheckIfWifiIpPingableThread(String string, String string2, CountDownLatch countDownLatch) {
            this.ip = string;
            this.latch = countDownLatch;
            Thread thread = new Thread((Runnable)this, string2);
            thread.setDaemon(true);
            thread.start();
        }

        @Override
        public void run() {
            Thread.currentThread().getName();
            try {
                this.ping = TrackerReachable.this.sendPingRequest(this.ip);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (this.latch != null) {
                this.latch.countDown();
            }
        }

        public boolean pingable() {
            return this.ping;
        }
    }
}

