/*
 * Decompiled with CFR 0.152.
 */
package ipaddressutility;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class NetshUtility {
    public static void main(String[] stringArray) {
        NetshUtility.getAllWifiNetworks();
    }

    public static String getWiFiCardName() {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("cmd.exe", "/c", "netsh wlan show interfaces  | find \"Description\"");
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray = string.split(":");
                if (stringArray.length <= 1) continue;
                return stringArray[1].trim();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return "";
    }

    public static String getSSIDName() {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("cmd.exe", "/c", "netsh wlan show interfaces  | find \"SSID\"");
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray = string.split(":");
                if (stringArray.length <= 1) continue;
                return stringArray[1].trim();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return "";
    }

    public static Object[] getAllWifiNetworks() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("cmd.exe", "/c", "netsh wlan show networks");
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string = "";
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray;
                if (string == null || !(string = string.trim()).startsWith("SSID") || (stringArray = string.split(":")).length <= 1) continue;
                arrayList.add(stringArray[1].trim());
            }
        }
        catch (IOException iOException) {}
        return arrayList.toArray();
    }

    public static Object[] getAllWifiProfiles() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("cmd.exe", "/c", "netsh wlan show profiles");
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string = "";
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray;
                if (string == null || !(string = string.trim()).startsWith("All User Profile") || (stringArray = string.split(":")).length <= 1) continue;
                arrayList.add(stringArray[1].trim());
            }
        }
        catch (IOException iOException) {}
        return arrayList.toArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean connectWifi(String string) {
        try {
            String string2;
            ProcessBuilder processBuilder = new ProcessBuilder("cmd.exe", "/c", "netsh wlan connect name=" + string);
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string3 = "";
            do {
                if ((string3 = bufferedReader.readLine()) != null) continue;
                return false;
            } while (string3 == null || !(string3 = string3.trim()).contains(string2 = "success"));
            return true;
        }
        catch (IOException iOException) {}
        return false;
    }

    public static String getWifiNetworks() {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("cmd.exe", "/c", "netsh wlan show interfaces");
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray = string.split(":");
                if (stringArray.length <= 1) continue;
                if (stringArray[0].trim().equalsIgnoreCase("Name")) {
                    stringArray[1].trim();
                }
                if (stringArray[0].trim().equalsIgnoreCase("Description")) {
                    stringArray[1].trim();
                }
                if (stringArray[0].trim().equalsIgnoreCase("GUID")) {
                    stringArray[1].trim();
                }
                if (stringArray[0].trim().equalsIgnoreCase("Physical address")) {
                    stringArray[1].trim();
                }
                if (stringArray[0].trim().equalsIgnoreCase("State")) {
                    stringArray[1].trim();
                }
                if (stringArray[0].trim().equalsIgnoreCase("SSID")) {
                    stringArray[1].trim();
                }
                if (!stringArray[0].trim().equalsIgnoreCase("BSSID")) continue;
                stringArray[1].trim();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return "";
    }

    public static String getWiFiCardAdpaterName() {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("cmd.exe", "/c", "netsh wlan show interfaces  | find \"Name\"");
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray = string.split(":");
                if (stringArray.length <= 1) continue;
                return stringArray[1].trim();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return "";
    }

    public static String getWiFiCardIPAddress(String string) {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("cmd.exe", "/c", "netsh interface ip show addresses \"" + string + "\" | find \"IP Address\"");
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray = string2.split(":");
                if (stringArray.length <= 1) continue;
                return stringArray[1].trim();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return "";
    }

    public static Object[] getAllNetworkCardIPAddresses() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("cmd.exe", "/c", "netsh interface ip show addresses | findstr \"IP Address\"");
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray = string.split(":");
                if (stringArray.length <= 1) continue;
                arrayList.add(stringArray[1].trim());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return arrayList.toArray();
    }
}

