/*
 * Decompiled with CFR 0.152.
 */
package ipaddressutility;

import ipaddressutility.FindTrackers;
import ipaddressutility.HelperUtility;
import ipaddressutility.NetworkCardInfo;
import ipaddressutility.ThreadListener;
import ipaddressutility.TrkInfo;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.DatagramPacket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.TooManyListenersException;
import java.util.Vector;
import smx.utility.ThreadComm;

public class IPAddressUtilityThread
implements Runnable {
    public static final int FIND_TRACKERS = 0;
    public static final int CHANGE_IP_ADDRESS_MASK = 1;
    public static final int CHANGE_WIRELESS_STATE = 2;
    public static final int CHANGE_ETHERNET_CONFIG = 3;
    public static final int DEFAULT = 4;
    public static final int SHUTDOWN = 5;
    public static final int PACKET_LENGTH = 200;
    public static final int FIND_TRACKER_TIMEOUT = 1000;
    public static final int PORT = 4000;
    public static final int MULTICAST_TTL = 32;
    public static final int CHANGE_SETTING_TIMEOUT = 3000;
    private ThreadComm command = new ThreadComm();
    private ThreadComm response = new ThreadComm();
    public boolean shutdown = false;
    private ThreadListener listener = null;
    private boolean stopReceiving = false;
    private boolean checkboxSelected = true;
    public static final int OLD_PORT = 4000;
    public static final String OLD_GROUP = "224.0.0.40";
    public static final int NEW_PORT = 54000;
    public static final String NEW_GROUP = "239.0.0.40";
    protected static final String OLD_RESP = "Tracker IP Resp";
    protected static final String NEW_RESP = "TrackerV2 network response";
    private PrintWriter debugWriter = null;
    private int timeout = 1000;

    public IPAddressUtilityThread(PrintWriter printWriter) {
        Thread thread = new Thread((Runnable)this, "IPAddress Utility Thread");
        this.debugWriter = printWriter;
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void run() {
        Object[] objectArray = null;
        Object[] objectArray2 = null;
        while (!this.shutdown) {
            block18: {
                int n = 4;
                try {
                    objectArray = this.command.receive();
                    n = (Integer)objectArray[0];
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                objectArray2 = new Object[]{null, null};
                try {
                    switch (n) {
                        case 0: {
                            Object[] objectArray3;
                            this.logLine("STart Find Tracker");
                            this.timeout = 1000;
                            objectArray2[1] = objectArray3 = this.findTrackers();
                            this.logLine("End Find Tracker");
                            break;
                        }
                        case 1: {
                            this.timeout = 3000;
                            Object[] objectArray3 = (Object[])objectArray[1];
                            String string = objectArray3[0].toString();
                            if (string.equals(OLD_RESP)) {
                                objectArray2[1] = this.changeVantageIonTrkSettings(objectArray3, 1);
                                break;
                            }
                            if (string.equals(NEW_RESP)) {
                                objectArray2[1] = this.changeVantageSTrkSettings(objectArray3, 1);
                            }
                            break;
                        }
                        case 2: {
                            this.timeout = 3000;
                            Object[] objectArray3 = (Object[])objectArray[1];
                            objectArray2[1] = this.changeVantageIonTrkSettings(objectArray3, 2);
                            break;
                        }
                        case 3: {
                            this.timeout = 3000;
                            Object[] objectArray3 = (Object[])objectArray[1];
                            objectArray2[1] = this.changeVantageSTrkSettings(objectArray3, 3);
                            break;
                        }
                        case 4: {
                            break;
                        }
                        case 5: {
                            this.shutdown = true;
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    objectArray2[0] = exception;
                }
                try {
                    this.response.send(objectArray2);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    if (this.debugWriter == null) break block18;
                    iOException.printStackTrace(this.debugWriter);
                }
            }
            if (this.listener == null) continue;
            this.listener.commandComplete();
        }
    }

    public Object[] receiveResponse() {
        try {
            return this.response.receive();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public synchronized void sendCommand(Object[] objectArray) {
        block2: {
            try {
                this.response.flush();
                this.command.send(objectArray);
            }
            catch (IOException iOException) {
                if (this.debugWriter == null) break block2;
                iOException.printStackTrace(this.debugWriter);
            }
        }
    }

    public void addThreadListener(ThreadListener threadListener) throws TooManyListenersException {
        if (this.listener != null) {
            throw new TooManyListenersException();
        }
        this.listener = threadListener;
    }

    public void removeThreadListener(ThreadListener threadListener) {
        if (threadListener == this.listener) {
            this.listener = null;
        }
    }

    public Vector getNICsHostAddresses() throws SocketException {
        Vector<InetAddress> vector = new Vector<InetAddress>(10, 1);
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
            while (enumeration2.hasMoreElements()) {
                InetAddress inetAddress = enumeration2.nextElement();
                if (inetAddress instanceof Inet6Address || inetAddress.isLoopbackAddress()) continue;
                vector.addElement(inetAddress);
            }
        }
        return vector;
    }

    public void setCheckBoxSelection(boolean bl) {
        this.checkboxSelected = bl;
    }

    private String getTrackerIpAddress(String string) {
        String string2;
        String[] stringArray;
        String string3 = "";
        if (string.startsWith(OLD_RESP)) {
            String string4 = HelperUtility.getLegacyTrkInfo(string, OLD_RESP);
            String string5 = string4.substring(OLD_RESP.length() + 1, string4.length());
            String[] stringArray2 = string5.split(" ");
            if (stringArray2.length > 1) {
                string3 = stringArray2[1];
            }
        } else if (string.startsWith(NEW_RESP) && (stringArray = (string2 = string.substring(NEW_RESP.length() + 1, string.length())).split(" ")).length > 4) {
            string3 = stringArray[4];
        }
        return string3;
    }

    private Object[] changeVantageIonTrkSettings(Object[] objectArray, int n) throws SocketException, IOException, IOException {
        String string = "";
        if (n == 1) {
            objectArray[1].toString();
            string = objectArray[2].toString();
        } else if (n == 2) {
            string = objectArray[0].toString();
        }
        boolean bl = false;
        Vector vector = this.getNICsHostAddresses();
        if (vector.size() == 0) {
            throw new IOException();
        }
        String string2 = "";
        InetAddress inetAddress = InetAddress.getByName(OLD_GROUP);
        int n2 = 0;
        while (n2 < vector.size()) {
            InetAddress inetAddress2 = (InetAddress)vector.elementAt(n2);
            MulticastSocket multicastSocket = this.sendPacket(string, inetAddress, inetAddress2, 4000);
            boolean bl2 = false;
            while (!bl2) {
                try {
                    String string3;
                    Object object;
                    byte[] byArray = new byte[200];
                    DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                    multicastSocket.receive(datagramPacket);
                    if (datagramPacket == null) continue;
                    string2 = new String(datagramPacket.getData());
                    string2 = string2.trim();
                    if (n == 2) {
                        object = new StringTokenizer(string2, "@");
                        string3 = ((StringTokenizer)object).nextToken();
                        String string4 = "Tracker VMCU Network Success ";
                        String string5 = "Tracker VMCU Network Success ";
                        if (string3.equals(string4) || string3.equals(string5)) {
                            datagramPacket = null;
                            bl2 = true;
                        }
                        if (!string3.equals(string4)) continue;
                        bl = true;
                        continue;
                    }
                    if (n != 1) continue;
                    object = "Tracker IP Address Set Succeed";
                    string3 = "Tracker IP Address Set Failed";
                    if (string2.equals(object) || string2.equals(string3)) {
                        datagramPacket = null;
                        bl2 = true;
                    }
                    if (!string2.equals(object)) continue;
                    bl = true;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    bl2 = true;
                }
            }
            multicastSocket.leaveGroup(inetAddress);
            multicastSocket.close();
            if (bl) break;
            ++n2;
        }
        return new Object[]{new Boolean(bl), new String(string2)};
    }

    private Object[] changeVantageSTrkSettings(Object[] objectArray, int n) throws IOException {
        String string = "";
        String string2 = "";
        if (n == 1) {
            string2 = objectArray[1].toString();
            string = objectArray[2].toString();
        } else if (n == 3) {
            string2 = objectArray[0].toString();
            string = objectArray[1].toString();
        }
        String string3 = "";
        Vector vector = this.getNICsHostAddresses();
        if (vector.size() == 0) {
            throw new IOException();
        }
        InetAddress inetAddress = InetAddress.getByName(NEW_GROUP);
        boolean bl = false;
        int n2 = 0;
        while (n2 < vector.size() && !bl) {
            InetAddress inetAddress2 = (InetAddress)vector.elementAt(n2);
            MulticastSocket multicastSocket = this.sendPacket(string, inetAddress, inetAddress2, 54000);
            boolean bl2 = false;
            while (!bl2) {
                try {
                    byte[] byArray = new byte[200];
                    DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                    multicastSocket.receive(datagramPacket);
                    if (datagramPacket == null) continue;
                    string3 = new String(datagramPacket.getData());
                    string3 = string3.trim();
                    String string4 = "TrackerV2 network response " + string2;
                    String string5 = String.valueOf(string4) + " Ok";
                    if (string3.startsWith(string4)) {
                        datagramPacket = null;
                        bl2 = true;
                    }
                    if (!string3.equals(string5)) continue;
                    bl = true;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    bl2 = true;
                }
            }
            multicastSocket.leaveGroup(inetAddress);
            multicastSocket.close();
            if (bl) break;
            ++n2;
        }
        return new Object[]{new Boolean(bl), new String(string3)};
    }

    private MulticastSocket sendPacket(String string, InetAddress inetAddress, InetAddress inetAddress2, int n) throws IOException {
        MulticastSocket multicastSocket = new MulticastSocket(n);
        multicastSocket.setLoopbackMode(false);
        multicastSocket.setTimeToLive(32);
        multicastSocket.setInterface(inetAddress2);
        multicastSocket.joinGroup(inetAddress);
        DatagramPacket datagramPacket = new DatagramPacket(string.getBytes(), string.length(), inetAddress, n);
        multicastSocket.send(datagramPacket);
        multicastSocket.setSoTimeout(this.timeout);
        return multicastSocket;
    }

    public Vector[] findTrackers() throws Exception {
        FindTrackers findTrackers = new FindTrackers(this.debugWriter, false);
        long l = System.currentTimeMillis();
        try {
            Vector[] vectorArray = findTrackers.findTrackers();
            this.logLine("Time taken by findtrackers(secs): " + (System.currentTimeMillis() - l) / 1000L);
            return vectorArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    private void logLine(String string) {
        if (this.debugWriter != null) {
            this.debugWriter.println(string);
        }
    }

    private Vector[] findTrackerTest() throws Exception {
        Vector<Object[]> vector = new Vector<Object[]>();
        Object[] objectArray = new Object[6];
        objectArray[0] = "TrackerV2 network response 1606193 eth1 False True 172.20.81.75 255.255.0.0 None BC:34:00:B0:18:31 False False None ssid:VantageS-Tracker-WiFi_6193 wifi_state:down type:0 serial_type:111 enet1:1 sessions:1";
        objectArray[1] = "172.20.80.1";
        objectArray[2] = "255.255.252.0";
        objectArray[4] = "Wired_Broadcast_1";
        objectArray[5] = new Boolean(false);
        vector.add(objectArray);
        Object[] objectArray2 = new Object[6];
        objectArray2[0] = "TrackerV2 network response 1606193 wlan0 False True 169.254.1.1 255.255.0.0 None 7C:5C:F8:E9:5C:C8 True True None ssid:VantageS-Tracker-WiFi_6193 wifi_state:down type:0 serial_type:111 enet1:1 sessions:1";
        objectArray2[1] = "172.20.80.1";
        objectArray2[2] = "255.255.252.0";
        objectArray2[4] = "Wired_Broadcast_1";
        objectArray2[5] = new Boolean(false);
        vector.add(objectArray2);
        Object[] objectArray3 = new Object[6];
        objectArray3[0] = "TrackerV2 network response 1606187 eth1 False True 172.20.81.66 255.255.254.0 None BC:34:00:B0:18:2B False False None ssid:VantageS-Tracker-WiFi_6187 wifi_state:up type:0 serial_type:111 enet1:1 sessions:0";
        objectArray3[1] = "172.20.80.1";
        objectArray3[2] = "255.255.252.0";
        objectArray3[4] = "Wired_Broadcast_1";
        objectArray3[5] = new Boolean(false);
        vector.add(objectArray3);
        Object[] objectArray4 = new Object[6];
        objectArray4[0] = "TrackerV2 network response 1606187 wlan0 False True 169.254.1.1 255.255.0.0 None 14:AB:C5:5C:CD:5D True True None ssid:VantageS-Tracker-WiFi_6187 wifi_state:up type:0 serial_type:111 enet1:1 sessions:0";
        objectArray4[1] = "172.20.80.1";
        objectArray4[2] = "255.255.252.0";
        objectArray4[4] = "Wired_Broadcast_1";
        objectArray4[5] = new Boolean(false);
        vector.add(objectArray4);
        Object[] objectArray5 = new Object[6];
        objectArray5[0] = "TrackerV2 network response 1726776 eth1 False True 172.20.80.76 255.255.0.0 None BC:34:00:B0:1A:78 False False None ssid:VantageS-Tracker-WiFi_6776 wifi_state:up type:0 serial_type:78 enet1:1 sessions:1";
        objectArray5[1] = "172.20.80.1";
        objectArray5[2] = "255.255.252.0";
        objectArray5[4] = "Wired_Broadcast_1";
        objectArray5[5] = new Boolean(false);
        vector.add(objectArray5);
        Object[] objectArray6 = new Object[6];
        objectArray6[0] = "TrackerV2 network response 1726776 wlan0 False True 169.254.1.1 255.255.0.0 None 14:AB:C5:5C:D6:5E True True None ssid:VantageS-Tracker-WiFi_6776 wifi_state:up type:0 serial_type:78 enet1:1 sessions:1";
        objectArray6[1] = "172.20.80.1";
        objectArray6[2] = "255.255.252.0";
        objectArray6[4] = "Wired_Broadcast_1";
        objectArray6[5] = new Boolean(false);
        vector.add(objectArray6);
        Object[] objectArray7 = new Object[6];
        objectArray7[0] = "TrackerV2 network response 1606192 eth1 False True 172.20.81.67 255.255.0.0 None BC:34:00:B0:18:31 False False None ssid:VantageS-Tracker-WiFi_6192 wifi_state:up type:0 serial_type:111 enet1:0 sessions:1";
        objectArray7[1] = "172.20.80.1";
        objectArray7[2] = "255.255.252.0";
        objectArray7[4] = "Wired_Broadcast_1";
        objectArray7[5] = new Boolean(false);
        vector.add(objectArray7);
        Object[] objectArray8 = new Object[6];
        objectArray8[0] = "TrackerV2 network response 1606192 wlan0 False True 169.254.1.1 255.255.0.0 None 7C:5C:F8:E9:5C:C8 True True None ssid:VantageS-Tracker-WiFi_6192 wifi_state:up type:0 serial_type:111 enet1:0 sessions:1";
        objectArray8[1] = "172.20.80.1";
        objectArray8[2] = "255.255.252.0";
        objectArray8[4] = "Wired_Broadcast_1";
        objectArray8[5] = new Boolean(false);
        vector.add(objectArray8);
        Object[] objectArray9 = new Object[6];
        objectArray9[0] = "TrackerV2 network response 1607000 eth1 True True 172.20.81.254 255.255.0.0 None BC:34:00:B0:18:31 False False None ssid:VantageS-Tracker-WiFi_7000 wifi_state:up type:0 serial_type:111 enet1:1 sessions:1";
        objectArray9[1] = "172.20.80.1";
        objectArray9[2] = "255.255.252.0";
        objectArray9[4] = "Wired_Broadcast_1";
        objectArray9[5] = new Boolean(false);
        vector.add(objectArray9);
        Object[] objectArray10 = new Object[6];
        objectArray10[0] = "TrackerV2 network response 1607000 wlan0 False True 169.254.1.1 255.255.0.0 None 7C:5C:F8:E9:5C:C8 True True None ssid:VantageS-Tracker-WiFi_7000 wifi_state:up type:0 serial_type:111 enet1:1 sessions:1";
        objectArray10[1] = "172.20.80.1";
        objectArray10[2] = "255.255.252.0";
        objectArray10[4] = "Wired_Broadcast_1";
        objectArray10[5] = new Boolean(false);
        vector.add(objectArray10);
        Object[] objectArray11 = new Object[6];
        objectArray11[0] = "TrackerV2 network response 1607500 eth1 True True None None None BC:34:00:B0:18:31 False False None ssid:VantageS-Tracker-WiFi_7500 wifi_state:up type:0 serial_type:111 enet1:1 sessions:1";
        objectArray11[1] = "172.20.80.1";
        objectArray11[2] = "255.255.252.0";
        objectArray11[4] = "Wired_Broadcast_1";
        objectArray11[5] = new Boolean(false);
        vector.add(objectArray11);
        Object[] objectArray12 = new Object[6];
        objectArray12[0] = "TrackerV2 network response 1607500 wlan0 False True 169.254.1.1 255.255.0.0 None 7C:5C:F8:E9:5C:C8 True True None ssid:VantageS-Tracker-WiFi_7500 wifi_state:up type:0 serial_type:111 enet1:1 sessions:1";
        objectArray12[1] = "172.20.80.1";
        objectArray12[2] = "255.255.252.0";
        objectArray12[4] = "Wired_Broadcast_1";
        objectArray12[5] = new Boolean(false);
        vector.add(objectArray12);
        Object[] objectArray13 = new Object[6];
        objectArray13[0] = "TrackerV2 network response 1607325 eth1 False True 128.128.128.100 255.255.0.0 None BC:34:00:B0:18:31 False False None ssid:VantageS-Tracker-WiFi_7500 wifi_state:up type:0 serial_type:111 enet1:1 sessions:1";
        objectArray13[1] = "172.20.80.1";
        objectArray13[2] = "255.255.252.0";
        objectArray13[4] = "Wired_Broadcast_1";
        objectArray13[5] = new Boolean(false);
        vector.add(objectArray13);
        Object[] objectArray14 = new Object[6];
        objectArray14[0] = "TrackerV2 network response 1607325 wlan0 False True 169.254.1.1 255.255.0.0 None 7C:5C:F8:E9:5C:C8 True True None ssid:VantageS-Tracker-WiFi_7500 wifi_state:up type:0 serial_type:111 enet1:1 sessions:1";
        objectArray14[1] = "172.20.80.1";
        objectArray14[2] = "255.255.252.0";
        objectArray14[4] = "Wired_Broadcast_1";
        objectArray14[5] = new Boolean(false);
        vector.add(objectArray14);
        FindTrackers findTrackers = new FindTrackers(null, false);
        Vector<NetworkCardInfo> vector2 = null;
        try {
            vector2 = findTrackers.getNICsHostAddressesAndSubNets();
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
        }
        Vector<NetworkCardInfo> vector3 = new Vector<NetworkCardInfo>();
        int n = 0;
        while (n < vector2.size()) {
            NetworkCardInfo networkCardInfo = vector2.get(n);
            if (!networkCardInfo.getNetworkInterface().getDisplayName().startsWith("Npcap")) {
                vector3.add(networkCardInfo);
            }
            ++n;
        }
        Vector<TrkInfo> vector4 = findTrackers.getAllTrackerRecords(vector, vector3);
        return new Vector[]{vector4, vector3};
    }
}

