/*
 * Decompiled with CFR 0.152.
 */
package ipaddressutility;

import ipaddressutility.ChangeIPSettingsDlg;
import ipaddressutility.CypherInfo;
import ipaddressutility.DiagnoseDlg;
import ipaddressutility.HelperUtility;
import ipaddressutility.IPAddressUtilityThread;
import ipaddressutility.IPAddressUtilityVersionInfo;
import ipaddressutility.NetshUtility;
import ipaddressutility.NetworkCardInfo;
import ipaddressutility.PleaseWait;
import ipaddressutility.SafeResourceBundle;
import ipaddressutility.ThreadListener;
import ipaddressutility.TrackerTableData;
import ipaddressutility.TrackerTableModel;
import ipaddressutility.TrkInfo;
import ipaddressutility.VantageIonInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.image.ImageProducer;
import java.io.PrintWriter;
import java.net.NetworkInterface;
import java.net.URL;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.BreakIterator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TooManyListenersException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class IPAddressUtility
extends JFrame {
    static SafeResourceBundle res = SafeResourceBundle.getBundle("ipaddressutility.IPAddressUtilityRes", Locale.getDefault());
    JPanel mainPanel = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JPanel buttonPanel = new JPanel();
    JPanel listPanel = new JPanel();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    JLabel trackerLabel = new JLabel();
    TitledBorder titledBorder1;
    JButton findTrackerButton = new JButton();
    JScrollPane jListScrollPane = new JScrollPane();
    JLabel columnheader = new JLabel();
    JPanel statusPanel = new JPanel();
    GridBagLayout gridBagLayout4 = new GridBagLayout();
    JLabel statusBar = new JLabel();
    JPanel checkBoxPanel = new JPanel();
    GridBagLayout gridBagLayout5 = new GridBagLayout();
    JCheckBox checkBox = new JCheckBox();
    JButton ChangeIpAddress = new JButton();
    JButton Close = new JButton();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    private PleaseWait pleaseWaitDialog = null;
    private FindCmdComplete findCmdComplete = new FindCmdComplete();
    private IPAddressUtilityThread commandThread = null;
    boolean stopReceiving = false;
    private Vector dpVectorList = new Vector(1, 1);
    private JFrame frame = null;
    public int dataChangedIndex = -1;
    private String separator = " ";
    private static PrintWriter debugWriter;
    GridBagLayout gridBagLayout6 = new GridBagLayout();
    JLabel versionInfoLabel = new JLabel();
    Component component1 = Box.createHorizontalStrut(8);
    String wifiOnStr = "Wifi On";
    String wifiOffStr = "Wifi Off";
    JButton wirelessStateButton = new JButton();
    JPopupMenu popupMenu = new JPopupMenu();
    JMenuItem changeIPAddMenuItem = new JMenuItem();
    JMenuItem changeWirelessStateMenuItem = new JMenuItem();
    MenuPopupListener menuPopupListener = new MenuPopupListener();
    private JTable jTable;
    private JScrollPane jTableScrollPane = new JScrollPane();
    String[] columns;
    String[] rows;
    Object[][] data;
    String staticStr = "Static";
    String dynamicStr = "DHCP";
    ColoredTableCellRenderer coloredTableCellRenderer = new ColoredTableCellRenderer();
    ArrayList changedRows = new ArrayList(10);
    JMenuItem changeStaticMenuItem = new JMenuItem();
    private ChangeCmdComplete_New changeCmdComplete_New = new ChangeCmdComplete_New();
    HashMap<Integer, TrkInfo> trksFoundList = new HashMap(10);
    TableRowSorter<TrackerTableModel> sorter = null;
    String cypherWiredStr = "Wired";
    String cypherWifiStr = "Wifi";
    int itsRow = 0;
    int itsColumn = 0;
    int selectedRow = -1;
    Vector nicAddrsList = new Vector(10);
    private static final Hashtable<TextAttribute, Object> map;
    int exitCode = 0;
    private long startFindTime = 0L;
    String statusText = "";
    private final JPanel networkDetailsPanel = new JPanel();
    private final JPanel findNetworkInfoPanel = new JPanel();
    private final JButton findNetworkInfoButton = new JButton("Get Network Info");
    private final JTextArea textArea = new JTextArea();
    private final JPanel finNetworkInfoButtonPanel = new JPanel();
    private final Component horizontalStrut = Box.createHorizontalStrut(20);
    JScrollPane scrollPane = null;
    private final JPanel trkpanel = new JPanel();
    int totalTrksFound = 0;
    int reachableTrksFound = 0;
    JTable networkCardTable = new JTable();
    DefaultTableModel networkCardTableModel = new DefaultTableModel();
    HashMap<String, List<TrkInfo>> groupHashMap = new HashMap();
    TrackerTableModel trkTableModel = null;
    private final JButton diagnoseButton = new JButton();
    String notAvailable = "N/A";
    String yesString = "Yes";
    String noString = "No";
    private JComboBox comboBox;
    private static final int CONNECT_NONE = 0;
    private static final int CONNECT_AS_USER = 1;
    private static final int CONNECT_AS_FACTORY = 2;
    JMenuItem diagnoseMenuItem = new JMenuItem();
    JMenuItem connectAsUserMenuItem = new JMenuItem();
    JMenuItem connectAsFactoryMenuItem = new JMenuItem();

    static {
        map = new Hashtable();
    }

    public IPAddressUtility(JFrame jFrame, String string, boolean bl) {
        this.frame = jFrame;
        try {
            this.jbInit();
            this.pack();
            this.setSize(800, 600);
            this.setLocationRelativeTo(jFrame);
            this.setTitle(res.getString("IPAddressUtility"));
            this.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.commandThread = new IPAddressUtilityThread(debugWriter);
    }

    public IPAddressUtility() {
        this(null, "", false);
    }

    void jbInit() throws Exception {
        this.connectAsUserMenuItem.addActionListener(new PopupActionListener());
        this.connectAsFactoryMenuItem.addActionListener(new PopupActionListener());
        this.diagnoseMenuItem.addActionListener(new PopupActionListener());
        this.connectAsUserMenuItem.setActionCommand("Connect_As_User");
        this.connectAsFactoryMenuItem.setActionCommand("Connect_As_Factory");
        this.diagnoseMenuItem.setActionCommand("Show_Diagnose");
        this.connectAsUserMenuItem.setText(String.valueOf(res.getString("Connect_As_User")) + "...");
        this.connectAsFactoryMenuItem.setText(String.valueOf(res.getString("Connect_As_Factory")) + "...");
        this.diagnoseMenuItem.setText(String.valueOf(res.getString("Diagnose")) + "...");
        this.comboBox = new JComboBox<String>(new String[]{res.getString("Connect_As_User"), res.getString("Connect_As_Factory")});
        this.diagnoseButton.setText(String.valueOf(res.getString("Diagnose")) + "...");
        this.textArea.setToolTipText("It is advised to refresh your network list before getting the network information");
        this.textArea.setEditable(false);
        this.networkCardTable.setDefaultRenderer(Object.class, new NetworkCardTableCellRenderer());
        this.networkCardTable.setShowGrid(false);
        this.networkCardTableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.networkCardTableModel.addColumn("#");
        this.networkCardTableModel.addColumn(res.getString("Name"));
        this.networkCardTableModel.addColumn(res.getString("IP_Address"));
        this.networkCardTableModel.addColumn(res.getString("IP_Mask"));
        this.networkCardTable.setModel(this.networkCardTableModel);
        this.scrollPane = new JScrollPane(this.networkCardTable, 20, 30);
        this.trkTableModel = new TrackerTableModel();
        this.sorter = new TableRowSorter<TrackerTableModel>(this.trkTableModel);
        ArrayList<RowSorter.SortKey> arrayList = new ArrayList<RowSorter.SortKey>();
        arrayList.add(new RowSorter.SortKey(1, SortOrder.DESCENDING));
        this.sorter.setSortKeys(arrayList);
        this.changeIPAddMenuItem.addActionListener(new PopupActionListener());
        this.changeWirelessStateMenuItem.addActionListener(new PopupActionListener());
        this.changeStaticMenuItem.addActionListener(new PopupActionListener());
        this.wirelessStateButton.setEnabled(false);
        this.component1 = Box.createHorizontalStrut(8);
        URL uRL = this.getClass().getResource("/ipaddressutility/appsicon.gif");
        if (uRL != null) {
            this.setIconImage(this.createImage((ImageProducer)uRL.getContent()));
        }
        this.titledBorder1 = new TitledBorder(new EtchedBorder(1), res.getString("Available_Trackers"));
        this.mainPanel.setLayout(this.gridBagLayout1);
        this.buttonPanel.setLayout(this.gridBagLayout2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                IPAddressUtility.this.this_windowClosing(windowEvent);
            }

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                IPAddressUtility.this.findTrackerButton_actionPerformed(null);
            }
        });
        this.jListScrollPane.setPreferredSize(new Dimension(450, 175));
        this.jListScrollPane.setHorizontalScrollBarPolicy(31);
        this.jListScrollPane.setAutoscrolls(true);
        this.jListScrollPane.setBorder(BorderFactory.createEtchedBorder());
        this.ChangeIpAddress.setEnabled(false);
        this.ChangeIpAddress.setVisible(false);
        this.ChangeIpAddress.setMnemonic('I');
        this.ChangeIpAddress.setText(String.valueOf(res.getString("Change_IP_Address_Mask")) + "...");
        this.ChangeIpAddress.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IPAddressUtility.this.ChangeIpAddress_actionPerformed(actionEvent);
            }
        });
        this.Close.setMnemonic('C');
        this.Close.setText(res.getString("Close"));
        this.Close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IPAddressUtility.this.Close_actionPerformed(actionEvent);
            }
        });
        this.getContentPane().setLayout(this.gridBagLayout6);
        this.versionInfoLabel.setText("");
        this.wirelessStateButton.setVisible(false);
        this.wirelessStateButton.setText(res.getString("Turn_Wireless_On"));
        this.wirelessStateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IPAddressUtility.this.wirelessStateButton_New_actionPerformed(actionEvent);
            }
        });
        this.changeIPAddMenuItem.setText(String.valueOf(res.getString("Change_IP_Settings")) + "...");
        this.changeWirelessStateMenuItem.setText(res.getString("Turn_Wireless_On"));
        this.changeStaticMenuItem.setText(String.valueOf(res.getString("Static")) + "...");
        this.changeIPAddMenuItem.setActionCommand("Change_IP_Address");
        this.changeWirelessStateMenuItem.setActionCommand("Change_Wireless_State");
        this.changeStaticMenuItem.setActionCommand("Change_Ethernet_Config");
        this.mainPanel.add((Component)this.buttonPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(12, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.mainPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(12, 12, 12, 12), 0, 0));
        this.buttonPanel.add((Component)this.versionInfoLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.buttonPanel.add(this.component1, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        this.buttonPanel.add((Component)this.findTrackerButton, gridBagConstraints);
        this.findTrackerButton.setMnemonic('F');
        this.findTrackerButton.setText(res.getString("Find_Trackers"));
        this.findTrackerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IPAddressUtility.this.findTrackerButton_actionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add((Component)this.Close, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 5, 0));
        this.buttonPanel.add((Component)this.ChangeIpAddress, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.buttonPanel.add((Component)this.wirelessStateButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.popupMenu.add(this.changeIPAddMenuItem);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.changeWirelessStateMenuItem);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.changeStaticMenuItem);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.diagnoseMenuItem);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.connectAsUserMenuItem);
        this.popupMenu.add(this.connectAsFactoryMenuItem);
        this.columnheader.setText(res.getString("Serial_Number_IP_Address_Mask_WinXP"));
        String string = System.getProperty("os.name");
        if (string.equals("Windows 7") || string.equals("Windows Vista")) {
            this.columnheader.setText(res.getString("Serial_Number_IP_Address_Mask_Win7"));
        }
        this.jListScrollPane.setColumnHeaderView(this.columnheader);
        this.versionInfoLabel.setText(IPAddressUtilityVersionInfo.getVersionInfo());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.weighty = 0.2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        this.networkDetailsPanel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "PC Network Card Information", 4, 2, null, new Color(0, 0, 0)));
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.networkDetailsPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets = new Insets(5, 0, 5, 0);
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        this.networkDetailsPanel.add((Component)this.finNetworkInfoButtonPanel, gridBagConstraints3);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        this.finNetworkInfoButtonPanel.setLayout(gridBagLayout2);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 0;
        this.finNetworkInfoButtonPanel.add(this.horizontalStrut, gridBagConstraints4);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 2;
        gridBagConstraints5.gridy = 0;
        this.findNetworkInfoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = System.lineSeparator();
                String string2 = NetshUtility.getSSIDName();
                Object[] objectArray = NetshUtility.getAllWifiProfiles();
                Object[] objectArray2 = NetshUtility.getAllNetworkCardIPAddresses();
                String string3 = "SSID Name: Not Connected" + string;
                if (!string2.equals("")) {
                    string3 = "SSID Name: " + string2;
                }
                String string4 = "Network Profiles: " + string;
                int n = objectArray.length;
                if (n == 0) {
                    string4 = String.valueOf(string4) + "\tNone" + string;
                } else {
                    int n2 = 0;
                    while (n2 < n) {
                        string4 = String.valueOf(string4) + "\t" + objectArray[n2] + string;
                        ++n2;
                    }
                }
                String string5 = "Network Card IPaddresses: " + string;
                n = objectArray2.length;
                if (n == 0) {
                    string5 = String.valueOf(string5) + "\tNone" + string;
                } else {
                    int n3 = 0;
                    while (n3 < n) {
                        string5 = String.valueOf(string5) + "\t" + objectArray2[n3] + string;
                        ++n3;
                    }
                }
                IPAddressUtility.this.textArea.setText(String.valueOf(string3) + string + string4 + string + string5);
                IPAddressUtility.this.textArea.setCaretPosition(0);
            }
        });
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.weighty = 1.0;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.fill = 1;
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.gridy = 0;
        this.findNetworkInfoPanel.setBorder(new EtchedBorder(1, null, null));
        this.networkDetailsPanel.add((Component)this.findNetworkInfoPanel, gridBagConstraints6);
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        this.findNetworkInfoPanel.setLayout(gridBagLayout3);
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints7.weighty = 1.0;
        gridBagConstraints7.fill = 1;
        gridBagConstraints7.weightx = 1.0;
        gridBagConstraints7.gridx = 0;
        gridBagConstraints7.gridy = 0;
        this.findNetworkInfoPanel.add((Component)this.scrollPane, gridBagConstraints7);
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.weighty = 1.0;
        gridBagConstraints8.weightx = 1.0;
        gridBagConstraints8.fill = 1;
        gridBagConstraints8.gridx = 0;
        gridBagConstraints8.gridy = 0;
        this.trkpanel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Tracker Information", 4, 2, null, new Color(0, 0, 0)));
        this.mainPanel.add((Component)this.trkpanel, gridBagConstraints8);
        GridBagLayout gridBagLayout4 = new GridBagLayout();
        this.trkpanel.setLayout(gridBagLayout4);
        this.jTable = new JTable(){};
        this.jTable.setRowHeight(20);
        this.jTable.setDefaultRenderer(Object.class, this.coloredTableCellRenderer);
        this.jTable.setToolTipText(res.getString("Tool_Tip_Menu"));
        this.jTable.setModel(this.trkTableModel);
        this.jTable.setRowSelectionAllowed(true);
        this.jTable.setRowSorter(this.sorter);
        this.jTable.getColumnModel().getColumn(0).setMinWidth(0);
        this.jTable.getColumnModel().getColumn(0).setMaxWidth(0);
        this.jTable.getColumnModel().getColumn(0).setWidth(0);
        this.jTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                IPAddressUtility.this.jTable_mouseExited(mouseEvent);
            }
        });
        this.jTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                IPAddressUtility.this.jTable_mouseMoved(mouseEvent);
            }
        });
        this.jTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                IPAddressUtility.this.jTable_mouseClicked(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                IPAddressUtility.this.jTable_mouseReleased(mouseEvent);
            }
        });
        this.jTableScrollPane.setViewportView(this.jTable);
        this.jTable.setShowGrid(false);
        this.jTable.setRowSelectionAllowed(true);
        JTableHeader jTableHeader = this.jTable.getTableHeader();
        jTableHeader.setUpdateTableInRealTime(false);
        jTableHeader.setReorderingAllowed(false);
        TableCellRenderer tableCellRenderer = this.jTable.getTableHeader().getDefaultRenderer();
        JLabel jLabel = (JLabel)((Object)tableCellRenderer);
        jLabel.setHorizontalAlignment(0);
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints9.fill = 2;
        gridBagConstraints9.weightx = 1.0;
        gridBagConstraints9.gridx = 0;
        gridBagConstraints9.gridy = 2;
        this.trkpanel.add((Component)this.statusPanel, gridBagConstraints9);
        this.statusPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.statusPanel.setLayout(this.gridBagLayout4);
        this.statusBar.setText(res.getString("Ready"));
        this.statusPanel.add((Component)this.statusBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints10.weightx = 1.0;
        gridBagConstraints10.fill = 2;
        gridBagConstraints10.gridx = 0;
        gridBagConstraints10.gridy = 1;
        this.trkpanel.add((Component)this.checkBoxPanel, gridBagConstraints10);
        this.gridBagLayout5.columnWeights = new double[]{1.0, 0.0, 0.0};
        this.checkBoxPanel.setLayout(this.gridBagLayout5);
        this.checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    IPAddressUtility.this.fillTrackerList();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.checkBox.setText(res.getString("Match_the_IP_Address"));
        this.checkBox.setMnemonic('M');
        this.checkBox.setSelected(false);
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints11.gridx = 1;
        gridBagConstraints11.gridy = 0;
        this.diagnoseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IPAddressUtility.this.diagnose();
            }
        });
        this.checkBoxPanel.add((Component)this.diagnoseButton, gridBagConstraints11);
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints12.fill = 2;
        gridBagConstraints12.gridx = 2;
        gridBagConstraints12.gridy = 0;
        this.comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = IPAddressUtility.this.comboBox.getSelectedIndex();
                if (n == 0) {
                    IPAddressUtility.this.sendConnectInfoUtilities(1);
                } else if (n == 1) {
                    IPAddressUtility.this.sendConnectInfoUtilities(2);
                }
            }
        });
        this.checkBoxPanel.add((Component)this.comboBox, gridBagConstraints12);
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints13.fill = 1;
        gridBagConstraints13.weightx = 1.0;
        gridBagConstraints13.weighty = 1.0;
        gridBagConstraints13.gridx = 0;
        gridBagConstraints13.gridy = 0;
        this.trkpanel.add((Component)this.listPanel, gridBagConstraints13);
        this.listPanel.setLayout(this.gridBagLayout3);
        this.listPanel.setBorder(new EtchedBorder(1, null, null));
        this.trackerLabel.setLabelFor(this.jTable);
        this.trackerLabel.setText("<html>* To change settings, Select tracker(row) in the table. Double Click or Right Click to access menu to make the changes.<br>\r\nIf IP Address is bold and in GREEN color, tracker is reachable (Wired or Wifi).<br>\r\nIf IP Address is plain and in RED color, tracker is not reachable (Wired or Wifi).<br>\r\n</html>");
        this.listPanel.setEnabled(false);
        this.listPanel.add((Component)this.jTableScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.listPanel.add((Component)this.trackerLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 10, 0, 0), 0, 0));
    }

    void findTrackerButton_actionPerformed(ActionEvent actionEvent) {
        IPAddressUtility.logLine("-----------Find Trackers--------------");
        this.enableButtons(false);
        this.dpVectorList.clear();
        this.reachableTrksFound = 0;
        this.totalTrksFound = 0;
        this.commandThread.setCheckBoxSelection(this.checkBox.isSelected());
        this.pleaseWaitDialog = new PleaseWait(this.frame, res.getString("Please_Wait_Title"), res.getString("Please_Wait_Text"), true, true);
        this.startFindTime = System.currentTimeMillis();
        Object[] objectArray = new Object[]{new Integer(0)};
        this.doThreadTransaction(objectArray, this.findCmdComplete);
    }

    private void enableButtons(boolean bl) {
        if (bl) {
            long cfr_ignored_0 = (System.currentTimeMillis() - this.startFindTime) / 1000L;
            this.statusText = String.valueOf(res.getString("Num_Reachable_Trackers_Found")) + " - " + this.reachableTrksFound + " / " + this.totalTrksFound;
            this.statusBar.setText(this.statusText);
        } else {
            this.statusText = res.getString("Finding_Trackers");
            this.statusBar.setText(this.statusText);
        }
        this.findTrackerButton.setEnabled(bl);
        this.ChangeIpAddress.setEnabled(bl);
        this.checkBox.setEnabled(bl);
        this.Close.setEnabled(bl);
        this.wirelessStateButton.setEnabled(bl);
        if (this.totalTrksFound == 0) {
            this.comboBox.setEnabled(false);
            this.diagnoseButton.setEnabled(false);
            this.diagnoseMenuItem.setEnabled(false);
            this.connectAsUserMenuItem.setEnabled(false);
            this.connectAsFactoryMenuItem.setEnabled(false);
        } else {
            this.comboBox.setEnabled(bl);
            this.diagnoseButton.setEnabled(bl);
            this.diagnoseMenuItem.setEnabled(bl);
            this.connectAsUserMenuItem.setEnabled(bl);
            this.connectAsFactoryMenuItem.setEnabled(bl);
        }
    }

    public static void main(String[] stringArray) {
        try {
            System.setProperty("sun.java2d.noddraw", "true");
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            IPAddressUtility.logLine("");
            IPAddressUtility.logLine("----------------------------------------------------------------------------------------------");
            IPAddressUtility.logLine(new Date().toString());
            new IPAddressUtility(new JFrame(), res.getString("IPAddressUtility"), false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void this_windowClosing(WindowEvent windowEvent) {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = null;
        objectArray[0] = new Integer(5);
        objectArray2 = this.doThreadTransaction(objectArray);
        if (objectArray2[0] == null) {
            IPAddressUtility.logLine("Dispose");
            this.dispose();
        }
        if (debugWriter != null) {
            IPAddressUtility.logLine("Closing: " + this.exitCode);
            debugWriter.flush();
            debugWriter.close();
        }
        System.exit(this.exitCode);
    }

    public Object[] doThreadTransaction(Object[] objectArray) {
        return this.doThreadTransaction(objectArray, null);
    }

    public Object[] doThreadTransaction(Object[] objectArray, ThreadListener threadListener) {
        Object[] objectArray2 = null;
        this.commandThread.sendCommand(objectArray);
        if (threadListener != null) {
            try {
                this.commandThread.addThreadListener(threadListener);
            }
            catch (TooManyListenersException tooManyListenersException) {
                tooManyListenersException.printStackTrace();
            }
        } else {
            objectArray2 = this.commandThread.receiveResponse();
        }
        return objectArray2;
    }

    void ChangeIpAddress_actionPerformed(ActionEvent actionEvent) {
        this.changeIPAddress_New();
    }

    void Close_actionPerformed(ActionEvent actionEvent) {
        this.sendConnectInfoUtilities(0);
    }

    public void wirelessStateButton_New_actionPerformed(ActionEvent actionEvent) {
        this.jTable.getColumnCount();
        int n = this.jTable.getSelectedRow();
        TrackerTableModel trackerTableModel = (TrackerTableModel)this.jTable.getModel();
        int n2 = this.jTable.convertRowIndexToModel(n);
        TrackerTableData trackerTableData = trackerTableModel.getRow(n2);
        String string = trackerTableData.getSrNum();
        Object[] objectArray = new Object[1];
        int n3 = 0;
        if (trackerTableData.getWifiMode() == 1) {
            objectArray[0] = "Tracker VMCU " + string + " eth0";
            n3 = 2;
        } else if (trackerTableData.getWifiMode() == 2) {
            objectArray[0] = "Tracker VMCU " + string + " wlan0";
            n3 = 1;
        }
        Object[] objectArray2 = new Object[]{new Integer(2), objectArray};
        this.changeCmdComplete_New.setChangeType(2);
        this.changeCmdComplete_New.setSelectedRow(n);
        this.changeCmdComplete_New.setWifiState(n3);
        this.doThreadTransaction(objectArray2, this.changeCmdComplete_New);
        this.pleaseWaitDialog = new PleaseWait(this.frame, res.getString("Please_Wait_Title"), res.getString("Please_Wait_Change"), true, true);
    }

    private void changeEthernetConfigState() {
        Object object;
        this.jTable.getColumnCount();
        int n = this.jTable.getSelectedRow();
        TrackerTableModel trackerTableModel = (TrackerTableModel)this.jTable.getModel();
        int n2 = this.jTable.convertRowIndexToModel(n);
        TrackerTableData trackerTableData = trackerTableModel.getRow(n2);
        String string = trackerTableData.getSrNum();
        String string2 = trackerTableData.getWiredIpAddr();
        String string3 = trackerTableData.getWiredIpMask();
        String string4 = trackerTableData.getConfiguration();
        int n3 = trackerTableData.getStaticDynamicInfo();
        int n4 = -1;
        Object[] objectArray = new Object[2];
        objectArray[0] = string;
        if (n3 == 2) {
            object = new ChangeIPSettingsDlg(this, res.getString("Change_IP_Settings"), true, "", "", false, 0, false, "");
            if (((ChangeIPSettingsDlg)object).cancelled) {
                return;
            }
            string2 = ((ChangeIPSettingsDlg)object).getNewIpAddress();
            string3 = ((ChangeIPSettingsDlg)object).getNewIpMask();
            string2 = this.removeLeadingZeros(string2);
            string3 = this.removeLeadingZeros(string3);
            objectArray[1] = "TrackerV2 network command " + string + " set eth1 static " + string2 + this.separator + string3 + this.separator + "\n";
            n4 = 1;
            this.changeCmdComplete_New.setNewIpAddr(string2);
            this.changeCmdComplete_New.setNewIpMask(string3);
        } else if (n3 == 1) {
            objectArray[1] = "TrackerV2 network command " + string + " set eth1 dhcp" + "\n";
            n4 = 2;
        }
        object = new Object[]{new Integer(3), objectArray};
        this.changeCmdComplete_New.setChangeType(3);
        this.changeCmdComplete_New.setSelectedRow(n);
        this.changeCmdComplete_New.setStaticDynamicInfo(n4);
        this.changeCmdComplete_New.setConfiguration(string4);
        this.doThreadTransaction((Object[])object, this.changeCmdComplete_New);
        this.pleaseWaitDialog = new PleaseWait(this.frame, res.getString("Please_Wait_Title"), res.getString("Please_Wait_Change"), true, true);
    }

    public void jTable_mouseMoved(MouseEvent mouseEvent) {
        JTable jTable = (JTable)mouseEvent.getSource();
        this.itsRow = jTable.rowAtPoint(mouseEvent.getPoint());
        this.itsColumn = jTable.columnAtPoint(mouseEvent.getPoint());
        jTable.repaint();
    }

    public void jTable_mouseExited(MouseEvent mouseEvent) {
        JTable jTable = (JTable)mouseEvent.getSource();
        this.itsRow = -1;
        jTable.repaint();
    }

    public void jTable_mouseReleased(MouseEvent mouseEvent) {
        int n = this.jTable.rowAtPoint(mouseEvent.getPoint());
        if (n >= 0 && n < this.jTable.getRowCount()) {
            this.selectedRow = n;
            this.jTable.setRowSelectionInterval(n, n);
        } else {
            this.jTable.clearSelection();
        }
        if (mouseEvent.isPopupTrigger() && mouseEvent.getComponent() instanceof JTable) {
            this.showPopUpMenu(mouseEvent, n);
        }
    }

    private void showPopUpMenu(MouseEvent mouseEvent, int n) {
        this.jTable.getColumnCount();
        TrackerTableModel trackerTableModel = (TrackerTableModel)this.jTable.getModel();
        int n2 = this.jTable.convertRowIndexToModel(n);
        TrackerTableData trackerTableData = trackerTableModel.getRow(n2);
        int n3 = trackerTableData.getModelType();
        String string = trackerTableData.getConfiguration();
        this.changeIPAddMenuItem.setEnabled(true);
        this.changeWirelessStateMenuItem.setEnabled(false);
        this.changeStaticMenuItem.setEnabled(false);
        boolean bl = true;
        if (n3 == 1) {
            this.changeWirelessStateMenuItem.setEnabled(true);
            this.changeStaticMenuItem.setEnabled(false);
            if (string.equals(this.wifiOnStr)) {
                this.changeIPAddMenuItem.setEnabled(false);
                this.changeWirelessStateMenuItem.setText(res.getString("Turn_Wireless_Off"));
            } else if (string.equals(this.wifiOffStr)) {
                this.changeIPAddMenuItem.setEnabled(true);
                this.changeWirelessStateMenuItem.setText(res.getString("Turn_Wireless_On"));
            }
        }
        if (n3 == 2) {
            this.changeWirelessStateMenuItem.setEnabled(false);
            this.changeStaticMenuItem.setEnabled(true);
            if (string.startsWith(this.cypherWiredStr)) {
                this.changeIPAddMenuItem.setEnabled(false);
                this.changeStaticMenuItem.setText(String.valueOf(res.getString("Static")) + "...");
            } else {
                this.changeIPAddMenuItem.setEnabled(true);
                this.changeStaticMenuItem.setText(res.getString("DHCP"));
            }
        }
        if (bl) {
            this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void jTable_mouseClicked(MouseEvent mouseEvent) {
        int n;
        int n2 = this.jTable.rowAtPoint(mouseEvent.getPoint());
        if (n2 >= 0 && n2 < this.jTable.getRowCount()) {
            this.selectedRow = n2;
            this.jTable.setRowSelectionInterval(n2, n2);
            this.jTable.repaint();
        } else {
            this.jTable.clearSelection();
        }
        int n3 = this.jTable.getSelectedRow();
        if (n3 < 0) {
            return;
        }
        TrackerTableModel trackerTableModel = (TrackerTableModel)this.jTable.getModel();
        TrackerTableData trackerTableData = trackerTableModel.getRow(n = this.jTable.convertRowIndexToModel(n3));
        boolean bl = trackerTableData.isConfigurationChanged();
        this.diagnoseButton.setEnabled(!bl);
        this.comboBox.setEnabled(!bl);
        if (mouseEvent.isPopupTrigger()) {
            boolean cfr_ignored_0 = mouseEvent.getComponent() instanceof JTable;
        }
        if (mouseEvent.getClickCount() == 2 && mouseEvent.getComponent() instanceof JTable) {
            this.showPopUpMenu(mouseEvent, n2);
        }
    }

    private void changeIPAddress_New() {
        this.jTable.getColumnCount();
        int n = this.jTable.getSelectedRow();
        TrackerTableModel trackerTableModel = (TrackerTableModel)this.jTable.getModel();
        int n2 = this.jTable.convertRowIndexToModel(n);
        TrackerTableData trackerTableData = trackerTableModel.getRow(n2);
        int n3 = trackerTableData.getModelType();
        String string = trackerTableData.getSrNum();
        String string2 = trackerTableData.getWiredIpAddr();
        String string3 = trackerTableData.getWiredIpMask();
        ChangeIPSettingsDlg changeIPSettingsDlg = new ChangeIPSettingsDlg(this, res.getString("Change_IP_Settings"), true, string2, string3, false, -1, false, "");
        if (changeIPSettingsDlg.cancelled) {
            return;
        }
        String string4 = changeIPSettingsDlg.getNewIpAddress();
        String string5 = changeIPSettingsDlg.getNewIpMask();
        boolean bl = this.checkIfChanged(string2, string4);
        boolean bl2 = this.checkIfChanged(string3, string5);
        if (bl || bl2) {
            Object[] objectArray = new Object[3];
            objectArray[1] = string;
            long l = HelperUtility.StringToLong(string4);
            long l2 = HelperUtility.StringToLong(string5);
            if (n3 == 0 || n3 == 1) {
                objectArray[0] = "Tracker IP Resp";
                objectArray[2] = "Tracker IP Address Set" + this.separator + string + this.separator + l + this.separator + l2;
            } else if (n3 == 2) {
                objectArray[0] = "TrackerV2 network response";
                string4 = this.removeLeadingZeros(string4);
                string5 = this.removeLeadingZeros(string5);
                objectArray[2] = "TrackerV2 network command " + string + " set eth1 static " + string4 + this.separator + string5 + "\n";
            }
            Object[] objectArray2 = new Object[]{new Integer(1), objectArray};
            this.changeCmdComplete_New.setChangeType(1);
            this.changeCmdComplete_New.setSelectedRow(n);
            this.changeCmdComplete_New.setNewIpAddr(string4);
            this.changeCmdComplete_New.setNewIpMask(string5);
            this.doThreadTransaction(objectArray2, this.changeCmdComplete_New);
            this.pleaseWaitDialog = new PleaseWait(this.frame, res.getString("Please_Wait_Title"), res.getString("Please_Wait_Change"), true, true);
        }
    }

    private boolean checkIfChanged(String string, String string2) {
        String[] stringArray = string.split("\\.");
        String[] stringArray2 = string2.split("\\.");
        int n = 0;
        while (n < stringArray.length) {
            int n2;
            int n3 = Integer.parseInt(stringArray[n]);
            if (n3 != (n2 = Integer.parseInt(stringArray2[n]))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private String removeLeadingZeros(String string) {
        String[] stringArray = string.split("\\.");
        int n = stringArray.length;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = Integer.parseInt(stringArray[n2]);
            ++n2;
        }
        String string2 = String.valueOf(nArray[0]) + "." + nArray[1] + "." + nArray[2] + "." + nArray[3];
        return string2;
    }

    private void setNetworkCardInfoText(Vector<NetworkCardInfo> vector) {
        Object object;
        int n = vector.size();
        if (n == 0) {
            return;
        }
        String string = System.lineSeparator();
        String string2 = "IP Address/Subnet" + string;
        int n2 = 0;
        while (n2 < n) {
            NetworkCardInfo networkCardInfo = vector.get(n2);
            String string3 = networkCardInfo.getIPAddress().getHostAddress();
            object = networkCardInfo.getSubNet();
            string2 = String.valueOf(string2) + string3 + "/" + (String)object + string;
            ++n2;
        }
        this.textArea.setText(string2);
        this.textArea.setCaretPosition(0);
        n2 = this.networkCardTableModel.getRowCount();
        int n3 = n2 - 1;
        while (n3 >= 0) {
            this.networkCardTableModel.removeRow(n3);
            --n3;
        }
        Object[][] objectArray = new Object[n][4];
        int n4 = 0;
        while (n4 < n) {
            object = vector.get(n4);
            String string4 = ((NetworkCardInfo)object).getIPAddress().getHostAddress();
            String string5 = ((NetworkCardInfo)object).getSubNet();
            NetworkInterface networkInterface = ((NetworkCardInfo)object).getNetworkInterface();
            objectArray[n4][0] = String.valueOf(n4 + 1);
            objectArray[n4][1] = networkInterface.getDisplayName();
            objectArray[n4][2] = string4;
            objectArray[n4][3] = string5;
            this.networkCardTableModel.addRow(objectArray[n4]);
            ++n4;
        }
        TableColumn tableColumn = this.networkCardTable.getColumnModel().getColumn(0);
        tableColumn.setMinWidth(20);
        tableColumn.setMaxWidth(20);
        tableColumn.setPreferredWidth(20);
        tableColumn = this.networkCardTable.getColumnModel().getColumn(2);
        tableColumn.setMinWidth(200);
        tableColumn.setMaxWidth(200);
        tableColumn.setPreferredWidth(200);
        tableColumn = this.networkCardTable.getColumnModel().getColumn(3);
        tableColumn.setMinWidth(200);
        tableColumn.setMaxWidth(200);
        tableColumn.setPreferredWidth(200);
        ((DefaultTableCellRenderer)this.networkCardTable.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(0);
    }

    public Object[] checkIfTrackerIsReachable(TrkInfo trkInfo, Vector vector) {
        boolean bl = false;
        int n = 0;
        int n2 = vector.size();
        if (n2 == 0) {
            return new Object[]{bl, n};
        }
        int n3 = 0;
        while (n3 < n2) {
            NetworkCardInfo networkCardInfo = (NetworkCardInfo)vector.get(n3);
            String string = networkCardInfo.getIPAddress().getHostAddress();
            String string2 = networkCardInfo.getSubNet();
            if (!(string.equals(trkInfo.getNetworkCardIpAdd()) && string2.equals(trkInfo.getNetworkCardIpMask()) || !(bl = HelperUtility.checkIfIPaddressAreWithinSameSubnet(trkInfo, string, string2)))) {
                networkCardInfo.getNetworkInterface();
                n = n3;
                break;
            }
            ++n3;
        }
        return new Object[]{new Boolean(bl), new Integer(n)};
    }

    public boolean checkIfIPaddressAreWithinSameSubnet(TrkInfo trkInfo) {
        return HelperUtility.checkIfIPaddressAreWithinSameSubnet(trkInfo, trkInfo.getNetworkCardIpAdd(), trkInfo.getNetworkCardIpMask());
    }

    private String[] getNetworkIpAndMask(int n) {
        TrkInfo trkInfo = this.trksFoundList.get(new Integer(n));
        String string = "";
        String string2 = "";
        if (trkInfo instanceof VantageIonInfo) {
            VantageIonInfo vantageIonInfo = (VantageIonInfo)trkInfo;
            string = vantageIonInfo.getNetworkCardIpAdd();
            string2 = vantageIonInfo.getNetworkCardIpMask();
        } else if (trkInfo instanceof CypherInfo) {
            CypherInfo cypherInfo = (CypherInfo)trkInfo;
            string = cypherInfo.getNetworkCardIpAdd();
            string2 = cypherInfo.getNetworkCardIpMask();
        }
        return new String[]{string, string2};
    }

    private String getCypherSSID(String string, Object[] objectArray) {
        if (objectArray == null) {
            return "";
        }
        int n = objectArray.length;
        if (n == 0) {
            return "";
        }
        int n2 = string.length();
        int n3 = 1;
        if (n2 > 4) {
            n3 = n2 - 4;
        }
        int n4 = 0;
        while (n4 <= n3) {
            int n5 = n2 - (4 + n4);
            String string2 = string.substring(n5, n2);
            int n6 = 0;
            while (n6 < n) {
                String string3;
                String string4 = (String)objectArray[n6];
                if (string4.startsWith("Vantage") && string4.contains(string3 = string2)) {
                    return string4;
                }
                ++n6;
            }
            ++n4;
        }
        return "";
    }

    private void sendConnectInfoUtilities(int n) {
        this.jTable.getColumnCount();
        int n2 = this.jTable.getSelectedRow();
        this.exitCode = n;
        if (this.exitCode != 0) {
            int n3 = this.jTable.getRowCount();
            if (n3 == 0) {
                return;
            }
            if (n2 == -1) {
                if (n3 == 1) {
                    n2 = 0;
                } else {
                    JOptionPane.showMessageDialog(this.frame, "Invalid selection. Please select a tracker(row) in the table and then select \"Connect as User\" or \"Connect as Factory\"", res.getString("Information"), 1);
                    return;
                }
            }
            TrackerTableModel trackerTableModel = (TrackerTableModel)this.jTable.getModel();
            int n4 = this.jTable.convertRowIndexToModel(n2);
            TrackerTableData trackerTableData = trackerTableModel.getRow(n4);
            String string = trackerTableData.getSrNum();
            String string2 = trackerTableData.getWiredIpAddr();
            String string3 = "Wired";
            if (trackerTableData.isWifiIpReachable()) {
                string3 = "Wifi";
                string2 = trackerTableData.getWifiIpAddr();
            }
            if (!trackerTableData.isWiredIpReachable() && !trackerTableData.isWifiIpReachable()) {
                string2 = string;
            }
            System.out.println("Start\"" + string + "," + string2 + "," + string3 + "\"End");
            IPAddressUtility.logLine("Start\"" + string + "," + string2 + "," + string3 + "\"End");
        }
        this.this_windowClosing(null);
    }

    private static void logLine(String string) {
        if (debugWriter != null) {
            debugWriter.println(string);
        }
    }

    void getNetworkSettings() {
        NetshUtility.getSSIDName();
        String string = NetshUtility.getWiFiCardAdpaterName();
        NetshUtility.getWiFiCardIPAddress(string);
    }

    /*
     * WARNING - void declaration
     */
    private void fillTrackerList() throws Exception {
        void entry;
        this.checkBox.isSelected();
        if (this.trkTableModel != null) {
            this.trkTableModel.removeAllRows();
        }
        this.changedRows.clear();
        this.trksFoundList.clear();
        int n = 0;
        while (n < this.dpVectorList.size()) {
            TrkInfo trkInfo = (TrkInfo)this.dpVectorList.elementAt(n);
            this.trksFoundList.put(new Integer(n + 1), trkInfo);
            ++n;
        }
        HashMap<TrkInfo, String> hashMap = new HashMap<TrkInfo, String>();
        boolean n2 = false;
        while (entry < this.dpVectorList.size()) {
            TrkInfo trkInfo = (TrkInfo)this.dpVectorList.elementAt((int)entry);
            hashMap.put(trkInfo, trkInfo.getSrNum());
            ++entry;
        }
        this.groupHashMap = new HashMap();
        for (Map.Entry n3 : hashMap.entrySet()) {
            List<TrkInfo> list = new ArrayList();
            if (this.groupHashMap.containsKey(n3.getValue())) {
                list = this.groupHashMap.get(n3.getValue());
            }
            list.add((TrkInfo)n3.getKey());
            this.groupHashMap.put((String)n3.getValue(), list);
        }
        this.totalTrksFound = this.groupHashMap.size();
        this.reachableTrksFound = 0;
        boolean bl = false;
        for (Map.Entry entry2 : this.groupHashMap.entrySet()) {
            void var2_8;
            boolean bl2;
            List list = (List)entry2.getValue();
            if (list.size() <= 0) continue;
            String string = this.notAvailable;
            String string2 = this.notAvailable;
            String string3 = this.notAvailable;
            String string4 = this.notAvailable;
            String string5 = this.notAvailable;
            String string6 = this.notAvailable;
            String string7 = "";
            String string8 = "";
            TrkInfo trkInfo = (TrkInfo)list.get(0);
            int n3 = trkInfo.getModelType();
            int n4 = -1;
            int n5 = -1;
            Object[] objectArray = this.getCypherMergeInfo(list, TrkInfo.CYPHER_WIRED_PACKET);
            Object[] objectArray2 = this.getCypherMergeInfo(list, TrkInfo.CYPHER_WIFI_PACKET);
            Object[] objectArray3 = this.getVantageIonMergeInfo(list, TrkInfo.LEGACY_PACKET);
            if (objectArray != null) {
                string = (String)objectArray[0];
                string2 = (String)objectArray[1];
                string3 = (String)objectArray[2];
                string7 = (String)objectArray[3];
                n4 = (Integer)objectArray[4];
            }
            if (objectArray2 != null) {
                string4 = (String)objectArray2[0];
                string5 = (String)objectArray2[1];
                string6 = (String)objectArray2[2];
                string8 = (String)objectArray2[3];
                if (!string8.equals("")) {
                    if (!string7.endsWith("")) {
                        string7 = String.valueOf(string7) + " ";
                    }
                    string7 = String.valueOf(string7) + string8;
                }
            }
            if (objectArray3 != null) {
                string = (String)objectArray3[0];
                string2 = (String)objectArray3[1];
                string3 = (String)objectArray3[2];
                string4 = (String)objectArray3[3];
                string5 = (String)objectArray3[4];
                string6 = (String)objectArray3[5];
                string7 = (String)objectArray3[6];
                n5 = (Integer)objectArray3[7];
            }
            boolean bl3 = string3.equals("Yes");
            boolean bl4 = bl2 = string6.equals("Yes");
            if (bl3 || bl2) {
                ++this.reachableTrksFound;
            }
            this.trkTableModel.addRow(new TrackerTableData((int)(var2_8 + true), trkInfo.getSrNum(), string, string2, string4, string5, bl3, bl2, n3, string7, n4, n5));
            ++var2_8;
        }
    }

    private Object[] getCypherMergeInfo(List<TrkInfo> list, int n) {
        String string = this.notAvailable;
        String string2 = this.notAvailable;
        String string3 = this.notAvailable;
        int n2 = 1;
        String string4 = "";
        int n3 = 0;
        while (n3 < list.size()) {
            TrkInfo trkInfo = list.get(n3);
            if (trkInfo.getPacketType() == n) {
                CypherInfo cypherInfo;
                int n4 = ((CypherInfo)trkInfo).isReachable();
                if (n4 == TrkInfo.REACHABLE_NO) {
                    string3 = this.noString;
                } else if (n4 == TrkInfo.REACHABLE_YES) {
                    string3 = this.yesString;
                }
                string = trkInfo.getIpAdd();
                string2 = trkInfo.getIpMask();
                if (trkInfo.getPacketType() == TrkInfo.CYPHER_WIRED_PACKET && (cypherInfo = (CypherInfo)trkInfo).getStaticDynamicInfo() == 2) {
                    n2 = 2;
                    string4 = "Wired-DHCP";
                }
                return new Object[]{string, string2, string3, string4, n2};
            }
            ++n3;
        }
        return null;
    }

    private Object[] getVantageIonMergeInfo(List<TrkInfo> list, int n) {
        String string = this.notAvailable;
        String string2 = this.notAvailable;
        String string3 = this.notAvailable;
        String string4 = this.notAvailable;
        String string5 = this.notAvailable;
        String string6 = this.notAvailable;
        String string7 = "";
        int n2 = 0;
        while (n2 < list.size()) {
            TrkInfo trkInfo = list.get(n2);
            if (trkInfo.getPacketType() == TrkInfo.LEGACY_PACKET) {
                string = trkInfo.getIpAdd();
                string2 = trkInfo.getIpMask();
                VantageIonInfo vantageIonInfo = (VantageIonInfo)trkInfo;
                int n3 = vantageIonInfo.isWiredReachable();
                String string8 = this.notAvailable;
                if (n3 == TrkInfo.REACHABLE_NO) {
                    string8 = this.noString;
                } else if (n3 == TrkInfo.REACHABLE_YES) {
                    string8 = this.yesString;
                }
                string3 = string8;
                if (vantageIonInfo.getModelType() == 1) {
                    n3 = vantageIonInfo.isWifiReachable();
                    string8 = this.notAvailable;
                    if (n3 == TrkInfo.REACHABLE_NO) {
                        string8 = this.noString;
                    } else if (n3 == TrkInfo.REACHABLE_YES) {
                        string8 = this.yesString;
                    }
                    string6 = string8;
                    string7 = vantageIonInfo.getWifiMode() == 1 ? this.wifiOnStr : this.wifiOffStr;
                    string4 = vantageIonInfo.getWifiIp();
                    string5 = trkInfo.getIpMask();
                }
                return new Object[]{string, string2, string3, string4, string5, string6, string7, vantageIonInfo.getWifiMode()};
            }
            ++n2;
        }
        return null;
    }

    private void diagnose() {
        this.jTable.getColumnCount();
        int n = this.jTable.getSelectedRow();
        int n2 = this.jTable.getRowCount();
        if (n2 == 0) {
            return;
        }
        if (n == -1) {
            if (n2 == 1) {
                n = 0;
            } else {
                JOptionPane.showMessageDialog(this.frame, "Invalid selection. Please select a tracker(row) in the table and press the \"Diagnose\" button.", res.getString("Information"), 1);
                return;
            }
        }
        TrackerTableModel trackerTableModel = (TrackerTableModel)this.jTable.getModel();
        int n3 = this.jTable.convertRowIndexToModel(n);
        TrackerTableData trackerTableData = trackerTableModel.getRow(n3);
        String string = trackerTableData.getSrNum();
        List<TrkInfo> list = this.groupHashMap.get(string);
        int n4 = list.size();
        String string2 = "";
        String string3 = "";
        int n5 = 0;
        while (n5 < n4) {
            TrkInfo trkInfo;
            TrkInfo trkInfo2 = list.get(n5);
            if (trkInfo2 instanceof VantageIonInfo) {
                trkInfo = (VantageIonInfo)trkInfo2;
                string2 = String.valueOf(string2) + "Wired: " + ((VantageIonInfo)trkInfo).getWiredReachableDetails() + "\n";
                string3 = String.valueOf(string3) + "Wired: " + ((VantageIonInfo)trkInfo).getWiredReachableRecommendation() + "\n";
                if (((VantageIonInfo)trkInfo).getWifiMode() != 0) {
                    string2 = String.valueOf(string2) + "Wifi: " + ((VantageIonInfo)trkInfo).getWifiReachableDetails() + "\n";
                    string3 = String.valueOf(string3) + "Wifi: " + ((VantageIonInfo)trkInfo).getWifiReachableRecommendation() + "\n";
                }
            } else {
                trkInfo = (CypherInfo)trkInfo2;
                if (trkInfo.getConnectionType() == 0) {
                    string2 = String.valueOf(string2) + "Wired: ";
                    string3 = String.valueOf(string3) + "Wired: ";
                } else if (trkInfo.getConnectionType() == 1) {
                    string2 = String.valueOf(string2) + "Wifi: ";
                    string3 = String.valueOf(string3) + "Wifi: ";
                }
                string2 = String.valueOf(string2) + ((CypherInfo)trkInfo).getReachableDetails() + "\n";
                string3 = String.valueOf(string3) + ((CypherInfo)trkInfo).getReachableRecommendation() + "\n";
            }
            ++n5;
        }
        new DiagnoseDlg(this, string, true, string2, string3, this.nicAddrsList);
    }

    private class ChangeCmdComplete_New
    implements ThreadListener,
    Runnable {
        Object[] respData = null;
        Object[] rowData = null;
        int cmdType = -1;
        int wifiState = 0;
        private int selRow = -1;
        private int staticDynamicInfo = -1;
        TrackerTableData trkData = null;
        private String newIpAddr = "";
        private String newIpMask = "";
        private String configure = "";

        private ChangeCmdComplete_New() {
        }

        @Override
        public void commandComplete() {
            IPAddressUtility.this.commandThread.removeThreadListener(IPAddressUtility.this.changeCmdComplete_New);
            this.respData = IPAddressUtility.this.commandThread.receiveResponse();
            SwingUtilities.invokeLater(this);
        }

        public void setChangeType(int n) {
            this.cmdType = n;
        }

        public void setNewIpAddr(String string) {
            this.newIpAddr = string;
        }

        public void setNewIpMask(String string) {
            this.newIpMask = string;
        }

        public void setWifiState(int n) {
            this.wifiState = n;
        }

        public void setSelectedRow(int n) {
            this.selRow = n;
        }

        public void setStaticDynamicInfo(int n) {
            this.staticDynamicInfo = n;
        }

        public void setConfiguration(String string) {
            this.configure = string;
        }

        @Override
        public void run() {
            IPAddressUtility.this.pleaseWaitDialog.dispose();
            IPAddressUtility.this.pleaseWaitDialog = null;
            if (this.respData[0] != null) {
                JOptionPane.showMessageDialog(IPAddressUtility.this.frame, res.getString("Communications_Failure"), res.getString("Error"), 0);
            } else {
                Object[] objectArray = (Object[])this.respData[1];
                boolean bl = (Boolean)objectArray[0];
                String string = (String)objectArray[1];
                if (!bl) {
                    String string2;
                    String string3 = res.getString("Change_Fail");
                    if (this.cmdType == 3 && string.contains(string2 = "Invalid gateway")) {
                        String string4 = string3;
                        string3 = string2 + "\n" + string4;
                    }
                    JOptionPane.showMessageDialog(IPAddressUtility.this.frame, string3, res.getString("Error"), 0);
                    return;
                }
                String string5 = res.getString("Reboot_Tracker_New");
                TrackerTableModel trackerTableModel = (TrackerTableModel)IPAddressUtility.this.jTable.getModel();
                int n = IPAddressUtility.this.jTable.convertRowIndexToModel(this.selRow);
                this.trkData = trackerTableModel.getRow(n);
                if (this.cmdType == 1) {
                    this.trkData.setWiredIpAddr(this.newIpAddr);
                    this.trkData.setWiredIpMask(this.newIpMask);
                    this.trkData.setWiredIpReachable(false);
                } else if (this.cmdType == 2) {
                    string5 = res.getString("Reboot_Tracker_Wireless_Off");
                    if (this.wifiState == 1) {
                        MessageFormat messageFormat = new MessageFormat(res.getString("Reboot_Tracker_Wireless_On"));
                        Object[] objectArray2 = new Object[]{string.trim()};
                        string5 = messageFormat.format(objectArray2);
                        this.trkData.setConfiguration(IPAddressUtility.this.wifiOnStr);
                        this.trkData.setWifiMode(this.wifiState);
                    } else if (this.wifiState == 2) {
                        this.trkData.setWifiIpReachable(false);
                        this.trkData.setConfiguration(IPAddressUtility.this.wifiOffStr);
                        this.trkData.setWifiMode(this.wifiState);
                    }
                } else if (this.cmdType == 3) {
                    if (this.staticDynamicInfo == 1) {
                        this.trkData.setWiredIpAddr(this.newIpAddr);
                        this.trkData.setWiredIpMask(this.newIpMask);
                        this.trkData.setWiredIpReachable(false);
                        this.trkData.setConfiguration("");
                    } else if (this.staticDynamicInfo == 2) {
                        this.trkData.setConfiguration("Wired-DHCP");
                    }
                    this.trkData.setStaticDynamicInfo(this.staticDynamicInfo);
                }
                int n2 = IPAddressUtility.this.jTable.convertRowIndexToModel(this.selRow);
                this.trkData.setConfigurationChanged(true);
                trackerTableModel.setRow(this.trkData, n2);
                IPAddressUtility.this.diagnoseButton.setEnabled(false);
                IPAddressUtility.this.comboBox.setEnabled(false);
                JOptionPane.showMessageDialog(IPAddressUtility.this.frame, string5, res.getString("Information"), 1);
            }
        }
    }

    class ColoredTableCellRenderer
    extends DefaultTableCellRenderer {
        JLabel lbl = new JLabel();

        ColoredTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            TrackerTableData trackerTableData;
            int n3;
            TrackerTableModel trackerTableModel;
            Font font;
            Font font2 = font = jTable.getFont();
            super.setForeground(jTable.getForeground());
            if (n % 2 == 1) {
                super.setBackground(new Color(235, 235, 235));
            } else {
                super.setBackground(jTable.getBackground());
            }
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
            }
            if (n2 == 2) {
                trackerTableModel = (TrackerTableModel)jTable.getModel();
                trackerTableData = trackerTableModel.getRow(n3 = jTable.convertRowIndexToModel(n));
                if (trackerTableData == null) {
                    return this;
                }
                if (trackerTableData.isWiredIpReachable()) {
                    font2 = new Font(font.getName(), 1, font.getSize() + 1);
                    super.setBackground(new Color(102, 255, 178));
                } else if (!trackerTableData.getWiredIpAddr().equals(IPAddressUtility.this.notAvailable)) {
                    super.setBackground(new Color(255, 102, 102));
                }
            }
            if (n2 == 4) {
                trackerTableModel = (TrackerTableModel)jTable.getModel();
                trackerTableData = trackerTableModel.getRow(n3 = jTable.convertRowIndexToModel(n));
                if (trackerTableData == null) {
                    return this;
                }
                if (trackerTableData.isWifiIpReachable()) {
                    font2 = new Font(font.getName(), 1, font.getSize() + 1);
                    super.setBackground(new Color(102, 255, 178));
                } else if (!trackerTableData.getWifiIpAddr().equals(IPAddressUtility.this.notAvailable)) {
                    super.setBackground(new Color(255, 102, 102));
                }
            }
            if ((trackerTableData = (trackerTableModel = (TrackerTableModel)jTable.getModel()).getRow(n3 = jTable.convertRowIndexToModel(n))) != null && trackerTableData.isConfigurationChanged()) {
                font2 = new Font(font.getName(), 3, font.getSize());
                super.setBackground(Color.LIGHT_GRAY);
            }
            this.setFont(font2);
            this.setOpaque(true);
            this.setText((String)object);
            this.setHorizontalAlignment(0);
            return this;
        }
    }

    private class FindCmdComplete
    implements ThreadListener,
    Runnable {
        Object[] respData = null;

        private FindCmdComplete() {
        }

        @Override
        public void commandComplete() {
            IPAddressUtility.this.commandThread.removeThreadListener(IPAddressUtility.this.findCmdComplete);
            this.respData = IPAddressUtility.this.commandThread.receiveResponse();
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void run() {
            if (this.respData[0] != null) {
                IPAddressUtility.this.pleaseWaitDialog.dispose();
                JOptionPane.showMessageDialog(IPAddressUtility.this.frame, res.getString("Communications_Failure"), res.getString("Error"), 0);
            } else {
                Vector[] vectorArray = (Vector[])this.respData[1];
                IPAddressUtility.this.dpVectorList = vectorArray[0];
                IPAddressUtility.this.nicAddrsList = vectorArray[1];
                if (IPAddressUtility.this.dpVectorList.size() <= 0) {
                    IPAddressUtility.this.pleaseWaitDialog.dispose();
                    if (IPAddressUtility.this.trkTableModel != null) {
                        IPAddressUtility.this.trkTableModel.removeAllRows();
                    }
                    JOptionPane.showMessageDialog(IPAddressUtility.this.frame, "Could not find any trackers.\n Please check the network connections and ethernet configurations and retry ", "Error", 0);
                } else {
                    IPAddressUtility.this.pleaseWaitDialog.updateMessage("Please wait while finding if trackers are reachable");
                    System.currentTimeMillis();
                    try {
                        IPAddressUtility.this.fillTrackerList();
                    }
                    catch (Exception exception) {
                        IPAddressUtility.this.pleaseWaitDialog.dispose();
                        exception.printStackTrace();
                        JOptionPane.showMessageDialog(IPAddressUtility.this.frame, String.valueOf(res.getString("Failed_To_Fill_List")) + "\n" + exception.toString(), res.getString("Error"), 0);
                        return;
                    }
                    IPAddressUtility.this.pleaseWaitDialog.dispose();
                    IPAddressUtility.this.pleaseWaitDialog = null;
                    if (IPAddressUtility.this.checkBox.isSelected() && IPAddressUtility.this.reachableTrksFound == 0) {
                        JOptionPane.showMessageDialog(IPAddressUtility.this.frame, res.getString("Reachable_Trackers_Not_Found"), res.getString("Error"), 0);
                    }
                }
            }
            IPAddressUtility.this.enableButtons(true);
        }
    }

    class MenuPopupListener
    extends MouseAdapter {
        MenuPopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (!SwingUtilities.isRightMouseButton(mouseEvent)) {
                return;
            }
            IPAddressUtility.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    class MultilineTableCell
    implements TableCellRenderer {
        MultilineTableCell() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            CellArea cellArea = new CellArea(object.toString(), jTable, n, n2, bl);
            return cellArea;
        }

        class CellArea
        extends DefaultTableCellRenderer {
            private static final long serialVersionUID = 1L;
            private String text;
            protected int rowIndex;
            protected int columnIndex;
            protected JTable table;
            protected Font font;
            private int paragraphStart;
            private int paragraphEnd;
            private LineBreakMeasurer lineMeasurer;
            public Font boldFont = null;
            public Font defaultFont = null;

            public CellArea(String string, JTable jTable, int n, int n2, boolean bl) {
                this.text = string;
                this.rowIndex = n;
                this.columnIndex = n2;
                this.table = jTable;
                this.font = this.table.getFont();
                this.setHorizontalAlignment(0);
                this.setVerticalAlignment(0);
                this.setHorizontalTextPosition(0);
                this.setVerticalTextPosition(0);
                this.defaultFont = this.table.getFont();
                this.boldFont = new Font(this.defaultFont.getName(), 3, this.defaultFont.getSize());
                if (bl) {
                    this.setForeground(this.table.getSelectionForeground());
                    this.setBackground(this.table.getSelectionBackground());
                } else {
                    this.setForeground(this.table.getForeground());
                    if (n % 2 == 1) {
                        this.setBackground(new Color(235, 235, 235));
                    } else {
                        this.setBackground(this.table.getBackground());
                    }
                    if (n2 == 1) {
                        int n3;
                        TableModel tableModel = this.table.getModel();
                        String string2 = (String)tableModel.getValueAt(n3 = this.table.convertRowIndexToModel(n), 5);
                        if (string2.equals("Yes")) {
                            super.setBackground(new Color(102, 255, 178));
                        } else if (string2.equals("No")) {
                            super.setBackground(new Color(255, 102, 102));
                        }
                    }
                    if (n2 == 5) {
                        if (this.text.equals("Yes")) {
                            super.setBackground(new Color(102, 255, 178));
                        } else if (this.text.equals("No")) {
                            super.setBackground(new Color(255, 102, 102));
                        }
                    }
                }
            }

            @Override
            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                if (this.text != null && !this.text.isEmpty()) {
                    Object object;
                    map.put(TextAttribute.FONT, this.defaultFont);
                    int n = ((MultilineTableCell)MultilineTableCell.this).IPAddressUtility.this.changedRows.size();
                    String string = IPAddressUtility.this.jTable.getValueAt(this.rowIndex, 0).toString();
                    int n2 = 0;
                    while (n2 < n) {
                        object = (String)((MultilineTableCell)MultilineTableCell.this).IPAddressUtility.this.changedRows.get(n2);
                        if (string.equals(object)) {
                            map.remove(TextAttribute.FONT);
                            map.put(TextAttribute.FONT, this.boldFont);
                            break;
                        }
                        ++n2;
                    }
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    if (this.lineMeasurer == null) {
                        object = new AttributedString(this.text, map).getIterator();
                        this.paragraphStart = object.getBeginIndex();
                        this.paragraphEnd = object.getEndIndex();
                        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
                        this.lineMeasurer = new LineBreakMeasurer((AttributedCharacterIterator)object, BreakIterator.getWordInstance(), fontRenderContext);
                    }
                    float f = this.table.getColumnModel().getColumn(this.columnIndex).getWidth();
                    float f2 = 0.0f;
                    this.lineMeasurer.setPosition(this.paragraphStart);
                    while (this.lineMeasurer.getPosition() < this.paragraphEnd) {
                        TextLayout textLayout = this.lineMeasurer.nextLayout(f);
                        float f3 = textLayout.isLeftToRight() ? 0.0f : f - textLayout.getAdvance();
                        textLayout.draw(graphics2D, f3, f2 += textLayout.getAscent());
                        f2 += textLayout.getDescent() + textLayout.getLeading();
                    }
                    this.table.setRowHeight(this.rowIndex, (int)f2);
                }
            }
        }
    }

    class NetworkCardTableCellRenderer
    extends DefaultTableCellRenderer {
        NetworkCardTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.setForeground(jTable.getForeground());
            if (n % 2 == 1) {
                super.setBackground(new Color(235, 235, 235));
            } else {
                super.setBackground(jTable.getBackground());
            }
            Font font = jTable.getFont();
            this.setFont(font);
            this.setOpaque(true);
            this.setText((String)object);
            this.setHorizontalAlignment(0);
            return this;
        }
    }

    class PopupActionListener
    implements ActionListener {
        PopupActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Change_IP_Address")) {
                IPAddressUtility.this.ChangeIpAddress_actionPerformed(null);
            } else if (string.equals("Change_Wireless_State")) {
                IPAddressUtility.this.wirelessStateButton_New_actionPerformed(null);
            } else if (string.equals("Change_Ethernet_Config")) {
                IPAddressUtility.this.changeEthernetConfigState();
            } else if (string.equals("Connect_As_User")) {
                IPAddressUtility.this.sendConnectInfoUtilities(1);
            } else if (string.equals("Connect_As_Factory")) {
                IPAddressUtility.this.sendConnectInfoUtilities(2);
            } else if (string.equals("Show_Diagnose")) {
                IPAddressUtility.this.diagnose();
            }
        }
    }
}

