/*
 * Decompiled with CFR 0.152.
 */
package ipaddressutility;

import ipaddressutility.CypherInfo;
import ipaddressutility.HelperUtility;
import ipaddressutility.NetworkCardInfo;
import ipaddressutility.TrackerReachable;
import ipaddressutility.TrkInfo;
import ipaddressutility.VantageIonInfo;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.DatagramPacket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class FindTrackers {
    public static final int PACKET_LENGTH = 300;
    public static final int TIMEOUT = 1000;
    public static final int PORT = 4000;
    public static final int MULTICAST_TTL = 32;
    public static final int OLD_PORT = 4000;
    public static final String OLD_GROUP = "224.0.0.40";
    public static final int NEW_PORT = 54000;
    public static final String NEW_GROUP = "239.0.0.40";
    protected static final String OLD_RESP = "Tracker IP Resp";
    protected static final String NEW_RESP = "TrackerV2 network response";
    public static String LEGACY_BROADCAST_NAME = "Legacy_Broadcast";
    public static String WIRED_BROADCAST_NAME = "Wired_Broadcast";
    public static String WIFI_BROADCAST_NAME = "WiFi_Broadcast";
    private Vector<Object[]> trkVectorList = new Vector(10);
    private PrintWriter debugWriter = null;
    private boolean findReachableTrks = true;
    Vector<NetworkCardInfo> networkCardsList = new Vector(10);
    private int THREAD_TIMEOUT = 10;
    public static final int WIRELESS = 1;

    public FindTrackers(PrintWriter printWriter) {
        this(printWriter, true);
    }

    public FindTrackers(PrintWriter printWriter, boolean bl) {
        this.debugWriter = printWriter;
        this.findReachableTrks = bl;
    }

    public static void main(String[] stringArray) {
        try {
            FindTrackers findTrackers = new FindTrackers(null, false);
            System.currentTimeMillis();
            findTrackers.findTrackers();
            System.currentTimeMillis();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Vector[] findTrackers() throws Exception {
        long l;
        Vector<NetworkCardInfo> vector;
        block4: {
            this.trkVectorList.clear();
            this.networkCardsList.clear();
            vector = this.getNICsHostAddressesAndSubNets();
            int n = vector.size();
            if (n == 0) {
                throw new IOException();
            }
            this.logLine("NUm Cards: " + n);
            int n2 = 3;
            int n3 = n2 * n;
            final CountDownLatch countDownLatch = new CountDownLatch(n3);
            l = System.currentTimeMillis();
            ExecutorService executorService = Executors.newFixedThreadPool(n2);
            executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        String string = "Tracker IP Address Identification";
                        InetAddress inetAddress = InetAddress.getByName(FindTrackers.OLD_GROUP);
                        FindTrackers.this.findTrackersThreads(string, inetAddress, 4000, vector, "", LEGACY_BROADCAST_NAME, countDownLatch);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            });
            executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        String string = "TrackerV2 network command all get eth1";
                        InetAddress inetAddress = InetAddress.getByName(FindTrackers.NEW_GROUP);
                        FindTrackers.this.findTrackersThreads(string, inetAddress, 54000, vector, "", WIRED_BROADCAST_NAME, countDownLatch);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            });
            executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        String string = "TrackerV2 network command all get wlan0";
                        InetAddress inetAddress = InetAddress.getByName(FindTrackers.NEW_GROUP);
                        FindTrackers.this.findTrackersThreads(string, inetAddress, 54000, vector, "", WIFI_BROADCAST_NAME, countDownLatch);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            });
            executorService.shutdown();
            while (!executorService.isTerminated()) {
            }
            try {
                countDownLatch.await(this.THREAD_TIMEOUT, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                this.logLine("Threads timeout");
                if (this.debugWriter == null) break block4;
                interruptedException.printStackTrace(this.debugWriter);
            }
        }
        this.logLine("Done waiting for all threads");
        this.logLine("find Trk time taken: " + (System.currentTimeMillis() - l) / 1000L);
        Vector<TrkInfo> vector2 = this.getAllTrackerRecords(vector);
        return new Vector[]{vector2, this.networkCardsList};
    }

    private void findTrackers(String string, InetAddress inetAddress, int n, Vector<NetworkCardInfo> vector, String string2, String string3) throws IOException {
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            this.findTrackersAndAddToList(vector, string, inetAddress, n, string2, string3, n3);
            ++n3;
        }
    }

    private void findTrackersThreads(String string, InetAddress inetAddress, int n, Vector<NetworkCardInfo> vector, String string2, String string3, CountDownLatch countDownLatch) throws IOException {
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            new FindTrackerThread(string, inetAddress, n, vector, string2, String.valueOf(string3) + "_" + (n3 + 1), n3, countDownLatch);
            ++n3;
        }
    }

    private void findTrackersAndAddToList(Vector<NetworkCardInfo> vector, String string, InetAddress inetAddress, int n, String string2, String string3, int n2) {
        try {
            NetworkCardInfo networkCardInfo = vector.elementAt(n2);
            InetAddress inetAddress2 = networkCardInfo.getIPAddress();
            String string4 = inetAddress2.getHostAddress();
            string4 = string4.substring(0, string4.lastIndexOf("."));
            MulticastSocket multicastSocket = this.sendPacket(string, inetAddress, inetAddress2, n);
            boolean bl = false;
            while (!bl) {
                try {
                    byte[] byArray = new byte[300];
                    DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                    multicastSocket.receive(datagramPacket);
                    if (datagramPacket == null) continue;
                    this.addToList(string4, datagramPacket, inetAddress2.getHostAddress(), networkCardInfo.getSubNet(), networkCardInfo.getNetworkInterface(), string2);
                    datagramPacket = null;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    bl = true;
                }
            }
            multicastSocket.leaveGroup(inetAddress);
            multicastSocket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private synchronized void addToList(String string, DatagramPacket datagramPacket, String string2, String string3, NetworkInterface networkInterface, String string4) {
        boolean bl = false;
        string = string.substring(0, string.lastIndexOf("."));
        String string5 = new String(datagramPacket.getData());
        if (string5.startsWith(OLD_RESP) || string5.startsWith(NEW_RESP)) {
            if (string4.equals(networkInterface.getDisplayName())) {
                bl = true;
            }
            this.logLine(string5.replaceAll("\n", "").trim());
            String string6 = "Fail";
            String string7 = "Invalid Format";
            if (string5.startsWith(NEW_RESP) && (string5.contains(string6) || string5.contains(string7))) {
                return;
            }
            String string8 = this.getTrackerIpAddress(string5);
            boolean bl2 = false;
            if (this.findReachableTrks && !string8.equals("None")) {
                string8 = string8.substring(0, string8.lastIndexOf("."));
                if (string.equals(string8 = string8.substring(0, string8.lastIndexOf(".")))) {
                    bl2 = true;
                }
            } else {
                bl2 = true;
            }
            if (bl2) {
                string5 = string5.replaceAll("\n", "");
                this.trkVectorList.add(new Object[]{string5, string2, string3, networkInterface, Thread.currentThread().getName(), bl});
            }
        }
    }

    public Vector<NetworkCardInfo> getNICsHostAddressesAndSubNets() throws SocketException {
        Vector<NetworkCardInfo> vector = new Vector<NetworkCardInfo>(10, 1);
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            if (!networkInterface.isUp()) continue;
            Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
            while (enumeration2.hasMoreElements()) {
                InetAddress inetAddress = enumeration2.nextElement();
                if (inetAddress instanceof Inet6Address || inetAddress.isLoopbackAddress()) continue;
                short s = networkInterface.getInterfaceAddresses().get(0).getNetworkPrefixLength();
                String string = HelperUtility.getSubnetMask(s);
                vector.addElement(new NetworkCardInfo(inetAddress, string, networkInterface));
            }
        }
        return vector;
    }

    private MulticastSocket sendPacket(String string, InetAddress inetAddress, InetAddress inetAddress2, int n) throws IOException {
        MulticastSocket multicastSocket = new MulticastSocket(n);
        multicastSocket.setLoopbackMode(false);
        multicastSocket.setTimeToLive(32);
        multicastSocket.setInterface(inetAddress2);
        multicastSocket.joinGroup(inetAddress);
        DatagramPacket datagramPacket = new DatagramPacket(string.getBytes(), string.length(), inetAddress, n);
        multicastSocket.send(datagramPacket);
        multicastSocket.setSoTimeout(1000);
        return multicastSocket;
    }

    private String getTrackerIpAddress(String string) {
        String string2;
        String[] stringArray;
        String string3 = "";
        if (string.startsWith(OLD_RESP)) {
            String string4 = FindTrackers.getLegacyTrkInfo(string, OLD_RESP);
            String string5 = string4.substring(OLD_RESP.length() + 1, string4.length());
            String[] stringArray2 = string5.split(" ");
            if (stringArray2.length > 1) {
                string3 = stringArray2[1];
            }
        } else if (string.startsWith(NEW_RESP) && (stringArray = (string2 = string.substring(NEW_RESP.length() + 1, string.length())).split(" ")).length > 4) {
            string3 = stringArray[4];
        }
        return string3;
    }

    private void logLine(String string) {
        if (this.debugWriter != null) {
            this.debugWriter.println(string);
        }
    }

    public static String getLegacyTrkInfo(String string, String string2) {
        String string3 = String.valueOf(string2) + " ";
        if (string.startsWith(string2)) {
            String string4 = string.substring(16, string.length());
            int n = 16;
            String string5 = string4.substring(n * 0, n * 1).trim();
            String string6 = string4.substring(n * 1, n * 2).trim();
            String string7 = string4.substring(n * 2, n * 3).trim();
            long l = FindTrackers.StringToLong(string7);
            string3 = String.valueOf(string3) + l + " " + string5 + " " + string6;
            String string8 = "";
            int n2 = string4.length();
            if (n2 > 48) {
                String string9 = string4.substring(n * 3, n * 4).trim();
                string9 = string9.trim();
                string3 = String.valueOf(string3) + " " + string9;
                if (string9.equals("WIFI_ON") || string9.equals("WIFI_OFF")) {
                    int n3 = string9.equals("WIFI_ON") ? 1 : 2;
                    String string10 = string4.substring(n * 4, n * 5).trim();
                    string3 = String.valueOf(string3) + " " + string10;
                    if (string9.equals("WIFI_ON")) {
                        string5 = string10;
                    }
                    string4.substring(n * 5, n * 6).trim();
                    if (string4.length() > n * 6) {
                        string8 = string4.substring(n * 6, n2).trim();
                        string3 = String.valueOf(string3) + " " + string8;
                    }
                }
            }
        }
        return string3;
    }

    public static long StringToLong(String string) {
        int[] nArray = new int[4];
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            nArray[n++] = Integer.parseInt(stringTokenizer.nextToken());
        }
        long l = 0L;
        n = 0;
        while (n < 4) {
            l = (long)((double)l + (double)nArray[3 - n] * Math.pow(256.0, n));
            ++n;
        }
        return l;
    }

    public static boolean checkIfIPaddressAreWithinSameSubnet(String string, String string2, String string3, String string4) {
        String[] stringArray = string.split("\\.");
        String[] stringArray2 = string3.split("\\.");
        String[] stringArray3 = string2.split("\\.");
        String[] stringArray4 = string4.split("\\.");
        int n = stringArray.length;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        String string5 = "";
        String string6 = "";
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = Integer.parseInt(stringArray[n2]) & Integer.parseInt(stringArray3[n2]);
            nArray2[n2] = Integer.parseInt(stringArray2[n2]) & Integer.parseInt(stringArray4[n2]);
            string5 = String.valueOf(string5) + nArray[n2];
            string6 = String.valueOf(string6) + nArray2[n2];
            if (n2 < 3) {
                string5 = String.valueOf(string5) + ".";
                string6 = String.valueOf(string6) + ".";
            }
            ++n2;
        }
        n2 = 1;
        int n3 = 0;
        while (n3 < 2) {
            if (nArray[n3] != nArray2[n3]) {
                n2 = 0;
            }
            ++n3;
        }
        return n2 != 0;
    }

    public Vector<TrkInfo> getAllTrackerRecords(Vector<NetworkCardInfo> vector) throws Exception {
        return this.getAllTrackerRecords(null, vector);
    }

    /*
     * Could not resolve type clashes
     */
    public Vector<TrkInfo> getAllTrackerRecords(Vector vector, Vector<NetworkCardInfo> vector2) throws Exception {
        boolean bl;
        boolean bl2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object52;
        HashMap<String, TrkInfo> hashMap;
        Object object62;
        if (vector != null) {
            this.trkVectorList = vector;
        }
        this.networkCardsList.clear();
        int n = this.trkVectorList.size();
        HashMap<Object, Integer> hashMap2 = new HashMap<Object, Integer>();
        int n2 = 0;
        while (n2 < n) {
            object62 = this.trkVectorList.get(n2);
            hashMap = (String)object62[1];
            object52 = (String)object62[2];
            object4 = (String)object62[0];
            if (((String)object4).startsWith(NEW_RESP) || ((String)object4).startsWith(OLD_RESP)) {
                Object object7;
                if (((String)object4).startsWith(OLD_RESP)) {
                    object4 = HelperUtility.getLegacyTrkInfo(object4, OLD_RESP);
                    object3 = ((String)object4).substring(OLD_RESP.length() + 1, ((String)object4).length()).trim();
                    object2 = ((String)object3).split(",");
                    object = "";
                    String string = "";
                    String string2 = "";
                    String string3 = "";
                    String string4 = "";
                    String string5 = "";
                    int n3 = 0;
                    int n4 = 0;
                    bl2 = false;
                    if (((String[])object2).length > 2) {
                        object = ((String)object2[0]).trim();
                        string = ((String)object2[1]).trim();
                        string2 = ((String)object2[2]).trim();
                        if (((Object)object2).length > 3 && ((string3 = ((String)object2[3]).trim()).equals("WIFI_ON") || string3.equals("WIFI_OFF"))) {
                            bl2 = true;
                            int n5 = n3 = string3.equals("WIFI_ON") ? 1 : 2;
                            if (string3.equals("WIFI_ON")) {
                                n4 = 1;
                            }
                        }
                        if (((Object)object2).length > 4) {
                            string4 = ((String)object2[4]).trim();
                        }
                        if (((Object)object2).length > 5) {
                            string5 = ((String)object2[5]).trim();
                        }
                        object7 = new VantageIonInfo((String)object, string, string2, n3, string4, string5, (String)((Object)hashMap), (String)object52, (NetworkInterface)object62[3], (String)object62[4], (String)object62[0], TrkInfo.LEGACY_PACKET, bl2 ? 1 : 0, n4);
                        hashMap2.put(object7, Integer.parseInt((String)object));
                    }
                } else if (((String)object4).startsWith(NEW_RESP)) {
                    object3 = ((String)object4).substring(NEW_RESP.length() + 1, ((String)object4).length()).trim();
                    int n6 = ((String)object3).indexOf(" ");
                    Integer.parseInt(((String)object3).substring(0, n6).trim());
                    object = ((String)object3).split(" ");
                    int n7 = 1;
                    if (object[2].trim().equalsIgnoreCase("True")) {
                        n7 = 2;
                    }
                    int n8 = TrkInfo.CYPHER_WIRED_PACKET;
                    int n9 = 0;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    String string = null;
                    if (((String)object[1]).trim().equalsIgnoreCase("wlan0")) {
                        n8 = TrkInfo.CYPHER_WIFI_PACKET;
                        n9 = 1;
                        if (((String)object[8]).trim().equalsIgnoreCase("True")) {
                            bl3 = true;
                        }
                        if (((String)object[9]).trim().equalsIgnoreCase("True")) {
                            bl4 = true;
                        }
                        if (((Object)object).length > 10 && !((String)object[10]).trim().equalsIgnoreCase("None")) {
                            string = ((String)object[10]).trim();
                        }
                    }
                    String string6 = "";
                    bl2 = false;
                    object7 = "";
                    bl = true;
                    boolean bl5 = false;
                    boolean bl6 = true;
                    int n10 = 11;
                    int n11 = 0;
                    if (((Object)object).length > n10) {
                        bl5 = true;
                        int n12 = n10;
                        while (n12 < ((Object)object).length) {
                            String[] stringArray = ((String)object[n12]).split(":");
                            if (stringArray.length > 1) {
                                String string7 = stringArray[0];
                                if (string7.equalsIgnoreCase("ssid")) {
                                    string6 = stringArray[1];
                                } else if (string7.equalsIgnoreCase("wifi_state")) {
                                    bl2 = stringArray[1].equalsIgnoreCase("up");
                                } else if (string7.equalsIgnoreCase("type")) {
                                    object7 = stringArray[1];
                                } else if (string7.equalsIgnoreCase("enet1")) {
                                    bl = stringArray[1].equalsIgnoreCase("1");
                                } else if (string7.equalsIgnoreCase("sessions")) {
                                    bl6 = stringArray[1].equalsIgnoreCase("1");
                                } else if (string7.equalsIgnoreCase("serial_type")) {
                                    n11 = Integer.parseInt(stringArray[1]);
                                }
                            }
                            ++n12;
                        }
                    }
                    CypherInfo cypherInfo = new CypherInfo(((String)object[0]).trim(), ((String)object[4]).trim(), ((String)object[5]).trim(), n7, bl4, string, bl3, (String)((Object)hashMap), (String)object52, (NetworkInterface)object62[3], (String)object62[4], (String)object62[0], string6, bl2, (String)object7, bl, bl5, bl6, n8, 2, n9, n11);
                    hashMap2.put(cypherInfo, Integer.parseInt((String)object[0]));
                }
            }
            ++n2;
        }
        HashMap<Integer, Object> hashMap3 = new HashMap<Integer, Object>();
        for (Object object62 : hashMap2.entrySet()) {
            object52 = new ArrayList();
            if (hashMap3.containsKey(object62.getValue())) {
                object52 = (List)hashMap3.get(object62.getValue());
            }
            object52.add((TrkInfo)object62.getKey());
            hashMap3.put((Integer)object62.getValue(), object52);
        }
        object62 = new Vector();
        hashMap = new HashMap<String, TrkInfo>();
        for (Object object52 : hashMap3.entrySet()) {
            object3 = (List)object52.getValue();
            object2 = new ArrayList();
            object = new ArrayList();
            int n13 = object3.size();
            int n14 = 0;
            while (n14 < n13) {
                TrkInfo trkInfo = (TrkInfo)object3.get(n14);
                if (trkInfo.getBroadCastName().startsWith(LEGACY_BROADCAST_NAME)) {
                    hashMap.put(trkInfo.getSrNum(), trkInfo);
                } else if (((CypherInfo)trkInfo).getPacketType() == CypherInfo.CYPHER_WIRED_PACKET) {
                    ((ArrayList)object2).add(trkInfo);
                } else if (((CypherInfo)trkInfo).getPacketType() == CypherInfo.CYPHER_WIFI_PACKET) {
                    ((ArrayList)object).add(trkInfo);
                }
                ++n14;
            }
            ArrayList<TrkInfo> arrayList = new ArrayList<TrkInfo>();
            ArrayList<TrkInfo> arrayList2 = new ArrayList<TrkInfo>();
            ArrayList<TrkInfo> arrayList3 = new ArrayList<TrkInfo>();
            ArrayList<TrkInfo> arrayList4 = new ArrayList<TrkInfo>();
            boolean bl7 = ((ArrayList)object2).size();
            boolean bl8 = false;
            while (bl8 < bl7) {
                TrkInfo trkInfo = (TrkInfo)((ArrayList)object2).get(bl8 ? 1 : 0);
                boolean bl9 = HelperUtility.checkIfIPaddressAreWithinSameSubnet(trkInfo, trkInfo.getNetworkCardIpAdd(), trkInfo.getNetworkCardIpMask());
                if (bl9) {
                    arrayList.add(trkInfo);
                } else {
                    arrayList2.add(trkInfo);
                }
                bl8 += 1;
            }
            bl8 = ((ArrayList)object).size();
            bl2 = false;
            while (bl2 < bl8) {
                TrkInfo trkInfo = (TrkInfo)((ArrayList)object).get(bl2 ? 1 : 0);
                bl = HelperUtility.checkIfIPaddressAreWithinSameSubnet(trkInfo, trkInfo.getNetworkCardIpAdd(), trkInfo.getNetworkCardIpMask());
                if (bl) {
                    arrayList3.add(trkInfo);
                } else {
                    arrayList4.add(trkInfo);
                }
                bl2 += 1;
            }
            if (arrayList.size() > 0) {
                ((Vector)object62).add((TrkInfo)arrayList.get(0));
            } else if (arrayList2.size() > 0) {
                ((Vector)object62).add((TrkInfo)arrayList2.get(0));
            }
            if (arrayList3.size() > 0) {
                ((Vector)object62).add((TrkInfo)arrayList3.get(0));
                continue;
            }
            if (arrayList4.size() <= 0) continue;
            ((Vector)object62).add((TrkInfo)arrayList4.get(0));
        }
        for (Object object52 : hashMap.entrySet()) {
            ((Vector)object62).add((TrkInfo)object52.getValue());
        }
        this.sortNetworkCards(vector2, (Vector<TrkInfo>)object62);
        int n15 = ((Vector)object62).size();
        this.logLine("-------------------------------------------------------------");
        object4 = new TrackerReachable((Vector<TrkInfo>)object62, this.networkCardsList, this.debugWriter);
        ((TrackerReachable)object4).checkIfTrackersReachable();
        int n16 = 0;
        while (n16 < n15) {
            object2 = (TrkInfo)((Vector)object62).get(n16);
            if (object2 instanceof CypherInfo) {
                object = (CypherInfo)object2;
                this.logLine(String.valueOf(((TrkInfo)object2).getSrNum()) + ", " + ((CypherInfo)object).isReachable() + ", " + ((CypherInfo)object).getReachableDetails() + ", " + ((CypherInfo)object).getReachableRecommendation());
            } else {
                object = (VantageIonInfo)object2;
                this.logLine(String.valueOf(((TrkInfo)object2).getSrNum()) + ", " + ((VantageIonInfo)object).isWiredReachable() + ", " + ((VantageIonInfo)object).getWiredReachableDetails() + ", " + ((VantageIonInfo)object).getWiredReachableRecommendation() + ", " + ((VantageIonInfo)object).isWifiReachable() + ", " + ((VantageIonInfo)object).getWifiReachableDetails() + ", " + ((VantageIonInfo)object).getWifiReachableRecommendation());
            }
            ++n16;
        }
        this.logLine("-------------------------------------------------------------");
        this.logLine("Network Cards");
        n16 = 0;
        while (n16 < this.networkCardsList.size()) {
            object2 = this.networkCardsList.get(n16);
            this.logLine(String.valueOf(((NetworkCardInfo)object2).getNetworkInterface().getDisplayName()) + "," + ((NetworkCardInfo)object2).getIPAddress() + "," + ((NetworkCardInfo)object2).getSubNet());
            ++n16;
        }
        this.logLine("-------------------------------------------------------------");
        return object62;
    }

    /*
     * WARNING - void declaration
     */
    private void sortNetworkCards(Vector<NetworkCardInfo> vector, Vector<TrkInfo> vector2) {
        Object object;
        void entry;
        int n = vector2.size();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        boolean n2 = false;
        while (entry < n) {
            String n3;
            TrkInfo trkInfo = vector2.get((int)entry);
            object = trkInfo.getNetworkInterface();
            if (object != null && !hashMap.containsKey(n3 = ((NetworkInterface)object).getDisplayName())) {
                hashMap.put(((NetworkInterface)object).getDisplayName(), object);
            }
            ++entry;
        }
        for (Map.Entry entry2 : hashMap.entrySet()) {
            object = (String)entry2.getKey();
            int n3 = 0;
            while (n3 < vector.size()) {
                NetworkCardInfo networkCardInfo = vector.get(n3);
                NetworkInterface networkInterface = networkCardInfo.getNetworkInterface();
                if (networkInterface.getDisplayName().equals(object)) {
                    this.networkCardsList.add(networkCardInfo);
                }
                ++n3;
            }
        }
    }

    private class FindTrackerThread
    implements Runnable {
        String msg;
        InetAddress group;
        int port;
        Vector<NetworkCardInfo> NICAddrs;
        String wifiCardName;
        String threadName;
        int x;
        CountDownLatch latch;

        public FindTrackerThread(String string, InetAddress inetAddress, int n, Vector<NetworkCardInfo> vector, String string2, String string3, int n2, CountDownLatch countDownLatch) {
            this.msg = string;
            this.group = inetAddress;
            this.port = n;
            this.NICAddrs = vector;
            this.x = n2;
            this.threadName = string3;
            this.wifiCardName = string2;
            this.latch = countDownLatch;
            Thread thread = new Thread((Runnable)this, this.threadName);
            thread.setDaemon(true);
            thread.start();
        }

        @Override
        public void run() {
            String string = Thread.currentThread().getName();
            FindTrackers.this.findTrackersAndAddToList(this.NICAddrs, this.msg, this.group, this.port, this.wifiCardName, string, this.x);
            if (this.latch != null) {
                this.latch.countDown();
            }
        }
    }
}

