/*
 * Decompiled with CFR 0.152.
 */
package ipaddressutility;

import ipaddressutility.IPAddressUtility;
import ipaddressutility.NetworkCardInfo;
import ipaddressutility.SafeResourceBundle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.NetworkInterface;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class DiagnoseDlg
extends JDialog {
    JTextArea recommendTextArea = new JTextArea();
    JTextArea detailsTextArea = new JTextArea();
    JTable networkCardTable = new JTable();
    DefaultTableModel networkCardTableModel = new DefaultTableModel();
    static SafeResourceBundle res = IPAddressUtility.res;

    public DiagnoseDlg() {
        this.init();
    }

    private void init() {
        this.recommendTextArea.setWrapStyleWord(true);
        this.recommendTextArea.setLineWrap(true);
        this.recommendTextArea.setFont(new Font("Tahoma", 0, 11));
        this.recommendTextArea.setEditable(false);
        this.detailsTextArea.setLineWrap(true);
        this.detailsTextArea.setWrapStyleWord(true);
        this.detailsTextArea.setFont(new Font("Tahoma", 0, 11));
        this.detailsTextArea.setEditable(false);
        this.recommendTextArea.setEnabled(false);
        this.detailsTextArea.setEnabled(false);
        this.recommendTextArea.setDisabledTextColor(Color.BLACK);
        this.detailsTextArea.setDisabledTextColor(Color.BLACK);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        JPanel jPanel = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.getContentPane().add((Component)jPanel, gridBagConstraints);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        jPanel.setLayout(gridBagLayout2);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new TitledBorder(null, "Details", 4, 2, null, null));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints2.weighty = 0.2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        jPanel.add((Component)jPanel2, gridBagConstraints2);
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout3);
        JScrollPane jScrollPane = new JScrollPane();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        jPanel2.add((Component)jScrollPane, gridBagConstraints3);
        jScrollPane.setViewportView(this.detailsTextArea);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(new TitledBorder(null, "Recommendation", 4, 2, null, null));
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.weighty = 0.4;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 1;
        jPanel.add((Component)jPanel3, gridBagConstraints4);
        GridBagLayout gridBagLayout4 = new GridBagLayout();
        jPanel3.setLayout(gridBagLayout4);
        JScrollPane jScrollPane2 = new JScrollPane();
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.weighty = 1.0;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.fill = 1;
        gridBagConstraints5.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 0;
        jPanel3.add((Component)jScrollPane2, gridBagConstraints5);
        jScrollPane2.setViewportView(this.recommendTextArea);
        JPanel jPanel4 = new JPanel();
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.fill = 2;
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.gridy = 3;
        jPanel.add((Component)jPanel4, gridBagConstraints6);
        GridBagLayout gridBagLayout5 = new GridBagLayout();
        gridBagLayout5.columnWeights = new double[]{0.0, 0.0};
        gridBagLayout5.rowWeights = new double[]{0.0};
        jPanel4.setLayout(gridBagLayout5);
        JButton jButton = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DiagnoseDlg.this.dispose();
            }
        });
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints7.gridx = 1;
        gridBagConstraints7.gridy = 0;
        jPanel4.add((Component)jButton, gridBagConstraints7);
        Component component = Box.createHorizontalStrut(20);
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.weightx = 1.0;
        gridBagConstraints8.fill = 2;
        gridBagConstraints8.gridx = 0;
        gridBagConstraints8.gridy = 0;
        jPanel4.add(component, gridBagConstraints8);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(new TitledBorder(null, "Network Cards", 4, 2, null, null));
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.weightx = 1.0;
        gridBagConstraints9.weighty = 0.4;
        gridBagConstraints9.fill = 1;
        gridBagConstraints9.gridx = 0;
        gridBagConstraints9.gridy = 2;
        jPanel.add((Component)jPanel5, gridBagConstraints9);
        GridBagLayout gridBagLayout6 = new GridBagLayout();
        jPanel5.setLayout(gridBagLayout6);
        this.networkCardTable.setDefaultRenderer(Object.class, new NetworkCardTableCellRenderer());
        this.networkCardTable.setShowGrid(false);
        this.networkCardTable.setAutoResizeMode(4);
        this.networkCardTableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.networkCardTableModel.addColumn("#");
        this.networkCardTableModel.addColumn(res.getString("Name"));
        this.networkCardTableModel.addColumn(res.getString("IP_Address"));
        this.networkCardTableModel.addColumn(res.getString("IP_Mask"));
        this.networkCardTable.setModel(this.networkCardTableModel);
        JScrollPane jScrollPane3 = new JScrollPane(this.networkCardTable, 20, 30);
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.weighty = 1.0;
        gridBagConstraints10.weightx = 1.0;
        gridBagConstraints10.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints10.fill = 1;
        gridBagConstraints10.gridx = 0;
        gridBagConstraints10.gridy = 0;
        jPanel5.add((Component)jScrollPane3, gridBagConstraints10);
    }

    public DiagnoseDlg(Frame frame, String string, boolean bl, String string2, String string3, Vector<NetworkCardInfo> vector) {
        super(frame, string, bl);
        try {
            this.setDefaultCloseOperation(2);
            this.init();
            this.recommendTextArea.setText(string3);
            this.detailsTextArea.setText(string2);
            this.recommendTextArea.setCaretPosition(0);
            this.detailsTextArea.setCaretPosition(0);
            this.setNetworkCardInfoText(vector);
            this.pack();
            this.setSize(new Dimension(600, 400));
            this.setLocationRelativeTo(frame);
            this.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setNetworkCardInfoText(Vector<NetworkCardInfo> vector) {
        int n = vector.size();
        if (n == 0) {
            return;
        }
        int n2 = this.networkCardTableModel.getRowCount();
        int n3 = n2 - 1;
        while (n3 >= 0) {
            this.networkCardTableModel.removeRow(n3);
            --n3;
        }
        Object[][] objectArray = new Object[n][4];
        int n4 = 0;
        while (n4 < n) {
            NetworkCardInfo networkCardInfo = vector.get(n4);
            String string = networkCardInfo.getIPAddress().getHostAddress();
            String string2 = networkCardInfo.getSubNet();
            NetworkInterface networkInterface = networkCardInfo.getNetworkInterface();
            objectArray[n4][0] = String.valueOf(n4 + 1);
            objectArray[n4][1] = networkInterface.getDisplayName();
            objectArray[n4][2] = string;
            objectArray[n4][3] = string2;
            this.networkCardTableModel.addRow(objectArray[n4]);
            ++n4;
        }
        TableColumn tableColumn = this.networkCardTable.getColumnModel().getColumn(0);
        tableColumn.setMinWidth(20);
        tableColumn.setMaxWidth(20);
        tableColumn.setPreferredWidth(20);
        tableColumn = this.networkCardTable.getColumnModel().getColumn(2);
        tableColumn.setMinWidth(150);
        tableColumn.setMaxWidth(150);
        tableColumn.setPreferredWidth(150);
        tableColumn = this.networkCardTable.getColumnModel().getColumn(3);
        tableColumn.setMinWidth(150);
        tableColumn.setMaxWidth(150);
        tableColumn.setPreferredWidth(150);
        ((DefaultTableCellRenderer)this.networkCardTable.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(0);
    }

    class NetworkCardTableCellRenderer
    extends DefaultTableCellRenderer {
        NetworkCardTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.setForeground(jTable.getForeground());
            if (n % 2 == 1) {
                super.setBackground(new Color(235, 235, 235));
            } else {
                super.setBackground(jTable.getBackground());
            }
            Font font = jTable.getFont();
            this.setFont(font);
            this.setOpaque(true);
            this.setText((String)object);
            this.setHorizontalAlignment(0);
            return this;
        }
    }
}

