/*
 * Decompiled with CFR 0.152.
 */
package ipaddressutility;

import ipaddressutility.ChangeConfigurationsDlg_cancelButton_actionAdapter;
import ipaddressutility.ChangeConfigurationsDlg_defaultsButton_actionAdapter;
import ipaddressutility.ChangeConfigurationsDlg_okButton_actionAdapter;
import ipaddressutility.IPAddressUtility;
import ipaddressutility.SafeResourceBundle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class ChangeIPSettingsDlg
extends JDialog {
    static SafeResourceBundle res = IPAddressUtility.res;
    JPanel mainPanel = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JPanel ipAddPanel = new JPanel();
    JPanel ipMaskPanel = new JPanel();
    JPanel wifiPanel = new JPanel();
    JPanel commandButtonPanel = new JPanel();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    Component component1 = Box.createHorizontalStrut(8);
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    GridBagLayout gridBagLayout4 = new GridBagLayout();
    GridBagLayout gridBagLayout5 = new GridBagLayout();
    GridBagLayout gridBagLayout6 = new GridBagLayout();
    JLabel ipAddLabel = new JLabel();
    JLabel ipMaskLabel = new JLabel();
    JButton okButton = new JButton();
    JButton cancelButton = new JButton();
    Component component2 = Box.createHorizontalStrut(8);
    MyDocumentListener myDocumentListener = new MyDocumentListener();
    private static int FIELD1 = 0;
    private static int FIELD2 = 1;
    private static int FIELD3 = 2;
    private static int FIELD4 = 3;
    private static int NO_OF_FIELDS = 4;
    JTextField[] ipAdd = new JTextField[NO_OF_FIELDS];
    JTextField[] ipMask = new JTextField[NO_OF_FIELDS];
    JTextField[] gtWay = new JTextField[NO_OF_FIELDS];
    private String oldIPAddress = new String();
    private String newIPAddress = new String();
    private String oldIPMask = new String();
    private String newIPMask = new String();
    private Frame frame = null;
    boolean cancelled = true;
    JPanel gtWayPanel = new JPanel();
    GridBagLayout gridBagLayout7 = new GridBagLayout();
    boolean showGateWay = false;
    String oldGateWay = "";
    String newGateWay = "";
    JLabel gatewayLabel = new JLabel();
    JButton defaultsButton = new JButton();

    public ChangeIPSettingsDlg(Frame frame, String string, boolean bl, String string2, String string3, boolean bl2, int n, boolean bl3, String string4) {
        super(frame, string, bl);
        try {
            this.oldIPAddress = string2;
            this.oldIPMask = string3;
            this.frame = frame;
            this.showGateWay = bl3;
            this.oldGateWay = string4;
            this.setDefaultCloseOperation(2);
            this.jbInit();
            this.setValues();
            this.pack();
            this.setLocationRelativeTo(frame);
            this.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ChangeIPSettingsDlg() {
        this(new Frame(), "ChangeConfigurationsDlg", false, "", "", false, -1, false, "");
    }

    private void jbInit() throws Exception {
        this.defaultsButton.setText("Defaults");
        this.gtWayPanel.setLayout(this.gridBagLayout6);
        this.component2 = Box.createHorizontalStrut(8);
        this.component1 = Box.createHorizontalStrut(8);
        this.mainPanel.setLayout(this.gridBagLayout1);
        this.getContentPane().setLayout(this.gridBagLayout2);
        this.ipAddPanel.setLayout(this.gridBagLayout3);
        this.ipMaskPanel.setLayout(this.gridBagLayout4);
        this.wifiPanel.setLayout(this.gridBagLayout5);
        this.commandButtonPanel.setLayout(this.gridBagLayout6);
        this.ipAddLabel.setText(res.getString("IP_Address"));
        this.ipMaskLabel.setText(res.getString("IP_Mask"));
        this.gatewayLabel.setText(res.getString("Gateway"));
        this.okButton.setText(res.getString("OK"));
        this.okButton.addActionListener(new ChangeConfigurationsDlg_okButton_actionAdapter(this));
        this.cancelButton.setText(res.getString("Cancel"));
        this.cancelButton.addActionListener(new ChangeConfigurationsDlg_cancelButton_actionAdapter(this));
        this.defaultsButton.addActionListener(new ChangeConfigurationsDlg_defaultsButton_actionAdapter(this));
        this.commandButtonPanel.add((Component)this.defaultsButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.commandButtonPanel.add(this.component1, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.mainPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(12, 12, 12, 12), 0, 0));
        this.commandButtonPanel.add((Component)this.okButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.mainPanel.add((Component)this.commandButtonPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.commandButtonPanel.add((Component)this.cancelButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.ipAddPanel.add((Component)this.ipAddLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.ipMaskPanel.add((Component)this.ipMaskLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 21), 0, 0));
        this.mainPanel.add((Component)this.ipAddPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 12, 0), 0, 0));
        this.mainPanel.add((Component)this.ipMaskPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 12, 0), 0, 0));
        this.gtWayPanel.add((Component)this.gatewayLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 15), 0, 0));
        if (this.showGateWay) {
            this.mainPanel.add((Component)this.gtWayPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 12, 0), 0, 0));
        }
        int n = 0;
        while (n < NO_OF_FIELDS) {
            this.ipAdd[n] = new JTextField();
            this.ipAddPanel.add((Component)this.ipAdd[n], new GridBagConstraints(n + 1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
            this.ipAdd[n].setDocument(new ValidatingDocument());
            this.ipAdd[n].getDocument().addDocumentListener(this.myDocumentListener);
            this.ipAdd[n].getDocument().putProperty("name", "ipAdd" + n);
            this.ipAdd[n].setPreferredSize(new Dimension(45, 23));
            this.ipMask[n] = new JTextField();
            this.ipMaskPanel.add((Component)this.ipMask[n], new GridBagConstraints(n + 1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
            this.ipMask[n].setDocument(new ValidatingDocument());
            this.ipMask[n].getDocument().addDocumentListener(this.myDocumentListener);
            this.ipMask[n].getDocument().putProperty("name", "ipMask" + n);
            this.ipMask[n].setPreferredSize(new Dimension(45, 23));
            this.gtWay[n] = new JTextField();
            this.gtWayPanel.add((Component)this.gtWay[n], new GridBagConstraints(n + 1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
            this.gtWay[n].setDocument(new ValidatingDocument());
            this.gtWay[n].getDocument().addDocumentListener(this.myDocumentListener);
            this.gtWay[n].getDocument().putProperty("name", "gtWay" + n);
            this.gtWay[n].setPreferredSize(new Dimension(45, 23));
            ++n;
        }
    }

    private void setValues() {
        int n = 0;
        this.oldIPAddress = this.oldIPAddress.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(this.oldIPAddress, ".");
        while (stringTokenizer.hasMoreTokens()) {
            this.ipAdd[n++].setText(stringTokenizer.nextToken());
        }
        n = 0;
        this.oldIPMask = this.oldIPMask.trim();
        stringTokenizer = new StringTokenizer(this.oldIPMask, ".");
        while (stringTokenizer.hasMoreTokens()) {
            this.ipMask[n++].setText(stringTokenizer.nextToken());
        }
    }

    private boolean validateIPAddressFields() {
        int n = 0;
        while (n < NO_OF_FIELDS) {
            String string = this.ipAdd[n].getText();
            if (string == null || string.equals("")) {
                this.ShowErrorMessage(String.valueOf(res.getString("Invalid_IP_Address")) + res.getString("Restriction"));
                return false;
            }
            int n2 = Integer.valueOf(string);
            if (n2 < 0 || n2 > 255) {
                this.ShowErrorMessage(String.valueOf(res.getString("Invalid_IP_Address")) + res.getString("Restriction"));
                return false;
            }
            ++n;
        }
        String string = this.ipAdd[FIELD4].getText();
        int n3 = Integer.valueOf(string);
        return n3 != 0 && n3 != 255 || JOptionPane.showConfirmDialog(this.frame, res.getString("Invalid_Number_Warning"), res.getString("Warning"), 0) != 1;
    }

    private boolean validateIPMaskFields() {
        int n = 0;
        while (n < NO_OF_FIELDS) {
            String string = this.ipMask[n].getText();
            if (string == null || string.equals("")) {
                this.ShowErrorMessage(String.valueOf(res.getString("Invalid_IP_Mask")) + res.getString("Restriction"));
                return false;
            }
            int n2 = Integer.valueOf(string);
            if (n2 < 0 || n2 > 255) {
                this.ShowErrorMessage(String.valueOf(res.getString("Invalid_IP_Mask")) + res.getString("Restriction"));
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean validateGtWayFields() {
        if (!this.showGateWay) {
            return true;
        }
        int n = 0;
        while (n < NO_OF_FIELDS) {
            String string = this.gtWay[n].getText();
            if (string == null || string.equals("")) {
                this.ShowErrorMessage(String.valueOf(res.getString("Invalid_Gateway")) + res.getString("Restriction"));
                return false;
            }
            int n2 = Integer.valueOf(string);
            if (n2 < 0 || n2 > 255) {
                this.ShowErrorMessage(String.valueOf(res.getString("Invalid_Gateway")) + res.getString("Restriction"));
                return false;
            }
            ++n;
        }
        return true;
    }

    private void ShowErrorMessage(String string) {
        JOptionPane.showMessageDialog(this.frame, string, res.getString("Error"), 0);
    }

    public String getNewIpAddress() {
        return this.newIPAddress;
    }

    public String getNewIpMask() {
        return this.newIPMask;
    }

    public String getNewGateway() {
        return this.newGateWay;
    }

    public int getWifiState() {
        return 0;
    }

    public void okButton_actionPerformed(ActionEvent actionEvent) {
        if (!this.validateIPAddressFields()) {
            return;
        }
        if (!this.validateIPMaskFields()) {
            return;
        }
        if (!this.validateGtWayFields()) {
            return;
        }
        this.newIPAddress = String.valueOf(this.ipAdd[FIELD1].getText()) + "." + this.ipAdd[FIELD2].getText() + "." + this.ipAdd[FIELD3].getText() + "." + this.ipAdd[FIELD4].getText();
        this.newIPMask = String.valueOf(this.ipMask[FIELD1].getText()) + "." + this.ipMask[FIELD2].getText() + "." + this.ipMask[FIELD3].getText() + "." + this.ipMask[FIELD4].getText();
        this.newGateWay = String.valueOf(this.gtWay[FIELD1].getText()) + "." + this.gtWay[FIELD2].getText() + "." + this.gtWay[FIELD3].getText() + "." + this.gtWay[FIELD4].getText();
        this.cancelled = false;
        this.dispose();
    }

    public void cancelButton_actionPerformed(ActionEvent actionEvent) {
        this.cancelled = true;
        this.dispose();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void defaultsButton_actionPerformed(ActionEvent actionEvent) {
        int n = 0;
        this.ipAdd[n++].setText("128");
        this.ipAdd[n++].setText("128");
        this.ipAdd[n++].setText("128");
        this.ipAdd[n++].setText("100");
        n = 0;
        this.ipMask[n++].setText("255");
        this.ipMask[n++].setText("255");
        this.ipMask[n++].setText("0");
        this.ipMask[n++].setText("0");
        this.okButton.requestFocus();
    }

    protected class MyDocumentListener
    implements DocumentListener {
        protected MyDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.EvaluateIPAddress(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        private void EvaluateIPAddFieldValue(int n) {
            String string = ChangeIPSettingsDlg.this.ipAdd[n].getText();
            Integer.valueOf(string).intValue();
            if (string.length() == 3) {
                if (n == 3) {
                    ChangeIPSettingsDlg.this.ipAdd[n].transferFocus();
                } else {
                    ChangeIPSettingsDlg.this.ipAdd[n + 1].selectAll();
                    ChangeIPSettingsDlg.this.ipAdd[n + 1].requestFocus();
                }
            }
        }

        private void EvaluateIPMaskFieldValue(int n) {
            String string = ChangeIPSettingsDlg.this.ipMask[n].getText();
            Integer.valueOf(string).intValue();
            if (string.length() == 3) {
                if (n == 3) {
                    ChangeIPSettingsDlg.this.ipMask[n].transferFocus();
                } else {
                    ChangeIPSettingsDlg.this.ipMask[n + 1].selectAll();
                    ChangeIPSettingsDlg.this.ipMask[n + 1].requestFocus();
                }
            }
        }

        private void EvaluateGtWayFieldValue(int n) {
            String string = ChangeIPSettingsDlg.this.gtWay[n].getText();
            Integer.valueOf(string).intValue();
            if (string.length() == 3) {
                if (n == 3) {
                    ChangeIPSettingsDlg.this.gtWay[n].transferFocus();
                } else {
                    ChangeIPSettingsDlg.this.gtWay[n + 1].selectAll();
                    ChangeIPSettingsDlg.this.gtWay[n + 1].requestFocus();
                }
            }
        }

        private void EvaluateIPAddress(DocumentEvent documentEvent) {
            Document document = documentEvent.getDocument();
            int n = 0;
            while (n < NO_OF_FIELDS) {
                if (document.getProperty("name").equals("ipAdd" + n)) {
                    this.EvaluateIPAddFieldValue(n);
                }
                if (document.getProperty("name").equals("ipMask" + n)) {
                    this.EvaluateIPMaskFieldValue(n);
                }
                if (document.getProperty("name").equals("gtWay" + n)) {
                    this.EvaluateGtWayFieldValue(n);
                }
                ++n;
            }
        }
    }

    public class ValidatingDocument
    extends PlainDocument {
        int maxCharacters = 3;

        void parseValue(String string) throws NumberFormatException {
            Integer.parseInt(string);
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            String string2;
            if (string == null) {
                return;
            }
            int n2 = this.getLength();
            if (n2 == 0) {
                string2 = string;
            } else {
                string2 = this.getText(0, n2);
                if (n2 + string.length() > this.maxCharacters) {
                    Toolkit.getDefaultToolkit().beep();
                    string = "";
                } else {
                    StringBuffer stringBuffer = new StringBuffer(string2);
                    stringBuffer.insert(n, string);
                    string2 = stringBuffer.toString();
                }
            }
            try {
                this.parseValue(string2);
                super.insertString(n, string, attributeSet);
            }
            catch (NumberFormatException numberFormatException) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

