/*
 * Decompiled with CFR 0.152.
 */
package ipaddressutility;

import ipaddressutility.IPAddressUtility;
import ipaddressutility.IPAddressUtilityThread;
import ipaddressutility.SafeResourceBundle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class ChangeIPAddress
extends JDialog {
    static SafeResourceBundle res = IPAddressUtility.res;
    private JPanel mainPanel = new JPanel();
    private JLabel IPAddLabel = new JLabel();
    private JTextField[] IPAdd = new JTextField[4];
    private JTextField[] IPMask = new JTextField[4];
    private JButton OK = new JButton();
    private JButton Cancel = new JButton();
    private JFrame frame = null;
    private String oldIPAddress = new String();
    private String newIPAddress = new String();
    private String oldIPMask = new String();
    private String newIPMask = new String();
    private static int FIELD1 = 0;
    private static int FIELD2 = 1;
    private static int FIELD3 = 2;
    private static int FIELD4 = 3;
    private static int NO_OF_FIELDS = 4;
    private boolean ipAddressChanged = false;
    private boolean ipMaskChanged = false;
    private IPAddressUtilityThread commandThread = null;
    MyDocumentListener myDocumentListener = new MyDocumentListener();
    private JLabel MaskValue = new JLabel();

    public ChangeIPAddress(JFrame jFrame, String string, boolean bl, String string2, String string3) {
        super(jFrame, string, bl);
        try {
            this.oldIPAddress = string2;
            this.oldIPMask = string3;
            this.frame = jFrame;
            this.jbInit();
            this.pack();
            this.setResizable(false);
            this.setLocationRelativeTo(this.frame);
            this.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ChangeIPAddress() {
        this(null, "", false, null, null);
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(215, 120));
        this.OK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChangeIPAddress.this.OK_actionPerformed(actionEvent);
            }
        });
        this.Cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChangeIPAddress.this.Cancel_actionPerformed(actionEvent);
            }
        });
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.MaskValue.setText(IPAddressUtility.res.getString("IP_Mask"));
        this.MaskValue.setBounds(new Rectangle(5, 40, 64, 18));
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.mainPanel.setLayout(null);
        this.mainPanel.setMaximumSize(new Dimension(230, 100));
        this.mainPanel.setMinimumSize(new Dimension(230, 100));
        this.mainPanel.setPreferredSize(new Dimension(230, 100));
        this.IPAddLabel.setText(IPAddressUtility.res.getString("IP_Address"));
        this.IPAddLabel.setBounds(new Rectangle(5, 9, 68, 19));
        this.OK.setText(IPAddressUtility.res.getString("OK"));
        this.OK.setBounds(new Rectangle(24, 70, 73, 27));
        this.mainPanel.add((Component)this.IPAddLabel, null);
        this.mainPanel.add((Component)this.MaskValue, null);
        this.mainPanel.add((Component)this.OK, null);
        this.mainPanel.add((Component)this.Cancel, null);
        this.Cancel.setText(IPAddressUtility.res.getString("Cancel"));
        this.Cancel.setBounds(new Rectangle(133, 70, 73, 27));
        int n = 75;
        int n2 = 0;
        while (n2 < NO_OF_FIELDS) {
            this.IPAdd[n2] = new JTextField();
            this.mainPanel.add((Component)this.IPAdd[n2], null);
            this.IPAdd[n2].setBounds(new Rectangle(n, 9, 31, 21));
            this.IPAdd[n2].setDocument(new ValidatingDocument());
            this.IPAdd[n2].getDocument().addDocumentListener(this.myDocumentListener);
            this.IPAdd[n2].getDocument().putProperty("name", "ipAdd" + n2);
            this.IPMask[n2] = new JTextField();
            this.mainPanel.add((Component)this.IPMask[n2], null);
            this.IPMask[n2].setBounds(new Rectangle(n, 40, 31, 21));
            this.IPMask[n2].setDocument(new ValidatingDocument());
            this.IPMask[n2].getDocument().addDocumentListener(this.myDocumentListener);
            this.IPMask[n2].getDocument().putProperty("name", "ipMask" + n2);
            n += 40;
            ++n2;
        }
        this.setIPAddressandMaskValues();
    }

    private void setIPAddressandMaskValues() {
        int n = 0;
        this.oldIPAddress = this.oldIPAddress.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(this.oldIPAddress, ".");
        while (stringTokenizer.hasMoreTokens()) {
            this.IPAdd[n++].setText(stringTokenizer.nextToken());
        }
        n = 0;
        this.oldIPMask = this.oldIPMask.trim();
        stringTokenizer = new StringTokenizer(this.oldIPMask, ".");
        while (stringTokenizer.hasMoreTokens()) {
            this.IPMask[n++].setText(stringTokenizer.nextToken());
        }
    }

    void OK_actionPerformed(ActionEvent actionEvent) {
        if (!this.validateIPAddressFilelds()) {
            return;
        }
        if (!this.validateIPMaskFilelds()) {
            return;
        }
        this.newIPAddress = String.valueOf(this.IPAdd[FIELD1].getText()) + "." + this.IPAdd[FIELD2].getText() + "." + this.IPAdd[FIELD3].getText() + "." + this.IPAdd[FIELD4].getText();
        this.newIPMask = String.valueOf(this.IPMask[FIELD1].getText()) + "." + this.IPMask[FIELD2].getText() + "." + this.IPMask[FIELD3].getText() + "." + this.IPMask[FIELD4].getText();
        this.changeIPAddressMask();
    }

    void Cancel_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    public String getNewIpAddress() {
        return this.newIPAddress;
    }

    public String getNewIpMask() {
        return this.newIPMask;
    }

    public boolean ipAddressChanged() {
        return this.ipAddressChanged;
    }

    public boolean ipMaskChanged() {
        return this.ipMaskChanged;
    }

    private void changeIPAddressMask() {
        this.ipAddressChanged = false;
        this.ipMaskChanged = false;
        if (!this.oldIPAddress.equals(this.newIPAddress)) {
            this.ipAddressChanged = true;
        }
        if (!this.oldIPMask.equals(this.newIPMask)) {
            this.ipMaskChanged = true;
        }
        this.dispose();
    }

    private boolean validateIPAddressFilelds() {
        int n = 0;
        while (n < NO_OF_FIELDS) {
            String string = this.IPAdd[n].getText();
            int n2 = Integer.valueOf(string);
            if (n2 < 0 || n2 > 255) {
                this.ShowErrorMessage(String.valueOf(res.getString("Invalid_IP_Address")) + res.getString("Restriction"));
                return false;
            }
            ++n;
        }
        String string = this.IPAdd[FIELD4].getText();
        int n3 = Integer.valueOf(string);
        return n3 != 0 && n3 != 255 || JOptionPane.showConfirmDialog(this.frame, res.getString("Invalid_Number_Warning"), res.getString("Warning"), 0) != 1;
    }

    private boolean validateIPMaskFilelds() {
        int n = 0;
        while (n < NO_OF_FIELDS) {
            String string = this.IPMask[n].getText();
            int n2 = Integer.valueOf(string);
            if (n2 < 0 || n2 > 255) {
                this.ShowErrorMessage(String.valueOf(res.getString("Invalid_IP_Mask")) + res.getString("Restriction"));
                return false;
            }
            ++n;
        }
        return true;
    }

    private void ShowErrorMessage(String string) {
        JOptionPane.showMessageDialog(this.frame, string, res.getString("Error"), 0);
    }

    protected class MyDocumentListener
    implements DocumentListener {
        protected MyDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.EvaluateIPAddress(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        private void EvaluateValue(int n) {
            String string = ChangeIPAddress.this.IPAdd[n].getText();
            Integer.valueOf(string).intValue();
            if (string.length() == 3) {
                if (n == 3) {
                    ChangeIPAddress.this.IPAdd[n].transferFocus();
                } else {
                    ChangeIPAddress.this.IPAdd[n + 1].selectAll();
                    ChangeIPAddress.this.IPAdd[n + 1].requestFocus();
                }
            }
        }

        private void EvaluateIPAddress(DocumentEvent documentEvent) {
            Document document = documentEvent.getDocument();
            int n = 0;
            while (n < NO_OF_FIELDS) {
                if (document.getProperty("name").equals("ipAdd" + n)) {
                    this.EvaluateValue(n);
                }
                ++n;
            }
        }
    }

    public class ValidatingDocument
    extends PlainDocument {
        int maxCharacters = 3;

        void parseValue(String string) throws NumberFormatException {
            Integer.parseInt(string);
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            String string2;
            if (string == null) {
                return;
            }
            int n2 = this.getLength();
            if (n2 == 0) {
                string2 = string;
            } else {
                string2 = this.getText(0, n2);
                if (n2 + string.length() > this.maxCharacters) {
                    Toolkit.getDefaultToolkit().beep();
                    string = "";
                } else {
                    StringBuffer stringBuffer = new StringBuffer(string2);
                    stringBuffer.insert(n, string);
                    string2 = stringBuffer.toString();
                }
            }
            try {
                this.parseValue(string2);
                super.insertString(n, string, attributeSet);
            }
            catch (NumberFormatException numberFormatException) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

