/*
 * Decompiled with CFR 0.152.
 */
package smx.utility;

import java.io.DataInput;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LittleEndianInputStream
extends FilterInputStream
implements DataInput {
    public LittleEndianInputStream(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        InputStream inputStream = this.in;
        int n = inputStream.read();
        int n2 = inputStream.read();
        if (n < 0 || n2 < 0) {
            throw new EOFException();
        }
        return n2 << 8 | n;
    }

    @Override
    public short readShort() throws IOException {
        return (short)this.readUnsignedShort();
    }

    public long readUnsignedInt() throws IOException {
        InputStream inputStream = this.in;
        int n = inputStream.read();
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        int n4 = inputStream.read();
        if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0) {
            throw new EOFException();
        }
        return n4 << 24 | n3 << 16 | n2 << 8 | n;
    }

    @Override
    public int readInt() throws IOException {
        return (int)this.readUnsignedInt();
    }

    @Override
    public long readLong() throws IOException {
        InputStream inputStream = this.in;
        long l = inputStream.read();
        long l2 = inputStream.read();
        long l3 = inputStream.read();
        long l4 = inputStream.read();
        long l5 = inputStream.read();
        long l6 = inputStream.read();
        long l7 = inputStream.read();
        long l8 = inputStream.read();
        if (l < 0L || l2 < 0L || l3 < 0L || l4 < 0L || l5 < 0L || l6 < 0L || l7 < 0L || l8 < 0L) {
            throw new EOFException();
        }
        return l8 << 56 | l7 << 48 | l6 << 40 | l5 << 32 | l4 << 24 | l3 << 16 | l2 << 8 | l;
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public int skipBytes(int n) throws IOException {
        InputStream inputStream = this.in;
        return (int)inputStream.skip(n);
    }

    @Override
    public int readUnsignedByte() throws IOException {
        InputStream inputStream = this.in;
        int n = inputStream.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    @Override
    public byte readByte() throws IOException {
        return (byte)this.readUnsignedByte();
    }

    @Override
    public char readChar() throws IOException {
        return (char)this.readUnsignedShort();
    }

    @Override
    public String readUTF() throws IOException {
        return "Unsuported";
    }

    @Override
    public String readLine() {
        return "Unsuported";
    }

    @Override
    public boolean readBoolean() throws IOException {
        InputStream inputStream = this.in;
        return 0 != inputStream.read();
    }

    @Override
    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        InputStream inputStream = this.in;
        int n3 = inputStream.read(byArray, n, n2);
        if (n3 < n2) {
            throw new EOFException();
        }
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }
}

