/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.apps4xxx.utility.tools;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import smx.tracker.TrackerException;
import smx.tracker.apps4xxx.utility.tools.Assert;
import smx.tracker.apps4xxx.utility.tools.P;

public class XTool {
    private static boolean appendToFile;
    private static boolean fileSaveError;
    private static DisplayErrorMsgInUIThread displayErrorMsgInUIThread;

    private XTool() {
    }

    public static final void putToSleep(Thread thread, int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            P.rintln("Thread interrupted while sleeping");
        }
    }

    public static final String lineSeparator() {
        return System.getProperty("line.separator");
    }

    public static final Font calculateMaxFontThatFits(JComponent jComponent, Dimension dimension) {
        JLabel jLabel = null;
        JTextField jTextField = null;
        if (jComponent instanceof JLabel) {
            jLabel = (JLabel)jComponent;
        } else if (jComponent instanceof JTextField) {
            jTextField = (JTextField)jComponent;
        }
        if (jLabel == null && jTextField == null) {
            return null;
        }
        Dimension dimension2 = jComponent.getSize();
        boolean bl = false;
        int n = 1;
        if (dimension2.getHeight() < dimension.getHeight() || dimension2.getWidth() < dimension.getWidth()) {
            n = -1;
            bl = true;
        }
        dimension.setSize(dimension2);
        Font font = jComponent.getFont();
        Dimension dimension3 = jComponent.getSize();
        double d = dimension3.getWidth() - 5.0;
        double d2 = dimension3.getHeight() - 5.0;
        dimension3 = new Dimension((int)d, (int)d2);
        double d3 = 1.0E-20;
        if (dimension3.getWidth() < d3 || dimension3.getHeight() < d3) {
            return null;
        }
        FontMetrics fontMetrics = ((Component)jComponent).getFontMetrics(font);
        String string = jLabel != null ? jLabel.getText() : jTextField.getText();
        int n2 = fontMetrics.stringWidth(string);
        int n3 = fontMetrics.getHeight();
        int n4 = font.getSize();
        Font font2 = null;
        boolean bl2 = false;
        if (bl) {
            while (n3 > (int)dimension3.getHeight() || (double)n2 > dimension3.getWidth()) {
                bl2 = true;
                font2 = new Font(font.getFontName(), font.getStyle(), n4 += n);
                FontMetrics fontMetrics2 = ((Component)jComponent).getFontMetrics(font2);
                n2 = fontMetrics2.stringWidth(string);
                n3 = fontMetrics2.getHeight();
            }
        } else {
            while (n3 < (int)dimension3.getHeight() && (double)n2 < dimension3.getWidth()) {
                bl2 = true;
                font2 = new Font(font.getFontName(), font.getStyle(), n4 += n);
                FontMetrics fontMetrics3 = ((Component)jComponent).getFontMetrics(font2);
                n2 = fontMetrics3.stringWidth(string);
                n3 = fontMetrics3.getHeight();
            }
        }
        if (bl2) {
            font2 = new Font(font.getFontName(), font.getStyle(), bl ? n4 + 2 * n : n4 - 2 * n);
        }
        return font2;
    }

    private static String[] getErrorFromException(TrackerException trackerException, String string) {
        String string2 = trackerException.getText();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
        int n = stringTokenizer.countTokens();
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(": ".concat(String.valueOf(String.valueOf(stringTokenizer.nextToken()))))));
        String string3 = new String();
        for (int i = 1; i < n; ++i) {
            string3 = String.valueOf(String.valueOf(string3)).concat(String.valueOf(String.valueOf(stringTokenizer.nextToken())));
        }
        String[] stringArray = new String[]{string, string3};
        System.out.println("code = ".concat(String.valueOf(String.valueOf(trackerException.getCode()))));
        switch (trackerException.getCode()) {
            case 5: {
                stringArray[1] = new String("Motors are turned OFF");
                break;
            }
            case 6: {
                stringArray[1] = new String("Laser is turned OFF");
                break;
            }
            case 7: {
                stringArray[1] = new String("Shutter is closed");
            }
        }
        return stringArray;
    }

    public static final void displayErrorToUser(Component component, String string, String string2) {
        JOptionPane.showMessageDialog(component, string2, string, 0);
    }

    public static final String[] displayErrorToUser(TrackerException trackerException, String string, JFrame jFrame) {
        String[] stringArray = XTool.getErrorFromException(trackerException, string);
        XTool.displayErrorToUser(jFrame, stringArray[0], stringArray[1]);
        return stringArray;
    }

    public static final String[] displayExtendedErrorToUser(TrackerException trackerException, String string, String string2, JFrame jFrame) {
        String[] stringArray = XTool.getErrorFromException(trackerException, string);
        stringArray[1] = String.valueOf(String.valueOf(stringArray[1])).concat(String.valueOf(String.valueOf(" ".concat(String.valueOf(String.valueOf(string2))))));
        XTool.displayErrorToUser(jFrame, stringArray[0], stringArray[1]);
        return stringArray;
    }

    public static final String[] extractErrorFromException(TrackerException trackerException) {
        return XTool.getErrorFromException(trackerException, "");
    }

    public static final String[] openFileOpenChooser(JFrame jFrame, String string, String string2, String string3, String string4, String string5, String string6) {
        Object object;
        UserFileFilter[] userFileFilterArray = null;
        if (string4 != null) {
            userFileFilterArray = XTool.createFileFilters(string4);
        }
        JFileChooser jFileChooser = XTool.createCustomFileChooser(string, userFileFilterArray, string2, string3);
        jFileChooser.setDialogType(0);
        if (jFileChooser.showOpenDialog(jFrame) != 0) {
            jFileChooser = null;
            return null;
        }
        File file = jFileChooser.getSelectedFile();
        if (!XTool.isValidFile(file, userFileFilterArray)) {
            if (string6 != null || string5 != null) {
                XTool.displayErrorToUser(jFrame, string5, string6);
            }
            return null;
        }
        String string7 = file.getName();
        if (string7.indexOf(46) == -1) {
            object = (UserFileFilter)jFileChooser.getFileFilter();
            string7 = String.valueOf(String.valueOf(string7)).concat(String.valueOf(String.valueOf(((UserFileFilter)object).getFileExtension())));
        }
        P.rintln(string7);
        object = file.getParent();
        String[] stringArray = new String[]{object, string7};
        return stringArray;
    }

    private static UserFileFilter[] createFileFilters(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        int n = stringTokenizer.countTokens();
        UserFileFilter[] userFileFilterArray = new UserFileFilter[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",");
            int n3 = stringTokenizer2.countTokens();
            if (n3 == 2) {
                userFileFilterArray[n2++] = new UserFileFilter(stringTokenizer2.nextToken(), stringTokenizer2.nextToken());
                continue;
            }
            if (n3 != 1) continue;
            String string3 = stringTokenizer2.nextToken();
            userFileFilterArray[n2++] = new UserFileFilter(string3, string3);
        }
        Assert.isTrue(n2 == n, "Failed to create a few filters\nPlease check the filter string");
        return userFileFilterArray;
    }

    private static JFileChooser createCustomFileChooser(String string, UserFileFilter[] userFileFilterArray, String string2, String string3) {
        JFileChooser jFileChooser = new JFileChooser();
        if (string != null) {
            jFileChooser.setDialogTitle(string);
        }
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileSelectionMode(0);
        int n = 0;
        if (userFileFilterArray != null) {
            n = userFileFilterArray.length;
        }
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                jFileChooser.addChoosableFileFilter(userFileFilterArray[i]);
            }
        }
        if (string2 != null && string3 != null) {
            jFileChooser.setSelectedFile(new File(string3, string2));
        } else if (string3 != null) {
            jFileChooser.setCurrentDirectory(new File(string3));
        }
        return jFileChooser;
    }

    private static boolean isValidFile(File file, UserFileFilter[] userFileFilterArray) {
        if (userFileFilterArray == null) {
            return true;
        }
        int n = userFileFilterArray.length;
        for (int i = 0; i < n; ++i) {
            if (userFileFilterArray[i] == null || !userFileFilterArray[i].accept(file)) continue;
            return true;
        }
        String string = file.getName().toLowerCase();
        return string.indexOf(46) == -1;
    }

    public static void saveResults(JFrame jFrame, String string, String string2, boolean bl, String string3, String string4) {
        SaveResultsThread saveResultsThread = new SaveResultsThread(jFrame, string, string2, bl, string3, string4);
    }

    public static final boolean isDataAppended() {
        return appendToFile;
    }

    public static final String[] openFileSaveAsChooser(JFrame jFrame, String string, String string2, String string3, boolean bl, String string4, String string5, String string6, String string7, String string8, String string9, String string10) {
        String[] stringArray = XTool.openFileSaveAsChooser(jFrame, string, string3, bl, string4, string5, string6, string7, string8);
        if (stringArray == null) {
            return null;
        }
        if (string2 != null) {
            XTool.saveResults(jFrame, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(stringArray[0]))).append(File.separator).append(stringArray[1]))), string2, appendToFile, string9, string10);
        }
        return stringArray;
    }

    public static final String[] openFileSaveAsChooser(JFrame jFrame, String string, String string2, boolean bl, String string3, String string4, String string5, String string6, String string7) {
        Object object;
        appendToFile = false;
        UserFileFilter[] userFileFilterArray = XTool.createFileFilters(string5);
        Assert.isTrue(userFileFilterArray != null, "Failed to create file even a single file filters\nPlease check the filter string");
        final JFileChooser jFileChooser = XTool.createCustomFileChooser(string, userFileFilterArray, string3, string4);
        jFileChooser.setDialogType(1);
        final JPanel jPanel = new JPanel();
        JCheckBox jCheckBox = new JCheckBox(string2);
        jCheckBox.setSelected(bl);
        Component component = Box.createHorizontalStrut(8);
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        jPanel.add(component, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        jPanel.setPreferredSize(new Dimension(100, 45));
        jFileChooser.setPreferredSize(new Dimension(450, 300));
        jFileChooser.setMinimumSize(new Dimension(450, 300));
        jFileChooser.setMaximumSize(new Dimension(450, 300));
        final String string8 = string2;
        jFileChooser.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (string8 != null) {
                    jFileChooser.getParent().add((Component)jPanel, "South");
                }
            }
        });
        if (jFileChooser.showSaveDialog(jFrame) != 0) {
            if (string2 != null) {
                jFileChooser.remove(jPanel);
            }
            return null;
        }
        File file = jFileChooser.getSelectedFile();
        if (!XTool.isValidFile(file, userFileFilterArray)) {
            if (string7 != null || string6 != null) {
                XTool.displayErrorToUser(jFrame, string6, string7);
            }
            jFileChooser.remove(jPanel);
            return null;
        }
        appendToFile = jCheckBox.isSelected();
        String string9 = file.getName();
        if (string9.indexOf(46) == -1) {
            object = (UserFileFilter)jFileChooser.getFileFilter();
            string9 = String.valueOf(String.valueOf(string9)).concat(String.valueOf(String.valueOf(((UserFileFilter)object).getFileExtension())));
        }
        object = file.getParent();
        jFileChooser.remove(jPanel);
        String[] stringArray = new String[]{object, string9};
        return stringArray;
    }

    static {
        fileSaveError = false;
        displayErrorMsgInUIThread = new DisplayErrorMsgInUIThread();
    }

    private static class DisplayErrorMsgInUIThread
    implements Runnable {
        private JFrame frame;
        private String fileOpenErrorTitle;
        private String fileOpenErrorMessage;

        private DisplayErrorMsgInUIThread() {
        }

        public void displayErrorMsg(JFrame jFrame, String string, String string2) {
            this.frame = jFrame;
            this.fileOpenErrorTitle = string;
            this.fileOpenErrorMessage = string2;
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            XTool.displayErrorToUser(this.frame, this.fileOpenErrorTitle, this.fileOpenErrorMessage);
        }
    }

    private static class SaveResultsThread
    extends Thread {
        private String filePath;
        private String data;
        private String fileOpenErrorTitle;
        private String fileOpenErrorMessage;
        private boolean append;
        private JFrame frame;

        SaveResultsThread(JFrame jFrame, String string, String string2, boolean bl, String string3, String string4) {
            super("Save Results Thread");
            this.frame = jFrame;
            this.filePath = string;
            this.data = string2;
            this.append = bl;
            this.fileOpenErrorTitle = string3;
            this.fileOpenErrorMessage = string4;
            this.start();
        }

        public void run() {
            try {
                PrintWriter printWriter = new PrintWriter((Writer)new BufferedWriter(new FileWriter(this.filePath, this.append)), true);
                printWriter.write(this.data);
                printWriter.close();
                fileSaveError = false;
            }
            catch (IOException iOException) {
                fileSaveError = true;
                displayErrorMsgInUIThread.displayErrorMsg(this.frame, this.fileOpenErrorTitle, this.fileOpenErrorMessage);
            }
        }
    }

    private static class UserFileFilter
    extends FileFilter {
        private String fileExtension;
        private String fileType;

        UserFileFilter(String string, String string2) {
            this.fileType = string;
            this.fileExtension = string2;
        }

        public String getDescription() {
            return this.fileType;
        }

        public String getFileExtension() {
            return this.fileExtension;
        }

        public boolean accept(File file) {
            if (file == null) {
                return false;
            }
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName().toLowerCase();
            return string.endsWith(this.fileExtension);
        }
    }
}

