/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.apps4xxx.trackerpad;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.TooManyListenersException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import smx.tracker.DataTag;
import smx.tracker.DataTagDouble;
import smx.tracker.DataTagUnsigned16;
import smx.tracker.MeasureData;
import smx.tracker.Tracker;
import smx.tracker.TrackerException;
import smx.tracker.apps4xxx.trackerpad.DriveOptUtil;
import smx.tracker.apps4xxx.trackerpad.TrackerPad;
import smx.tracker.apps4xxx.trackerpad.TrackerPadThread;
import smx.tracker.apps4xxx.utility.GlassComponent;
import smx.tracker.apps4xxx.utility.ThreadListener;
import smx.tracker.event.FactoryBkndMeasureDataEvent;
import smx.tracker.event.FactoryBkndMeasureDataListener;
import smx.utility.UnitsConversion;

public class VisualDrive
extends JDialog {
    private static final int UPDATE_RATE = 100;
    private TrackerPadThread padThread;
    private Timer timer;
    private double horizontalVelocity = 0.0;
    private double verticalVelocity = 0.0;
    private int xCenter;
    private int yCenter;
    private boolean timerStopFlag = false;
    private boolean initialVelocitySet = false;
    private boolean backsightMode = false;
    private UnitsConversion lengthUnits = null;
    private UnitsConversion angularUnits = null;
    private Frame frame = null;
    private BkndMeasureData bkndListener = new BkndMeasureData();
    private MeasureData[] dataDisplayed = null;
    private double az = 0.0;
    private double ze = 0.0;
    private int azStatus = 0;
    private int zeStatus = 0;
    private Tracker trk = null;
    private boolean error = false;
    private boolean searchInProgress = false;
    private highlightCmdComplete highlightListener = new highlightCmdComplete();
    JPanel panel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel buttonPanel = new JPanel();
    JButton closeButton = new JButton();
    JPanel dragPanel = new JPanel();
    Border border1;
    TitledBorder titledBorder1;
    JLabel centerLabel = new JLabel();
    BorderLayout borderLayout2 = new BorderLayout();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JTextField azReading = new JTextField();
    JTextField zeReading = new JTextField();
    JButton searchButton = new JButton();
    JLabel azUnit = new JLabel();
    JLabel zeUnit = new JLabel();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JButton HighlightBeam = new JButton();
    GridBagLayout gridBagLayout3 = new GridBagLayout();

    private void updateDisplay(FactoryBkndMeasureDataEvent factoryBkndMeasureDataEvent) {
        try {
            this.dataDisplayed = this.trk.readFactoryBkndMeasureData(factoryBkndMeasureDataEvent.getNumMeasurements());
            if (this.error) {
                return;
            }
            if (this.searchInProgress) {
                return;
            }
            this.az = Math.IEEEremainder((Double)this.dataDisplayed[0].getDataElement(0), 1296000.0);
            this.az = Math.toRadians(this.az / (double)3600);
            this.azStatus = (Integer)this.dataDisplayed[0].getDataElement(1);
            this.ze = Math.IEEEremainder((Double)this.dataDisplayed[0].getDataElement(2), 1296000.0);
            this.ze = Math.toRadians(this.ze / (double)3600);
            this.zeStatus = (Integer)this.dataDisplayed[0].getDataElement(3);
            if ((this.azStatus & 2) != 0 || (this.zeStatus & 2) != 0) {
                this.error = true;
                JOptionPane.showConfirmDialog(this, TrackerPad.res.getString("Encoder_Error"), TrackerPad.res.getString("Error"), 0, 0);
                this.stopBkndMeasure();
                this.dispose();
                return;
            }
            this.azReading.setText(this.angularUnits.convertToDisplayStr(this.az));
            this.zeReading.setText(this.angularUnits.convertToDisplayStr(this.ze));
        }
        catch (TrackerException trackerException) {
            trackerException.printStackTrace();
        }
    }

    public void restoreCursor() {
        GlassComponent.setWaitState(false, this);
    }

    public void setCursor() {
        GlassComponent.setWaitState(true, this);
    }

    public void setSearchInProgressFlag(boolean bl) {
        this.searchInProgress = bl;
    }

    public VisualDrive(Frame frame, String string, boolean bl, boolean bl2, UnitsConversion unitsConversion, UnitsConversion unitsConversion2, Tracker tracker, TrackerPadThread trackerPadThread) {
        super(frame, string, bl);
        this.frame = frame;
        this.padThread = trackerPadThread;
        this.backsightMode = bl2;
        this.lengthUnits = unitsConversion;
        this.angularUnits = unitsConversion2;
        this.trk = tracker;
        this.setGlassPane(new GlassComponent());
        try {
            this.jbInit();
            this.pack();
            this.setLocationRelativeTo(frame);
            this.timer = new Timer(100, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    VisualDrive.this.onTimer(actionEvent);
                }
            });
            this.startBkndMeasure(this.bkndListener);
            ((Component)this).setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.border1 = new EtchedBorder(0, Color.white, new Color(134, 134, 134));
        this.titledBorder1 = new TitledBorder(this.border1, TrackerPad.res.getString("Drag_Move_Beam"));
        this.closeButton.setText(TrackerPad.res.getString("Close"));
        this.jLabel1.setText(TrackerPad.res.getString("Az"));
        this.jLabel2.setText(TrackerPad.res.getString("Ze"));
        this.searchButton.setText(TrackerPad.res.getString("Search"));
        this.azUnit.setText(TrackerPad.res.getString("Radians"));
        this.zeUnit.setText(TrackerPad.res.getString("Radians"));
        this.HighlightBeam.setText(TrackerPad.res.getString("Highlight_Beam"));
        this.addWindowListener(new VisualDrive_this_windowAdapter(this, this));
        this.panel1.setLayout(this.borderLayout1);
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VisualDrive.this.closeButton_actionPerformed(actionEvent);
            }
        });
        this.dragPanel.setBorder(this.titledBorder1);
        this.dragPanel.setMinimumSize(new Dimension(400, 400));
        this.dragPanel.setPreferredSize(new Dimension(400, 400));
        this.dragPanel.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                VisualDrive.this.dragPanel_mouseDragged(mouseEvent);
            }
        });
        this.dragPanel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                VisualDrive.this.dragPanel_mousePressed(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                VisualDrive.this.dragPanel_mouseReleased(mouseEvent);
            }
        });
        this.dragPanel.setLayout(this.borderLayout2);
        this.centerLabel.setFont(new Font("Dialog", 0, 20));
        this.centerLabel.setHorizontalAlignment(0);
        this.centerLabel.setText("+");
        this.buttonPanel.setPreferredSize(new Dimension(450, 180));
        this.buttonPanel.setLayout(this.gridBagLayout1);
        this.jLabel1.setFont(new Font("SansSerif", 1, 22));
        this.jLabel2.setFont(new Font("SansSerif", 1, 22));
        this.azReading.setEnabled(false);
        this.azReading.setFont(new Font("SansSerif", 1, 22));
        this.azReading.setDisabledTextColor(Color.black);
        this.azReading.setEditable(false);
        this.zeReading.setEnabled(false);
        this.zeReading.setFont(new Font("SansSerif", 1, 22));
        this.zeReading.setDisabledTextColor(Color.black);
        this.zeReading.setEditable(false);
        if (this.angularUnits.displayName().equals(TrackerPad.res.getString("Angular_Degree_Symbol"))) {
            this.azUnit.setFont(new Font("Dialog", 1, 21));
            this.zeUnit.setFont(new Font("Dialog", 1, 21));
        }
        this.azUnit.setText(this.angularUnits.displayName());
        this.zeUnit.setText(this.angularUnits.displayName());
        this.searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VisualDrive.this.searchButton_actionPerformed(actionEvent);
            }
        });
        this.panel1.setPreferredSize(new Dimension(450, 510));
        this.jPanel1.setLayout(this.gridBagLayout2);
        this.jPanel2.setLayout(this.gridBagLayout3);
        this.HighlightBeam.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VisualDrive.this.HighlightBeam_actionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.buttonPanel, "South");
        this.buttonPanel.add((Component)this.jPanel1, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 6, 2), 413, 40));
        this.jPanel1.add((Component)this.zeUnit, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(2, 6, 4, 10), 0, 0));
        this.jPanel1.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(8, 25, 2, 2), 4, 20));
        this.jPanel1.add((Component)this.jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 25, 4, 2), 2, 20));
        this.jPanel1.add((Component)this.azUnit, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(8, 6, 2, 10), 0, 0));
        this.jPanel1.add((Component)this.azReading, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(8, 2, 2, 2), 166, 16));
        this.jPanel1.add((Component)this.zeReading, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 2, 4, 2), 166, 16));
        this.buttonPanel.add((Component)this.jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 264, 55));
        this.jPanel2.add((Component)this.closeButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(8, 0, 4, 59), 0, 0));
        this.jPanel2.add((Component)this.searchButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(8, 57, 4, 0), 0, 0));
        this.jPanel2.add((Component)this.HighlightBeam, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(8, 0, 4, 0), 3, 0));
        this.panel1.add((Component)this.dragPanel, "Center");
        this.dragPanel.add((Component)this.centerLabel, "Center");
    }

    private void onTimer(ActionEvent actionEvent) {
        if (this.timerStopFlag && this.initialVelocitySet) {
            this.horizontalVelocity = 0.0;
            this.verticalVelocity = 0.0;
            this.timer.stop();
            this.closeButton.setEnabled(true);
        }
        this.initialVelocitySet = true;
        Object[] objectArray = new Object[]{new Integer(12), new Integer(0), new Double(this.horizontalVelocity), new Double(this.verticalVelocity)};
        this.padThread.sendCommand(objectArray);
        this.padThread.receiveResponse();
    }

    private void calculateVelocity(int n, int n2) {
        this.horizontalVelocity = (double)(-(n - this.xCenter)) / 500.0 * 1.570796;
        this.verticalVelocity = (double)(n2 - this.yCenter) / 500.0 * 1.570796;
        if (this.backsightMode) {
            this.verticalVelocity = -this.verticalVelocity;
        }
    }

    void dragPanel_mousePressed(MouseEvent mouseEvent) {
        if (!this.timer.isRunning()) {
            this.xCenter = this.dragPanel.getX() + this.dragPanel.getWidth() / 2;
            this.yCenter = this.dragPanel.getY() + this.dragPanel.getHeight() / 2;
            this.calculateVelocity(mouseEvent.getX(), mouseEvent.getY());
            this.initialVelocitySet = false;
            this.timerStopFlag = false;
            this.closeButton.setEnabled(false);
            this.timer.start();
        }
    }

    void dragPanel_mouseReleased(MouseEvent mouseEvent) {
        this.timerStopFlag = true;
    }

    void dragPanel_mouseDragged(MouseEvent mouseEvent) {
        this.calculateVelocity(mouseEvent.getX(), mouseEvent.getY());
    }

    void doClose() {
        this.stopBkndMeasure();
        this.timer = null;
        this.padThread = null;
        this.dispose();
    }

    void closeButton_actionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    void this_windowClosing(WindowEvent windowEvent) {
        this.doClose();
    }

    void searchButton_actionPerformed(ActionEvent actionEvent) {
        DriveOptUtil.setParentDialog(this);
        DriveOptUtil.searchTarget(this.padThread, this.frame, this.trk, this.lengthUnits);
    }

    private void startBkndMeasure(FactoryBkndMeasureDataListener factoryBkndMeasureDataListener) {
        DataTag[] dataTagArray = new DataTag[]{new DataTagDouble("az_motor_in.output"), new DataTagUnsigned16("az_motor_in.status"), new DataTagDouble("el_motor_in.output"), new DataTagUnsigned16("el_motor_in.status")};
        Object[] objectArray = DriveOptUtil.startBkndMeasure(this.padThread, dataTagArray, factoryBkndMeasureDataListener);
        if (objectArray[0] != null) {
            JOptionPane.showMessageDialog(this, TrackerPad.res.getString("Start_Measure_Failure"), TrackerPad.res.getString("Error"), 0);
            this.dispose();
        }
    }

    private void stopBkndMeasure() {
        Object[] objectArray = DriveOptUtil.stopBkndMeasure(this.padThread, this.bkndListener);
        if (objectArray[0] != null) {
            JOptionPane.showMessageDialog(this, TrackerPad.res.getString("Stop_Measure_Failure"), TrackerPad.res.getString("Error"), 0);
        }
    }

    void HighlightBeam_actionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = new Object[]{new Integer(25), new Integer(0)};
        try {
            this.padThread.addThreadListener(this.highlightListener);
        }
        catch (TooManyListenersException tooManyListenersException) {
            JOptionPane.showMessageDialog(this, TrackerPad.res.getString("Too_Many_Listener"), TrackerPad.res.getString("Internal_Error"), 0);
            return;
        }
        this.setCursor();
        this.padThread.sendCommand(objectArray);
    }

    static {
        UPDATE_RATE = 100;
    }

    private class BkndMeasureData
    implements FactoryBkndMeasureDataListener,
    Runnable {
        FactoryBkndMeasureDataEvent data;

        private BkndMeasureData() {
        }

        public void dataAvailable(FactoryBkndMeasureDataEvent factoryBkndMeasureDataEvent) {
            this.data = factoryBkndMeasureDataEvent;
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            VisualDrive.this.updateDisplay(this.data);
        }
    }

    class VisualDrive_this_windowAdapter
    extends WindowAdapter {
        VisualDrive adaptee;

        VisualDrive_this_windowAdapter(VisualDrive visualDrive, VisualDrive visualDrive2) {
            this.adaptee = visualDrive2;
        }

        public void windowClosing(WindowEvent windowEvent) {
            this.adaptee.this_windowClosing(windowEvent);
        }
    }

    private class highlightCmdComplete
    implements ThreadListener,
    Runnable {
        private highlightCmdComplete() {
        }

        public void commandComplete() {
            VisualDrive.this.padThread.removeThreadListener(this);
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            Object[] objectArray = VisualDrive.this.padThread.receiveResponse();
            VisualDrive.this.restoreCursor();
        }
    }
}

