/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.apps4xxx.trackerpad;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import smx.tracker.apps4xxx.trackerpad.DriveOptUtil;
import smx.tracker.apps4xxx.trackerpad.TrackerPad;
import smx.utility.UnitsConversion;

public class SearchCfg
extends JDialog {
    private static final double DEFAULT_RADIUS = 0.02;
    private static final double MINIMUM_RANGE = 0.2;
    private boolean shouldSearch = false;
    private double radius;
    private double range;
    private UnitsConversion lengthUnits;
    private Object tempMinRange = null;
    JPanel panel1 = new JPanel();
    JLabel jLabel1 = new JLabel();
    JTextField radiusText = new JTextField();
    JLabel unitsText1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JTextField estimatedRange = new JTextField();
    JLabel unitsText2 = new JLabel();
    JPanel jPanel1 = new JPanel();
    GridLayout gridLayout2 = new GridLayout();
    BorderLayout borderLayout1 = new BorderLayout();
    JCheckBox useRange = new JCheckBox();
    JPanel jPanel2 = new JPanel();
    JButton cancelButton = new JButton();
    JButton searchButton = new JButton();

    public SearchCfg(Frame frame, String string, boolean bl, UnitsConversion unitsConversion, Object[] objectArray) {
        super(frame, string, bl);
        try {
            this.jbInit();
            this.range = (Double)objectArray[0] / 1000000.0;
            this.range = Math.max(this.range, 0.2);
            this.lengthUnits = unitsConversion;
            this.unitsText1.setText(unitsConversion.displayName());
            this.unitsText2.setText(unitsConversion.displayName());
            this.estimatedRange.setText(unitsConversion.convertToDisplayStr(this.range));
            this.tempMinRange = new Double(unitsConversion.convertToDisplayStr(0.2));
            this.radiusText.setText(unitsConversion.convertToDisplayStr(0.02));
            this.pack();
            this.setLocationRelativeTo(frame);
            ((Component)this).setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.panel1.setLayout(this.borderLayout1);
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setLabelFor(this.radiusText);
        this.radiusText.setHorizontalAlignment(4);
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setLabelFor(this.estimatedRange);
        if (DriveOptUtil.getUseEstimatedRangeFlag()) {
            this.estimatedRange.setEnabled(true);
            this.useRange.setSelected(true);
        } else {
            this.estimatedRange.setEnabled(false);
            this.useRange.setSelected(false);
        }
        this.estimatedRange.setHorizontalAlignment(4);
        this.jPanel1.setLayout(this.gridLayout2);
        this.jLabel1.setText(TrackerPad.res.getString("Radius"));
        this.unitsText1.setText(TrackerPad.res.getString("Meters_Small_Case"));
        this.jLabel2.setText(TrackerPad.res.getString("Estimated_Range"));
        this.unitsText2.setText(TrackerPad.res.getString("Meters_Small_Case"));
        this.useRange.setText(TrackerPad.res.getString("Use_Estimated_Range"));
        this.cancelButton.setText(TrackerPad.res.getString("Cancel"));
        this.searchButton.setText(TrackerPad.res.getString("SearchT"));
        this.useRange.setHorizontalAlignment(0);
        this.useRange.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchCfg.this.useRange_actionPerformed(actionEvent);
            }
        });
        this.gridLayout2.setColumns(3);
        this.gridLayout2.setRows(2);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchCfg.this.cancelButton_actionPerformed(actionEvent);
            }
        });
        this.searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchCfg.this.searchButton_actionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.jPanel1, "North");
        this.jPanel1.add((Component)this.jLabel1, null);
        this.jPanel1.add((Component)this.radiusText, null);
        this.jPanel1.add((Component)this.unitsText1, null);
        this.jPanel1.add((Component)this.jLabel2, null);
        this.jPanel1.add((Component)this.estimatedRange, null);
        this.jPanel1.add((Component)this.unitsText2, null);
        this.panel1.add((Component)this.useRange, "Center");
        this.panel1.add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.searchButton, null);
        this.jPanel2.add((Component)this.cancelButton, null);
    }

    private void searchButton_actionPerformed(ActionEvent actionEvent) {
        int n;
        String string = "";
        char[] cArray = null;
        Object object = new Object();
        string = this.radiusText.getText().trim();
        cArray = string.toCharArray();
        try {
            for (n = 0; n < cArray.length; ++n) {
                if (!Character.isLetter(cArray[n])) continue;
                throw new ParseException("", n);
            }
            object = new Double(TrackerPad.form.parse(string).doubleValue());
        }
        catch (ParseException parseException) {
            JOptionPane.showMessageDialog(this, TrackerPad.res.getString("Enter_Number"), TrackerPad.res.getString("Error"), 0);
            return;
        }
        this.radius = (Double)object;
        this.radius = this.lengthUnits.convertFrom(this.radius);
        if (this.radius <= 0.0) {
            JOptionPane.showMessageDialog(this, TrackerPad.res.getString("Radius_Validate"), TrackerPad.res.getString("User_Entry_Error"), 0);
            return;
        }
        if (this.useRange.isSelected()) {
            string = this.estimatedRange.getText().trim();
            cArray = string.toCharArray();
            try {
                for (n = 0; n < cArray.length; ++n) {
                    if (!Character.isLetter(cArray[n])) continue;
                    throw new ParseException("", n);
                }
                object = new Double(TrackerPad.form.parse(string).doubleValue());
            }
            catch (ParseException parseException) {
                JOptionPane.showMessageDialog(this, TrackerPad.res.getString("Enter_Number"), TrackerPad.res.getString("Error"), 0);
                return;
            }
            this.range = (Double)object;
            this.range = this.lengthUnits.convertFrom(this.range);
            double d = (Double)this.tempMinRange;
            d = this.lengthUnits.convertFrom(d);
            if (this.range < d) {
                TrackerPad.formatter.applyPattern(TrackerPad.res.getString("Range_Validate_Template"));
                Object[] objectArray = new Object[]{new String("".concat(String.valueOf(String.valueOf(this.lengthUnits.convertTo(0.2)))))};
                String string2 = TrackerPad.formatter.format(objectArray);
                JOptionPane.showMessageDialog(this, string2, TrackerPad.res.getString("User_Entry_Error"), 0);
                return;
            }
        }
        this.shouldSearch = true;
        this.dispose();
    }

    private void cancelButton_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    void useRange_actionPerformed(ActionEvent actionEvent) {
        this.estimatedRange.setEnabled(this.useRange.isSelected());
    }

    public boolean paramsSet() {
        return this.shouldSearch;
    }

    public double searchRadius() {
        return this.radius;
    }

    public double estimatedRange() {
        if (this.useRange.isSelected()) {
            return this.range;
        }
        return 0.0;
    }

    public boolean useEstimatedRange() {
        return this.useRange.isSelected();
    }

    static {
        DEFAULT_RADIUS = 0.02;
        MINIMUM_RANGE = 0.2;
    }
}

