/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.apps4xxx.startupchecks;

import java.io.IOException;
import java.util.TooManyListenersException;
import smx.tracker.AverageFilter;
import smx.tracker.ContinueTrigger;
import smx.tracker.DataTag;
import smx.tracker.DataTagUnsigned16;
import smx.tracker.DataTagUnsigned32;
import smx.tracker.Filter;
import smx.tracker.InterfaceBusyException;
import smx.tracker.IntervalTrigger;
import smx.tracker.MeasureCfg;
import smx.tracker.NullStartTrigger;
import smx.tracker.StartTrigger;
import smx.tracker.Tracker;
import smx.tracker.TrackerException;
import smx.tracker.apps4xxx.utility.ThreadListener;
import smx.tracker.event.FactoryBkndMeasureDataListener;
import smx.utility.ThreadComm;

public class StartupChecksThread
implements Runnable {
    private Tracker trk = null;
    private ThreadListener listener = null;
    private boolean hasExclusiveAccess = false;
    private boolean shutdownFlag = false;
    private boolean commandInProgress = false;
    private boolean oldBlockSetting = false;
    private ThreadComm command = new ThreadComm();
    private ThreadComm response = new ThreadComm();
    public static final int NULL_COMMAND = 0;
    public static final int STOP_BKND_MEASURE = 1;
    public static final int TURN_MOTOR_ON = 2;
    public static final int TURN_LASER_ON = 3;
    public static final int INITIALIZE = 4;
    public static final int PREPARE = 5;
    public static final int HOME = 6;
    public static final int SHUT_DOWN = 7;
    public static final int OPEN_SHUTTER = 8;
    public static final int DARK_LEVEL = 9;
    private final int SAMPLE_RATE = 1;
    private final double BKND_DATA_LISTENER_RATE = 0.25;

    public StartupChecksThread(Tracker tracker, ThreadListener threadListener) {
        Thread thread = new Thread((Runnable)this, "Startup Checks Thread");
        thread.setDaemon(true);
        this.trk = tracker;
        this.listener = threadListener;
        thread.start();
    }

    public void run() {
        int n = 0;
        Object[] objectArray = new Object[]{null, null, null};
        this.oldBlockSetting = this.trk.getBlocking();
        try {
            this.setExclusiveAccess();
            this.trk.setBlocking(true);
        }
        catch (TrackerException trackerException) {
            objectArray[0] = trackerException;
        }
        try {
            this.response.send(objectArray);
            if (this.listener != null) {
                this.listener.commandComplete();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (objectArray[0] != null) {
            return;
        }
        while (!this.shutdownFlag) {
            StartupChecksThread startupChecksThread;
            try {
                Object[] objectArray2;
                this.command.browse();
                startupChecksThread = this;
                synchronized (startupChecksThread) {
                    objectArray2 = this.command.receive();
                    this.commandInProgress = true;
                    n = (Integer)objectArray2[0];
                    objectArray = new Object[]{null, null, null};
                }
                if (n != 0 && !this.hasExclusiveAccess) {
                    this.setExclusiveAccess();
                    this.oldBlockSetting = this.trk.getBlocking();
                    this.trk.setBlocking(true);
                }
                switch (n) {
                    case 5: {
                        this.prepare((FactoryBkndMeasureDataListener)objectArray2[1]);
                        break;
                    }
                    case 1: {
                        this.stopBkndMeasurement((FactoryBkndMeasureDataListener)objectArray2[1]);
                        break;
                    }
                    case 2: {
                        this.motorOn();
                        break;
                    }
                    case 3: {
                        this.changeLaserState((Boolean)objectArray2[1]);
                        break;
                    }
                    case 4: {
                        this.initialize();
                        break;
                    }
                    case 6: {
                        this.trk.home(false);
                        break;
                    }
                    case 8: {
                        this.trk.command("shutter open", 6000);
                        try {
                            Thread.currentThread();
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        break;
                    }
                    case 9: {
                        this.trk.command("calibrate darklev", 6000);
                        break;
                    }
                    case 7: {
                        this.shutDownThread();
                        break;
                    }
                    default: {
                        throw new TrackerException("Thread received unexpected command");
                    }
                }
            }
            catch (TrackerException trackerException) {
                objectArray[0] = trackerException;
            }
            catch (IOException iOException) {
                if (this.shutdownFlag) break;
                iOException.printStackTrace();
            }
            startupChecksThread = this;
            synchronized (startupChecksThread) {
                this.commandInProgress = false;
                try {
                    this.response.send(objectArray);
                    if (this.shutdownFlag) {
                        this.response.close();
                    }
                    if (this.listener != null) {
                        this.listener.commandComplete();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public void addThreadListener(ThreadListener threadListener) throws TooManyListenersException {
        if (this.listener != null) {
            throw new TooManyListenersException();
        }
        this.listener = threadListener;
    }

    public void removeThreadListener(ThreadListener threadListener) {
        if (threadListener == this.listener) {
            this.listener = null;
        }
    }

    private void setExclusiveAccess() throws TrackerException {
        int n;
        for (n = 0; n < 10; ++n) {
            try {
                this.trk.setExclusiveAccess();
                break;
            }
            catch (InterfaceBusyException interfaceBusyException) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        if (n == 10) {
            this.trk.setExclusiveAccess();
        }
        this.hasExclusiveAccess = true;
    }

    private void clearExclusiveAccess() throws TrackerException {
        this.trk.clearExclusiveAccess();
        this.hasExclusiveAccess = false;
    }

    private void prepare(FactoryBkndMeasureDataListener factoryBkndMeasureDataListener) throws TrackerException {
        long l;
        long l2;
        DataTag[] dataTagArray = null;
        dataTagArray = new DataTag[]{new DataTagUnsigned32("laser.int_output"), new DataTagUnsigned32("motor_state.int_output"), new DataTagUnsigned32("shutter_state.int_output")};
        Object[] objectArray = this.trk.readOneTimeData(dataTagArray);
        long l3 = (Long)objectArray[0];
        if (l3 == (long)3) {
            this.trk.command("laser off", 6000);
            l3 = 0L;
        }
        if (l3 == (long)0) {
            this.trk.command("laser on", 6000);
        }
        if ((l2 = ((Long)objectArray[1]).longValue()) == (long)0) {
            this.trk.command("servo on", 6000);
        }
        if ((l = ((Long)objectArray[2]).longValue()) == (long)0) {
            this.trk.command("shutter open", 6000);
        }
        dataTagArray = new DataTag[]{new DataTagUnsigned32("laser.int_output"), new DataTagUnsigned32("motor_state.int_output"), new DataTagUnsigned32("shutter_state.int_output"), new DataTagUnsigned16("az_motor_in.status"), new DataTagUnsigned16("el_motor_in.status")};
        this.trk.setFactoryBkndMeasureBlocking(true);
        this.trk.addFactoryBkndMeasureDataListener(factoryBkndMeasureDataListener);
        this.trk.startFactoryBkndMeasure(new MeasureCfg(1, (Filter)new AverageFilter(), (StartTrigger)new NullStartTrigger(), (ContinueTrigger)new IntervalTrigger(0.25)), dataTagArray);
    }

    private void stopBkndMeasurement(FactoryBkndMeasureDataListener factoryBkndMeasureDataListener) throws TrackerException {
        this.trk.removeFactoryBkndMeasureDataListener(factoryBkndMeasureDataListener);
        this.trk.stopFactoryBkndMeasure();
    }

    private void motorOn() throws TrackerException {
        this.trk.changeMotorState(true);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void changeLaserState(boolean bl) throws TrackerException {
        if (bl) {
            this.trk.command("laser off", 6000);
            this.trk.command("laser on", 6000);
        } else {
            this.trk.command("laser on", 6000);
        }
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void initialize() throws TrackerException {
        this.trk.initialize();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void sendCommand(Object[] objectArray) {
        try {
            this.response.flush();
            this.command.send(objectArray);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Object[] receiveResponse() {
        try {
            Object[] objectArray = this.response.receive();
            return objectArray;
        }
        catch (IOException iOException) {
            Object[] objectArray = null;
            return objectArray;
        }
    }

    private void shutDownThread() throws TrackerException {
        this.shutdownFlag = true;
        this.command.close();
        if (this.hasExclusiveAccess) {
            this.trk.setBlocking(this.oldBlockSetting);
            this.clearExclusiveAccess();
        }
    }

    public void abortCmdInProgress() {
        for (int i = 0; i < 5 && this.commandInProgress; ++i) {
            this.trk.abort();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static {
        NULL_COMMAND = 0;
        STOP_BKND_MEASURE = 1;
        TURN_MOTOR_ON = 2;
        TURN_LASER_ON = 3;
        INITIALIZE = 4;
        PREPARE = 5;
        HOME = 6;
        SHUT_DOWN = 7;
        OPEN_SHUTTER = 8;
        DARK_LEVEL = 9;
    }
}

