/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.apps4xxx.operationalchecks;

import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import smx.tracker.AverageFilter;
import smx.tracker.ContinueTrigger;
import smx.tracker.DataTag;
import smx.tracker.DataTagDouble;
import smx.tracker.DataTagUnsigned16;
import smx.tracker.DataTagUnsigned32;
import smx.tracker.DistanceMode;
import smx.tracker.ExtTempType;
import smx.tracker.Filter;
import smx.tracker.InterferometerOnly;
import smx.tracker.InterferometerSetByADM;
import smx.tracker.IntervalTrigger;
import smx.tracker.MeasureCfg;
import smx.tracker.NullStartTrigger;
import smx.tracker.SMRTargetType;
import smx.tracker.StartTrigger;
import smx.tracker.TargetType;
import smx.tracker.Tracker;
import smx.tracker.TrackerException;
import smx.tracker.apps4xxx.operationalchecks.OperationalChecks;
import smx.tracker.apps4xxx.utility.ClosureMath;
import smx.tracker.apps4xxx.utility.ThreadListener;
import smx.tracker.apps4xxx.utility.TrackerAppCommandThread;
import smx.tracker.apps4xxx.utility.TrackerAppException;
import smx.tracker.apps4xxx.utility.XMath;
import smx.tracker.apps4xxx.utility.tools.Assert;
import smx.tracker.apps4xxx.utility.tools.P;
import smx.tracker.event.BusyListener;
import smx.tracker.event.FactoryBkndMeasureDataListener;
import smx.tracker.event.MeasureDataListener;

class OpChecksThread
extends TrackerAppCommandThread
implements Runnable {
    public static final int HOME = 1;
    public static final int BACKSIGHT = 2;
    public static final int TRACKING = 3;
    public static final int MOTORS = 4;
    public static final int INITIALIZE = 5;
    public static final int MEASURE = 6;
    public static final int START_FACTORY_BKND_MEASUREMENT = 7;
    public static final int STOP_FACTORY_BKND_MEASUREMENT = 8;
    public static final int START_CLOSURE_REPEAT_TEST = 9;
    public static final int START_STATIC_REPEAT_TEST = 10;
    public static final int START_DYNAMIC_REPEAT_TEST = 11;
    public static final int START_BACKSIGHT_TEST = 12;
    public static final int STOP_TEST = 13;
    public static final int START_ADM_TEST = 14;
    public static final int ADM_TEST_MEASURE = 15;
    public static final int STOP_ADM_TEST = 16;
    public static final int READ_ONE_TIME_DATA = 17;
    public static final int WRITE_ONE_TIME_DATA = 18;
    public static final int START_FACTORY_BKND_LASER_MEASUREMENT = 19;
    public static final int STOP_FACTORY_BKND_LASER_MEASUREMENT = 20;
    public static final int ENABLE_ADM = 21;
    public static final int DISABLE_ADM = 22;
    private ResourceBundle res = OperationalChecks.res;
    private static final int REPEATABILITY_STUDY_SAMPLE_SIZE = 1;
    private static final int BACKSIGHT_REPEATABILITY_STUDY_SAMPLE_SIZE = 1;
    private boolean badmCapable;
    private final double FACTORY_BKND_DATA_LISTENER_RATE = 0.25;
    private final int DEFAULT_SAMPLE_RATE = 2000;
    private final int SAMPLE_RATE_1000 = 1000;
    private final int SAMPLE_RATE_750 = 750;
    private final int QUICK_SAMPLE_RATE = 50;
    private final int VERY_QUICK_SAMPLE_RATE = 5;
    private final double SMR_DIA_STD = 0.0381;
    private final double SMR_DIA_7_8 = 0.022225;
    private final double SMR_DIA_1_2 = 0.0127;
    double tmrUncorrectedDist = 0.0;
    FactoryBkndMeasureDataListener factoryBkndDataListener;
    boolean factoryBkndMeasurementInProgress = false;

    OpChecksThread(Tracker tracker, ThreadListener threadListener, BusyListener busyListener, ThreadListener threadListener2, JFrame jFrame) {
        super("OperationalChecks", tracker, threadListener, busyListener, threadListener2, jFrame);
        this.thread = new Thread((Runnable)this, "OpChecks Thread");
        this.thread.setDaemon(true);
    }

    public void stopAppActivities() throws TrackerException {
        this.stopTest(null);
        this.stopFactoryBkndMeasurementForTargetPos();
    }

    public void run() {
        Object var2_1 = null;
        boolean bl = false;
        this.stateTag = new DataTag[2];
        this.stateTag[0] = new DataTagUnsigned32("motor_state.int_output");
        this.stateTag[1] = new DataTagUnsigned32("control_mode.int_output");
        this.responseData = new Object[3];
        this.responseData[0] = null;
        this.responseData[1] = null;
        this.responseData[2] = null;
        this.oldBlockSetting = this.trk.getBlocking();
        try {
            this.setExclusiveAccess();
            this.trk.setBlocking(true);
            this.badmCapable = this.trk.admCapable();
            DataTag[] dataTagArray = new DataTag[]{new DataTagDouble("tmr_dist.output"), new DataTagDouble("hene_baseline_int.output"), new DataTagUnsigned16("hene_baseline_int.status")};
            Object[] objectArray = this.getStateInfo(dataTagArray);
            this.tmrUncorrectedDist = (Double)objectArray[0] / (double)1000000;
            int n = (Integer)objectArray[2];
            this.responseData[1] = this.getStateInfo(this.stateTag);
            boolean bl2 = this.trk.factoryBkndMeasureInProgress();
            Object[] objectArray2 = new Object[]{new Boolean(bl2), new Boolean(this.badmCapable), this.trk.distanceMeasureMode() instanceof InterferometerSetByADM ? new Boolean(true) : new Boolean(false), objectArray[1], n == 0 ? new Boolean(true) : new Boolean(false), new ClosureMath(this.trk), this.getExternalTemperatureInfo()};
            this.responseData[2] = objectArray2;
            this.storeCurrentTrackerState();
        }
        catch (TrackerException trackerException) {
            this.responseData[0] = trackerException;
        }
        try {
            this.response.send(this.responseData);
            if (this.listener != null) {
                this.listener.commandComplete();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.listenForBusyEvents();
        while (!this.shutdown) {
            try {
                Object[] objectArray = this.command.receive();
                this.commandCode = (Integer)objectArray[0];
                this.responseData = new Object[3];
                this.responseData[0] = null;
                this.responseData[1] = null;
                this.responseData[2] = null;
                switch (this.commandCode) {
                    case 2: {
                        this.trk.toggleSightOrientation();
                        break;
                    }
                    case 3: {
                        this.trk.changeTrackingState(!this.trk.trackingOn());
                        break;
                    }
                    case 4: {
                        this.trk.changeMotorState(!this.trk.motorsOn());
                        break;
                    }
                    case 5: {
                        this.trk.initialize();
                        break;
                    }
                    case 9: {
                        break;
                    }
                    case 10: {
                        this.startStaticRepeatTest((MeasureDataListener)objectArray[1], (Double)objectArray[2]);
                        break;
                    }
                    case 11: {
                        this.responseData[2] = this.getOneMeasurement(2000);
                        break;
                    }
                    case 12: {
                        this.responseData[2] = this.startBacksightTest(2000);
                        break;
                    }
                    case 1: {
                        this.trk.home(this.trk.backsightOrientation());
                        break;
                    }
                    case 14: {
                        this.startADMTest();
                        break;
                    }
                    case 15: {
                        this.responseData[2] = this.calculateADMAccuracy((Integer)objectArray[1]);
                        break;
                    }
                    case 13: {
                        this.stopTest((MeasureDataListener)objectArray[1]);
                        break;
                    }
                    case 16: {
                        break;
                    }
                    case 7: {
                        this.startFactoryBkndMeasurementForTargetPos((FactoryBkndMeasureDataListener)objectArray[1]);
                        break;
                    }
                    case 8: {
                        this.stopFactoryBkndMeasurementForTargetPos();
                        break;
                    }
                    case 6: {
                        this.responseData[2] = this.getOneMeasurement(2000);
                        break;
                    }
                    case 17: {
                        this.responseData[2] = this.readOneTimeData((DataTag[])objectArray[1]);
                        break;
                    }
                    case 18: {
                        this.writeOneTimeData((DataTag[])objectArray[1], (Object[])objectArray[2]);
                        break;
                    }
                    case 21: {
                        try {
                            this.trk.changeDistanceMeasureMode((DistanceMode)new InterferometerSetByADM());
                            break;
                        }
                        catch (TrackerException trackerException) {
                            throw new TrackerAppException(this.res.getString("Failed_enable_adm"));
                        }
                    }
                    case 22: {
                        try {
                            this.trk.changeDistanceMeasureMode((DistanceMode)new InterferometerOnly());
                            break;
                        }
                        catch (TrackerException trackerException) {
                            throw new TrackerAppException(this.res.getString("Failed_disable_adm"));
                        }
                    }
                    case 0: {
                        break;
                    }
                    case -9: {
                        this.stopAppActivities();
                        this.appIsSelfClosing = (Boolean)objectArray[1];
                        break;
                    }
                    default: {
                        throw new TrackerException("Thread received unexpected command");
                    }
                }
            }
            catch (Exception exception) {
                this.handleException(exception);
            }
            this.sendResponseToApp();
        }
        this.ignoreBusyEvents();
    }

    private Object[] getExternalTemperatureInfo() throws TrackerException {
        int n = this.trk.numExternalTempSensors();
        DataTag[] dataTagArray = new DataTag[n * 2];
        int n2 = 0;
        dataTagArray[n2++] = new DataTagDouble("temp_input_1.output");
        dataTagArray[n2++] = new DataTagUnsigned16("temp_input_1.status");
        dataTagArray[n2++] = new DataTagDouble("temp_input_2.output");
        dataTagArray[n2++] = new DataTagUnsigned16("temp_input_2.status");
        dataTagArray[n2++] = new DataTagDouble("temp_input_3.output");
        dataTagArray[n2++] = new DataTagUnsigned16("temp_input_3.status");
        dataTagArray[n2++] = new DataTagDouble("temp_input_4.output");
        dataTagArray[n2++] = new DataTagUnsigned16("temp_input_4.status");
        dataTagArray[n2++] = new DataTagDouble("temp_input_5.output");
        dataTagArray[n2++] = new DataTagUnsigned16("temp_input_5.status");
        dataTagArray[n2++] = new DataTagDouble("temp_input_6.output");
        dataTagArray[n2++] = new DataTagUnsigned16("temp_input_6.status");
        dataTagArray[n2++] = new DataTagDouble("temp_input_7.output");
        dataTagArray[n2++] = new DataTagUnsigned16("temp_input_7.status");
        dataTagArray[n2++] = new DataTagDouble("temp_input_8.output");
        dataTagArray[n2++] = new DataTagUnsigned16("temp_input_8.status");
        ExtTempType[] extTempTypeArray = new ExtTempType[n];
        Object[] objectArray = new Object[2];
        objectArray[0] = this.readOneTimeData(dataTagArray);
        for (int i = 0; i < n; ++i) {
            extTempTypeArray[i] = this.trk.externalTempType(i + 1);
        }
        objectArray[1] = extTempTypeArray;
        return objectArray;
    }

    private void startFactoryBkndMeasurementForTargetPos(FactoryBkndMeasureDataListener factoryBkndMeasureDataListener) throws TrackerException {
        if (this.factoryBkndMeasurementInProgress) {
            return;
        }
        this.trk.setFactoryBkndMeasureBlocking(true);
        int n = 19;
        DataTag[] dataTagArray = new DataTag[n];
        int n2 = 0;
        dataTagArray[n2++] = new DataTagDouble("az_corrected.output");
        dataTagArray[n2++] = new DataTagUnsigned16("az_corrected.status");
        dataTagArray[n2++] = new DataTagDouble("el_corrected.output");
        dataTagArray[n2++] = new DataTagUnsigned16("el_corrected.status");
        dataTagArray[n2++] = new DataTagDouble("dist_corrected.output");
        dataTagArray[n2++] = new DataTagUnsigned16("dist_corrected.status");
        dataTagArray[n2++] = new DataTagDouble("dist.output");
        dataTagArray[n2++] = new DataTagUnsigned32("target.int_output");
        dataTagArray[n2++] = new DataTagUnsigned32("fb_sight_mode.int_output");
        dataTagArray[n2++] = new DataTagDouble("quad_a_up.output");
        dataTagArray[n2++] = new DataTagDouble("quad_b_up.output");
        dataTagArray[n2++] = new DataTagDouble("quad_c_up.output");
        dataTagArray[n2++] = new DataTagDouble("quad_d_up.output");
        dataTagArray[n2++] = new DataTagUnsigned16("ambient_temp.status");
        dataTagArray[n2++] = new DataTagDouble("ambient_temp.output");
        dataTagArray[n2++] = new DataTagUnsigned16("air_pressure.status");
        dataTagArray[n2++] = new DataTagDouble("air_pressure.output");
        dataTagArray[n2++] = new DataTagUnsigned16("humidity.status");
        dataTagArray[n2++] = new DataTagDouble("humidity.output");
        Assert.isTrue(n2 == n, "mismatch with the dataTags array in FactoryBkndMeasurement in OpChecksThread");
        this.trk.startFactoryBkndMeasure(new MeasureCfg(5, (Filter)new AverageFilter(), (StartTrigger)new NullStartTrigger(), (ContinueTrigger)new IntervalTrigger(0.25)), dataTagArray);
        P.rintln("\tStarted factory bknd measurements");
        this.factoryBkndDataListener = factoryBkndMeasureDataListener;
        this.trk.addFactoryBkndMeasureDataListener(factoryBkndMeasureDataListener);
        this.factoryBkndMeasurementInProgress = true;
    }

    private void stopFactoryBkndMeasurementForTargetPos() throws TrackerException {
        if (!this.factoryBkndMeasurementInProgress) {
            return;
        }
        this.trk.removeFactoryBkndMeasureDataListener(this.factoryBkndDataListener);
        this.trk.stopFactoryBkndMeasure();
        P.rintln("\tStopped factory bknd measurements");
        this.factoryBkndMeasurementInProgress = false;
    }

    private void startStaticRepeatTest(MeasureDataListener measureDataListener, double d) throws TrackerException {
        this.trk.startMeasurePoint(new MeasureCfg(2000, (Filter)new AverageFilter(), (StartTrigger)new NullStartTrigger(), (ContinueTrigger)new IntervalTrigger(d)));
        this.trk.addMeasureDataListener(measureDataListener);
    }

    private void stopTest(MeasureDataListener measureDataListener) throws TrackerException {
        if (measureDataListener != null) {
            this.trk.removeMeasureDataListener(measureDataListener);
        }
        this.trk.stopMeasurePoint();
    }

    private void startADMTest() throws TrackerException {
        TargetType targetType = this.trk.targetType();
        this.checkAndAbort();
        double d = 0.0;
        DataTag[] dataTagArray = new DataTag[1];
        if (targetType instanceof SMRTargetType) {
            d = ((SMRTargetType)targetType).getDiameter();
            if (Math.abs(d - 0.0381) < 1.0E-14) {
                dataTagArray[0] = new DataTagDouble("adm_crs_scale_std.output");
            } else if (Math.abs(d - 0.022225) < 1.0E-14) {
                dataTagArray[0] = new DataTagDouble("adm_crs_scale_7_8.output");
            } else if (Math.abs(d - 0.0127) < 1.0E-14) {
                dataTagArray[0] = new DataTagDouble("adm_crs_scale_1_2.output");
            } else {
                throw new TrackerAppException(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.res.getString("supportedSMRS")))).append(this.res.getString("probes_not_support")).append(this.res.getString("Please_select_a_probe")))));
            }
            Object[] objectArray = this.trk.readOneTimeData(dataTagArray);
            this.checkAndAbort();
            if (Math.abs((Double)objectArray[0]) < 1.0E-14) {
                JOptionPane.showMessageDialog(null, this.res.getString("Probe_is_not_comp"), this.res.getString("Warning"), 2);
            }
        } else {
            throw new TrackerAppException(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.res.getString("wrongTargetType")))).append(this.res.getString("change_current_probe")).append("and rerun the test"))));
        }
        this.checkAndAbort();
        this.trk.home(this.trk.backsightOrientation());
    }

    private double[] startBacksightTestWithBackMirror(int n) throws TrackerException {
        this.trk.command("moveto zero", 25000);
        this.trk.search(0.02);
        double[] dArray = this.getOneMeasurement(n);
        this.trk.command("moveto zero b", 25000);
        double[] dArray2 = this.getOneMeasurement(n);
        XMath.pointSphereToCart(dArray);
        XMath.pointSphereToCart(dArray2);
        double[] dArray3 = new double[]{dArray[0] - dArray2[0], dArray[1] - dArray2[1], dArray[2] - dArray2[2]};
        XMath.pointCartToSphere(dArray3);
        return dArray3;
    }

    private double[] startBacksightTest(int n) throws TrackerException {
        double[] dArray = new double[7];
        double[] dArray2 = this.getOneMeasurement(n);
        this.checkAndAbort();
        dArray[0] = dArray2[0];
        dArray[1] = dArray2[1];
        dArray[2] = dArray2[2];
        this.trk.toggleSightOrientation();
        this.checkAndAbort();
        double[] dArray3 = this.getOneMeasurement(n);
        this.checkAndAbort();
        dArray[3] = dArray3[0];
        dArray[4] = dArray3[1];
        dArray[5] = dArray3[2];
        dArray[6] = dArray3[3];
        this.trk.toggleSightOrientation();
        return dArray;
    }

    private double[] calculateADMAccuracy(int n) throws TrackerException {
        double[] dArray = this.getOneMeasurement(n);
        this.trk.command("sd ?", 15000);
        double[] dArray2 = this.getOneMeasurement(n);
        double d = dArray2[0] - dArray[0];
        this.trk.move(dArray[1], dArray[2], dArray[0], false);
        System.out.println("returning data");
        double[] dArray3 = new double[]{d, dArray[0], dArray[1], dArray[2], dArray[3]};
        return dArray3;
    }

    static {
        HOME = 1;
        BACKSIGHT = 2;
        TRACKING = 3;
        MOTORS = 4;
        INITIALIZE = 5;
        MEASURE = 6;
        START_FACTORY_BKND_MEASUREMENT = 7;
        STOP_FACTORY_BKND_MEASUREMENT = 8;
        START_CLOSURE_REPEAT_TEST = 9;
        START_STATIC_REPEAT_TEST = 10;
        START_DYNAMIC_REPEAT_TEST = 11;
        START_BACKSIGHT_TEST = 12;
        STOP_TEST = 13;
        START_ADM_TEST = 14;
        ADM_TEST_MEASURE = 15;
        STOP_ADM_TEST = 16;
        READ_ONE_TIME_DATA = 17;
        WRITE_ONE_TIME_DATA = 18;
        START_FACTORY_BKND_LASER_MEASUREMENT = 19;
        STOP_FACTORY_BKND_LASER_MEASUREMENT = 20;
        ENABLE_ADM = 21;
        DISABLE_ADM = 22;
        REPEATABILITY_STUDY_SAMPLE_SIZE = 1;
        BACKSIGHT_REPEATABILITY_STUDY_SAMPLE_SIZE = 1;
    }
}

