/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.apps4xxx.operationalchecks;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import smx.tracker.MeasurePointData;
import smx.tracker.apps4xxx.operationalchecks.OpChecksPanel;
import smx.tracker.apps4xxx.operationalchecks.OpChecksTableColumnData;
import smx.tracker.apps4xxx.operationalchecks.OpChecksTableDisplay;
import smx.tracker.apps4xxx.operationalchecks.OperationalChecks;
import smx.tracker.apps4xxx.utility.DoubleValidatingDocument;
import smx.tracker.apps4xxx.utility.InputDialog;
import smx.tracker.apps4xxx.utility.ThreadListener;
import smx.tracker.apps4xxx.utility.XMath;
import smx.tracker.apps4xxx.utility.tools.P;
import smx.tracker.apps4xxx.utility.tools.XTime;
import smx.tracker.apps4xxx.utility.tools.XTool;
import smx.tracker.event.MeasureDataEvent;
import smx.tracker.event.MeasureDataListener;

public class OpChecksRepeatabilityPane
extends OpChecksPanel {
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    Border border1;
    TitledBorder titledBorder2;
    Border border2;
    Border border3;
    GridLayout gridLayout1 = new GridLayout();
    JPanel jPanel3 = new JPanel();
    JPanel jPanel4 = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JTextField ctrlAz = new JTextField();
    JTextField ctrlZe = new JTextField();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JLabel jLabel3 = new JLabel();
    JLabel jLabel4 = new JLabel();
    JLabel jLabel1Units = new JLabel();
    JLabel jLabel2Units = new JLabel();
    JLabel jLabel3Units = new JLabel();
    JLabel jLabel4Units = new JLabel();
    JTextField ctrlInter = new JTextField();
    JTextField ctrlTotal = new JTextField();
    JPanel jPanel5 = new JPanel();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    Border border4;
    TitledBorder titledBorder1;
    Border border5;
    JRadioButton ctrlClosureCheck = new JRadioButton();
    JRadioButton ctrlStaticCheck = new JRadioButton();
    JRadioButton ctrlDynamicCheck = new JRadioButton();
    ButtonGroup testButtonGroup = new ButtonGroup();
    GridLayout gridLayout2 = new GridLayout();
    ImageIcon closureImage;
    ImageIcon pressedClosureImage;
    ImageIcon staticImage;
    ImageIcon pressedStaticImage;
    ImageIcon dynamicImage;
    ImageIcon pressedDynamicImage;
    JPanel jPanel6 = new JPanel();
    GridLayout gridLayout3 = new GridLayout();
    JButton ctrlStartStop = new JButton();
    JButton ctrlMeasure = new JButton();
    public final OpChecksTableColumnData[] columns = new OpChecksTableColumnData[]{new OpChecksTableColumnData("Type", 75, 2), this.referencePositionColumn, this.dateColumn, this.timeColumn, new OpChecksTableColumnData("Total", 75, 4), this.dXColumn, this.dYColumn, this.dZColumn, this.dRColumn, this.dTColumn, this.dPColumn};
    StaticMeasureDataImplementer measureDataListener = new StaticMeasureDataImplementer();
    private String resultHeading;
    private double[] referenceSpherPosition = null;
    private boolean bdisplayRefPosInResults = true;
    private ArrayList testResults = new ArrayList(50);
    private StartTestCompleteListener startTestListener;
    private StopTestCompleteListener stopTestListener;
    private DynamicMeasureCompleteListener dynamicMeasureListener;
    private boolean btestInProgress = false;
    private int testType = 1;
    private static final int CLOSURE_TEST = 0;
    private static final int STATIC_TEST = 1;
    private static final int DYNAMIC_TEST = 2;
    GridLayout gridLayout4 = new GridLayout();
    private InputDialog inputDialogForStaticTest;

    public OpChecksRepeatabilityPane(String string) {
        super(string);
        this.parentTabPane = OperationalChecks.parentApp;
        this.opChecksThread = OperationalChecks.parentAppCommandThread;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        super.initialize();
        this.resultsPanel = new OpChecksTableDisplay(null, this.columns, null);
        Image image = this.parentTabPane.loadImage("opchecksclosure.gif", OperationalChecks.parentApp.packagePath);
        if (image == null) {
            System.err.println("Couldn't load image greyclosure");
        } else {
            this.closureImage = new ImageIcon(image);
        }
        image = this.parentTabPane.loadImage("opchecksstatic.gif", OperationalChecks.parentApp.packagePath);
        if (image == null) {
            System.err.println("Couldn't load image greystatic");
        } else {
            this.staticImage = new ImageIcon(image);
        }
        image = this.parentTabPane.loadImage("opchecksdynamic.gif", OperationalChecks.parentApp.packagePath);
        if (image == null) {
            System.err.println("Couldn't load image greydynamic");
        } else {
            this.dynamicImage = new ImageIcon(image);
        }
        this.border3 = BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), this.res.getString("Position_Monitor")), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.border1 = BorderFactory.createLineBorder(Color.white, 1);
        this.titledBorder2 = new TitledBorder(this.border1, this.res.getString("Tests_Detailed"));
        this.border2 = BorderFactory.createCompoundBorder(this.titledBorder2, BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.border4 = new EtchedBorder(0, Color.white, new Color(134, 134, 134));
        this.titledBorder1 = new TitledBorder(this.border4, this.res.getString("Tests"));
        this.border5 = BorderFactory.createCompoundBorder(this.titledBorder1, BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setLayout(this.gridLayout4);
        this.jPanel1.setLayout(this.gridLayout1);
        this.jPanel1.setBorder(this.border3);
        this.jPanel1.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.jPanel1.setMinimumSize(new Dimension(200, 125));
        this.jPanel1.setPreferredSize(new Dimension(50, 50));
        this.jPanel2.setBorder(this.border2);
        this.jPanel2.setMinimumSize(new Dimension(200, 125));
        this.jPanel2.setPreferredSize(new Dimension(50, 50));
        this.jPanel2.setLayout(this.gridBagLayout3);
        this.gridLayout1.setColumns(2);
        this.gridLayout1.setHgap(25);
        this.jPanel3.setLayout(this.gridBagLayout1);
        this.jPanel4.setLayout(this.gridBagLayout2);
        this.ctrlAz.setBackground(Color.black);
        this.ctrlAz.setFont(new Font("SansSerif", 1, 30));
        this.ctrlAz.setForeground(Color.white);
        this.ctrlAz.setEditable(false);
        this.ctrlAz.setHorizontalAlignment(4);
        this.ctrlZe.setBackground(Color.black);
        this.ctrlZe.setFont(new Font("SansSerif", 1, 30));
        this.ctrlZe.setForeground(Color.white);
        this.ctrlZe.setEditable(false);
        this.ctrlZe.setHorizontalAlignment(4);
        this.jLabel1.setFont(new Font("Dialog", 1, 25));
        this.jLabel1.setText(this.res.getString("Az"));
        this.jLabel2.setText(this.res.getString("Ze"));
        this.jLabel3.setText(this.res.getString("Ra"));
        this.jLabel4.setText(this.res.getString("3D"));
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.parentTabPane.localAngularUnits.displayName());
        StringBuffer stringBuffer2 = new StringBuffer(100);
        stringBuffer2.append(this.parentTabPane.localLinearUnits.displayName());
        StringBuffer stringBuffer3 = new StringBuffer(100);
        if (stringBuffer.length() > 4) {
            stringBuffer3.append("(").append(stringBuffer.substring(0, 4)).append(")");
        } else {
            stringBuffer3.append("(").append(stringBuffer).append(")");
        }
        StringBuffer stringBuffer4 = new StringBuffer(100);
        if (stringBuffer2.length() > 4) {
            stringBuffer4.append("(").append(stringBuffer2.substring(0, 4)).append(")");
        } else {
            stringBuffer4.append("(").append(stringBuffer2).append(")");
        }
        this.jLabel1Units.setHorizontalTextPosition(0);
        this.jLabel1Units.setVerticalTextPosition(1);
        this.jLabel2Units.setHorizontalTextPosition(0);
        this.jLabel2Units.setVerticalTextPosition(1);
        this.jLabel3Units.setHorizontalTextPosition(0);
        this.jLabel3Units.setVerticalTextPosition(1);
        this.jLabel4Units.setHorizontalTextPosition(0);
        this.jLabel4Units.setVerticalTextPosition(1);
        this.jLabel1Units.setText(stringBuffer3.toString());
        this.jLabel2Units.setText(stringBuffer3.toString());
        this.jLabel3Units.setText(stringBuffer4.toString());
        this.jLabel4Units.setText(stringBuffer4.toString());
        this.jLabel2.setFont(new Font("Dialog", 1, 25));
        this.jLabel3.setFont(new Font("SansSerif", 1, 25));
        this.ctrlInter.setBackground(Color.black);
        this.ctrlInter.setFont(new Font("SansSerif", 1, 30));
        this.ctrlInter.setForeground(Color.white);
        this.ctrlInter.setEditable(false);
        this.ctrlInter.setHorizontalAlignment(4);
        this.jLabel4.setFont(new Font("SansSerif", 1, 25));
        this.ctrlTotal.setBackground(Color.black);
        this.ctrlTotal.setFont(new Font("SansSerif", 1, 30));
        this.ctrlTotal.setForeground(Color.white);
        this.ctrlTotal.setEditable(false);
        this.ctrlTotal.setHorizontalAlignment(4);
        this.setMaximumSize(new Dimension(5000, 4000));
        this.setMinimumSize(new Dimension(550, 425));
        this.setPreferredSize(new Dimension(550, 425));
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                OpChecksRepeatabilityPane.this.onComponentResized(componentEvent);
            }
        });
        this.jPanel5.setBorder(this.border5);
        this.jPanel5.setMaximumSize(new Dimension(85, 47));
        this.jPanel5.setMinimumSize(new Dimension(95, 47));
        this.jPanel5.setPreferredSize(new Dimension(95, 47));
        this.jPanel5.setLayout(this.gridLayout2);
        this.ctrlClosureCheck.setIcon(this.closureImage);
        this.ctrlClosureCheck.setText(this.res.getString("Closure"));
        this.ctrlClosureCheck.setPreferredSize(new Dimension(100, 47));
        this.ctrlClosureCheck.setMaximumSize(new Dimension(1000, 470));
        this.ctrlClosureCheck.setMinimumSize(new Dimension(100, 47));
        this.ctrlClosureCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OpChecksRepeatabilityPane.this.onClosureTestSelected(actionEvent);
            }
        });
        this.ctrlStaticCheck.setIcon(this.staticImage);
        this.ctrlStaticCheck.setText(this.res.getString("Static"));
        this.ctrlStaticCheck.setPreferredSize(new Dimension(100, 47));
        this.ctrlStaticCheck.setMaximumSize(new Dimension(1000, 470));
        this.ctrlStaticCheck.setMinimumSize(new Dimension(100, 47));
        this.ctrlStaticCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OpChecksRepeatabilityPane.this.onStaticTestSelected(actionEvent);
            }
        });
        this.ctrlDynamicCheck.setIcon(this.dynamicImage);
        this.ctrlDynamicCheck.setText(this.res.getString("Dynamic"));
        this.ctrlDynamicCheck.setPreferredSize(new Dimension(100, 47));
        this.ctrlDynamicCheck.setMaximumSize(new Dimension(1000, 470));
        this.ctrlDynamicCheck.setMinimumSize(new Dimension(100, 47));
        this.ctrlDynamicCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OpChecksRepeatabilityPane.this.onDynamicTestSelected(actionEvent);
            }
        });
        this.ctrlMeasure.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OpChecksRepeatabilityPane.this.onMeasure(actionEvent);
            }
        });
        this.ctrlMeasure.setEnabled(false);
        this.ctrlMeasure.setMnemonic('M');
        this.gridLayout4.setRows(2);
        this.ctrlStartStop.setMnemonic('T');
        this.ctrlHome.setMnemonic('H');
        this.testButtonGroup.add(this.ctrlClosureCheck);
        this.testButtonGroup.add(this.ctrlStaticCheck);
        this.testButtonGroup.add(this.ctrlDynamicCheck);
        this.ctrlStaticCheck.setSelected(true);
        this.onStaticTestSelected(null);
        this.gridLayout2.setColumns(1);
        this.gridLayout2.setRows(3);
        this.gridLayout2.setVgap(5);
        this.jPanel6.setLayout(this.gridLayout3);
        this.gridLayout3.setColumns(1);
        this.gridLayout3.setRows(6);
        this.gridLayout3.setVgap(1);
        this.ctrlStartStop.setText(this.res.getString("Start_Test"));
        this.ctrlStartStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OpChecksRepeatabilityPane.this.ctrlStartStop_actionPerformed(actionEvent);
            }
        });
        this.ctrlHome.setText(this.res.getString("Home"));
        this.ctrlHome.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OpChecksRepeatabilityPane.this.onHome(actionEvent);
            }
        });
        this.ctrlMeasure.setText(this.res.getString("Measure"));
        this.add((Component)this.jPanel1, null);
        this.jPanel1.add((Component)this.jPanel3, null);
        this.jPanel3.add((Component)this.ctrlAz, new GridBagConstraints(1, 0, 1, 2, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 15, 15));
        this.jPanel3.add((Component)this.ctrlZe, new GridBagConstraints(1, 2, 1, 2, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 15, 15));
        this.jPanel3.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 3), 5, 5));
        this.jPanel3.add((Component)this.jLabel1Units, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 2, 2, 3), 0, 0));
        this.jPanel3.add((Component)this.jLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 3), 5, 5));
        this.jPanel3.add((Component)this.jLabel2Units, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 2, 2, 3), 0, 0));
        this.jPanel1.add((Component)this.jPanel4, null);
        this.jPanel4.add((Component)this.ctrlInter, new GridBagConstraints(1, 0, 1, 2, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 15, 15));
        this.jPanel4.add((Component)this.ctrlTotal, new GridBagConstraints(1, 2, 1, 2, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 15, 15));
        this.jPanel4.add((Component)this.jLabel3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 3), 5, 5));
        this.jPanel4.add((Component)this.jLabel3Units, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 2, 2, 3), 0, 0));
        this.jPanel4.add((Component)this.jLabel4, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 3), 5, 5));
        this.jPanel4.add((Component)this.jLabel4Units, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 2, 2, 3), 0, 0));
        this.add((Component)this.jPanel2, null);
        this.jPanel2.add((Component)this.jPanel5, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(2, 2, 2, 5), 0, 0));
        this.jPanel5.add((Component)this.ctrlClosureCheck, null);
        this.jPanel5.add((Component)this.ctrlStaticCheck, null);
        this.jPanel5.add((Component)this.ctrlDynamicCheck, null);
        this.jPanel2.add((Component)this.resultsPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 200, 100));
        this.jPanel2.add((Component)this.jPanel6, new GridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(2, 5, 2, 2), 0, 25));
        this.jPanel6.add((Component)this.ctrlStartStop, null);
        this.jPanel6.add((Component)this.ctrlHome, null);
        this.jPanel6.add((Component)this.ctrlMeasure, null);
        this.jPanel6.add((Component)this.ctrlClear, null);
        this.jPanel6.add((Component)this.ctrlSave, null);
        this.jPanel6.add((Component)this.ctrlSaveAs, null);
    }

    protected void onComponentResized(ComponentEvent componentEvent) {
        String string = this.ctrlAz.getText();
        String string2 = this.ctrlZe.getText();
        String string3 = this.ctrlInter.getText();
        Font font = this.ctrlInter.getFont();
        FontMetrics fontMetrics = ((Component)this.ctrlInter).getFontMetrics(font);
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.stringWidth(string2);
        int n3 = fontMetrics.stringWidth(string3);
        int n4 = Math.max(n, n2);
        if ((n4 = Math.max(n4, n3)) == 0) {
            return;
        }
        Font font2 = null;
        font2 = n4 == n ? XTool.calculateMaxFontThatFits(this.ctrlAz, this.oldDimension) : (n4 == n2 ? XTool.calculateMaxFontThatFits(this.ctrlZe, this.oldDimension) : XTool.calculateMaxFontThatFits(this.ctrlInter, this.oldDimension));
        if (font2 == null) {
            return;
        }
        this.ctrlAz.setFont(font2);
        this.ctrlZe.setFont(font2);
        this.ctrlInter.setFont(font2);
        this.ctrlTotal.setFont(font2);
    }

    protected void handleBeamBreak() {
        if (this.btestInProgress) {
            this.runStopTest();
        }
        super.handleBeamBreak();
    }

    public void displayTargetPosition() {
        this.displayTargetPosition(this.parentTabPane.measurementTime, this.parentTabPane.azimuthAngle, this.parentTabPane.zenithAngle, this.parentTabPane.radialDistance, this.parentTabPane.overallStatus, false);
    }

    private void displayTargetPosition(double d, double d2, double d3, double d4, int n, boolean bl) {
        double[] dArray = new double[]{this.parentTabPane.radialDistance, this.parentTabPane.azimuthAngle, this.parentTabPane.zenithAngle};
        this.ctrlInter.setText(this.parentTabPane.localLinearUnits.convertToDisplayStr(dArray[0]));
        this.ctrlAz.setText(this.parentTabPane.localAngularUnits.convertToDisplayStr(dArray[1]));
        this.ctrlZe.setText(this.parentTabPane.localAngularUnits.convertToDisplayStr(dArray[2]));
        if (!this.fontCalculatedOnce) {
            this.onComponentResized(null);
            this.fontCalculatedOnce = true;
        }
        if (this.parentTabPane.overallStatus == 0) {
            this.ctrlAz.setForeground(Color.white);
            this.ctrlZe.setForeground(Color.white);
            this.ctrlInter.setForeground(Color.white);
        } else {
            this.ctrlAz.setForeground(Color.red);
            this.ctrlZe.setForeground(Color.red);
            this.ctrlInter.setForeground(Color.red);
            this.handleBeamBreak();
        }
        if (this.btestInProgress) {
            switch (this.testType) {
                case 0: {
                    double d5 = this.parentTabPane.closureMath.getClosureAgainstTMR(this.parentTabPane.targetType, this.parentTabPane.sightMode, this.parentTabPane.radialDistanceUnCorrected * (double)1000000);
                    String string = this.parentTabPane.localLinearUnits.convertToDisplayStr(d5);
                    this.ctrlTotal.setText(string);
                    break;
                }
                case 1: {
                    if (!bl) break;
                    if (this.referenceSpherPosition == null) {
                        this.referenceSpherPosition = new double[3];
                        XMath.pointCopyToFrom(this.referenceSpherPosition, dArray);
                        return;
                    }
                    double[] dArray2 = new double[]{d4, d2, d3, d};
                    this.SetDeviationResults("Static", dArray2);
                }
            }
        }
    }

    void SetDeviationResults(String string, double[] dArray) {
        double d = dArray[3];
        double[] dArray2 = new double[]{this.referenceSpherPosition[0], this.referenceSpherPosition[1], this.referenceSpherPosition[2]};
        double[] dArray3 = new double[]{this.referenceSpherPosition[0], this.referenceSpherPosition[1], this.referenceSpherPosition[2]};
        double[] dArray4 = new double[]{dArray[0], dArray[1], dArray[2]};
        XMath.pointSphereToCart(dArray2);
        XMath.pointSphereToCart(dArray4);
        String string2 = this.parentTabPane.localLinearUnits.convertToDisplayStr(dArray2[0]);
        String string3 = this.parentTabPane.localLinearUnits.convertToDisplayStr(dArray2[1]);
        String string4 = this.parentTabPane.localLinearUnits.convertToDisplayStr(dArray2[2]);
        dArray2[0] = this.parentTabPane.localLinearUnits.convertTo(dArray2[0]);
        dArray2[1] = this.parentTabPane.localLinearUnits.convertTo(dArray2[1]);
        dArray2[2] = this.parentTabPane.localLinearUnits.convertTo(dArray2[2]);
        dArray4[0] = this.parentTabPane.localLinearUnits.convertTo(dArray4[0]);
        dArray4[1] = this.parentTabPane.localLinearUnits.convertTo(dArray4[1]);
        dArray4[2] = this.parentTabPane.localLinearUnits.convertTo(dArray4[2]);
        dArray3[0] = this.parentTabPane.localLinearUnits.convertTo(dArray3[0]);
        dArray3[1] = this.parentTabPane.localAngularUnits.convertTo(dArray3[1]);
        dArray3[2] = this.parentTabPane.localAngularUnits.convertTo(dArray3[2]);
        dArray[0] = this.parentTabPane.localLinearUnits.convertTo(dArray[0]);
        dArray[1] = this.parentTabPane.localAngularUnits.convertTo(dArray[1]);
        dArray[2] = this.parentTabPane.localAngularUnits.convertTo(dArray[2]);
        double d2 = dArray2[0] - dArray4[0];
        double d3 = dArray2[1] - dArray4[1];
        double d4 = dArray2[2] - dArray4[2];
        d2 = this.parentTabPane.localLinearUnits.convertFrom(d2);
        String string5 = this.parentTabPane.localLinearUnits.convertToDisplayStr(d2);
        d3 = this.parentTabPane.localLinearUnits.convertFrom(d3);
        String string6 = this.parentTabPane.localLinearUnits.convertToDisplayStr(d3);
        d4 = this.parentTabPane.localLinearUnits.convertFrom(d4);
        String string7 = this.parentTabPane.localLinearUnits.convertToDisplayStr(d4);
        double d5 = Math.sqrt(d2 * d2 + d3 * d3 + d4 * d4);
        String string8 = this.parentTabPane.localLinearUnits.convertToDisplayStr(d5);
        this.ctrlTotal.setText(string8);
        double d6 = dArray3[0] - dArray[0];
        double d7 = dArray3[1] - dArray[1];
        double d8 = dArray3[2] - dArray[2];
        d6 = this.parentTabPane.localLinearUnits.convertFrom(d6);
        String string9 = this.parentTabPane.localLinearUnits.convertToDisplayStr(d6);
        d7 = this.parentTabPane.localAngularUnits.convertFrom(d7);
        String string10 = this.parentTabPane.localAngularUnits.convertToDisplayStr(d7);
        d8 = this.parentTabPane.localAngularUnits.convertFrom(d8);
        String string11 = this.parentTabPane.localAngularUnits.convertToDisplayStr(d8);
        StringBuffer stringBuffer = new StringBuffer(512);
        if (this.bdisplayRefPosInResults) {
            this.bdisplayRefPosInResults = false;
            stringBuffer.append(string).append(this.dataTokenizer);
            stringBuffer.append(string2).append("  ").append(string3).append("  ").append(string4).append(this.dataTokenizer);
        } else {
            stringBuffer.append(" ").append(this.dataTokenizer);
            stringBuffer.append(" ").append(this.dataTokenizer);
        }
        stringBuffer.append(XTime.getDate(d)).append(this.dataTokenizer);
        stringBuffer.append(XTime.getTime(d)).append(this.dataTokenizer);
        stringBuffer.append(string8).append(this.dataTokenizer);
        stringBuffer.append(string5).append(this.dataTokenizer);
        stringBuffer.append(string6).append(this.dataTokenizer);
        stringBuffer.append(string7).append(this.dataTokenizer);
        stringBuffer.append(string9).append(this.dataTokenizer);
        stringBuffer.append(string10).append(this.dataTokenizer);
        stringBuffer.append(string11);
        this.updateResults(stringBuffer.toString());
    }

    private void restoreControlsToInitialState() {
        this.ctrlStartStop.setEnabled(true);
        this.ctrlHome.setEnabled(true);
        this.ctrlClosureCheck.setEnabled(true);
        this.ctrlStaticCheck.setEnabled(true);
        this.ctrlDynamicCheck.setEnabled(true);
        if (this.resultsPanel.isDataAvailable()) {
            this.ctrlClear.setEnabled(true);
            this.ctrlSave.setEnabled(true);
            this.ctrlSaveAs.setEnabled(true);
        }
    }

    private void runStartTest() {
        this.ctrlStartStop.setEnabled(false);
        this.ctrlHome.setEnabled(false);
        this.ctrlClosureCheck.setEnabled(false);
        this.ctrlStaticCheck.setEnabled(false);
        this.ctrlDynamicCheck.setEnabled(false);
        this.ctrlClear.setEnabled(false);
        this.ctrlSave.setEnabled(false);
        this.ctrlSaveAs.setEnabled(false);
        switch (this.testType) {
            case 0: {
                this.runClosureTest();
                break;
            }
            case 1: {
                this.runStaticTest();
                break;
            }
            case 2: {
                this.runDynamicTest();
            }
        }
    }

    private void runClosureTest() {
        Object[] objectArray = new Object[]{new Integer(9)};
        if (this.startTestListener == null) {
            this.startTestListener = new StartTestCompleteListener();
        }
        this.parentTabPane.doThreadTransaction(objectArray, "", this.startTestListener);
    }

    private void runDynamicTest() {
        Object[] objectArray = new Object[]{new Integer(11)};
        if (this.startTestListener == null) {
            this.startTestListener = new StartTestCompleteListener();
        }
        this.parentTabPane.doThreadTransaction(objectArray, "", this.startTestListener);
    }

    private void runStaticTest() {
        if (this.inputDialogForStaticTest == null) {
            this.inputDialogForStaticTest = new InputDialog(OperationalChecks.parentAppFrame, this.res.getString("Enter_Delay_title"), this.res.getString("Please_enter_delay"), "2", new DoubleValidatingDocument());
        }
        Dimension dimension = this.inputDialogForStaticTest.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocationOnScreen();
        P.rintln("panel loc = ".concat(String.valueOf(String.valueOf(point))));
        P.rintln("panel size = ".concat(String.valueOf(String.valueOf(dimension2))));
        P.rintln("dlg size = ".concat(String.valueOf(String.valueOf(dimension))));
        ((Component)this.inputDialogForStaticTest).setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        ((Component)this.inputDialogForStaticTest).setVisible(true);
        String string = this.inputDialogForStaticTest.getInput();
        if (string == null || string.length() == 0) {
            this.restoreControlsToInitialState();
            return;
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = new Integer(10);
        if (this.startTestListener == null) {
            this.startTestListener = new StartTestCompleteListener();
        }
        objectArray[1] = this.measureDataListener;
        P.rintln("Delay string = ".concat(String.valueOf(String.valueOf(string))));
        double d = Double.parseDouble(string);
        if (d < 1.0E-14) {
            d = 1.0;
        }
        objectArray[2] = new Double(d);
        this.parentTabPane.doThreadTransaction(objectArray, "", this.startTestListener);
    }

    private void runStopTest() {
        this.btestInProgress = false;
        this.ctrlMeasure.setEnabled(false);
        Object[] objectArray = new Object[2];
        objectArray[0] = new Integer(13);
        if (this.stopTestListener == null) {
            this.stopTestListener = new StopTestCompleteListener();
        }
        objectArray[1] = this.measureDataListener;
        this.parentTabPane.doThreadTransaction(objectArray, "", this.stopTestListener);
    }

    void ctrlStartStop_actionPerformed(ActionEvent actionEvent) {
        if (this.ctrlStartStop.getText().equals(this.res.getString("Start_Test"))) {
            this.runStartTest();
        } else if (this.ctrlStartStop.getText().equals(this.res.getString("Stop_Test"))) {
            this.runStopTest();
        }
    }

    protected void onFocusLost() {
        super.onFocusLost();
        if (this.ctrlStartStop.getText().equals(this.res.getString("Stop_Test"))) {
            this.runStopTest();
        }
    }

    protected void enableAllControls(boolean bl) {
        this.ctrlStartStop.setEnabled(bl);
        this.ctrlHome.setEnabled(bl);
    }

    private void enableTestTypeButton(boolean bl) {
        switch (this.testType) {
            case 0: {
                this.ctrlClosureCheck.setEnabled(bl);
                this.ctrlStaticCheck.setEnabled(false);
                this.ctrlDynamicCheck.setEnabled(false);
                break;
            }
            case 1: {
                this.ctrlStaticCheck.setEnabled(bl);
                this.ctrlClosureCheck.setEnabled(false);
                this.ctrlDynamicCheck.setEnabled(false);
                break;
            }
            case 2: {
                this.ctrlDynamicCheck.setEnabled(bl);
                this.ctrlClosureCheck.setEnabled(false);
                this.ctrlStaticCheck.setEnabled(false);
            }
        }
    }

    void onClosureTestSelected(ActionEvent actionEvent) {
        this.testType = 0;
        this.ctrlClosureCheck.setBackground(Color.white);
        this.ctrlStaticCheck.setBackground(Color.gray);
        this.ctrlDynamicCheck.setBackground(Color.gray);
    }

    void onStaticTestSelected(ActionEvent actionEvent) {
        this.testType = 1;
        this.ctrlStaticCheck.setBackground(Color.white);
        this.ctrlClosureCheck.setBackground(Color.gray);
        this.ctrlDynamicCheck.setBackground(Color.gray);
    }

    void onDynamicTestSelected(ActionEvent actionEvent) {
        this.testType = 2;
        this.ctrlDynamicCheck.setBackground(Color.white);
        this.ctrlClosureCheck.setBackground(Color.gray);
        this.ctrlStaticCheck.setBackground(Color.gray);
    }

    void onMeasure(ActionEvent actionEvent) {
        if (this.testType == 2) {
            this.ctrlMeasure.setEnabled(false);
            Object[] objectArray = new Object[]{new Integer(6)};
            if (this.dynamicMeasureListener == null) {
                this.dynamicMeasureListener = new DynamicMeasureCompleteListener();
            }
            this.parentTabPane.doThreadTransaction(objectArray, "", this.dynamicMeasureListener);
        } else if (this.testType == 0) {
            if (this.parentTabPane.distanceStatus != 0) {
                XTool.displayErrorToUser(OperationalChecks.parentAppFrame, this.res.getString("Error"), this.res.getString("Measured_data_invalid"));
                this.runStopTest();
                return;
            }
            double d = this.parentTabPane.closureMath.getClosureAgainstTMR(this.parentTabPane.targetType, this.parentTabPane.sightMode, this.parentTabPane.radialDistanceUnCorrected * (double)1000000);
            String string = this.parentTabPane.localLinearUnits.convertToDisplayStr(d);
            this.ctrlTotal.setText(string);
            double d2 = this.parentTabPane.measurementTime;
            double[] dArray = new double[]{this.parentTabPane.radialDistance, this.parentTabPane.azimuthAngle, this.parentTabPane.zenithAngle};
            XMath.pointSphereToCart(dArray);
            String string2 = this.parentTabPane.localLinearUnits.convertToDisplayStr(dArray[0]);
            String string3 = this.parentTabPane.localLinearUnits.convertToDisplayStr(dArray[1]);
            String string4 = this.parentTabPane.localLinearUnits.convertToDisplayStr(dArray[2]);
            StringBuffer stringBuffer = new StringBuffer(512);
            stringBuffer.append(this.res.getString("Closure")).append(this.dataTokenizer);
            stringBuffer.append(string2).append("  ").append(string3).append("  ").append(string4).append(this.dataTokenizer);
            stringBuffer.append(XTime.getDate(d2)).append(this.dataTokenizer);
            stringBuffer.append(XTime.getTime(d2)).append(this.dataTokenizer);
            stringBuffer.append(string).append(this.dataTokenizer);
            stringBuffer.append(" ").append(this.dataTokenizer);
            stringBuffer.append(" ").append(this.dataTokenizer);
            stringBuffer.append(" ").append(this.dataTokenizer);
            stringBuffer.append(string).append(this.dataTokenizer);
            stringBuffer.append(" ").append(this.dataTokenizer);
            stringBuffer.append(" ");
            this.updateResults(stringBuffer.toString());
        }
    }

    static /* synthetic */ double[] access$3(OpChecksRepeatabilityPane opChecksRepeatabilityPane, double[] dArray) {
        opChecksRepeatabilityPane.referenceSpherPosition = dArray;
        return dArray;
    }

    static {
        CLOSURE_TEST = 0;
        STATIC_TEST = 1;
        DYNAMIC_TEST = 2;
    }

    private class StaticMeasureDataImplementer
    implements MeasureDataListener,
    Runnable {
        private Vector dataList = new Vector(1000, 1000);

        private StaticMeasureDataImplementer() {
        }

        public void dataAvailable(MeasureDataEvent measureDataEvent) {
            try {
                MeasurePointData[] measurePointDataArray = OpChecksRepeatabilityPane.this.parentTabPane.getInterface().readMeasurePointData(measureDataEvent.getNumMeasurements());
                this.dataList.add(measurePointDataArray);
                SwingUtilities.invokeLater(this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void run() {
            if (this.dataList.isEmpty() || !OpChecksRepeatabilityPane.this.btestInProgress) {
                return;
            }
            MeasurePointData[] measurePointDataArray = (MeasurePointData[])this.dataList.remove(0);
            if (measurePointDataArray != null && measurePointDataArray[0] != null) {
                if (measurePointDataArray[0].status() != 0) {
                    XTool.displayErrorToUser(OperationalChecks.parentAppFrame, OpChecksRepeatabilityPane.this.res.getString("Error"), OpChecksRepeatabilityPane.this.res.getString("Measured_data_invalid"));
                    OpChecksRepeatabilityPane.this.runStopTest();
                    this.dataList.clear();
                    return;
                }
                OpChecksRepeatabilityPane.this.displayTargetPosition(measurePointDataArray[0].time(), measurePointDataArray[0].azimuth(), measurePointDataArray[0].zenith(), measurePointDataArray[0].distance(), measurePointDataArray[0].status(), true);
            }
        }
    }

    private class DynamicMeasureCompleteListener
    implements ThreadListener,
    Runnable {
        private Object[] data;

        private DynamicMeasureCompleteListener() {
        }

        public void commandComplete() {
            this.data = OpChecksRepeatabilityPane.this.opChecksThread.peekResponse();
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            if (this.data[0] == null && OpChecksRepeatabilityPane.this.testType == 2 && this.data[2] != null) {
                OpChecksRepeatabilityPane.this.SetDeviationResults(OpChecksRepeatabilityPane.this.res.getString("Dynamic"), (double[])this.data[2]);
            }
            OpChecksRepeatabilityPane.this.ctrlStartStop.setEnabled(true);
            OpChecksRepeatabilityPane.this.ctrlMeasure.setEnabled(true);
        }
    }

    private class StopTestCompleteListener
    implements ThreadListener,
    Runnable {
        private StopTestCompleteListener() {
        }

        public void commandComplete() {
            OpChecksRepeatabilityPane.access$3(OpChecksRepeatabilityPane.this, null);
            OpChecksRepeatabilityPane.this.bdisplayRefPosInResults = true;
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            OpChecksRepeatabilityPane.this.ctrlStartStop.setText(OpChecksRepeatabilityPane.this.res.getString("Start_Test"));
            OpChecksRepeatabilityPane.this.restoreControlsToInitialState();
        }
    }

    private class StartTestCompleteListener
    implements ThreadListener,
    Runnable {
        private Object[] data;

        private StartTestCompleteListener() {
        }

        public void commandComplete() {
            this.data = OpChecksRepeatabilityPane.this.opChecksThread.peekResponse();
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            OpChecksRepeatabilityPane.this.enableTestTypeButton(true);
            OpChecksRepeatabilityPane.this.ctrlStartStop.setText(OpChecksRepeatabilityPane.this.res.getString("Stop_Test"));
            OpChecksRepeatabilityPane.this.ctrlStartStop.setEnabled(true);
            if (this.data[0] == null) {
                if (OpChecksRepeatabilityPane.this.testType == 2 && this.data[2] != null) {
                    if (OpChecksRepeatabilityPane.this.referenceSpherPosition == null) {
                        OpChecksRepeatabilityPane.access$3(OpChecksRepeatabilityPane.this, new double[3]);
                        XMath.pointCopyToFrom(OpChecksRepeatabilityPane.this.referenceSpherPosition, (double[])this.data[2]);
                    }
                    OpChecksRepeatabilityPane.this.ctrlMeasure.setEnabled(true);
                } else if (OpChecksRepeatabilityPane.this.testType == 0) {
                    OpChecksRepeatabilityPane.this.ctrlMeasure.setEnabled(true);
                }
                OpChecksRepeatabilityPane.this.btestInProgress = true;
            } else {
                OpChecksRepeatabilityPane.this.runStopTest();
            }
        }
    }
}

