/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.apps4xxx.operationalchecks;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import smx.tracker.DataTag;
import smx.tracker.DataTagUnsigned32;
import smx.tracker.apps4xxx.operationalchecks.OpChecksADMSettingsDlg;
import smx.tracker.apps4xxx.operationalchecks.OpChecksPanel;
import smx.tracker.apps4xxx.operationalchecks.OpChecksTableColumnData;
import smx.tracker.apps4xxx.operationalchecks.OpChecksTableDisplay;
import smx.tracker.apps4xxx.operationalchecks.OperationalChecks;
import smx.tracker.apps4xxx.utility.ThreadListener;
import smx.tracker.apps4xxx.utility.XMath;
import smx.tracker.apps4xxx.utility.tools.P;
import smx.tracker.apps4xxx.utility.tools.XTime;
import smx.tracker.apps4xxx.utility.tools.XTool;

public class OpChecksADMPane
extends OpChecksPanel {
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    Border border1;
    TitledBorder titledBorder2;
    Border border2;
    Border border3;
    GridLayout gridLayout1 = new GridLayout();
    JPanel jPanel3 = new JPanel();
    JPanel jPanel4 = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JTextField ctrlInter = new JTextField();
    JTextField ctrlClosure = new JTextField();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JLabel jLabel3 = new JLabel();
    JLabel jLabel1Units = new JLabel();
    JLabel jLabel2Units = new JLabel();
    JLabel jLabel3Units = new JLabel();
    JTextField ctrlAccuracy = new JTextField();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    Border border4;
    TitledBorder titledBorder1;
    Border border5;
    JPanel jPanel6 = new JPanel();
    GridLayout gridLayout3 = new GridLayout();
    JButton ctrlStartStop = new JButton();
    JButton ctrlSettings = new JButton();
    JButton ctrlMeasure = new JButton();
    public final OpChecksTableColumnData[] columns = new OpChecksTableColumnData[]{this.referencePositionColumn, this.dateColumn, this.timeColumn, new OpChecksTableColumnData(this.res.getString("Accuracy"), 100, 4)};
    String resultHeading;
    private boolean btestInProgress = false;
    private StartStopTestCompleteListener startStopTestListener;
    private ADMMeasureCompleteListener admMeasureListener;
    private int nIfSamples = 1000;
    private double nMeasTimeSecs = 15.0;
    private boolean setBacksight;
    private boolean setResetPt;
    private OpChecksADMSettingsDlg admSettingsDlg;
    private ADMMeasureTimeReadListener admMeasureTimeReadListener;
    private boolean admIsTurnedOn;
    GridLayout gridLayout2 = new GridLayout();

    public OpChecksADMPane(String string) {
        super(string);
        this.parentTabPane = OperationalChecks.parentApp;
        this.opChecksThread = OperationalChecks.parentAppCommandThread;
        this.admMeasureTimeReadListener = new ADMMeasureTimeReadListener(this);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        super.initialize();
        this.resultsPanel = new OpChecksTableDisplay(null, this.columns, null);
        this.border3 = BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), this.res.getString("Position_Monitor")), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.border1 = BorderFactory.createLineBorder(Color.white, 1);
        this.titledBorder2 = new TitledBorder(this.border1, this.res.getString("Tests_Detailed"));
        this.border2 = BorderFactory.createCompoundBorder(this.titledBorder2, BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.border4 = new EtchedBorder(0, Color.white, new Color(134, 134, 134));
        this.titledBorder1 = new TitledBorder(this.border4, this.res.getString("Tests"));
        this.border5 = BorderFactory.createCompoundBorder(this.titledBorder1, BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setLayout(this.gridLayout2);
        this.jPanel1.setLayout(this.gridLayout1);
        this.jPanel1.setBorder(this.border3);
        this.jPanel1.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.jPanel1.setMinimumSize(new Dimension(200, 125));
        this.jPanel1.setPreferredSize(new Dimension(50, 50));
        this.jPanel2.setBorder(this.border2);
        this.jPanel2.setMinimumSize(new Dimension(200, 125));
        this.jPanel2.setPreferredSize(new Dimension(50, 50));
        this.jPanel2.setLayout(this.gridBagLayout3);
        this.gridLayout1.setColumns(2);
        this.gridLayout1.setHgap(25);
        this.jPanel3.setLayout(this.gridBagLayout1);
        this.jPanel4.setLayout(this.gridBagLayout2);
        this.ctrlInter.setBackground(Color.black);
        this.ctrlInter.setFont(new Font("SansSerif", 1, 30));
        this.ctrlInter.setEditable(false);
        this.ctrlInter.setHorizontalAlignment(4);
        this.ctrlClosure.setBackground(Color.black);
        this.ctrlClosure.setFont(new Font("SansSerif", 1, 30));
        this.ctrlClosure.setForeground(Color.white);
        this.ctrlClosure.setEditable(false);
        this.ctrlClosure.setHorizontalAlignment(4);
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.parentTabPane.localLinearUnits.displayName());
        StringBuffer stringBuffer2 = new StringBuffer(100);
        if (stringBuffer.length() > 4) {
            stringBuffer2.append("(").append(stringBuffer.substring(0, 4)).append(")");
        } else {
            stringBuffer2.append("(").append(stringBuffer).append(")");
        }
        String string = stringBuffer2.toString();
        this.jLabel1Units.setText(string);
        this.jLabel2Units.setText(string);
        this.jLabel3Units.setText(string);
        this.jLabel1Units.setHorizontalTextPosition(0);
        this.jLabel1Units.setVerticalTextPosition(1);
        this.jLabel2Units.setHorizontalTextPosition(0);
        this.jLabel2Units.setVerticalTextPosition(1);
        this.jLabel3Units.setHorizontalTextPosition(0);
        this.jLabel3Units.setVerticalTextPosition(1);
        this.jLabel1.setFont(new Font("Dialog", 1, 25));
        this.jLabel1.setText(this.res.getString("3D"));
        this.jLabel2.setFont(new Font("Dialog", 1, 25));
        this.jLabel2.setText(this.res.getString("Cl"));
        this.jLabel3.setFont(new Font("SansSerif", 1, 25));
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText(this.res.getString("Accuracy"));
        this.ctrlAccuracy.setBackground(Color.black);
        this.ctrlAccuracy.setFont(new Font("SansSerif", 1, 30));
        this.ctrlAccuracy.setForeground(Color.white);
        this.ctrlAccuracy.setEditable(false);
        this.ctrlAccuracy.setHorizontalAlignment(4);
        this.setMaximumSize(new Dimension(5000, 4000));
        this.setMinimumSize(new Dimension(550, 425));
        this.setPreferredSize(new Dimension(550, 425));
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                OpChecksADMPane.this.onComponentResized(componentEvent);
            }
        });
        this.jPanel6.setLayout(this.gridLayout3);
        this.gridLayout3.setColumns(1);
        this.gridLayout3.setRows(7);
        this.gridLayout3.setVgap(1);
        this.ctrlStartStop.setMnemonic('T');
        this.ctrlStartStop.setText(this.res.getString("Start_Test"));
        this.ctrlStartStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OpChecksADMPane.this.ctrlStartStop_actionPerformed(actionEvent);
            }
        });
        this.ctrlHome.setMnemonic('H');
        this.ctrlHome.setText(this.res.getString("Home"));
        this.ctrlHome.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OpChecksADMPane.this.onHome(actionEvent);
            }
        });
        this.ctrlSettings.setText(this.res.getString("Settings_"));
        this.ctrlSettings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OpChecksADMPane.this.onADMSettings(actionEvent);
            }
        });
        this.ctrlMeasure.setText(this.res.getString("Measure"));
        this.ctrlMeasure.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OpChecksADMPane.this.onMeasure(actionEvent);
            }
        });
        this.ctrlMeasure.setEnabled(false);
        this.ctrlMeasure.setMnemonic('M');
        this.gridLayout2.setRows(2);
        this.add((Component)this.jPanel1, null);
        this.jPanel1.add((Component)this.jPanel3, null);
        this.jPanel3.add((Component)this.ctrlInter, new GridBagConstraints(1, 0, 1, 2, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 15, 15));
        this.jPanel3.add((Component)this.ctrlClosure, new GridBagConstraints(1, 2, 1, 2, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 15, 15));
        this.jPanel3.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 3), 5, 5));
        this.jPanel3.add((Component)this.jLabel1Units, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 2, 2, 3), 0, 0));
        this.jPanel3.add((Component)this.jLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 3), 5, 5));
        this.jPanel3.add((Component)this.jLabel2Units, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 2, 2, 3), 0, 0));
        this.jPanel1.add((Component)this.jPanel4, null);
        this.jPanel4.add((Component)this.jLabel3, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 2, 5, 2), 5, 5));
        this.jPanel4.add((Component)this.jLabel3Units, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 2, 2, 2), 0, 0));
        this.jPanel4.add((Component)this.ctrlAccuracy, new GridBagConstraints(0, 2, 1, 2, 1.0, 1.0, 10, 1, new Insets(10, 2, 2, 2), 15, 15));
        this.add((Component)this.jPanel2, null);
        this.jPanel2.add((Component)this.resultsPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 200, 100));
        this.jPanel2.add((Component)this.jPanel6, new GridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(2, 5, 2, 2), 0, 25));
        this.jPanel6.add((Component)this.ctrlSettings, null);
        this.jPanel6.add((Component)this.ctrlStartStop, null);
        this.jPanel6.add((Component)this.ctrlHome, null);
        this.jPanel6.add((Component)this.ctrlMeasure, null);
        this.jPanel6.add((Component)this.ctrlClear, null);
        this.jPanel6.add((Component)this.ctrlSave, null);
        this.jPanel6.add((Component)this.ctrlSaveAs, null);
    }

    private void onComponentResized(ComponentEvent componentEvent) {
        int n;
        Font font = null;
        Font font2 = this.ctrlInter.getFont();
        FontMetrics fontMetrics = ((Component)this.ctrlInter).getFontMetrics(font2);
        int n2 = fontMetrics.stringWidth(this.ctrlInter.getText());
        int n3 = Math.max(n2, n = fontMetrics.stringWidth(this.ctrlClosure.getText()));
        if (n3 == 0) {
            return;
        }
        font = n2 < n ? XTool.calculateMaxFontThatFits(this.ctrlClosure, this.oldDimension) : XTool.calculateMaxFontThatFits(this.ctrlInter, this.oldDimension);
        if (font == null) {
            return;
        }
        this.ctrlInter.setFont(font);
        this.ctrlClosure.setFont(font);
        this.ctrlAccuracy.setFont(font);
    }

    public void displayTargetPosition() {
        double[] dArray = new double[]{this.parentTabPane.radialDistance, this.parentTabPane.azimuthAngle, this.parentTabPane.zenithAngle};
        this.ctrlInter.setText(this.parentTabPane.localLinearUnits.convertToDisplayStr(dArray[0]));
        double d = this.parentTabPane.closureMath.getClosureAgainstTMR(this.parentTabPane.targetType, this.parentTabPane.sightMode, this.parentTabPane.radialDistanceUnCorrected * (double)1000000);
        this.ctrlClosure.setText(this.parentTabPane.localLinearUnits.convertToDisplayStr(d));
        if (!this.fontCalculatedOnce) {
            this.onComponentResized(null);
            this.fontCalculatedOnce = true;
        }
        if (this.parentTabPane.overallStatus == 0) {
            this.ctrlInter.setForeground(Color.white);
            this.ctrlClosure.setForeground(Color.white);
        } else {
            this.ctrlInter.setForeground(Color.red);
            this.ctrlClosure.setForeground(Color.red);
            if (!this.btestInProgress) {
                super.handleBeamBreak();
            }
        }
    }

    void SetDeviationResults(double[] dArray) {
        double d = dArray[0];
        double[] dArray2 = new double[]{dArray[1], dArray[2], dArray[3]};
        String string = this.parentTabPane.localLinearUnits.convertToDisplayStr(d);
        this.ctrlAccuracy.setText(string);
        XMath.pointSphereToCart(dArray2);
        String string2 = this.parentTabPane.localLinearUnits.convertToDisplayStr(dArray2[0]);
        String string3 = this.parentTabPane.localLinearUnits.convertToDisplayStr(dArray2[1]);
        String string4 = this.parentTabPane.localLinearUnits.convertToDisplayStr(dArray2[2]);
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(string2).append("  ").append(string3).append("  ").append(string4).append(this.dataTokenizer);
        stringBuffer.append(XTime.getDate(dArray[4])).append(this.dataTokenizer);
        stringBuffer.append(XTime.getTime(dArray[4])).append(this.dataTokenizer);
        stringBuffer.append(string);
        this.updateResults(stringBuffer.toString());
    }

    private void runStartTest() {
        String string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.res.getString("Please_place_the_SMR")))).append("\n").append(this.res.getString("The_test_starts_by"))));
        int n = JOptionPane.showOptionDialog(this, string, this.res.getString("Instruction"), 2, 1, null, null, null);
        if (n == 2) {
            return;
        }
        this.ctrlClear.setEnabled(false);
        this.ctrlSave.setEnabled(false);
        this.ctrlSaveAs.setEnabled(false);
        this.ctrlStartStop.setEnabled(false);
        this.ctrlSettings.setEnabled(false);
        this.ctrlHome.setEnabled(false);
        this.btestInProgress = true;
        Object[] objectArray = new Object[]{new Integer(14)};
        if (this.startStopTestListener == null) {
            this.startStopTestListener = new StartStopTestCompleteListener();
        }
        this.parentTabPane.doThreadTransaction(objectArray, "", this.startStopTestListener);
    }

    private void runStopTest(boolean bl) {
        this.btestInProgress = false;
        if (bl) {
            Object[] objectArray = new Object[]{new Integer(16)};
            this.parentTabPane.doThreadTransaction(objectArray, "", this.startStopTestListener);
        }
    }

    void ctrlStartStop_actionPerformed(ActionEvent actionEvent) {
        if (this.ctrlStartStop.getText().equals(this.res.getString("Start_Test"))) {
            this.runStartTest();
        } else if (this.ctrlStartStop.getText().equals(this.res.getString("Stop_Test"))) {
            this.runStopTest(true);
        }
    }

    protected void onFocusGained() {
        if (this.parentTabPane.admCapable && !this.parentTabPane.admEnabled) {
            Object[] objectArray = new Object[]{new Integer(21)};
            this.parentTabPane.doThreadTransaction(objectArray, "", null, true);
            Object[] objectArray2 = this.opChecksThread.peekResponse();
            if (objectArray2 != null & objectArray2[0] == null) {
                this.admIsTurnedOn = true;
            }
        }
        super.onFocusGained();
    }

    protected void onFocusLost() {
        super.onFocusLost();
        if (this.admIsTurnedOn) {
            Object[] objectArray = new Object[]{new Integer(22)};
            this.parentTabPane.doThreadTransaction(objectArray, "", null);
        }
        if (this.ctrlStartStop.getText().equals(this.res.getString("Stop_Test"))) {
            this.runStopTest(true);
        }
    }

    protected void enableAllControls(boolean bl) {
        this.ctrlStartStop.setEnabled(bl);
        this.ctrlSettings.setEnabled(bl);
        this.ctrlHome.setEnabled(bl);
    }

    void onMeasure(ActionEvent actionEvent) {
        this.ctrlMeasure.setEnabled(false);
        Object[] objectArray = new Object[]{new Integer(15), new Integer(this.nIfSamples)};
        if (this.admMeasureListener == null) {
            this.admMeasureListener = new ADMMeasureCompleteListener();
        }
        this.parentTabPane.doThreadTransaction(objectArray, "", this.admMeasureListener);
    }

    void onADMSettings(ActionEvent actionEvent) {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("adm_meas_time.int_output")};
        Object[] objectArray = new Object[]{new Integer(17), dataTagArray};
        this.parentTabPane.doThreadTransaction(objectArray, "", this.admMeasureTimeReadListener);
        this.admSettingsDlg = new OpChecksADMSettingsDlg(this, this.res.getString("ADM_Settings"), true);
    }

    void setADMSettings(Object[] objectArray) {
        this.nIfSamples = (Integer)objectArray[0];
        P.rintln(" IF samples = ".concat(String.valueOf(String.valueOf(this.nIfSamples))));
        this.nMeasTimeSecs = (Double)objectArray[1];
        P.rintln(" ADM meas time = ".concat(String.valueOf(String.valueOf(this.nMeasTimeSecs))));
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("adm_meas_time.int_output")};
        Object[] objectArray2 = new Object[]{new Long((long)(this.nMeasTimeSecs * (double)1000000))};
        P.rintln(" ADM meas time (micro secs)= ".concat(String.valueOf(String.valueOf((Long)objectArray2[0]))));
        Object[] objectArray3 = new Object[]{new Integer(18), dataTagArray, objectArray2};
        this.parentTabPane.doThreadTransaction(objectArray3, "", null);
    }

    private class ADMMeasureTimeReadListener
    implements ThreadListener,
    Runnable {
        private OpChecksADMPane pane;

        private ADMMeasureTimeReadListener(OpChecksADMPane opChecksADMPane2) {
            this.pane = opChecksADMPane2;
        }

        public void commandComplete() {
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            Object[] objectArray = OpChecksADMPane.this.opChecksThread.peekResponse();
            if (objectArray[0] == null) {
                Object[] objectArray2 = (Object[])objectArray[2];
                OpChecksADMPane.this.nMeasTimeSecs = (double)((Long)objectArray2[0]).longValue() / (double)1000000;
                Object[] objectArray3 = new Object[]{new Integer(OpChecksADMPane.this.nIfSamples), new Double(OpChecksADMPane.this.nMeasTimeSecs), new Boolean(OpChecksADMPane.this.setBacksight), new Boolean(OpChecksADMPane.this.setResetPt)};
                OpChecksADMPane.this.admSettingsDlg.setUserSettings(objectArray3);
            }
            OpChecksADMPane.this.admSettingsDlg.setLocationRelativeTo(this.pane);
            OpChecksADMPane.this.admSettingsDlg.show();
        }
    }

    private class StartStopTestCompleteListener
    implements ThreadListener,
    Runnable {
        Object[] responseData = null;

        private StartStopTestCompleteListener() {
        }

        public void commandComplete() {
            this.responseData = OpChecksADMPane.this.opChecksThread.peekResponse();
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            if (this.responseData == null || this.responseData != null && this.responseData[0] != null) {
                OpChecksADMPane.this.runStopTest(false);
                return;
            }
            if (OpChecksADMPane.this.ctrlStartStop.getText().equals(OpChecksADMPane.this.res.getString("Start_Test"))) {
                OpChecksADMPane.this.ctrlStartStop.setEnabled(true);
                OpChecksADMPane.this.ctrlStartStop.setText(OpChecksADMPane.this.res.getString("Stop_Test"));
                OpChecksADMPane.this.ctrlMeasure.setEnabled(true);
            } else if (OpChecksADMPane.this.ctrlStartStop.getText().equals(OpChecksADMPane.this.res.getString("Stop_Test"))) {
                OpChecksADMPane.this.ctrlStartStop.setEnabled(true);
                OpChecksADMPane.this.ctrlStartStop.setText(OpChecksADMPane.this.res.getString("Start_Test"));
                OpChecksADMPane.this.ctrlSettings.setEnabled(true);
                OpChecksADMPane.this.ctrlHome.setEnabled(true);
                OpChecksADMPane.this.ctrlMeasure.setEnabled(false);
                if (OpChecksADMPane.this.resultsPanel.isDataAvailable()) {
                    OpChecksADMPane.this.ctrlClear.setEnabled(true);
                    OpChecksADMPane.this.ctrlSave.setEnabled(true);
                    OpChecksADMPane.this.ctrlSaveAs.setEnabled(true);
                }
            }
        }
    }

    private class ADMMeasureCompleteListener
    implements ThreadListener,
    Runnable {
        private Object[] data;

        private ADMMeasureCompleteListener() {
        }

        public void commandComplete() {
            this.data = OpChecksADMPane.this.opChecksThread.peekResponse();
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            if (this.data[0] == null && this.data[2] != null) {
                OpChecksADMPane.this.SetDeviationResults((double[])this.data[2]);
            }
            OpChecksADMPane.this.ctrlStartStop.setEnabled(true);
            OpChecksADMPane.this.ctrlMeasure.setEnabled(true);
        }
    }
}

