/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.apps4xxx.measurepad;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import smx.tracker.apps4xxx.measurepad.MeasureSetupDlg_button1_actionAdapter;
import smx.tracker.apps4xxx.measurepad.MeasureSetupDlg_button2_actionAdapter;
import smx.tracker.apps4xxx.measurepad.MeasureSetupDlg_this_windowAdapter;
import smx.tracker.apps4xxx.utility.tools.XTool;

public class MeasureSetupDlg
extends JDialog {
    private JFrame frame;
    ResourceBundle res = ResourceBundle.getBundle("smx.tracker.apps4xxx.measurepad.MeaurePadRes", Locale.getDefault());
    DisableTimeDistanceInputListener noneContDigiListener = new DisableTimeDistanceInputListener();
    int initialTriggerSet = 0;
    int nextTriggerSet = 0;
    boolean sendDataToFile = false;
    boolean sendDataToSocket = true;
    String outputFileName;
    String outputDirectory;
    String outputFileNamePath;
    boolean appendToFile;
    String distanceUnits;
    int nsamples = 2000;
    double timeInterval = -1.0;
    double distanceInterval = -1.0;
    String initialTriggerString;
    String nextTriggerString;
    String samplesString;
    String outputFileNameOld;
    String outputDirectoryOld;
    String outputFileNamePathOld;
    boolean appendToFileOld;
    static final int INITIAL_TRIGGER_IMMEDIATE = 0;
    static final int INITIAL_TRIGGER_DIGITAL = 1;
    static final int NEXT_TRIGGER_NONE = 0;
    static final int NEXT_TRIGGER_TIME = 1;
    static final int NEXT_TRIGGER_DISTANCE = 2;
    static final int NEXT_TRIGGER_CONTINUOUS = 3;
    static final int NEXT_TRIGGER_DIGITAL = 4;
    JPanel panel1 = new JPanel();
    JPanel panel2 = new JPanel();
    JButton button1 = new JButton();
    JButton button2 = new JButton();
    Border border1;
    JPanel jPanel1 = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GridLayout gridLayout1 = new GridLayout();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JPanel jPanel2 = new JPanel();
    JPanel jPanel3 = new JPanel();
    JPanel jPanel4 = new JPanel();
    JPanel jPanel5 = new JPanel();
    JLabel jpanel2Dummy1 = new JLabel();
    JLabel jpanel2Dummy2 = new JLabel();
    GridLayout gridLayout2 = new GridLayout();
    ButtonGroup initalTriggerGroup = new ButtonGroup();
    ButtonGroup nextTriggerGroup = new ButtonGroup();
    Border border2;
    TitledBorder titledBorder1;
    Border border3;
    Border border4;
    TitledBorder titledBorder2;
    Border border5;
    Border border6;
    TitledBorder titledBorder3;
    Border border7;
    JRadioButton ctrlDigitalFirst = new JRadioButton();
    JRadioButton ctrlImmediate = new JRadioButton();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    JRadioButton ctrlNone = new JRadioButton();
    JRadioButton ctrlTime = new JRadioButton();
    JRadioButton ctrlDistance = new JRadioButton();
    JRadioButton ctrlContinuous = new JRadioButton();
    JRadioButton ctrlDigitalNext = new JRadioButton();
    JTextField ctrlTimeInput = new JTextField();
    JTextField ctrlDistanceInput = new JTextField();
    JLabel ctrlTimeUnits = new JLabel();
    JLabel ctrlDistanceUnits = new JLabel();
    Component component2;
    GridBagLayout gridBagLayout4 = new GridBagLayout();
    JCheckBox ctrlToSocket = new JCheckBox();
    JCheckBox ctrlToFile = new JCheckBox();
    JButton ctrlBrowse = new JButton();
    JTextField ctrlFileName = new JTextField();
    Component component1;
    Component component3;
    Component component4;
    JLabel jpanel4Dummy1 = new JLabel();
    JLabel jpanel4Dummy2 = new JLabel();
    GridBagLayout gridBagLayout5 = new GridBagLayout();
    JLabel jLabel3 = new JLabel();
    JTextField ctrlSamples = new JTextField();
    Component component5;
    Component component6;

    public MeasureSetupDlg(String string, JFrame jFrame, String string2, boolean bl) {
        super(jFrame, string2, bl);
        this.frame = jFrame;
        this.distanceUnits = string;
        try {
            this.outputFileName = new String("SMXHolos.csv");
            this.outputDirectory = new String(".");
            this.outputFileNamePath = this.outputFileName;
            this.outputFileNameOld = this.outputFileName;
            this.outputDirectoryOld = this.outputDirectory;
            this.outputFileNamePathOld = this.outputFileNamePath;
            this.appendToFileOld = this.appendToFile;
            this.jbInit();
            this.initialiseDlg();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.pack();
    }

    void button1_actionPerformed(ActionEvent actionEvent) {
        if (!this.updateDlgData()) {
            return;
        }
        ((Component)this).setVisible(false);
    }

    boolean updateDlgData() {
        String string;
        if (this.ctrlImmediate.isSelected()) {
            this.initialTriggerSet = 0;
            this.initialTriggerString = this.res.getString("Immediate");
        } else {
            this.initialTriggerSet = 1;
            this.initialTriggerString = this.res.getString("Digital");
        }
        if (this.ctrlNone.isSelected()) {
            this.nextTriggerSet = 0;
            this.nextTriggerString = this.res.getString("None");
        } else if (this.ctrlTime.isSelected()) {
            string = this.ctrlTimeInput.getText();
            if (string.length() < 1) {
                JOptionPane.showMessageDialog(this, this.res.getString("Time_Input_Error_Msg"), this.res.getString("Time_Input_Error"), 0);
                return false;
            }
            this.timeInterval = Double.parseDouble(string);
            if (this.timeInterval < 0.0 || this.timeInterval < 1.0E-14) {
                JOptionPane.showMessageDialog(this, this.res.getString("Time_Input_Error_Msg"), this.res.getString("Time_Input_Error"), 0);
                return false;
            }
            this.nextTriggerSet = 1;
            this.nextTriggerString = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" ").append(this.res.getString("Time_unit"))));
        } else if (this.ctrlDistance.isSelected()) {
            string = this.ctrlDistanceInput.getText();
            if (string.length() < 1) {
                JOptionPane.showMessageDialog(this, this.res.getString("Distance_Input_Error_Msg"), this.res.getString("Distance_Input_Error"), 0);
                return false;
            }
            this.distanceInterval = Double.parseDouble(string);
            if (this.distanceInterval < 0.0 || this.distanceInterval < 1.0E-14) {
                JOptionPane.showMessageDialog(this, this.res.getString("Distance_Input_Error_Msg"), this.res.getString("Distance_Input_Error"), 0);
                return false;
            }
            this.nextTriggerSet = 2;
            this.nextTriggerString = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" ").append(this.ctrlDistanceUnits.getText())));
        } else if (this.ctrlContinuous.isSelected()) {
            this.nextTriggerSet = 3;
            this.nextTriggerString = this.res.getString("Continuous");
        } else if (this.ctrlDigitalNext.isSelected()) {
            this.nextTriggerSet = 4;
            this.nextTriggerString = this.res.getString("Digital");
        }
        this.sendDataToFile = this.ctrlToFile.isSelected();
        this.outputFileName = this.ctrlFileName.getText();
        if (this.outputDirectory.equals(".")) {
            this.outputFileNamePath = this.outputFileName;
        } else {
            string = new String(":".concat(String.valueOf(String.valueOf(File.separator))));
            if (this.outputFileName.regionMatches(1, string, 1, 2)) {
                this.outputFileNamePath = this.outputFileName;
            } else {
                if (this.outputFileName.indexOf(File.separatorChar) != -1) {
                    JOptionPane.showMessageDialog(this, this.res.getString("File_Name_Error_Msg"), this.res.getString("File_Name_Error"), 0);
                    return false;
                }
                this.outputFileNamePath = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.outputDirectory))).append(File.separator).append(this.outputFileName)));
            }
        }
        if (this.sendDataToFile && this.outputFileName.length() < 1) {
            JOptionPane.showMessageDialog(this, this.res.getString("File_Not_Specified_Error_Msg"), this.res.getString("File_Not_Specified_Error"), 0);
            return false;
        }
        this.sendDataToSocket = this.ctrlToSocket.isSelected();
        this.samplesString = this.ctrlSamples.getText();
        if (this.samplesString.length() < 1) {
            JOptionPane.showMessageDialog(this, this.res.getString("Sample_Pt_Error_Msg"), this.res.getString("Sample_Pt_Error"), 0);
            return false;
        }
        this.nsamples = Integer.parseInt(this.samplesString);
        this.outputFileNameOld = this.outputFileName;
        this.outputDirectoryOld = this.outputDirectory;
        this.outputFileNamePathOld = this.outputFileNamePath;
        this.appendToFileOld = this.appendToFile;
        return true;
    }

    void initialiseDlg() {
        if (this.initialTriggerSet == 0) {
            this.ctrlImmediate.setSelected(true);
        } else {
            this.ctrlDigitalFirst.setSelected(true);
        }
        switch (this.nextTriggerSet) {
            case 0: {
                this.ctrlNone.setSelected(true);
                this.disableTimeAndDistanceInput();
                break;
            }
            case 1: {
                this.ctrlTime.setSelected(true);
                this.enableTimeInput();
                this.setTimeInterval(this.timeInterval);
                break;
            }
            case 2: {
                this.ctrlDistance.setSelected(true);
                this.enableDistanceInput();
                this.setDistanceInterval(this.distanceInterval);
                break;
            }
            case 3: {
                this.ctrlContinuous.setSelected(true);
                this.disableTimeAndDistanceInput();
                break;
            }
            case 4: {
                this.ctrlDigitalNext.setSelected(true);
                this.disableTimeAndDistanceInput();
            }
        }
        if (this.timeInterval == (double)-1) {
            this.ctrlTimeInput.setText(null);
        }
        if (this.distanceInterval == (double)-1) {
            this.ctrlDistanceInput.setText(null);
        }
        this.ctrlToFile.setSelected(this.sendDataToFile);
        this.ctrlFileName.setEnabled(this.sendDataToFile);
        this.ctrlFileName.setText(this.outputFileName);
        this.ctrlBrowse.setEnabled(this.sendDataToFile);
        this.ctrlToSocket.setSelected(this.sendDataToSocket);
        this.ctrlSamples.setText(Integer.toString(this.nsamples));
    }

    void button2_actionPerformed(ActionEvent actionEvent) {
        this.outputFileName = this.outputFileNameOld;
        this.outputDirectory = this.outputDirectoryOld;
        this.outputFileNamePath = this.outputFileNamePathOld;
        this.appendToFile = this.appendToFileOld;
        this.ctrlFileName.setText(this.outputFileName);
        this.initialiseDlg();
        ((Component)this).setVisible(false);
        ((Component)this).setVisible(false);
    }

    void this_windowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    void ctrlToFile_actionPerformed(ActionEvent actionEvent) {
        this.ctrlFileName.setEnabled(this.ctrlToFile.isSelected());
        this.ctrlBrowse.setEnabled(this.ctrlToFile.isSelected());
    }

    void enableTimeInput() {
        this.ctrlTimeInput.setEnabled(true);
        this.ctrlTimeUnits.setEnabled(true);
        this.ctrlDistanceInput.setEnabled(false);
        this.ctrlDistanceUnits.setEnabled(false);
    }

    void setTimeInterval(double d) {
        this.ctrlTimeInput.setText(Double.toString(d));
    }

    void enableDistanceInput() {
        this.ctrlTimeInput.setEnabled(false);
        this.ctrlTimeUnits.setEnabled(false);
        this.ctrlDistanceInput.setEnabled(true);
        this.ctrlDistanceUnits.setEnabled(true);
    }

    void setDistanceInterval(double d) {
        this.ctrlDistanceInput.setText(Double.toString(d));
    }

    void disableTimeAndDistanceInput() {
        this.ctrlTimeInput.setEnabled(false);
        this.ctrlTimeUnits.setEnabled(false);
        this.ctrlDistanceInput.setEnabled(false);
        this.ctrlDistanceUnits.setEnabled(false);
    }

    void onTimeTrigger(ActionEvent actionEvent) {
        this.enableTimeInput();
    }

    void onDistanceTrigger(ActionEvent actionEvent) {
        this.enableDistanceInput();
    }

    void onBrowse(ActionEvent actionEvent) {
        String string = this.res.getString("Text_files");
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(",".concat(String.valueOf(String.valueOf(this.res.getString("_txt")))))));
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(";".concat(String.valueOf(String.valueOf(this.res.getString("CSV_files")))))));
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(",".concat(String.valueOf(String.valueOf(this.res.getString("_csv")))))));
        String[] stringArray = XTool.openFileSaveAsChooser(this.frame, this.res.getString("Save_results_to"), null, this.res.getString("Append_to_file"), this.appendToFile, this.outputFileName, this.outputDirectory, string, this.res.getString("Invalid_file_error"), this.res.getString("Invalid_file_error_msg"), this.res.getString("File_open_error"), this.res.getString("File_open_error_msg"));
        if (stringArray != null) {
            this.appendToFile = XTool.isDataAppended();
            if (stringArray[0] != null) {
                this.outputDirectory = stringArray[0];
            }
            if (stringArray[1] != null) {
                this.outputFileName = stringArray[1];
                this.ctrlFileName.setText(this.outputFileName);
            }
        }
    }

    public static boolean isValidFile(File file) {
        String string = file.getName().toLowerCase();
        return string.endsWith(".csv") || string.endsWith(".txt");
    }

    private void jbInit() throws Exception {
        this.ctrlDistanceUnits.setText(this.distanceUnits);
        this.ctrlImmediate.setSelected(true);
        this.ctrlNone.setSelected(true);
        this.ctrlFileName.setText(this.outputFileName);
        this.ctrlSamples.setText(Integer.toString(this.nsamples));
        this.border1 = BorderFactory.createRaisedBevelBorder();
        this.border2 = new EtchedBorder(0, Color.white, new Color(134, 134, 134));
        this.titledBorder1 = new TitledBorder(this.border2, this.res.getString("Initial_trigger"));
        this.border3 = BorderFactory.createCompoundBorder(this.titledBorder1, BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.border4 = new EtchedBorder(0, Color.white, new Color(134, 134, 134));
        this.titledBorder2 = new TitledBorder(this.border4, this.res.getString("Subsequent_trigger"));
        this.border5 = BorderFactory.createCompoundBorder(this.titledBorder2, BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.border6 = new EtchedBorder(0, Color.white, new Color(134, 134, 134));
        this.titledBorder3 = new TitledBorder(this.border6, this.res.getString("Send_data"));
        this.border7 = BorderFactory.createCompoundBorder(this.titledBorder3, BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.component2 = Box.createHorizontalStrut(8);
        this.component1 = Box.createHorizontalStrut(8);
        this.component3 = Box.createHorizontalStrut(8);
        this.component4 = Box.createHorizontalStrut(8);
        this.component5 = Box.createHorizontalStrut(8);
        this.component6 = Box.createHorizontalStrut(8);
        this.jPanel1.setLayout(this.gridLayout1);
        this.panel2.setBorder(this.border1);
        this.panel2.setLayout(this.gridBagLayout2);
        this.button1.setText(this.res.getString("OK"));
        this.button1.addActionListener(new MeasureSetupDlg_button1_actionAdapter(this));
        this.button2.setText(this.res.getString("Cancel"));
        this.gridLayout1.setHgap(4);
        this.button2.addActionListener(new MeasureSetupDlg_button2_actionAdapter(this));
        this.addWindowListener(new MeasureSetupDlg_this_windowAdapter(this));
        this.panel1.setLayout(this.gridBagLayout1);
        this.ctrlTimeInput.setEnabled(false);
        this.ctrlDistanceInput.setEnabled(false);
        this.ctrlTimeUnits.setEnabled(false);
        this.ctrlDistanceUnits.setEnabled(false);
        this.ctrlNone.addActionListener(this.noneContDigiListener);
        this.ctrlContinuous.addActionListener(this.noneContDigiListener);
        this.ctrlDigitalNext.addActionListener(this.noneContDigiListener);
        this.ctrlTime.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MeasureSetupDlg.this.onTimeTrigger(actionEvent);
            }
        });
        this.ctrlDistance.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MeasureSetupDlg.this.onDistanceTrigger(actionEvent);
            }
        });
        this.ctrlFileName.setEnabled(false);
        this.ctrlBrowse.setEnabled(false);
        this.ctrlBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MeasureSetupDlg.this.onBrowse(actionEvent);
            }
        });
        this.ctrlDigitalNext.setActionCommand("DigitalNext");
        this.ctrlDigitalFirst.setActionCommand("DigitalFirst");
        this.ctrlContinuous.setPreferredSize(new Dimension(89, 25));
        this.ctrlContinuous.setMaximumSize(new Dimension(89, 25));
        this.ctrlContinuous.setMinimumSize(new Dimension(89, 25));
        this.ctrlToSocket.setPreferredSize(new Dimension(87, 25));
        this.ctrlToSocket.setMaximumSize(new Dimension(87, 25));
        this.ctrlToSocket.setMinimumSize(new Dimension(87, 25));
        this.initalTriggerGroup.add(this.ctrlImmediate);
        this.initalTriggerGroup.add(this.ctrlDigitalFirst);
        this.nextTriggerGroup.add(this.ctrlNone);
        this.nextTriggerGroup.add(this.ctrlTime);
        this.nextTriggerGroup.add(this.ctrlDistance);
        this.nextTriggerGroup.add(this.ctrlContinuous);
        this.nextTriggerGroup.add(this.ctrlDigitalNext);
        this.jPanel2.setLayout(this.gridLayout2);
        this.jPanel3.setLayout(this.gridBagLayout3);
        this.jPanel4.setLayout(this.gridBagLayout4);
        this.jPanel5.setLayout(this.gridBagLayout5);
        this.gridLayout2.setRows(2);
        this.gridLayout2.setVgap(2);
        this.jPanel2.setBorder(this.border3);
        this.jPanel3.setBorder(this.border5);
        this.jPanel4.setBorder(this.border7);
        this.ctrlDigitalFirst.setText(this.res.getString("Digital"));
        this.ctrlImmediate.setText(this.res.getString("Immediate"));
        this.ctrlNone.setPreferredSize(new Dimension(89, 25));
        this.ctrlNone.setMaximumSize(new Dimension(89, 25));
        this.ctrlNone.setMinimumSize(new Dimension(89, 25));
        this.ctrlNone.setText(this.res.getString("None"));
        this.ctrlTime.setPreferredSize(new Dimension(89, 25));
        this.ctrlTime.setMaximumSize(new Dimension(89, 25));
        this.ctrlTime.setMinimumSize(new Dimension(89, 25));
        this.ctrlTime.setText(this.res.getString("Time"));
        this.ctrlDistance.setPreferredSize(new Dimension(89, 25));
        this.ctrlDistance.setMaximumSize(new Dimension(89, 25));
        this.ctrlDistance.setMinimumSize(new Dimension(89, 25));
        this.ctrlDistance.setText(this.res.getString("Distance"));
        this.ctrlContinuous.setText(this.res.getString("Continuous"));
        this.ctrlDigitalNext.setPreferredSize(new Dimension(89, 25));
        this.ctrlDigitalNext.setMaximumSize(new Dimension(89, 25));
        this.ctrlDigitalNext.setMinimumSize(new Dimension(89, 25));
        this.ctrlDigitalNext.setText(this.res.getString("Digital"));
        this.ctrlTimeInput.setMaximumSize(new Dimension(63, 21));
        this.ctrlTimeInput.setMinimumSize(new Dimension(63, 21));
        this.ctrlTimeInput.setPreferredSize(new Dimension(63, 21));
        this.ctrlTimeInput.setToolTipText("");
        this.ctrlDistanceInput.setMaximumSize(new Dimension(63, 21));
        this.ctrlDistanceInput.setMinimumSize(new Dimension(63, 21));
        this.ctrlDistanceInput.setPreferredSize(new Dimension(63, 21));
        this.ctrlTimeUnits.setText(this.res.getString("Time_unit"));
        this.ctrlToSocket.setText(this.res.getString("To_Holos"));
        this.ctrlToFile.setPreferredSize(new Dimension(87, 25));
        this.ctrlToFile.setMaximumSize(new Dimension(87, 25));
        this.ctrlToFile.setMinimumSize(new Dimension(87, 25));
        this.ctrlToFile.setText(this.res.getString("To_File"));
        this.ctrlToFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MeasureSetupDlg.this.ctrlToFile_actionPerformed(actionEvent);
            }
        });
        this.ctrlBrowse.setMaximumSize(new Dimension(75, 25));
        this.ctrlBrowse.setMinimumSize(new Dimension(75, 25));
        this.ctrlBrowse.setPreferredSize(new Dimension(75, 25));
        this.ctrlBrowse.setMargin(new Insets(2, 5, 2, 5));
        this.ctrlBrowse.setText(this.res.getString("Browse"));
        this.ctrlFileName.setMaximumSize(new Dimension(93, 25));
        this.ctrlFileName.setMinimumSize(new Dimension(93, 25));
        this.ctrlFileName.setPreferredSize(new Dimension(93, 25));
        this.jLabel3.setMaximumSize(new Dimension(181, 25));
        this.jLabel3.setMinimumSize(new Dimension(181, 25));
        this.jLabel3.setPreferredSize(new Dimension(181, 25));
        this.jLabel3.setText(this.res.getString("Number_of_samples_per_pt"));
        this.ctrlSamples.setMaximumSize(new Dimension(63, 25));
        this.ctrlSamples.setMinimumSize(new Dimension(63, 25));
        this.ctrlSamples.setPreferredSize(new Dimension(63, 25));
        this.panel1.setMinimumSize(new Dimension(330, 415));
        this.panel1.setPreferredSize(new Dimension(330, 415));
        this.panel1.add((Component)this.panel2, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.panel2.add((Component)this.jPanel2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel2.add((Component)this.ctrlImmediate, null);
        this.jPanel2.add((Component)this.ctrlDigitalFirst, null);
        this.panel2.add((Component)this.jPanel3, new GridBagConstraints(0, 1, 1, 2, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel3.add((Component)this.ctrlNone, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel3.add((Component)this.ctrlTime, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel3.add((Component)this.ctrlDistance, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel3.add((Component)this.ctrlContinuous, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel3.add((Component)this.ctrlDigitalNext, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel3.add((Component)this.ctrlTimeInput, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel3.add((Component)this.ctrlDistanceInput, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel3.add((Component)this.ctrlTimeUnits, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel3.add((Component)this.ctrlDistanceUnits, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel3.add(this.component2, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.panel2.add((Component)this.jPanel4, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel4.add((Component)this.ctrlToFile, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel4.add((Component)this.ctrlBrowse, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 0, 2, 2), 0, 0));
        this.jPanel4.add((Component)this.ctrlFileName, new GridBagConstraints(2, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel4.add(this.component1, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel4.add((Component)this.ctrlToSocket, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel4.add(this.component3, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 5, 0));
        this.jPanel4.add(this.component4, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 5, 0));
        this.jPanel4.add((Component)this.jpanel4Dummy1, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel4.add((Component)this.jpanel4Dummy2, new GridBagConstraints(3, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panel2.add((Component)this.jPanel5, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 4, 2), 0, 0));
        this.jPanel5.add((Component)this.jLabel3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel5.add((Component)this.ctrlSamples, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 0, 2, 2), 0, 0));
        this.jPanel5.add(this.component5, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel5.add(this.component6, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 15, 0));
        this.panel2.add((Component)this.jpanel2Dummy1, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.panel2.add((Component)this.jpanel2Dummy2, new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.panel1.add((Component)this.jPanel1, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(8, 2, 2, 2), 0, 0));
        this.jPanel1.add((Component)this.button1, null);
        this.jPanel1.add((Component)this.button2, null);
        this.getContentPane().add(this.panel1);
    }

    static {
        INITIAL_TRIGGER_IMMEDIATE = 0;
        INITIAL_TRIGGER_DIGITAL = 1;
        NEXT_TRIGGER_NONE = 0;
        NEXT_TRIGGER_TIME = 1;
        NEXT_TRIGGER_DISTANCE = 2;
        NEXT_TRIGGER_CONTINUOUS = 3;
        NEXT_TRIGGER_DIGITAL = 4;
    }

    private class DisableTimeDistanceInputListener
    implements ActionListener {
        private DisableTimeDistanceInputListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MeasureSetupDlg.this.disableTimeAndDistanceInput();
        }
    }

    private class CSVTextFileFilter
    extends FileFilter {
        private String fileExtension;
        private String fileType;

        CSVTextFileFilter(String string, String string2) {
            this.fileType = string;
            this.fileExtension = string2;
        }

        public String getDescription() {
            return MeasureSetupDlg.this.res.getString(this.fileType);
        }

        public boolean accept(File file) {
            if (file == null) {
                return false;
            }
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName().toLowerCase();
            return string.endsWith(MeasureSetupDlg.this.res.getString(this.fileExtension));
        }
    }
}

