/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.apps4xxx.measurepad;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import smx.tracker.AverageFilter;
import smx.tracker.ContinueTrigger;
import smx.tracker.DistanceTrigger;
import smx.tracker.ExternalContinueTrigger;
import smx.tracker.ExternalStartTrigger;
import smx.tracker.Filter;
import smx.tracker.InterfaceBusyException;
import smx.tracker.IntervalTrigger;
import smx.tracker.MeasureCfg;
import smx.tracker.MeasurePointData;
import smx.tracker.NullContinueTrigger;
import smx.tracker.NullFilter;
import smx.tracker.NullStartTrigger;
import smx.tracker.SMRTargetType;
import smx.tracker.StartTrigger;
import smx.tracker.TargetType;
import smx.tracker.Tracker;
import smx.tracker.TrackerApp;
import smx.tracker.TrackerException;
import smx.tracker.apps4xxx.measurepad.DataThread;
import smx.tracker.apps4xxx.measurepad.FileOpenFailed;
import smx.tracker.apps4xxx.measurepad.MeasurePad_ctrlMeasure_actionAdapter;
import smx.tracker.apps4xxx.measurepad.MeasurePad_ctrlStop_actionAdapter;
import smx.tracker.apps4xxx.measurepad.MeasureSetupDlg;
import smx.tracker.apps4xxx.utility.XMath;
import smx.tracker.apps4xxx.utility.tools.P;
import smx.tracker.apps4xxx.utility.tools.XTool;
import smx.tracker.event.BusyEvent;
import smx.tracker.event.BusyListener;
import smx.tracker.event.FactoryBkndMeasureDataEvent;
import smx.tracker.event.FactoryBkndMeasureDataListener;
import smx.tracker.event.MeasureDataEvent;
import smx.tracker.event.MeasureDataListener;
import smx.utility.UnitsConversion;

public class MeasurePad
extends TrackerApp {
    private FileOpenFailedImplementor fileOpenFailedImplementor = new FileOpenFailedImplementor();
    private int listenerPtCount = 0;
    FactoryBkndMeasureDataImplementer factoryBkndDataListener = new FactoryBkndMeasureDataImplementer();
    boolean appIsStable = false;
    ResourceBundle res = ResourceBundle.getBundle("smx.tracker.apps4xxx.measurepad.MeaurePadRes", Locale.getDefault());
    private final int VERY_QUICK_SAMPLE_RATE = 1;
    private final double FACTORY_BKND_DATA_LISTENER_RATE = 0.25;
    private final int WAIT_TIME_BEFORE_STARTING_FACTORY_BKND_MEASUREMENTS = 1000;
    private MeasureSetupDlg measureSetupDlg;
    private BusyThreadListener busyListener = new BusyThreadListener();
    private MeasureDataImplementer measureDataListener = new MeasureDataImplementer();
    private boolean hasExclusiveAccess = false;
    int npts = 0;
    private boolean oldBlockSetting;
    private int portNumber = 0;
    UnitsConversion localLinearUnits;
    UnitsConversion localAngularUnits;
    UnitsConversion localTemperatureUnits;
    UnitsConversion localPressureUnits;
    JFrame localFrame;
    DataThread dataThreadSocket;
    boolean measureSinglePointOnly = true;
    private double probeDiameter;
    private boolean factoryBkndMeasurementsStarted = false;
    private boolean foregroundMeasurementsInProgress = false;
    private boolean closeButtonClicked;
    private boolean factoryBkndMeasureBlocking;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JLabel jlblDummy1 = new JLabel();
    JLabel jlblDummy2 = new JLabel();
    Border border1;
    TitledBorder titledBorder1;
    Border border2;
    Border border3;
    TitledBorder titledBorder2;
    Border border4;
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JLabel jLabel1 = new JLabel();
    JLabel ctrlX = new JLabel();
    JLabel ctrlY = new JLabel();
    JLabel ctrlZ = new JLabel();
    JLabel ctrlI = new JLabel();
    JLabel ctrlJ = new JLabel();
    JLabel ctrlK = new JLabel();
    JLabel ctrlPtCount = new JLabel();
    JLabel ctrlInitialTrigger = new JLabel();
    JLabel ctrlNextTrigger = new JLabel();
    JLabel ctrlSamples = new JLabel();
    JLabel ctrlOutputFile = new JLabel();
    JLabel ctrlSocket = new JLabel();
    JLabel jLabel2 = new JLabel();
    JLabel jLabel3 = new JLabel();
    JLabel jLabel4 = new JLabel();
    JLabel jLabel5 = new JLabel();
    JLabel jLabel6 = new JLabel();
    JLabel jLabel7 = new JLabel();
    JLabel jLabel8 = new JLabel();
    JLabel jLabel9 = new JLabel();
    JLabel jLabel10 = new JLabel();
    JLabel jlblDummy3 = new JLabel();
    JLabel jlblDummy4 = new JLabel();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    JPanel jPanel3 = new JPanel();
    JPanel jPanel4 = new JPanel();
    JLabel jpanel4Dummy1 = new JLabel();
    JLabel jpanel4Dummy2 = new JLabel();
    JLabel jpanel4Dummy3 = new JLabel();
    GridBagLayout gridBagLayout4 = new GridBagLayout();
    JLabel jLabel11 = new JLabel();
    JLabel jLabel12 = new JLabel();
    JLabel jLabel13 = new JLabel();
    JLabel jpanel3Dummy2 = new JLabel();
    JLabel jpanel3Dummy1 = new JLabel();
    JLabel jlblOutputFile = new JLabel();
    JLabel jlblSocket = new JLabel();
    GridBagLayout gridBagLayout5 = new GridBagLayout();
    JButton ctrlMeasure = new JButton();
    JButton ctrlSetup = new JButton();
    JButton ctrlStop = new JButton();
    Component component3;
    JButton ctrlClose = new JButton();
    Component component1;
    Border border6;
    Border border5;
    TitledBorder titledBorder3;
    JLabel jlblPositionReadOut = new JLabel();

    public MeasurePad(String string, Tracker tracker, JFrame jFrame) throws Exception {
        super(string, tracker, jFrame);
        this.localFrame = jFrame;
        this.localLinearUnits = this.lengthUnits;
        this.localAngularUnits = this.angularUnits;
        this.localTemperatureUnits = this.temperatureUnits;
        this.localPressureUnits = this.pressureUnits;
        try {
            this.jbInit();
            this.processParam(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.dataThreadSocket = new DataThread("Socket Data thread", null, null, this.portNumber, this.localLinearUnits);
            this.measureSetupDlg = new MeasureSetupDlg(this.localLinearUnits.displayName(), jFrame, this.res.getString("Measurement_setup"), true);
            this.trk.addBusyListener((BusyListener)new StartAppBusyListener(this.trk));
        }
        catch (Exception exception) {
            this.shutDownDataThread();
            throw exception;
        }
    }

    void onSetup(ActionEvent actionEvent) {
        this.measureSetupDlg.updateDlgData();
        ((Component)this.measureSetupDlg).setVisible(true);
        this.ctrlInitialTrigger.setText(this.measureSetupDlg.initialTriggerString);
        this.ctrlNextTrigger.setText(this.measureSetupDlg.nextTriggerString);
        this.ctrlSamples.setText(this.measureSetupDlg.samplesString);
        if (this.measureSetupDlg.sendDataToFile) {
            this.ctrlOutputFile.setText(this.measureSetupDlg.outputFileName);
        } else {
            this.ctrlOutputFile.setText(null);
        }
        if (this.measureSetupDlg.sendDataToSocket) {
            this.ctrlSocket.setText(this.res.getString("Yes"));
        } else {
            this.ctrlSocket.setText(this.res.getString("No"));
        }
        this.dataThreadSocket.enableDataTransmissionToSocket(this.measureSetupDlg.sendDataToSocket);
    }

    private void setExclusiveAccess() throws TrackerException {
        int n;
        if (this.hasExclusiveAccess) {
            return;
        }
        for (n = 0; n < 10; ++n) {
            try {
                this.trk.setExclusiveAccess();
                break;
            }
            catch (InterfaceBusyException interfaceBusyException) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        if (10 == n) {
            this.trk.setExclusiveAccess();
        }
        this.hasExclusiveAccess = true;
    }

    void onMeasure(ActionEvent actionEvent) {
        this.npts = 0;
        this.listenerPtCount = 0;
        this.ctrlMeasure.setEnabled(false);
        this.ctrlClose.setEnabled(false);
        this.ctrlSetup.setEnabled(false);
        try {
            this.oldBlockSetting = this.trk.getBlocking();
            this.trk.setBlocking(true);
            this.setExclusiveAccess();
        }
        catch (TrackerException trackerException) {
            XTool.displayErrorToUser(trackerException, this.res.getString("Tracker_Error"), this.frame);
            return;
        }
        NullStartTrigger nullStartTrigger = null;
        switch (this.measureSetupDlg.initialTriggerSet) {
            case 0: {
                nullStartTrigger = new NullStartTrigger();
                break;
            }
            case 1: {
                nullStartTrigger = new ExternalStartTrigger();
            }
        }
        ExternalContinueTrigger externalContinueTrigger = null;
        switch (this.measureSetupDlg.nextTriggerSet) {
            case 0: {
                this.measureSinglePointOnly = true;
                externalContinueTrigger = new NullContinueTrigger();
                break;
            }
            case 1: {
                externalContinueTrigger = new IntervalTrigger(this.measureSetupDlg.timeInterval);
                this.measureSinglePointOnly = false;
                break;
            }
            case 2: {
                externalContinueTrigger = new DistanceTrigger(this.localLinearUnits.convertFrom(this.measureSetupDlg.distanceInterval));
                this.measureSinglePointOnly = false;
                break;
            }
            case 3: {
                externalContinueTrigger = new IntervalTrigger((double)(this.measureSetupDlg.nsamples / 1000) + 0.01);
                this.measureSinglePointOnly = false;
                break;
            }
            case 4: {
                externalContinueTrigger = new ExternalContinueTrigger();
                this.measureSinglePointOnly = false;
            }
        }
        this.trk.addMeasureDataListener((MeasureDataListener)this.measureDataListener);
        if (this.measureSetupDlg.sendDataToFile) {
            this.dataThreadSocket.resetOutPutFileName(this.measureSetupDlg.outputFileNamePath, this.measureSetupDlg.appendToFile, this.fileOpenFailedImplementor);
        }
        try {
            this.probeDiameter = this.readProbeDiameter();
            this.trk.startMeasurePoint(new MeasureCfg(this.measureSetupDlg.nsamples, (Filter)new AverageFilter(), (StartTrigger)nullStartTrigger, (ContinueTrigger)externalContinueTrigger));
        }
        catch (TrackerException trackerException) {
            XTool.displayErrorToUser(trackerException, this.res.getString("Tracker_Error"), this.frame);
            this.clearExclusiveAccessSetupForMeasurement();
            return;
        }
        this.ctrlX.setBackground(Color.lightGray);
        this.ctrlY.setBackground(Color.lightGray);
        this.ctrlZ.setBackground(Color.lightGray);
        this.ctrlStop.setEnabled(true);
        this.foregroundMeasurementsInProgress = true;
    }

    double readProbeDiameter() throws TrackerException {
        TargetType targetType = this.trk.targetType();
        if (targetType instanceof SMRTargetType) {
            return ((SMRTargetType)targetType).getDiameter();
        }
        return -1.0;
    }

    void clearExclusiveAccessSetupForMeasurement() {
        try {
            this.trk.stopMeasurePoint();
            this.trk.setBlocking(this.oldBlockSetting);
            this.trk.clearExclusiveAccess();
            this.ctrlStop.setEnabled(false);
        }
        catch (TrackerException trackerException) {
            XTool.displayErrorToUser(trackerException, this.res.getString("Tracker_Error"), this.frame);
        }
    }

    void onStopMeasurement(ActionEvent actionEvent) {
        this.trk.removeMeasureDataListener((MeasureDataListener)this.measureDataListener);
        this.clearExclusiveAccessSetupForMeasurement();
        this.dataThreadSocket.flushDataBuffer();
        if (this.measureSetupDlg.sendDataToFile) {
            this.dataThreadSocket.resetOutPutFileName(null, false, null);
        }
        this.foregroundMeasurementsInProgress = false;
    }

    void sendDataToDataThreads(MeasurePointData measurePointData, boolean bl) {
        if (measurePointData.status() != 0) {
            return;
        }
        this.dataThreadSocket.displayData(measurePointData.distance(), measurePointData.azimuth(), measurePointData.zenith(), measurePointData.time(), bl, this.probeDiameter);
    }

    MeasurePointData extractDataFromTracker(int n) {
        MeasurePointData[] measurePointDataArray = null;
        try {
            measurePointDataArray = this.trk.readMeasurePointData(n);
        }
        catch (TrackerException trackerException) {
            if (this.measureSinglePointOnly) {
                XTool.displayErrorToUser(trackerException, this.res.getString("Tracker_Error"), this.frame);
            }
            trackerException.printStackTrace();
            MeasurePointData measurePointData = null;
            return measurePointData;
        }
        if (measurePointDataArray == null) {
            return null;
        }
        return measurePointDataArray[0];
    }

    void updateMeasureData(MeasurePointData measurePointData) {
        if (measurePointData == null) {
            return;
        }
        if (measurePointData.status() != 0) {
            this.ctrlX.setText("******");
            this.ctrlY.setText("******");
            this.ctrlZ.setText("******");
            this.ctrlI.setText("******");
            this.ctrlJ.setText("******");
            this.ctrlK.setText("******");
            this.ctrlX.setForeground(Color.red);
            this.ctrlY.setForeground(Color.red);
            this.ctrlZ.setForeground(Color.red);
            this.ctrlI.setForeground(Color.red);
            this.ctrlJ.setForeground(Color.red);
            this.ctrlK.setForeground(Color.red);
            this.onStopMeasurement(null);
            return;
        }
        this.ctrlX.setForeground(Color.black);
        this.ctrlY.setForeground(Color.black);
        this.ctrlZ.setForeground(Color.black);
        this.ctrlI.setForeground(Color.black);
        this.ctrlJ.setForeground(Color.black);
        this.ctrlK.setForeground(Color.black);
        double[] dArray = new double[]{measurePointData.distance(), measurePointData.azimuth(), measurePointData.zenith()};
        XMath.pointSphereToCart(dArray);
        this.ctrlX.setText(this.localLinearUnits.convertToDisplayStr(dArray[0]));
        this.ctrlY.setText(this.localLinearUnits.convertToDisplayStr(dArray[1]));
        this.ctrlZ.setText(this.localLinearUnits.convertToDisplayStr(dArray[2]));
        double d = XMath.get3DPtDistance(dArray);
        double d2 = dArray[0] / d;
        double d3 = dArray[1] / d;
        double d4 = dArray[2] / d;
        this.ctrlI.setText(this.localLinearUnits.convertToDisplayStr(this.localLinearUnits.convertFrom(d2)));
        this.ctrlJ.setText(this.localLinearUnits.convertToDisplayStr(this.localLinearUnits.convertFrom(d3)));
        this.ctrlK.setText(this.localLinearUnits.convertToDisplayStr(this.localLinearUnits.convertFrom(d4)));
        this.ctrlPtCount.setText(Integer.toString(++this.npts));
    }

    void updateTargetPosition(MeasurePointData measurePointData) {
        if (measurePointData == null) {
            return;
        }
        if (measurePointData.status() != 0) {
            this.jlblPositionReadOut.setText("******");
            this.jlblPositionReadOut.setForeground(Color.red);
        } else {
            this.jlblPositionReadOut.setForeground(Color.black);
        }
        double[] dArray = new double[]{measurePointData.distance(), measurePointData.azimuth(), measurePointData.zenith()};
        XMath.pointSphereToCart(dArray);
        this.jlblPositionReadOut.setText(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.res.getString("X")))).append(" = ").append(this.localLinearUnits.convertToDisplayStr(dArray[0])).append(" , ").append(this.res.getString("Y")).append(" = ").append(this.localLinearUnits.convertToDisplayStr(dArray[1])).append(" , ").append(this.res.getString("Z")).append(" = ").append(this.localLinearUnits.convertToDisplayStr(dArray[2])))));
    }

    public void stop() {
        if (!this.closeButtonClicked) {
            this.onClose(null);
        }
        this.shutDownDataThread();
        this.trk.removeBusyListener((BusyListener)this.busyListener);
        super.stop();
    }

    public void shutDownDataThread() {
        if (this.dataThreadSocket != null) {
            this.dataThreadSocket.shutDown();
            this.dataThreadSocket.doNoOp();
            this.dataThreadSocket = null;
        }
    }

    void onClose(ActionEvent actionEvent) {
        if (actionEvent != null) {
            this.closeButtonClicked = true;
        }
        if (this.foregroundMeasurementsInProgress) {
            this.onStopMeasurement(null);
        }
        if (this.measureSetupDlg != null) {
            this.measureSetupDlg.dispose();
            this.measureSetupDlg = null;
        }
        try {
            boolean bl = this.trk.getBlocking();
            this.trk.setBlocking(true);
            this.stopFactoryBkndMeasurementForTargetPos(this.factoryBkndDataListener);
            this.trk.setBlocking(bl);
            if (actionEvent != null) {
                this.trk.stopApplication("MeasurePad");
            }
        }
        catch (TrackerException trackerException) {
            trackerException.printStackTrace();
            XTool.displayErrorToUser(trackerException, this.res.getString("Tracker_Error"), this.frame);
        }
    }

    private void enableButtons(boolean bl) {
        this.ctrlMeasure.setEnabled(!bl);
        this.ctrlClose.setEnabled(!bl);
        this.ctrlSetup.setEnabled(!bl);
    }

    private void startFactoryBkndMeasurementForTargetPos() throws TrackerException {
        boolean bl = this.trk.getBlocking();
        this.trk.setBlocking(true);
        P.rintln(String.valueOf(String.valueOf(new StringBuffer("\" ").append(Thread.currentThread().getName()).append(" \" ").append(" is doing Factory bknd stuff"))));
        if (this.trk.factoryBkndMeasureInProgress()) {
            P.rintln("Factory bknd measurements in progress");
        } else {
            P.rintln("Factory bknd measurements NOT in progress");
        }
        this.factoryBkndMeasureBlocking = this.trk.getFactoryBkndMeasureBlocking();
        this.trk.setFactoryBkndMeasureBlocking(true);
        this.trk.addFactoryBkndMeasureDataListener((FactoryBkndMeasureDataListener)this.factoryBkndDataListener);
        this.trk.startFactoryBkndMeasurePoint(new MeasureCfg(1, (Filter)new NullFilter(), (StartTrigger)new NullStartTrigger(), (ContinueTrigger)new IntervalTrigger(0.25)));
        P.rintln("Starting the factory bknd measurements");
        this.factoryBkndMeasurementsStarted = true;
        this.trk.setBlocking(bl);
    }

    private void stopFactoryBkndMeasurementForTargetPos(FactoryBkndMeasureDataListener factoryBkndMeasureDataListener) throws TrackerException {
        if (!this.factoryBkndMeasurementsStarted) {
            return;
        }
        this.trk.removeFactoryBkndMeasureDataListener(factoryBkndMeasureDataListener);
        if (this.factoryBkndMeasurementsStarted) {
            this.trk.stopFactoryBkndMeasurePoint();
            this.trk.setFactoryBkndMeasureBlocking(this.factoryBkndMeasureBlocking);
            this.factoryBkndMeasurementsStarted = false;
            P.rintln("Stopping the factory bknd measurements");
        }
    }

    private void processButtonSetting(String string) {
        JButton jButton = null;
        try {
            String string2 = string.substring(1);
            string2 = string2.trim();
            int n = string.indexOf("=");
            if (-1 == n) {
                return;
            }
            String string3 = string.substring(n + 1);
            if (!(string3 = string3.trim()).equalsIgnoreCase("off")) {
                return;
            }
            boolean bl = false;
            if (string2.startsWith("Close")) {
                jButton = this.ctrlClose;
            } else if (string2.startsWith("Setup")) {
                jButton = this.ctrlSetup;
            }
            if (jButton != null) {
                this.jPanel4.remove(jButton);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private void processParam(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "-", true);
            while (true) {
                String string2;
                if (!(string2 = stringTokenizer.nextToken()).equals("-")) {
                    continue;
                }
                while ((string2 = stringTokenizer.nextToken()).equals("-")) {
                }
                string2 = string2.trim();
                switch (string2.charAt(0)) {
                    case 'b': {
                        this.processButtonSetting(string2);
                        break;
                    }
                    case 'h': {
                        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "h");
                        this.portNumber = Integer.parseInt(stringTokenizer2.nextToken());
                        stringTokenizer2 = null;
                    }
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    private synchronized void signalAppStable() {
        if (!this.appIsStable) {
            this.appIsStable = true;
            ((Object)((Object)this)).notifyAll();
        }
    }

    public synchronized void waitUntilStable() {
        P.rintln("Thread waiting for app to become stable is : ".concat(String.valueOf(String.valueOf(Thread.currentThread().getName()))));
        try {
            while (!this.appIsStable) {
                ((Object)((Object)this)).wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        P.rintln("Thread woken after app became stable is : ".concat(String.valueOf(String.valueOf(Thread.currentThread().getName()))));
    }

    private void enableCloseButtonOnly() {
        this.trk.removeBusyListener((BusyListener)this.busyListener);
        this.ctrlMeasure.setEnabled(false);
        this.ctrlSetup.setEnabled(false);
        this.ctrlStop.setEnabled(false);
        this.ctrlClose.setEnabled(true);
    }

    public void issueTrackerFactoryBkndMeasurementInSeperateThread() {
        StartFactoryBkndMeasurementsThread startFactoryBkndMeasurementsThread = new StartFactoryBkndMeasurementsThread();
    }

    public synchronized void modifyParameters(String string) {
        boolean bl = true;
        String string2 = this.ctrlX.getText();
        if (string2 == null || string2.length() < 1) {
            bl = false;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        if (bl) {
            d = Double.parseDouble(string2);
            d = this.localLinearUnits.convertFrom(d);
            string2 = this.ctrlY.getText();
            d2 = Double.parseDouble(string2);
            d2 = this.localLinearUnits.convertFrom(d2);
            string2 = this.ctrlZ.getText();
            d3 = Double.parseDouble(string2);
            d3 = this.localLinearUnits.convertFrom(d3);
        }
        super.modifyParameters(string);
        this.processParam(string);
        this.localLinearUnits = this.lengthUnits;
        this.localAngularUnits = this.angularUnits;
        this.localTemperatureUnits = this.temperatureUnits;
        this.localPressureUnits = this.pressureUnits;
        this.jLabel2.setText(this.localLinearUnits.displayName());
        this.jLabel4.setText(this.localLinearUnits.displayName());
        this.jLabel6.setText(this.localLinearUnits.displayName());
        if (bl) {
            this.ctrlX.setText(this.localLinearUnits.convertToDisplayStr(d));
            this.ctrlY.setText(this.localLinearUnits.convertToDisplayStr(d2));
            this.ctrlZ.setText(this.localLinearUnits.convertToDisplayStr(d3));
        }
    }

    MeasurePointData extractFactoryBkndMeasureData(int n) {
        MeasurePointData[] measurePointDataArray = null;
        try {
            measurePointDataArray = this.trk.readFactoryBkndMeasurePointData(n);
        }
        catch (TrackerException trackerException) {
            XTool.displayErrorToUser(trackerException, this.res.getString("Tracker_Error"), this.frame);
            trackerException.printStackTrace();
            MeasurePointData measurePointData = null;
            return measurePointData;
        }
        if (measurePointDataArray == null) {
            return null;
        }
        return measurePointDataArray[0];
    }

    private void jbInit() throws Exception {
        this.border1 = new EtchedBorder(0, Color.white, new Color(134, 134, 134));
        this.titledBorder1 = new TitledBorder(this.border1, this.res.getString("Measure_data"));
        this.border2 = BorderFactory.createCompoundBorder(this.titledBorder1, BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.border3 = new EtchedBorder(0, Color.white, new Color(134, 134, 134));
        this.titledBorder2 = new TitledBorder(this.border3, this.res.getString("Current_setup"));
        this.border4 = BorderFactory.createCompoundBorder(this.titledBorder2, BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.component3 = Box.createHorizontalStrut(8);
        this.component1 = Box.createHorizontalStrut(8);
        this.border6 = BorderFactory.createLineBorder(SystemColor.controlText, 1);
        this.border5 = BorderFactory.createLineBorder(SystemColor.controlText, 1);
        this.titledBorder3 = new TitledBorder(this.border3, this.res.getString("Target_position"));
        this.jlblPositionReadOut.setBorder(this.titledBorder3);
        this.jlblPositionReadOut.setText("");
        ((Container)((Object)this)).setLayout(this.gridBagLayout1);
        this.jPanel1.setBorder(this.border2);
        this.jPanel1.setLayout(this.gridBagLayout2);
        this.ctrlX.setBackground(Color.lightGray);
        this.ctrlY.setBackground(Color.lightGray);
        this.ctrlZ.setBackground(Color.lightGray);
        this.ctrlI.setBackground(Color.lightGray);
        this.ctrlJ.setBackground(Color.lightGray);
        this.ctrlK.setBackground(Color.lightGray);
        this.ctrlPtCount.setBackground(Color.lightGray);
        this.ctrlInitialTrigger.setBackground(Color.lightGray);
        this.ctrlNextTrigger.setBackground(Color.lightGray);
        this.ctrlSamples.setBackground(Color.lightGray);
        this.ctrlX.setFont(new Font("SansSerif", 1, 12));
        this.ctrlY.setFont(new Font("SansSerif", 1, 12));
        this.ctrlZ.setFont(new Font("SansSerif", 1, 12));
        this.ctrlX.setBorder(this.border6);
        this.ctrlY.setBorder(this.border6);
        this.ctrlZ.setBorder(this.border6);
        this.ctrlI.setBorder(this.border6);
        this.ctrlJ.setBorder(this.border6);
        this.ctrlK.setBorder(this.border6);
        this.ctrlPtCount.setBorder(this.border6);
        this.ctrlInitialTrigger.setBorder(this.border6);
        this.ctrlNextTrigger.setBorder(this.border6);
        this.ctrlSamples.setBorder(this.border6);
        this.ctrlOutputFile.setFont(new Font("Dialog", 1, 12));
        this.ctrlOutputFile.setBorder(this.border6);
        this.ctrlSocket.setFont(new Font("Dialog", 1, 12));
        this.ctrlSocket.setBorder(this.border6);
        this.ctrlI.setFont(new Font("SansSerif", 1, 12));
        this.ctrlJ.setFont(new Font("SansSerif", 1, 12));
        this.ctrlK.setFont(new Font("SansSerif", 1, 12));
        this.ctrlPtCount.setFont(new Font("SansSerif", 1, 12));
        this.ctrlInitialTrigger.setFont(new Font("SansSerif", 1, 12));
        this.ctrlNextTrigger.setFont(new Font("SansSerif", 1, 12));
        this.ctrlSamples.setFont(new Font("SansSerif", 1, 12));
        this.jLabel1.setMaximumSize(new Dimension(44, 17));
        this.jLabel1.setMinimumSize(new Dimension(44, 17));
        this.jLabel1.setPreferredSize(new Dimension(44, 17));
        this.jLabel1.setHorizontalTextPosition(2);
        this.jLabel1.setText(this.res.getString("X"));
        this.jLabel2.setText(this.localLinearUnits.displayName());
        this.jLabel4.setText(this.localLinearUnits.displayName());
        this.jLabel6.setText(this.localLinearUnits.displayName());
        this.jLabel3.setMaximumSize(new Dimension(44, 17));
        this.jLabel3.setMinimumSize(new Dimension(44, 17));
        this.jLabel3.setPreferredSize(new Dimension(44, 17));
        this.jLabel3.setText(this.res.getString("Y"));
        this.jLabel5.setMaximumSize(new Dimension(44, 17));
        this.jLabel5.setMinimumSize(new Dimension(44, 17));
        this.jLabel5.setPreferredSize(new Dimension(44, 17));
        this.jLabel5.setText(this.res.getString("Z"));
        this.jLabel7.setMaximumSize(new Dimension(44, 17));
        this.jLabel7.setMinimumSize(new Dimension(44, 17));
        this.jLabel7.setPreferredSize(new Dimension(44, 17));
        this.jLabel7.setText(this.res.getString("I"));
        this.jLabel8.setMaximumSize(new Dimension(44, 17));
        this.jLabel8.setMinimumSize(new Dimension(44, 17));
        this.jLabel8.setPreferredSize(new Dimension(44, 17));
        this.jLabel8.setText(this.res.getString("J"));
        this.jLabel9.setMaximumSize(new Dimension(44, 17));
        this.jLabel9.setMinimumSize(new Dimension(44, 17));
        this.jLabel9.setPreferredSize(new Dimension(44, 17));
        this.jLabel9.setText(this.res.getString("K"));
        this.jLabel10.setText(this.res.getString("Pt_count"));
        this.jPanel2.setLayout(this.gridBagLayout3);
        this.jPanel3.setBorder(this.border4);
        this.jPanel3.setLayout(this.gridBagLayout4);
        this.jLabel11.setText(this.res.getString("Initial_trigger"));
        this.ctrlInitialTrigger.setText(this.res.getString("Immediate"));
        this.jLabel12.setText(this.res.getString("Subsequent_trigger"));
        this.ctrlNextTrigger.setText(this.res.getString("None"));
        this.jLabel13.setText(this.res.getString("Samples_per_point"));
        this.jlblOutputFile.setText(this.res.getString("Output_file_name"));
        this.jlblSocket.setText(this.res.getString("To_Holos"));
        this.ctrlSocket.setText(this.res.getString("Yes"));
        this.ctrlSamples.setText("2000");
        this.jPanel4.setLayout(this.gridBagLayout5);
        this.ctrlMeasure.setMargin(new Insets(1, 1, 1, 1));
        this.ctrlMeasure.setText(this.res.getString("Measure"));
        this.ctrlMeasure.addActionListener(new MeasurePad_ctrlMeasure_actionAdapter(this));
        this.ctrlSetup.setMargin(new Insets(1, 1, 1, 1));
        this.ctrlSetup.setText(this.res.getString("Setup"));
        this.ctrlSetup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MeasurePad.this.onSetup(actionEvent);
            }
        });
        this.ctrlStop.setEnabled(false);
        this.ctrlStop.setToolTipText(this.res.getString("Stop_current_measurement"));
        this.ctrlStop.setMargin(new Insets(1, 1, 1, 1));
        this.ctrlStop.setText(this.res.getString("Stop"));
        this.ctrlStop.addActionListener(new MeasurePad_ctrlStop_actionAdapter(this));
        ((JComponent)((Object)this)).setMinimumSize(new Dimension(240, 435));
        ((JComponent)((Object)this)).setPreferredSize(new Dimension(240, 435));
        this.ctrlClose.setMargin(new Insets(1, 1, 1, 1));
        this.ctrlClose.setText(this.res.getString("Close"));
        this.ctrlClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MeasurePad.this.onClose(actionEvent);
            }
        });
        this.jlblPositionReadOut.setFont(new Font("Dialog", 1, 12));
        ((Container)((Object)this)).add(this.jPanel1, new GridBagConstraints(0, 0, 1, 3, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel1.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel1.add((Component)this.ctrlX, new GridBagConstraints(1, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel1.add((Component)this.jLabel3, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 10, 3, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel1.add((Component)this.ctrlY, new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel1.add((Component)this.jLabel5, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 10, 3, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel1.add((Component)this.ctrlZ, new GridBagConstraints(1, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel1.add((Component)this.jLabel7, new GridBagConstraints(0, 3, 1, 1, 0.0, 1.0, 10, 3, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel1.add((Component)this.ctrlI, new GridBagConstraints(1, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel1.add((Component)this.jLabel8, new GridBagConstraints(0, 4, 1, 1, 0.0, 1.0, 10, 3, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel1.add((Component)this.ctrlJ, new GridBagConstraints(1, 4, 2, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel1.add((Component)this.jLabel9, new GridBagConstraints(0, 5, 1, 1, 0.0, 1.0, 10, 3, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel1.add((Component)this.ctrlK, new GridBagConstraints(1, 5, 2, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel1.add((Component)this.jLabel10, new GridBagConstraints(0, 6, 1, 1, 0.0, 1.0, 10, 3, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel1.add((Component)this.ctrlPtCount, new GridBagConstraints(1, 6, 2, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel1.add((Component)this.jLabel2, new GridBagConstraints(3, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel1.add((Component)this.jLabel4, new GridBagConstraints(3, 1, 1, 1, 0.0, 1.0, 10, 3, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel1.add((Component)this.jLabel6, new GridBagConstraints(3, 2, 1, 1, 0.0, 1.0, 10, 3, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel1.add((Component)this.jlblDummy3, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jlblDummy4, new GridBagConstraints(2, 7, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        ((Container)((Object)this)).add(this.jPanel2, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel2.add((Component)this.jPanel3, new GridBagConstraints(0, 0, 2, 3, 1.0, 1.0, 10, 1, new Insets(0, 2, 2, 2), 0, 0));
        this.jPanel3.add((Component)this.jLabel11, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel3.add((Component)this.ctrlInitialTrigger, new GridBagConstraints(1, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel3.add((Component)this.jLabel12, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel3.add((Component)this.ctrlNextTrigger, new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel3.add((Component)this.jLabel13, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel3.add((Component)this.ctrlSamples, new GridBagConstraints(1, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel3.add((Component)this.jlblOutputFile, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel3.add((Component)this.ctrlOutputFile, new GridBagConstraints(1, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel3.add((Component)this.jlblSocket, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel3.add((Component)this.ctrlSocket, new GridBagConstraints(1, 4, 2, 1, 1.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel3.add((Component)this.jpanel3Dummy2, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel3.add((Component)this.jpanel3Dummy1, new GridBagConstraints(2, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jPanel4, new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel2.add((Component)this.jlblPositionReadOut, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 2, 2, 2), 0, 0));
        this.jPanel4.add((Component)this.ctrlMeasure, new GridBagConstraints(1, 0, 1, 2, 0.0, 0.0, 10, 0, new Insets(2, 0, 2, 2), 0, 0));
        this.jPanel4.add((Component)this.ctrlSetup, new GridBagConstraints(2, 0, 1, 2, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel4.add((Component)this.ctrlStop, new GridBagConstraints(3, 0, 1, 2, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel4.add(this.component3, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel4.add((Component)this.ctrlClose, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel4.add(this.component1, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jpanel4Dummy1, new GridBagConstraints(2, 0, 1, 2, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jpanel4Dummy2, new GridBagConstraints(2, 2, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jpanel4Dummy3, new GridBagConstraints(2, 3, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        ((Container)((Object)this)).add(this.jlblDummy1, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        ((Container)((Object)this)).add(this.jlblDummy2, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    private class FileOpenFailedImplementor
    implements FileOpenFailed,
    Runnable {
        private FileOpenFailedImplementor() {
        }

        public void failedToOpenFile() {
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            JOptionPane.showMessageDialog(null, MeasurePad.this.res.getString("File_open_error_msg"), MeasurePad.this.res.getString("File_open_error"), 0);
        }
    }

    class FactoryBkndMeasureDataImplementer
    implements FactoryBkndMeasureDataListener,
    Runnable {
        MeasurePointData data;

        FactoryBkndMeasureDataImplementer() {
        }

        public void dataAvailable(FactoryBkndMeasureDataEvent factoryBkndMeasureDataEvent) {
            this.data = MeasurePad.this.extractFactoryBkndMeasureData(factoryBkndMeasureDataEvent.getNumMeasurements());
            MeasurePad.this.sendDataToDataThreads(this.data, true);
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            MeasurePad.this.updateTargetPosition(this.data);
        }
    }

    class StartFactoryBkndMeasurementsThread
    extends Thread {
        StartFactoryBkndMeasurementsThread() {
            super("StartFactoryBkndMeasurementsThread");
            this.setDaemon(true);
            this.start();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    MeasurePad.this.startFactoryBkndMeasurementForTargetPos();
                    P.rintln("Factory bknd measurements started");
                }
                catch (TrackerException trackerException) {
                    trackerException.printStackTrace();
                    new ErrorDisplayThread();
                    Object var3_2 = null;
                    MeasurePad.this.signalAppStable();
                    return;
                }
                Object var3_1 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                MeasurePad.this.signalAppStable();
                throw throwable;
            }
            MeasurePad.this.signalAppStable();
        }
    }

    private class ErrorDisplayThread
    implements Runnable {
        ErrorDisplayThread() {
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            JOptionPane.showMessageDialog(MeasurePad.this.localFrame, MeasurePad.this.res.getString("Closing_the_app"), MeasurePad.this.res.getString("Failed_to_run_app"), 0);
            MeasurePad.this.onClose(new ActionEvent(new Object(), 1001, ""));
        }
    }

    private class BusyThreadListener
    implements BusyListener,
    Runnable {
        private ArrayList eventList = new ArrayList();

        private BusyThreadListener() {
        }

        public void stateChanged(BusyEvent busyEvent) {
            this.eventList.add(busyEvent);
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            BusyEvent busyEvent = (BusyEvent)this.eventList.remove(0);
            MeasurePad.this.enableButtons(busyEvent.getCommandState() || busyEvent.getMeasureState());
        }
    }

    class StartAppBusyListener
    implements BusyListener {
        private Tracker trkInner;

        StartAppBusyListener(Tracker tracker) {
            this.trkInner = tracker;
        }

        public void stateChanged(BusyEvent busyEvent) {
            if (!busyEvent.getCommandState()) {
                P.rintln("Well the tracker finally is NOT BUSY");
                this.trkInner.removeBusyListener((BusyListener)this);
                this.trkInner.addBusyListener((BusyListener)MeasurePad.this.busyListener);
                MeasurePad.this.issueTrackerFactoryBkndMeasurementInSeperateThread();
            }
        }
    }

    private class MeasureDataImplementer
    implements MeasureDataListener,
    Runnable {
        MeasurePointData data;

        private MeasureDataImplementer() {
        }

        public void dataAvailable(MeasureDataEvent measureDataEvent) {
            if (measureDataEvent == null) {
                return;
            }
            ++MeasurePad.this.listenerPtCount;
            if (MeasurePad.this.measureSinglePointOnly && MeasurePad.this.listenerPtCount > 1) {
                return;
            }
            this.data = MeasurePad.this.extractDataFromTracker(measureDataEvent.getNumMeasurements());
            MeasurePad.this.sendDataToDataThreads(this.data, false);
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            if (MeasurePad.this.measureSinglePointOnly) {
                MeasurePad.this.onStopMeasurement(null);
            }
            MeasurePad.this.updateMeasureData(this.data);
        }
    }
}

