/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.apps4xxx.healthchecks;

import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import smx.tracker.CommunicationException;
import smx.tracker.DataTag;
import smx.tracker.DataTagDouble;
import smx.tracker.DataTagUnsigned16;
import smx.tracker.DataTagUnsigned32;
import smx.tracker.DeviceLockedException;
import smx.tracker.DistanceMode;
import smx.tracker.InterferometerOnly;
import smx.tracker.NoResponseException;
import smx.tracker.Status;
import smx.tracker.Tracker;
import smx.tracker.TrackerException;
import smx.tracker.apps4xxx.healthchecks.HealthChecks;
import smx.tracker.apps4xxx.utility.ThreadListener;
import smx.tracker.apps4xxx.utility.TrackerAppCommandThread;
import smx.tracker.apps4xxx.utility.TrackerAppException;
import smx.tracker.apps4xxx.utility.XMath;
import smx.tracker.apps4xxx.utility.tools.Assert;
import smx.tracker.apps4xxx.utility.tools.P;
import smx.tracker.apps4xxx.utility.tools.XTool;
import smx.tracker.event.BusyListener;

class HealthChecksThread
extends TrackerAppCommandThread
implements Runnable {
    public static final int READ_ONE_TIME_DATA = 1;
    public static final int WRITE_ONE_TIME_DATA = 2;
    public static final int READ_LASER_DATA = 3;
    public static final int PSD_OPCHECK = 4;
    public static final int INTERFEROMETER_OPCHECK = 5;
    public static final int ADM_OPCHECK = 6;
    public static final int SHUTTER_CHECK = 7;
    public static final int STORE_TRACKER_STATE = 8;
    public static final int RESTORE_TRACKER_STATE = 9;
    private ResourceBundle res = HealthChecks.res;
    private final int NUMBER_OF_BEAMINS = 2;
    private final int NUMBER_OF_FINE_CRS_RAW_VALS = 3;
    private final int ADMOP_WAIT_TIME = 10000;
    private final int ADMOP_THREAD_WAIT_TIME = 100;
    private final double MIN_STDEV_ACCEPTANCE_FOR_FINE_RAW = 3.0E-4;
    private final double MIN_STDEV_ACCEPTANCE_FOR_CRS_RAW = 0.002;
    private final double REFERENCE_INTENSITY_THRESHOLD = 1.1;
    private final double MEASUREMENT_INTENSITY_THRESHOLD = 0.8;
    private final long ADM_MEASURE_TIME = 500000L;

    HealthChecksThread(Tracker tracker, ThreadListener threadListener, BusyListener busyListener, ThreadListener threadListener2, JFrame jFrame) {
        super("HealthChecks", tracker, threadListener, busyListener, threadListener2, jFrame);
        this.thread = new Thread((Runnable)this, "Health checks 4xxx Thread");
        this.thread.setDaemon(true);
    }

    public void run() {
        Object[] objectArray;
        boolean bl = false;
        boolean bl2 = false;
        this.stateTag = new DataTag[2];
        this.stateTag[0] = new DataTagUnsigned32("motor_state.int_output");
        this.stateTag[1] = new DataTagUnsigned32("control_mode.int_output");
        this.responseData = new Object[3];
        this.responseData[0] = null;
        this.responseData[1] = null;
        this.responseData[2] = null;
        this.oldBlockSetting = this.trk.getBlocking();
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        Boolean[] booleanArray = new Boolean[3];
        try {
            DistanceMode distanceMode;
            block28: {
                try {
                    this.setExclusiveAccess();
                }
                catch (TrackerException trackerException) {
                    bl2 = true;
                    this.responseData[0] = new DeviceLockedException(" ");
                    throw (TrackerException)((Object)this.responseData[0]);
                }
                this.trk.setBlocking(true);
                try {
                    this.trk.move(0.0, 0.0, 5.0, false);
                }
                catch (TrackerException trackerException) {
                    trackerException.printStackTrace();
                    if (!(trackerException instanceof DeviceLockedException) && !(trackerException instanceof CommunicationException) && !(trackerException instanceof NoResponseException)) break block28;
                    bl2 = true;
                    this.responseData[0] = trackerException;
                    throw trackerException;
                }
            }
            bl3 = this.trk.admCapable();
            if (bl3 && (distanceMode = this.trk.distanceMeasureMode()) instanceof InterferometerOnly) {
                bl4 = true;
            }
            distanceMode = new DistanceMode[]{new DataTagDouble("tmr_dist.output"), new DataTagUnsigned16("hene_baseline_int.status")};
            boolean bl6 = false;
            objectArray = this.getStateInfo((DataTag[])distanceMode);
            if (objectArray[0] instanceof TrackerException) {
                P.rintln("Re-throwing the Tracker Exception");
                throw (TrackerException)((Object)objectArray[0]);
            }
            int n = (Integer)objectArray[1];
            if (n == 0 || (n & 0x20) != 0) {
                bl5 = true;
            }
            this.responseData[1] = this.getStateInfo(this.stateTag);
            booleanArray[0] = new Boolean(bl3);
            booleanArray[1] = new Boolean(bl5);
            booleanArray[2] = new Boolean(bl4);
            this.responseData[2] = booleanArray;
        }
        catch (TrackerException trackerException) {
            trackerException.printStackTrace();
            this.responseData[0] = trackerException;
        }
        boolean bl7 = false;
        this.stateDataTags = new DataTag[3];
        this.stateDataTags[0] = new DataTagUnsigned32("target.int_output");
        this.stateDataTags[1] = new DataTagUnsigned32("control_mode.int_output");
        this.stateDataTags[2] = new DataTagUnsigned32("adm_meas_time.int_output");
        try {
            this.response.send(this.responseData);
            if (this.listener != null) {
                this.listener.commandComplete();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.listenForBusyEvents();
        boolean bl8 = false;
        while (!this.shutdown) {
            try {
                Object[] objectArray2 = this.command.receive();
                this.commandCode = (Integer)objectArray2[0];
                if (this.commandCode != 7 && !bl7) {
                    Assert.isTrue(this.commandCode == -9, "Trying to run health checks while shutter is closed!!");
                }
                this.responseData = new Object[3];
                this.responseData[0] = null;
                this.responseData[1] = null;
                this.responseData[2] = null;
                switch (this.commandCode) {
                    case 7: {
                        bl7 = this.isShutterOpen();
                        objectArray = new Boolean[]{new Boolean(bl7)};
                        this.responseData[2] = objectArray;
                        break;
                    }
                    case 8: {
                        this.setExclusiveAccess();
                        this.storeCurrentTrackerState();
                        this.setTrackerInCustomState();
                        break;
                    }
                    case 9: {
                        this.restoreOldTrackerState();
                        this.clearExclusiveAccess();
                        break;
                    }
                    case 1: {
                        bl8 = true;
                        this.responseData[2] = this.readOneTimeData((DataTag[])objectArray2[1]);
                        break;
                    }
                    case 4: {
                        this.responseData[2] = this.doPSDOpChecks((DataTag[])objectArray2[1]);
                        break;
                    }
                    case 5: {
                        this.responseData[2] = this.doInterferometerChecks((DataTag[])objectArray2[1]);
                        break;
                    }
                    case 6: {
                        this.responseData[2] = this.doADMRepeatabilityChecks();
                        break;
                    }
                    case 2: {
                        this.writeOneTimeData((DataTag[])objectArray2[1], (Object[])objectArray2[2]);
                        break;
                    }
                    case 0: {
                        break;
                    }
                    case -9: {
                        this.appIsSelfClosing = (Boolean)objectArray2[1];
                        break;
                    }
                    default: {
                        throw new TrackerException("Thread received unexpected command");
                    }
                }
            }
            catch (Exception exception) {
                this.handleException(exception);
            }
            this.sendResponseToApp();
        }
        this.ignoreBusyEvents();
    }

    private void setTrackerInCustomState() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("adm_meas_time.int_output")};
        Object[] objectArray = new Object[]{new Long(500000L)};
        P.rintln("ADM meas time = ".concat(String.valueOf(String.valueOf((Long)objectArray[0]))));
        this.writeOneTimeData(dataTagArray, objectArray);
        this.trk.changeDistanceMeasureMode((DistanceMode)new InterferometerOnly());
    }

    private double[] getRadAzZeData(Object[] objectArray) throws TrackerAppException {
        int n = 0;
        double d = Math.IEEEremainder((Double)objectArray[n++], 1296000.0);
        d = Math.toRadians(d / 3600.0);
        int n2 = (Integer)objectArray[n++];
        P.rintln("azStatus = ".concat(String.valueOf(String.valueOf(n2))));
        double d2 = Math.IEEEremainder((Double)objectArray[n++], 1296000.0);
        d2 = Math.toRadians(d2 / 3600.0);
        int n3 = (Integer)objectArray[n++];
        P.rintln("zeStatus = ".concat(String.valueOf(String.valueOf(n3))));
        double d3 = (Double)objectArray[n++] / (double)1000000;
        int n4 = (Integer)objectArray[n++];
        P.rintln("distStatus = ".concat(String.valueOf(String.valueOf(n4))));
        int n5 = n2 | n3 | n4;
        if (n5 != 0) {
            throw new TrackerAppException(this.res.getString("Measured_data_invalid"));
        }
        double[] dArray = new double[]{d3, d, d2};
        return dArray;
    }

    boolean doPSDScaleChecks() throws TrackerException {
        boolean bl = this.trk.trackingOn();
        if (!bl) {
            this.trk.changeTrackingState(true);
        }
        boolean bl2 = false;
        try {
            DataTag[] dataTagArray = new DataTag[]{new DataTagDouble("az.output"), new DataTagUnsigned16("az.status"), new DataTagDouble("el.output"), new DataTagUnsigned16("el.status"), new DataTagDouble("dist.output"), new DataTagUnsigned16("dist.status")};
            Object[] objectArray = this.measureOneTimeFactoryBkndData(dataTagArray, 1000);
            double[] dArray = this.getRadAzZeData(objectArray);
            this.trk.changeTrackingState(false);
            dataTagArray = new DataTag[]{new DataTagDouble("quad_work_dist.output"), new DataTagDouble("zero_mir_dist.output")};
            Object[] objectArray2 = this.readOneTimeData(dataTagArray);
            double d = (Double)objectArray2[0] + (Double)objectArray2[1];
            double d2 = Math.atan((double)1000 * Math.cos(Math.toRadians(45.0)) / d);
            double d3 = Math.atan((double)1000 * Math.sin(Math.toRadians(45.0)) / d);
            this.checkAndAbort();
            this.trk.command(String.valueOf(String.valueOf(new StringBuffer("moveto ").append(d2 + dArray[1]).append(" ").append(d3 + dArray[2]).append(" ").append(dArray[0]).append(" a c2"))), 10000);
            dataTagArray = new DataTag[]{new DataTagDouble("smr_scale_up.output"), new DataTagDouble("quad_a_up.output"), new DataTagDouble("quad_b_up.output"), new DataTagDouble("quad_c_up.output"), new DataTagDouble("quad_d_up.output")};
            this.checkAndAbort();
            objectArray2 = this.readOneTimeData(dataTagArray);
            double d4 = (Double)objectArray2[1];
            double d5 = (Double)objectArray2[2];
            double d6 = (Double)objectArray2[3];
            double d7 = (Double)objectArray2[4];
            System.out.println("A upstream = ".concat(String.valueOf(String.valueOf(d4))));
            System.out.println("B upstream = ".concat(String.valueOf(String.valueOf(d5))));
            System.out.println("C upstream = ".concat(String.valueOf(String.valueOf(d6))));
            System.out.println("D upstream = ".concat(String.valueOf(String.valueOf(d7))));
            double d8 = d4 - d6;
            double d9 = d4 + d6;
            double d10 = d5 - d7;
            double d11 = d5 + d7;
            this.checkAndAbort();
            double d12 = Math.sqrt(d8 / d9 * (d8 / d9) + d10 / d11 * (d10 / d11));
            double d13 = d12 * (Double)objectArray2[0];
            System.out.println("computedDist = ".concat(String.valueOf(String.valueOf(d13))));
            bl2 = !(d13 < (double)400);
            Object var34_20 = null;
        }
        catch (Throwable throwable) {
            Object var34_21 = null;
            this.trk.changeTrackingState(bl);
            throw throwable;
        }
        this.trk.changeTrackingState(bl);
        return bl2;
    }

    Object[] getBackMirrorPSDData(DataTag[] dataTagArray) throws TrackerException {
        this.aimToBackMirror();
        boolean bl = false;
        Object[] objectArray = null;
        try {
            this.checkAndAbort();
            objectArray = this.readOneTimeData(dataTagArray);
            this.checkAndAbort();
            bl = this.doPSDScaleChecks();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.restoreTargetType();
            throw throwable;
        }
        this.restoreTargetType();
        Object[] objectArray2 = null;
        objectArray2 = new Object[]{objectArray, new Boolean(bl)};
        return objectArray2;
    }

    Object[] doInterferometerChecks(DataTag[] dataTagArray) throws TrackerException {
        Object[] objectArray = null;
        Object[] objectArray2 = this.readOneTimeData(dataTagArray);
        Status[] statusArray = this.trk.statusHistory();
        objectArray = new Object[]{objectArray2, statusArray};
        return objectArray;
    }

    Object[] doPSDOpChecks(DataTag[] dataTagArray) throws TrackerException {
        Object[] objectArray = null;
        this.trk.move(0.0, 0.0, 5.0, false);
        Object[] objectArray2 = this.readOneTimeData(dataTagArray);
        Object[] objectArray3 = this.getBackMirrorPSDData(dataTagArray);
        objectArray = new Object[]{objectArray2, objectArray3[0], objectArray3[1]};
        return objectArray;
    }

    Boolean[] doADMRepeatabilityChecks() throws TrackerException {
        Boolean[] booleanArray;
        DataTag[] dataTagArray = new DataTag[]{new DataTagDouble("adm_crs_scale_std.output")};
        Object[] objectArray = this.trk.readOneTimeData(dataTagArray);
        double d = (Double)objectArray[0];
        if (Math.abs(d) < 1.0E-14) {
            return new Boolean[]{new Boolean(false)};
        }
        this.aimToBackMirror();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = this.trk.trackingOn();
        try {
            this.trk.changeTrackingState(false);
            dataTagArray = new DataTag[1];
            this.trk.command("admop refint", 10000);
            dataTagArray[0] = new DataTagDouble("adm_ref_intensity.output");
            XTool.putToSleep(Thread.currentThread(), 100);
            objectArray = this.trk.readOneTimeData(dataTagArray);
            P.rintln("Ref intensity = ".concat(String.valueOf(String.valueOf((Double)objectArray[0]))));
            if (!((Double)objectArray[0] > 1.1)) {
                throw new TrackerAppException("Dummy exception");
            }
            bl = true;
            this.checkAndAbort();
            this.trk.command("admop beamin", 15000);
            this.checkAndAbort();
            this.trk.command("admop measint", 10000);
            this.checkAndAbort();
            XTool.putToSleep(Thread.currentThread(), 100);
            dataTagArray[0] = new DataTagDouble("adm_meas_intensity.output");
            objectArray = this.trk.readOneTimeData(dataTagArray);
            P.rintln("Meas intensity = ".concat(String.valueOf(String.valueOf((Double)objectArray[0]))));
            if (!((Double)objectArray[0] > 0.8)) {
                throw new TrackerAppException("Dummy exception");
            }
            bl2 = true;
            this.checkAndAbort();
            this.trk.command("admop fineraw", 10000);
            this.checkAndAbort();
            XTool.putToSleep(Thread.currentThread(), 100);
            booleanArray = new DataTagDouble("adm_last_fine_raw.output");
            DataTagDouble dataTagDouble = new DataTagDouble("adm_last_crs_raw.output");
            dataTagArray[0] = booleanArray;
            objectArray = this.trk.readOneTimeData(dataTagArray);
            double d2 = (Double)objectArray[0];
            P.rintln("fine raw value = ".concat(String.valueOf(String.valueOf(d2))));
            this.checkAndAbort();
            this.trk.command("admop coarseraw", 10000);
            this.checkAndAbort();
            XTool.putToSleep(Thread.currentThread(), 100);
            dataTagArray[0] = dataTagDouble;
            objectArray = this.trk.readOneTimeData(dataTagArray);
            double d3 = (Double)objectArray[0];
            P.rintln("coarse raw value = ".concat(String.valueOf(String.valueOf(d3))));
            this.checkAndAbort();
            int n = 6;
            double[][] dArray = new double[2][n];
            int n2 = 0;
            for (int i = 0; i < 2; ++i) {
                this.checkAndAbort();
                this.trk.command("admop beamin", 15000);
                for (int j = 0; j < 3; ++j) {
                    this.checkAndAbort();
                    this.trk.command("admop fineraw", 10000);
                    dataTagArray[0] = booleanArray;
                    this.checkAndAbort();
                    XTool.putToSleep(Thread.currentThread(), 100);
                    objectArray = this.trk.readOneTimeData(dataTagArray);
                    dArray[0][n2] = d2 - (Double)objectArray[0];
                    P.rintln(String.valueOf(String.valueOf(new StringBuffer("fine raw # ").append(i + 1).append(" is : ").append(dArray[0][i]))));
                    this.checkAndAbort();
                    this.trk.command("admop coarseraw", 10000);
                    dataTagArray[0] = dataTagDouble;
                    this.checkAndAbort();
                    XTool.putToSleep(Thread.currentThread(), 100);
                    objectArray = this.trk.readOneTimeData(dataTagArray);
                    dArray[1][n2] = d3 - (Double)objectArray[0];
                    P.rintln(String.valueOf(String.valueOf(new StringBuffer("crs raw # ").append(i + 1).append(" is : ").append(dArray[1][i]))));
                    ++n2;
                }
            }
            Assert.isTrue(n2 == n, "ADMOP failed");
            double d4 = XMath.getStandardDeviation(dArray[0], n);
            double d5 = XMath.getStandardDeviation(dArray[1], n);
            P.rintln("\nfine raw std dev = ".concat(String.valueOf(String.valueOf(d4))));
            P.rintln("\nCrs raw std dev = ".concat(String.valueOf(String.valueOf(d5))));
            if (d4 < 3.0E-4 && d5 < 0.002) {
                bl3 = true;
            }
        }
        catch (TrackerAppException trackerAppException) {
            P.rintln("Aborting ADM checks half way through");
        }
        booleanArray = null;
        booleanArray = new Boolean[]{new Boolean(true), new Boolean(bl), new Boolean(bl2), new Boolean(bl3)};
        return booleanArray;
    }

    private boolean isShutterOpen() throws TrackerException {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("shutter_state.int_output")};
        Object[] objectArray = this.trk.readOneTimeData(dataTagArray);
        if ((Long)objectArray[0] == (long)0) {
            P.rintln("Trying to open the shutter");
            this.trk.command("shutter open", 20000);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            objectArray = this.trk.readOneTimeData(dataTagArray);
            if ((Long)objectArray[0] == (long)0) {
                if (JOptionPane.showConfirmDialog(this.frame(), this.res.getString("Please_open_shutter_and_hit_ok"), this.res.getString("Open_shutter"), 2) == 0) {
                    return this.isShutterOpen();
                }
                return false;
            }
        }
        return true;
    }

    static {
        READ_ONE_TIME_DATA = 1;
        WRITE_ONE_TIME_DATA = 2;
        READ_LASER_DATA = 3;
        PSD_OPCHECK = 4;
        INTERFEROMETER_OPCHECK = 5;
        ADM_OPCHECK = 6;
        SHUTTER_CHECK = 7;
        STORE_TRACKER_STATE = 8;
        RESTORE_TRACKER_STATE = 9;
    }
}

