/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.apps4xxx.healthchecks;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import smx.tracker.CommunicationException;
import smx.tracker.DataTag;
import smx.tracker.DataTagDouble;
import smx.tracker.DataTagUnsigned16;
import smx.tracker.DataTagUnsigned32;
import smx.tracker.DeviceLockedException;
import smx.tracker.NoResponseException;
import smx.tracker.Status;
import smx.tracker.Tracker;
import smx.tracker.TrackerException;
import smx.tracker.apps4xxx.healthchecks.HealthChecksDetailsDlg;
import smx.tracker.apps4xxx.healthchecks.HealthChecksThread;
import smx.tracker.apps4xxx.healthchecks.HealthChecksWarningsDlg;
import smx.tracker.apps4xxx.utility.ThreadListener;
import smx.tracker.apps4xxx.utility.TrackerApp4xxx;
import smx.tracker.apps4xxx.utility.TrackerExceptionString;
import smx.tracker.apps4xxx.utility.tools.Assert;
import smx.tracker.apps4xxx.utility.tools.P;
import smx.tracker.apps4xxx.utility.tools.XTime;
import smx.tracker.apps4xxx.utility.tools.XTool;

public class HealthChecks
extends TrackerApp4xxx {
    public static final ResourceBundle res = ResourceBundle.getBundle("smx.tracker.apps4xxx.healthchecks.HealthChecksRes", Locale.getDefault());
    private HealthChecksThread healthChecksThread = null;
    private String outputFileName;
    String imagePath = new String("/smx/tracker/apps4xxx/utility/images/");
    long shutterState;
    double admCrsDistanceScale;
    Icon m_badImage;
    Icon m_goodImage;
    Icon m_warningImage;
    Icon m_notInstalledImage;
    Icon untestedImage;
    Icon blink1Image;
    Icon blink2Image;
    boolean blinkingFlag = true;
    String newLineString;
    double psdADarkLevel;
    double psdBDarkLevel;
    double psdCDarkLevel;
    double psdDDarkLevel;
    JLabel blinkingCtrl;
    private Timer timer = null;
    private final int blinkingRate = 200;
    private int checkType;
    private double baseLineIntensity;
    private double currentBackMirrorIntensity;
    private HealthChecksDataListener healthChecksDataListener = new HealthChecksDataListener();
    boolean healthChecksInProgress = false;
    JLabel currentBlinkingCtrl;
    JLabel currentCheckCtrl;
    boolean admDisabled = false;
    boolean baseLineIntensitySet;
    boolean doADMChecks;
    private final int LASER_CHECK = 1;
    private final int ENCODER_CHECK = 2;
    private final int MOTOR_CHECK = 3;
    private final int WEATHER_CHECK = 4;
    private final int KINEMATIC_MODEL_CHECK = 5;
    private final int PSD_CHECK = 6;
    private final int INTERFEROMETER_CHECK = 7;
    private final int ADM_CHECK = 8;
    private final int STORE_TRACKER_STATE = 9;
    private final int RESTORE_TRACKER_STATE = 10;
    private final int SHUTTER_CHECK = 11;
    private final double PSD_DARK_LEVEL_THRESHOLD = 0.1;
    private final double BACK_MIRROR_INTENSITY_THRESHOLD = 40.0;
    boolean admCapable;
    private StringBuffer detailedResultsBuffer = new StringBuffer(2500);
    private boolean allTestsPassed = true;
    private boolean criticalFailureDetected = false;
    private StringBuffer limitationsBuffer = new StringBuffer(500);
    private HealthChecksWarningsDlg limitationsDlg = null;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JPanel jPanel2 = new JPanel();
    JPanel jPanel3 = new JPanel();
    JLabel jLblResult = new JLabel();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    JPanel jPanel1 = new JPanel();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JLabel laserCheck = new JLabel();
    JLabel motorCheck = new JLabel();
    JLabel encoderCheck = new JLabel();
    JLabel psdCheck = new JLabel();
    JLabel admCheck = new JLabel();
    JLabel weatherCheck = new JLabel();
    GridBagLayout gridBagLayout4 = new GridBagLayout();
    Color goColor = new Color(0, 125, 55);
    Color nogoColor = new Color(255, 0, 0);
    JLabel laserResult = new JLabel();
    JLabel encoderResult = new JLabel();
    JLabel motorResult = new JLabel();
    JLabel kinematicModelResult = new JLabel();
    JLabel interferometerResult = new JLabel();
    JLabel weatherResult = new JLabel();
    JLabel admResult = new JLabel();
    JLabel kinematicModelCheck = new JLabel();
    JLabel interferometerCheck = new JLabel();
    JLabel jLabel26 = new JLabel();
    JLabel psdResult = new JLabel();
    JButton ctrlRerun = new JButton();
    JButton ctrlDetails = new JButton();
    JButton ctrlClose = new JButton();
    Component component1;
    Component component2;
    Component component3;
    Component component4;
    JPanel jPanel4 = new JPanel();
    JTextField goNogoResult = new JTextField();
    Border border1;
    GridLayout gridLayout1 = new GridLayout();

    public HealthChecks(String string, Tracker tracker, JFrame jFrame) {
        super(string, tracker, jFrame);
        File file = new File(".");
        JFileChooser jFileChooser = new JFileChooser(file);
        this.outputFileName = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(jFileChooser.getCurrentDirectory()))).append(File.separator).append(res.getString("Default_details_file"))));
        this.newLineString = XTool.lineSeparator();
        file = null;
        jFileChooser = null;
        try {
            this.jbInit();
            this.healthChecksThread = new HealthChecksThread(this.trk, this.threadCreationComplete, this.trackerAppBusyListener, this.commandThreadExitListener, this.frame);
            this.commandThread = this.healthChecksThread;
            this.processParam(string);
            this.limitationsDlg = new HealthChecksWarningsDlg(this.frame, "HealthChecks ".concat(String.valueOf(String.valueOf(res.getString("Limitations")))), true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String toString() {
        return new String("Health Checks 4xxx");
    }

    private void addExceptionErrorToDetails(String string) {
        this.detailedResultsBuffer.append("*****   ").append(string).append(".").append(this.newLineString).append(this.newLineString);
    }

    public void setBusyStateToApp(boolean bl) {
        if (this.healthChecksThread == null || this.healthChecksInProgress) {
            return;
        }
        this.ctrlClose.setEnabled(!bl);
        this.enableControls(!bl);
    }

    void setWarningIcons() {
        if (this.admResult.getIcon() == this.m_badImage) {
            this.admResult.setIcon(this.m_warningImage);
        }
    }

    void stop4000HealthChecks() {
        this.currentBlinkingCtrl.setVisible(true);
        this.setBusy(false);
        this.healthChecksInProgress = false;
        this.goNogoResult.setVisible(true);
        this.goNogoResult.setFont(new Font("SansSerif", 1, 25));
        if (!this.allTestsPassed) {
            if (this.criticalFailureDetected) {
                this.goNogoResult.setBackground(Color.red);
                this.goNogoResult.setText(res.getString("NoGo"));
            } else {
                this.goNogoResult.setBackground(Color.yellow);
                this.goNogoResult.setText(res.getString("Limitations"));
                this.limitationsDlg.setLimitations(this.limitationsBuffer.toString());
                if (this.limitationsDlg.isLimitationAccepted()) {
                    this.goNogoResult.setBackground(Color.yellow);
                    this.goNogoResult.setText(res.getString("Go_limitations"));
                    this.setWarningIcons();
                    this.detailedResultsBuffer.append(res.getString("User_accepted_limitations")).append(this.newLineString);
                } else {
                    this.goNogoResult.setBackground(Color.red);
                    this.goNogoResult.setText(res.getString("NoGo_limitations"));
                }
            }
        } else {
            this.goNogoResult.setBackground(Color.green);
            this.goNogoResult.setText(res.getString("Go"));
        }
        this.ctrlClose.setText(res.getString("Close"));
        XTool.saveResults(this.frame, this.outputFileName, this.detailedResultsBuffer.toString(), true, res.getString("File_open_error"), res.getString("File_open_error_msg"));
    }

    void onTimer(ActionEvent actionEvent) {
        this.goNogoResult.setText(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(res.getString("Checking")))).append(" : ").append(this.currentCheckCtrl.getText()))));
        if (this.blinkingFlag) {
            this.blinkingCtrl.setIcon(this.blink1Image);
            this.blinkingFlag = false;
        } else {
            this.blinkingCtrl.setIcon(this.blink2Image);
            this.blinkingFlag = true;
        }
    }

    void storeCurrentTrackerState() {
        this.checkType = 9;
        Object[] objectArray = new Object[1];
        objectArray[0] = new Integer(8);
        this.doThreadTransaction(objectArray, "", this.healthChecksDataListener);
    }

    void restoreTrackerState() {
        this.checkType = 10;
        Object[] objectArray = new Object[1];
        objectArray[0] = new Integer(9);
        this.doThreadTransaction(objectArray, "", this.healthChecksDataListener);
    }

    void start4000HealthChecks() {
        this.allTestsPassed = true;
        this.limitationsBuffer.delete(0, this.limitationsBuffer.length());
        this.criticalFailureDetected = false;
        this.ctrlClose.setText(res.getString("Stop"));
        this.ctrlClose.setEnabled(true);
        this.blinkingCtrl = this.laserResult;
        this.currentCheckCtrl = this.laserCheck;
        this.timer = new Timer(200, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HealthChecks.this.onTimer(actionEvent);
            }
        });
        this.timer.start();
        this.storeCurrentTrackerState();
    }

    void doLaserChecks() {
        this.checkType = 1;
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("laser.int_output"), new DataTagDouble("laser.output"), new DataTagUnsigned16("laser.status")};
        Object[] objectArray = new Object[2];
        objectArray[0] = new Integer(1);
        objectArray[1] = dataTagArray;
        this.doThreadTransaction(objectArray, "", this.healthChecksDataListener);
    }

    void doEncoderChecks() {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned16("az_motor_in.status"), new DataTagUnsigned16("el_motor_in.status")};
        Object[] objectArray = new Object[2];
        objectArray[0] = new Integer(1);
        objectArray[1] = dataTagArray;
        this.doThreadTransaction(objectArray, "", this.healthChecksDataListener);
    }

    void doMotorChecks() {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned32("motor_state.int_output")};
        Object[] objectArray = new Object[2];
        objectArray[0] = new Integer(1);
        objectArray[1] = dataTagArray;
        this.doThreadTransaction(objectArray, "", this.healthChecksDataListener);
    }

    void doWeatherChecks() {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned16("ambient_temp.status"), new DataTagUnsigned16("air_pressure.status"), new DataTagUnsigned16("humidity.status"), new DataTagDouble("ambient_temp.output"), new DataTagDouble("air_pressure.output"), new DataTagDouble("humidity.output")};
        Object[] objectArray = new Object[2];
        objectArray[0] = new Integer(1);
        objectArray[1] = dataTagArray;
        this.doThreadTransaction(objectArray, "", this.healthChecksDataListener);
    }

    void doKinematicModelChecks() {
        DataTag[] dataTagArray = new DataTag[]{new DataTagDouble("kinematic_dqc.output")};
        Object[] objectArray = new Object[2];
        objectArray[0] = new Integer(1);
        objectArray[1] = dataTagArray;
        this.doThreadTransaction(objectArray, "", this.healthChecksDataListener);
    }

    void doPSDChecks() {
        DataTag[] dataTagArray = new DataTag[]{new DataTagDouble("hene_baseline_int.output"), new DataTagDouble("quad_a_up.output"), new DataTagDouble("quad_b_up.output"), new DataTagDouble("quad_c_up.output"), new DataTagDouble("quad_d_up.output")};
        Object[] objectArray = new Object[2];
        objectArray[0] = new Integer(4);
        objectArray[1] = dataTagArray;
        this.doThreadTransaction(objectArray, "", this.healthChecksDataListener);
    }

    void doInterferometerChecks() {
        DataTag[] dataTagArray = new DataTag[]{new DataTagUnsigned16("iso_temp.status")};
        Object[] objectArray = new Object[2];
        objectArray[0] = new Integer(5);
        objectArray[1] = dataTagArray;
        this.doThreadTransaction(objectArray, "", this.healthChecksDataListener);
    }

    void doADMChecks() {
        Object[] objectArray = new Object[1];
        objectArray[0] = new Integer(6);
        this.doThreadTransaction(objectArray, "", this.healthChecksDataListener);
    }

    boolean checkDarkLevelData(Object[] objectArray) {
        this.baseLineIntensity = (Double)objectArray[0];
        this.psdADarkLevel = (Double)objectArray[1];
        this.psdBDarkLevel = (Double)objectArray[2];
        this.psdCDarkLevel = (Double)objectArray[3];
        this.psdDDarkLevel = (Double)objectArray[4];
        return Math.abs(this.psdADarkLevel) < 0.1 && Math.abs(this.psdBDarkLevel) < 0.1 && Math.abs(this.psdCDarkLevel) < 0.1 && Math.abs(this.psdDDarkLevel) < 0.1;
    }

    boolean checkStatusHistoryForIFRunning(Status[] statusArray) {
        int n = statusArray.length;
        for (int i = n - 1; i >= 0; --i) {
            if (statusArray[i].getCode() != 8) continue;
            return !statusArray[i].getState();
        }
        return true;
    }

    boolean checkIsolatorStatusHistory(Status[] statusArray) {
        int n = statusArray.length;
        for (int i = n - 1; i >= 0; --i) {
            if (statusArray[i].getCode() != 4) continue;
            return !statusArray[i].getState();
        }
        return true;
    }

    public void enableControls(boolean bl) {
        this.ctrlRerun.setEnabled(bl);
        this.ctrlDetails.setEnabled(bl);
    }

    void clearAllChecks() {
        this.laserResult.setIcon(this.untestedImage);
        this.encoderResult.setIcon(this.untestedImage);
        this.motorResult.setIcon(this.untestedImage);
        this.kinematicModelResult.setIcon(this.untestedImage);
        this.weatherResult.setIcon(this.untestedImage);
        this.admResult.setIcon(this.untestedImage);
        this.psdResult.setIcon(this.untestedImage);
        this.interferometerResult.setIcon(this.untestedImage);
        this.ctrlClose.setText(res.getString("Close"));
    }

    void onRerunTest(ActionEvent actionEvent) {
        this.goNogoResult.setFont(new Font("SansSerif", 1, 15));
        this.clearAllChecks();
        this.doInitialTestsBeforeStartingHealthChecks();
    }

    public void launchApp() {
        if (this.healthChecksThread == null) {
            return;
        }
        Object[] objectArray = this.healthChecksThread.receiveResponse();
        if (objectArray[0] != null && (objectArray[0] instanceof DeviceLockedException || objectArray[0] instanceof CommunicationException || objectArray[0] instanceof NoResponseException)) {
            this.ctrlClose.setText(res.getString("Close"));
            this.setBusy(true);
            this.showFatalErrorAndCloseApp(TrackerExceptionString.getError((TrackerException)((Object)objectArray[0])));
            return;
        }
        this.enableErrorDialogDisplay(false);
        Boolean[] booleanArray = (Boolean[])objectArray[2];
        this.admCapable = booleanArray[0];
        this.baseLineIntensitySet = booleanArray[1];
        boolean bl = booleanArray[2];
        if (this.admCapable && bl) {
            this.admDisabled = true;
        }
        if (this.admDisabled) {
            if (JOptionPane.showConfirmDialog(this.frame, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(res.getString("ADM_not_enabled")))).append("\n").append(res.getString("Want_to_enable_ADM_msg")))), res.getString("Want_to_enable_ADM"), 0) == 1) {
                this.admCheck.setEnabled(false);
                this.admResult.setEnabled(false);
            } else {
                this.admDisabled = false;
            }
        }
        boolean bl2 = this.doADMChecks = this.admCapable && !this.admDisabled;
        if (this.admDisabled) {
            P.rintln("This is an ADM tracker but ADM is disabled");
        } else if (this.admCapable) {
            P.rintln("This is an ADM tracker");
        } else {
            P.rintln("This is an non-ADM tracker");
        }
        this.doInitialTestsBeforeStartingHealthChecks();
    }

    public void setBusy(boolean bl) {
        if (this.healthChecksInProgress) {
            return;
        }
        this.enableControls(!bl);
    }

    void onDetails(ActionEvent actionEvent) {
        HealthChecksDetailsDlg healthChecksDetailsDlg = new HealthChecksDetailsDlg(this.frame, this.detailedResultsBuffer.toString(), res.getString("Health_checks_title"), this.outputFileName, true);
        this.outputFileName = healthChecksDetailsDlg.extractOutputFileName();
    }

    private void doInitialTestsBeforeStartingHealthChecks() {
        this.goNogoResult.setBackground(Color.lightGray);
        this.goNogoResult.setText("");
        this.doShutterChecks();
    }

    private void doShutterChecks() {
        this.checkType = 11;
        Object[] objectArray = new Object[1];
        objectArray[0] = new Integer(7);
        this.doThreadTransaction(objectArray, "", this.healthChecksDataListener);
    }

    protected boolean isOKToCloseApp() {
        return !this.isBusy() && !this.healthChecksInProgress;
    }

    private void processParam(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "-", true);
            while (true) {
                String string2;
                if (!(string2 = stringTokenizer.nextToken()).equals("-")) {
                    continue;
                }
                while ((string2 = stringTokenizer.nextToken()).equals("-")) {
                }
                string2 = string2.trim();
                switch (string2.charAt(0)) {
                    case 'b': {
                        break;
                    }
                    case 'f': {
                        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "f");
                        this.outputFileName = stringTokenizer2.nextToken();
                        this.outputFileName = this.outputFileName.trim();
                        if (this.outputFileName.indexOf(".") != -1) break;
                        this.outputFileName = String.valueOf(String.valueOf(this.outputFileName)).concat(String.valueOf(String.valueOf(res.getString("_txt"))));
                    }
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    private void jbInit() throws Exception {
        Image image = this.loadImage("nogo.gif", this.imagePath);
        if (image == null) {
            System.out.println("Could not load bad image");
        } else {
            this.m_badImage = new ImageIcon(image);
        }
        image = this.loadImage("go.gif", this.imagePath);
        if (image == null) {
            System.out.println("Could not load good image");
        } else {
            this.m_goodImage = new ImageIcon(image);
        }
        image = this.loadImage("warn.gif", this.imagePath);
        if (image == null) {
            System.out.println("Could not load warning image");
        } else {
            this.m_warningImage = new ImageIcon(image);
        }
        image = this.loadImage("notInstalled.gif", this.imagePath);
        if (image == null) {
            System.out.println("Could not load notins image");
        } else {
            this.m_notInstalledImage = new ImageIcon(image);
        }
        image = this.loadImage("untested.gif", this.imagePath);
        if (image == null) {
            System.out.println("Could not load untested image");
        } else {
            this.untestedImage = new ImageIcon(image);
        }
        image = this.loadImage("blink1.gif", this.imagePath);
        if (image == null) {
            System.out.println("Could not load blink1 image");
        } else {
            this.blink1Image = new ImageIcon(image);
        }
        image = this.loadImage("blink2.gif", this.imagePath);
        if (image == null) {
            System.out.println("Could not load blink2 image");
        } else {
            this.blink2Image = new ImageIcon(image);
        }
        this.component1 = Box.createHorizontalStrut(8);
        this.component2 = Box.createHorizontalStrut(8);
        this.component3 = Box.createHorizontalStrut(8);
        this.component4 = Box.createHorizontalStrut(8);
        this.border1 = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(SystemColor.controlText, 1), BorderFactory.createEmptyBorder(1, 1, 1, 1));
        ((JComponent)((Object)this)).setMaximumSize(new Dimension(325, 235));
        ((JComponent)((Object)this)).setMinimumSize(new Dimension(325, 235));
        ((JComponent)((Object)this)).setPreferredSize(new Dimension(325, 235));
        ((Container)((Object)this)).setLayout(this.gridBagLayout1);
        this.jPanel2.setLayout(this.gridBagLayout4);
        this.jPanel3.setLayout(this.gridBagLayout3);
        this.jLblResult.setFont(new Font("Dialog", 1, 30));
        this.jLblResult.setForeground(Color.red);
        this.jLblResult.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.jLblResult.setHorizontalAlignment(0);
        this.jLblResult.setHorizontalTextPosition(0);
        this.jPanel3.setMaximumSize(new Dimension(525, 250));
        this.jPanel3.setMinimumSize(new Dimension(0, 0));
        this.jPanel3.setPreferredSize(new Dimension(0, 0));
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel2.setMaximumSize(new Dimension(525, 250));
        this.jPanel2.setMinimumSize(new Dimension(100, 45));
        this.jPanel2.setPreferredSize(new Dimension(100, 45));
        this.jPanel1.setLayout(this.gridBagLayout2);
        this.laserCheck.setMaximumSize(new Dimension(25, 17));
        this.laserCheck.setMinimumSize(new Dimension(25, 17));
        this.laserCheck.setPreferredSize(new Dimension(25, 17));
        this.laserCheck.setText(res.getString("Laser"));
        this.motorCheck.setMaximumSize(new Dimension(25, 17));
        this.motorCheck.setMinimumSize(new Dimension(25, 17));
        this.motorCheck.setPreferredSize(new Dimension(25, 17));
        this.motorCheck.setText(res.getString("Motors"));
        this.encoderCheck.setMaximumSize(new Dimension(25, 17));
        this.encoderCheck.setMinimumSize(new Dimension(25, 17));
        this.encoderCheck.setPreferredSize(new Dimension(25, 17));
        this.encoderCheck.setText(res.getString("Encoders"));
        this.psdCheck.setMaximumSize(new Dimension(25, 17));
        this.psdCheck.setMinimumSize(new Dimension(25, 17));
        this.psdCheck.setPreferredSize(new Dimension(25, 17));
        this.psdCheck.setText(res.getString("PSD_Intensities"));
        this.weatherCheck.setMaximumSize(new Dimension(25, 17));
        this.weatherCheck.setMinimumSize(new Dimension(25, 17));
        this.weatherCheck.setPreferredSize(new Dimension(25, 17));
        this.weatherCheck.setText(res.getString("Weather"));
        this.jPanel1.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.jPanel1.setMinimumSize(new Dimension(0, 0));
        this.jPanel1.setPreferredSize(new Dimension(0, 0));
        this.kinematicModelCheck.setMaximumSize(new Dimension(25, 17));
        this.kinematicModelCheck.setMinimumSize(new Dimension(25, 17));
        this.kinematicModelCheck.setPreferredSize(new Dimension(25, 17));
        this.kinematicModelCheck.setText(res.getString("Kinematic_Model"));
        this.laserResult.setText(" ");
        this.encoderResult.setText(" ");
        this.motorResult.setText(" ");
        this.kinematicModelResult.setText(" ");
        this.weatherResult.setText(" ");
        this.admResult.setText(" ");
        this.psdResult.setText(" ");
        this.interferometerResult.setText(" ");
        this.laserResult.setIcon(this.untestedImage);
        this.encoderResult.setIcon(this.untestedImage);
        this.motorResult.setIcon(this.untestedImage);
        this.kinematicModelResult.setIcon(this.untestedImage);
        this.weatherResult.setIcon(this.untestedImage);
        this.admResult.setIcon(this.untestedImage);
        this.psdResult.setIcon(this.untestedImage);
        this.interferometerResult.setIcon(this.untestedImage);
        this.interferometerCheck.setMaximumSize(new Dimension(25, 17));
        this.interferometerCheck.setMinimumSize(new Dimension(25, 17));
        this.interferometerCheck.setPreferredSize(new Dimension(25, 17));
        this.interferometerCheck.setText(res.getString("Interferometer"));
        this.ctrlRerun.setMinimumSize(new Dimension(100, 25));
        this.ctrlRerun.setPreferredSize(new Dimension(100, 25));
        this.ctrlRerun.setMargin(new Insets(2, 2, 2, 2));
        this.ctrlRerun.setText(res.getString("Rerun_test"));
        this.ctrlRerun.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HealthChecks.this.onRerunTest(actionEvent);
            }
        });
        this.ctrlDetails.setMinimumSize(new Dimension(85, 25));
        this.ctrlDetails.setPreferredSize(new Dimension(85, 25));
        this.ctrlDetails.setMnemonic('0');
        this.ctrlDetails.setText(res.getString("Details"));
        this.ctrlDetails.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HealthChecks.this.onDetails(actionEvent);
            }
        });
        this.admCheck.setMinimumSize(new Dimension(25, 17));
        this.admCheck.setPreferredSize(new Dimension(25, 17));
        this.admCheck.setText("ADM");
        this.ctrlClose.setMaximumSize(new Dimension(67, 25));
        this.ctrlClose.setMinimumSize(new Dimension(67, 25));
        this.ctrlClose.setPreferredSize(new Dimension(67, 25));
        this.ctrlClose.setText(res.getString("Close"));
        this.ctrlClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HealthChecks.this.onClose(actionEvent);
            }
        });
        this.goNogoResult.setBackground(Color.lightGray);
        this.goNogoResult.setText("");
        this.goNogoResult.setFont(new Font("SansSerif", 1, 15));
        this.goNogoResult.setDoubleBuffered(true);
        this.goNogoResult.setMaximumSize(new Dimension(65, 35));
        this.goNogoResult.setMinimumSize(new Dimension(65, 35));
        this.goNogoResult.setPreferredSize(new Dimension(65, 35));
        this.goNogoResult.setDisabledTextColor(Color.black);
        this.goNogoResult.setEnabled(false);
        this.goNogoResult.setHorizontalAlignment(0);
        this.jPanel4.setBorder(this.border1);
        this.jPanel4.setLayout(this.gridLayout1);
        ((Container)((Object)this)).add(this.jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 0), 0, 0));
        this.jPanel2.add(this.component1, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.ctrlRerun, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel2.add(this.component2, new GridBagConstraints(2, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.ctrlDetails, new GridBagConstraints(3, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add(this.component3, new GridBagConstraints(4, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.ctrlClose, new GridBagConstraints(5, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add(this.component4, new GridBagConstraints(6, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        ((Container)((Object)this)).add(this.jPanel3, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.jPanel3.add((Component)this.jLblResult, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel3.add((Component)this.jPanel1, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel1.add((Component)this.laserCheck, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 10, 2, 2), 0, 0));
        this.jPanel1.add((Component)this.jLabel26, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.encoderCheck, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 10, 2, 2), 0, 0));
        this.jPanel1.add((Component)this.motorCheck, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 10, 2, 2), 0, 0));
        this.jPanel1.add((Component)this.laserResult, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.encoderResult, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.motorResult, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.weatherResult, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.weatherCheck, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 10, 2, 2), 0, 0));
        this.jPanel1.add((Component)this.kinematicModelCheck, new GridBagConstraints(4, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 10, 2, 2), 0, 0));
        this.jPanel1.add((Component)this.psdCheck, new GridBagConstraints(4, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 10, 2, 2), 0, 0));
        this.jPanel1.add((Component)this.interferometerCheck, new GridBagConstraints(4, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 10, 2, 2), 0, 0));
        this.jPanel1.add((Component)this.admCheck, new GridBagConstraints(4, 3, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 10, 2, 2), 0, 0));
        this.jPanel1.add((Component)this.kinematicModelResult, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.psdResult, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.interferometerResult, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.admResult, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel3.add((Component)this.jPanel4, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel4.add((Component)this.goNogoResult, null);
    }

    private class HealthChecksDataListener
    implements ThreadListener,
    Runnable {
        Object[] results;
        boolean exceptionOccured = false;
        String exceptionMessages;
        String individualResult;
        String htmlStarter = "<html>";
        String errorMsgStarter = "*****   ";
        String tabString = "\t";

        private HealthChecksDataListener() {
        }

        public void commandComplete() {
            this.results = HealthChecks.this.healthChecksThread.peekResponse();
            if (!HealthChecks.this.healthChecksInProgress) {
                HealthChecks.this.healthChecksInProgress = true;
            }
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            if (this.results != null) {
                if (this.results[0] != null) {
                    this.exceptionOccured = true;
                    this.exceptionMessages = TrackerExceptionString.getError((TrackerException)((Object)this.results[0]));
                    this.individualResult = String.valueOf(String.valueOf(this.exceptionMessages)).concat(".");
                } else {
                    this.exceptionOccured = false;
                }
                if (this.results[1] == null && this.results[2] == null) {
                    P.rintln("Null data returned");
                    return;
                }
                Object[] objectArray = (Object[])this.results[2];
                switch (HealthChecks.this.checkType) {
                    case 11: {
                        boolean bl = (Boolean)objectArray[0];
                        if (bl) {
                            P.rintln("shutter is open");
                            HealthChecks.this.start4000HealthChecks();
                            break;
                        }
                        P.rintln("Shutter is closed");
                        HealthChecks.this.showFatalErrorAndCloseApp(res.getString("Close_app_due_to_shutter_close"));
                        break;
                    }
                    case 9: {
                        if (!this.exceptionOccured) {
                            HealthChecks.this.doLaserChecks();
                            break;
                        }
                        HealthChecks.this.addExceptionErrorToDetails(this.exceptionMessages);
                        HealthChecks.this.stop4000HealthChecks();
                        break;
                    }
                    case 1: {
                        String string = this.individualResult;
                        HealthChecks.this.detailedResultsBuffer.delete(0, HealthChecks.this.detailedResultsBuffer.length());
                        HealthChecks.this.detailedResultsBuffer.append(res.getString("Health_checks")).append(" ").append(XTime.getTime()).append(" ( ").append(XTime.getDate()).append(" ) ").append(HealthChecks.this.newLineString).append(HealthChecks.this.newLineString);
                        HealthChecks.this.detailedResultsBuffer.append(res.getString("Laser_info")).append(HealthChecks.this.newLineString);
                        if (!this.exceptionOccured) {
                            string = this.htmlStarter;
                            long l = (Long)objectArray[0];
                            double d = (int)Math.round((Double)objectArray[1] * (double)100);
                            int n = (Integer)objectArray[2];
                            if (l == (long)2) {
                                HealthChecks.this.laserResult.setIcon(HealthChecks.this.m_goodImage);
                                this.individualResult = res.getString("laser_is_stable");
                                HealthChecks.this.detailedResultsBuffer.append(this.tabString);
                            } else {
                                HealthChecks.this.laserResult.setIcon(HealthChecks.this.m_badImage);
                                HealthChecks.this.allTestsPassed = false;
                                HealthChecks.this.criticalFailureDetected = true;
                                HealthChecks.this.detailedResultsBuffer.append(this.errorMsgStarter);
                                this.individualResult = l == (long)1 ? res.getString("laser_is_ON_but_not_stable") : (l == (long)0 ? res.getString("laser_is_OFF_") : res.getString("laser_is_in_error_"));
                            }
                            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(this.individualResult)));
                            HealthChecks.this.detailedResultsBuffer.append(this.individualResult);
                            string = String.valueOf(String.valueOf(string)).concat("<br>");
                            this.individualResult = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(res.getString("PWM")))).append(" = ").append(d).append(" % (").append(res.getString("Status")).append(" - ").append(HealthChecks.this.getStatusString(n)).append(")")));
                            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(this.individualResult)));
                            HealthChecks.this.detailedResultsBuffer.append(HealthChecks.this.newLineString).append(this.tabString).append(this.individualResult).append(HealthChecks.this.newLineString).append(HealthChecks.this.newLineString);
                        } else {
                            HealthChecks.this.addExceptionErrorToDetails(this.exceptionMessages);
                            HealthChecks.this.laserResult.setIcon(HealthChecks.this.m_badImage);
                            HealthChecks.this.allTestsPassed = false;
                            HealthChecks.this.criticalFailureDetected = true;
                        }
                        HealthChecks.this.laserResult.setToolTipText(string);
                        HealthChecks.this.checkType = 2;
                        HealthChecks.this.currentBlinkingCtrl = HealthChecks.this.blinkingCtrl;
                        HealthChecks.this.blinkingCtrl = HealthChecks.this.encoderResult;
                        HealthChecks.this.currentCheckCtrl = HealthChecks.this.encoderCheck;
                        HealthChecks.this.currentBlinkingCtrl.setVisible(true);
                        HealthChecks.this.doEncoderChecks();
                        break;
                    }
                    case 2: {
                        HealthChecks.this.detailedResultsBuffer.append(res.getString("Encoders_info")).append(HealthChecks.this.newLineString);
                        String string = this.individualResult;
                        if (!this.exceptionOccured) {
                            String string2;
                            string = "<html>";
                            int n = (Integer)objectArray[0];
                            int n2 = (Integer)objectArray[1];
                            if (n == 0 && n2 == 0) {
                                HealthChecks.this.encoderResult.setIcon(HealthChecks.this.m_goodImage);
                                HealthChecks.this.detailedResultsBuffer.append(this.tabString);
                            } else {
                                HealthChecks.this.encoderResult.setIcon(HealthChecks.this.m_badImage);
                                HealthChecks.this.allTestsPassed = false;
                                HealthChecks.this.criticalFailureDetected = true;
                                HealthChecks.this.detailedResultsBuffer.append(this.errorMsgStarter);
                            }
                            this.individualResult = n == 0 ? res.getString("The_Azimuth_motor") : (n == 1 ? res.getString("Azimuth_motors_are_off") : res.getString("Azimuth_motor_state"));
                            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(this.individualResult)));
                            this.individualResult = String.valueOf(String.valueOf(this.individualResult)).concat(String.valueOf(String.valueOf(HealthChecks.this.newLineString)));
                            string = String.valueOf(String.valueOf(string)).concat("<br>");
                            HealthChecks.this.detailedResultsBuffer.append(this.individualResult);
                            if (n2 == 0) {
                                this.individualResult = string2 = res.getString("The_Elevation_motor");
                                HealthChecks.this.detailedResultsBuffer.append(this.tabString).append(this.individualResult);
                            } else if (n2 == 1) {
                                this.individualResult = string2 = res.getString("Elevation_motors_are_off");
                                HealthChecks.this.detailedResultsBuffer.append(this.errorMsgStarter).append(this.individualResult);
                            } else {
                                this.individualResult = string2 = res.getString("Elevation_motor_state");
                                HealthChecks.this.detailedResultsBuffer.append(this.errorMsgStarter).append(this.individualResult);
                            }
                            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(string2)));
                            HealthChecks.this.detailedResultsBuffer.append(HealthChecks.this.newLineString).append(HealthChecks.this.newLineString);
                        } else {
                            HealthChecks.this.addExceptionErrorToDetails(this.exceptionMessages);
                            HealthChecks.this.encoderResult.setIcon(HealthChecks.this.m_badImage);
                            HealthChecks.this.allTestsPassed = false;
                            HealthChecks.this.criticalFailureDetected = true;
                        }
                        HealthChecks.this.encoderResult.setToolTipText(string);
                        HealthChecks.this.checkType = 3;
                        HealthChecks.this.currentBlinkingCtrl = HealthChecks.this.blinkingCtrl;
                        HealthChecks.this.blinkingCtrl = HealthChecks.this.motorResult;
                        HealthChecks.this.currentCheckCtrl = HealthChecks.this.motorCheck;
                        HealthChecks.this.currentBlinkingCtrl.setVisible(true);
                        HealthChecks.this.doMotorChecks();
                        break;
                    }
                    case 3: {
                        HealthChecks.this.detailedResultsBuffer.append(res.getString("Motor_info")).append(HealthChecks.this.newLineString);
                        if (!this.exceptionOccured) {
                            long l = (Long)objectArray[0];
                            if (l == (long)1) {
                                HealthChecks.this.motorResult.setIcon(HealthChecks.this.m_goodImage);
                                HealthChecks.this.detailedResultsBuffer.append(this.tabString);
                                this.individualResult = res.getString("The_motor_state_is_stable");
                            } else if (l == (long)0) {
                                HealthChecks.this.motorResult.setIcon(HealthChecks.this.m_badImage);
                                HealthChecks.this.detailedResultsBuffer.append(this.errorMsgStarter);
                                this.individualResult = res.getString("motors_are_turned_OFF");
                            } else {
                                HealthChecks.this.motorResult.setIcon(HealthChecks.this.m_badImage);
                                HealthChecks.this.allTestsPassed = false;
                                HealthChecks.this.criticalFailureDetected = true;
                                HealthChecks.this.detailedResultsBuffer.append(this.errorMsgStarter);
                                this.individualResult = res.getString("motor_state_is_in_error");
                            }
                            HealthChecks.this.detailedResultsBuffer.append(this.individualResult).append(HealthChecks.this.newLineString).append(HealthChecks.this.newLineString);
                        } else {
                            HealthChecks.this.addExceptionErrorToDetails(this.exceptionMessages);
                            HealthChecks.this.motorResult.setIcon(HealthChecks.this.m_badImage);
                            HealthChecks.this.allTestsPassed = false;
                            HealthChecks.this.criticalFailureDetected = true;
                        }
                        HealthChecks.this.motorResult.setToolTipText(String.valueOf(String.valueOf(this.htmlStarter)).concat(String.valueOf(String.valueOf(this.individualResult))));
                        HealthChecks.this.checkType = 4;
                        HealthChecks.this.currentBlinkingCtrl = HealthChecks.this.blinkingCtrl;
                        HealthChecks.this.blinkingCtrl = HealthChecks.this.weatherResult;
                        HealthChecks.this.currentCheckCtrl = HealthChecks.this.weatherCheck;
                        HealthChecks.this.currentBlinkingCtrl.setVisible(true);
                        HealthChecks.this.doWeatherChecks();
                        break;
                    }
                    case 4: {
                        HealthChecks.this.detailedResultsBuffer.append(res.getString("Weather_info")).append(HealthChecks.this.newLineString);
                        String string = this.individualResult;
                        if (!this.exceptionOccured) {
                            string = "<html>";
                            int n = (Integer)objectArray[0];
                            boolean bl = false;
                            int n3 = (Integer)objectArray[1];
                            boolean bl2 = false;
                            int n4 = (Integer)objectArray[2];
                            boolean bl3 = false;
                            double d = (Double)objectArray[3];
                            double d2 = (Double)objectArray[4];
                            double d3 = (Double)objectArray[5] * (double)100;
                            if (n == 0) {
                                bl = true;
                                HealthChecks.this.detailedResultsBuffer.append(this.tabString);
                                this.individualResult = res.getString("Temperature_state_stable");
                            } else if ((n & 8) != 0) {
                                bl = true;
                                this.individualResult = res.getString("Temperature_value_manual");
                                HealthChecks.this.detailedResultsBuffer.append(this.tabString);
                            } else {
                                this.individualResult = res.getString("Temperature_state_error");
                                HealthChecks.this.detailedResultsBuffer.append(this.errorMsgStarter);
                            }
                            this.individualResult = String.valueOf(String.valueOf(this.individualResult)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("( ").append(res.getString("Value")).append(" = ").append(HealthChecks.this.localTemperatureUnits.convertToDisplayStr(d)).append(" ").append(HealthChecks.this.localTemperatureUnits.displayName()).append(" )"))))));
                            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.individualResult)).concat("<br>"))));
                            this.individualResult = String.valueOf(String.valueOf(this.individualResult)).concat(String.valueOf(String.valueOf(HealthChecks.this.newLineString)));
                            HealthChecks.this.detailedResultsBuffer.append(this.individualResult);
                            if (n3 == 0) {
                                bl2 = true;
                                HealthChecks.this.detailedResultsBuffer.append(this.tabString);
                                this.individualResult = res.getString("Pressure_state_stable");
                            } else if ((n3 & 8) != 0) {
                                bl2 = true;
                                HealthChecks.this.detailedResultsBuffer.append(this.tabString);
                                this.individualResult = res.getString("Pressure_value_manual");
                            } else {
                                HealthChecks.this.detailedResultsBuffer.append(this.errorMsgStarter);
                                this.individualResult = res.getString("Pressure_state_error");
                            }
                            this.individualResult = String.valueOf(String.valueOf(this.individualResult)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("( ").append(res.getString("Value")).append(" = ").append(HealthChecks.this.localPressureUnits.convertToDisplayStr(d2)).append(" ").append(HealthChecks.this.localPressureUnits.displayName()).append(" )"))))));
                            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.individualResult)).concat("<br>"))));
                            this.individualResult = String.valueOf(String.valueOf(this.individualResult)).concat(String.valueOf(String.valueOf(HealthChecks.this.newLineString)));
                            HealthChecks.this.detailedResultsBuffer.append(this.individualResult);
                            if (n4 == 0) {
                                bl3 = true;
                                HealthChecks.this.detailedResultsBuffer.append(this.tabString);
                                this.individualResult = res.getString("Humidity_state_stable");
                            } else if ((n4 & 8) != 0) {
                                bl3 = true;
                                HealthChecks.this.detailedResultsBuffer.append(this.tabString);
                                this.individualResult = res.getString("Humidity_value_manual");
                            } else {
                                HealthChecks.this.detailedResultsBuffer.append(this.errorMsgStarter);
                                this.individualResult = res.getString("Humidity_state_error");
                            }
                            this.individualResult = String.valueOf(String.valueOf(this.individualResult)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("( ").append(res.getString("Value")).append(" = ").append(Double.toString(d3)).append(" %").append(" )"))))));
                            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(this.individualResult)));
                            HealthChecks.this.detailedResultsBuffer.append(this.individualResult).append(HealthChecks.this.newLineString).append(HealthChecks.this.newLineString);
                            if (bl && bl2 && bl3) {
                                HealthChecks.this.weatherResult.setIcon(HealthChecks.this.m_goodImage);
                            } else {
                                HealthChecks.this.weatherResult.setIcon(HealthChecks.this.m_badImage);
                                HealthChecks.this.allTestsPassed = false;
                                HealthChecks.this.criticalFailureDetected = true;
                            }
                        } else {
                            HealthChecks.this.addExceptionErrorToDetails(this.exceptionMessages);
                            HealthChecks.this.weatherResult.setIcon(HealthChecks.this.m_badImage);
                            HealthChecks.this.allTestsPassed = false;
                            HealthChecks.this.criticalFailureDetected = true;
                        }
                        HealthChecks.this.weatherResult.setToolTipText(string);
                        HealthChecks.this.checkType = 5;
                        HealthChecks.this.currentBlinkingCtrl = HealthChecks.this.blinkingCtrl;
                        HealthChecks.this.blinkingCtrl = HealthChecks.this.kinematicModelResult;
                        HealthChecks.this.currentCheckCtrl = HealthChecks.this.kinematicModelCheck;
                        HealthChecks.this.currentBlinkingCtrl.setVisible(true);
                        HealthChecks.this.doKinematicModelChecks();
                        break;
                    }
                    case 5: {
                        HealthChecks.this.detailedResultsBuffer.append(res.getString("Kinematic_Model_info")).append(HealthChecks.this.newLineString);
                        if (!this.exceptionOccured) {
                            boolean bl = false;
                            double d = (Double)objectArray[0];
                            if (Math.abs(d - 5.428) < 1.0E-14) {
                                HealthChecks.this.kinematicModelResult.setIcon(HealthChecks.this.m_goodImage);
                                bl = true;
                                this.individualResult = res.getString("Kinematic_model_present");
                                HealthChecks.this.detailedResultsBuffer.append(this.tabString);
                            } else {
                                HealthChecks.this.kinematicModelResult.setIcon(HealthChecks.this.m_badImage);
                                this.individualResult = res.getString("Kinematic_model_NOT_present");
                                HealthChecks.this.detailedResultsBuffer.append(this.errorMsgStarter);
                                HealthChecks.this.allTestsPassed = false;
                                HealthChecks.this.criticalFailureDetected = true;
                            }
                            HealthChecks.this.detailedResultsBuffer.append(this.individualResult).append(HealthChecks.this.newLineString).append(HealthChecks.this.newLineString);
                        } else {
                            HealthChecks.this.addExceptionErrorToDetails(this.exceptionMessages);
                            HealthChecks.this.kinematicModelResult.setIcon(HealthChecks.this.m_badImage);
                            HealthChecks.this.allTestsPassed = false;
                            HealthChecks.this.criticalFailureDetected = true;
                        }
                        HealthChecks.this.kinematicModelResult.setToolTipText(String.valueOf(String.valueOf(this.htmlStarter)).concat(String.valueOf(String.valueOf(this.individualResult))));
                        HealthChecks.this.checkType = 6;
                        HealthChecks.this.currentBlinkingCtrl = HealthChecks.this.blinkingCtrl;
                        HealthChecks.this.blinkingCtrl = HealthChecks.this.psdResult;
                        HealthChecks.this.currentCheckCtrl = HealthChecks.this.psdCheck;
                        HealthChecks.this.currentBlinkingCtrl.setVisible(true);
                        HealthChecks.this.doPSDChecks();
                        break;
                    }
                    case 6: {
                        HealthChecks.this.detailedResultsBuffer.append(res.getString("PSD_info")).append(HealthChecks.this.newLineString);
                        String string = this.individualResult;
                        if (!this.exceptionOccured) {
                            string = "<html>";
                            boolean bl = false;
                            Object[] objectArray2 = (Object[])objectArray[0];
                            boolean bl4 = HealthChecks.this.checkDarkLevelData(objectArray2);
                            if (HealthChecks.this.baseLineIntensitySet) {
                                Object[] objectArray3 = (Object[])objectArray[1];
                                double d = (Double)objectArray3[0];
                                Assert.isTrue(Math.abs(HealthChecks.this.baseLineIntensity - d) < 1.0E-14, "baseline intensities differ from dark level and back mirror positions");
                                double d4 = (Double)objectArray3[1];
                                double d5 = (Double)objectArray3[2];
                                double d6 = (Double)objectArray3[3];
                                double d7 = (Double)objectArray3[4];
                                double d8 = d4 + d5 + d6 + d7;
                                HealthChecks.this.currentBackMirrorIntensity = d8 / HealthChecks.this.baseLineIntensity * 100.0;
                                if (HealthChecks.this.currentBackMirrorIntensity >= (double)100) {
                                    HealthChecks.this.currentBackMirrorIntensity = 100.0;
                                }
                                if (HealthChecks.this.currentBackMirrorIntensity >= 40.0) {
                                    bl = true;
                                }
                            } else {
                                bl = true;
                            }
                            boolean bl5 = (Boolean)objectArray[2];
                            if (bl4 && bl && bl5) {
                                HealthChecks.this.psdResult.setIcon(HealthChecks.this.m_goodImage);
                                HealthChecks.this.detailedResultsBuffer.append(this.tabString);
                                this.individualResult = res.getString("PSD_ok");
                                string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(this.individualResult)));
                                string = String.valueOf(String.valueOf(string)).concat("<br>");
                                this.individualResult = String.valueOf(String.valueOf(this.individualResult)).concat(String.valueOf(String.valueOf(HealthChecks.this.newLineString)));
                                HealthChecks.this.detailedResultsBuffer.append(this.individualResult);
                            } else {
                                HealthChecks.this.psdResult.setIcon(HealthChecks.this.m_badImage);
                                HealthChecks.this.allTestsPassed = false;
                                HealthChecks.this.criticalFailureDetected = true;
                                if (!bl4) {
                                    HealthChecks.this.detailedResultsBuffer.append(this.errorMsgStarter);
                                    this.individualResult = res.getString("PSD_darklevel_error");
                                } else {
                                    HealthChecks.this.detailedResultsBuffer.append(this.tabString);
                                    this.individualResult = res.getString("PSD_darklevel_good");
                                }
                                string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(this.individualResult)));
                                string = String.valueOf(String.valueOf(string)).concat("<br>");
                                this.individualResult = String.valueOf(String.valueOf(this.individualResult)).concat(String.valueOf(String.valueOf(HealthChecks.this.newLineString)));
                                HealthChecks.this.detailedResultsBuffer.append(this.individualResult);
                                if (!bl5) {
                                    HealthChecks.this.detailedResultsBuffer.append(this.errorMsgStarter);
                                    this.individualResult = res.getString("PSD_scale_error");
                                } else {
                                    HealthChecks.this.detailedResultsBuffer.append(this.tabString);
                                    this.individualResult = res.getString("PSD_scale_good");
                                }
                                string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(this.individualResult)));
                                string = String.valueOf(String.valueOf(string)).concat("<br>");
                                this.individualResult = String.valueOf(String.valueOf(this.individualResult)).concat(String.valueOf(String.valueOf(HealthChecks.this.newLineString)));
                                HealthChecks.this.detailedResultsBuffer.append(this.individualResult);
                                if (!bl) {
                                    HealthChecks.this.detailedResultsBuffer.append(this.errorMsgStarter);
                                    this.individualResult = res.getString("PSD_return_intensity_error");
                                } else {
                                    HealthChecks.this.detailedResultsBuffer.append(this.tabString);
                                    this.individualResult = HealthChecks.this.baseLineIntensitySet ? res.getString("PSD_return_intensity_good") : res.getString("Base_line_intensity_not_set");
                                }
                                string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(this.individualResult)));
                                string = String.valueOf(String.valueOf(string)).concat("<br>");
                                this.individualResult = String.valueOf(String.valueOf(this.individualResult)).concat(String.valueOf(String.valueOf(HealthChecks.this.newLineString)));
                                HealthChecks.this.detailedResultsBuffer.append(this.individualResult);
                            }
                            this.individualResult = String.valueOf(String.valueOf(new StringBuffer("\t").append(res.getString("Back_mirror_intensity")).append(" = ").append(HealthChecks.this.posForm.format(HealthChecks.this.currentBackMirrorIntensity))));
                            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(this.individualResult)));
                            HealthChecks.this.detailedResultsBuffer.append(this.individualResult).append(HealthChecks.this.newLineString).append(HealthChecks.this.newLineString);
                        } else {
                            HealthChecks.this.addExceptionErrorToDetails(this.exceptionMessages);
                            HealthChecks.this.psdResult.setIcon(HealthChecks.this.m_badImage);
                            HealthChecks.this.allTestsPassed = false;
                            HealthChecks.this.criticalFailureDetected = true;
                        }
                        HealthChecks.this.psdResult.setToolTipText(string);
                        HealthChecks.this.checkType = 7;
                        HealthChecks.this.currentBlinkingCtrl = HealthChecks.this.blinkingCtrl;
                        HealthChecks.this.blinkingCtrl = HealthChecks.this.interferometerResult;
                        HealthChecks.this.currentCheckCtrl = HealthChecks.this.interferometerCheck;
                        HealthChecks.this.currentBlinkingCtrl.setVisible(true);
                        HealthChecks.this.doInterferometerChecks();
                        break;
                    }
                    case 7: {
                        if (!HealthChecks.this.doADMChecks) {
                            HealthChecks.this.timer.stop();
                            HealthChecks.this.timer = null;
                        }
                        if (!this.exceptionOccured) {
                            Object[] objectArray4 = (Object[])objectArray[0];
                            int n = (Integer)objectArray4[0];
                            Status[] statusArray = (Status[])objectArray[1];
                            boolean bl = false;
                            if (n == 0) {
                                bl = HealthChecks.this.checkIsolatorStatusHistory(statusArray);
                            }
                            if (n == 0 && bl) {
                                HealthChecks.this.detailedResultsBuffer.append(res.getString("Interferometer_info")).append(HealthChecks.this.newLineString);
                                HealthChecks.this.interferometerResult.setIcon(HealthChecks.this.m_goodImage);
                                HealthChecks.this.detailedResultsBuffer.append(this.tabString);
                                this.individualResult = res.getString("Interferometer_ok");
                            } else {
                                HealthChecks.this.detailedResultsBuffer.append(res.getString("Interferometer_info")).append(HealthChecks.this.newLineString);
                                HealthChecks.this.interferometerResult.setIcon(HealthChecks.this.m_badImage);
                                HealthChecks.this.allTestsPassed = false;
                                HealthChecks.this.criticalFailureDetected = true;
                                HealthChecks.this.detailedResultsBuffer.append(this.errorMsgStarter);
                                if (n != 0) {
                                    this.individualResult = res.getString("Isolator_bad_status");
                                } else if (!bl) {
                                    this.individualResult = res.getString("Isolator_out_of_range");
                                }
                            }
                            HealthChecks.this.detailedResultsBuffer.append(this.individualResult).append(HealthChecks.this.newLineString).append(HealthChecks.this.newLineString);
                        } else {
                            HealthChecks.this.addExceptionErrorToDetails(this.exceptionMessages);
                            HealthChecks.this.interferometerResult.setIcon(HealthChecks.this.m_badImage);
                            HealthChecks.this.allTestsPassed = false;
                            HealthChecks.this.criticalFailureDetected = true;
                        }
                        HealthChecks.this.interferometerResult.setToolTipText(String.valueOf(String.valueOf(this.htmlStarter)).concat(String.valueOf(String.valueOf(this.individualResult))));
                        if (HealthChecks.this.doADMChecks) {
                            HealthChecks.this.checkType = 8;
                            HealthChecks.this.currentBlinkingCtrl = HealthChecks.this.blinkingCtrl;
                            HealthChecks.this.blinkingCtrl = HealthChecks.this.admResult;
                            HealthChecks.this.currentCheckCtrl = HealthChecks.this.admCheck;
                            HealthChecks.this.currentBlinkingCtrl.setVisible(true);
                            HealthChecks.this.doADMChecks();
                            break;
                        }
                        HealthChecks.this.detailedResultsBuffer.append(res.getString("ADM_info")).append(HealthChecks.this.newLineString);
                        HealthChecks.this.detailedResultsBuffer.append(this.tabString);
                        HealthChecks.this.currentBlinkingCtrl = HealthChecks.this.blinkingCtrl;
                        HealthChecks.this.currentBlinkingCtrl.setVisible(true);
                        if (!HealthChecks.this.admCapable) {
                            this.individualResult = res.getString("ADM_not_installed");
                            HealthChecks.this.admResult.setIcon(HealthChecks.this.m_notInstalledImage);
                        } else {
                            this.individualResult = res.getString("ADM_not_enabled");
                        }
                        HealthChecks.this.admResult.setToolTipText(String.valueOf(String.valueOf(this.htmlStarter)).concat(String.valueOf(String.valueOf(this.individualResult))));
                        HealthChecks.this.detailedResultsBuffer.append(this.individualResult).append(HealthChecks.this.newLineString).append(HealthChecks.this.newLineString);
                        HealthChecks.this.restoreTrackerState();
                        break;
                    }
                    case 8: {
                        HealthChecks.this.timer.stop();
                        HealthChecks.this.timer = null;
                        HealthChecks.this.detailedResultsBuffer.append(res.getString("ADM_info")).append(HealthChecks.this.newLineString);
                        if (!this.exceptionOccured) {
                            boolean bl = (Boolean)objectArray[0];
                            boolean bl6 = false;
                            boolean bl7 = false;
                            boolean bl8 = false;
                            if (bl) {
                                bl6 = (Boolean)objectArray[1];
                                bl7 = (Boolean)objectArray[2];
                                bl8 = (Boolean)objectArray[3];
                            }
                            if (bl && bl6 && bl7 && bl8) {
                                HealthChecks.this.admResult.setIcon(HealthChecks.this.m_goodImage);
                                HealthChecks.this.detailedResultsBuffer.append(this.tabString);
                                this.individualResult = res.getString("ADM_ok");
                            } else {
                                HealthChecks.this.allTestsPassed = false;
                                HealthChecks.this.detailedResultsBuffer.append(this.errorMsgStarter);
                                HealthChecks.this.admResult.setIcon(HealthChecks.this.m_badImage);
                                if (!bl) {
                                    this.individualResult = res.getString("ADM_std_probe_error");
                                } else if (!bl6) {
                                    this.individualResult = res.getString("ADM_ref_intensity_error");
                                } else if (!bl7) {
                                    this.individualResult = res.getString("ADM_meas_intensity_error");
                                } else if (!bl8) {
                                    this.individualResult = res.getString("ADM_crs_raw_error");
                                }
                                if (!HealthChecks.this.criticalFailureDetected) {
                                    HealthChecks.this.limitationsBuffer.append(res.getString("Limitation")).append(": ").append(res.getString("Cannot_use_ifm_set_by_adm")).append(HealthChecks.this.newLineString);
                                    HealthChecks.this.limitationsBuffer.append(res.getString("Limitation")).append(": ").append(res.getString("Can_use_ifm_only")).append(HealthChecks.this.newLineString);
                                    HealthChecks.this.limitationsBuffer.append(HealthChecks.this.newLineString);
                                }
                            }
                            HealthChecks.this.detailedResultsBuffer.append(this.individualResult).append(HealthChecks.this.newLineString);
                            if (HealthChecks.this.limitationsBuffer.length() > 0) {
                                HealthChecks.this.detailedResultsBuffer.append(HealthChecks.this.limitationsBuffer.toString());
                            } else {
                                HealthChecks.this.detailedResultsBuffer.append(HealthChecks.this.newLineString);
                            }
                        } else {
                            HealthChecks.this.addExceptionErrorToDetails(this.exceptionMessages);
                            HealthChecks.this.admResult.setIcon(HealthChecks.this.m_badImage);
                            HealthChecks.this.allTestsPassed = false;
                            HealthChecks.this.criticalFailureDetected = true;
                        }
                        HealthChecks.this.admResult.setToolTipText(String.valueOf(String.valueOf(this.htmlStarter)).concat(String.valueOf(String.valueOf(this.individualResult))));
                        HealthChecks.this.currentBlinkingCtrl = HealthChecks.this.blinkingCtrl;
                        HealthChecks.this.currentBlinkingCtrl.setVisible(true);
                        HealthChecks.this.restoreTrackerState();
                        break;
                    }
                    case 10: {
                        if (this.exceptionOccured) {
                            HealthChecks.this.addExceptionErrorToDetails(this.exceptionMessages);
                        }
                        HealthChecks.this.stop4000HealthChecks();
                    }
                }
            }
        }
    }
}

