/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.apps4xxx.diagnostics;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import smx.tracker.DataTag;
import smx.tracker.DataTagDouble;
import smx.tracker.DataTagUnsigned16;
import smx.tracker.DataTagUnsigned32;
import smx.tracker.MeasureData;
import smx.tracker.apps4xxx.diagnostics.Diagnostics;
import smx.tracker.apps4xxx.diagnostics.DiagnosticsLaserCycleDlg;
import smx.tracker.apps4xxx.diagnostics.DiagnosticsLaserTimeDlg;
import smx.tracker.apps4xxx.diagnostics.DiagnosticsPanel;
import smx.tracker.apps4xxx.utility.ClosureMath;
import smx.tracker.apps4xxx.utility.IconTabListCellRenderer;
import smx.tracker.apps4xxx.utility.ThreadListener;
import smx.tracker.apps4xxx.utility.tools.Assert;
import smx.tracker.apps4xxx.utility.tools.P;
import smx.tracker.apps4xxx.utility.tools.XTime;
import smx.tracker.apps4xxx.utility.tools.XTool;

public class DiagnosticsLaserPane
extends DiagnosticsPanel {
    public static final int READ_DATA = 0;
    public static final int HOME = 1;
    public static final int ENABLE_DIAGNOSTICS = 2;
    public static final int START_FACTORY_BKND_MEASUREMENTS = 3;
    public static final int STOP_FACTORY_BKND_MEASUREMENTS = 4;
    public static final int DO_DARK_LEVEL_CALIBRATION = 5;
    public static final int GET_DARK_LEVEL_QUAD_DATA = 6;
    public static final int GET_BACKMIRROR_INTENSITY_POWER = 7;
    public static final int LASER_ON_OFF = 8;
    boolean bStopReadingData = false;
    boolean factoryBkndMeasurementStarted = false;
    double baseLineIntensity;
    double quadAUpstream;
    double quadBUpstream;
    double quadCUpstream;
    double quadDUpstream;
    DarkLevelCalibrationListener darkLevelCalibrationListener = new DarkLevelCalibrationListener();
    DarkLevelQuadTestListener darkLevelQuadTestListener = new DarkLevelQuadTestListener();
    BackMirrorIntensityListener backMirrorIntensityListener = new BackMirrorIntensityListener();
    LaserOffListener laserOffListener = new LaserOffListener();
    LaserOnListener laserOnListener = new LaserOnListener();
    private DecimalFormat posForm = new DecimalFormat();
    String resultHeading;
    boolean dataBeingRead = false;
    boolean hideLaserCycleDlg = false;
    int laserCycleDelay = 5;
    boolean bturnLaserOn = false;
    boolean onetimeTempSensorDataCollected = false;
    double[] initialSightSpherData = new double[3];
    double[] backSightSpherData = new double[3];
    StringBuffer detailedResults = new StringBuffer(5000);
    int currentState = 0;
    private Component diagnosticsParent;
    long targetType;
    long sightMode;
    ClosureMath closureMath;
    double azimuthAngle;
    double zenithAngle;
    double radialDistance;
    double averageSMRIntensity;
    double temperature;
    double pressure;
    double humidity;
    int temperatureStatus;
    int pressureStatus;
    int humidityStatus;
    double measurementTime;
    int overallStatus;
    int distanceStatus;
    Border border1;
    TitledBorder titledBorder2;
    Border border2;
    Border border3;
    Border border4;
    TitledBorder titledBorder1;
    Border border5;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JLabel jblDummy1 = new JLabel();
    JLabel jblDummy2 = new JLabel();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JPanel jPanel3 = new JPanel();
    JPanel jPanel4 = new JPanel();
    JLabel jblDummy3 = new JLabel();
    JLabel jblDummy4 = new JLabel();
    JPanel jPanel5 = new JPanel();
    JPanel jPanel6 = new JPanel();
    GridLayout gridLayout2 = new GridLayout();
    JPanel jPanelDarkLevel = new JPanel();
    JPanel jPanelOutPutPower = new JPanel();
    TitledBorder titledBorder3;
    Border border6;
    TitledBorder titledBorder4;
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    JLabel jLabel2 = new JLabel();
    JProgressBar jProgressBar1 = new JProgressBar(0, 100);
    JLabel jLabel3 = new JLabel();
    JLabel jLabel4 = new JLabel();
    JTextField jlblLaserState = new JTextField();
    JButton ctrlLaser = new JButton();
    GridBagLayout gridBagLayout4 = new GridBagLayout();
    JLabel jLabel5 = new JLabel();
    JLabel jLabel6 = new JLabel();
    JLabel jLabel7 = new JLabel();
    JLabel jLabel8 = new JLabel();
    JTextField jTextField2 = new JTextField();
    JTextField jTextField3 = new JTextField();
    JTextField jTextField4 = new JTextField();
    JTextField jTextField5 = new JTextField();
    JButton ctrlCalibrate = new JButton();
    JButton ctrlDrkLvlTest = new JButton();
    JButton ctrlOutputTest = new JButton();
    GridBagLayout gridBagLayout5 = new GridBagLayout();
    JTextField jTxtOutPutPower = new JTextField();
    JLabel jLabel9 = new JLabel();
    JLabel jLabel10 = new JLabel();
    GridBagLayout gridBagLayout6 = new GridBagLayout();
    JLabel jLabel11 = new JLabel();
    JLabel jlblTemperature = new JLabel();
    JTextField jTextField7 = new JTextField();
    JLabel jLabel13 = new JLabel();
    JLabel jLabel15 = new JLabel();
    JLabel jlblPressure = new JLabel();
    JTextField jTextField8 = new JTextField();
    JLabel jLabel17 = new JLabel();
    JLabel jLabel18 = new JLabel();
    JLabel jlblHumidity = new JLabel();
    JTextField jTextField9 = new JTextField();
    JLabel jLabel20 = new JLabel();
    JLabel jLabel21 = new JLabel();
    JLabel jlblWavelength = new JLabel();
    JTextField jTextField10 = new JTextField();
    JLabel jLabel23 = new JLabel();
    JPanel jPanel7 = new JPanel();
    GridLayout gridLayout4 = new GridLayout();
    JLabel jlb_Tmp1 = new JLabel();
    JLabel jLabel24 = new JLabel();
    JLabel jlb_Tmp5 = new JLabel();
    JLabel jLabel26 = new JLabel();
    JLabel jlb_Tmp6 = new JLabel();
    JLabel jLabel28 = new JLabel();
    JLabel jlb_Tmp7 = new JLabel();
    JLabel jLabel30 = new JLabel();
    JLabel jlb_Tmp8 = new JLabel();
    JLabel jLabel32 = new JLabel();
    JLabel jlb_Tmp4 = new JLabel();
    JLabel jLabel34 = new JLabel();
    JLabel jlb_Tmp3 = new JLabel();
    JLabel jLabel36 = new JLabel();
    JLabel jlb_Tmp2 = new JLabel();
    JLabel jLabel38 = new JLabel();
    GridBagLayout gridBagLayout7 = new GridBagLayout();
    JPanel jPanel8 = new JPanel();
    JLabel jlblOuputPower = new JLabel();
    GridLayout gridLayout3 = new GridLayout();
    Component component2;
    JPanel jPanel9 = new JPanel();
    Icon autoSettingIcon;
    Icon errorSettingIcon;
    Icon manualSettingIcon;
    Icon lightOffIcon;
    Icon lightOnIcon;
    GridBagLayout gridBagLayout8 = new GridBagLayout();
    GridBagLayout gridBagLayout9 = new GridBagLayout();
    Component component1;
    Component component3;
    Component component4;
    Component component5;
    Component component6;

    public DiagnosticsLaserPane(String string, boolean bl, boolean bl2) {
        super(string);
        this.parentTabPane = Diagnostics.parentApp;
        this.diagnosticsThread = Diagnostics.parentAppCommandThread;
        Image image = this.parentTabPane.loadImage("diagnosticsauto.gif", this.parentTabPane.packagePath);
        if (image == null) {
            System.err.println("Couldn't load image auto");
        } else {
            this.autoSettingIcon = new ImageIcon(image);
        }
        image = this.parentTabPane.loadImage("diagnosticsmanual.gif", this.parentTabPane.packagePath);
        if (image == null) {
            System.err.println("Couldn't load image manual");
        } else {
            this.manualSettingIcon = new ImageIcon(image);
        }
        image = this.parentTabPane.loadImage("diagnosticslightoff.gif", this.parentTabPane.packagePath);
        if (image == null) {
            System.err.println("Couldn't load image lightoff");
        } else {
            this.lightOffIcon = new ImageIcon(image);
        }
        image = this.parentTabPane.loadImage("diagnosticslighton.gif", this.parentTabPane.packagePath);
        if (image == null) {
            System.err.println("Couldn't load image lighton");
        } else {
            this.lightOnIcon = new ImageIcon(image);
        }
        image = this.parentTabPane.loadImage("diagnosticserror.gif", this.parentTabPane.packagePath);
        if (image == null) {
            System.err.println("Couldn't load image error");
        } else {
            this.errorSettingIcon = new ImageIcon(image);
        }
        if (bl) {
            this.ctrlLaser.setText(this.res.getString("Turn_Laser_on"));
        } else {
            this.ctrlLaser.setText(this.res.getString("Turn_Laser_off"));
        }
        if (bl2) {
            this.jPanel8.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), this.res.getString("Return_Power")));
        } else {
            this.jPanel8.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), this.res.getString("Intensity")));
        }
        this.tagsToMeasure = new DataTag[15];
        this.tagsToMeasure[0] = new DataTagDouble("laser.output");
        this.tagsToMeasure[1] = new DataTagUnsigned32("laser.int_output");
        this.tagsToMeasure[2] = new DataTagUnsigned16("ambient_temp.status");
        this.tagsToMeasure[3] = new DataTagDouble("ambient_temp.output");
        this.tagsToMeasure[4] = new DataTagUnsigned16("air_pressure.status");
        this.tagsToMeasure[5] = new DataTagDouble("air_pressure.output");
        this.tagsToMeasure[6] = new DataTagUnsigned16("humidity.status");
        this.tagsToMeasure[7] = new DataTagDouble("humidity.output");
        this.tagsToMeasure[8] = new DataTagUnsigned16("wavelength.status");
        this.tagsToMeasure[9] = new DataTagDouble("wavelength.output");
        this.tagsToMeasure[10] = new DataTagDouble("hene_baseline_int.output");
        this.tagsToMeasure[11] = new DataTagDouble("quad_a_up.output");
        this.tagsToMeasure[12] = new DataTagDouble("quad_b_up.output");
        this.tagsToMeasure[13] = new DataTagDouble("quad_c_up.output");
        this.tagsToMeasure[14] = new DataTagDouble("quad_d_up.output");
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void enableAllControls(boolean bl) {
        this.enableControls(bl);
    }

    void this_componentResized(ComponentEvent componentEvent) {
        Font font = XTool.calculateMaxFontThatFits(this.jlblOuputPower, this.oldDimension);
        if (font == null) {
            return;
        }
        this.jlblOuputPower.setFont(font);
    }

    void showDarklevelQuadData() {
        this.posForm.setMinimumFractionDigits(1);
        this.posForm.setMaximumFractionDigits(1);
        double d = (this.quadAUpstream - this.quadCUpstream) * (double)100;
        double d2 = (this.quadAUpstream + this.quadCUpstream) * (double)50;
        double d3 = (this.quadBUpstream - this.quadDUpstream) * (double)100;
        double d4 = (this.quadBUpstream + this.quadDUpstream) * (double)50;
        String string = this.posForm.format(d2);
        this.jTextField2.setText(string);
        string = this.posForm.format(d);
        this.jTextField3.setText(string);
        string = this.posForm.format(d4);
        this.jTextField4.setText(string);
        string = this.posForm.format(d3);
        this.jTextField5.setText(string);
    }

    void addDarklevelQuadDataResults() {
        this.detailedResults.append(this.res.getString("No_target_intensity"));
        this.detailedResults.append(" :").append(this.newLineString);
        this.detailedResults.append("A + C = ");
        this.detailedResults.append(this.jTextField2.getText()).append(this.newLineString);
        this.detailedResults.append("A - C = ");
        this.detailedResults.append(this.jTextField3.getText()).append(this.newLineString);
        this.detailedResults.append("B + D = ");
        this.detailedResults.append(this.jTextField4.getText()).append(this.newLineString);
        this.detailedResults.append("B - D = ");
        this.detailedResults.append(this.jTextField5.getText()).append(this.newLineString);
        this.detailedResults.append(this.newLineString);
        this.detailedResults.append(this.newLineString);
    }

    void addOutputPowerResults() {
        this.detailedResults.append(this.res.getString("Output_Power")).append(" : ");
        this.detailedResults.append(this.jTxtOutPutPower.getText());
        this.detailedResults.append(this.newLineString);
        this.detailedResults.append(this.newLineString);
    }

    void showReflectedIntensity(boolean bl) {
        this.posForm.setMinimumFractionDigits(1);
        this.posForm.setMaximumFractionDigits(1);
        double d = 0.0;
        double d2 = this.quadAUpstream + this.quadBUpstream + this.quadCUpstream + this.quadDUpstream;
        if (this.parentTabPane.baseLineIntensitySet) {
            if (bl) {
                d2 /= 0.85;
            }
            d = d2 / this.baseLineIntensity * 100.0;
        } else {
            d = d2 / (double)2;
        }
        if (d > 100.0) {
            d = 100.0;
        }
        if (!bl) {
            this.jTxtOutPutPower.setText(this.posForm.format(d));
        } else {
            if (d < (double)20) {
                this.jlblOuputPower.setForeground(Color.red);
            } else {
                this.jlblOuputPower.setForeground(Color.green);
            }
            this.jlblOuputPower.setText(this.posForm.format(d));
        }
        if (!this.fontCalculatedOnce) {
            this.this_componentResized(null);
            this.fontCalculatedOnce = true;
        }
        if (this.parentTabPane.baseLineIntensitySet) {
            this.detailedResults.append(this.res.getString("Return_Power")).append(" : ");
        } else {
            this.detailedResults.append(this.res.getString("Intensity")).append(" : ");
        }
        this.detailedResults.append(this.posForm.format(d));
        this.detailedResults.append(this.newLineString).append(this.newLineString).append(this.newLineString);
    }

    public void enableControls(boolean bl) {
        this.ctrlHome.setEnabled(bl);
        this.ctrlCalibrate.setEnabled(bl);
        this.ctrlLaser.setEnabled(bl);
        this.ctrlDrkLvlTest.setEnabled(bl);
        this.ctrlOutputTest.setEnabled(bl);
        this.ctrlSave.setEnabled(bl);
        this.ctrlSaveAs.setEnabled(bl);
    }

    void setCycleDlgFlag(boolean bl) {
        this.hideLaserCycleDlg = bl;
    }

    void setLaserCycleDelay(int n) {
        this.laserCycleDelay = n;
    }

    void setLaserOnOffFlag(boolean bl) {
        this.bturnLaserOn = bl;
    }

    boolean autoTurnLaserOn() {
        if (this.hideLaserCycleDlg) {
            new DiagnosticsLaserTimeDlg(Diagnostics.parentAppFrame, this.res.getString("Time_remaining"), true, this.laserCycleDelay, this);
        } else {
            new DiagnosticsLaserCycleDlg((Frame)Diagnostics.parentAppFrame, this.res.getString("Cycle_laser_power"), true, this);
        }
        boolean bl = this.bturnLaserOn;
        if (this.bturnLaserOn) {
            this.turnLaserON();
        }
        this.bturnLaserOn = false;
        return bl;
    }

    void turnLaserOFF() {
        Object[] objectArray = new Object[]{new Integer(8)};
        this.parentTabPane.doThreadTransaction(objectArray, "", this.laserOffListener);
    }

    void turnLaserON() {
        Object[] objectArray = new Object[]{new Integer(7)};
        this.parentTabPane.doThreadTransaction(objectArray, "", this.laserOnListener);
    }

    void onDarkLevelTest(ActionEvent actionEvent) {
        this.ctrlDrkLvlTest.setEnabled(false);
        DataTag[] dataTagArray = new DataTag[]{new DataTagDouble("quad_a_up.output"), new DataTagDouble("quad_b_up.output"), new DataTagDouble("quad_c_up.output"), new DataTagDouble("quad_d_up.output")};
        Object[] objectArray = new Object[]{new Integer(5), dataTagArray};
        this.parentTabPane.doThreadTransaction(objectArray, "", this.darkLevelQuadTestListener);
    }

    void onOutputPowerTest(ActionEvent actionEvent) {
        this.ctrlOutputTest.setEnabled(false);
        DataTag[] dataTagArray = new DataTag[]{new DataTagDouble("hene_baseline_int.output"), new DataTagDouble("quad_a_up.output"), new DataTagDouble("quad_b_up.output"), new DataTagDouble("quad_c_up.output"), new DataTagDouble("quad_d_up.output")};
        Object[] objectArray = new Object[]{new Integer(6), dataTagArray};
        this.parentTabPane.doThreadTransaction(objectArray, "", this.backMirrorIntensityListener);
    }

    void onDarklevelCalibration(ActionEvent actionEvent) {
        this.ctrlCalibrate.setEnabled(false);
        Object[] objectArray = new Object[]{new Integer(4)};
        this.parentTabPane.doThreadTransaction(objectArray, "", this.darkLevelCalibrationListener);
    }

    void onLaserOnOff(ActionEvent actionEvent) {
        this.ctrlLaser.setEnabled(false);
        String string = this.ctrlLaser.getText();
        if (string.equalsIgnoreCase(this.res.getString("Turn_Laser_off"))) {
            this.turnLaserOFF();
        } else {
            this.turnLaserON();
        }
    }

    void updateDisplay(MeasureData measureData) {
        Assert.isTrue(measureData != null, this.res.getString("Laser_data_is_null"));
        if (measureData == null) {
            return;
        }
        Object[] objectArray = measureData.getData();
        this.detailedResults.delete(0, this.detailedResults.length());
        this.detailedResults.append(this.res.getString("Laser_results"));
        this.detailedResults.append(" ").append(XTime.getTime()).append(" ( ");
        this.detailedResults.append(XTime.getDate()).append(" ) ");
        this.detailedResults.append(this.newLineString).append(this.newLineString);
        double d = (Double)objectArray[0] * (double)100;
        int n = (int)d;
        this.jProgressBar1.setValue(n);
        this.jLabel3.setText(String.valueOf(String.valueOf(Integer.toString(n))).concat("%"));
        this.detailedResults.append(this.res.getString("PWM")).append(" : ");
        this.detailedResults.append(Integer.toString(n)).append(" %");
        this.detailedResults.append(this.newLineString);
        long l = (Long)objectArray[1];
        this.detailedResults.append(this.res.getString("Status")).append(" : ");
        if (l == (long)2) {
            this.jlblLaserState.setBackground(Color.green);
            this.jlblLaserState.setText(this.res.getString("Laser_stable"));
            this.detailedResults.append(this.res.getString("Laser_is_stable"));
        } else if (l == (long)1) {
            this.jlblLaserState.setBackground(Color.yellow);
            this.jlblLaserState.setText(this.res.getString("Laser_unstable"));
            this.detailedResults.append("*****  ").append(this.res.getString("Laser_is_unstable"));
        } else {
            this.jlblLaserState.setBackground(Color.red);
            this.jlblLaserState.setText(this.res.getString("Laser_off"));
            this.detailedResults.append("*****  ").append(this.res.getString("Laser_is_off"));
        }
        this.detailedResults.append(this.newLineString);
        this.detailedResults.append(this.newLineString);
        int n2 = (Integer)objectArray[2];
        String string = this.parentTabPane.localTemperatureUnits.displayName();
        this.jLabel13.setText(string);
        d = (Double)objectArray[3];
        String string2 = this.parentTabPane.localTemperatureUnits.convertToDisplayStr(d);
        this.detailedResults.append(this.res.getString("Temperature")).append("\t : ");
        if (n2 == 0) {
            this.detailedResults.append(this.res.getString("Stable"));
            this.jTextField7.setText(string2);
            this.jlblTemperature.setIcon(this.autoSettingIcon);
        } else if (n2 == 8) {
            this.detailedResults.append(this.res.getString("Manual"));
            this.jTextField7.setText(string2);
            this.jlblTemperature.setIcon(this.manualSettingIcon);
        } else {
            this.detailedResults.append("*****  ").append(this.res.getString("Error"));
            this.jTextField7.setText(null);
            this.jlblTemperature.setIcon(this.errorSettingIcon);
        }
        this.detailedResults.append(" ( ").append(this.res.getString("Value")).append(" : ");
        this.detailedResults.append(string2).append(" ").append(string);
        this.detailedResults.append(" )");
        this.detailedResults.append(this.newLineString);
        int n3 = (Integer)objectArray[4];
        string = this.parentTabPane.localPressureUnits.displayName();
        this.jLabel17.setText(string);
        d = (Double)objectArray[5];
        string2 = this.parentTabPane.localPressureUnits.convertToDisplayStr(d);
        this.detailedResults.append(this.res.getString("Pressure")).append("\t : ");
        if (n3 == 0) {
            this.detailedResults.append(this.res.getString("Stable"));
            this.jTextField8.setText(string2);
            this.jlblPressure.setIcon(this.autoSettingIcon);
        } else if (n3 == 8) {
            this.detailedResults.append(this.res.getString("Manual"));
            this.jTextField8.setText(string2);
            this.jlblPressure.setIcon(this.manualSettingIcon);
        } else {
            this.detailedResults.append("*****  ").append(this.res.getString("Error"));
            this.jTextField8.setText(null);
            this.jlblPressure.setIcon(this.errorSettingIcon);
        }
        this.detailedResults.append(" ( ").append(this.res.getString("Value")).append(" : ");
        this.detailedResults.append(string2).append(" ").append(string);
        this.detailedResults.append(" )");
        this.detailedResults.append(this.newLineString);
        int n4 = (Integer)objectArray[6];
        d = (Double)objectArray[7] * (double)100;
        d = this.parentTabPane.localTemperatureUnits.convertFrom(d);
        string2 = this.parentTabPane.localTemperatureUnits.convertToDisplayStr(d);
        this.detailedResults.append(this.res.getString("Humidity")).append("\t : ");
        if (n4 == 0) {
            this.detailedResults.append(this.res.getString("Stable"));
            this.jTextField9.setText(string2);
            this.jlblHumidity.setIcon(this.autoSettingIcon);
        } else if (n4 == 8) {
            this.detailedResults.append(this.res.getString("Manual"));
            this.jTextField9.setText(string2);
            this.jlblHumidity.setIcon(this.manualSettingIcon);
        } else {
            this.detailedResults.append("*****  ").append(this.res.getString("Error"));
            this.jTextField9.setText(null);
            this.jlblHumidity.setIcon(this.errorSettingIcon);
        }
        this.detailedResults.append(" ( ").append(this.res.getString("Value")).append(" : ");
        this.detailedResults.append(string2).append(" %");
        this.detailedResults.append(" )");
        this.detailedResults.append(this.newLineString);
        int n5 = (Integer)objectArray[8];
        string = this.parentTabPane.localLinearUnits.displayName();
        this.jLabel23.setText(string);
        double d2 = (Double)objectArray[9] * 1.0E-6;
        d2 = this.parentTabPane.localLinearUnits.convertTo(d2);
        this.posForm.setMinimumFractionDigits(6);
        string2 = this.posForm.format(d2);
        this.detailedResults.append(this.res.getString("Wavelength")).append("\t : ");
        if (n5 == 0) {
            this.detailedResults.append(this.res.getString("Stable"));
            this.jTextField10.setText(string2);
            this.jlblWavelength.setIcon(this.autoSettingIcon);
        } else if (n5 == 8) {
            this.detailedResults.append(this.res.getString("Manual"));
            this.jTextField10.setText(string2);
            this.jlblWavelength.setIcon(this.manualSettingIcon);
        } else {
            this.detailedResults.append("*****  ").append(this.res.getString("Error"));
            this.jTextField10.setText(null);
            this.jlblWavelength.setIcon(this.errorSettingIcon);
        }
        this.detailedResults.append(" ( ").append(this.res.getString("Value")).append(" : ");
        this.detailedResults.append(string2).append(" ").append(string);
        this.detailedResults.append(" )");
        this.detailedResults.append(this.newLineString);
        this.detailedResults.append(this.newLineString);
        this.baseLineIntensity = (Double)objectArray[10];
        this.quadAUpstream = (Double)objectArray[11];
        this.quadBUpstream = (Double)objectArray[12];
        this.quadCUpstream = (Double)objectArray[13];
        this.quadDUpstream = (Double)objectArray[14];
        this.addDarklevelQuadDataResults();
        this.addOutputPowerResults();
        this.showReflectedIntensity(true);
    }

    public void updateTempSensorData(Object[] objectArray) {
        Assert.isTrue(objectArray != null, "Temperature sensor data is null");
        if (objectArray == null) {
            return;
        }
        short s = (Short)objectArray[0];
        if (s == 0) {
            this.jlb_Tmp1.setIcon(this.lightOffIcon);
        }
        if ((s = ((Short)objectArray[1]).shortValue()) == 0) {
            this.jlb_Tmp2.setIcon(this.lightOffIcon);
        }
        if ((s = ((Short)objectArray[2]).shortValue()) == 0) {
            this.jlb_Tmp3.setIcon(this.lightOffIcon);
        }
        if ((s = ((Short)objectArray[3]).shortValue()) == 0) {
            this.jlb_Tmp4.setIcon(this.lightOffIcon);
        }
        if ((s = ((Short)objectArray[4]).shortValue()) == 0) {
            this.jlb_Tmp5.setIcon(this.lightOffIcon);
        }
        if ((s = ((Short)objectArray[5]).shortValue()) == 0) {
            this.jlb_Tmp6.setIcon(this.lightOffIcon);
        }
        if ((s = ((Short)objectArray[6]).shortValue()) == 0) {
            this.jlb_Tmp7.setIcon(this.lightOffIcon);
        }
        if ((s = ((Short)objectArray[7]).shortValue()) == 0) {
            this.jlb_Tmp8.setIcon(this.lightOffIcon);
        }
    }

    String getFileFilters() {
        String string = this.res.getString("Text_files");
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(",".concat(String.valueOf(String.valueOf(this.res.getString("_txt")))))));
        return string;
    }

    String getDataToSaveToFile() {
        return this.detailedResults.toString();
    }

    private void jbInit() throws Exception {
        super.initialize();
        this.component1 = Box.createHorizontalStrut(8);
        this.component3 = Box.createHorizontalStrut(8);
        this.component4 = Box.createHorizontalStrut(8);
        this.component5 = Box.createHorizontalStrut(8);
        this.component6 = Box.createHorizontalStrut(8);
        this.jLabel13.setText(this.parentTabPane.localTemperatureUnits.displayName());
        this.jLabel17.setText(this.parentTabPane.localPressureUnits.displayName());
        this.jLabel23.setText(this.parentTabPane.localLinearUnits.displayName());
        this.border3 = BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), this.res.getString("Position_Monitor")), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.border1 = BorderFactory.createLineBorder(Color.white, 1);
        this.titledBorder2 = new TitledBorder(this.border1, this.res.getString("Tests_Detailed"));
        this.border2 = BorderFactory.createCompoundBorder(this.titledBorder2, BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.border4 = new EtchedBorder(0, Color.white, new Color(134, 134, 134));
        this.titledBorder1 = new TitledBorder(this.border4, this.res.getString("Tests"));
        this.border5 = BorderFactory.createCompoundBorder(this.titledBorder1, BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.titledBorder3 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), this.res.getString("Stability"));
        this.border6 = BorderFactory.createEmptyBorder();
        this.titledBorder4 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), this.res.getString("Wavelength"));
        this.component2 = Box.createHorizontalStrut(8);
        this.setLayout(this.gridBagLayout1);
        this.setMaximumSize(new Dimension(5000, 4000));
        this.setMinimumSize(new Dimension(550, 425));
        this.setPreferredSize(new Dimension(550, 425));
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                DiagnosticsLaserPane.this.this_componentResized(componentEvent);
            }
        });
        this.jPanel1.setLayout(this.gridBagLayout2);
        this.jPanel2.setLayout(this.gridBagLayout8);
        this.jPanel5.setLayout(this.gridLayout2);
        this.gridLayout2.setHgap(5);
        this.gridLayout2.setRows(2);
        this.gridLayout2.setVgap(5);
        this.jPanel6.setLayout(this.gridBagLayout7);
        this.jPanel3.setBorder(this.titledBorder3);
        this.jPanel3.setLayout(this.gridBagLayout3);
        this.jPanel4.setBorder(this.titledBorder4);
        this.jPanel4.setMinimumSize(new Dimension(201, 114));
        this.jPanel4.setPreferredSize(new Dimension(201, 114));
        this.jPanel4.setLayout(this.gridBagLayout6);
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText(this.res.getString("PWM"));
        this.jProgressBar1.setPreferredSize(new Dimension(50, 16));
        this.jLabel3.setMaximumSize(new Dimension(200, 200));
        this.jLabel3.setMinimumSize(new Dimension(35, 17));
        this.jLabel3.setPreferredSize(new Dimension(35, 17));
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel4.setHorizontalAlignment(0);
        this.jLabel4.setText(this.res.getString("Status"));
        this.jlblLaserState.setBackground(Color.gray);
        this.jlblLaserState.setFont(new Font("SansSerif", 1, 12));
        this.jlblLaserState.setEditable(false);
        this.jlblLaserState.setHorizontalAlignment(0);
        this.ctrlLaser.setText(this.res.getString("Turn_Laser_off"));
        this.ctrlLaser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiagnosticsLaserPane.this.onLaserOnOff(actionEvent);
            }
        });
        this.jPanel2.setMinimumSize(new Dimension(215, 131));
        this.jPanel2.setPreferredSize(new Dimension(215, 131));
        this.jPanelDarkLevel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), this.res.getString("Dark_Level")));
        this.jPanelDarkLevel.setLayout(this.gridBagLayout4);
        this.jPanelOutPutPower.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), this.res.getString("Output_Power")));
        this.jPanelOutPutPower.setLayout(this.gridBagLayout5);
        this.jLabel5.setHorizontalAlignment(0);
        this.jLabel5.setText("A + C");
        this.jLabel6.setHorizontalAlignment(0);
        this.jLabel6.setText("A - C");
        this.jLabel7.setHorizontalAlignment(0);
        this.jLabel7.setText("B + D");
        this.jLabel8.setHorizontalAlignment(0);
        this.jLabel8.setText("B - D");
        this.jTextField2.setBackground(Color.lightGray);
        this.jTextField2.setMinimumSize(new Dimension(43, 21));
        this.jTextField2.setPreferredSize(new Dimension(43, 21));
        this.jTextField2.setEditable(false);
        this.jTextField2.setHorizontalAlignment(0);
        this.jTextField3.setBackground(Color.lightGray);
        this.jTextField3.setMinimumSize(new Dimension(43, 21));
        this.jTextField3.setPreferredSize(new Dimension(43, 21));
        this.jTextField3.setEditable(false);
        this.jTextField3.setHorizontalAlignment(0);
        this.jTextField4.setBackground(Color.lightGray);
        this.jTextField4.setMinimumSize(new Dimension(43, 21));
        this.jTextField4.setPreferredSize(new Dimension(43, 21));
        this.jTextField4.setEditable(false);
        this.jTextField4.setHorizontalAlignment(0);
        this.jTextField5.setBackground(Color.lightGray);
        this.jTextField5.setMinimumSize(new Dimension(43, 21));
        this.jTextField5.setPreferredSize(new Dimension(43, 21));
        this.jTextField5.setEditable(false);
        this.jTextField5.setHorizontalAlignment(0);
        this.ctrlCalibrate.setMaximumSize(new Dimension(610, 250));
        this.ctrlCalibrate.setMinimumSize(new Dimension(61, 25));
        this.ctrlCalibrate.setPreferredSize(new Dimension(61, 25));
        this.ctrlCalibrate.setMargin(new Insets(2, 2, 2, 2));
        this.ctrlCalibrate.setMnemonic('L');
        this.ctrlCalibrate.setText(this.res.getString("Calibrate"));
        this.ctrlCalibrate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiagnosticsLaserPane.this.onDarklevelCalibration(actionEvent);
            }
        });
        this.ctrlDrkLvlTest.setMaximumSize(new Dimension(610, 250));
        this.ctrlDrkLvlTest.setMinimumSize(new Dimension(65, 25));
        this.ctrlDrkLvlTest.setPreferredSize(new Dimension(65, 25));
        this.ctrlDrkLvlTest.setMargin(new Insets(2, 2, 2, 2));
        this.ctrlDrkLvlTest.setMnemonic('T');
        this.ctrlDrkLvlTest.setText(this.res.getString("Start_Test"));
        this.ctrlDrkLvlTest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiagnosticsLaserPane.this.onDarkLevelTest(actionEvent);
            }
        });
        this.ctrlOutputTest.setMargin(new Insets(2, 2, 2, 2));
        this.ctrlOutputTest.setMnemonic('E');
        this.ctrlOutputTest.setText(this.res.getString("Start_Test"));
        this.ctrlOutputTest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiagnosticsLaserPane.this.onOutputPowerTest(actionEvent);
            }
        });
        this.jTxtOutPutPower.setBackground(Color.lightGray);
        this.jTxtOutPutPower.setFont(new Font("SansSerif", 0, 14));
        this.jTxtOutPutPower.setMinimumSize(new Dimension(43, 21));
        this.jTxtOutPutPower.setPreferredSize(new Dimension(43, 21));
        this.jTxtOutPutPower.setEditable(false);
        this.jTxtOutPutPower.setHorizontalAlignment(0);
        this.jLabel9.setText(this.res.getString("Power"));
        this.jLabel10.setText("%");
        this.jLabel11.setMaximumSize(new Dimension(51, 17));
        this.jLabel11.setMinimumSize(new Dimension(51, 17));
        this.jLabel11.setPreferredSize(new Dimension(51, 17));
        this.jLabel11.setText(this.res.getString("Temperature"));
        this.jlblTemperature.setMaximumSize(new Dimension(15, 17));
        this.jlblTemperature.setMinimumSize(new Dimension(15, 17));
        this.jlblTemperature.setPreferredSize(new Dimension(15, 17));
        this.jlblTemperature.setHorizontalAlignment(0);
        this.jTextField7.setBackground(Color.lightGray);
        this.jTextField7.setMaximumSize(new Dimension(750, 250));
        this.jTextField7.setMinimumSize(new Dimension(75, 25));
        this.jTextField7.setPreferredSize(new Dimension(75, 25));
        this.jTextField7.setEditable(false);
        this.jTextField7.setHorizontalAlignment(4);
        this.jLabel13.setMaximumSize(new Dimension(20, 17));
        this.jLabel13.setMinimumSize(new Dimension(20, 17));
        this.jLabel13.setPreferredSize(new Dimension(20, 17));
        this.jLabel13.setHorizontalAlignment(0);
        this.jLabel15.setText(this.res.getString("Pressure"));
        this.jlblPressure.setMaximumSize(new Dimension(15, 17));
        this.jlblPressure.setMinimumSize(new Dimension(15, 17));
        this.jlblPressure.setPreferredSize(new Dimension(15, 17));
        this.jlblPressure.setHorizontalAlignment(0);
        this.jTextField8.setBackground(Color.lightGray);
        this.jTextField8.setMaximumSize(new Dimension(750, 250));
        this.jTextField8.setMinimumSize(new Dimension(75, 25));
        this.jTextField8.setPreferredSize(new Dimension(75, 25));
        this.jTextField8.setEditable(false);
        this.jTextField8.setHorizontalAlignment(4);
        this.jLabel17.setMaximumSize(new Dimension(20, 17));
        this.jLabel17.setMinimumSize(new Dimension(20, 17));
        this.jLabel17.setPreferredSize(new Dimension(20, 17));
        this.jLabel17.setHorizontalAlignment(0);
        this.jLabel18.setText(this.res.getString("Humidity"));
        this.jlblHumidity.setMaximumSize(new Dimension(15, 17));
        this.jlblHumidity.setMinimumSize(new Dimension(15, 17));
        this.jlblHumidity.setPreferredSize(new Dimension(15, 17));
        this.jlblHumidity.setHorizontalAlignment(0);
        this.jTextField9.setBackground(Color.lightGray);
        this.jTextField9.setMaximumSize(new Dimension(750, 250));
        this.jTextField9.setMinimumSize(new Dimension(75, 25));
        this.jTextField9.setPreferredSize(new Dimension(75, 25));
        this.jTextField9.setEditable(false);
        this.jTextField9.setHorizontalAlignment(4);
        this.jLabel20.setMaximumSize(new Dimension(20, 17));
        this.jLabel20.setMinimumSize(new Dimension(20, 17));
        this.jLabel20.setPreferredSize(new Dimension(20, 17));
        this.jLabel20.setHorizontalAlignment(0);
        this.jLabel20.setText("%");
        this.jLabel21.setText(this.res.getString("Wavelength"));
        this.jlblWavelength.setMaximumSize(new Dimension(15, 17));
        this.jlblWavelength.setMinimumSize(new Dimension(15, 17));
        this.jlblWavelength.setPreferredSize(new Dimension(15, 17));
        this.jlblWavelength.setHorizontalAlignment(0);
        this.jTextField10.setBackground(Color.lightGray);
        this.jTextField10.setMaximumSize(new Dimension(750, 250));
        this.jTextField10.setMinimumSize(new Dimension(75, 25));
        this.jTextField10.setPreferredSize(new Dimension(75, 25));
        this.jTextField10.setEditable(false);
        this.jTextField10.setHorizontalAlignment(4);
        this.jLabel23.setMaximumSize(new Dimension(40, 17));
        this.jLabel23.setMinimumSize(new Dimension(40, 17));
        this.jLabel23.setPreferredSize(new Dimension(40, 17));
        this.jLabel23.setHorizontalAlignment(0);
        this.jPanel7.setLayout(this.gridLayout4);
        this.gridLayout4.setColumns(8);
        this.gridLayout4.setHgap(1);
        this.gridLayout4.setRows(2);
        this.gridLayout4.setVgap(1);
        this.jlb_Tmp1.setHorizontalAlignment(0);
        this.jlb_Tmp1.setIcon(this.lightOnIcon);
        this.jlb_Tmp2.setIcon(this.lightOnIcon);
        this.jlb_Tmp3.setIcon(this.lightOnIcon);
        this.jlb_Tmp4.setIcon(this.lightOnIcon);
        this.jlb_Tmp5.setIcon(this.lightOnIcon);
        this.jlb_Tmp6.setIcon(this.lightOnIcon);
        this.jlb_Tmp7.setIcon(this.lightOnIcon);
        this.jlb_Tmp8.setIcon(this.lightOnIcon);
        this.jlblTemperature.setIcon(this.autoSettingIcon);
        this.jlblPressure.setIcon(this.autoSettingIcon);
        this.jlblHumidity.setIcon(this.autoSettingIcon);
        this.jlblWavelength.setIcon(this.autoSettingIcon);
        this.jLabel24.setHorizontalAlignment(0);
        this.jLabel24.setText("1");
        this.jlb_Tmp5.setHorizontalAlignment(0);
        this.jLabel26.setHorizontalAlignment(0);
        this.jLabel26.setText("2");
        this.jlb_Tmp6.setHorizontalAlignment(0);
        this.jLabel28.setHorizontalAlignment(0);
        this.jLabel28.setText("3");
        this.jlb_Tmp7.setHorizontalAlignment(0);
        this.jLabel30.setHorizontalAlignment(0);
        this.jLabel30.setText("4");
        this.jlb_Tmp8.setHorizontalAlignment(0);
        this.jLabel32.setHorizontalAlignment(0);
        this.jLabel32.setText("5");
        this.jlb_Tmp4.setHorizontalAlignment(0);
        this.jLabel34.setHorizontalAlignment(0);
        this.jLabel34.setText("6");
        this.jlb_Tmp3.setHorizontalAlignment(0);
        this.jLabel36.setHorizontalAlignment(0);
        this.jLabel36.setText("7");
        this.jlb_Tmp2.setHorizontalAlignment(0);
        this.jLabel38.setHorizontalAlignment(0);
        this.jLabel38.setText("8");
        this.jPanel8.setLayout(this.gridLayout3);
        this.jlblOuputPower.setBackground(Color.black);
        this.jlblOuputPower.setFont(new Font("Dialog", 1, 100));
        this.jlblOuputPower.setForeground(Color.green);
        this.jlblOuputPower.setOpaque(true);
        this.jlblOuputPower.setHorizontalAlignment(0);
        this.ctrlHome.setMaximumSize(new Dimension(65, 25));
        this.ctrlHome.setMinimumSize(new Dimension(35, 25));
        this.ctrlHome.setPreferredSize(new Dimension(35, 25));
        this.ctrlHome.setMargin(new Insets(2, 2, 2, 2));
        this.ctrlHome.setMnemonic('H');
        this.ctrlHome.setText(this.res.getString("Home"));
        this.ctrlHome.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiagnosticsLaserPane.this.onHome(actionEvent);
            }
        });
        this.jPanel9.setLayout(this.gridBagLayout9);
        this.ctrlSaveAs.setMargin(new Insets(2, 2, 2, 2));
        this.ctrlSaveAs.setMnemonic('A');
        this.ctrlSaveAs.setPreferredSize(new Dimension(45, 25));
        this.ctrlSaveAs.setMinimumSize(new Dimension(45, 25));
        this.ctrlSaveAs.setMaximumSize(new Dimension(65, 25));
        this.ctrlSave.setMargin(new Insets(2, 2, 2, 2));
        this.ctrlSave.setMnemonic('S');
        this.ctrlSave.setPreferredSize(new Dimension(35, 25));
        this.ctrlSave.setMinimumSize(new Dimension(35, 25));
        this.ctrlSave.setMaximumSize(new Dimension(65, 25));
        this.add((Component)this.jPanel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jPanel3, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel3.add((Component)this.jLabel2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel3.add((Component)this.jProgressBar1, new GridBagConstraints(1, 0, 2, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 11));
        this.jPanel3.add((Component)this.jLabel3, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel3.add((Component)this.jLabel4, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 8, 0));
        this.jPanel3.add((Component)this.jlblLaserState, new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 11));
        this.jPanel3.add((Component)this.ctrlLaser, new GridBagConstraints(1, 2, 2, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jPanel4, new GridBagConstraints(0, 1, 1, 2, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel4.add((Component)this.jLabel11, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jlblTemperature, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jTextField7, new GridBagConstraints(2, 0, 1, 1, 1.5, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jLabel13, new GridBagConstraints(3, 0, 1, 1, 0.25, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jLabel15, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jlblPressure, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jTextField8, new GridBagConstraints(2, 2, 1, 1, 1.5, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jLabel17, new GridBagConstraints(3, 2, 1, 1, 0.25, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jLabel18, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jlblHumidity, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jTextField9, new GridBagConstraints(2, 3, 1, 1, 1.5, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jLabel20, new GridBagConstraints(3, 3, 1, 1, 0.25, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jLabel21, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jlblWavelength, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jTextField10, new GridBagConstraints(2, 4, 1, 1, 1.5, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jLabel23, new GridBagConstraints(3, 4, 1, 1, 0.25, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel4.add((Component)this.jPanel7, new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel7.add((Component)this.jlb_Tmp1, null);
        this.jPanel7.add((Component)this.jlb_Tmp2, null);
        this.jPanel7.add((Component)this.jlb_Tmp3, null);
        this.jPanel7.add((Component)this.jlb_Tmp4, null);
        this.jPanel7.add((Component)this.jlb_Tmp5, null);
        this.jPanel7.add((Component)this.jlb_Tmp6, null);
        this.jPanel7.add((Component)this.jlb_Tmp7, null);
        this.jPanel7.add((Component)this.jlb_Tmp8, null);
        this.jPanel7.add((Component)this.jLabel24, null);
        this.jPanel7.add((Component)this.jLabel26, null);
        this.jPanel7.add((Component)this.jLabel28, null);
        this.jPanel7.add((Component)this.jLabel30, null);
        this.jPanel7.add((Component)this.jLabel32, null);
        this.jPanel7.add((Component)this.jLabel34, null);
        this.jPanel7.add((Component)this.jLabel36, null);
        this.jPanel7.add((Component)this.jLabel38, null);
        this.jPanel1.add((Component)this.jblDummy4, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jblDummy3, new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jPanel2, new GridBagConstraints(1, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jPanel5, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.35, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel5.add((Component)this.jPanelDarkLevel, null);
        this.jPanelDarkLevel.add((Component)this.jLabel5, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanelDarkLevel.add((Component)this.jLabel6, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanelDarkLevel.add((Component)this.jLabel7, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanelDarkLevel.add((Component)this.jTextField2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanelDarkLevel.add((Component)this.jTextField3, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanelDarkLevel.add((Component)this.jTextField4, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanelDarkLevel.add((Component)this.jLabel8, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanelDarkLevel.add((Component)this.jTextField5, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanelDarkLevel.add((Component)this.ctrlCalibrate, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 5, 2, 2), 0, 0));
        this.jPanelDarkLevel.add((Component)this.ctrlDrkLvlTest, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 5, 1, 2), 0, 0));
        this.jPanel5.add((Component)this.jPanelOutPutPower, null);
        this.jPanelOutPutPower.add((Component)this.ctrlOutputTest, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 10, 2, 2), 0, 1));
        this.jPanelOutPutPower.add((Component)this.jTxtOutPutPower, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelOutPutPower.add((Component)this.jLabel9, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 7, 0, 5), 0, 0));
        this.jPanelOutPutPower.add((Component)this.jLabel10, new GridBagConstraints(4, 0, 3, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.jPanelOutPutPower.add(this.component2, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jPanel6, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel6.add((Component)this.jPanel8, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.jPanel8.add((Component)this.jlblOuputPower, null);
        this.jPanel6.add((Component)this.jPanel9, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 2, 2, 2), 0, 0));
        this.jPanel9.add(this.component1, new GridBagConstraints(0, 0, 1, 1, 0.25, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel9.add((Component)this.ctrlHome, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel9.add(this.component3, new GridBagConstraints(2, 0, 1, 1, 0.25, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel9.add((Component)this.ctrlSave, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel9.add(this.component4, new GridBagConstraints(4, 0, 1, 1, 0.25, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel9.add((Component)this.ctrlSaveAs, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.jPanel9.add(this.component6, new GridBagConstraints(6, 0, 1, 1, 0.25, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jblDummy2, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jblDummy1, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        IconTabListCellRenderer iconTabListCellRenderer = new IconTabListCellRenderer();
    }

    static {
        READ_DATA = 0;
        HOME = 1;
        ENABLE_DIAGNOSTICS = 2;
        START_FACTORY_BKND_MEASUREMENTS = 3;
        STOP_FACTORY_BKND_MEASUREMENTS = 4;
        DO_DARK_LEVEL_CALIBRATION = 5;
        GET_DARK_LEVEL_QUAD_DATA = 6;
        GET_BACKMIRROR_INTENSITY_POWER = 7;
        LASER_ON_OFF = 8;
    }

    private class DarkLevelCalibrationListener
    implements ThreadListener,
    Runnable {
        private DarkLevelCalibrationListener() {
        }

        public void commandComplete() {
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            Object[] objectArray = DiagnosticsLaserPane.this.diagnosticsThread.peekResponse();
            if (objectArray[0] == null) {
                P.rintln("Performed Darklevel calibration");
            }
        }
    }

    private class BackMirrorIntensityListener
    implements ThreadListener,
    Runnable {
        private BackMirrorIntensityListener() {
        }

        public void commandComplete() {
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            Object[] objectArray = DiagnosticsLaserPane.this.diagnosticsThread.peekResponse();
            if (objectArray != null && objectArray[0] == null) {
                Object[] objectArray2 = (Object[])objectArray[2];
                if (objectArray2 == null) {
                    return;
                }
                DiagnosticsLaserPane.this.baseLineIntensity = (Double)objectArray2[0];
                DiagnosticsLaserPane.this.quadAUpstream = (Double)objectArray2[1];
                DiagnosticsLaserPane.this.quadBUpstream = (Double)objectArray2[2];
                DiagnosticsLaserPane.this.quadCUpstream = (Double)objectArray2[3];
                DiagnosticsLaserPane.this.quadDUpstream = (Double)objectArray2[4];
                DiagnosticsLaserPane.this.showReflectedIntensity(false);
            }
        }
    }

    private class DarkLevelQuadTestListener
    implements ThreadListener,
    Runnable {
        private DarkLevelQuadTestListener() {
        }

        public void commandComplete() {
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            Object[] objectArray = DiagnosticsLaserPane.this.diagnosticsThread.peekResponse();
            if (objectArray != null && objectArray[0] == null) {
                Object[] objectArray2 = (Object[])objectArray[2];
                if (objectArray2 == null) {
                    return;
                }
                DiagnosticsLaserPane.this.quadAUpstream = (Double)objectArray2[0];
                DiagnosticsLaserPane.this.quadBUpstream = (Double)objectArray2[1];
                DiagnosticsLaserPane.this.quadCUpstream = (Double)objectArray2[2];
                DiagnosticsLaserPane.this.quadDUpstream = (Double)objectArray2[3];
                DiagnosticsLaserPane.this.showDarklevelQuadData();
            }
        }
    }

    private class LaserOnListener
    implements ThreadListener,
    Runnable {
        private LaserOnListener() {
        }

        public void commandComplete() {
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            Object[] objectArray = DiagnosticsLaserPane.this.diagnosticsThread.peekResponse();
            if (objectArray[0] == null) {
                DiagnosticsLaserPane.this.ctrlLaser.setEnabled(true);
                DiagnosticsLaserPane.this.ctrlLaser.setText(DiagnosticsLaserPane.this.res.getString("Turn_Laser_off"));
            }
        }
    }

    private class LaserOffListener
    implements ThreadListener,
    Runnable {
        private LaserOffListener() {
        }

        public void commandComplete() {
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            Object[] objectArray = DiagnosticsLaserPane.this.diagnosticsThread.peekResponse();
            if (objectArray[0] == null) {
                DiagnosticsLaserPane.this.ctrlLaser.setEnabled(true);
                DiagnosticsLaserPane.this.ctrlLaser.setText(DiagnosticsLaserPane.this.res.getString("Turn_Laser_on"));
            }
            DiagnosticsLaserPane.this.autoTurnLaserOn();
        }
    }
}

