/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.apps4xxx.diagnostics;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import smx.tracker.DataTag;
import smx.tracker.DataTagDouble;
import smx.tracker.DataTagUnsigned16;
import smx.tracker.MeasureData;
import smx.tracker.apps4xxx.diagnostics.Diagnostics;
import smx.tracker.apps4xxx.diagnostics.DiagnosticsPanel;
import smx.tracker.apps4xxx.diagnostics.DiagnosticsTableColumnData;
import smx.tracker.apps4xxx.diagnostics.DiagnosticsTableDisplay;
import smx.tracker.apps4xxx.utility.ThreadListener;
import smx.tracker.apps4xxx.utility.XMath;
import smx.tracker.apps4xxx.utility.tools.XTime;
import smx.tracker.apps4xxx.utility.tools.XTool;
import smx.tracker.apps4xxx.utility.tools.debug.P;

public class DiagnosticsBacksightsPane
extends DiagnosticsPanel {
    public final DiagnosticsTableColumnData[] columns;
    String resultHeading;
    double azimuthAngle;
    double zenithAngle;
    double radialDistance;
    double averageSMRIntensity;
    double temperature;
    double pressure;
    double humidity;
    int temperatureStatus;
    int pressureStatus;
    int humidityStatus;
    double measurementTime;
    int overallStatus;
    int distanceStatus;
    double[] initialSightSpherData;
    double[] backSightSpherData;
    private DecimalFormat posForm;
    private DecimalFormat resultsFormat;
    public static final int IFM_MODE = 0;
    public static final int ADM_MODE = 1;
    private int testMode;
    private int MAX_UNIT_NAME_LENGTH;
    StartStopTestCompleteListener startStopTestListener;
    GridLayout gridLayout2;
    ImageIcon ifmImage;
    ImageIcon admImage;
    JPanel jPanel1;
    JPanel jPanel2;
    Border border1;
    TitledBorder titledBorder2;
    Border border2;
    Border border3;
    GridLayout gridLayout1;
    JPanel jPanel3;
    JPanel jPanel4;
    GridBagLayout gridBagLayout1;
    GridBagLayout gridBagLayout2;
    JTextField ctrlAz;
    JTextField ctrlZe;
    JLabel jLabel1;
    JLabel jLabel2;
    JLabel jLabel3;
    JLabel jLabel4;
    JLabel jLabel1Units;
    JLabel jLabel2Units;
    JLabel jLabel3Units;
    JLabel jLabel4Units;
    JTextField ctrlInter;
    JTextField ctrlTotal;
    GridBagLayout gridBagLayout3;
    Border border4;
    TitledBorder titledBorder1;
    Border border5;
    JPanel jPanel6;
    JPanel jPanel5;
    GridLayout gridLayout3;
    JButton ctrlStartStop;
    JRadioButton ctrlIFMMode;
    JRadioButton ctrlADMMode;
    ButtonGroup testButtonGroup;

    public DiagnosticsBacksightsPane(String string) {
        super(string);
        this.columns = new DiagnosticsTableColumnData[]{this.referencePositionColumn, this.dateColumn, this.timeColumn, this.dXColumn, this.dYColumn, this.dZColumn, new DiagnosticsTableColumnData(this.res.getString("3D"), 75, 4), this.dRColumn, this.dTColumn, this.dPColumn};
        this.initialSightSpherData = new double[3];
        this.backSightSpherData = new double[3];
        this.testMode = 0;
        this.MAX_UNIT_NAME_LENGTH = 4;
        this.gridLayout2 = new GridLayout();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.gridLayout1 = new GridLayout();
        this.jPanel3 = new JPanel();
        this.jPanel4 = new JPanel();
        this.gridBagLayout1 = new GridBagLayout();
        this.gridBagLayout2 = new GridBagLayout();
        this.ctrlAz = new JTextField();
        this.ctrlZe = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel1Units = new JLabel();
        this.jLabel2Units = new JLabel();
        this.jLabel3Units = new JLabel();
        this.jLabel4Units = new JLabel();
        this.ctrlInter = new JTextField();
        this.ctrlTotal = new JTextField();
        this.gridBagLayout3 = new GridBagLayout();
        this.jPanel6 = new JPanel();
        this.jPanel5 = new JPanel();
        this.gridLayout3 = new GridLayout();
        this.ctrlStartStop = new JButton();
        this.ctrlIFMMode = new JRadioButton();
        this.ctrlADMMode = new JRadioButton();
        this.testButtonGroup = new ButtonGroup();
        this.parentTabPane = Diagnostics.parentApp;
        this.diagnosticsThread = Diagnostics.parentAppCommandThread;
        this.tagsToMeasure = new DataTag[6];
        int n = 0;
        this.tagsToMeasure[n++] = new DataTagDouble("az_corrected.output");
        this.tagsToMeasure[n++] = new DataTagUnsigned16("az_corrected.status");
        this.tagsToMeasure[n++] = new DataTagDouble("el_corrected.output");
        this.tagsToMeasure[n++] = new DataTagUnsigned16("el_corrected.status");
        this.tagsToMeasure[n++] = new DataTagDouble("dist_corrected.output");
        this.tagsToMeasure[n++] = new DataTagUnsigned16("dist_corrected.status");
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        super.initialize();
        Image image = this.parentTabPane.loadImage("diagnosticsifm.gif", Diagnostics.parentApp.packagePath);
        if (image == null) {
            System.err.println("Couldn't load image diagnosticsifm");
        } else {
            this.ifmImage = new ImageIcon(image);
        }
        image = this.parentTabPane.loadImage("diagnosticsadm.gif", Diagnostics.parentApp.packagePath);
        if (image == null) {
            System.err.println("Couldn't load image diagnosticsadm");
        } else {
            this.admImage = new ImageIcon(image);
        }
        this.resultsPanel = new DiagnosticsTableDisplay(null, this.columns, null);
        this.border3 = BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), this.res.getString("Position_Monitor")), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.border1 = BorderFactory.createLineBorder(Color.white, 1);
        this.titledBorder2 = new TitledBorder(this.border1, this.res.getString("Tests_Detailed"));
        this.border2 = BorderFactory.createCompoundBorder(this.titledBorder2, BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.border4 = new EtchedBorder(0, Color.white, new Color(134, 134, 134));
        this.titledBorder1 = new TitledBorder(this.border4, this.res.getString("Tests"));
        this.border5 = BorderFactory.createCompoundBorder(this.titledBorder1, BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setLayout(this.gridLayout2);
        this.jPanel1.setLayout(this.gridLayout1);
        this.jPanel1.setBorder(this.border3);
        this.jPanel1.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.jPanel1.setMinimumSize(new Dimension(200, 125));
        this.jPanel1.setPreferredSize(new Dimension(50, 50));
        this.jPanel2.setBorder(this.border2);
        this.jPanel2.setMinimumSize(new Dimension(200, 125));
        this.jPanel2.setPreferredSize(new Dimension(50, 50));
        this.jPanel2.setLayout(this.gridBagLayout3);
        this.gridLayout1.setColumns(2);
        this.gridLayout1.setHgap(25);
        this.jPanel3.setLayout(this.gridBagLayout1);
        this.jPanel4.setLayout(this.gridBagLayout2);
        this.ctrlAz.setBackground(Color.black);
        this.ctrlAz.setFont(new Font("SansSerif", 1, 30));
        this.ctrlAz.setForeground(Color.white);
        this.ctrlAz.setEditable(false);
        this.ctrlAz.setHorizontalAlignment(4);
        this.ctrlZe.setBackground(Color.black);
        this.ctrlZe.setFont(new Font("SansSerif", 1, 30));
        this.ctrlZe.setForeground(Color.white);
        this.ctrlZe.setEditable(false);
        this.ctrlZe.setHorizontalAlignment(4);
        this.jLabel1.setFont(new Font("Dialog", 1, 25));
        this.jLabel1.setText(this.res.getString("Az"));
        this.jLabel2.setFont(new Font("Dialog", 1, 25));
        this.jLabel2.setText(this.res.getString("Ze"));
        this.jLabel3.setFont(new Font("SansSerif", 1, 25));
        this.jLabel3.setText(this.res.getString("Ra"));
        this.ctrlInter.setBackground(Color.black);
        this.ctrlInter.setFont(new Font("SansSerif", 1, 30));
        this.ctrlInter.setForeground(Color.white);
        this.ctrlInter.setEditable(false);
        this.ctrlInter.setHorizontalAlignment(4);
        this.jLabel4.setFont(new Font("SansSerif", 1, 25));
        this.jLabel4.setText(this.res.getString("3D"));
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.parentTabPane.localAngularUnits.displayName());
        StringBuffer stringBuffer2 = new StringBuffer(100);
        stringBuffer2.append(this.parentTabPane.localLinearUnits.displayName());
        StringBuffer stringBuffer3 = new StringBuffer(100);
        if (stringBuffer.length() > this.MAX_UNIT_NAME_LENGTH) {
            stringBuffer3.append("(").append(stringBuffer.substring(0, this.MAX_UNIT_NAME_LENGTH)).append(")");
        } else {
            stringBuffer3.append("(").append(stringBuffer).append(")");
        }
        StringBuffer stringBuffer4 = new StringBuffer(100);
        if (stringBuffer2.length() > this.MAX_UNIT_NAME_LENGTH) {
            stringBuffer4.append("(").append(stringBuffer2.substring(0, this.MAX_UNIT_NAME_LENGTH)).append(")");
        } else {
            stringBuffer4.append("(").append(stringBuffer2).append(")");
        }
        this.jLabel1Units.setHorizontalTextPosition(0);
        this.jLabel1Units.setVerticalTextPosition(1);
        this.jLabel2Units.setHorizontalTextPosition(0);
        this.jLabel2Units.setVerticalTextPosition(1);
        this.jLabel3Units.setHorizontalTextPosition(0);
        this.jLabel3Units.setVerticalTextPosition(1);
        this.jLabel4Units.setHorizontalTextPosition(0);
        this.jLabel4Units.setVerticalTextPosition(1);
        this.jLabel1Units.setText(stringBuffer3.toString());
        this.jLabel2Units.setText(stringBuffer3.toString());
        this.jLabel3Units.setText(stringBuffer4.toString());
        this.jLabel4Units.setText(stringBuffer4.toString());
        this.ctrlTotal.setBackground(Color.black);
        this.ctrlTotal.setFont(new Font("SansSerif", 1, 30));
        this.ctrlTotal.setForeground(Color.white);
        this.ctrlTotal.setEditable(false);
        this.ctrlTotal.setHorizontalAlignment(4);
        this.setMaximumSize(new Dimension(5000, 4000));
        this.setMinimumSize(new Dimension(550, 425));
        this.setPreferredSize(new Dimension(550, 425));
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                DiagnosticsBacksightsPane.this.onComponentResized(componentEvent);
            }
        });
        this.jPanel5.setBorder(this.border5);
        this.jPanel5.setMaximumSize(new Dimension(85, 47));
        this.jPanel5.setMinimumSize(new Dimension(95, 47));
        this.jPanel5.setPreferredSize(new Dimension(95, 47));
        this.jPanel5.setLayout(this.gridLayout2);
        this.ctrlIFMMode.setIcon(this.ifmImage);
        this.ctrlIFMMode.setText(this.res.getString("IFM"));
        this.ctrlIFMMode.setPreferredSize(new Dimension(100, 47));
        this.ctrlIFMMode.setMaximumSize(new Dimension(1000, 470));
        this.ctrlIFMMode.setMinimumSize(new Dimension(100, 47));
        this.ctrlIFMMode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiagnosticsBacksightsPane.this.onIFMModeSelected(actionEvent);
            }
        });
        this.ctrlADMMode.setIcon(this.admImage);
        this.ctrlADMMode.setText(this.res.getString("ADM_set_ifm"));
        this.ctrlADMMode.setPreferredSize(new Dimension(100, 47));
        this.ctrlADMMode.setMaximumSize(new Dimension(1000, 470));
        this.ctrlADMMode.setMinimumSize(new Dimension(100, 47));
        this.ctrlADMMode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiagnosticsBacksightsPane.this.onADMModeSelected(actionEvent);
            }
        });
        this.testButtonGroup.add(this.ctrlIFMMode);
        this.testButtonGroup.add(this.ctrlADMMode);
        if (this.parentTabPane.admEnabled) {
            this.ctrlADMMode.setSelected(true);
            this.onADMModeSelected(null);
        } else {
            this.ctrlIFMMode.setSelected(true);
            this.onIFMModeSelected(null);
        }
        this.enableTestModeButtons(true);
        this.jPanel6.setLayout(this.gridLayout3);
        this.gridLayout3.setColumns(1);
        this.gridLayout3.setRows(5);
        this.gridLayout3.setVgap(1);
        this.ctrlStartStop.setMnemonic('T');
        this.ctrlStartStop.setText(this.res.getString("Start_Test"));
        this.ctrlStartStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiagnosticsBacksightsPane.this.ctrlStartStop_actionPerformed(actionEvent);
            }
        });
        this.ctrlHome.setMnemonic('H');
        this.ctrlHome.setText(this.res.getString("Home"));
        this.ctrlHome.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiagnosticsBacksightsPane.this.onHome(actionEvent);
            }
        });
        this.gridLayout2.setRows(2);
        this.add((Component)this.jPanel1, null);
        this.jPanel1.add((Component)this.jPanel3, null);
        this.jPanel3.add((Component)this.ctrlAz, new GridBagConstraints(1, 0, 1, 2, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 15, 15));
        this.jPanel3.add((Component)this.ctrlZe, new GridBagConstraints(1, 2, 1, 2, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 15, 15));
        this.jPanel3.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 3), 5, 5));
        this.jPanel3.add((Component)this.jLabel1Units, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 2, 2, 3), 0, 0));
        this.jPanel3.add((Component)this.jLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 3), 5, 5));
        this.jPanel3.add((Component)this.jLabel2Units, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 2, 2, 3), 0, 0));
        this.jPanel1.add((Component)this.jPanel4, null);
        this.jPanel4.add((Component)this.ctrlInter, new GridBagConstraints(1, 0, 1, 2, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 15, 15));
        this.jPanel4.add((Component)this.ctrlTotal, new GridBagConstraints(1, 2, 1, 2, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 15, 15));
        this.jPanel4.add((Component)this.jLabel3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 3), 5, 5));
        this.jPanel4.add((Component)this.jLabel3Units, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 2, 2, 3), 0, 0));
        this.jPanel4.add((Component)this.jLabel4, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 3), 5, 5));
        this.jPanel4.add((Component)this.jLabel4Units, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 2, 2, 3), 0, 0));
        this.add((Component)this.jPanel2, null);
        this.jPanel2.add((Component)this.jPanel5, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(2, 2, 2, 5), 0, 0));
        this.jPanel5.add((Component)this.ctrlIFMMode, null);
        this.jPanel5.add((Component)this.ctrlADMMode, null);
        this.jPanel2.add((Component)this.resultsPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 200, 100));
        this.jPanel2.add((Component)this.jPanel6, new GridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(2, 5, 2, 2), 0, 25));
        this.jPanel6.add((Component)this.ctrlStartStop, null);
        this.jPanel6.add((Component)this.ctrlHome, null);
        this.jPanel6.add((Component)this.ctrlClear, null);
        this.jPanel6.add((Component)this.ctrlSave, null);
        this.jPanel6.add((Component)this.ctrlSaveAs, null);
    }

    private void onComponentResized(ComponentEvent componentEvent) {
        String string = this.ctrlAz.getText();
        String string2 = this.ctrlZe.getText();
        String string3 = this.ctrlInter.getText();
        Font font = this.ctrlInter.getFont();
        FontMetrics fontMetrics = ((Component)this.ctrlInter).getFontMetrics(font);
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.stringWidth(string2);
        int n3 = fontMetrics.stringWidth(string3);
        int n4 = Math.max(n, n2);
        if ((n4 = Math.max(n4, n3)) == 0) {
            return;
        }
        Font font2 = null;
        font2 = n4 == n ? XTool.calculateMaxFontThatFits(this.ctrlAz, this.oldDimension) : (n4 == n2 ? XTool.calculateMaxFontThatFits(this.ctrlZe, this.oldDimension) : XTool.calculateMaxFontThatFits(this.ctrlInter, this.oldDimension));
        if (font2 == null) {
            return;
        }
        this.ctrlAz.setFont(font2);
        this.ctrlZe.setFont(font2);
        this.ctrlInter.setFont(font2);
        this.ctrlTotal.setFont(font2);
    }

    void SetDeviationResults(double[] dArray) {
        dArray[4] = dArray[4] >= 0.0 ? dArray[4] - Math.PI : dArray[4] + Math.PI;
        dArray[5] = dArray[5] * (double)-1;
        double[] dArray2 = new double[]{dArray[0], dArray[1], dArray[2]};
        double[] dArray3 = new double[]{dArray[3], dArray[4], dArray[5]};
        double[] dArray4 = new double[]{dArray[0], dArray[1], dArray[2]};
        double[] dArray5 = new double[]{dArray[3], dArray[4], dArray[5]};
        XMath.pointSphereToCart(dArray2);
        XMath.pointSphereToCart(dArray3);
        String string = this.parentTabPane.localLinearUnits.convertToDisplayStr(dArray2[0]);
        String string2 = this.parentTabPane.localLinearUnits.convertToDisplayStr(dArray2[1]);
        String string3 = this.parentTabPane.localLinearUnits.convertToDisplayStr(dArray2[2]);
        dArray2[0] = this.parentTabPane.localLinearUnits.convertTo(dArray2[0]);
        dArray2[1] = this.parentTabPane.localLinearUnits.convertTo(dArray2[1]);
        dArray2[2] = this.parentTabPane.localLinearUnits.convertTo(dArray2[2]);
        dArray3[0] = this.parentTabPane.localLinearUnits.convertTo(dArray3[0]);
        dArray3[1] = this.parentTabPane.localLinearUnits.convertTo(dArray3[1]);
        dArray3[2] = this.parentTabPane.localLinearUnits.convertTo(dArray3[2]);
        dArray4[0] = this.parentTabPane.localLinearUnits.convertTo(dArray4[0]);
        dArray4[1] = this.parentTabPane.localAngularUnits.convertTo(dArray4[1]);
        dArray4[2] = this.parentTabPane.localAngularUnits.convertTo(dArray4[2]);
        dArray5[0] = this.parentTabPane.localLinearUnits.convertTo(dArray5[0]);
        dArray5[1] = this.parentTabPane.localAngularUnits.convertTo(dArray5[1]);
        dArray5[2] = this.parentTabPane.localAngularUnits.convertTo(dArray5[2]);
        double d = dArray2[0] - dArray3[0];
        double d2 = dArray2[1] - dArray3[1];
        double d3 = dArray2[2] - dArray3[2];
        d = this.parentTabPane.localLinearUnits.convertFrom(d);
        String string4 = this.parentTabPane.localLinearUnits.convertToDisplayStr(d);
        d2 = this.parentTabPane.localLinearUnits.convertFrom(d2);
        String string5 = this.parentTabPane.localLinearUnits.convertToDisplayStr(d2);
        d3 = this.parentTabPane.localLinearUnits.convertFrom(d3);
        String string6 = this.parentTabPane.localLinearUnits.convertToDisplayStr(d3);
        double d4 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        String string7 = this.parentTabPane.localLinearUnits.convertToDisplayStr(d4);
        this.ctrlTotal.setText(string7);
        double d5 = dArray4[0] - dArray5[0];
        double d6 = dArray4[1] - dArray5[1];
        double d7 = dArray4[2] - dArray5[2];
        d5 = this.parentTabPane.localLinearUnits.convertFrom(d5);
        String string8 = this.parentTabPane.localLinearUnits.convertToDisplayStr(d5);
        d6 = this.parentTabPane.localAngularUnits.convertFrom(d6);
        String string9 = this.parentTabPane.localAngularUnits.convertToDisplayStr(d6);
        d7 = this.parentTabPane.localAngularUnits.convertFrom(d7);
        String string10 = this.parentTabPane.localAngularUnits.convertToDisplayStr(d7);
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append(string).append(" ").append(string2).append(" ").append(string3).append(this.dataTokenizer);
        stringBuffer.append(XTime.getDate(dArray[6])).append(this.dataTokenizer);
        stringBuffer.append(XTime.getTime(dArray[6])).append(this.dataTokenizer);
        stringBuffer.append(string4).append(this.dataTokenizer);
        stringBuffer.append(string5).append(this.dataTokenizer);
        stringBuffer.append(string6).append(this.dataTokenizer);
        stringBuffer.append(string7).append(this.dataTokenizer);
        stringBuffer.append(string8).append(this.dataTokenizer);
        stringBuffer.append(string9).append(this.dataTokenizer);
        stringBuffer.append(string10);
        this.updateResults(stringBuffer.toString());
    }

    void ctrlStartStop_actionPerformed(ActionEvent actionEvent) {
        this.ctrlStartStop.setEnabled(false);
        this.ctrlClear.setEnabled(false);
        this.ctrlSave.setEnabled(false);
        this.ctrlSaveAs.setEnabled(false);
        this.enableTestModeButtons();
        Object[] objectArray = new Object[]{new Integer(11), new Integer(this.testMode)};
        if (this.startStopTestListener == null) {
            this.startStopTestListener = new StartStopTestCompleteListener();
        }
        this.parentTabPane.doThreadTransaction(objectArray, "", this.startStopTestListener);
    }

    private void enableTestModeButtons(boolean bl) {
        if (this.parentTabPane.admCapable) {
            this.ctrlIFMMode.setEnabled(bl);
            this.ctrlADMMode.setEnabled(bl);
        } else {
            this.ctrlIFMMode.setEnabled(false);
            this.ctrlADMMode.setEnabled(false);
        }
    }

    private void enableTestModeButtons() {
        if (!this.parentTabPane.admCapable) {
            return;
        }
        switch (this.testMode) {
            case 0: {
                this.ctrlIFMMode.setEnabled(true);
                this.ctrlADMMode.setEnabled(false);
                break;
            }
            case 1: {
                this.ctrlIFMMode.setEnabled(false);
                this.ctrlADMMode.setEnabled(true);
            }
        }
    }

    void onIFMModeSelected(ActionEvent actionEvent) {
        this.testMode = 0;
        this.ctrlIFMMode.setBackground(Color.white);
        this.ctrlADMMode.setBackground(Color.gray);
    }

    void onADMModeSelected(ActionEvent actionEvent) {
        this.testMode = 1;
        this.ctrlADMMode.setBackground(Color.white);
        this.ctrlIFMMode.setBackground(Color.gray);
    }

    public void enableControls(boolean bl) {
        this.ctrlStartStop.setEnabled(bl);
        this.ctrlHome.setEnabled(bl);
    }

    public void enableAllControls(boolean bl) {
        this.enableControls(bl);
    }

    protected void handleBeamBreak() {
        if (this.homeCmdInProgress) {
            P.rintln("Ignoring the beam break msg");
            return;
        }
        this.stopFactoryBkndMeasurement();
        if (!this.beamBroken) {
            XTool.displayErrorToUser(this, "Diagnostics", this.res.getString("Beam_broke_err_before_test_started"));
            this.beamBroken = true;
        }
        this.enableAllControls(false);
        this.enableTestModeButtons(false);
        this.ctrlHome.setEnabled(true);
    }

    String getFileFilters() {
        String string = this.res.getString("Text_files");
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(",".concat(String.valueOf(String.valueOf(this.res.getString("_txt")))))));
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(";".concat(String.valueOf(String.valueOf(this.res.getString("CSV_files")))))));
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(",".concat(String.valueOf(String.valueOf(this.res.getString("_csv")))))));
        return string;
    }

    String getDataToSaveToFile() {
        String string = this.resultsFileName.endsWith(this.res.getString("_csv")) ? this.resultsPanel.getTableData(",") : this.resultsPanel.getTableData();
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(this.res.getString("Backsight_results"));
        stringBuffer.append(" ").append(XTime.getTime()).append(" ( ");
        stringBuffer.append(XTime.getDate()).append(" ) ");
        stringBuffer.append(this.newLineString).append(this.newLineString);
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    void updateDisplay(MeasureData measureData) {
        int n = 0;
        Object[] objectArray = measureData.getData();
        this.measurementTime = measureData.time();
        int n2 = -1;
        int n3 = -1;
        this.azimuthAngle = Math.IEEEremainder((Double)objectArray[n++], 1296000.0);
        this.azimuthAngle = Math.toRadians(this.azimuthAngle / 3600.0);
        n2 = (Integer)objectArray[n++];
        this.zenithAngle = Math.IEEEremainder((Double)objectArray[n++], 1296000.0);
        this.zenithAngle = Math.toRadians(this.zenithAngle / 3600.0);
        n3 = (Integer)objectArray[n++];
        this.radialDistance = (Double)objectArray[n++] / (double)1000000;
        this.distanceStatus = (Integer)objectArray[n++];
        int n4 = n2 | n3 | this.distanceStatus;
        this.overallStatus = (n4 & 2) != 0 ? 2 : ((n4 & 4) != 0 ? 1 : 0);
        this.displayTargetPosition();
    }

    private void displayTargetPosition() {
        double[] dArray = new double[]{this.radialDistance, this.azimuthAngle, this.zenithAngle};
        this.ctrlInter.setText(this.parentTabPane.localLinearUnits.convertToDisplayStr(dArray[0]));
        this.ctrlAz.setText(this.parentTabPane.localAngularUnits.convertToDisplayStr(dArray[1]));
        this.ctrlZe.setText(this.parentTabPane.localAngularUnits.convertToDisplayStr(dArray[2]));
        if (!this.fontCalculatedOnce) {
            this.onComponentResized(null);
            this.fontCalculatedOnce = true;
        }
        if (this.overallStatus == 0) {
            this.ctrlAz.setForeground(Color.white);
            this.ctrlZe.setForeground(Color.white);
            this.ctrlInter.setForeground(Color.white);
        } else {
            this.ctrlAz.setForeground(Color.red);
            this.ctrlZe.setForeground(Color.red);
            this.ctrlInter.setForeground(Color.red);
            if (this.ctrlStartStop.isEnabled()) {
                this.handleBeamBreak();
            }
        }
    }

    static {
        IFM_MODE = 0;
        ADM_MODE = 1;
    }

    private class StartStopTestCompleteListener
    implements ThreadListener,
    Runnable {
        private Object[] data;

        private StartStopTestCompleteListener() {
        }

        public void commandComplete() {
            this.data = DiagnosticsBacksightsPane.this.diagnosticsThread.peekResponse();
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            if (this.data[0] == null && this.data[2] != null) {
                DiagnosticsBacksightsPane.this.SetDeviationResults((double[])this.data[2]);
            }
            DiagnosticsBacksightsPane.this.ctrlStartStop.setEnabled(true);
            DiagnosticsBacksightsPane.this.enableTestModeButtons(true);
            if (DiagnosticsBacksightsPane.this.resultsPanel.isDataAvailable()) {
                DiagnosticsBacksightsPane.this.ctrlClear.setEnabled(true);
                DiagnosticsBacksightsPane.this.ctrlSave.setEnabled(true);
                DiagnosticsBacksightsPane.this.ctrlSaveAs.setEnabled(true);
            }
        }
    }
}

