/*
 * Decompiled with CFR 0.152.
 */
package logfileextractor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.image.ImageProducer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import logfileextractor.LogFileExtractorDlg_closeButton_actionAdapter;
import logfileextractor.LogFileExtractorDlg_extractButton_actionAdapter;
import logfileextractor.LogFileExtractorDlg_this_windowAdapter;
import logfileextractor.LogFileExtractorVersionInfo;
import logfileextractor.SafeResourceBundle;

public class LogFileExtractorDlg
extends JDialog {
    JPanel mainPanel = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JPanel extractPanel = new JPanel();
    JPanel commandButtonPanel = new JPanel();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    GridBagLayout gridBagLayout4 = new GridBagLayout();
    JButton extractButton = new JButton();
    JButton closeButton = new JButton();
    JButton cancelButton = new JButton();
    Component component1 = Box.createHorizontalStrut(8);
    String zipLogFileName = "LogFiles.FARO";
    static SafeResourceBundle res = SafeResourceBundle.getBundle("logfileextractor.LogFileExtractorRes", Locale.getDefault());
    JLabel versionLabel = new JLabel();

    public LogFileExtractorDlg(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        try {
            this.setDefaultCloseOperation(2);
            this.jbInit();
            this.pack();
            this.setLocationRelativeTo(owner);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public LogFileExtractorDlg() {
        this(new Frame(), "LogFileExtractorDlg", false);
    }

    private void jbInit() throws Exception {
        URL url = this.getClass().getResource("/logfileextractor/appsicon.gif");
        if (url != null) {
            this.setIconImage(this.createImage((ImageProducer)url.getContent()));
        }
        this.component1 = Box.createHorizontalStrut(8);
        this.mainPanel.setLayout(this.gridBagLayout1);
        this.getContentPane().setLayout(this.gridBagLayout2);
        this.extractPanel.setLayout(this.gridBagLayout3);
        this.commandButtonPanel.setLayout(this.gridBagLayout4);
        this.extractButton.setText(res.getString("Extract") + "...");
        this.extractButton.addActionListener(new LogFileExtractorDlg_extractButton_actionAdapter(this));
        this.closeButton.setText(res.getString("Close"));
        this.closeButton.addActionListener(new LogFileExtractorDlg_closeButton_actionAdapter(this));
        this.extractPanel.setBorder(BorderFactory.createEtchedBorder());
        this.addWindowListener(new LogFileExtractorDlg_this_windowAdapter(this));
        this.mainPanel.setPreferredSize(new Dimension(150, 100));
        this.versionLabel.setText("");
        this.mainPanel.add((Component)this.commandButtonPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(17, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.mainPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(12, 12, 12, 12), 0, 0));
        this.mainPanel.add((Component)this.extractPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.extractPanel.add((Component)this.extractButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.commandButtonPanel.add((Component)this.versionLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.commandButtonPanel.add(this.component1, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.commandButtonPanel.add((Component)this.closeButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.versionLabel.setText(LogFileExtractorVersionInfo.getVersionInfo());
    }

    public void extractButton_actionPerformed(ActionEvent e) {
        File startupLogFile;
        String fSep = System.getProperty("file.separator");
        JFileChooser fileChooser = new JFileChooser(new File("."));
        fileChooser.setFileSelectionMode(1);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setDialogType(1);
        if (fileChooser.showSaveDialog(this) == 1) {
            return;
        }
        String filePath = fileChooser.getSelectedFile().toString();
        File tempZipFile = new File(filePath + "\\" + this.zipLogFileName);
        if (tempZipFile.exists()) {
            MessageFormat form = new MessageFormat(res.getString("Overwrite_Files_Template"));
            Object[] testArgs = new Object[]{this.zipLogFileName};
            int selection = JOptionPane.showConfirmDialog(this, form.format(testArgs), res.getString("Error"), 0, 3);
            if (selection == 1) {
                return;
            }
        }
        String logFilePath = System.getenv("ALLUSERSPROFILE") + "\\FARO Laser";
        ArrayList<String> list = new ArrayList<String>(2);
        File compITLogFile = new File(LogFileExtractorDlg.getLogFileEnvPath("CompIT") + "\\CompitLog.txt");
        if (compITLogFile.exists()) {
            list.add(compITLogFile.getAbsolutePath());
        }
        if ((startupLogFile = new File(LogFileExtractorDlg.getLogFileEnvPath("StartupChecks") + "\\StartupChecksLog.txt")).exists()) {
            list.add(startupLogFile.getAbsolutePath());
        }
        if (list.size() == 0) {
            JOptionPane.showMessageDialog(this, res.getString("Could_Not_Find_Log_Files"), res.getString("Error"), 0);
            return;
        }
        boolean zipped = this.zipFiles(list.toArray(), filePath);
        if (zipped) {
            MessageFormat form = new MessageFormat(res.getString("Saved_Log_Files_Template"));
            Object[] testArgs = new Object[]{this.zipLogFileName, filePath};
            JOptionPane.showMessageDialog(this, form.format(testArgs), res.getString(res.getString("Saved")), 1);
        } else {
            MessageFormat form = new MessageFormat(res.getString("Failed_To_Save_Template"));
            Object[] testArgs = new Object[]{this.zipLogFileName};
            JOptionPane.showMessageDialog(this, form.format(testArgs), res.getString("Error"), 0);
        }
        System.exit(0);
    }

    private boolean zipFiles(Object[] files, String filePath) {
        int BUFFER = 2048;
        try {
            BufferedInputStream origin = null;
            FileOutputStream dest = new FileOutputStream(filePath + "\\" + this.zipLogFileName);
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));
            byte[] data = new byte[2048];
            for (int i = 0; i < files.length; ++i) {
                int count;
                String file = (String)files[i];
                System.out.println("Adding: " + files[i]);
                FileInputStream fi = new FileInputStream(file);
                origin = new BufferedInputStream(fi, 2048);
                File f = new File(file);
                ZipEntry entry = new ZipEntry(f.getName());
                out.putNextEntry(entry);
                while ((count = origin.read(data, 0, 2048)) != -1) {
                    out.write(data, 0, count);
                }
                origin.close();
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException ex) {
        }
        catch (IllegalAccessException ex) {
        }
        catch (InstantiationException ex) {
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        LogFileExtractorDlg dlg = new LogFileExtractorDlg(new Frame(), "LogFileExtractor", true);
        dlg.setVisible(true);
    }

    public void closeButton_actionPerformed(ActionEvent e) {
        this.dispose();
        System.exit(0);
    }

    public void this_windowClosing(WindowEvent e) {
        this.dispose();
        System.exit(0);
    }

    public static String getLogFileEnvPath(String appName) {
        String allUsersFolderName;
        String logFilePath = "";
        String appDataFolderName = System.getenv("APPDATA");
        logFilePath = allUsersFolderName = System.getenv("ALLUSERSPROFILE");
        String osName = System.getProperty("os.name");
        if (osName.equals("Windows XP")) {
            String appData = appDataFolderName.substring(appDataFolderName.lastIndexOf("\\"), appDataFolderName.length());
            logFilePath = logFilePath + appData;
        }
        logFilePath = logFilePath + "\\FARO Laser\\" + appName;
        return logFilePath;
    }
}

