/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.AppsKeystoneSim.SimulatorAPI;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.LinkedList;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.Constants;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.Nest;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.SimuData;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.Target;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.TrackerDialog;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.TrackerSimInterface;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.Trackers;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.mainPanel;

public class TrackerPanel
extends mainPanel
implements ListSelectionListener,
ActionListener {
    private LinkedList trackerList;
    private LinkedList nestList;
    private LinkedList targetList;
    private Trackers tracker;
    private SimuData simuData;
    private JButton[] button;
    private JFrame parent;
    private DefaultListModel model;
    private JList nameList;
    private int index;
    private int coordinate;
    private TrackerSimInterface trkKeystoneSim;
    private NumberFormat form = NumberFormat.getNumberInstance();

    public TrackerPanel(JFrame jFrame, TrackerSimInterface trackerSimInterface) {
        this.setLayout(new BorderLayout());
        this.parent = jFrame;
        this.trkKeystoneSim = trackerSimInterface;
        this.index = 0;
        this.simuData = new SimuData();
        this.trackerList = new LinkedList();
        this.nestList = new LinkedList();
        this.targetList = new LinkedList();
        this.button = new JButton[5];
        this.model = new DefaultListModel();
        this.addList();
        this.addButton();
        this.form.setMaximumFractionDigits(8);
    }

    public void setSimuData(SimuData simuData) {
        this.simuData = simuData;
        this.trackerList = this.simuData.getTrackerList();
        this.nestList = this.simuData.getNestList();
        this.targetList = this.simuData.getTargetList();
        this.tracker = this.simuData.getTracker();
        this.coordinate = this.simuData.getCoord();
        this.prepareList();
        if (this.trackerList.size() != 0) {
            Trackers trackers = (Trackers)this.trackerList.getFirst();
            String string = this.form.format(trackers.getPosition()[0]);
            String string2 = this.form.format(trackers.getPosition()[1]);
            String string3 = this.form.format(trackers.getPosition()[2]);
            String string4 = this.form.format(trackers.getRotation()[0]);
            String string5 = this.form.format(trackers.getRotation()[1]);
            String string6 = this.form.format(trackers.getRotation()[2]);
            String string7 = "X = " + string + "  Y = " + string2 + "  Z = " + string3 + "  RX = " + string4 + "  RY = " + string5 + "  RZ = " + string6;
            this.nameList.setToolTipText(string7);
        }
    }

    public SimuData getSimuData() {
        this.simuData.setTrackerList(this.trackerList);
        this.simuData.setTargetList(this.targetList);
        this.simuData.setNestList(this.nestList);
        return this.simuData;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        JList jList = null;
        if (listSelectionEvent.getValueIsAdjusting()) {
            jList = (JList)listSelectionEvent.getSource();
            this.index = jList.getSelectedIndex();
        }
        if (this.trackerList.size() == 0) {
            this.nameList.setToolTipText("There is no tracker in the list");
            return;
        }
        Trackers trackers = (Trackers)this.trackerList.get(this.index);
        this.simuData.setTracker(trackers);
        String string = this.form.format(trackers.getPosition()[0]);
        String string2 = this.form.format(trackers.getPosition()[1]);
        String string3 = this.form.format(trackers.getPosition()[2]);
        String string4 = this.form.format(trackers.getRotation()[0]);
        String string5 = this.form.format(trackers.getRotation()[1]);
        String string6 = this.form.format(trackers.getRotation()[2]);
        String string7 = "X = " + string + "  Y = " + string2 + "  Z = " + string3 + "  RX = " + string4 + "  RY = " + string5 + "  RZ = " + string6;
        this.nameList.setToolTipText(string7);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        if (jButton == this.button[4]) {
            if (this.trackerList.size() == 0) {
                JOptionPane.showConfirmDialog(this, "There is no more tracker to delete.", "Error", 2, 0);
                return;
            }
            if (this.OnDelete()) {
                this.setModifiedFlag(true);
            }
            if (this.trackerList.size() == 0) {
                this.nameList.setToolTipText("There is no tracker in the list");
            }
        } else {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            for (int i = 0; i < 4; ++i) {
                if (jButton != this.button[i]) continue;
                object4 = new TrackerDialog(this.parent, this.trackerList, this.nestList, this.index, Constants.TRACKER_DIALOG_TITLE[i], i, this.coordinate, this.simuData);
                this.trackerList = ((TrackerDialog)object4).showDialog();
                this.nestList = ((TrackerDialog)object4).getNestList();
                if (!((TrackerDialog)object4).isOKClicked()) continue;
                if (jButton == this.button[0]) {
                    this.model.addElement(((Trackers)this.trackerList.getLast()).getInfoForTrackerList());
                } else {
                    this.model.set(this.index, ((Trackers)this.trackerList.get(this.index)).getInfoForTrackerList());
                }
                this.setModifiedFlag(true);
                object3 = (Trackers)this.trackerList.get(this.index);
                for (int j = 0; j < this.nestList.size(); ++j) {
                    object2 = (Nest)this.nestList.get(j);
                    if (!((Nest)object2).getNestName().startsWith("TMR_")) continue;
                    object = Constants.TMR_LOCATION;
                    object = this.simuData.coordTransfer((double[])object, ((Trackers)object3).getPosition(), ((Trackers)object3).getRotation());
                    if (this.coordinate == 0) {
                        object = this.simuData.sphere_to_cart((double)object[0], (double)object[1], (double)object[2]);
                    }
                    ((Nest)object2).setAbsPosition((double[])object);
                }
                this.trkKeystoneSim.setSimTrkPosition(((Trackers)object3).getPosition(), ((Trackers)object3).getRotation());
                this.trkKeystoneSim.setSimNestList(this.nestList);
                this.trkKeystoneSim.updateSimPosition();
            }
            Trackers trackers = (Trackers)this.trackerList.get(this.index);
            object3 = this.form.format(trackers.getPosition()[0]);
            String string = this.form.format(trackers.getPosition()[1]);
            object2 = this.form.format(trackers.getPosition()[2]);
            object = this.form.format(trackers.getRotation()[0]);
            String string2 = this.form.format(trackers.getRotation()[1]);
            String string3 = this.form.format(trackers.getRotation()[2]);
            object4 = "X = " + (String)object3 + "  Y = " + string + "  Z = " + (String)object2 + "  RX = " + (String)object + "  RY = " + string2 + "  RZ = " + string3;
            this.nameList.setToolTipText((String)object4);
        }
    }

    public boolean OnDelete() {
        int n = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete this tracker?", "Delete confirmation", 2, 2);
        if (n == 0) {
            Trackers trackers = (Trackers)this.trackerList.get(this.index);
            if (trackers.getClassmate() != null) {
                Cloneable cloneable;
                int n2;
                for (n2 = 0; n2 < this.targetList.size(); ++n2) {
                    cloneable = (Target)this.targetList.get(n2);
                    if (!((Target)cloneable).getTargetName().equals(trackers.getClassmate())) continue;
                    this.targetList.remove(n2);
                    --n2;
                }
                for (n2 = 0; n2 < this.nestList.size(); ++n2) {
                    cloneable = (Nest)this.nestList.get(n2);
                    if (!((Nest)cloneable).getNestName().startsWith("TMR_") || !((Nest)cloneable).getNestName().substring(4, ((Nest)cloneable).getNestName().length()).equals(trackers.getName())) continue;
                    this.nestList.remove(n2);
                }
            }
            this.model.remove(this.index);
            this.trackerList.remove(this.index);
            if (this.index > this.trackerList.size() - 1) {
                --this.index;
            }
            this.nameList.setSelectedIndex(this.index);
            return true;
        }
        return false;
    }

    public void prepareList() {
        this.model.clear();
        for (int i = 0; i < this.trackerList.size(); ++i) {
            Trackers trackers = (Trackers)this.trackerList.get(i);
            this.model.addElement(trackers.getInfoForTrackerList());
        }
    }

    private void addList() {
        this.prepareList();
        this.nameList = new JList(this.model);
        this.nameList.setSelectionMode(0);
        this.nameList.setSelectedIndex(this.index);
        this.nameList.addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.nameList);
        this.add((Component)jScrollPane, "North");
    }

    private void addButton() {
        Box box = Box.createHorizontalBox();
        for (int i = 0; i < 5; ++i) {
            this.button[i] = new JButton(Constants.TRACKERBUTTON[i]);
            this.button[i].addActionListener(this);
            box.add(Box.createHorizontalStrut(4));
            box.add(this.button[i]);
            box.add(Box.createHorizontalStrut(2));
        }
        this.add((Component)box, "South");
    }
}

