/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.AppsKeystoneSim.SimulatorAPI;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.LinkedList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.Constants;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.Nest;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.SimuData;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.Target;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.TargetDialog;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.TrackerSimInterface;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.Trackers;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.mainPanel;

public class TargetPanel
extends mainPanel
implements ListSelectionListener,
ActionListener {
    private SimuData simuData;
    private LinkedList trackerList;
    private LinkedList nestList;
    private LinkedList targetList;
    private Trackers tracker;
    private JButton[] button;
    private JFrame parent;
    private DefaultListModel model;
    private JList nameList;
    private int index;
    private int coordinate;
    private TrackerSimInterface trkKeystoneSim;
    private NumberFormat form = NumberFormat.getNumberInstance();

    public TargetPanel(JFrame jFrame, TrackerSimInterface trackerSimInterface) {
        this.setLayout(new BorderLayout());
        this.parent = jFrame;
        this.trkKeystoneSim = trackerSimInterface;
        this.index = 0;
        this.simuData = new SimuData();
        this.trackerList = new LinkedList();
        this.nestList = new LinkedList();
        this.targetList = new LinkedList();
        this.button = new JButton[4];
        this.model = new DefaultListModel();
        this.addList();
        this.addButton();
        this.form.setMaximumFractionDigits(8);
    }

    public void setSimuData(SimuData simuData) {
        this.simuData = simuData;
        this.trackerList = this.simuData.getTrackerList();
        this.nestList = this.simuData.getNestList();
        this.targetList = this.simuData.getTargetList();
        this.coordinate = this.simuData.getCoord();
        this.tracker = this.simuData.getTracker();
        this.prepareList();
        if (this.targetList.size() != 0) {
            Target target = (Target)this.targetList.getFirst();
            if (target.getClassmate().equals("")) {
                this.nameList.setToolTipText("This target is not in any nest");
            }
            for (int i = 0; i < this.nestList.size(); ++i) {
                Nest nest = (Nest)this.nestList.get(i);
                if (!target.getClassmate().equals(nest.getNestName())) continue;
                String string = this.form.format(nest.getPosition()[0]);
                String string2 = this.form.format(nest.getPosition()[1]);
                String string3 = this.form.format(nest.getPosition()[2]);
                String string4 = this.coordinate == 0 ? "X = " + string + "  Y = " + string2 + "  Z = " + string3 : "Az = " + string + "  Ze = " + string2 + "  D = " + string3;
                this.nameList.setToolTipText(string4);
                break;
            }
        }
    }

    public SimuData getSimuData() {
        for (int i = 0; i < this.nestList.size(); ++i) {
            Nest nest = (Nest)this.nestList.get(i);
            if (!nest.getNestName().startsWith("TMR_") || this.tracker.getClassmate().equals(nest.getClassmateName())) continue;
            for (int j = 0; j < this.trackerList.size(); ++j) {
                Trackers trackers = (Trackers)this.trackerList.get(j);
                if (!this.tracker.getName().equals(trackers.getName())) continue;
                trackers.setClassmate(nest.getClassmateName());
            }
        }
        this.simuData.setTrackerList(this.trackerList);
        this.simuData.setTargetList(this.targetList);
        this.simuData.setNestList(this.nestList);
        return this.simuData;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        JList jList = null;
        if (listSelectionEvent.getValueIsAdjusting()) {
            jList = (JList)listSelectionEvent.getSource();
            this.index = jList.getSelectedIndex();
        }
        if (this.targetList.size() == 0) {
            this.nameList.setToolTipText("There is no target in the list.");
            return;
        }
        Target target = (Target)this.targetList.get(this.index);
        for (int i = 0; i < this.nestList.size(); ++i) {
            Nest nest = (Nest)this.nestList.get(i);
            if (target.getClassmate().equals(nest.getNestName())) {
                String string = this.form.format(nest.getPosition()[0]);
                String string2 = this.form.format(nest.getPosition()[1]);
                String string3 = this.form.format(nest.getPosition()[2]);
                String string4 = this.coordinate == 0 ? "X = " + string + "  Y = " + string2 + "  Z = " + string3 : "Az = " + string + "  Ze = " + string2 + "  D = " + string3;
                this.nameList.setToolTipText(string4);
                break;
            }
            this.nameList.setToolTipText("This target is not in any nest.");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block16: {
            JButton jButton;
            block15: {
                jButton = (JButton)actionEvent.getSource();
                if (jButton != this.button[2]) break block15;
                if (this.targetList.size() == 0) {
                    JOptionPane.showConfirmDialog(this, "There is no target to delete.", "Error", 2, 0);
                    return;
                }
                if (this.OnDelete()) {
                    this.setModifiedFlag(true);
                }
                if (this.targetList.size() != 0) break block16;
                this.nameList.setToolTipText("There is no target in the list.");
                break block16;
            }
            if (jButton == this.button[3]) {
                Target target = (Target)this.targetList.get(this.index);
                if (target.getTargetStatus().equals("Blocked")) {
                    target.setTargetStatus("");
                    this.trkKeystoneSim.setSimTargetBlocked(false, target);
                } else {
                    target.setTargetStatus("Blocked");
                    this.trkKeystoneSim.setSimTargetBlocked(true, target);
                }
                this.model.set(this.index, ((Target)this.targetList.get(this.index)).getInfoForTargetList());
                this.setModifiedFlag(true);
            } else {
                Object object;
                Cloneable cloneable;
                for (int i = 0; i < 2; ++i) {
                    if (jButton != this.button[i]) continue;
                    if (i == 1 && this.targetList.size() == 0) {
                        JOptionPane.showConfirmDialog(this, "There is no target to move", "Error", 2, 0);
                        return;
                    }
                    TargetDialog targetDialog = new TargetDialog(this.parent, this.targetList, this.nestList, this.trackerList, this.index, Constants.TARGET_DIALOG_TITLE[i], i, this.coordinate, this.simuData);
                    this.targetList = targetDialog.showDialog();
                    this.nestList = targetDialog.getNewNest();
                    this.trackerList = targetDialog.getTrackerList();
                    if (targetDialog.isOkClicked()) {
                        if (jButton == this.button[0]) {
                            this.model.addElement(((Target)this.targetList.getLast()).getInfoForTargetList());
                        } else {
                            this.model.set(this.index, ((Target)this.targetList.get(this.index)).getInfoForTargetList());
                        }
                        this.setModifiedFlag(true);
                    }
                    if (targetDialog.isNewClicked()) {
                        this.nestList = targetDialog.getNewNest();
                        this.setModifiedFlag(true);
                    }
                    if (!targetDialog.isOkClicked() && !targetDialog.isNewClicked()) continue;
                    this.trkKeystoneSim.setSimNestList(this.nestList);
                    this.trkKeystoneSim.setSimTargetList(this.targetList);
                    this.trkKeystoneSim.setSimTrackerList(this.trackerList);
                    cloneable = (Target)this.targetList.get(this.index);
                    object = (Nest)this.nestList.getFirst();
                    for (int j = 0; j < this.nestList.size() && !((Target)cloneable).getClassmate().equals(((Nest)object).getNestName()); ++j) {
                        object = (Nest)this.nestList.get(j);
                    }
                    this.trkKeystoneSim.setSimPosition(this.coordinate, (Nest)object);
                }
                if (this.targetList.size() == 0) {
                    return;
                }
                Target target = (Target)this.targetList.get(this.index);
                for (int i = 0; i < this.nestList.size(); ++i) {
                    cloneable = (Nest)this.nestList.get(i);
                    if (!target.getClassmate().equals(((Nest)cloneable).getNestName())) continue;
                    String string = this.form.format(((Nest)cloneable).getPosition()[0]);
                    String string2 = this.form.format(((Nest)cloneable).getPosition()[1]);
                    String string3 = this.form.format(((Nest)cloneable).getPosition()[2]);
                    object = this.coordinate == 0 ? "X = " + string + "  Y = " + string2 + "  Z = " + string3 : "Az = " + string + "  Ze = " + string2 + "  D = " + string3;
                    this.nameList.setToolTipText((String)object);
                    break;
                }
            }
        }
    }

    public boolean OnDelete() {
        int n = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete this target?", "Delete confirmation", 2, 2);
        if (n == 0) {
            Cloneable cloneable;
            int n2;
            Target target = (Target)this.targetList.get(this.index);
            for (n2 = 0; n2 < this.trackerList.size(); ++n2) {
                cloneable = (Trackers)this.trackerList.get(n2);
                if (!target.getClassmate().equals("TMR_" + ((Trackers)cloneable).getName())) continue;
                ((Trackers)cloneable).setClassmate("");
            }
            for (n2 = 0; n2 < this.nestList.size(); ++n2) {
                cloneable = (Nest)this.nestList.get(n2);
                if (!((Nest)cloneable).getClassmateName().equals(target.getTargetName())) continue;
                ((Nest)cloneable).setClassmateName("");
            }
            this.trkKeystoneSim.deleteSimTarget(target);
            this.model.remove(this.index);
            this.targetList.remove(this.index);
            this.trkKeystoneSim.setSimTargetList(this.targetList);
            if (this.index > this.targetList.size() - 1 && this.targetList.size() != 0) {
                --this.index;
            }
            this.nameList.setSelectedIndex(this.index);
            this.trkKeystoneSim.setSimNestList(this.nestList);
            return true;
        }
        return false;
    }

    private void prepareList() {
        this.model.clear();
        for (int i = 0; i < this.targetList.size(); ++i) {
            Target target = (Target)this.targetList.get(i);
            this.model.addElement(target.getInfoForTargetList());
        }
    }

    private void addList() {
        this.prepareList();
        this.nameList = new JList(this.model);
        this.nameList.setSelectionMode(0);
        this.nameList.setSelectedIndex(this.index);
        this.nameList.addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.nameList);
        this.add((Component)jScrollPane, "North");
    }

    private void addButton() {
        JPanel jPanel = new JPanel();
        for (int i = 0; i < 4; ++i) {
            this.button[i] = new JButton(Constants.TARGETBUTTON[i]);
            this.button[i].addActionListener(this);
            jPanel.add(this.button[i]);
        }
        this.add((Component)jPanel, "South");
    }
}

