/*
 * Decompiled with CFR 0.152.
 */
package smx.tracker.AppsKeystoneSim.SimulatorAPI;

import java.util.LinkedList;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.MaterialTemp;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.Nest;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.Noise;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.Target;
import smx.tracker.AppsKeystoneSim.SimulatorAPI.Trackers;

public class SimuData {
    private LinkedList trackerList = new LinkedList();
    private LinkedList nestList = new LinkedList();
    private LinkedList targetList = new LinkedList();
    private MaterialTemp materialTemp = new MaterialTemp();
    private Noise noise = new Noise();
    private int coordinate = 0;
    private Trackers tracker = new Trackers();

    public LinkedList getTrackerList() {
        LinkedList<Trackers> linkedList = new LinkedList<Trackers>();
        Trackers trackers = new Trackers();
        Trackers trackers2 = new Trackers();
        for (int i = 0; i < this.trackerList.size(); ++i) {
            trackers = (Trackers)this.trackerList.get(i);
            trackers2 = (Trackers)trackers.clone();
            linkedList.add(i, trackers2);
        }
        return linkedList;
    }

    public LinkedList getNestList() {
        LinkedList<Nest> linkedList = new LinkedList<Nest>();
        Nest nest = new Nest();
        Nest nest2 = new Nest();
        for (int i = 0; i < this.nestList.size(); ++i) {
            nest = (Nest)this.nestList.get(i);
            nest2 = (Nest)nest.clone();
            linkedList.add(i, nest2);
        }
        return linkedList;
    }

    public LinkedList getTargetList() {
        LinkedList<Target> linkedList = new LinkedList<Target>();
        Target target = new Target();
        Target target2 = new Target();
        for (int i = 0; i < this.targetList.size(); ++i) {
            target = (Target)this.targetList.get(i);
            target2 = (Target)target.clone();
            linkedList.add(i, target2);
        }
        return linkedList;
    }

    public MaterialTemp getMaterialTemp() {
        return (MaterialTemp)this.materialTemp.clone();
    }

    public Noise getNoise() {
        return (Noise)this.noise.clone();
    }

    public int getCoord() {
        return this.coordinate;
    }

    public Trackers getTracker() {
        return (Trackers)this.tracker.clone();
    }

    public void setTrackerList(LinkedList linkedList) {
        this.trackerList = linkedList;
    }

    public void setNestList(LinkedList linkedList) {
        this.nestList = linkedList;
    }

    public void setTargetList(LinkedList linkedList) {
        this.targetList = linkedList;
    }

    public void setMaterialTemp(MaterialTemp materialTemp) {
        this.materialTemp = materialTemp;
    }

    public void setNoise(Noise noise) {
        this.noise = noise;
    }

    public void setCoord(int n) {
        this.coordinate = n;
    }

    public void setTracker(Trackers trackers) {
        this.tracker = trackers;
    }

    public double[] coordTransfer(double[] dArray, double[] dArray2, double[] dArray3) {
        int n;
        double[][] dArray4 = new double[3][3];
        double[][] dArray5 = new double[3][3];
        double[][] dArray6 = new double[3][3];
        double[] dArray7 = new double[3];
        double[] dArray8 = new double[]{dArray[2] * Math.sin(dArray[1]) * Math.cos(dArray[0]), dArray[2] * Math.sin(dArray[1]) * Math.sin(dArray[0]), dArray[2] * Math.cos(dArray[1])};
        for (n = 0; n < 3; ++n) {
            dArray7[n] = dArray8[n];
            for (int i = 0; i < 3; ++i) {
                if (n != i) continue;
                dArray4[n][i] = 1.0;
                dArray5[n][i] = 1.0;
                dArray6[n][i] = 1.0;
            }
        }
        dArray4[1][1] = Math.cos(dArray3[0]);
        dArray4[2][2] = Math.cos(dArray3[0]);
        dArray4[1][2] = -Math.sin(dArray3[0]);
        dArray4[2][1] = Math.sin(dArray3[0]);
        dArray5[0][0] = Math.cos(dArray3[1]);
        dArray5[0][2] = Math.sin(dArray3[1]);
        dArray5[2][0] = -Math.sin(dArray3[1]);
        dArray5[2][2] = Math.cos(dArray3[1]);
        dArray6[0][0] = Math.cos(dArray3[2]);
        dArray6[0][1] = Math.sin(dArray3[2]);
        dArray6[1][0] = -Math.sin(dArray3[2]);
        dArray6[1][1] = Math.cos(dArray3[2]);
        dArray7 = this.MatrixTimesVector(dArray6, dArray7);
        dArray7 = this.MatrixTimesVector(dArray5, dArray7);
        dArray7 = this.MatrixTimesVector(dArray4, dArray7);
        for (n = 0; n < 3; ++n) {
            int n2 = n;
            dArray7[n2] = dArray7[n2] + dArray2[n];
        }
        dArray8 = this.cart_to_sphere(dArray7[0], dArray7[1], dArray7[2]);
        return dArray8;
    }

    public double[] MatrixTimesVector(double[][] dArray, double[] dArray2) {
        double[] dArray3 = new double[3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int n = i;
                dArray3[n] = dArray3[n] + dArray[i][j] * dArray2[j];
            }
        }
        return dArray3;
    }

    public double[] sphere_to_cart(double d, double d2, double d3) {
        double[] dArray = new double[]{d3 * Math.sin(d2) * Math.cos(d), d3 * Math.sin(d2) * Math.sin(d), d3 * Math.cos(d2)};
        return dArray;
    }

    public double[] cart_to_sphere(double d, double d2, double d3) {
        double[] dArray = new double[3];
        if (d != 0.0) {
            dArray[0] = Math.atan(d2 / d);
            if (d < 0.0 && d2 >= 0.0 || d > 0.0 && d2 < 0.0) {
                dArray[0] = dArray[0] + Math.PI;
            }
        } else if (d2 == 0.0) {
            if (d3 == 0.0) {
                return null;
            }
            dArray[0] = 0.0;
        } else {
            dArray[0] = 1.5707963267948966;
        }
        if (d2 < 0.0) {
            dArray[0] = dArray[0] + Math.PI;
        }
        dArray[2] = Math.sqrt(Math.pow(d, 2.0) + Math.pow(d2, 2.0) + Math.pow(d3, 2.0));
        dArray[1] = Math.acos(d3 / dArray[2]);
        dArray[0] = Math.IEEEremainder(dArray[0], Math.PI * 2);
        dArray[1] = Math.IEEEremainder(dArray[1], Math.PI * 2);
        return dArray;
    }

    public double[] back_to_front(double d, double d2, double d3) {
        double[] dArray = new double[3];
        d += Math.PI;
        d = Math.IEEEremainder(d, Math.PI * 2);
        d2 = -d2;
        d2 = Math.IEEEremainder(d2, Math.PI * 2);
        dArray[0] = d;
        dArray[1] = d2;
        dArray[2] = d3;
        return dArray;
    }
}

